<?php

include 'config.php';

/**
 * To add new email function:
 *
 * STEP 1 : Add email Subject and Body function to email_template in the respective language file
 * STEP 2 : Add EMAIL_TEMPLATE_ constant below that identifies the function name
 * STEP 3 : Create the email trigger function below
 */


define("EMAIL_TEMPLATE_AGENT_WELCOME","agent_welcome");
define("EMAIL_TEMPLATE_PAYOUT_AMAZON","payout_amazon");

define("EMAIL_TEMPLATE_VERIFY_EMAIL","verify_email");
define("EMAIL_TEMPLATE_REG_AGENT_INVITE","registered_agent_invite");
define("EMAIL_TEMPLATE_UN_REG_AGENT_INVITE","unregistered_agent_invite");
define("EMAIL_TEMPLATE_MANAGER_INVITE","manager_invite");



function email__template($email_addr,$first_name, $lang = "en"){
    $email_var = array();
    $email_var["{{firstname}}"] = $first_name;


    $template_data = getEmailBody(EMAIL_TEMPLATE_AGENT_WELCOME,$email_var, strtolower($lang));

    if ($template_data != null){
        $subject = $template_data["subject"];
        $body = ($template_data["body"]);

        return triggerEmailSMTP($email_addr, $subject, $body, $extra_headers='');

    }

    return false;
}


function email_confirm_account($email_addr,$verify_link, $lang = "en"){
    $email_var = array();
    $email_var["{{verify_link}}"] = $verify_link;

    $template_data = getEmailBody(EMAIL_TEMPLATE_VERIFY_EMAIL,$email_var, strtolower($lang));

    if ($template_data != null){
        $subject = $template_data["subject"];
        $body = ($template_data["body"]);

        return triggerEmailSMTP($email_addr, $subject, $body, $extra_headers='');
    }

    return false;
}
function email_reg_agent_invite($email_addr,$invite_link,$invite_code,$organization,$customized_message, $lang = "en"){
    $email_var = array();
    $email_var["{{invite_link}}"] = $invite_link;
    $email_var["{{invite_code}}"] = $invite_code;
    $email_var["{{organization}}"] = $organization;
    $email_var["{{customized_message}}"] = $customized_message;

    $template_data = getEmailBody(EMAIL_TEMPLATE_REG_AGENT_INVITE,$email_var, strtolower($lang));

    if ($template_data != null){
        $subject = $template_data["subject"];
        $body = ($template_data["body"]);

        return triggerEmailSMTP($email_addr, $subject, $body, $extra_headers='');
    }

    return false;
}
function email_un_reg_agent_invite($email_addr,$invite_code,$organization,$customized_message, $lang = "en"){
    $email_var = array();
    $email_var["{{invite_code}}"] = $invite_code;
    $email_var["{{organization}}"] = $organization;
    $email_var["{{customized_message}}"] = $customized_message;

    $template_data = getEmailBody(EMAIL_TEMPLATE_UN_REG_AGENT_INVITE,$email_var, strtolower($lang));

    if ($template_data != null){
        $subject = $template_data["subject"];
        $body = ($template_data["body"]);

        return triggerEmailSMTP($email_addr, $subject, $body, $extra_headers='');
    }

    return false;
}
function email_manager_invite($email_addr,$invite_link,$organization,$customized_message, $lang = "en"){
    $email_var = array();
    $email_var["{{invite_link}}"] = $invite_link;
    $email_var["{{organization}}"] = $organization;
    $email_var["{{customized_message}}"] = $customized_message;

    $template_data = getEmailBody(EMAIL_TEMPLATE_MANAGER_INVITE,$email_var, strtolower($lang));

    if ($template_data != null){
        $subject = $template_data["subject"];
        $body = ($template_data["body"]);

        return triggerEmailSMTP($email_addr, $subject, $body, $extra_headers='');
    }

    return false;
}