<?php



header("Access-Control-Allow-Origin: *"); //enable resource sharing(allows this resource to be shared with "all[*]" requesting clients
header('Content-Type: application/json');
/**
 * @Author : Kadian Salmon
 * Date : Sep 23, 2021
 * Purpose : process all api request for Queritel Console Application
 * @link : https://api.queritel.com/api/web/queritel/console/v1/api.php
 */


//------------------------------------------
define("QUESTION_SET", 10);//respondents per location
define("RESEARCHER_PER_LOC", 4);//researcher per location

define("MAIN_DB_USERNAME", "initia19_paperweight");
define("MAIN_DB_PASSWORD", "sqnktJrG-J4k");
define("MAIN_DB_NAME", "initia19_paperweight");

define("INSIGHT_DB_USERNAME", "initia19_lime880");
define("INSIGHT_DB_PASSWORD", "[2ST4)V2p6");
define("INSIGHT_DB_NAME", "initia19_lime880");
define("INSIGHT_DOMAIN", "insight.queritel.com");

define("DASHBOARD_DB_NAME", "initia19_ansplex"); //Dashboard
define("DASHBOARD_DB_USERNAME", "initia19_ansplex");
define("DASHBOARD_DB_PASSWORD", "QueritelMgmt2019!");

define("FIGOZO_DB_USERNAME", "initia19_cornersave");
define("FIGOZO_DB_PASSWORD", "cornersave");
define("FIGOZO_DB_NAME", "initia19_cornersave");
define("CATALOG_ITEM_ROOT", "https://source.queritel.com/figozo/uploads/store/product/");
//catalog tables
define("TABLE_CATALOG_CATEGORY", "catalog_category_list");
define("TABLE_CATALOG_UNIT", "catalog_unit_list");
define("TABLE_CATALOG_BRAND", "catalog_brand_list");
define("TABLE_CATALOG", "catalog_item_list");



//API KEY | AND CONSTANTS
define("SERVER_MAP_KEY", "AIzaSyCAbro3HYflhyhj9Z55xCMSZDBLABLABnM");
define("FIREBASE_SERVER_KEY", "AIzaSyD8Xf2XrVxrtq0sngAJrRULYniemVn8MJM");
define("FIREBASE_SENDER_ID", "114414183492");

define("PUSH_NOTIFICATION_TOPIC_NEW_QUEST", "/topics/new_quest");
define("PUSH_NOTIFICATION_TOPIC_BROADCAST", "/topics/new_broadcast");
define("PUSH_NOTIFICATION_TOPIC_MESSAGE", "/topics/new_message");

define("PUSH_NOTIFICATION_STATUS_NEW_QUEST", "new_quest");
define("PUSH_NOTIFICATION_STATUS_BROADCAST", "new_broadcast");
define("PUSH_NOTIFICATION_STATUS_MESSAGE", "new_message");

//API KEY - PAYOUTS
define("DING_MOBILE_RECHARGE_KEY", "ApyJWyuifmb6YMuJhu7wAW");
define("AMAZON_GIFT_INCENTIVE_KEY", "AKIAWWFS6UKLHJAGJY55");
define("STRIPE_PAYMENT_TEST_KEY", "sk_test_51HJPlPJyH9e69bzmLefuJnDLy1tq8GOkDD6NqZ7cx9obJYq6kqza5bx5hJ9tAoEVRxNugBCuIUFJMHVg4fpuoAfh00KxNxU02N");
define("STRIPE_PAYMENT_LIVE_KEY", "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");


define("FTP_HOST_SERVER", "ftp.queritel.com");
define("FTP_Q_HOST_USERNAME", "queritel@source.queritel.com");
define('FTP_Q_HOST_PASS', '^xu]0*FV%*9!quer72');
define('FTP_Q_HOST_DIRECTORY', 'https://source.queritel.com/queritel');
define('FTP_Q_FILE_DIRECTORY', 'https://source.queritel.com/queritel/uploads/file/');




define("PASSWORD_SALT","ewoiruqojfklajreajflajoer");

//status value
define("STATUS_OK","OK");
define("STATUS_ERROR","ERROR");
/*{
    "status": "ERROR",
    "error": {
        "name": "opFailed", //([ERROR NAME CONSTANTS])
        "message": "INV_TKN" | "USR_SPND" | "UNK_ERR" //([ERROR MESSAGE CONSTANTS])
    }
}*/

define("STATUS_SIGNUP_FAILED", "SIGNUP_FAILED");
define("STATUS_LOGIN_FAILED","LOGIN_FAILED");
define("STATUS_ACCOUNT_DEACTIVATED", "ACCOUNT_DEACTIVATED");
define("STATUS_OPERATION_FAILED", "OPERATION_FAILED");
define("STATUS_NO_JOBS", "NO_JOBS");


//ERROR NAME CONSTANTS
define("ERROR_NAME_OP_FAILED","opFailed");

//ERROR MESSAGE CONSTANTS
define("ERROR_MSG_INVALID_CRED","INV_CR"); //("The Credentials provided are invalid")
define("ERROR_MSG_INVALID_LOGIN","INV_LGN");//("The user is not Logged in")
define("ERROR_MSG_INVALID_TOKEN","INV_TKN");//("The Login token is invalid") {re-entering the password is needed}
define("ERROR_MSG_USER_SUSPENDED","USR_SPND");//("The account has been suspended")
define("ERROR_MSG_USER_DEACTIVATED","USR_DEAC");//("The account has been deactivated")
define("ERROR_MSG_USER_UNKNOWN","UNK_ERR");//("An unknown error was encountered")
define("ERROR_MSG_USER_ACC_DUPLICATE","ACC_DUPLICATE");//("The user already exist")
define("ERROR_MSG_INVALID_TAX_ID","INV_TAX_ID");//("The tax id provided when setting up the bank account was invalid")
define("ERROR_MSG_NOT_FOUND","NOT_FOUND");//("The data requested was not found")
define("ERROR_MSG_NOT_VERIFIED","NOT_VERIFIED");//("The user being logged in is not verified")
define("ERROR_MSG_EXPIRED","EXPIRED");//("Token has expired")


//EMAIL ACTION
define("EMAIL_ACTION_PASSWORD_RESET","password_reset");//(" for password reset")
define("EMAIL_ACTION_VERIFY_EMAIL","verify_email");//(" for email verification")
define("EMAIL_ACTION_ACCEPT_INVITE","accept_invite");//(" for accepting invite")



//unique prefix (used to generate unique IDs)
define("UNIQUE_SUB_NETWORK","gr_"); //unique data collection sub network
define("UNIQUE_NETWORK","net_"); //unique data collection network
define("UNIQUE_TEAM","team_"); //unique team
define("UNIQUE_NOTIFICATION","note_"); //unique notification id (one way msg)
define("UNIQUE_MSG","msg_"); //unique message
define("UNIQUE_PAYMENT","pay_");//unique payment instance
define("UNIQUE_TRANSACTION","trans_"); //unique transaction instance
define("UNIQUE_ACCOUNT","acc_");//unique account instance
define("UNIQUE_ACTIVITY","aty_");//unique user activity instance
define("UNIQUE_PENALTY","pty_");//unique cancel quest/other penalty
define("UNIQUE_RELATIONSHIP","rel_");//unique relationship instance
define("UNIQUE_FILE","fid_");//unique file
define("UNIQUE_INVITATION","ivn_");//unique invitation instance
define("UNIQUE_PULSE","pul_");//unique pulse instance
define("UNIQUE_PULSE_QUESTION","que_");//unique pulse instance
define("UNIQUE_PRODUCT_CATEGORY","cid_");//unique product category
define("UNIQUE_PRODUCT_ITEM","pid_");//unique product item
define("UNIQUE_SECTOR","sid_");//unique sector item
define("UNIQUE_TARGET","tid_");//unique target item
//define("UNIQUE_SUBMISSION","sub_");
define("UNIQUE_DEPOSIT","dep_");//unique deposit item
define("UNIQUE_WALLET_ENTRY","tr_");//unique wallet item
define("UNIQUE_INVOICE","inv_");//unique invoice
define("UNIQUE_INVOICE_ITEM","itm_");//unique invoice item
define("UNIQUE_HOLD","hold_");//unique holding entry


//survey state
define("SURVEY_STATE_PROGRESS", 1);
define("SURVEY_STATE_COMPLETED",2);
define("SURVEY_STATE_CANCELLED",3);

//survey instrument state
define("SURVEY_INSTRUMENT_READY", 1);
define("SURVEY_INSTRUMENT_NOT_READY", 0);



//admin verification
define("VERIFIED", 1);
define("UNVERIFIED", 0);


//login state
define("LOGIN_STATE_VALID", 1);
define("LOGIN_STATE_INVALID", 0);

//active state / network relationship state
define("STATE_ACTIVE", 1);
define("STATE_INACTIVE", 0);


//dashboard tables
define("TABLE_LIVE_SURVEY", "dash_live_survey");
define("TABLE_CLIENT_DASHBOARD", "dash_client_dashboard");

//database tables
define("TABLE_USERS", "tbl_users");
define("TABLE_USER_PROFILE", "tbl_user_profile");
define("TABLE_TASKS", "tbl_tasks");
define("TABLE_COUNTRY", "tbl_countries");
define("TABLE_LOGIN", "mobile_login");
define("TABLE_JOBS", "job_instance");
define("TABLE_JOB_TAGS", "job_tag");
define("TABLE_RESPONSE", "survey_response");
define("TABLE_NETWORK", "research_network");
define("TABLE_NETWORK_RELATIONSHIP", "network_relationship");
define("TABLE_SUBMISSIONS", "submission_response");
define("TABLE_MESSAGE", "message");
define("TABLE_PAYOUT_ACCOUNT", "payout_account");
define("TABLE_REALTIME_NOTIFICATION", "realtime_notification");
//not logged
define("TABLE_EMAIL_TOKEN", "app_email_token");
define("TABLE_SUB_NETWORK", "app_sub_network");
define("TABLE_SUB_NETWORK_RELATIONSHIP", "app_sub_net_rel");
define("TABLE_INVITE_CODE", "app_invitation_code");
define("TABLE_INVITE_RESPONSE", "app_invitation_response");
define("TABLE_PRODUCT_CATEGORY", "app_product_category");
define("TABLE_PRODUCT_ITEM", "app_product_item");
define("TABLE_ALL_FILES", "app_all_files");
define("TABLE_QUEST_SECTORS", "app_sectors");
define("TABLE_QUEST_TARGETS", "app_targets");
define("TABLE_TARGET_SEGMENTS", "--");
define("TABLE_CLIENT_WALLET", "app_client_payment");
define("TABLE_CLIENT_DEPOSIT", "app_client_deposit");
define("TABLE_STORE_SAMPLE", "app_store_sample"); //store samples
define("TABLE_STORE_SAMPLE_PACKAGE", "app_store_sample_package"); //the actual stores connected to the sample
define("TABLE_SUBSCRIPTION", "app_subscription"); //used to store all subscription instances
define("TABLE_INVOICE", "app_invoice"); //this is used to store all internal invoice data
define("TABLE_INVOICE_ITEM", "app_invoice_item"); //this is used to store all the invoice items for a specific invoice
define("TABLE_HOLDING", "app_client_holding"); //this is used to store all the funds held for specific purposes
define("TABLE_HOLDING_ITEM", "app_holding_item"); //this is used to store the specific logs related to the holding process




//file relationship
define("FILE_REL_MSG", "rel_msg"); //messages -> message related files
define("FILE_REL_USR", "rel_usr"); //profile -> user related files
define("FILE_REL_QUEST", "rel_quest"); //quest -> files uploaded by clients for quest
define("FILE_REL_SUBMISSION", "rel_sub"); //submission -> files uploaded by agents related to quest (QA or official submission)

//deposit status
define("DEPOSIT_STATUS_INCOMPLETE", "incomplete"); //(default status) handled by the system
define("DEPOSIT_STATUS_FAILED", "failed"); //After the request is made, stripe indicated an operation failure.
define("DEPOSIT_STATUS_CANCELLED", "cancelled"); //After the initiation process, the user cancelled the operation.
define("DEPOSIT_STATUS_SUCCESS", "success"); //The payment was completed successfully.
define("DEPOSIT_STATUS_PENDING", "pending"); //This indicates that a wire transfer (wire_transfer) has not been confirmed by admin.

//deposit provider
define("DEPOSIT_PROVIDER_WIRE_TRANSFER", "wire_transfer"); //This indicates that the deposit will be initiated as a bank transfer. This user will be required to upload a document to prove that the transfer was initiated.
define("DEPOSIT_PROVIDER_STRIPE", "stripe"); //This indicates that the deposit will be initiated as a stripe payment.

//deposit use case
define("DEPOSIT_USE_WALLET", "wallet");
define("DEPOSIT_USE_QUEST", "quest");
define("DEPOSIT_USE_SUBSCRIPTION", "subscription");

//holding status
define("HOLDING_STATUS_HELD", "held"); //funds held from wallet
define("HOLDING_STATUS_RELEASED", "released"); //funds applied to intended target
define("HOLDING_STATUS_CANCELLED", "cancelled"); //hold on funds has been cancelled

//invoice use case
define("INVOICE_USE_SUBSCRIPTION_SETUP", "sub_setup"); //first payment of a subscription
define("INVOICE_USE_SUBSCRIPTION_RENEW", "sub_renew"); //renewal payment for a subscription
define("INVOICE_USE_QUEST", "quest"); // payment for a quest



//subscription handler
define("SUBSCRIPTION_HANDLER_STRIPE", "stripe"); //The subscription will be handled by stripe
define("SUBSCRIPTION_HANDLER_WALLET", "wallet"); //The subscription will be handled by funds loaded from the wallet

//payout account type
define("ACCOUNT_TYPE_AMAZON_GIFT_CARD", "type_amazon_card");
define("ACCOUNT_TYPE_DING_MOBILE_TOP_UP", "type_ding");
define("ACCOUNT_TYPE_REWARDS_GENIUS", "type_rewards_genius");
define("ACCOUNT_TYPE_PAYONEER", "type_payoneer");
define("ACCOUNT_TYPE_PAYPAL", "type_paypal");
define("ACCOUNT_TYPE_BANK_ACCOUNT", "type_bank");

//payout account function (the purpose of the specific account type)
define("ACCOUNT_FUNCTION_GIFT_CARD", "function_gift_card"); //("Gift Card")
define("ACCOUNT_FUNCTION_MOBILE", "function_mobile"); //("Mobile Recharge")
define("ACCOUNT_FUNCTION_CASH_OUT", "function_cash_out"); //("Monetary Cash Out")


//task status
define("TASK_STATUS_PENDING",   0);
define("TASK_STATUS_ACTIVE",    1);
define("TASK_STATUS_AWARDED",   2);
define("TASK_STATUS_COMPLETED", 3);
define("TASK_STATUS_CANCELLED", 4);
define("TASK_STATUS_DRAFT",     5);
define("TASK_STATUS_DISABLED",  6);

//task activity type
define("ACTIVITY_TYPE_SENTIMENT", "activity_sentiment");
define("ACTIVITY_TYPE_DISCOVERY", "activity_discovery");
define("ACTIVITY_TYPE_RETAIL", "activity_retail");
define("ACTIVITY_TYPE_MONITOR", "activity_monitor");
define("ACTIVITY_TYPE_INSPECTION", "activity_inspection");
define("ACTIVITY_TYPE_VOX", "activity_vox");
define("ACTIVITY_TYPE_POLL", "activity_poll");
//----------------
define("ACTIVITY_TYPE_SENTIMENT_TXT", "Sentiment Survey");
define("ACTIVITY_TYPE_DISCOVERY_TXT", "Location Discovery");
define("ACTIVITY_TYPE_RETAIL_TXT", "Retail Audit");
define("ACTIVITY_TYPE_MONITOR_TXT", "Price Monitoring");
define("ACTIVITY_TYPE_INSPECTION_TXT", "Inspection");


//task activity category
define("ACTIVITY_CATEGORY_LOCATE", "category_locate");
define("ACTIVITY_CATEGORY_EXPLORE", "category_explore");
define("ACTIVITY_CATEGORY_DISCOVER", "category_discover");
define("ACTIVITY_CATEGORY_VOX", "category_vox");
define("ACTIVITY_CATEGORY_PULSE", "category_pulse");
//-----------------
define("ACTIVITY_CATEGORY_PULSE_TXT", "Pulse");
define("ACTIVITY_CATEGORY_LOCATE_TXT", "Locate");
define("ACTIVITY_CATEGORY_EXPLORE_TXT", "Explore");
define("ACTIVITY_CATEGORY_DISCOVER_TXT", "Discover");

//user presence activity (the activity state that can be logged)
define("USER_ACTIVITY_ACCEPT_QUEST", "check_available");//the user queried available quest

//network role
define("NETWORK_ROLE_COMMANDER", "net_commander");
define("NETWORK_ROLE_MANAGER", "net_manager");
define("NETWORK_ROLE_COLLECTOR", "net_collector");

//network position
define("NETWORK_POSITION_PRIVATE", 0); //collectors cannot be used by other networks
define("NETWORK_POSITION_OFFICIAL", 1); //collectors can be used by other networks
define("NETWORK_POSITION_DEFAULT", 2); //this is the primary official network (all user registered without a specific network)

//user type
define("USER_TYPE_RESEARCHER", 1);
define("USER_TYPE_CLIENT", 0);


//location type
define("LOCATION_TYPE_POINT", "type_point");
define("LOCATION_TYPE_POLYGON", "type_polygon");
define("LOCATION_TYPE_MULTI_POLYGON", "type_multi_polygon");



//gender
define("GENDER_FEMALE", 0);
define("GENDER_MALE", 1);
define("GENDER_NON_BINARY", 2);
define("GENDER_NOT_TO_SAY", 3);
define("GENDER_OTHER", 4);
define("GENDER_FEMALE_STRING", "female");
define("GENDER_MALE_STRING", "male");
define("GENDER_NON_BINARY_STRING", "non_binary");
define("GENDER_NOT_TO_SAY_STRING", "prefer_not_to_say");
define("GENDER_OTHER_STRING", "other");


//--------------------------------------------------------

include("../../../../includes/headers/classes-v1.php");//has all the classes needed for queritel back-end
include("../../../../includes/headers/miscellaneous-v1.php");//additional functions
include("../../../../includes/headers/strings.php");//has all the constants needed



//API ACTIONS
define("ACTION_LOG_IN", "log_in");
define("ACTION_SIGN_UP", "sign_up");
define("ACTION_SIGN_OUT", "sign_out");
define("ACTION_GET_AVAILABLE_JOBS", "available_jobs");
define("ACTION_GET_ACTIVE_JOBS", "active_jobs");
define("ACTION_GET_COMPLETED_JOBS", "completed_jobs");
define("ACTION_ACCEPT_JOB", "accept_job");
define("ACTION_CANCEL_JOB", "cancel_job");
define("ACTION_GET_JOB_DETAIL", "get_job_detail");

define("ACTION_SUBMISSION_START", "submission_start");
define("ACTION_SUBMISSION_COMPLETE", "submission_complete");
define("ACTION_SEND_NOTIFICATION_ID", "send_notification_id");
define("ACTION_AUTHENTICATE_USER", "authenticate_user");
define("ACTION_GET_USER_DATA", "get_user_data");
define("ACTION_CHANGE_PASSWORD", "change_password");
//new actions
//define("", "");
define("ACTION_GET_WALLET_DATA", "get_wallet_data");
define("ACTION_SEND_DIRECT_MESSAGE", "send_direct_message");
define("ACTION_GET_DIRECT_MESSAGE_THREAD", "get_direct_message_thread");
define("ACTION_GET_DIRECT_MESSAGE_ITEM", "get_direct_message_item");
define("ACTION_GET_MESSAGE_LIST", "get_message_list");

define("ACTION_ADD_PRIMARY_ACCOUNT", "add_primary_bank_account");
define("ACTION_UPDATE_PRIMARY_ACCOUNT", "update_primary_bank_account");
define("ACTION_GET_PRIMARY_ACCOUNT", "get_primary_bank_account");

//LOCATION BASED VARIABLES
define("DEFAULT_LANGUAGE_CODE","en");
define("LOCATION_GREEN_ZONE", 16000); //16 km -> Users must be within the GREEN_ZONE in order to accept quest
define("SYSTEM_CURRENCY", "USD"); //The base currency used by the system
define("COUNTRY_JAMAICA", "JM"); //Country code for jamaica
define("COUNTRY_CHILE", "CL"); //Country code for chile

//EMAIL TEMPLATE FUNCTION NAME
//email template
//define("EMAIL_TEMPLATE_VERIFY_EMAIL","verify_email");
//define("EMAIL_TEMPLATE_REG_AGENT_INVITE","registered_agent_invite");
//define("EMAIL_TEMPLATE_UN_REG_AGENT_INVITE","unregistered_agent_invite");
//define("EMAIL_TEMPLATE_MANAGER_INVITE","manager_invite");
//define("EMAIL_TEMPLATE_AGENT_","");


//specific email functions
include 'email/email_handler.php';

$paperweight = new Database(MAIN_DB_USERNAME,MAIN_DB_PASSWORD,MAIN_DB_NAME);


$action = $_GET["action"];
if ($action == "demo")
{

    //https://api.queritel.com/api/mobile/queritel/insight/workservice/api.php?action=demo&param_json={%22user_id%22:823,%22lat%22:%2277.00%22,%22lng%22:%2213.00%22}

    $param_json = $_GET["param_json"];
    $data = json_decode($param_json, true);

    //329
    $user_id =      text_clean($data["user_id"]);
    //$lat =          text_clean($data["lat"]);
    //$lng =          text_clean($data["lng"]);
    //$response_id =  text_clean($data["response_id"]);

    //echo "This is demo <br>";
    //echo createEmailInvitationBody("google.com","Kadan Salmon");

    //echo getDefaultNetwork($paperweight);
    //echo json_encode(getOfficialNetworks($paperweight));

    /*$letters = array("a","b","c","d");

    foreach ($letters as $let){
        echo $let . "<br>";
    }*/

    //echo json_encode(getNetworkRelationship(125, $paperweight));
    //echo json_encode(isFromOfficialNetwork(329, $paperweight));
    //echo json_encode(isFromOfficialNetwork(121, $paperweight));
    //echo json_encode(isFromOfficialNetwork(377, $paperweight));

    //$client = new HostInfo();


    //echo json_encode($client->getCountry_flag());

    $lat = 17.9973836;
    $lng = -76.7896984;

    //$user_id = 823;

    $client = new Client($paperweight);
    $client->initializeClient($user_id);

    //$client->setCurrentLocation($lat,$lng);

    //$result = $client->getCurrentLocation();

    //$result = $client->startSubmission($response_id);
    //$result = $client->completeSubmission($response_id,);

    $task_id = 297;
    $passed_network_id = getQuestCreatorNetwork($task_id,$paperweight);

    $result = array();
    $data = array();
    $message_thread = array();


    /*

    $message_id = "pywxqjo-7175664-RRTWUNB";
    $recipient_id = 0;
    $recipient_network_id = "nid_jsy827459OFksye";
    $sender_id = 329;
    $sender_network_id = null;
    $timestamp = getCurrentTime();
    $task_id = 289;
    $msg_body = "this is my message body";

    $data[$index]["message_id"] = $message_id;
    $data[$index]["recipient_id"] = intval($recipient_id);
    $data[$index]["recipient_network"] = $recipient_network_id;
    $data[$index]["sender_id"] = intval($sender_id);
    $data[$index]["sender_network"] = $sender_network_id;
    $data[$index]["task_id"] = intval($task_id);
    $data[$index]["timestamp"] = $timestamp;
    $data[$index]["body"] = $msg_body;

    $message_id = "jfhyfgr-8476395-HDKDJGT";
    $recipient_id = 329;
    $recipient_network_id = null;
    $sender_id = 0;
    $sender_network_id = "nid_jsy827459OFksye";
    $timestamp = "2021-03-11 08:14:58";
    $task_id = 289;
    $msg_body = "this is my message body sent by the company";

    $index = 1;

    $data[$index]["message_id"] = $message_id;
    $data[$index]["recipient_id"] = intval($recipient_id);
    $data[$index]["recipient_network"] = $recipient_network_id;
    $data[$index]["sender_id"] = intval($sender_id);
    $data[$index]["sender_network"] = $sender_network_id;
    $data[$index]["task_id"] = intval($task_id);
    $data[$index]["timestamp"] = $timestamp;
    $data[$index]["body"] = $msg_body;

    $data[$index]["body"] = "Hello kadian";
    */


    $result["status"] = STATUS_OK;
    $result["message_thread"] = array();

    //if sender is not null (check if user is sender)


    $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_id = '$user_id' or recipient_id = '$user_id')) and task_id = '$task_id'";
    $msg_result = $paperweight->query($msg_query);

    if($msg_result != null && $msg_result->is_row_found()){

        while($row = $msg_result->fetch_array()){

            $message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);


            $data["message_id"] = $message_id;
            $data["recipient_id"] = intval($recipient_id);
            $data["recipient_network"] = $recipient_network_id;
            $data["sender_id"] = intval($sender_id);
            $data["sender_network"] = $sender_network_id;
            $data["task_id"] = intval($task_id);
            $data["timestamp"] = $timestamp;
            $data["body"] = ($msg_body);

            $message_thread[] = $data;

        }

        $result["status"] = STATUS_OK;
        $result["message_thread"] = $message_thread;

    }
    //$result = $client->startSubmission(79446052);
    //$result = $client->completeSubmission(79446052,30742304);
    //$result = $client->completeQuestionnaire(79446052);

    //$result = new LocationPoint(null,null);

    /*if (!$result->isEmpty()){
        echo "Location was found";
    }
    else{
        echo "Location was not found";
    }*/

    //echo $result->isEmpty();
    //echo $result->isEmpty();

    //$paperweight->getConnector()->set_charset("utf8");

    echo "Current character set is: " . $paperweight->getConnector()->character_set_name();

    //echo json_export($result);
    //echo json_encode($result);

}


define("DEBUG_EMAIL_TOKEN","0vqdnmx6g4waekl52ztp19jsor83uf");
define("DEBUG_INVITE_CODE","HJGYR7487FHNUF");


//todo - incorporate processUpload
/*public function processUpload(
    $directoryId = null,
    string $cabin = '',
    array $file = [],
    array $attribution = []
): array {

    // First step: Validate our file data
    switch ($file['error']) {
        case UPLOAD_ERR_INI_SIZE:
        case UPLOAD_ERR_FORM_SIZE:
            throw new UploadError('File is too large');
        case UPLOAD_ERR_PARTIAL:
            throw new UploadError('Partial file received');
        case UPLOAD_ERR_NO_TMP_DIR:
            throw new UploadError('Temporary directory does not exist');
        case UPLOAD_ERR_CANT_WRITE:
            throw new UploadError('Cannot write to temporary directory');
        case UPLOAD_ERR_OK:
            // Continue
            break;
    }
    if ($file['name'] === '..') {
        throw new UploadError('Invalid file name');
    }
    if (\preg_match('#([^/]+)\.([a-zA-Z0-9]+)$#', $file['name'], $matches)) {
        $name = $matches[1];
        $ext = $matches[2];
    } elseif(\preg_match('#([^/\.]+)$#', $file['name'], $matches)) {
        $name = $matches[1];
        $ext = 'txt';
    } else {
        throw new UploadError('Invalid file name');
    }

    // Actually upload the file.
    $destination = $this->moveUploadedFile($file['tmp_name'], $ext);
    $fullpath = AIRSHIP_UPLOADS . $destination;

    // Get the MIME type and checksum

    $type = $this->getMimeType($fullpath);
    $state = State::instance();
    $checksum = HaliteFile::checksum($fullpath, $state->keyring['cache.hash_key']);

    // Begin transaction
    $this->db->beginTransaction();

    // Get a unique file name
    $filename = $this->getUniqueFileName($name, $ext, $directoryId, $cabin);

    // Insert the new record
    $store = [
        'filename' =>
            $filename,
        'type' =>
            $type,
        'realname' =>
            $destination,
        'checksum' =>
            $checksum,
        'uploaded_by' =>
            $attribution['uploaded_by'] ?? $this->getActiveUserId(),
    ];
    if ($directoryId) {
        $store['directory'] = (int) $directoryId;
    } else {
        $store['cabin'] = (string) $cabin;
    }
    if (!empty($attribution['author'])) {
        $store['author'] = $attribution['author'];
    }
    $newId = $this->db->insertGet('airship_files', $store,'fileid');

    // Did our INSERT query fail?
    if (!$this->db->commit()) {
        // Clean up orphaned file, it was a database error.
        \unlink($fullpath);
        $this->db->rollBack();
        throw new UploadError('A database error occurred trying to save ' . $destination);
    }

    // Return metadata
    return [
        'fileid' => $newId,
        'name' => $filename,
        'type' => $type,
        'csum' => $checksum
    ];
}*/

if (isset($_POST["action"])){
    $action = $_POST["action"];
    $param_json = $_POST["param_json"];

    //todo - ACTION_VERIFY_EMAIL = verify_email
    //todo - ACTION_REGISTER_CLIENT = register_client
    //todo - ACTION_INVITATION_DETAIL = get_invitation_detail
    //todo - ACTION_ACCEPT_INVITATION = accept_invitation
    //todo - ACTION_REJECT_INVITATION = reject_invitation
    //todo - ACTION_REVOKE_INVITATION = revoke_invitation
    //todo - ACTION_INVITE_AGENT = invite_agent
    //todo - ACTION_AGENT_INVITATION_LIST = get_agent_invitation_list
    //todo - ACTION_SUPPORTED_ACCESS_LIST = get_supported_access
    //todo - ACTION_INVITE_MANAGER = invite_manager
    //todo - ACTION_MANAGER_INVITATION_LIST = get_manager_invitation_list
    //todo - ACTION_GET_AGENT_LIST = get_agent_list
    //todo - ACTION_GET_MANAGER_LIST = get_manager_list
    //todo - ACTION_GET_DASHBOARD_LIST = "get_dashboard_list"
    //todo - ACTION_GET_DASHBOARD_DATA = "get_dashboard_data"
    //todo - ACTION_CHANGE_PASSWORD = "change_password"
    //todo - ACTION_GET_USER_DATA = "get_user_data"
    //todo - ACTION_UPDATE_USER_DATA = "update_user_data"
    //todo - ACTION_CREATE_CATEGORY = "create_category"
    //todo - ACTION_GET_CATEGORY_LIST = "get_category_list"
    //todo - ACTION_GET_CATEGORY_DATA = "get_category_data"
    //todo - ACTION_REMOVE_CATEGORY = "remove_category"
    //todo - ACTION_GET_PRODUCT_LIST = "get_product_list"
    //todo - ACTION_ADD_PRODUCT = "add_product"
    //todo - ACTION_REMOVE_PRODUCT = "remove_product"
    //todo - ACTION_GET_CATALOG_LIST = "get_catalog_list"  - extern
    //todo - ACTION_CAT_BRAND_LIST = "cat_brand_list" - extern
    //todo - ACTION_CAT_UNIT_LIST = "cat_unit_list" - extern
    //todo - ACTION_CAT_CATEGORY_LIST = "cat_category_list" - extern

    //todo = ---------------------------- FILE START ----------------------------
    //todo - ACTION_GET_FILE_LIST = "get_file_list" - test
    //todo - ACTION_GET_FILE_DATA = "get_file_data" - test
    //todo - ACTION_REMOVE_FILE = "remove_quest_file" - test
    //todo - ACTION_ADD_FILE = "add_quest_file" - test
    //todo = ---------------------------- FILE END ----------------------------





    if ($action == "console_debug") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);

        $key_list = array();
        $key_1 = array();
        $key_2 = array();
        $key_3 = array();


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $account_holder = $network_detail["account_holder"];


                $result = getOKStatus();

                $result["wallet"] = getWalletBalance($network_id,$paperweight);
                $result["holding"] = getHoldingBalance($network_id,$paperweight);

                $param_obj = array();
                $param_obj["user_id"] = $user_id;
                $param_obj["network_id"] = $network_id;
                $param_obj["hold_amount"] = 10;
                $param_obj["holding_id"] = "hold_yukQIYn4826554BenKtOQ75ANH";

                //$result["funds_held"] = h_funds_hold($param_obj, $paperweight);
                //$result["funds_released"] = h_funds_hold_release($param_obj, $paperweight);
                $result["funds_cancelled"] = h_funds_hold_cancel($param_obj, $paperweight);

                $result["new_wallet"] = getWalletBalance($network_id,$paperweight);
                $result["new_holding"] = getHoldingBalance($network_id,$paperweight);
            }


            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);
            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/



            /*foreach ($json_a as $store) {
                foreach ($store as $key => $value) {
                    echo $key . ' : ' . $value . "\n";
                }
            }*/
            /*foreach ($json_a as $store) {
                echo json_encode($store["logo_url"]) . "\n";

            }*/

            //$result["obj"] = filterStoreList(null, $json_a);

            //super_mercados.json

            //$result["send_mail"] = email_confirm_account("kadansalmon.ks@gmail.com","http://app.queritel.com/qKdpbkhCrStGWTSGMKBeKlZnzVdbdbqiIODgyvzF/verify");

        }

        echo json_export($result);
    }
    if ($action == "-"){
        $data = json_decode($param_json, true);

        $username = strtolower(text_clean($data["username"]));
        $password = text_clean($data["password"]);



        //$client = new Client($paperweight);
        //$result = $client->login($username, $password, $login_data);

        echo json_export($result);

    }


    //todo - 100%
    if ($action == "register_client"){
        $data = json_decode($param_json, true);

        $username = strtolower(text_clean($data["email"]));
        $password = text_clean($data["password"]);


        $signup_success = false;

        $provided_password = encryptPassword($password);

        $user_type = USER_TYPE_CLIENT;
        $user_active = STATE_ACTIVE;
        $user_is_approved = VERIFIED;
        $email_is_verified = UNVERIFIED;
        $current_time = getCurrentTime();
        $user_ref_id = generateUserReferenceId();


        //network creation
        $network_id = generate_unique_id(UNIQUE_NETWORK);
        $relationship_id = generateNumericId();
        $network_name =  "net_" . getRandomString(5) . getRandomNumber(5);
        $network_role = NETWORK_ROLE_COMMANDER;
        $network_position = NETWORK_POSITION_OFFICIAL;

        //email token creation
        $email_token = generate_email_token();
        $email_action = EMAIL_ACTION_VERIFY_EMAIL;
        $email_status = STATE_ACTIVE;

        $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

        $registration = isClientRegistered($username,$paperweight);
        if (!empty($registration)){
            //client is already registered

            $result = getErrorStatus(ERROR_MSG_USER_ACC_DUPLICATE);

        }
        else{
            //client is not registered

            if (!empty($username) && !empty($password)){
                $add_user = get_insert_query(TABLE_USERS,[
                    "user_ref_id" => $user_ref_id,
                    "user_email" => $username,
                    "user_password" => $provided_password,
                    "user_screen_name" => $username,
                    "user_type" => $user_type,
                    "user_email_verified" => $email_is_verified,
                    "user_active" => $user_active,
                    "user_regdate" => $current_time,
                    "user_is_approved" => $user_is_approved,
                    "language_code" => DEFAULT_LANGUAGE_CODE
                ]);
                $add_user_result = $paperweight->query($add_user);

                if($add_user_result != null && $add_user_result->is_row_affected()){
                    $new_user_id = $add_user_result->insert_id();

                    $add_network = get_insert_query(TABLE_NETWORK,[
                        "network_id" => $network_id,
                        "network_name" => $network_name,
                        "update_time" => $current_time,
                        "default_user" => $new_user_id,
                        "organization_name" => $network_name,
                        "position" => $network_position
                    ]);
                    $add_network_rel = get_insert_query(TABLE_NETWORK_RELATIONSHIP,[
                        "relationship_id" => $relationship_id,
                        "network_id" => $network_id,
                        "network_role" => $network_role,
                        "update_time" => $current_time,
                        "user_id" => $new_user_id
                    ]);

                    $add_network_result = $paperweight->query($add_network);
                    $add_network_rel_result = $paperweight->query($add_network_rel);

                    if($add_network_result != null && $add_network_rel_result != null){
                        $add_email_token = get_insert_query(TABLE_EMAIL_TOKEN,[
                            "token" => $email_token,
                            "creation_time" => $current_time,
                            "action" => $email_action,
                            "user_id" => $new_user_id,
                            "status" => $email_status
                        ]);
                        $add_token_result = $paperweight->query($add_email_token);

                        if($add_token_result != null && $add_token_result->is_row_affected()){
                            $generated_link = "http://app.queritel.com/" . $email_token . "/verify";
                            //$generated_link = "https://api.queritel.com/api/general/mailing/email/submission?ops=invitation&op=" . $network_id . "&token=" . $token;

                            email_confirm_account($username,$generated_link);

                            //$subject = "Confirm Account";
                            //$body = createEmailConfirmationBody($generated_link);
                            //triggerEmail($username,$subject,$body);

                            $signup_success = true;
                        }

                    }

                }

            }

        }

        if ($signup_success){
            $result = getOKStatus();
            $result["user_type"] = $network_role;
        }

        /*$user_test_passed = VERIFIED;
        $user_sample_essay = VERIFIED;


        //network data
        $network_id = text_clean($data["n_id"]);// please validate this first
        if(!isset($data["n_id"]) || $network_id == ""){
            $network_id = getDefaultNetwork($paperweight);
            //$network_id = "nid_jsy827459OFksye"; //demo network
        }
        $network_role = NETWORK_ROLE_COLLECTOR;
        $relationship_id = generateNumericId();

        if (!empty($first_name) && !empty($last_name) && !empty($email) && !empty($password)){
            //insert into table user
            $add_user = "insert into " . TABLE_USERS . " (user_ref_id,user_email,user_password,user_screen_name,user_first_name,user_last_name,user_sex,user_country_id,user_state_id,user_city_id,user_county,user_parish,user_regdate,user_type,user_email_verified,user_active,user_is_approved,phone_number,date_of_birth,country_code,location_state,location_city,location_address,language_code,invitation_referrer) values('$user_ref_id','$email','$password','$screen_name','$first_name','$last_name','$gender','$country_id','$state_id','$city_id','$county','$parish','$user_regdate','$user_type','$email_is_verified','$user_active','$user_is_approved','$mobile','$date_of_birth','$country_code','$location_state','$location_city','$location_address','$language_code','$invitation_referrer')";
            $add_user_result = $paperweight->query($add_user);

            if($add_user_result != null && $add_user_result->is_row_affected()){

                $query_new_user = "select * from " . TABLE_USERS . " where user_ref_id = '$user_ref_id' and user_email = '$email'";
                $query_new_user_result = $paperweight->query($query_new_user);

                if ($query_new_user_result != null && $query_new_user_result->is_row_found())
                {
                    if ($row = $query_new_user_result->fetch_array())
                    {
                        //--- ADD AGENT PROFILE data

                        $user_id = $row["user_id"];
                        $add_user_profile = "insert into " . TABLE_USER_PROFILE . " (userprofile_user_id,user_mobile,user_is_experienced,user_assistance_company,user_deg_id,user_test_passed,user_sample_essay,ethnicity,marital_status,education,employment_status,employment_industry,occupation) values ('$user_id','$mobile','$is_experienced','$user_assistance_company','$user_deg_id','$user_test_passed','$user_sample_essay','$ethnicity','$marital_status','$education','$employment_status','$employment_industry','$occupation')";
                        $add_user_network = "insert into " . TABLE_NETWORK_RELATIONSHIP . " (relationship_id,network_id,network_role,update_time,user_id) values ('$relationship_id','$network_id','$network_role','$user_regdate','$user_id')";

                        $add_user_profile_result = $paperweight->query($add_user_profile);
                        if($add_user_profile_result != null && $add_user_profile_result->is_row_affected()){
                            $add_user_network_result = $paperweight->query($add_user_network);
                            if($add_user_network_result != null && $add_user_network_result->is_row_affected()){

                                $signup_success = true;

                            }
                        }

                    }
                }

            }
        }

        if ($signup_success){
            $result = $client->getOKStatus();
        }*/

        echo json_export($result);
    }

    //todo - 100%
    if ($action == "verify_email"){
        $data = json_decode($param_json, true);

        $email_token = text_clean($data["token"]);

        $email_action = EMAIL_ACTION_VERIFY_EMAIL;
        $email_status = STATE_ACTIVE;

        $result = getErrorStatus(ERROR_MSG_INVALID_TOKEN);


        $sql_query = "select * from " . TABLE_EMAIL_TOKEN . " where token = '$email_token' and `action` = '$email_action' and `status` = '$email_status'";
        $sql_query_result = $paperweight->query($sql_query);

        if($sql_query_result != null && $sql_query_result->is_row_found()){
            if($row = $sql_query_result->fetch_array()){
                $user_id = $row["user_id"];

                $network_relationships = getNetworkRelationship($user_id, $paperweight);


                if (!empty($network_relationships)){
                    $network_id =  $network_relationships[0]["network_id"];
                    $network_role =  $network_relationships[0]["network_role"];
                    $relationship_state =  $network_relationships[0]["relationship_state"];

                    $update_user = get_update_query(TABLE_USERS,[
                        "user_email_verified" => 1
                    ],"user_id = '$user_id'");
                    $update_user_result = $paperweight->query($update_user);
                    if($update_user_result != null && $update_user_result->is_row_affected()){

                        $update_email_token = get_update_query(TABLE_EMAIL_TOKEN,[
                            "status" => 0
                        ],"token = '$email_token'");
                        $update_token_result = $paperweight->query($update_email_token);
                        if($update_token_result != null && $update_token_result->is_row_affected()){

                            $login_data = triggerRawLogin($user_id, $paperweight);
                            if (!empty($login_data)){

                                $result = getOKStatus();
                                $result["user_type"] = $network_role;
                                $result["user_id"] = $user_id;
                                $result["login_token"] = $login_data["login_token"];

                            }

                        }

                    }

                }


            }
        }



        $res = '{
              "status": "OK",
              "user_type": "net_commander",
              "user_id": "125",
              "login_token": "52956179"
        }';

        //$client = new Client($paperweight);
        //$result = $client->login($username, $password, $login_data);

        echo json_export($result);
        //echo $res;
    }

    //todo - 90% - add group list
    if ($action == "get_agent_list") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $group_id = text_clean($data["group_id"]); //array
        //$community_list = text_clean($data["community_list"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getOKStatus();

            $agent_list = array();

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $role_collector = NETWORK_ROLE_COLLECTOR;
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                if (empty($group_id)){
                    //all the agents on the network

                    $net_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where network_id = '$network_id' and network_role = '$role_collector'";
                    $net_rel_result = $paperweight->query($net_rel_query);
                    if ($net_rel_result != null && $net_rel_result->is_row_found()){

                        while ($row_rel = $net_rel_result->fetch_array()){
                            $uid = $row_rel["user_id"];
                            $detail = query_user($uid,$paperweight);
                            $role = $row_rel["network_role"];
                            $net_state = $row_rel["relationship_state"];
                            if ($role == NETWORK_ROLE_COLLECTOR){
                                $user_type = 0;
                            }
                            elseif ($role == NETWORK_ROLE_MANAGER){
                                $user_type = 1;
                            }

                            $group_list = array();

                            $agent = array();
                            $agent["agent_id"] = $uid;
                            $agent["ref_code"] = $detail["user_ref_id"];
                            $agent["fname"] = $detail["fname"];
                            $agent["lname"] = $detail["lname"];
                            $agent["is_active"] = $net_state == 1;
                            $agent["email"] = $detail["user_email"];
                            $agent["quest_completed"] = 0;
                            $agent["quest_active"] = 0;
                            $agent["score"] = 0;
                            $agent["group_list"] = $group_list;

                            $agent_list[] = $agent;

                        }

                    }

                }
                else{
                    //agents on a specific sub network

                    $net_rel_query = "select * from " . TABLE_SUB_NETWORK_RELATIONSHIP . " where network_id = '$network_id' and network_role = '$role_collector' and group_id = '$group_id'";
                    $net_rel_result = $paperweight->query($net_rel_query);
                    if ($net_rel_result != null && $net_rel_result->is_row_found()){
                        while ($row_rel = $net_rel_result->fetch_array()){
                            $uid = $row_rel["user_id"];
                            $detail = query_user($uid,$paperweight);
                            $role = $row_rel["network_role"];
                            $net_state = $row_rel["relationship_state"];
                            if ($role == NETWORK_ROLE_COLLECTOR){
                                $user_type = 0;
                            }
                            elseif ($role == NETWORK_ROLE_MANAGER){
                                $user_type = 1;
                            }

                            $group_list = array();

                            $agent = array();
                            $agent["agent_id"] = $uid;
                            $agent["ref_code"] = $detail["user_ref_id"];
                            $agent["fname"] = $detail["fname"];
                            $agent["lname"] = $detail["lname"];
                            $agent["is_active"] = $net_state == 1;
                            $agent["email"] = $detail["user_email"];
                            $agent["quest_completed"] = 0;
                            $agent["quest_active"] = 0;
                            $agent["score"] = 0;
                            $agent["group_list"] = $group_list;

                            $agent_list[] = $agent;

                        }
                    }

                }
            }

            $result["agent_list"] = $agent_list;

            $res = '{
              "status": "OK",
              "agent_list": [
                {
                  "agent_id": "329",
                  "ref_code": "40760968",
                  "fname": "Kevin",
                  "lname": "Smith",
                  "quest_completed": 0,
                  "quest_active": 0,
                  "score": 0,
                  "is_active": true,
                  "email": "kevin.s@queritel.com",
                  "group_list": [
                    {
                      "group_id": "KFHDIU765H4HCHFh653gddsgGHSLJSgdS",
                      "group_name": "Collection Group 2"
                    }
                  ]
                },
                {
                  "agent_id": "1069",
                  "ref_code": "59175160",
                  "fname": "Demo",
                  "lname": "User",
                  "quest_completed": 0,
                  "quest_active": 0,
                  "score": 0,
                  "is_active": false,
                  "email": "zen.des@queritel.com",
                  "group_list": [
                    {
                      "group_id": "KFHDIU765H4HCHFh653gddsgGHSLJSgdS",
                      "group_name": "Collection Group 2"
                    }
                  ]
                }
              ]
            }';

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

        }

        //echo json_export($result);
        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }

    //todo - 99% - add permission map to get permission name
    if ($action == "get_manager_list") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $community_id = text_clean($data["community_id"]); //array
        //$community_list = text_clean($data["community_list"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getOKStatus();

            $manager_list = array();

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $role_collector = NETWORK_ROLE_COLLECTOR;
                $role_manager = NETWORK_ROLE_MANAGER;

                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $net_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where network_id = '$network_id' and network_role = '$role_manager'";
                $net_rel_result = $paperweight->query($net_rel_query);

                if ($net_rel_result != null && $net_rel_result->is_row_found()){
                    while ($row_rel = $net_rel_result->fetch_array()){
                        //$permission = $row_rel["permission_json"];
                        $uid = $row_rel["user_id"];
                        $detail = query_user($uid,$paperweight);
                        $role = $row_rel["network_role"];
                        $net_state = $row_rel["relationship_state"];
                        if ($role == NETWORK_ROLE_COLLECTOR){
                            $user_type = 0;
                        }
                        elseif ($role == NETWORK_ROLE_MANAGER){
                            $user_type = 1;
                        }


                        if (empty($row_rel["permission_json"])){
                            $permission_list = array();
                        }
                        else{
                            try {
                                $new_perm = array();

                                $permission_list = json_decode($row_rel["permission_json"],true);

                                if (!empty($permission_list)){
                                    foreach($permission_list as $item) {
                                        $arr = array();
                                        $arr["permission_id"] = $item;
                                        $arr["permission_name"] = $item;

                                        $new_perm[] = $arr;
                                    }
                                }

                                $permission_list = $new_perm;
                            }
                            catch (Exception $ex){
                                $permission_list = array();
                            }
                        }


                        $manager = array();
                        $manager["manager_id"] = $uid;
                        $manager["ref_code"] = $detail["user_ref_id"];
                        $manager["fname"] = $detail["fname"];
                        $manager["lname"] = $detail["lname"];
                        $manager["is_active"] = $net_state == 1;
                        $manager["email"] = $detail["user_email"];
                        $manager["permission_list"] = $permission_list;

                        $manager_list[] = $manager;
                    }
                }
            }

            $result["manager_list"] = $manager_list;

            /*$res = '{
              "status": "OK",
              "manager_list": [
                {
                  "manager_id": "125",
                  "ref_code": "40760968",
                  "fname": "John",
                  "lname": "Davaros",
                  "email": "kevin.s@queritel.com",
                  "is_active": true,
                  "permission_list": [
                    {
                      "permission_id": "access_quest_creation",
                      "permission_name": "Quest Creation"
                    }
                  ]
                },
                {
                  "manager_id": "125",
                  "ref_code": "40760968",
                  "fname": "Micheal",
                  "lname": "Tailor",
                  "email": "kevin.s@queritel.com",
                  "is_active": true,
                  "permission_list": [
                    {
                      "permission_id": "access_network_management",
                      "permission_name": "Network Management"
                    }
                  ]
                }
              ]
            }';*/

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

        }

        //echo json_export($result);
        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }

    //todo - 100%
    if ($action == "invite_agent") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $email_list = $data["email_list"]; //array
        $community_list = $data["group_list"]; //array
        $comment = text_clean($data["comment"]); //array

        $invitation_sent = false;

        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                if (count($email_list) > 0) {
                    for ($i = 0; $i < count($email_list); $i++) {
                        $email = text_clean($email_list[$i]);

                        $email_token = generate_email_token();
                        $email_action = EMAIL_ACTION_ACCEPT_INVITE;
                        $email_status = STATE_ACTIVE;

                        if (!empty($community_list)){
                            $community_list = json_encode($community_list);
                        }
                        else{
                            $community_list = json_encode(array());
                        }

                        $invite_code = strtoupper(getRandomString(15));
                        $current_time = getCurrentTime();


                        /*$add_email_token = get_insert_query(TABLE_EMAIL_TOKEN,[
                                "token" => $email_token,
                                "creation_time" => $current_time,
                                "action" => $email_action,
                                "user_id" => $new_user_id,
                                "status" => $email_status
                            ]);*/
                        /*$add_invite_code = get_insert_query(TABLE_INVITE_CODE,[
                                    "creation_time" => $current_time,
                                    "invitation_code" => $invite_code,
                                    "group_list" => $community_list,
                                    "email" => $email,
                                    "email_token" => $email_token,
                                    "invitation_state" => $email_status,
                                    "is_public" => 0,
                                    "expiration_time" => null,
                                    "accepted_time" => $email_status,
                                    "user_id" => $email_status,
                                    "comment" => $email_status,
                                    "permission_list" => $email_status,
                                    "network_role" => $email_status,
                                    "network_id" => $email_status,
                                    "quota_max" => $email_status,
                                    "quota_count" => $email_status,
                                ]);*/


                        $registration = isAgentRegistered($email,$paperweight);
                        if (!empty($registration)){
                            //agent is already registered

                            $uid = $registration["user_id"];
                            $add_email_token = get_insert_query(TABLE_EMAIL_TOKEN,[
                                "token" => $email_token,
                                "creation_time" => $current_time,
                                "action" => $email_action,
                                "user_id" => $uid,
                                "status" => $email_status
                            ]);
                            $add_token_result = $paperweight->query($add_email_token);

                            if($add_token_result != null && $add_token_result->is_row_affected()){

                                $add_invite_code = get_insert_query(TABLE_INVITE_CODE,[
                                    "creation_time" => $current_time,
                                    "invitation_code" => $invite_code,
                                    "group_list" => $community_list,
                                    "email" => $email,
                                    "user_id" => $uid,
                                    "email_token" => $email_token,
                                    "invitation_state" => $email_status,
                                    "is_public" => 0,
                                    "comment" => $comment,
                                    "network_role" => NETWORK_ROLE_COLLECTOR,
                                    "network_id" => $network_id,
                                    "creator_id" => $user_id,
                                    "creator_network_id" => $network_id
                                ]);
                                $add_invite_result = $paperweight->query($add_invite_code);

                                if($add_invite_result != null && $add_invite_result->is_row_affected()){
                                    $generated_link = "http://app.queritel.com/" . $email_token . "/invite?code=" . $invite_code;

                                    email_reg_agent_invite($email,$generated_link,$invite_code,$org_name,$comment);

                                    $invitation_sent = true;
                                }

                            }

                        }
                        else{
                            //agent is not registered
                            $add_email_token = get_insert_query(TABLE_EMAIL_TOKEN,[
                                "token" => $email_token,
                                "creation_time" => $current_time,
                                "action" => $email_action,
                                "status" => $email_status
                            ]);
                            $add_token_result = $paperweight->query($add_email_token);

                            if($add_token_result != null && $add_token_result->is_row_affected()){

                                $add_invite_code = get_insert_query(TABLE_INVITE_CODE,[
                                    "creation_time" => $current_time,
                                    "invitation_code" => $invite_code,
                                    "group_list" => $community_list,
                                    "email" => $email,
                                    "email_token" => $email_token,
                                    "invitation_state" => $email_status,
                                    "is_public" => 0,
                                    "comment" => $comment,
                                    "network_role" => NETWORK_ROLE_COLLECTOR,
                                    "network_id" => $network_id,
                                    "creator_id" => $user_id,
                                    "creator_network_id" => $network_id,
                                ]);
                                $add_invite_result = $paperweight->query($add_invite_code);

                                if($add_invite_result != null && $add_invite_result->is_row_affected()){
                                    $generated_link = "http://app.queritel.com/" . $email_token . "/invite?code=" . $invite_code;


                                    email_un_reg_agent_invite($email,$invite_code,$comment,$org_name);

                                    $invitation_sent = true;
                                }

                            }

                        }
                    }
                }

                if ($invitation_sent){
                    $result = getOKStatus();
                }
            }

        }

        echo json_export($result);
    }

    //todo - 100%
    if ($action == "invite_manager") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $email = text_clean($data["invite_email"]);
        $permission_list = $data["permission_list"]; //array
        $comment = text_clean($data["comment"]);

        $invitation_sent = false;

        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $email_token = generate_email_token();
                $email_action = EMAIL_ACTION_ACCEPT_INVITE;
                $email_status = STATE_ACTIVE;

                if (!empty($permission_list)){
                    $permission_list = json_encode($permission_list);
                }
                else{
                    $permission_list = json_encode(array());
                }

                $invite_code = strtoupper(getRandomString(15));
                $current_time = getCurrentTime();

                $registration = isClientRegistered($email,$paperweight);

                if (empty($registration)){
                    //manager is not registered

                    $add_email_token = get_insert_query(TABLE_EMAIL_TOKEN,[
                        "token" => $email_token,
                        "creation_time" => $current_time,
                        "action" => $email_action,
                        "status" => $email_status
                    ]);
                    $add_token_result = $paperweight->query($add_email_token);

                    if($add_token_result != null && $add_token_result->is_row_affected()){
                        $add_invite_code = get_insert_query(TABLE_INVITE_CODE,[
                            "creation_time" => $current_time,
                            "invitation_code" => $invite_code,
                            "permission_list" => $permission_list,
                            "email" => $email,
                            "email_token" => $email_token,
                            "invitation_state" => $email_status,
                            "is_public" => 0,
                            "comment" => $comment,
                            "network_role" => NETWORK_ROLE_MANAGER,
                            "network_id" => $network_id,
                            "creator_id" => $user_id,
                            "creator_network_id" => $network_id,
                        ]);
                        $add_invite_result = $paperweight->query($add_invite_code);

                        if($add_invite_result != null && $add_invite_result->is_row_affected()){
                            $generated_link = "http://app.queritel.com/" . $email_token . "/invite?code=" . $invite_code;


                            email_manager_invite($email,$generated_link,$comment,$org_name);

                            $invitation_sent = true;
                        }
                    }

                }
                else{
                    $result = getErrorStatus(ERROR_MSG_USER_ACC_DUPLICATE);
                }

                if ($invitation_sent){
                    $result = getOKStatus();
                }

            }



        }

        echo json_export($result);
    }

    //todo - 100%
    if ($action == "get_invitation_detail"){
        $data = json_decode($param_json, true);

        $token = text_clean($data["token"]);
        $invitation_code = text_clean($data["invitation_code"]);
        $verify = $data["verify"];

        $result = getErrorStatus(ERROR_MSG_INVALID_TOKEN);

        if ($verify){
            $verified = VERIFIED;

            $query_invite = "select * from " . TABLE_INVITE_CODE . " where invitation_code = '$invitation_code' and invitation_state = '$verified' and email_token = '$token'";
            $invite_result = $paperweight->query($query_invite);

            if($invite_result != null && $invite_result->is_row_found()){
                if($row = $invite_result->fetch_array()){
                    $network_id = $row["network_id"];
                    $network_detail = getNetworkDetails($network_id,$paperweight);
                    $org_name = $network_detail["organization_name"];

                    $group_list = array();
                    $permission_list = array();

                    if (empty($row["group_list"])){
                        $group_list = array();
                    }
                    else{
                        try {
                            $new_group = array();

                            $group_list = json_decode($row["group_list"],true);
                            $index = 1;

                            if (!empty($group_list)){
                                foreach ($group_list as $item) {
                                    $arr = array();
                                    $arr["group_id"] = $item;
                                    $arr["group_name"] = "Community " . $index;

                                    $index++;

                                    $new_group[] = $arr;
                                }
                            }

                            $group_list = $new_group;
                        }
                        catch (Exception $ex){
                            $group_list = array();
                        }
                    }
                    if (empty($row["permission_list"])){
                        $permission_list = array();
                    }
                    else{
                        try {
                            $new_perm = array();

                            $permission_list = json_decode($row["permission_list"],true);

                            if (!empty($permission_list)){
                                foreach($permission_list as $item) {
                                    $arr = array();
                                    $arr["permission_id"] = $item;
                                    $arr["permission_name"] = "";

                                    $new_perm[] = $arr;
                                }
                            }

                            $permission_list = $new_perm;
                        }
                        catch (Exception $ex){
                            $permission_list = array();
                        }
                    }


                    $result = getOKStatus();
                    $result["invitation_code"] = $invitation_code;
                    $result["user_type"] = $row["network_role"];
                    $result["organization_name"] = $org_name;
                    $result["comment"] = $row["comment"];
                    $result["group_list"] = $group_list;
                    $result["permission_list"] = $permission_list;

                }
            }
        }
        else{

            $query_invite = "select * from " . TABLE_INVITE_CODE . " where invitation_code = '$invitation_code'";
            $invite_result = $paperweight->query($query_invite);

            if($invite_result != null && $invite_result->is_row_found()){
                if($row = $invite_result->fetch_array()){
                    $network_id = $row["network_id"];
                    $network_detail = getNetworkDetails($network_id,$paperweight);
                    $org_name = $network_detail["organization_name"];

                    $group_list = array();
                    $permission_list = array();


                    if (empty($row["group_list"])){
                        $group_list = array();
                    }
                    else{
                        try {
                            $new_group = array();

                            $group_list = json_decode($row["group_list"],true);
                            $index = 1;
                            foreach ($group_list as $item) {
                                $arr = array();
                                $arr["group_id"] = $item;
                                $arr["group_name"] = "Community " . $index;

                                $index++;

                                $new_group[] = $arr;
                            }

                            $group_list = $new_group;
                        }
                        catch (Exception $ex){
                            $group_list = array();
                        }
                    }
                    if (empty($row["permission_list"])){
                        $permission_list = array();
                    }
                    else{
                        try {
                            $new_perm = array();

                            $permission_list = json_decode($row["permission_list"],true);
                            foreach ($permission_list as $item) {
                                $arr = array();
                                $arr["permission_id"] = $item;
                                $arr["permission_name"] = "";

                                $new_perm[] = $arr;
                            }

                            $permission_list = $new_perm;
                        }
                        catch (Exception $ex){
                            $permission_list = array();
                        }
                    }


                    $result = getOKStatus();
                    $result["invitation_code"] = $invitation_code;
                    $result["user_type"] = $row["network_role"];
                    $result["organization_name"] = $org_name;
                    $result["comment"] = $row["comment"];
                    $result["group_list"] = $group_list;
                    $result["permission_list"] = $permission_list;

                }
            }
        }

        /*$res = '{
          "status": "OK",
          "invitation_code": "' . DEBUG_INVITE_CODE .'",
          "user_type": "net_collector",
          "organization_name": "Zendar Collector Group",
          "group_list": [
            {
              "group_id": "HFJG76FGHD874HK8hfjs8dge5",
              "group_name": "Collection Group"
            }
          ],
          "permission_list": [
            {
              "permission_id": "access_view_messages",
              "permission_name": "Messages"
            },
            {
              "permission_id": "access_view_dashboard",
              "permission_name": "Data Dashboard"
            }
          ],
          "comment": "Hey Kevin, It would be really great if you could give us a hand with our network. We\'d love to have you board."
        }';*/

        /*$debug_valid = false;

        if (($token == DEBUG_EMAIL_TOKEN) && ($invitation_code == DEBUG_INVITE_CODE)){
            $debug_valid = true;
        }

        if ((!$verify) && ($invitation_code == DEBUG_INVITE_CODE)){
            $debug_valid = true;
        }


        if ($debug_valid){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "accept_invitation"){
        $data = json_decode($param_json, true);

        $token = text_clean($data["token"]);
        $invitation_code = text_clean($data["invitation_code"]);

        //todo - debug log
        debugAPIResponse($action,json_encode($data));

        $result = getErrorStatus(ERROR_MSG_INVALID_TOKEN);

        $verified = VERIFIED;

        $query_invite = "select * from " . TABLE_INVITE_CODE . " where invitation_code = '$invitation_code' and invitation_state = '$verified' and email_token = '$token'";
        $invite_result = $paperweight->query($query_invite);

        if($invite_result != null && $invite_result->is_row_found()){
            if ($row = $invite_result->fetch_array()){

                $email = $row["email"];
                $network_role = $row["network_role"];

                if ($network_role == NETWORK_ROLE_COLLECTOR){

                    $registration = isAgentRegistered($email,$paperweight);
                    if (!empty($registration)){
                        $uid = $registration["user_id"];
                        $email_token = $row["email_token"];
                        $network_id = $row["network_id"];

                        $group_list = array();

                        if (empty($row["group_list"])){
                            $group_list = array();
                        }
                        else{
                            try {
                                $group_list = json_decode($row["group_list"],true);
                            }
                            catch (Exception $ex){
                                $group_list = array();
                            }
                        }


                        $update_insert_rel = get_insert_query(TABLE_NETWORK_RELATIONSHIP,[
                            "relationship_id" => generate_token(),
                            "network_id" => $network_id,
                            "network_role" => $network_role,
                            "relationship_state" => VERIFIED,
                            "update_time" => getCurrentTime(),
                            "user_id" => $uid
                        ]);
                        $update_insert_result = $paperweight->query($update_insert_rel);
                        if($update_insert_result != null && $update_insert_result->is_row_affected()){
                            //add user to sub network if any
                            if (!empty($group_list)){

                                foreach ($group_list as $group_id) {
                                    $update_insert_sub = get_insert_query(TABLE_SUB_NETWORK_RELATIONSHIP,[
                                        "relationship_id" => generate_token(),
                                        "network_id" => $network_id,
                                        "group_id" => $group_id,
                                        "relationship_state" => VERIFIED,
                                        "update_time" => getCurrentTime(),
                                        "user_id" => $uid
                                    ]);
                                    $update_insert_sub_result = $paperweight->query($update_insert_sub);
                                    //if($update_insert_sub_result != null && $update_insert_sub_result->is_row_affected()){}
                                }
                            }

                            $current_time = getCurrentTime();

                            //update invite code
                            $update_invite_code = get_update_query(TABLE_INVITE_CODE,[
                                "update_time" => $current_time,
                                "accepted_time" => $current_time,
                                "is_accepted" => 1,
                                "invitation_state" => 0
                            ],"invitation_code = '$invitation_code' and email_token = '$token'");
                            $update_code_result = $paperweight->query($update_invite_code);
                            if($update_code_result != null && $update_code_result->is_row_affected()){

                                $update_email_token = get_update_query(TABLE_EMAIL_TOKEN,[
                                    "status" => 0
                                ],"token = '$email_token'");
                                $update_token_result = $paperweight->query($update_email_token);
                                //if($update_token_result != null && $update_token_result->is_row_affected()){}

                                $result = getOKStatus();
                                $result["user_type"] = $network_role;
                            }

                        }

                    }
                    else{
                        //invitation acceptance for non registered agents is NOT Supported from here
                    }

                }
                elseif ($network_role == NETWORK_ROLE_MANAGER){
                    $registration = isClientRegistered($email,$paperweight);
                    if (empty($registration)){
                        //if the client is not registered

                        $manager_password = text_clean($data["password"]);
                        $provided_password = encryptPassword($manager_password);

                        $signup_success = false;

                        $user_type = USER_TYPE_CLIENT;
                        $user_active = STATE_ACTIVE;
                        $user_is_approved = VERIFIED;
                        $email_is_verified = VERIFIED;
                        $current_time = getCurrentTime();
                        $user_ref_id = generateUserReferenceId();
                        $relationship_id = generateNumericId();

                        $email_token = $row["email_token"];
                        $network_id = $row["network_id"];
                        $permission_list = $row["permission_list"];


                        if (!empty($email) && !empty($manager_password)){
                            $add_user = get_insert_query(TABLE_USERS,[
                                "user_ref_id" => $user_ref_id,
                                "user_email" => $email,
                                "user_password" => $provided_password,
                                "user_screen_name" => $email,
                                "user_type" => $user_type,
                                "user_email_verified" => $email_is_verified,
                                "user_active" => $user_active,
                                "user_regdate" => $current_time,
                                "user_is_approved" => $user_is_approved
                            ]);
                            $add_user_result = $paperweight->query($add_user);

                            if($add_user_result != null && $add_user_result->is_row_affected()){
                                $new_user_id = $add_user_result->insert_id();

                                $add_network_rel = get_insert_query(TABLE_NETWORK_RELATIONSHIP,[
                                    "relationship_id" => $relationship_id,
                                    "network_id" => $network_id,
                                    "network_role" => $network_role,
                                    "update_time" => $current_time,
                                    "permission_json" => $permission_list,
                                    "user_id" => $new_user_id
                                ]);
                                $add_network_rel_result = $paperweight->query($add_network_rel);

                                if($add_network_rel_result != null && $add_network_rel_result->is_row_affected()){

                                    $update_invite_code = get_update_query(TABLE_INVITE_CODE,[
                                        "update_time" => $current_time,
                                        "accepted_time" => $current_time,
                                        "is_accepted" => 1,
                                        "user_id" => $new_user_id,
                                        "invitation_state" => 0
                                    ],"invitation_code = '$invitation_code' and email_token = '$token'");
                                    $update_code_result = $paperweight->query($update_invite_code);
                                    if($update_code_result != null && $update_code_result->is_row_affected()){

                                        $update_email_token = get_update_query(TABLE_EMAIL_TOKEN,[
                                            "status" => 0
                                        ],"token = '$email_token'");
                                        $update_token_result = $paperweight->query($update_email_token);
                                        //if($update_token_result != null && $update_token_result->is_row_affected()){}

                                        $login_data = triggerRawLogin($new_user_id, $paperweight);
                                        if (!empty($login_data)){

                                            $result = getOKStatus();
                                            $result["user_type"] = $network_role;
                                            $result["user_id"] = $user_id;
                                            $result["login_token"] = $login_data["login_token"];

                                        }

                                    }

                                }

                            }

                        }

                    }
                }

            }
        }

        /*$res = '{
            "status": "OK",
            "user_type": "net_manager",
            "user_id": "125", 
            "login_token": "52956179" 
        }';*/


        echo json_export($result);

    }

    //todo - 99% - test
    if ($action == "reject_invitation"){
        $data = json_decode($param_json, true);

        $token = text_clean($data["token"]);
        $invitation_code = text_clean($data["invitation_code"]);

        $result = getErrorStatus(ERROR_MSG_INVALID_TOKEN);

        $verified = VERIFIED;

        $query_invite = "select * from " . TABLE_INVITE_CODE . " where invitation_code = '$invitation_code' and invitation_state = '$verified' and email_token = '$token'";
        $invite_result = $paperweight->query($query_invite);

        if($invite_result != null && $invite_result->is_row_found()){
            if ($row = $invite_result->fetch_array()){
                $email = $row["email"];
                $network_role = $row["network_role"];

                $current_time = getCurrentTime();

                //update invite code
                $update_invite_code = get_update_query(TABLE_INVITE_CODE,[
                    "update_time" => $current_time,
                    "rejected_time" => $current_time,
                    "is_rejected" => 1,
                    "invitation_state" => 0
                ],"invitation_code = '$invitation_code' and email_token = '$token'");
                $update_code_result = $paperweight->query($update_invite_code);
                if($update_code_result != null && $update_code_result->is_row_affected()){
                    $update_email_token = get_update_query(TABLE_EMAIL_TOKEN,[
                        "status" => 0
                    ],"token = '$token'");
                    $update_token_result = $paperweight->query($update_email_token);
                    //if($update_token_result != null && $update_token_result->is_row_affected()){}

                    $result = getOKStatus();
                }

            }
        }

        /*$res = '{
              "status": "OK",
              "user_type": "net_commander",
              "user_id": "125",
              "login_token": "52956179"
        }';*/


        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "get_agent_invitation_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        //$email_list = text_clean($data["email_list"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getOKStatus();

            $invite_list = array();

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $role_collector = NETWORK_ROLE_COLLECTOR;
                $invite_state = VERIFIED;

                $net_rel_query = "select * from " . TABLE_INVITE_CODE . " where creator_network_id = '$network_id' and network_role = '$role_collector' and invitation_state = '$invite_state' and is_public = '0'";
                $net_rel_result = $paperweight->query($net_rel_query);
                if ($net_rel_result != null && $net_rel_result->is_row_found()){
                    while ($row_rel = $net_rel_result->fetch_array()){

                        $group_list = array();

                        if (empty($row_rel["group_list"])){
                            $group_list = array();
                        }
                        else{
                            try {
                                $new_group = array();

                                $group_list = json_decode($row_rel["group_list"],true);
                                $index = 1;

                                if (!empty($group_list)){
                                    foreach ($group_list as $item) {
                                        $arr = array();
                                        $arr["group_id"] = $item;
                                        $arr["group_name"] = "Community " . $index;

                                        $index++;

                                        $new_group[] = $arr;
                                    }
                                }

                                $group_list = $new_group;
                            }
                            catch (Exception $ex){
                                $group_list = array();
                            }
                        }

                        $invite_data = array();
                        $invite_data["invitation_code"] = $row_rel["invitation_code"];
                        $invite_data["email"] = $row_rel["email"];
                        $invite_data["comment"] = $row_rel["comment"];
                        $invite_data["group_list"] = $group_list;

                        $invite_list[] = $invite_data;

                    }
                }

            }

            $result["pending_invitation"] = $invite_list;


            /*$res = '{
              "status": "OK",
              "pending_invitation": [
                {
                  "invitation_code": "HFJG76FGHD874HK",
                  "email": "kevin.s@queritel.com",
                  "comment": "No Comment",
                  "group_list": [
                    {
                      "group_id": "HFJG76FGHD874HK8hfjs8dge5",
                      "group_name": "Collection Group"
                    },
                    {
                      "group_id": "KFHDIU765H4HCHFh653gddsgGHSLJSgdS",
                      "group_name": "Collection Group 2"
                    }
                  ]
                },
                {
                  "invitation_code": "KFHDIU765H4HCHF",
                  "email": "zen.des@queritel.com",
                  "comment": "No Comment",
                  "group_list": [
                    {
                      "group_id": "HFJG76FGHD874HK8hfjs8dge5",
                      "group_name": "Collection Group"
                    },
                    {
                      "group_id": "KFHDIU765H4HCHFh653gddsgGHSLJSgdS",
                      "group_name": "Collection Group 2"
                    }
                  ]
                }
              ]
            }';*/

            //echo json_export($result);
        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);

    }

    //todo - 99% - test
    if ($action == "get_manager_invitation_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        //$email_list = text_clean($data["email_list"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getOKStatus();

            $invite_list = array();

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $role = NETWORK_ROLE_MANAGER;
                $invite_state = VERIFIED;

                $net_rel_query = "select * from " . TABLE_INVITE_CODE . " where creator_network_id = '$network_id' and network_role = '$role' and invitation_state = '$invite_state' and is_public = '0'";
                $net_rel_result = $paperweight->query($net_rel_query);
                if ($net_rel_result != null && $net_rel_result->is_row_found()){
                    while ($row_rel = $net_rel_result->fetch_array()){

                        $permission_list = array();

                        if (empty($row["permission_list"])){
                            $permission_list = array();
                        }
                        else{
                            try {
                                $new_perm = array();

                                $permission_list = json_decode($row["permission_list"],true);

                                if (!empty($permission_list)){
                                    foreach($permission_list as $item) {
                                        $arr = array();
                                        $arr["permission_id"] = $item;
                                        $arr["permission_name"] = $item; //remove id

                                        $new_perm[] = $arr;
                                    }
                                }

                                $permission_list = $new_perm;
                            }
                            catch (Exception $ex){
                                $permission_list = array();
                            }
                        }

                        $invite_data = array();
                        $invite_data["invitation_code"] = $row_rel["invitation_code"];
                        $invite_data["email"] = $row_rel["email"];
                        $invite_data["comment"] = $row_rel["comment"];
                        $invite_data["permission_list"] = $permission_list;

                        $invite_list[] = $invite_data;

                    }
                }
            }

            $result["pending_invitation"] = $invite_list;

            /*$res = '{
              "status": "OK",
              "pending_invitation": [
                {
                  "invitation_code": "HFJG76FGHD874HK",
                  "email": "kevin.s@queritel.com",
                  "comment": "No Comment",
                  "permission_list": [
                    {
                      "permission_id": "access_view_messages",
                      "permission_name": "Messages"
                    },
                    {
                      "permission_id": "access_quest_creation",
                      "permission_name": "Quest Creation"
                    },
                    {
                      "permission_id": "access_quest_management",
                      "permission_name": "Quest Management"
                    }
                  ]
                },
                {
                  "invitation_code": "KFHDIU765H4HCHF",
                  "email": "zen.des@queritel.com",
                  "comment": "No Comment",
                  "permission_list": [
                    {
                      "permission_id": "access_view_messages",
                      "permission_name": "Messages"
                    },
                    {
                      "permission_id": "access_quest_creation",
                      "permission_name": "Quest Creation"
                    },
                    {
                      "permission_id": "access_quest_management",
                      "permission_name": "Quest Management"
                    }
                  ]
                }
              ]
            }';*/

            //echo json_export($result);
        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }

    //todo - 50% - store access in database
    if ($action == "get_supported_access"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $email_list = text_clean($data["email_list"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                  "status": "OK",
                  "permission_list": [
                    {
                      "permission_id": "access_view_messages",
                      "permission_name": "Messages"
                    },
                    {
                      "permission_id": "access_view_dashboard",
                      "permission_name": "Data Dashboard"
                    },
                    {
                      "permission_id": "access_quest_creation",
                      "permission_name": "Quest Creation"
                    },
                    {
                      "permission_id": "access_quest_management",
                      "permission_name": "Quest Management"
                    },
                    {
                      "permission_id": "access_team_management",
                      "permission_name": "Team Management"
                    },
                    {
                      "permission_id": "access_network_management",
                      "permission_name": "Network Management"
                    }
                  ]
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }

    //todo - 99% test
    if ($action == "change_password"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $old_password = text_clean($data["password"]);
        $new_password = text_clean($data["new_password"]);

        //todo : API Debug
        debugAPIResponse("change_password",json_encode($data,JSON_PRETTY_PRINT));



        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getErrorStatus(ERROR_MSG_INVALID_CRED);

            if (encryptPassword($old_password) == $client->get_encrytedPassword()){

                $password_provided = encryptPassword($new_password);

                $update_user = get_update_query(TABLE_USERS,[
                    "user_password" => $password_provided
                ],"user_id = '$user_id'");
                $update_user_result = $paperweight->query($update_user);
                if($update_user_result != null && $update_user_result->is_row_affected()){
                    $result = getOKStatus();
                }

            }

        }

        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "revoke_invitation") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $invitation_codes = $data["invitation_codes"]; //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                if (!empty($invitation_codes)){
                    if (count($invitation_codes) > 0){
                        for ($i = 0; $i < count($invitation_codes); $i++){
                            $invitation_code = text_clean($invitation_codes[$i]);

                            $verified = VERIFIED;

                            $query_invite = "select * from " . TABLE_INVITE_CODE . " where invitation_code = '$invitation_code' and invitation_state = '$verified'";
                            $invite_result = $paperweight->query($query_invite);

                            if($invite_result != null && $invite_result->is_row_found()){
                                if ($row = $invite_result->fetch_array()){
                                    $email_token = $row["email_token"];
                                    $current_time = getCurrentTime();

                                    //update invite code
                                    $update_invite_code = get_update_query(TABLE_INVITE_CODE,[
                                        "update_time" => $current_time,
                                        "invitation_state" => 0
                                    ],"invitation_code = '$invitation_code'");
                                    $update_code_result = $paperweight->query($update_invite_code);
                                    if($update_code_result != null && $update_code_result->is_row_affected()){
                                        $update_email_token = get_update_query(TABLE_EMAIL_TOKEN,[
                                            "status" => 0
                                        ],"token = '$email_token'");
                                        $update_token_result = $paperweight->query($update_email_token);
                                        //if($update_token_result != null && $update_token_result->is_row_affected()){}

                                        $result = getOKStatus();
                                    }
                                }

                            }
                        }
                    }
                }
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

        }

        echo json_export($result);
    }




    //todo - 50% - replace with key based update
    if ($action == "update_user_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();


        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            //$result = getErrorStatus(ERROR_MSG_NOT_FOUND);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_role = $client_network["network_role"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $first_name =  text_clean($data["first_name"]);
                $last_name =  text_clean($data["last_name"]);
                $country_code =  text_clean($data["country_code"]);
                $region =  text_clean($data["region"]);
                $city =  text_clean($data["city"]);
                $phone_number =  text_clean($data["phone_number"]);

                $update_user = get_update_query(TABLE_USERS,[
                    "user_first_name" => $first_name,
                    "user_last_name" => $last_name,
                    "country_code" => $country_code,
                    "location_state" => $region,
                    "location_city" => $city,
                    "phone_number" => $phone_number
                ],"user_id = '$user_id'");
                $update_user_result = $paperweight->query($update_user);
                if($update_user_result != null && $update_user_result->is_row_affected()){

                    $result = getOKStatus();
                }

            }

            /*
                user_data.occupation = result_obj["occupation"];
                user_data.education = result_obj["education"];
                user_data.employment_status = result_obj["employment_status"];
                user_data.marital_status = result_obj["marital_status"];
                user_data.phone_model = result_obj["phone_model"];
            */

            /*$user_data["fname"] = stringCase($client->get_firstName(),STRING_CASE_CAP_FIRST);
            $user_data["lname"] = stringCase($client->get_lastName(),STRING_CASE_CAP_FIRST);
            $user_data["user_name"] = $client->get_screenName();
            $user_data["email"] = $client->get_email();
            $user_data["user_ref"] = $client->getUserRefId();
            $user_data["gender"] = $client->get_gender();
            $user_data["reg_date"] = $client->get_registrationDate();
            $user_data["phone_number"] = $client->get_phoneNumber();
            $user_data["location_address"] = $client->getLocationAddress();
            $user_data["location_city"] = $client->get_locationCity();
            $user_data["location_state"] = $client->get_locationState();
            $user_data["country_name"] = $client->get_locationCountry();
            $user_data["country_code"] = $client->getLocationCountryCode();
            $user_data["date_of_birth"] = $client->getDateOfBirth();
            $user_data["language_code"] = $client->getLanguageCode();
            $user_data["occupation"] = $client->getOccupation();
            $user_data["education"] = $client->getEducation();
            $user_data["ethnicity"] = $client->getEthnicity();
            $user_data["marital_status"] = $client->getMaritalStatus();
            $user_data["employment_status"] = $client->getEmploymentStatus();
            $user_data["employment_industry"] = $client->getEmploymentIndustry();
            $user_data["profile_lock"] = true; //$client->getProfileLock();

            $result["user_data"] = $user_data;*/

        }

        //echo json_export($result);

        /*$res = '{
            "status": "OK",
            "organization": "Meta Zandaria",
            "user_type" : "net_commander",
            "user_data": {
                "first_name": "Dovageris",
                "last_name": "Simms",
                "email": "dov.simms@queritel.com",
                "country_code": "JM",
                "region": "Kingston",
                "city": "Kingston",
                "phone_number": "18765555555",
                "reg_date": "2021-11-15 09:07:45"
              }
        }';*/

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }

    //todo - 95% - in progress (extra properties to activate)
    if ($action == "get_user_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_role = $client_network["network_role"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $user_data = array();
                $user_data["first_name"] = $client->get_firstName();
                $user_data["last_name"] = $client->get_lastName();
                $user_data["user_ref_id"] = $client->getUserRefId();
                $user_data["email"] = $client->get_email();
                $user_data["country_code"] = $client->getLocationCountryCode();
                $user_data["region"] = $client->get_locationState();
                $user_data["city"] = $client->get_locationCity();
                $user_data["phone_number"] = $client->get_phoneNumber();
                $user_data["reg_date"] = $client->get_registrationDate();

                $user_data["country_name"] = "";
                $user_data["postal_code"] = "";
                $user_data["address"] = "";

                $result = getOKStatus();
                $result["organization"] = $org_name;
                $result["user_type"] = $network_role;
                $result["user_data"] = $user_data;

            }

            /*
                user_data.occupation = result_obj["occupation"];
                user_data.education = result_obj["education"];
                user_data.employment_status = result_obj["employment_status"];
                user_data.marital_status = result_obj["marital_status"];
                user_data.phone_model = result_obj["phone_model"];
            */

            /*$user_data["fname"] = stringCase($client->get_firstName(),STRING_CASE_CAP_FIRST);
            $user_data["lname"] = stringCase($client->get_lastName(),STRING_CASE_CAP_FIRST);
            $user_data["user_name"] = $client->get_screenName();
            $user_data["email"] = $client->get_email();
            $user_data["user_ref"] = $client->getUserRefId();
            $user_data["gender"] = $client->get_gender();
            $user_data["reg_date"] = $client->get_registrationDate();
            $user_data["phone_number"] = $client->get_phoneNumber();
            $user_data["location_address"] = $client->getLocationAddress();
            $user_data["location_city"] = $client->get_locationCity();
            $user_data["location_state"] = $client->get_locationState();
            $user_data["country_name"] = $client->get_locationCountry();
            $user_data["country_code"] = $client->getLocationCountryCode();
            $user_data["date_of_birth"] = $client->getDateOfBirth();
            $user_data["language_code"] = $client->getLanguageCode();
            $user_data["occupation"] = $client->getOccupation();
            $user_data["education"] = $client->getEducation();
            $user_data["ethnicity"] = $client->getEthnicity();
            $user_data["marital_status"] = $client->getMaritalStatus();
            $user_data["employment_status"] = $client->getEmploymentStatus();
            $user_data["employment_industry"] = $client->getEmploymentIndustry();
            $user_data["profile_lock"] = true; //$client->getProfileLock();

            $result["user_data"] = $user_data;*/

        }

        //echo json_export($result);

        /*$res = '{
            "status": "OK",
            "organization": "Meta Zandaria",
            "user_type" : "net_commander",
            "user_data": {
                "first_name": "Dovageris",
                "last_name": "Simms",
                "email": "dov.simms@queritel.com",
                "country_code": "JM",
                "region": "Kingston",
                "city": "Kingston",
                "phone_number": "18765555555",
                "reg_date": "2021-11-15 09:07:45"
              }
        }';*/

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }

    //todo - 100% - extern
    if ($action == "get_dashboard_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        //$email_list = text_clean($data["email_list"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getOKStatus();

            $dashboard_list = array();

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $role_collector = NETWORK_ROLE_COLLECTOR;
                $invite_state = VERIFIED;

                $dash_database = new Database(DASHBOARD_DB_USERNAME,DASHBOARD_DB_PASSWORD,DASHBOARD_DB_NAME);


                $net_rel_query = "select * from " . TABLE_CLIENT_DASHBOARD . " where client_id = '$user_id'";
                $net_rel_result = $dash_database->query($net_rel_query);

                if ($net_rel_result != null && $net_rel_result->is_row_found()){
                    while ($row = $net_rel_result->fetch_array()){
                        $dashboard_code = $row["dashboard_code"];

                        $dashboard = array();
                        $dashboard["dashboard_code"] = $dashboard_code;
                        $dashboard["dashboard_name"] = $row["dashboard_name"];
                        $dashboard["dashboard_url"] = get_dashboard_lnk(intval($dashboard_code));

                        $dashboard_list[] = $dashboard;
                    }
                }



                /*$dashboard_code = 2;
                $dashboard = array();
                $dashboard["dashboard_code"] = $dashboard_code;
                $dashboard["dashboard_name"] = "Fuel Tracking";
                $dashboard["dashboard_url"] = get_dashboard_lnk($dashboard_code);

                $dashboard_list[] = $dashboard;*/

                /*{
                  "status": "OK",
                  "dashboard_list": [
                    {
                      "dashboard_code": "5",
                      "dashboard_name": "Gas Price",
                      "dashboard_url": "https://chartally.com"
                    }
                  ]
                }*/
            }

            $result["dashboard_list"] = $dashboard_list;

        }

        echo json_export($result);

    }

    //todo - 100% - extern
    if ($action == "get_dashboard_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $dashboard_code = text_clean($data["dashboard_code"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getErrorStatus(ERROR_MSG_NOT_FOUND);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $role_collector = NETWORK_ROLE_COLLECTOR;
                $invite_state = VERIFIED;


                $dash_database = new Database(DASHBOARD_DB_USERNAME,DASHBOARD_DB_PASSWORD,DASHBOARD_DB_NAME);

                $net_rel_query = "select * from " . TABLE_CLIENT_DASHBOARD . " where client_id = '$user_id' and dashboard_code = '$dashboard_code'";
                $net_rel_result = $dash_database->query($net_rel_query);

                if ($net_rel_result != null && $net_rel_result->is_row_found()){
                    if ($row = $net_rel_result->fetch_array()){
                        //$dashboard_code = $row["dashboard_code"];

                        $dashboard = array();
                        $dashboard["dashboard_code"] = $dashboard_code;
                        $dashboard["dashboard_name"] = $row["dashboard_name"];
                        $dashboard["dashboard_url"] = get_dashboard_lnk(intval($dashboard_code));

                        $result = getOKStatus();
                        $result["dashboard_data"] = $dashboard;
                    }
                }


                //$result = getOKStatus();

                /*$dashboard_code = 2;
                $dashboard = array();
                $dashboard["dashboard_code"] = $dashboard_code;
                $dashboard["dashboard_name"] = "Gas Price";
                $dashboard["dashboard_url"] = get_dashboard_lnk($dashboard_code);

                $result["dashboard_data"] = $dashboard;*/
            }



        }

        echo json_export($result);

    }




    //todo - 100% - test
    if ($action == "create_category"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $category_name = text_clean($data["category_name"]);
        $category_description = text_clean($data["category_description"]);
        $country_code = text_clean($data["country_code"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $category_id = generate_unique_id(UNIQUE_PRODUCT_CATEGORY);
                $creation_time = getCurrentTime();

                $add_category = get_insert_query(TABLE_PRODUCT_CATEGORY, [
                    "category_id" => $category_id,
                    "category_name" => $category_name,
                    "category_description" => $category_description,
                    "country_code" => $country_code,
                    "network_id" => $network_id,
                    "creator_id" => $user_id,
                    "creation_time" => $creation_time
                ]);
                $add_category_res = $paperweight->query($add_category);
                if($add_category_res != null && $add_category_res->is_row_affected()){

                    $result = getOKStatus();
                    $result["category_id"] = $category_id;

                }

            }

        }

        echo json_export($result);
    }

    //todo - 100% - test
    if ($action == "remove_category_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK"
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "remove_category"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $category_id = text_clean($data["category_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                $del_category = "delete from " . TABLE_PRODUCT_CATEGORY . " where category_id = '$category_id' and network_id = '$network_id'";
                $del_category_res = $paperweight->query($del_category);
                if($del_category_res != null && $del_category_res->is_row_affected()){
                    $result = getOKStatus();
                }

            }
        }

        echo json_export($result);
    }

    //todo - 100% - test
    if ($action == "get_category_list_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $result = getOKStatus();

            }


            $res = '{
              "status": "OK",
              "category_list": [
                {
                  "category_id": "category-hfgdklg-3465847-yrhekid",
                  "category_name": "Family Products",
                  "category_description": "Everyday products used within the household",
                  "country_code": "JM"
                },
                {
                  "category_id": "category-gdfsljg-4536533-hfgdtyr",
                  "category_name": "General Goods",
                  "category_description": "Products ranging from home care to food",
                  "country_code": "JM"
                }
              ]
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "get_category_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $category_list = array();

                $get_category = "select * from " . TABLE_PRODUCT_CATEGORY . " where network_id = '$network_id'";
                $get_category_result = $paperweight->query($get_category);

                if($get_category_result != null && $get_category_result->is_row_found()){
                    while($row = $get_category_result->fetch_array()){

                        $category = array();
                        $category["category_id"] = $row["category_id"];
                        $category["category_name"] = $row["category_name"];
                        $category["category_description"] = $row["category_description"];
                        $category["country_code"] = $row["country_code"];
                        $category["creation_time"] = $row["creation_time"];

                        $category_list[] = $category;

                    }
                }

                $result = getOKStatus();
                $result["category_list"] = $category_list;

            }

        }

        echo json_export($result);
    }

    //todo - 100% - test
    if ($action == "get_category_data_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "category_data": {
                "category_id": "category-hfgdklg-3465847-yrhekid",
                "category_name": "Family Products",
                "category_description": "Everyday products used within the household",
                "country_code": "JM"
              }
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "get_category_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $category_id = text_clean($data["category_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_NOT_FOUND);

                $get_category = "select * from " . TABLE_PRODUCT_CATEGORY . " where category_id = '$category_id' and network_id = '$network_id'";
                $get_category_result = $paperweight->query($get_category);

                if($get_category_result != null && $get_category_result->is_row_found()){
                    if($row = $get_category_result->fetch_array()){

                        $category["category_id"] = $row["category_id"];
                        $category["category_name"] = $row["category_name"];
                        $category["category_description"] = $row["category_description"];
                        $category["country_code"] = $row["country_code"];
                        $category["creation_time"] = $row["creation_time"];

                        $result = getOKStatus();
                        $result["category_data"] = $category;

                    }
                }

            }

        }

        echo json_export($result);
    }

    //todo - 100% - test
    if ($action == "add_product_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK"
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "add_product"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $category_id = text_clean($data["category_id"]);
        $catalog_id = text_clean($data["catalog_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $product_id = generate_unique_id(UNIQUE_PRODUCT_ITEM);
                $creation_time = getCurrentTime();

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                $category_data = getProductCategory($category_id,$paperweight);
                $catalog_item = get_catalog_item($catalog_id);

                if (!empty($category_data) && !empty($catalog_item)){
                    $add_product = get_insert_query(TABLE_PRODUCT_ITEM, [
                        "product_id" => $product_id,
                        "category_id" => $category_id,
                        "country_code" => $category_data["country_code"],
                        "network_id" => $network_id,
                        "creator_id" => $user_id,
                        "creation_time" => $creation_time,
                        "product_name" => $catalog_item["product_name"],
                        "brand" => $catalog_item["brand"],
                        "unit_value" => $catalog_item["unit_value"],
                        "unit_label" => $catalog_item["unit_label"],
                        "file_name" => $catalog_item["image_name"],
                        "catalog_id" => $catalog_item["catalog_id"]
                    ]);
                    $add_product_res = $paperweight->query($add_product);
                    if($add_product_res != null && $add_product_res->is_row_affected()){

                        $result = getOKStatus();

                    }
                }

            }

        }

        echo json_export($result);
    }

    //todo - 100% - test
    if ($action == "get_product_list_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "product_list": [
                {
                  "product_id": "pid-hgjffh-958659-ghdjhd",
                  "product_name": "Salmon Porcion",
                  "brand": "Marine Harvest By Mowi",
                  "unit_value": 180,
                  "unit_label": "gr",
                  "image_url": "https://source.queritel.com/figozo/uploads/store/product/718023.jpg",
                  "catalog_id": "catalog-bnteelv-9984020-ezgjuzf"
                },
                {
                  "product_id": "pid-jghffj-853845-fdoshhf",
                  "product_name": "Corvina Filete",
                  "brand": "Pesca Austral",
                  "unit_value": 400,
                  "unit_label": "gr",
                  "image_url": "https://source.queritel.com/figozo/uploads/store/product/612446.jpg",
                  "catalog_id": "catalog-fnnsoug-4178072-ihzackt"
                },
                {
                  "product_id": "pid-gdhfgd-375630-gdffla",
                  "product_name": "Carpaccio De Pulpo Caja",
                  "brand": "South Wind",
                  "unit_value": 100,
                  "unit_label": "gr",
                  "image_url": "https://source.queritel.com/figozo/uploads/store/product/544548.jpg",
                  "catalog_id": "catalog-zjxmgwk-8458688-onotpeo"
                }
              ]
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "get_product_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $category_id = text_clean($data["category_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $product_list = array();

                $get_product = "select * from " . TABLE_PRODUCT_ITEM . " where network_id = '$network_id' and category_id = '$category_id' ";
                $get_product_result = $paperweight->query($get_product);

                if($get_product_result != null && $get_product_result->is_row_found()){
                    while($row = $get_product_result->fetch_array()){

                        $product = array();
                        $product["product_id"] = $row["product_id"];
                        $product["product_name"] = $row["product_name"];
                        $product["brand"] = $row["brand"];
                        $product["unit_value"] = intval($row["unit_value"]);
                        $product["unit_label"] = $row["unit_label"];
                        $product["image_url"] = CATALOG_ITEM_ROOT .  $row["file_name"];
                        $product["catalog_id"] = $row["catalog_id"];

                        $product_list[] = $product;

                    }
                }

                $result = getOKStatus();
                $result["product_list"] = $product_list;

            }

        }

        echo json_export($result);
    }

    //todo - 100% - test
    if ($action == "remove_product_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK"
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "remove_product"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $category_id = text_clean($data["category_id"]);
        $product_id = text_clean($data["product_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                $del_product = "delete from " . TABLE_PRODUCT_ITEM . " where category_id = '$category_id' and product_id = '$product_id' and network_id = '$network_id'";
                $del_product_res = $paperweight->query($del_product);
                if($del_product_res != null && $del_product_res->is_row_affected()){
                    $result = getOKStatus();
                }

            }

        }

        echo json_export($result);
    }


    //todo - 100% - test - extern
    if ($action == "get_catalog_list_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
            "status": "OK",
            "last_index": 25,
            "catalog_list": [
                {
                    "catalog_id": "catalog-bnteelv-9984020-ezgjuzf",
                    "product_name": "Salmon Porcion",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Marine Harvest By Mowi",
                    "unit_value": 180,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/718023.jpg",
                    "image_name": "718023.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-zcsyzxs-7588239-hmxbemn",
                    "product_name": "Salmón Mediterráneo",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Marine Harvest By Mowi",
                    "unit_value": 180,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/736262.jpg",
                    "image_name": "736262.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-peripva-6251245-knkwrje",
                    "product_name": "Salmón Sureño",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Marine Harvest By Mowi",
                    "unit_value": 180,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/736260.jpg",
                    "image_name": "736260.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-lqqtnzs-2180136-qgiykhk",
                    "product_name": "Trucha Natural",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Marine Harvest By Mowi",
                    "unit_value": 180,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/736261.jpg",
                    "image_name": "736261.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-vzmglrl-6947860-ejtaobj",
                    "product_name": "Albacora Filete",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612440.jpg",
                    "image_name": "612440.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-nzhnzqx-1567887-tecuvbx",
                    "product_name": "Atun Steak Trozos",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612456.jpg",
                    "image_name": "612456.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-lxsmztk-8266055-oaywkcn",
                    "product_name": "Congrio Dorado Filete",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612444.jpg",
                    "image_name": "612444.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-fnnsoug-4178072-ihzackt",
                    "product_name": "Corvina Filete",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612446.jpg",
                    "image_name": "612446.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-rykmjdn-7567583-orcjxpf",
                    "product_name": "Merluza Austral Filete",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612442.jpg",
                    "image_name": "612442.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-fpoexzi-7261648-gfeuerv",
                    "product_name": "Merluza Gayi Filete",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612434.jpg",
                    "image_name": "612434.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-zdgcwcy-7548045-ejicabd",
                    "product_name": "Ostion Media Concha",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612474.jpg",
                    "image_name": "612474.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-bklrner-4618126-ijhdrdt",
                    "product_name": "Pangasius Filete",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612436.jpg",
                    "image_name": "612436.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-pwawobg-7013501-obvrjyf",
                    "product_name": "Reineta Filete Congelado",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612432.jpg",
                    "image_name": "612432.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-oufkbip-2678703-rlkibli",
                    "product_name": "Salmon En Cubitos",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/674455.jpg",
                    "image_name": "674455.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-homsgai-4209727-gmszffs",
                    "product_name": "Salmon Filete",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612448.jpg",
                    "image_name": "612448.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-igkcrll-6618295-ywhywou",
                    "product_name": "Tilapia Filete",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Pesca Austral",
                    "unit_value": 400,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/612454.jpg",
                    "image_name": "612454.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-zszjdsr-7265275-qxyttvv",
                    "product_name": "Pechuga De Pollo Apanada",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Receta del Abuelo",
                    "unit_value": 120,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/691250.jpg",
                    "image_name": "691250.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-gldsafa-5518890-guhocpo",
                    "product_name": "Atún en Cubos",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Selección",
                    "unit_value": 250,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/722695.jpg",
                    "image_name": "722695.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-nveurke-6775103-iiksvto",
                    "product_name": "Atún en Medallones",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Selección",
                    "unit_value": 400,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/722696.jpg",
                    "image_name": "722696.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-bzizmol-9826901-mjsvhcq",
                    "product_name": "Salmón Blackene",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Selección",
                    "unit_value": 284,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/739418.jpg",
                    "image_name": "739418.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-mmxbxsd-4579953-crigotz",
                    "product_name": "Salmón Mantequilla y Finas Hierbas",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Selección",
                    "unit_value": 284,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/739417.jpg",
                    "image_name": "739417.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-mjtbbca-4771909-gelnjil",
                    "product_name": "Salmón Teriyaki",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "Selección",
                    "unit_value": 284,
                    "unit_label": "gr",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/739416.jpg",
                    "image_name": "739416.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-kferyfy-4265918-fsiamsz",
                    "product_name": "Almejas Juliana",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "South Wind",
                    "unit_value": 500,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/563109.jpg",
                    "image_name": "563109.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-rgzrqqr-1011569-lntsvyw",
                    "product_name": "Carpaccio De Atún Caja",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "South Wind",
                    "unit_value": 100,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/544547.jpg",
                    "image_name": "544547.jpg",
                    "country_code": "CL"
                },
                {
                    "catalog_id": "catalog-zjxmgwk-8458688-onotpeo",
                    "product_name": "Carpaccio De Pulpo Caja",
                    "category_name": "Carnes Y Mariscos",
                    "brand": "South Wind",
                    "unit_value": 100,
                    "unit_label": "g",
                    "image_url": "https://source.queritel.com/figozo/uploads/store/product/544548.jpg",
                    "image_name": "544548.jpg",
                    "country_code": "CL"
                }
            ]
        }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "get_catalog_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $search_id = text_clean($data["search_id"]);
        $search_limit = text_clean($data["search_limit"]);
        $offset_index = text_clean($data["offset_index"]);

        $filter_list = $data["filter_list"];


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $figozo = new Database(FIGOZO_DB_USERNAME, FIGOZO_DB_PASSWORD, FIGOZO_DB_NAME);

                $catalog_list = array();

                $limit_from = intval($offset_index);
                $row_count = intval($search_limit);
                $items_returned = 0;
                $has_where_clause = false;
                $last_index = 0;


                $sql_query = "select * from " . TABLE_CATALOG . " ";

                //filter check here
                $filter_string = null;
                if (!empty($filter_list)){

                    $country_filter = array();
                    $brand_filter = array();
                    $category_filter = array();
                    $unit_filter = array();

                    foreach ($filter_list as $filter){

                        $filter_type = text_clean($filter["filter_type"]);
                        $filter_mode = text_clean($filter["filter_mode"]);
                        $filter_criteria = text_clean($filter["filter_criteria"]);

                        if ($filter_type == "country_code"){
                            if ($filter_mode == "inc" || $filter_mode == "exc"){
                                $country_filter[$filter_mode][] = $filter_criteria;
                            }
                        }
                        elseif ($filter_type == "category_id"){
                            if ($filter_mode == "inc" || $filter_mode == "exc"){
                                $category_filter[$filter_mode][] = $filter_criteria;
                            }
                        }
                        elseif ($filter_type == "brand_id"){
                            if ($filter_mode == "inc" || $filter_mode == "exc"){
                                $brand_filter[$filter_mode][] = $filter_criteria;
                            }
                        }
                        elseif ($filter_type == "unit_label_id"){
                            if ($filter_mode == "inc" || $filter_mode == "exc"){
                                $unit_filter[$filter_mode][] = $filter_criteria;
                            }
                        }


                    }

                    $country_included = null;
                    $country_excluded = null;
                    $brand_included = null;
                    $brand_excluded = null;
                    $category_included = null;
                    $category_excluded = null;
                    $unit_included = null;
                    $unit_excluded = null;

                    if (!empty($country_filter["inc"])){

                        $country_included = "country_code in (";
                        foreach ($country_filter["inc"] as $criteria){
                            $country_included .= "'$criteria',";
                        }
                        $country_included = rtrim($country_included, ",");
                        $country_included .= ")";
                    }
                    if (!empty($country_filter["exc"])){

                        $country_excluded = "country_code not in (";
                        foreach ($country_filter["exc"] as $criteria){
                            $country_excluded .= "'$criteria',";
                        }
                        $country_excluded = rtrim($country_excluded, ",");
                        $country_excluded .= ")";
                    }
                    if (!empty($brand_filter["inc"])){

                        $brand_included = "brand_id in (";
                        foreach ($brand_filter["inc"] as $criteria){
                            $brand_included .= "'$criteria',";
                        }
                        $brand_included = rtrim($brand_included, ",");
                        $brand_included .= ")";
                    }
                    if (!empty($brand_filter["exc"])){

                        $brand_excluded = "brand_id not in (";
                        foreach ($brand_filter["exc"] as $criteria){
                            $brand_excluded .= "'$criteria',";
                        }
                        $brand_excluded = rtrim($brand_excluded, ",");
                        $brand_excluded .= ")";
                    }
                    if (!empty($category_filter["inc"])){

                        $category_included = "category_id in (";
                        foreach ($category_filter["inc"] as $criteria){
                            $category_included .= "'$criteria',";
                        }
                        $category_included = rtrim($category_included, ",");
                        $category_included .= ")";
                    }
                    if (!empty($category_filter["exc"])){

                        $category_excluded = "category_id not in (";
                        foreach ($category_filter["exc"] as $criteria){
                            $category_excluded .= "'$criteria',";
                        }
                        $category_excluded = rtrim($category_excluded, ",");
                        $category_excluded .= ")";
                    }
                    if (!empty($unit_filter["inc"])){

                        $unit_included = "unit_label_id in (";
                        foreach ($unit_filter["inc"] as $criteria){
                            $unit_included .= "'$criteria',";
                        }
                        $unit_included = rtrim($unit_included, ",");
                        $unit_included .= ")";
                    }
                    if (!empty($unit_filter["exc"])){

                        $unit_excluded = "unit_label_id not in (";
                        foreach ($unit_filter["exc"] as $criteria){
                            $unit_excluded .= "'$criteria',";
                        }
                        $unit_excluded = rtrim($unit_excluded, ",");
                        $unit_excluded .= ")";
                    }


                    //$has_where_clause = true;
                    $filter_string = null;

                    if (!empty($country_included)){
                        if (!empty($filter_string)){
                            $filter_string .= "and ";
                        }

                        $filter_string .= "($country_included) ";

                    }
                    if (!empty($country_excluded)){
                        if (!empty($filter_string)){
                            $filter_string .= "and ";
                        }

                        $filter_string .= "($country_excluded) ";

                    }
                    if (!empty($brand_included)){
                        if (!empty($filter_string)){
                            $filter_string .= "and ";
                        }

                        $filter_string .= "($brand_included) ";

                    }
                    if (!empty($brand_excluded)){
                        if (!empty($filter_string)){
                            $filter_string .= "and ";
                        }

                        $filter_string .= "($brand_excluded) ";

                    }
                    if (!empty($category_included)){
                        if (!empty($filter_string)){
                            $filter_string .= "and ";
                        }

                        $filter_string .= "($category_included) ";

                    }
                    if (!empty($category_excluded)){
                        if (!empty($filter_string)){
                            $filter_string .= "and ";
                        }

                        $filter_string .= "($category_excluded) ";

                    }
                    if (!empty($unit_included)){
                        if (!empty($filter_string)){
                            $filter_string .= "and ";
                        }

                        $filter_string .= "($unit_included) ";

                    }
                    if (!empty($unit_excluded)){
                        if (!empty($filter_string)){
                            $filter_string .= "and ";
                        }

                        $filter_string .= "($unit_excluded) ";

                    }


                    if (!empty($filter_string)){

                        $sql_query .= "where " . $filter_string;

                        $has_where_clause = true;
                    }

                }

                if (!empty($search_id)){
                    if ($has_where_clause){
                        //$sql_query .= "and ((catalog_item_list.name like '%$search_id%') or (catalog_category_list.name like '%$search_id%') or (catalog_brand_list.name like '%$search_id%') or (catalog_unit_list.name like '%$search_id%')) "; //order by `name` asc
                        //$sql_query .= "and ((name like '%$search_id%')) or ((brand_name like '%$search_id%')) "; //order by `name` asc
                        $sql_query .= "and ((name like '%$search_id%')) "; //order by `name` asc
                    }
                    else{
                        //$sql_query .= "where ((catalog_item_list.name like '%$search_id%') or (catalog_category_list.name like '%$search_id%') or (catalog_brand_list.name like '%$search_id%') or (catalog_unit_list.name like '%$search_id%')) "; //order by `name` asc
                        //$sql_query .= "where ((name like '%$search_id%')) or ((brand_name like '%$search_id%')) "; //order by `name` asc
                        $sql_query .= "where ((name like '%$search_id%')) "; //order by `name` asc
                        //$sql_query .= "where ((category_id = '$search_id')) "; //order by `name` asc
                    }
                }

                $sql_query .= "limit $row_count offset $limit_from";

                $sql_query_result = $figozo->query($sql_query);
                if($sql_query_result != null && $sql_query_result->is_row_found()){
                    while($row = $sql_query_result->fetch_array()){
                        $catalog_item = array();

                        $brand = get_catalog_brand($row["brand_id"],$figozo);
                        $category = get_catalog_category($row["category_id"],$figozo);
                        $unit_label = get_catalog_label($row["unit_label_id"],$figozo);

                        $catalog_item["catalog_id"] = $row["catalog_id"];
                        $catalog_item["product_name"] = $row["name"];
                        $catalog_item["category_name"] = $category;
                        $catalog_item["brand"] = $brand;
                        $catalog_item["unit_value"] = intval($row["unit_value"]);
                        $catalog_item["unit_label"] = $unit_label;
                        $catalog_item["image_url"] = CATALOG_ITEM_ROOT .  $row["file_name"];
                        $catalog_item["image_name"] = $row["file_name"];
                        $catalog_item["country_code"] = $row["country_code"];
                        //$catalog_item["in_store"] = catalog_is_in_store($row["catalog_id"],$catalog,$figozo);

                        $catalog_list[] = $catalog_item;

                        $items_returned++;
                    }

                    $last_index = (intval($offset_index) + intval($items_returned));


                }


                $result = getOKStatus();
                $result["last_index"] = $last_index;
                $result["catalog_list"] = $catalog_list;


            }

        }

        echo json_export($result);
    }

    //todo - 100% - test - extern
    if ($action == "cat_brand_list_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                "status": "OK",
                "brand_list": [
                    {
                        "brand_name": "1733 + Coca Cola",
                        "brand_id": "brand-izjufcm-8775525-xmfnwmu"
                    },
                    {
                        "brand_name": "Alto del Carmen + Cocacola",
                        "brand_id": "brand-kriodpi-8875847-wlycvyl"
                    },
                    {
                        "brand_name": "Coca Cola",
                        "brand_id": "brand-gjogufw-7034316-mzkjyne"
                    },
                    {
                        "brand_name": "Coca-Cola",
                        "brand_id": "brand-vojmsld-9548502-vgqnmor"
                    },
                    {
                        "brand_name": "Cocalan",
                        "brand_id": "brand-hshdaxf-9148898-nytywrk"
                    }
                ]
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "cat_brand_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $search_id = text_clean($data["search_id"]);
        $country_code = text_clean($data["country_code"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $figozo = new Database(FIGOZO_DB_USERNAME, FIGOZO_DB_PASSWORD, FIGOZO_DB_NAME);
                $brand_list = array();
                if (!empty($search_id)){
                    $sql_query = "select * from " . TABLE_CATALOG_BRAND . " where (`name` like '%$search_id%')"; // order by `name` asc
                }
                else{
                    $sql_query = "select * from " . TABLE_CATALOG_BRAND . " order by `name` asc";
                }

                $sql_query_result = $figozo->query($sql_query);
                if($sql_query_result != null && $sql_query_result->is_row_found()){
                    while($row = $sql_query_result->fetch_array()){
                        $brand_name = $row["name"];
                        $brand_id = $row["brand_id"];

                        $brand = array();
                        $brand["brand_name"] = $brand_name;
                        $brand["brand_id"] = $brand_id;

                        if (is_brand_in_country($brand_id, $country_code, $figozo)) {
                            $brand_list[] = $brand;
                        }

                    }

                }

                $result = getOKStatus();
                $result["brand_list"] = $brand_list;

            }


        }

        echo json_export($result);
    }

    //todo - 100% - test - extern
    if ($action == "cat_unit_list_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                "status": "OK",
                "unit_list": [
                    {
                        "unit_name": "ml",
                        "unit_id": "unit-guuoedx-5277099-psggegv"
                    },
                    {
                        "unit_name": "Ml",
                        "unit_id": "unit-voqrtky-6357892-jfmhado"
                    },
                    {
                        "unit_name": "Multipack",
                        "unit_id": "unit-sobdzym-9819197-dguteop"
                    },
                    {
                        "unit_name": "Metros",
                        "unit_id": "unit-vamqihv-0921709-ddmrage"
                    },
                    {
                        "unit_name": "cm",
                        "unit_id": "unit-mqfrsyd-6815588-kkwifxl"
                    },
                    {
                        "unit_name": "ML",
                        "unit_id": "unit-fiiwhlx-8876709-eaxcwtd"
                    },
                    {
                        "unit_name": "GRM",
                        "unit_id": "unit-zufnlja-7875656-engqsoq"
                    }
                ]
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "cat_unit_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $search_id = text_clean($data["search_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $figozo = new Database(FIGOZO_DB_USERNAME, FIGOZO_DB_PASSWORD, FIGOZO_DB_NAME);
                $unit_label_list = array();
                if (!empty($search_id)){
                    $sql_query = "select * from " . TABLE_CATALOG_UNIT . " where (`name` like '%$search_id%')"; // order by `name` asc
                }
                else{
                    $sql_query = "select * from " . TABLE_CATALOG_UNIT . " order by `name` asc";
                }

                $sql_query_result = $figozo->query($sql_query);
                if($sql_query_result != null && $sql_query_result->is_row_found()){
                    while($row = $sql_query_result->fetch_array()){
                        $unit_label_name = $row["name"];
                        $unit_label_id = $row["unit_label_id"];

                        $unit_label = array();
                        $unit_label["unit_name"] = $unit_label_name;
                        $unit_label["unit_id"] = $unit_label_id;

                        $unit_label_list[] = $unit_label;
                    }

                    $result = getOKStatus();
                    $result["unit_list"] = $unit_label_list;
                }

            }


        }

        echo json_export($result);
    }

    //todo - 100% - test - extern - upgrade filter by country
    if ($action == "cat_category_list_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                "status": "OK",
                "category_list": [
                    {
                        "category_name": "Papeles",
                        "category_id": "category-kenuwca-8557954-bfgpriw"
                    },
                    {
                        "category_name": "Pastelería",
                        "category_id": "category-wwoipfb-2670760-eufvdct"
                    },
                    {
                        "category_name": "Pisos y Muebles",
                        "category_id": "category-blwomzi-4689844-ylcthhu"
                    },
                    {
                        "category_name": "Salud",
                        "category_id": "category-midhlfm-9881708-difxhcd"
                    },
                    {
                        "category_name": "Snacks",
                        "category_id": "category-hgmtyzh-6806889-bvwwtnf"
                    },
                    {
                        "category_name": "Té y Hierbas",
                        "category_id": "category-hshxzkj-6611948-rxkxhwa"
                    },
                    {
                        "category_name": "Verduras",
                        "category_id": "category-afenblx-8125549-azrdqqn"
                    }
                ]
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "cat_category_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $search_id = text_clean($data["search_id"]);
        $country_code = text_clean($data["country_code"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $figozo = new Database(FIGOZO_DB_USERNAME, FIGOZO_DB_PASSWORD, FIGOZO_DB_NAME);

                $category_list = array();
                if (!empty($search_id)){
                    $sql_query = "select * from " . TABLE_CATALOG_CATEGORY . " where `name` like '%$search_id%'"; // order by `name`
                }
                else{
                    $sql_query = "select * from " . TABLE_CATALOG_CATEGORY . " order by `name`";
                }

                $sql_query_result = $figozo->query($sql_query);
                if($sql_query_result != null && $sql_query_result->is_row_found()){
                    while($row = $sql_query_result->fetch_array()){
                        $category_name = $row["name"];
                        $category_id = $row["category_id"];

                        $category = array();
                        $category["category_name"] = $category_name;
                        $category["category_id"] = $category_id;

                        if (is_category_in_country($category_id, $country_code, $figozo)) {
                            $category_list[] = $category;
                        }

                    }

                    $result = getOKStatus();
                    $result["category_list"] = $category_list;
                }

            }

        }

        echo json_export($result);
    }




    //fixme = ---------------------------- COMMUNITY START ----------------------------
    //todo - ACTION_CREATE_COMMUNITY = create_community
    //todo - ACTION_GET_COMMUNITY_DATA = "get_community_data" - sample
    //todo - ACTION_COMMUNITY_LIST = "get_community_list" - sample
    //todo - ACTION_EDIT_COMMUNITY = "edit_community" - sample
    //todo - ACTION_SUSPEND_MANAGER = "suspend_manager" - sample
    //todo - ACTION_ACTIVATE_MANAGER = "activate_manager" - sample
    //todo - ACTION_SUSPEND_AGENT = "suspend_agent" - sample
    //todo - ACTION_ACTIVATE_AGENT = "activate_agent" - sample

    //todo - 99% - test
    if ($action == "create_community") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $name = text_clean($data["name"]);
        $description = text_clean($data["description"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                if (!empty($name)){

                    $group_id = generate_unique_id(UNIQUE_SUB_NETWORK);
                    $creation_time = getCurrentTime();

                    $add_sub_net = get_insert_query(TABLE_SUB_NETWORK,[
                        "creation_time" => $creation_time,
                        "group_id" => $group_id,
                        "network_id" => $network_id,
                        "creator_id" => $user_id,
                        "group_name" => $name,
                        "group_description" => $description
                    ]);
                    $add_sub_net_result = $paperweight->query($add_sub_net);

                    if($add_sub_net_result != null && $add_sub_net_result->is_row_affected()){
                        $result = getOKStatus();
                        $result["group_id"] = $group_id;
                    }
                }

            }

        }

        echo json_export($result);
    }

    //todo - NYI
    if ($action == "get_community_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $group_id = text_clean($data["group_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "group_id": "'.$group_id.'",
              "name": "Community 1",
              "description": "Main collection Sub Network"
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    //todo - NYI
    if ($action == "get_community_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $email_list = text_clean($data["email_list"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "group_list": [
                {
                  "group_id": "HFJG76FGHD874HK8hfjs8dge5",
                  "group_name": "Collection Group",
                  "creation_time": "2021-11-15 09:07:45",
                  "agent_count": 10
                },
                {
                  "group_id": "KFHDIU765H4HCHFh653gddsgGHSLJSgdS",
                  "group_name": "Collection Group 2",
                  "creation_time": "2021-11-15 09:07:45",
                  "agent_count": 5
                }
              ]
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    //fixme - NYI
    if ($action == "edit_community") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $email_list = text_clean($data["email_list"]); //array
        //$community_list = text_clean($data["community_list"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

        }

        echo json_export($result);
    }
    //fixme - NYI
    if ($action == "suspend_manager") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $invitation_codes = $data["invitation_codes"]; //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                if (!empty($invitation_codes)){
                    if (count($invitation_codes) > 0){
                        for ($i = 0; $i < count($invitation_codes); $i++){
                            $invitation_code = text_clean($invitation_codes[$i]);

                            $verified = VERIFIED;

                            $query_invite = "select * from " . TABLE_INVITE_CODE . " where invitation_code = '$invitation_code' and invitation_state = '$verified'";
                            $invite_result = $paperweight->query($query_invite);

                            if($invite_result != null && $invite_result->is_row_found()){
                                if ($row = $invite_result->fetch_array()){
                                    $email_token = $row["email_token"];
                                    $current_time = getCurrentTime();

                                    //update invite code
                                    $update_invite_code = get_update_query(TABLE_INVITE_CODE,[
                                        "update_time" => $current_time,
                                        "invitation_state" => 0
                                    ],"invitation_code = '$invitation_code'");
                                    $update_code_result = $paperweight->query($update_invite_code);
                                    if($update_code_result != null && $update_code_result->is_row_affected()){
                                        $update_email_token = get_update_query(TABLE_EMAIL_TOKEN,[
                                            "status" => 0
                                        ],"token = '$email_token'");
                                        $update_token_result = $paperweight->query($update_email_token);
                                        //if($update_token_result != null && $update_token_result->is_row_affected()){}

                                        $result = getOKStatus();
                                    }
                                }

                            }
                        }
                    }
                }
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

        }

        echo json_export($result);
    }
    //fixme - NYI
    if ($action == "activate_manager") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $invitation_codes = $data["invitation_codes"]; //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                if (!empty($invitation_codes)){
                    if (count($invitation_codes) > 0){
                        for ($i = 0; $i < count($invitation_codes); $i++){
                            $invitation_code = text_clean($invitation_codes[$i]);

                            $verified = VERIFIED;

                            $query_invite = "select * from " . TABLE_INVITE_CODE . " where invitation_code = '$invitation_code' and invitation_state = '$verified'";
                            $invite_result = $paperweight->query($query_invite);

                            if($invite_result != null && $invite_result->is_row_found()){
                                if ($row = $invite_result->fetch_array()){
                                    $email_token = $row["email_token"];
                                    $current_time = getCurrentTime();

                                    //update invite code
                                    $update_invite_code = get_update_query(TABLE_INVITE_CODE,[
                                        "update_time" => $current_time,
                                        "invitation_state" => 0
                                    ],"invitation_code = '$invitation_code'");
                                    $update_code_result = $paperweight->query($update_invite_code);
                                    if($update_code_result != null && $update_code_result->is_row_affected()){
                                        $update_email_token = get_update_query(TABLE_EMAIL_TOKEN,[
                                            "status" => 0
                                        ],"token = '$email_token'");
                                        $update_token_result = $paperweight->query($update_email_token);
                                        //if($update_token_result != null && $update_token_result->is_row_affected()){}

                                        $result = getOKStatus();
                                    }
                                }

                            }
                        }
                    }
                }
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

        }

        echo json_export($result);
    }
    //fixme - NYI
    if ($action == "suspend_agent") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $invitation_codes = $data["invitation_codes"]; //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                if (!empty($invitation_codes)){
                    if (count($invitation_codes) > 0){
                        for ($i = 0; $i < count($invitation_codes); $i++){
                            $invitation_code = text_clean($invitation_codes[$i]);

                            $verified = VERIFIED;

                            $query_invite = "select * from " . TABLE_INVITE_CODE . " where invitation_code = '$invitation_code' and invitation_state = '$verified'";
                            $invite_result = $paperweight->query($query_invite);

                            if($invite_result != null && $invite_result->is_row_found()){
                                if ($row = $invite_result->fetch_array()){
                                    $email_token = $row["email_token"];
                                    $current_time = getCurrentTime();

                                    //update invite code
                                    $update_invite_code = get_update_query(TABLE_INVITE_CODE,[
                                        "update_time" => $current_time,
                                        "invitation_state" => 0
                                    ],"invitation_code = '$invitation_code'");
                                    $update_code_result = $paperweight->query($update_invite_code);
                                    if($update_code_result != null && $update_code_result->is_row_affected()){
                                        $update_email_token = get_update_query(TABLE_EMAIL_TOKEN,[
                                            "status" => 0
                                        ],"token = '$email_token'");
                                        $update_token_result = $paperweight->query($update_email_token);
                                        //if($update_token_result != null && $update_token_result->is_row_affected()){}

                                        $result = getOKStatus();
                                    }
                                }

                            }
                        }
                    }
                }
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

        }

        echo json_export($result);
    }
    //fixme - NYI
    if ($action == "activate_agent") {
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $invitation_codes = $data["invitation_codes"]; //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $client_network = getClientNetwork($user_id,$paperweight);

            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                if (!empty($invitation_codes)){
                    if (count($invitation_codes) > 0){
                        for ($i = 0; $i < count($invitation_codes); $i++){
                            $invitation_code = text_clean($invitation_codes[$i]);

                            $verified = VERIFIED;

                            $query_invite = "select * from " . TABLE_INVITE_CODE . " where invitation_code = '$invitation_code' and invitation_state = '$verified'";
                            $invite_result = $paperweight->query($query_invite);

                            if($invite_result != null && $invite_result->is_row_found()){
                                if ($row = $invite_result->fetch_array()){
                                    $email_token = $row["email_token"];
                                    $current_time = getCurrentTime();

                                    //update invite code
                                    $update_invite_code = get_update_query(TABLE_INVITE_CODE,[
                                        "update_time" => $current_time,
                                        "invitation_state" => 0
                                    ],"invitation_code = '$invitation_code'");
                                    $update_code_result = $paperweight->query($update_invite_code);
                                    if($update_code_result != null && $update_code_result->is_row_affected()){
                                        $update_email_token = get_update_query(TABLE_EMAIL_TOKEN,[
                                            "status" => 0
                                        ],"token = '$email_token'");
                                        $update_token_result = $paperweight->query($update_email_token);
                                        //if($update_token_result != null && $update_token_result->is_row_affected()){}

                                        $result = getOKStatus();
                                    }
                                }

                            }
                        }
                    }
                }
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

        }

        echo json_export($result);
    }
    //fixme = ---------------------------- COMMUNITY END ----------------------------

    //fixme = ---------------------------- DATA MARKETPLACE START ----------------------------
    //todo - ACTION_STORE_SAMPLE_LIST = "get_store_sample_list" - test
    //todo - ACTION_GET_STORE_SAMPLE = "get_store_sample_data" - test
    //todo - ACTION_GET_STORE_LIST = "get_store_list" - test
    //todo - ACTION_CONNECTED_STORE_LIST = "get_connected_store_list" - sample
    //todo - ACTION_GET_ALL_STORE = "get_all_store_list" - sample
    //todo - ACTION_CREATE_STORE_SAMPLE = "create_store_sample" - test
    //todo - ACTION_REMOVE_STORE_SAMPLE = "remove_store_sample" - test
    //todo - ACTION_ADD_STORE = "add_store_to_sample" - test
    //todo - ACTION_REMOVE_STORE = "remove_store_from_sample" - test

    //todo - progress - test - active sub by default
    if ($action == "create_store_sample_old"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sample_name = text_clean($data["sample_name"]);
        $sample_description = text_clean($data["sample_description"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();

            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/



            $res = '{
                  "status": "OK",
                  "sample_id": "samp-jghhfg-8695485-kgjffd"
                }';

        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

        //echo json_export($result);
    }
    if ($action == "create_store_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sample_name = text_clean($data["sample_name"]);
        $sample_description = text_clean($data["sample_description"]);
        $country_code = text_clean($data["country_code"]);

        $data_mode = text_clean($data["data_mode"]);
        $monitor_category = text_clean($data["monitor_category"]);
        $monitor_brand = text_clean($data["monitor_brand"]);

        $data_type = ($data["data_type"]);
        $category_list = ($data["category_list"]);
        $brand_list = ($data["brand_list"]);


        $data_type_cleaned = array();
        $category_list_cleaned = array();
        $brand_list_cleaned = array();


        foreach ($data_type as $value) {
            $cleaned_val = text_clean($value);
            $data_type_cleaned[] = $cleaned_val;
        }
        foreach ($category_list as $value) {
            $cleaned_val = text_clean($value);
            $category_list_cleaned[] = $cleaned_val;
        }
        foreach ($brand_list as $value) {
            $cleaned_val = text_clean($value);
            $brand_list_cleaned[] = $cleaned_val;
        }


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                $creation_time = getCurrentTime();
                $sample_id = generate_unique_id("sp_");


                $sample_query = get_insert_query(TABLE_STORE_SAMPLE, [
                    "creation_time" => $creation_time,
                    "sample_id" => $sample_id,
                    "creator_id" => $user_id,
                    "network_id" => $network_id,
                    "sample_name" => $sample_name,
                    "description" => $sample_description,
                    "country_code" => $country_code,

                    "data_mode" => $data_mode,
                    "data_type" => json_encode($data_type_cleaned),
                    "monitor_category" => $monitor_category,
                    "monitor_brand" => $monitor_brand,
                    "category_list" => json_encode($category_list_cleaned),
                    "brand_list" => json_encode($brand_list_cleaned)
                    //"subscription_active" => 1
                ]);
                $sample_result = $paperweight->query($sample_query);
                if($sample_result != null && $sample_result->is_row_affected()){
                    $result = getOKStatus();
                    $result["sample_id"] = $sample_id;
                }

            }

        }

        echo json_export($result);
    }

    //todo - NYI - sample
    if ($action == "update_store_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sample_name = text_clean($data["sample_name"]);
        $sample_description = text_clean($data["sample_description"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();

            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/



            $res = '{
                  "status": "OK"
                }';

        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

        //echo json_export($result);
    }


    //todo - progress - sample - json
    if ($action == "get_store_sample_list_old"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array

        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $string1 = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_CSV_MAYORISTA.json");
            $obj_store_list1 = json_decode($string1, true);

            $string2 = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_CSV_SUPERMERCADOS.json");
            $obj_store_list2 = json_decode($string2, true);

            $string3 = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWS_CSV_ALMACENS.json");
            $obj_store_list3 = json_decode($string3, true);

            $res = '{
              "status": "OK",
              "sample_list": [
                {
                  "sample_id": "samp-jghhfg-8695485-kgjffd",
                  "update_time": "2021-02-12 10:07:15",
                  "sample_name": "Mayorista Sample",
                  "sample_description": "All Mayoristas",
                  "store_count": '. count($obj_store_list1) .',
                  "subscription_active": true
                },
                {
                  "sample_id": "samp-hgjhfd-867585-jgkhjfhh",
                  "update_time": "2021-02-12 10:07:15",
                  "sample_name": "Supermercado Sample",
                  "sample_description": "All Supermercados",
                  "store_count": '. count($obj_store_list2) .',
                  "subscription_active": true
                },
                {
                  "sample_id": "samp-ghdwoqp-4387309-gapdihw",
                  "update_time": "2021-02-12 10:07:15",
                  "sample_name": "Almacens Sample",
                  "sample_description": "All Almacens",
                  "store_count": '. count($obj_store_list3) .',
                  "subscription_active": true
                }
              ]
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }
    }
    if ($action == "get_store_sample_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                //$result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);
                $sample_list = array();

                $sample_query = "select * from " . TABLE_STORE_SAMPLE . " where network_id = '$network_id' ";
                $sample_result = $paperweight->query($sample_query);

                if($sample_result != null && $sample_result->is_row_found()){
                    while($row = $sample_result->fetch_array()){

                        $sample_id = $row["sample_id"];
                        $sample_item = array();
                        $sample_item["sample_id"] = $sample_id;
                        $sample_item["update_time"] = $row["creation_time"];
                        $sample_item["sample_name"] = $row["sample_name"];
                        $sample_item["sample_description"] = $row["description"];
                        $sample_item["country_code"] = $row["country_code"];
                        $sample_item["store_count"] = getSampleStoreListCount($sample_id,$paperweight);
                        $sample_item["subscription_active"] = $row["subscription_active"] == 1;

                        $sample_list[] = $sample_item;
                    }
                }

                $result = getOKStatus();
                $result["sample_list"] = $sample_list;
            }

            /*$string1 = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_CSV_MAYORISTA.json");
            $obj_store_list1 = json_decode($string1, true);

            $string2 = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_CSV_SUPERMERCADOS.json");
            $obj_store_list2 = json_decode($string2, true);

            $string3 = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWS_CSV_ALMACENS.json");
            $obj_store_list3 = json_decode($string3, true);

            $res = '{
              "status": "OK",
              "sample_list": [
                {
                  "sample_id": "samp-jghhfg-8695485-kgjffd",
                  "update_time": "2021-02-12 10:07:15",
                  "sample_name": "Mayorista Sample",
                  "sample_description": "All Mayoristas",
                  "store_count": '. count($obj_store_list1) .',
                  "subscription_active": true
                },
                {
                  "sample_id": "samp-hgjhfd-867585-jgkhjfhh",
                  "update_time": "2021-02-12 10:07:15",
                  "sample_name": "Supermercado Sample",
                  "sample_description": "All Supermercados",
                  "store_count": '. count($obj_store_list2) .',
                  "subscription_active": true
                },
                {
                  "sample_id": "samp-ghdwoqp-4387309-gapdihw",
                  "update_time": "2021-02-12 10:07:15",
                  "sample_name": "Almacens Sample",
                  "sample_description": "All Almacens",
                  "store_count": '. count($obj_store_list3) .',
                  "subscription_active": true
                }
              ]
            }';*/
        }

        echo json_export($result);
    }


    //todo - test - sample - get the locality of the stores
    if ($action == "get_store_locality"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $search_id = text_clean($data["search_id"]);
        $country_code = text_clean($data["country_code"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $locality_list = getStoreLocality($country_code,$search_id);


                $result = getOKStatus();
                $result["locality_list"] = $locality_list;

            }

        }

        echo json_export($result);
    }


    //todo - test - sample
    if ($action == "add_store_to_sample_old"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                  "status": "OK",
                  "file_list": [
                    {
                      "file_name": "Permission Document",
                      "file_ext": "ext_pdf",
                      "file_url": "https://api.queritel.com/api/uploads/queritel/insights/other/sample-file.pdf"
                    },
                    {
                      "file_name": "Instruction Document",
                      "file_ext": "ext_docx",
                      "file_url": "https://example-files.online-convert.com/document/docx/example.docx"
                    }
                  ]
                }';

            //echo json_export($result);
        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }
    if ($action == "add_store_to_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sample_id = text_clean($data["sample_id"]);
        $package_id = text_clean($data["store_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);


                $package_data = getStorePackage($package_id);
                $sample_data = getSampleDataRaw($sample_id,$paperweight);

                $creation_time = getCurrentTime();

                if (!empty($package_data) && !empty($sample_data)){

                    $package_query = get_insert_query(TABLE_STORE_SAMPLE_PACKAGE, [
                        "creation_time" => $creation_time,
                        "sample_id" => $sample_data["sample_id"],
                        "creator_id" => $user_id,
                        "network_id" => $network_id,
                        "package_id" => $package_data["store_id"],
                        "store_id" => $package_data["store_id"],
                        "store_name" => text_clean($package_data["store_name"]),
                        "store_type" => $package_data["store_type"],
                        "country_code" => $package_data["country_code"],
                        "address" => $package_data["address"],
                        "monthly_subscription" => $package_data["monthly_subscription"],
                        "currency_code" => $package_data["currency_code"]
                    ]);
                    $package_result = $paperweight->query($package_query);
                    if($package_result != null && $package_result->is_row_affected()){
                        $result = getOKStatus();
                    }

                }

            }

        }

        echo json_export($result);
    }


    //todo - NYI - sample
    if ($action == "get_connected_store_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "store_list": [
                {
                  "store_id": "4687314909",
                  "store_name": "Zendos Snackables2",
                  "store_type": "grocerystore",
                  "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/company_logo.jpg",
                  "country_code": "CL",
                  "address": "Bellavista 186, Recoleta, Chile",
                  "currency_code": "CLP",
                  "total_products": 500,
                  "days_active": 365,
                  "daily_transactions": 100,
                  "avg_monthly_sales": 1000000,
                  "monthly_subscription": 5000,
                  "store_url": "https://market.figozo.com/store/?storeid=4687314909",
                  "sample_list": [
                    {
                      "sample_id": "samp-jghhfg-8695485-kgjffd",
                      "sample_name": "Supermarket Sample"
                    }
                  ]
                },
                {
                  "store_id": "5042245635",
                  "store_name": "Delicias de rengo",
                  "store_type": "grocerystore",
                  "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/no_store.png",
                  "country_code": "CL",
                  "address": "Av. Azul, La Florida, Santiago Metropolitana",
                  "currency_code": "CLP",
                  "total_products": 500,
                  "days_active": "30",
                  "daily_transactions": 200,
                  "avg_monthly_sales": 2000000,
                  "monthly_subscription": 3000,
                  "store_url": "https://market.figozo.com/store/?storeid=4687314909",
                  "sample_list": [
                    {
                      "sample_id": "samp-jghhfg-8695485-kgjffd",
                      "sample_name": "Supermarket Sample"
                    }
                  ]
                },
                {
                  "store_id": "8576475857",
                  "store_name": "Delicias de rengo",
                  "store_type": "grocerystore",
                  "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/no_store.png",
                  "country_code": "CL",
                  "address": "Av. Azul, La Florida, Santiago Metropolitana",
                  "currency_code": "CLP",
                  "total_products": 500,
                  "days_active": "30",
                  "daily_transactions": 600,
                  "avg_monthly_sales": 2000000,
                  "monthly_subscription": 3000,
                  "store_url": "https://market.figozo.com/store/?storeid=4687314909",
                  "sample_list": [
                    {
                      "sample_id": "samp-jghhfg-8695485-kgjffd",
                      "sample_name": "Supermarket Sample"
                    }
                  ]
                }
              ]
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }


    //todo - test - sample - json
    if ($action == "get_store_sample_data_old"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $sample_id = text_clean($data["sample_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];



                $result = getErrorStatus(ERROR_MSG_NOT_FOUND);
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $string1 = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_CSV_MAYORISTA.json");
            $obj_store_list1 = json_decode($string1, true);

            $string2 = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_CSV_SUPERMERCADOS.json");
            $obj_store_list2 = json_decode($string2, true);

            $string3 = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWS_CSV_ALMACENS.json");
            $obj_store_list3 = json_decode($string3, true);


            $sample_data = array();
            $store_list = array();


            $index = 0;
            if ($sample_id == "samp-jghhfg-8695485-kgjffd"){

                $sample_data["sample_id"] = "samp-jghhfg-8695485-kgjffd";
                $sample_data["update_time"] = "2021-02-12 10:07:15";
                $sample_data["sample_name"] = "Mayorista Sample";
                $sample_data["sample_description"] = "All Mayoristas";
                $sample_data["country_code"] = "CL";
                $sample_data["store_count"] = count($obj_store_list1);
                $sample_data["subscription_active"] = true;

                foreach ($obj_store_list1 as $store) {
                    $store_obj = array();

                    $store_obj["store_id"] = $store["store_id"];
                    $store_obj["store_name"] = $store["store_name"];
                    $store_obj["store_type"] = $store["store_type"];
                    $store_obj["logo_url"] = $store["logo_url"];
                    $store_obj["store_url"] = $store["store_url"];
                    $store_obj["country_code"] = $store["country_code"];
                    $store_obj["address"] = $store["address"];
                    $store_obj["currency_code"] = $store["currency_code"];
                    $store_obj["total_products"] = $store["total_products"];
                    $store_obj["days_active"] = $store["days_active"];
                    $store_obj["daily_transactions"] = $store["daily_transactions"];
                    $store_obj["avg_monthly_sales"] = $store["avg_monthly_sales"];
                    $store_obj["monthly_subscription"] = $store["monthly_subscription"];
                    //$store_obj["region"] = $store["region"];
                    $store_obj["locality"] = $store["locality"];
                    $store_obj["tax_id"] = $store["co_id"];

                    $store_list[] = $store_obj;

                    if ($index >= 50){
                        break;
                    }

                    $index++;
                }

                $sample_data["store_list"] = $store_list;

                $result = getOKStatus();
                $result["sample_data"] = $sample_data;

            }
            elseif ($sample_id == "samp-hgjhfd-867585-jgkhjfhh"){

                $sample_data["sample_id"] = "samp-hgjhfd-867585-jgkhjfhh";
                $sample_data["update_time"] = "2021-02-12 10:07:15";
                $sample_data["sample_name"] = "Supermercado Sample";
                $sample_data["sample_description"] = "All Supermercados";
                $sample_data["country_code"] = "CL";
                $sample_data["store_count"] = count($obj_store_list2);
                $sample_data["subscription_active"] = true;

                $index = 0;
                foreach ($obj_store_list2 as $store) {
                    $store_obj = array();

                    $store_obj["store_id"] = $store["store_id"];
                    $store_obj["store_name"] = $store["store_name"];
                    $store_obj["store_type"] = $store["store_type"];
                    $store_obj["logo_url"] = $store["logo_url"];
                    $store_obj["store_url"] = $store["store_url"];
                    $store_obj["country_code"] = $store["country_code"];
                    $store_obj["address"] = $store["address"];
                    $store_obj["currency_code"] = $store["currency_code"];
                    $store_obj["total_products"] = $store["total_products"];
                    $store_obj["days_active"] = $store["days_active"];
                    $store_obj["daily_transactions"] = $store["daily_transactions"];
                    $store_obj["avg_monthly_sales"] = $store["avg_monthly_sales"];
                    $store_obj["monthly_subscription"] = $store["monthly_subscription"];
                    $store_obj["region"] = $store["region"];
                    $store_obj["locality"] = $store["locality"];
                    $store_obj["tax_id"] = $store["co_id"];

                    $store_list[] = $store_obj;

                    if ($index >= 50){
                        break;
                    }

                    $index++;
                }

                $sample_data["store_list"] = $store_list;

                $result = getOKStatus();
                $result["sample_data"] = $sample_data;
            }
            elseif ($sample_id == "samp-ghdwoqp-4387309-gapdihw"){

                $sample_data["sample_id"] = "samp-ghdwoqp-4387309-gapdihw";
                $sample_data["update_time"] = "2021-02-12 10:07:15";
                $sample_data["sample_name"] = "Almacens Sample";
                $sample_data["sample_description"] = "All Almacens";
                $sample_data["country_code"] = "CL";
                $sample_data["store_count"] = count($obj_store_list3);
                $sample_data["subscription_active"] = true;

                $index = 0;

                foreach ($obj_store_list3 as $store) {
                    $store_obj = array();

                    $store_obj["store_id"] = $store["store_id"];
                    $store_obj["store_name"] = $store["store_name"];
                    $store_obj["store_type"] = $store["store_type"];
                    $store_obj["logo_url"] = $store["logo_url"];
                    $store_obj["store_url"] = $store["store_url"];
                    $store_obj["country_code"] = $store["country_code"];
                    $store_obj["address"] = $store["address"];
                    $store_obj["currency_code"] = $store["currency_code"];
                    $store_obj["total_products"] = $store["total_products"];
                    $store_obj["days_active"] = $store["days_active"];
                    $store_obj["daily_transactions"] = $store["daily_transactions"];
                    $store_obj["avg_monthly_sales"] = $store["avg_monthly_sales"];
                    $store_obj["monthly_subscription"] = $store["monthly_subscription"];
                    $store_obj["region"] = $store["region"];
                    $store_obj["locality"] = $store["locality"];
                    $store_obj["tax_id"] = $store["co_id"];

                    $store_list[] = $store_obj;

                    if ($index >= 50){
                        break;
                    }

                    $index++;
                }

                $sample_data["store_list"] = $store_list;

                $result = getOKStatus();
                $result["sample_data"] = $sample_data;
            }



            /*$res = '{
              "status": "OK",
              "sample_data": {
                "sample_id": "samp-jghhfg-8695485-kgjffd",
                "sample_name": "Supermarket Sample",
                "sample_description": "This is a Sample Desc",
                "store_count": 1,
                "subscription_active": false,
                "store_list": [
                  {
                      "store_id": "4687314909",
                      "store_name": "Zendos Snackables2",
                      "store_type": "grocerystore",
                      "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/company_logo.jpg",
                      "store_url": "https://market.figozo.com/store/?storeid=4687314909",
                      "region": "CL",
                      "country_code": "CL",
                      "address": "Bellavista 186, Recoleta, Chile",
                      "currency_code": "CLP",
                      "total_products": 500,
                      "days_active": 365,
                      "daily_transactions": 100,
                      "avg_monthly_sales": 1000000,
                      "monthly_subscription": 5000
                  }
                ]
              }
            }';*/

            //echo json_export($result);
        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }
    if ($action == "get_store_sample_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sample_id = text_clean($data["sample_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_NOT_FOUND);

                $sample_data = array();
                $store_list = array();

                $sample_query = "select * from " . TABLE_STORE_SAMPLE . " where network_id = '$network_id' and sample_id = '$sample_id' ";
                $sample_result = $paperweight->query($sample_query);

                if($sample_result != null && $sample_result->is_row_found()){
                    if($row = $sample_result->fetch_array()){

                        $store_list = array();
                        $distribution_list = array();


                        $store_query = "select * from " . TABLE_STORE_SAMPLE_PACKAGE . " where network_id = '$network_id' and sample_id = '$sample_id' ";
                        $store_result = $paperweight->query($store_query);
                        if($store_result != null && $store_result->is_row_found()){
                            while($row2 = $store_result->fetch_array()){
                                $store_obj = array();

                                $package_id = $row2["store_id"];
                                $store_type = $row2["store_type"];

                                $package_data = getStorePackage($package_id);

                                $store_obj["store_id"] = $package_id;
                                $store_obj["store_name"] = $row2["store_name"];
                                $store_obj["store_type"] = $store_type;
                                $store_obj["logo_url"] = $package_data["logo_url"];
                                $store_obj["store_url"] = $package_data["store_url"];
                                $store_obj["country_code"] = $row2["country_code"];
                                $store_obj["address"] = $row2["address"];
                                $store_obj["currency_code"] = $row2["currency_code"];
                                $store_obj["total_products"] = $package_data["total_products"];
                                $store_obj["days_active"] = $package_data["days_active"];
                                $store_obj["daily_transactions"] = $package_data["daily_transactions"];
                                $store_obj["avg_monthly_sales"] = $package_data["avg_monthly_sales"];
                                $store_obj["monthly_subscription"] = $row2["monthly_subscription"];
                                //$store_obj["region"] = $store["region"];
                                $store_obj["locality"] = $package_data["locality"];
                                $store_obj["tax_id"] = $package_data["co_id"];

                                $distribution_list[$store_type] += 1;

                                $store_list[] = $store_obj;
                            }
                        }

                        $temp = array();
                        foreach ($distribution_list as $key => $value) {
                            $temp[] = [
                                $key => $value
                            ];
                        }
                        $distribution_list = $temp;


                        $sample_data["sample_id"] = $row["sample_id"];
                        $sample_data["update_time"] = $row["creation_time"];
                        $sample_data["sample_name"] = $row["sample_name"];
                        $sample_data["sample_description"] = $row["description"];
                        $sample_data["country_code"] = $row["country_code"];
                        $sample_data["subscription_active"] = $row["subscription_active"] == 1;
                        $sample_data["store_count"] = count($store_list);
                        $sample_data["store_distribution"] = $distribution_list;

                        $sample_data["data_mode"] = $row["data_mode"];
                        $sample_data["data_type"] = json_export($row["data_type"]);
                        $sample_data["monitor_category"] = $row["monitor_category"] == 1;
                        $sample_data["monitor_brand"] = $row["monitor_brand"] == 1;
                        $sample_data["category_list"] = json_export($row["category_list"]);
                        $sample_data["brand_list"] = json_export($row["brand_list"]);




                        $subscription_id = $row["subscription_id"];
                        //$subscription_data = getSubscriptionData($subscription_id);
                        $subscription = array();
                        $subscription["subscription_id"] = generate_unique_id("sb_");
                        $subscription["is_active"] = $row["subscription_active"] == 1;
                        $subscription["interval"] = "3_month";
                        $subscription["provider"] = "stripe";
                        $subscription["billing_mode"] = "automatic";


                        $sample_data["subscription"] = $subscription;
                        //$sample_data["store_list"] = $store_list;


                        $result = getOKStatus();
                        $result["sample_data"] = $sample_data;

                    }
                }

            }

        }

        echo json_export($result);
    }

    //todo - test - sample - json
    if ($action == "get_store_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sample_id = text_clean($data["sample_id"]);

        $search_limit = text_clean($data["search_limit"]);
        $offset_index = text_clean($data["offset_index"]);

        $limit_from = intval($offset_index);
        $row_count = intval($search_limit);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_NOT_FOUND);

                $store_list = array();

                $store_query = "select * from " . TABLE_STORE_SAMPLE_PACKAGE . " where network_id = '$network_id' and sample_id = '$sample_id' limit $row_count offset $limit_from";
                $store_result = $paperweight->query($store_query);

                if($store_result != null && $store_result->is_row_found()){
                    while($row2 = $store_result->fetch_array()){
                        $store_obj = array();

                        $package_id = $row2["store_id"];

                        $package_data = getStorePackage($package_id);

                        $store_obj["store_id"] = $package_id;
                        $store_obj["store_name"] = $row2["store_name"];
                        $store_obj["store_type"] = $row2["store_type"];
                        $store_obj["logo_url"] = $package_data["logo_url"];
                        $store_obj["store_url"] = $package_data["store_url"];
                        $store_obj["country_code"] = $row2["country_code"];
                        $store_obj["address"] = $row2["address"];
                        $store_obj["currency_code"] = $row2["currency_code"];
                        $store_obj["total_products"] = $package_data["total_products"];
                        $store_obj["days_active"] = $package_data["days_active"];
                        $store_obj["daily_transactions"] = $package_data["daily_transactions"];
                        $store_obj["avg_monthly_sales"] = $package_data["avg_monthly_sales"];
                        $store_obj["monthly_subscription"] = $row2["monthly_subscription"];
                        //$store_obj["region"] = $store["region"];
                        $store_obj["locality"] = $package_data["locality"];
                        $store_obj["tax_id"] = $package_data["co_id"];

                        $store_list[] = $store_obj;
                    }
                }

                $result = getOKStatus();
                $result["store_list"] = $store_list;

            }

        }

        echo json_export($result);
    }


    //todo - test - sample json
    if ($action == "get_all_store_list_old"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $filter = $data["filter"]; //map

        $search_id =  text_clean($data["search_id"]);
        $search_limit =  text_clean($data["search_limit"]);
        $offset_index =  text_clean($data["offset_index"]);



        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            //Country
            //Region
            //Store Type
            //Transaction Volume
            //Subscription Range
            //SKU Sold


            /*$filter = array();
            $filter["country_code"] = "CL";
            $filter["region"] = "Santiago";
            $filter["locality"] = "locality";
            $filter["store_type"] = "supermarketstore";
            $filter["product_name"] = "Pan Hot Dog 8 Un";*/

            //$product_string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_STORE_LIST_ALL.json");
            //$obj_product_list = json_decode($product_string, true);



            $store_list = array();

            $store_string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_STORE_LIST_ALL.json");
            $obj_store_list = json_decode($store_string, true);

            if (!empty($filter)){
                $obj_store_list = filterStoreList($filter, $obj_store_list);
            }

            $index = 0;
            foreach ($obj_store_list as $store) {
                $store_obj = array();

                $store_obj["store_id"] = $store["store_id"];
                $store_obj["store_name"] = $store["store_name"];
                $store_obj["store_type"] = $store["store_type"];
                $store_obj["logo_url"] = $store["logo_url"];
                $store_obj["store_url"] = $store["store_url"];
                $store_obj["country_code"] = $store["country_code"];
                $store_obj["address"] = $store["address"];
                $store_obj["currency_code"] = $store["currency_code"];
                $store_obj["total_products"] = $store["total_products"];
                $store_obj["days_active"] = $store["days_active"];
                $store_obj["daily_transactions"] = $store["daily_transactions"];
                $store_obj["avg_monthly_sales"] = $store["avg_monthly_sales"];
                $store_obj["monthly_subscription"] = $store["monthly_subscription"];
                $store_obj["region"] = $store["region"];
                $store_obj["locality"] = $store["locality"];
                $store_obj["tax_id"] = $store["co_id"];


                $store_list[] = $store_obj;
                $index++;


                if ($index >= 90){
                    break;
                }

            }

            $result["store_list"] = $store_list;
            $result["last_index"] = 100;

            /*$res = '{
              "status": "OK",
              "store_list": [
                {
                  "store_id": "4687314909",
                  "store_name": "Zendos Snackables2",
                  "store_type": "grocerystore",
                  "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/company_logo.jpg",
                  "store_url": "https://market.figozo.com/store/?storeid=4687314909",
                  "country_code": "CL",
                  "address": "Bellavista 186, Recoleta, Chile",
                  "currency_code": "CLP",
                  "total_products": 500,
                  "days_active": "365",
                  "daily_transactions": 100,
                  "avg_monthly_sales": 1000000,
                  "monthly_subscription": 5000
                },
                {
                  "store_id": "5042245635",
                  "store_name": "Tienda E. Morale",
                  "store_type": "grocerystore",
                  "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/company_logo9.png",
                  "store_url": "https://market.figozo.com/store/?storeid=5042245635",
                  "country_code": "CL",
                  "address": "Av. Azul, La Florida, Santiago Metropolitana",
                  "currency_code": "CLP",
                  "total_products": 500,
                  "days_active": "30",
                  "daily_transactions": 200,
                  "avg_monthly_sales": 2000000,
                  "monthly_subscription": 3000
                },
                {
                  "store_id": "8576475857",
                  "store_name": "Delicias de rengo",
                  "store_type": "grocerystore",
                  "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/no_store.png",
                  "store_url": "https://market.figozo.com/store/?storeid=5042245635",
                  "country_code": "CL",
                  "address": "Av. Azul, La Florida, Santiago Metropolitana",
                  "currency_code": "CLP",
                  "total_products": 500,
                  "days_active": "30",
                  "daily_transactions": 600,
                  "avg_monthly_sales": 2000000,
                  "monthly_subscription": 3000
                }
                
              ]
            }';*/

            //echo json_export($result);
        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }
    if ($action == "get_all_store_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $filter = $data["filter"]; //map

        $search_id =  text_clean($data["search_id"]);
        $search_limit =  text_clean($data["search_limit"]);
        $offset_index =  text_clean($data["offset_index"]);
        $sample_id =  text_clean($data["sample_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            //Country
            //Region
            //Store Type
            //Transaction Volume
            //Subscription Range
            //SKU Sold


            /*$filter = array();
            $filter["country_code"] = "CL";
            $filter["region"] = "Santiago";
            $filter["locality"] = "locality";
            $filter["store_type"] = "supermarketstore";
            $filter["product_name"] = "Pan Hot Dog 8 Un";*/

            //$product_string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_STORE_LIST_ALL.json");
            //$obj_product_list = json_decode($product_string, true);

            //$search_limit
            //$offset_index

            $store_list = array();



            $store_string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_STORE_LIST_ALL.json");
            $obj_store_list = json_decode($store_string, true);

            if (!empty($filter)){
                $obj_store_list = filterStoreList($filter, $obj_store_list);
            }

            $index = 0;
            $items_returned = 0;

            foreach ($obj_store_list as $store) {
                $store_obj = array();


                if ($index <= $offset_index){
                    $index++;
                    continue;
                }

                $store_id = $store["store_id"];

                $store_obj["store_id"] = $store_id;
                $store_obj["store_name"] = $store["store_name"];
                $store_obj["store_type"] = $store["store_type"];
                $store_obj["logo_url"] = $store["logo_url"];
                $store_obj["store_url"] = $store["store_url"];
                $store_obj["country_code"] = $store["country_code"];
                $store_obj["address"] = $store["address"];
                $store_obj["currency_code"] = $store["currency_code"];
                $store_obj["total_products"] = $store["total_products"];
                $store_obj["days_active"] = $store["days_active"];
                $store_obj["daily_transactions"] = $store["daily_transactions"];
                $store_obj["avg_monthly_sales"] = $store["avg_monthly_sales"];
                $store_obj["monthly_subscription"] = $store["monthly_subscription"];
                $store_obj["region"] = $store["region"];
                $store_obj["locality"] = $store["locality"];
                $store_obj["tax_id"] = $store["co_id"];
                $store_obj["in_sample"] = (!empty($sample_id) ? (isStoreInSample($store_id,$sample_id,$paperweight)) : false);

                $store_list[] = $store_obj;

                $items_returned++;


                if ($items_returned >= $search_limit){
                    break;
                }

            }

            $last_index = (intval($offset_index) + intval($items_returned));

            $result["store_list"] = $store_list;
            $result["last_index"] = $last_index;

            /*$res = '{
              "status": "OK",
              "store_list": [
                {
                  "store_id": "4687314909",
                  "store_name": "Zendos Snackables2",
                  "store_type": "grocerystore",
                  "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/company_logo.jpg",
                  "store_url": "https://market.figozo.com/store/?storeid=4687314909",
                  "country_code": "CL",
                  "address": "Bellavista 186, Recoleta, Chile",
                  "currency_code": "CLP",
                  "total_products": 500,
                  "days_active": "365",
                  "daily_transactions": 100,
                  "avg_monthly_sales": 1000000,
                  "monthly_subscription": 5000
                },
                {
                  "store_id": "5042245635",
                  "store_name": "Tienda E. Morale",
                  "store_type": "grocerystore",
                  "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/company_logo9.png",
                  "store_url": "https://market.figozo.com/store/?storeid=5042245635",
                  "country_code": "CL",
                  "address": "Av. Azul, La Florida, Santiago Metropolitana",
                  "currency_code": "CLP",
                  "total_products": 500,
                  "days_active": "30",
                  "daily_transactions": 200,
                  "avg_monthly_sales": 2000000,
                  "monthly_subscription": 3000
                },
                {
                  "store_id": "8576475857",
                  "store_name": "Delicias de rengo",
                  "store_type": "grocerystore",
                  "logo_url": "https://source.queritel.com/figozo/uploads/store/logo/no_store.png",
                  "store_url": "https://market.figozo.com/store/?storeid=5042245635",
                  "country_code": "CL",
                  "address": "Av. Azul, La Florida, Santiago Metropolitana",
                  "currency_code": "CLP",
                  "total_products": 500,
                  "days_active": "30",
                  "daily_transactions": 600,
                  "avg_monthly_sales": 2000000,
                  "monthly_subscription": 3000
                }

              ]
            }';*/

        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }


    //todo - 99% - test
    if ($action == "remove_store_from_sample_old"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                  "status": "OK",
                  "store_list": [
                    
                  ]
                }';

            //echo json_export($result);
        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }
    if ($action == "remove_store_from_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sample_id = text_clean($data["sample_id"]);
        $package_id = text_clean($data["store_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                $package_query = "delete from " . TABLE_STORE_SAMPLE_PACKAGE . " where network_id = '$network_id' and sample_id = '$sample_id' and package_id = '$package_id'";
                $package_result = $paperweight->query($package_query);
                if($package_result != null && $package_result->is_row_affected()){
                    $result = getOKStatus();
                }

            }

        }

        echo json_export($result);
    }


    //todo - 99% - test
    if ($action == "remove_store_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sample_id = text_clean($data["sample_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                $sample_query = "delete from " . TABLE_STORE_SAMPLE . " where network_id = '$network_id' and sample_id = '$sample_id'";
                $sample_result = $paperweight->query($sample_query);
                if($sample_result != null && $sample_result->is_row_affected()){

                    $package_query = "delete from " . TABLE_STORE_SAMPLE_PACKAGE . " where network_id = '$network_id' and sample_id = '$sample_id'";
                    $package_result = $paperweight->query($package_query);
                    if($package_result != null && $package_result->is_row_affected()){
                        $result = getOKStatus();
                    }
                    else{
                        $result = getOKStatus();
                    }
                }


            }

        }

        echo json_export($result);
    }
    //fixme = ---------------------------- DATA MARKETPLACE END ----------------------------



    //todo = ---------------------------- FILE START (done)----------------------------
    //todo - 99% - test
    if ($action == "get_file_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $rel_type = FILE_REL_QUEST;
                $file_list = array();

                $file_query = "select * from " . TABLE_ALL_FILES . " where network_id = '$network_id' and relationship_type = '$rel_type' and quest_id = '$quest_id'";
                //- hide geo json - //$file_query = "select * from " . TABLE_ALL_FILES . " where network_id = '$network_id' and relationship_type = '$rel_type' and quest_id = '$quest_id' and is_hidden = '0'";
                $file_query_result = $paperweight->query($file_query);

                if($file_query_result != null && $file_query_result->is_row_found()){
                    while($row = $file_query_result->fetch_array()){

                        $file_data = array();
                        $file_data["file_id"] = $row["file_id"];
                        $file_data["file_name"] = $row["original_filename"];
                        $file_data["file_ext"] = $row["file_ext"];
                        $file_data["file_url"] = FTP_Q_FILE_DIRECTORY . $row["file_name"];
                        $file_data["file_size"] = $row["file_size"];
                        $file_data["uploaded_date"] = $row["creation_time"];

                        $file_list[] = $file_data;
                    }
                }

                $result = getOKStatus();
                $result["file_list"] = $file_list;
            }
        }

        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "get_file_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $file_id = text_clean($data["file_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                //$rel_type = FILE_REL_QUEST;

                $result = getErrorStatus(ERROR_MSG_NOT_FOUND);

                //$file_query = "select * from " . TABLE_ALL_FILES . " where network_id = '$network_id' and relationship_type = '$rel_type' and file_id = '$file_id'";
                $file_query = "select * from " . TABLE_ALL_FILES . " where network_id = '$network_id' and file_id = '$file_id'";
                $file_query_result = $paperweight->query($file_query);

                if($file_query_result != null && $file_query_result->is_row_found()){
                    if($row = $file_query_result->fetch_array()){

                        $file_data = array();
                        $file_data["file_id"] = $row["file_id"];
                        $file_data["file_name"] = $row["original_filename"];
                        $file_data["file_ext"] = $row["file_ext"];
                        $file_data["file_url"] = FTP_Q_FILE_DIRECTORY . $row["file_name"];
                        $file_data["file_size"] = $row["file_size"];
                        $file_data["uploaded_date"] = $row["creation_time"];

                        $result = getOKStatus();
                        $result["file_data"] = $file_data;
                    }
                }



            }

        }


        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "remove_quest_file"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $file_id = text_clean($data["file_id"]);
        $quest_id = text_clean($data["quest_id"]); //future compatibility (multi quest per file id)


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $rel_type = FILE_REL_QUEST;

                $result = getErrorStatus(ERROR_MSG_NOT_FOUND);

                $file_query = "select * from " . TABLE_ALL_FILES . " where network_id = '$network_id' and relationship_type = '$rel_type' and file_id = '$file_id'";
                $file_query_result = $paperweight->query($file_query);

                if($file_query_result != null && $file_query_result->is_row_found()){
                    if($row = $file_query_result->fetch_array()){

                        $targetPath = "uploads/file/" . $row["file_name"];

                        $del_query = "delete from " . TABLE_ALL_FILES . " where network_id = '$network_id' and relationship_type = '$rel_type' and file_id = '$file_id'";
                        $del_query_result = $paperweight->query($del_query);
                        if($file_query_result != null && $file_query_result->is_row_affected()){
                            $result = getOKStatus();

                            queritelRemoveFile($targetPath);

                            //if (queritelRemoveFile($targetPath)){}

                        }

                    }
                }
            }


        }

        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "add_quest_file"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                if (isset($_FILES["file_upload"]["tmp_name"])){
                    $supportedFileTypeArray = array(
                        'png' => 'ext_png',
                        'jpg' => 'ext_jpg',
                        'jpeg' => 'ext_jpg',
                        'pdf' => 'ext_pdf',
                        'docx' => 'ext_docx',
                        'mp4' => 'ext_mp4',
                        'html' => 'ext_html'
                    );
                    $fileName = $_FILES["file_upload"]['name'];
                    //$fileError = $_FILES["file_upload"]['error'];
                    $fileSize = $_FILES["file_upload"]["size"];
                    $fileNameOnly = pathinfo($fileName, PATHINFO_FILENAME);
                    $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
                    $fileNameNew = generate_file_name() . ".$fileExtension";
                    $sourcePath = $_FILES["file_upload"]['tmp_name'];

                    if (array_key_exists($fileExtension, $supportedFileTypeArray)) {
                        $fileExt = $supportedFileTypeArray[$fileExtension];
                        $targetPath = "uploads/file/" . $fileNameNew;

                        $file_id = generate_unique_id(UNIQUE_FILE);


                        if (queritelUploadFile($targetPath, $sourcePath)) {
                            $add_file_query = get_insert_query(TABLE_ALL_FILES,[
                                "file_id" => $file_id,
                                "creation_time" => getCurrentTime(),
                                "original_filename" => $fileNameOnly,
                                "original_ext" => $fileExtension,
                                "file_name" => $fileNameNew,
                                "file_ext" => $fileExt,
                                "file_size" => $fileSize,
                                "creator_id" => $user_id,
                                "network_id" => $network_id,
                                "relationship_type" => FILE_REL_QUEST,
                                "quest_id" => $quest_id
                            ]);
                            $file_query_result = $paperweight->query($add_file_query);
                            if($file_query_result != null && $file_query_result->is_row_affected()){
                                $result = getOKStatus();
                                $result["file_id"] = $file_id;
                            }
                        }
                        else{
                            //upload failed
                        }

                    }
                }
                //$result = getOKStatus();
                //$result["file_id"] = generate_unique_id(UNIQUE_FILE);;

            }


        }

        echo json_export($result);
    }
    //todo = ---------------------------- FILE END ----------------------------


    //todo -----> remove error log
    ini_set('display_errors', '1');

    //todo remove bug
    if ($action == "bug"){

        //require 'payment/gw-stripe/vendor/stripe/stripe-php/init.php';

        //\Stripe\Stripe::setApiKey(STRIPE_PAYMENT_LIVE_KEY);
        //\Stripe\Stripe::setApiKey(STRIPE_PAYMENT_TEST_KEY);

        //$result = get_catalog_item("catalog-afodjbt-5800670-uvhockc");
        //$result = get_catalog_item("catalog-afodjbt-5800670-uvhockc");

        /*$result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        if (isset($_FILES["file_upload"]["tmp_name"])) {
            $fileName = $_FILES["file_upload"]['name'];
            $fileError = $_FILES["file_upload"]['error'];
            $fileSize = $_FILES["file_upload"]["size"];
            $fileNameOnly = pathinfo($fileName, PATHINFO_FILENAME);
            $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
            $fileNameNew = generate_file_name() . ".$fileExtension";
            $sourcePath = $_FILES["file_upload"]['tmp_name'];

            $supportedFileTypeArray = array(
                'png' => 'ext_png',
                'jpg' => 'ext_jpg',
                'jpeg' => 'ext_jpg',
                'pdf' => 'ext_pdf',
                'docx' => 'ext_docx',
                'mp4' => 'ext_mp4',
                'html' => 'ext_html'
            );

            if (array_key_exists($fileExtension, $supportedFileTypeArray)) {
                $fileExt = $supportedFileTypeArray[$fileExtension];
                //$targetPath = "uploads/file/" . $fileName;
                $targetPath = "uploads/file/" . $fileNameNew;

                $result = getOKStatus();

                $result["file_name"] = $fileName;
                $result["file_name_new"] = $fileNameNew;
                $result["file_size"] = $fileSize;
                $result["file_name_only"] = $fileNameOnly;
                $result["file_name_random"] = generate_file_name();
                $result["file_extension"] = $fileExtension;
                $result["file_ext"] = $fileExt;

                if (queritelUploadFile($targetPath, $sourcePath)) {
                    //$result = getOKStatus();
                    $result["file_url"] = FTP_Q_HOST_DIRECTORY . "/uploads/file/$fileNameNew";
                    $result["success"] = true;
                }
                else{
                    $result["success"] = false;
                }
            }

        } else {
            $result["demo_field_file_name"] = "No Files were uploaded";
        }*/

        //$result = array();

        //$result["name"] = "kadian";
        $result = storesWithProduct("Lavalozas Limón Bidón");

        //-- {"paymentIntent":{"id":"pi_3KRIj1JyH9e69bzm1Vei2tTd","object":"payment_intent","amount":10329,
        //"automatic_payment_methods":null,"canceled_at":null,"cancellation_reason":null,
        //"capture_method":"automatic","client_secret":"pi_3KRIj1JyH9e69bzm1Vei2tTd_secret_LMRWchGwcGo2SYmoXMXd5qRus",
        //"confirmation_method":"automatic","created":1644422939,"currency":"usd",
        //"description":"Queritel Wallet Deposit","last_payment_error":null,
        //"livemode":false,"next_action":null,"payment_method":"pm_1KRIjIJyH9e69bzmEaBYNWQ8",
        //"payment_method_types":["card"],"processing":null,"receipt_email":"kadansalmon.ks@gmail.com",
        //"setup_future_usage":null,"shipping":null,"source":null,"status":"succeeded"}}

        //stripe payment id - pm_1KRIjIJyH9e69bzmEaBYNWQ8


        echo json_export($result);
    }


    //fixme = ---------------------------- QUEST START ----------------------------
    //todo - ACTION_CREATE_QUEST = "create_quest" - sample
    //todo - ACTION_GET_QUEST_DATA = "get_quest_data" - sample
    //todo - ACTION_UPDATE_QUEST_DATA = "update_quest_data" - sample

    //todo - ACTION_UPLOAD_GEOJSON = "upload_geojson" - test
    //todo - ACTION_APPLY_GEOJSON = "apply_geojson" - test
    //todo - ACTION_GET_SECTOR_LIST = "get_sector_list" - test
    //todo - ACTION_GET_SECTOR_DATA = "get_sector_data" - test
    //todo - ACTION_ADD_SECTOR = "add_sector" - test
    //todo - ACTION_REMOVE_SECTOR = "remove_sector" - test
    //todo - ACTION_UPDATE_SECTOR = "update_sector_data" - test
    //todo - ACTION_UPDATE_SECTOR_TARGET = "update_sector_target" - test



    //todo - NYI - sample
    if ($action == "create_quest"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }


            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "quest_id": "299"
            }';

        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

        //echo json_export($result);
    }

    //todo - NYI - sample
    if ($action == "get_quest_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);


        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }


            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "quest_data": {
                "quest_id": "299",
                "activity_type": "activity_discovery",
                "quest_state": "5",
                "task_topic": "Health Facilities",
                "tag_effort": "600",
                "task_time_day": "1",
                "task_question_type": "2",
                "task_question_count": "0",
                "task_respondent_count": "200",
                "response_limit": "0",
                "task_location_count": "10",
                "task_start_date": "2021-03-15 07:30:00",
                "task_due_date": "2021-03-12 18:10:00",
                "workforce_timezone": "Asia/Kabul",
                "workforce_country": "JM",
                "task_instructions": "Visiting grocery stores documenting what kinds of brand items see outside using the form and taking pictures.",
                "completion_url": "https://api.queritel.com/api/mobile/queritel/insight/completion/trigger.html",
                "my_team": "1",
                "community_list": [
                  "community_id_1",
                  "community_id_2"
                ],
                "handle_payment": "0",
                "payout_per_response": "0",
                "payout_total": "0",
                "task_budget": "389",
                "usage_fee": "20",
                "processing_fee": "20",
                "sector_count": "10"
              }
            }';

        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

        //echo json_export($result);
    }

    //todo - NYI - sample
    if ($action == "update_quest_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }


            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK"
            }';

        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

        //echo json_export($result);
    }



    //todo - 99% - pending - proper file validation
    if ($action == "upload_geojson"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                if (isset($_FILES["file_upload"]["tmp_name"])){
                    $supportedFileTypeArray = array(
                        'json' => 'ext_json',
                        'geojson' => 'ext_json'
                    );
                    $fileName = $_FILES["file_upload"]['name'];
                    //$fileError = $_FILES["file_upload"]['error'];
                    $fileSize = $_FILES["file_upload"]["size"];
                    $fileNameOnly = pathinfo($fileName, PATHINFO_FILENAME);
                    $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
                    $fileNameNew = generate_file_name() . ".$fileExtension";
                    $sourcePath = $_FILES["file_upload"]['tmp_name'];

                    if (array_key_exists($fileExtension, $supportedFileTypeArray)) {
                        $fileExt = $supportedFileTypeArray[$fileExtension];
                        $targetPath = "uploads/file/" . $fileNameNew;

                        $file_id = generate_unique_id(UNIQUE_FILE);


                        if (queritelUploadFile($targetPath, $sourcePath)) {
                            $add_file_query = get_insert_query(TABLE_ALL_FILES,[
                                "file_id" => $file_id,
                                "creation_time" => getCurrentTime(),
                                "original_filename" => $fileNameOnly,
                                "original_ext" => $fileExtension,
                                "file_name" => $fileNameNew,
                                "file_ext" => $fileExt,
                                "file_size" => $fileSize,
                                "creator_id" => $user_id,
                                "network_id" => $network_id,
                                "relationship_type" => FILE_REL_QUEST,
                                "quest_id" => $quest_id,
                                "is_hidden" => 1
                            ]);
                            $file_query_result = $paperweight->query($add_file_query);
                            if($file_query_result != null && $file_query_result->is_row_affected()){

                                $geo_json_data = file_get_contents($sourcePath);
                                $geo_json = json_decode($geo_json_data, true);


                                $geo_type = $geo_json["type"];
                                $geo_feature_list = $geo_json["features"];

                                $feature_count = count($geo_feature_list);
                                $single_sector = false;
                                $sector_data = null;
                                $found_properties = array();

                                if($feature_count > 0){
                                    if ($feature_count == 1){
                                        $single_sector = true;

                                        $geo_index = 0;

                                        $feature = $geo_feature_list[$geo_index];
                                        $geometry = $feature["geometry"];
                                        $properties = $feature["properties"];

                                        $geometry_type = strtolower($geometry["type"]);
                                        $geometry_coordinates = $geometry["coordinates"];

                                        $sector_data = array();//MultiPolygon

                                        if ($geometry_type == "point"){

                                            $sector_data["location_type"] = LOCATION_TYPE_POINT;
                                            $sector_data["coordinates"] = $geometry_coordinates;
                                        }
                                        elseif ($geometry_type == "polygon"){

                                            $sector_data["location_type"] = LOCATION_TYPE_POLYGON;
                                            $sector_data["coordinates"] = $geometry_coordinates[0];
                                        }
                                        elseif ($geometry_type == "multipolygon"){

                                            $sector_data["location_type"] = LOCATION_TYPE_MULTI_POLYGON;

                                            $local_polygon_list = array();

                                            foreach ($geometry_coordinates as $geo_json_polygon) {
                                                $local_polygon_list[] = $geo_json_polygon[0];
                                            }


                                            $sector_data["coordinates"] = $local_polygon_list;
                                        }

                                        foreach ($properties as $key => $value) {
                                            $found_properties[$key]["prop_id"] = $key;
                                            $found_properties[$key]["prop_sample"][] = $value;
                                        }

                                        if (!empty($found_properties)){

                                            $new_properties = array();

                                            foreach ($found_properties as $key => $value) {

                                                $prop = array();
                                                $prop["prop_id"] = $value["prop_id"];
                                                $prop["prop_sample"] = join($value["prop_sample"],", ");

                                                $new_properties[] = $prop;

                                                $found_properties = $new_properties;

                                            }

                                        }

                                    }
                                    else{
                                        $geo_index = 0;

                                        foreach ($geo_feature_list as $feature) {

                                            $feature = $geo_feature_list[$geo_index];
                                            $geometry = $feature["geometry"];
                                            $properties = $feature["properties"];

                                            $geometry_type = strtolower($geometry["type"]);
                                            $geometry_coordinates = $geometry["coordinates"];

                                            if ($geometry_type == "point"){

                                                //$sector_data["location_type"] = LOCATION_TYPE_POINT;
                                                //$sector_data["coordinates"] = $geometry_coordinates;
                                            }
                                            elseif ($geometry_type == "polygon"){

                                                //$sector_data["location_type"] = LOCATION_TYPE_POLYGON;
                                                //$sector_data["coordinates"] = $geometry_coordinates[0];
                                            }

                                            foreach ($properties as $key => $value) {
                                                $found_properties[$key]["prop_id"] = $key;
                                                $found_properties[$key]["prop_sample"][] = $value;
                                            }

                                            $geo_index++;
                                        }

                                        if (!empty($found_properties)){

                                            $new_properties = array();

                                            foreach ($found_properties as $key => $value) {

                                                $prop = array();
                                                $prop["prop_id"] = $value["prop_id"];
                                                $prop["prop_sample"] = join($value["prop_sample"],", ");

                                                $new_properties[] = $prop;

                                                $found_properties = $new_properties;

                                            }

                                        }

                                    }

                                }


                                /*{
                                    "type": "FeatureCollection",
                                    "features": [
                                        {
                                            "type": "Feature",
                                            "geometry": {
                                                "type": "Point",
                                                "coordinates": [
                                                    -77.040178999999994857716956175863742828369140625,
                                                    38.92650900000000291356627712957561016082763671875
                                                ]
                                            },
                                            "properties": {
                                                "name": "Santiago",
                                                "location": "Store 1"
                                            }
                                        }
                                    ]
                                }*/
                                /*{
                                  "status": "OK",
                                  "file_id": "fid-jgydlki-7545874-fgsordi", //unique file id
                                  "map_name": "sample_uploaded_json", // The default map name
                                  "single_sector": true, //if the uploaded file only has a single feature
                                  "sector_data": { //this is null if single_sector is false
                                    "location_type": "type_point",
                                    "coordinates": [
                                      -77.3333,
                                      -33.8948
                                    ]
                                  },
                                  "property_list": [
                                    {
                                      "prop_id": "location_name",
                                      "prop_sample": "Store A, Store B"
                                    },
                                    {
                                      "prop_id": "region",
                                      "prop_sample": "Recoleta, Providencia"
                                    }
                                  ]
                                }*/
                                $result = getOKStatus();
                                $result["file_id"] = $file_id;
                                $result["map_name"] = $fileNameOnly;
                                $result["single_sector"] = $single_sector;
                                $result["sector_data"] = $sector_data;
                                $result["property_list"] = $found_properties;


                            }
                        }
                        else{
                            //upload failed
                        }

                    }
                }

            }


        }

        echo json_export($result);
    }
    if ($action == "upload_geojson_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                if (isset($_FILES["file_upload"]["tmp_name"])){
                    $supportedFileTypeArray = array(
                        'json' => 'ext_json',
                        'geojson' => 'ext_json'
                    );
                    $fileName = $_FILES["file_upload"]['name'];
                    //$fileError = $_FILES["file_upload"]['error'];
                    $fileSize = $_FILES["file_upload"]["size"];
                    $fileNameOnly = pathinfo($fileName, PATHINFO_FILENAME);
                    $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
                    $fileNameNew = generate_file_name() . ".$fileExtension";
                    $sourcePath = $_FILES["file_upload"]['tmp_name'];

                    if (array_key_exists($fileExtension, $supportedFileTypeArray)) {
                        $fileExt = $supportedFileTypeArray[$fileExtension];
                        $targetPath = "uploads/file/" . $fileNameNew;

                        $file_id = generate_unique_id(UNIQUE_FILE);


                        //queritelUploadFile($targetPath, $sourcePath)
                        if (true) {
                            $add_file_query = get_insert_query(TABLE_ALL_FILES,[
                                "file_id" => $file_id,
                                "creation_time" => getCurrentTime(),
                                "original_filename" => $fileNameOnly,
                                "original_ext" => $fileExtension,
                                "file_name" => $fileNameNew,
                                "file_ext" => $fileExt,
                                "file_size" => $fileSize,
                                "creator_id" => $user_id,
                                "network_id" => $network_id,
                                "relationship_type" => FILE_REL_QUEST,
                                "quest_id" => $quest_id,
                                "is_hidden" => 1
                            ]);
                            //$file_query_result = $paperweight->query($add_file_query);
                            //$file_query_result != null && $file_query_result->is_row_affected()
                            if(true){

                                $geo_json_data = file_get_contents($sourcePath);
                                $geo_json = json_decode($geo_json_data, true);


                                $geo_type = $geo_json["type"];
                                $geo_feature_list = $geo_json["features"];

                                $feature_count = count($geo_feature_list);
                                $single_sector = false;
                                $sector_data = null;
                                $found_properties = array();

                                if($feature_count > 0){
                                    if ($feature_count == 1){
                                        $single_sector = true;

                                        $geo_index = 0;

                                        $feature = $geo_feature_list[$geo_index];
                                        $geometry = $feature["geometry"];
                                        $properties = $feature["properties"];

                                        $geometry_type = strtolower($geometry["type"]);
                                        $geometry_coordinates = $geometry["coordinates"];

                                        $sector_data = array();

                                        if ($geometry_type == "point"){

                                            $sector_data["location_type"] = LOCATION_TYPE_POINT;
                                            $sector_data["coordinates"] = $geometry_coordinates;
                                        }
                                        elseif ($geometry_type == "polygon"){

                                            $sector_data["location_type"] = LOCATION_TYPE_POLYGON;
                                            $sector_data["coordinates"] = $geometry_coordinates[0];
                                        }

                                        foreach ($properties as $key => $value) {
                                            $found_properties[$key]["prop_id"] = $key;
                                            $found_properties[$key]["prop_sample"][] = $value;
                                        }

                                        if (!empty($found_properties)){

                                            $new_properties = array();

                                            foreach ($found_properties as $key => $value) {

                                                $prop = array();
                                                $prop["prop_id"] = $value["prop_id"];
                                                $prop["prop_sample"] = join($value["prop_sample"],", ");

                                                $new_properties[] = $prop;

                                                $found_properties = $new_properties;

                                            }

                                        }

                                    }
                                    else{
                                        $geo_index = 0;

                                        foreach ($geo_feature_list as $feature) {

                                            $feature = $geo_feature_list[$geo_index];
                                            $geometry = $feature["geometry"];
                                            $properties = $feature["properties"];

                                            $geometry_type = strtolower($geometry["type"]);
                                            $geometry_coordinates = $geometry["coordinates"];

                                            if ($geometry_type == "point"){

                                                //$sector_data["location_type"] = LOCATION_TYPE_POINT;
                                                //$sector_data["coordinates"] = $geometry_coordinates;
                                            }
                                            elseif ($geometry_type == "polygon"){

                                                //$sector_data["location_type"] = LOCATION_TYPE_POLYGON;
                                                //$sector_data["coordinates"] = $geometry_coordinates[0];
                                            }

                                            foreach ($properties as $key => $value) {
                                                $found_properties[$key]["prop_id"] = $key;
                                                $found_properties[$key]["prop_sample"][] = $value;
                                            }

                                            $geo_index++;
                                        }

                                        if (!empty($found_properties)){

                                            $new_properties = array();

                                            foreach ($found_properties as $key => $value) {

                                                $prop = array();
                                                $prop["prop_id"] = $value["prop_id"];
                                                $prop["prop_sample"] = join($value["prop_sample"],", ");

                                                $new_properties[] = $prop;

                                                $found_properties = $new_properties;

                                            }

                                        }

                                    }

                                }


                                /*{
                                    "type": "FeatureCollection",
                                    "features": [
                                        {
                                            "type": "Feature",
                                            "geometry": {
                                                "type": "Point",
                                                "coordinates": [
                                                    -77.040178999999994857716956175863742828369140625,
                                                    38.92650900000000291356627712957561016082763671875
                                                ]
                                            },
                                            "properties": {
                                                "name": "Santiago",
                                                "location": "Store 1"
                                            }
                                        }
                                    ]
                                }*/
                                /*{
                                  "status": "OK",
                                  "file_id": "fid-jgydlki-7545874-fgsordi", //unique file id
                                  "map_name": "sample_uploaded_json", // The default map name
                                  "single_sector": true, //if the uploaded file only has a single feature
                                  "sector_data": { //this is null if single_sector is false
                                    "location_type": "type_point",
                                    "coordinates": [
                                      -77.3333,
                                      -33.8948
                                    ]
                                  },
                                  "property_list": [
                                    {
                                      "prop_id": "location_name",
                                      "prop_sample": "Store A, Store B"
                                    },
                                    {
                                      "prop_id": "region",
                                      "prop_sample": "Recoleta, Providencia"
                                    }
                                  ]
                                }*/
                                $result = getOKStatus();
                                $result["file_id"] = $file_id;
                                $result["map_name"] = $fileNameOnly;
                                $result["single_sector"] = $single_sector;
                                $result["sector_data"] = $sector_data;
                                $result["property_list"] = $found_properties;


                            }
                        }
                        else{
                            //upload failed
                        }

                    }
                }

            }


        }

        echo json_export($result);
    }


    //todo - 99% - pending - realtime coord resolution (reverse geocode api)
    if ($action == "apply_geojson"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $quest_id = text_clean($data["quest_id"]);
        $file_id = text_clean($data["file_id"]);
        $map_name = text_clean($data["map_name"]);
        $sector_data = $data["sector_data"]; //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                $file_data = getFileData($file_id, $network_id, $paperweight);
                if (!empty($file_data)){
                    $file_url = $file_data["file_url"];
                    $file_content = file_get_contents($file_url);

                    $geo_json = json_decode($file_content, true);

                    $geo_type = $geo_json["type"];
                    $geo_feature_list = $geo_json["features"];

                    $feature_count = count($geo_feature_list);

                    if (!empty($sector_data) && !empty($sector_data["sector_id"])){
                        //single sector upload
                        $sector_id = text_clean($sector_data["sector_id"]);
                        $sector_prop_id = text_clean($sector_data["sector_prop_id"]);

                        if($feature_count > 0){
                            if ($feature_count == 1){
                                $geo_index = 0;

                                $feature = $geo_feature_list[$geo_index];
                                $geometry = $feature["geometry"];
                                $properties = $feature["properties"];

                                $geometry_type = strtolower($geometry["type"]);
                                $geometry_coordinates = $geometry["coordinates"];

                                $location_type = null;
                                $location_coordinates = array();

                                if ($geometry_type == "point"){
                                    $location_type = LOCATION_TYPE_POINT;
                                    $location_coordinates = $geometry_coordinates;
                                }
                                elseif ($geometry_type == "polygon"){
                                    $location_type = LOCATION_TYPE_POLYGON;
                                    $location_coordinates = $geometry_coordinates[0];
                                }
                                elseif ($geometry_type == "multipolygon"){

                                    $location_type = LOCATION_TYPE_MULTI_POLYGON;

                                    $local_polygon_list = array();
                                    foreach ($geometry_coordinates as $geo_json_polygon) {
                                        $local_polygon_list[] = $geo_json_polygon[0];
                                    }
                                    $location_coordinates = $local_polygon_list;
                                }

                                //update here
                                if (!empty($sector_prop_id)){
                                    $sector_query = get_update_query(TABLE_QUEST_SECTORS, [
                                        "update_time" => getCurrentTime(),
                                        "sector_name" => $properties[$sector_prop_id]
                                    ], "network_id = '$network_id' and sector_id = '$sector_id'" );
                                    $sector_result = $paperweight->query($sector_query);
                                    if($sector_result != null && $sector_result->is_row_affected()){
                                        $result = getOKStatus();
                                    }
                                }

                                if (!empty($location_coordinates)){
                                    $sector_query = get_update_query(TABLE_QUEST_TARGETS, [
                                        "update_time" => getCurrentTime(),
                                        "country" => null,
                                        "country_code" => null,
                                        "region" => null,
                                        "address" => null,
                                        "location_type" => $location_type,
                                        "tag_radius" => 0,
                                        "coordinates" => json_encode($location_coordinates),

                                    ], "network_id = '$network_id' and sector_id = '$sector_id'" );
                                    $sector_result = $paperweight->query($sector_query);
                                    if($sector_result != null && $sector_result->is_row_affected()){
                                        $result = getOKStatus();
                                    }
                                }
                                else{
                                    $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);
                                }

                            }
                        }

                    }
                    elseif (!empty($sector_data)){
                        //multi sector upload
                        $sector_prop_id = text_clean($sector_data["sector_prop_id"]);

                        if($feature_count > 0){
                            $geo_index = 0;

                            foreach ($geo_feature_list as $feature) {

                                $feature = $geo_feature_list[$geo_index];
                                $geometry = $feature["geometry"];
                                $properties = $feature["properties"];

                                $geometry_type = strtolower($geometry["type"]);
                                $geometry_coordinates = $geometry["coordinates"];

                                $location_type = null;
                                $location_coordinates = array();

                                if ($geometry_type == "point"){
                                    $location_type = LOCATION_TYPE_POINT;
                                    $location_coordinates = $geometry_coordinates;
                                }
                                elseif ($geometry_type == "polygon"){
                                    $location_type = LOCATION_TYPE_POLYGON;
                                    $location_coordinates = $geometry_coordinates[0];
                                }
                                elseif ($geometry_type == "multipolygon"){

                                    $location_type = LOCATION_TYPE_MULTI_POLYGON;

                                    $local_polygon_list = array();
                                    foreach ($geometry_coordinates as $geo_json_polygon) {
                                        $local_polygon_list[] = $geo_json_polygon[0];
                                    }
                                    $location_coordinates = $local_polygon_list;
                                }

                                //add here
                                if (!empty($location_coordinates)){
                                    $job_id = generateNumericId(); //todo - for back compat (replaced by sector id)
                                    $sector_id = generate_unique_id(UNIQUE_SECTOR);
                                    $target_id = generate_unique_id(UNIQUE_TARGET);
                                    $creation_time = getCurrentTime();

                                    $insert_array = array(
                                        "sector_id" => $sector_id,
                                        "creation_time" => $creation_time,
                                        "network_id" => $network_id,
                                        "creator_id" => $user_id,
                                        "quest_id" => $quest_id,
                                        "job_id" => $job_id,
                                        "target_id" => $target_id
                                    );

                                    if (!empty($sector_prop_id)){
                                        $insert_array["sector_name"] = $properties[$sector_prop_id];
                                    }

                                    $sector_query = get_insert_query(TABLE_QUEST_SECTORS,$insert_array);
                                    $sector_result = $paperweight->query($sector_query);
                                    if($sector_result != null && $sector_result->is_row_affected()){

                                        $target_query = get_insert_query(TABLE_QUEST_TARGETS,[
                                            "target_id" => $target_id,
                                            "sector_id" => $sector_id,
                                            "creation_time" => $creation_time,
                                            "network_id" => $network_id,
                                            "creator_id" => $user_id,
                                            "quest_id" => $quest_id,
                                            "job_id" => $job_id,
                                            "location_type" => $location_type,
                                            "coordinates" => json_encode($location_coordinates)
                                        ]);
                                        $target_result = $paperweight->query($target_query);
                                        if($target_result != null && $target_result->is_row_affected()){

                                            $result = getOKStatus();
                                        }
                                    }

                                }

                                $geo_index++;
                            }

                        }
                    }

                }

            }


            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }
    if ($action == "apply_geojson_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }



    //todo - 99% - test
    if ($action == "add_sector"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $job_id = generateNumericId(); //todo - for back compat (replaced by sector id)
                $sector_id = generate_unique_id(UNIQUE_SECTOR);
                $target_id = generate_unique_id(UNIQUE_TARGET);
                $creation_time = getCurrentTime();

                //for future update
                //"cpq" => $description,  -- future support (sector based cost per response)
                //"currency" => $description,
                $sector_query = get_insert_query(TABLE_QUEST_SECTORS,[
                    "sector_id" => $sector_id,
                    "creation_time" => $creation_time,
                    "network_id" => $network_id,
                    "creator_id" => $user_id,
                    "quest_id" => $quest_id,
                    "job_id" => $job_id,
                    "target_id" => $target_id
                ]);
                $sector_result = $paperweight->query($sector_query);
                if($sector_result != null && $sector_result->is_row_affected()){

                    $target_query = get_insert_query(TABLE_QUEST_TARGETS,[
                        "target_id" => $target_id,
                        "sector_id" => $sector_id,
                        "creation_time" => $creation_time,
                        "network_id" => $network_id,
                        "creator_id" => $user_id,
                        "quest_id" => $quest_id,
                        "job_id" => $job_id
                    ]);
                    $target_result = $paperweight->query($target_query);
                    if($target_result != null && $target_result->is_row_affected()){

                        $result = getOKStatus();
                        $result["sector_id"] = $sector_id;

                    }
                }
            }

        }

        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "get_sector_list"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $sector_list = array();

                $sector_query = "select * from " . TABLE_QUEST_SECTORS . " where network_id = '$network_id' and quest_id = '$quest_id'";
                $sector_query_result = $paperweight->query($sector_query);

                if($sector_query_result != null && $sector_query_result->is_row_found()){
                    while($row = $sector_query_result->fetch_array()){

                        $sector_data = array();
                        $target_data = array();

                        $sector_data["sector_id"] = $row["sector_id"];
                        $sector_data["sector_name"] = $row["sector_name"];
                        $sector_data["agents_required"] = intval($row["agents_required"]);
                        $sector_data["responses_required"] = intval($row["survey_total"]);


                        $target_row = getTargetRaw($row["target_id"], $paperweight);
                        if (!empty($target_row)){

                            $target_data["target_id"] = $target_row["target_id"];
                            $target_data["target_name"] = $target_row["target_name"];

                            $custom_location = array();
                            $custom_location["country"] = $target_row["country"];
                            $custom_location["country_code"] = $target_row["country_code"];
                            $custom_location["region"] = $target_row["region"];
                            $custom_location["address"] = $target_row["address"];
                            $custom_location["location_type"] = $target_row["location_type"];
                            $custom_location["coordinates"] = json_decode($target_row["coordinates"],true);
                            $custom_location["tag_radius"] = intval($target_row["tag_radius"]);

                            $target_data["custom_location"] = $custom_location;
                        }

                        $sector_data["target"] = $target_data;
                        $sector_data["segment_list"] = array();

                        $sector_list[] = $sector_data;
                    }
                }

                $result = getOKStatus();
                $result["sector_list"] = $sector_list;
            }


            /*$res = '{
              "status": "OK",
              "sector_list": [
                {
                  "sector_id": "sid-hgjfhg-jythgg-7464",
                  "sector_name": "Store A",
                  "agents_required": 1,
                  "responses_required": 1,
                  "target": {
                    "target_id": "tid-745674-dfdfdd-dldld",
                    "target_name": null,
                    "custom_location": {
                      "country": "Jamaica",
                      "country_code": "JM",
                      "region": "St. Andrew Parish",
                      "address": "121 Red Hills Rd, Kingston, Jamaica",
                      "location_type": "type_point",
                      "coordinates": [
                        -33.433815,
                        -70.587639
                      ],
                      "tag_radius": 100
                    },
                    "segment_list": []
                  }
                },
                {
                  "sector_id": "sid-fgditoei-4653645-gfjjg",
                  "sector_name": "Store B",
                  "agents_required": 1,
                  "responses_required": 1,
                  "target": {
                    "target_id": "tid-745674-dfdfdd-dldld",
                    "target_name": null,
                    "custom_location": {
                      "country": "Jamaica",
                      "country_code": "JM",
                      "state": "St. Andrew Parish",
                      "address": "121 Red Hills Rd, Kingston, Jamaica",
                      "location_type": "type_polygon",
                      "coordinates": [
                        [
                          -33.433815,
                          -70.587639
                        ],
                        [
                          -33.433815,
                          -70.587639
                        ],
                        [
                          -33.433815,
                          -70.587639
                        ]
                      ],
                      "tag_radius": 0
                    },
                    "segment_list": []
                  }
                }
              ]
            }';*/

        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "get_sector_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sector_id = text_clean($data["sector_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_NOT_FOUND);

                $sector_query = "select * from " . TABLE_QUEST_SECTORS . " where network_id = '$network_id' and sector_id = '$sector_id'";
                $sector_query_result = $paperweight->query($sector_query);

                if($sector_query_result != null && $sector_query_result->is_row_found()){
                    if($row = $sector_query_result->fetch_array()){

                        $sector_data = array();
                        $target_data = array();

                        $sector_data["sector_id"] = $row["sector_id"];
                        $sector_data["sector_name"] = $row["sector_name"];
                        $sector_data["agents_required"] = intval($row["agents_required"]);
                        $sector_data["responses_required"] = intval($row["survey_total"]);


                        $target_row = getTargetRaw($row["target_id"], $paperweight);
                        if (!empty($target_row)){

                            $target_data["target_id"] = $target_row["target_id"];
                            $target_data["target_name"] = $target_row["target_name"];

                            $custom_location = array();
                            $custom_location["country"] = $target_row["country"];
                            $custom_location["country_code"] = $target_row["country_code"];
                            $custom_location["region"] = $target_row["region"];
                            $custom_location["address"] = $target_row["address"];
                            $custom_location["location_type"] = $target_row["location_type"];
                            $custom_location["coordinates"] = json_decode($target_row["coordinates"],true);
                            $custom_location["tag_radius"] = intval($target_row["tag_radius"]);

                            $target_data["custom_location"] = $custom_location;
                        }

                        $sector_data["target"] = $target_data;
                        $sector_data["segment_list"] = array();

                        $result = getOKStatus();
                        $result["sector_data"] = $sector_data;

                    }
                }
            }

        }

        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "update_sector_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sector_id = text_clean($data["sector_id"]);
        $sector_data = $data["sector_data"];


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                //api_fields => db_fields
                $all_update_fields = array(
                    "sector_name" => "sector_name",
                    "agents_required" => "agents_required",
                    "responses_required" => "survey_total"
                );
                $valid_update_fields = array();
                $valid_update_fields["update_time"] = getCurrentTime();
                foreach ($sector_data as $key => $value) {
                    if (array_key_exists($key, $all_update_fields)){
                        $valid_key = $all_update_fields[$key];
                        $cleaned_val = text_clean($value);

                        $valid_update_fields[$valid_key] = $cleaned_val;
                    }
                }

                if (!empty($valid_update_fields)){
                    $sector_query = get_update_query(TABLE_QUEST_SECTORS, $valid_update_fields, "network_id = '$network_id' and sector_id = '$sector_id'" );
                    $sector_result = $paperweight->query($sector_query);
                    if($sector_result != null && $sector_result->is_row_affected()){
                        $result = getOKStatus();
                    }
                    else{
                        $result = getOKStatus(); //todo -- add unchanged error here
                    }
                }
            }

        }

        echo json_export($result);
    }

    //todo - 90 - fixme - clean, round and validate coordinates (based on location type)
    if ($action == "update_sector_target"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sector_id = text_clean($data["sector_id"]);
        $custom_location = $data["custom_location"];


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                //id, target_id, creation_time, update_time, target_name, sector_id,
                // job_id, quest_id, creator_id, network_id,
                // country, country_code, region, address, location_type, coordinates, tag_radius

                //"country": "Jamaica",
                //    "country_code": "JM",
                //    "region": "St. Andrew Parish",
                //    "address": "121 Red Hills Rd, Kingston, Jamaica",
                //    "location_type": "type_point", //NOTICE : check Api properties for supported values
                //    "coordinates": [
                //      -33.433815,
                //      -70.587639
                //    ],
                //    "tag_radius": 100

                $country_name = text_clean($custom_location["country"]);
                $country_code = text_clean($custom_location["country_code"]);
                $region = text_clean($custom_location["region"]);
                $address = text_clean($custom_location["address"]);
                $location_type = text_clean($custom_location["location_type"]);
                $tag_radius = text_clean($custom_location["tag_radius"]);

                $coordinates = array();

                $coordinates = $custom_location["coordinates"];

                $sector_query = get_update_query(TABLE_QUEST_TARGETS, [
                    "update_time" => getCurrentTime(),
                    "country" => $country_name,
                    "country_code" => strtoupper($country_code),
                    "region" => $region,
                    "address" => $address,
                    "location_type" => $location_type,
                    "tag_radius" => $tag_radius,
                    "coordinates" => json_encode($coordinates),

                ], "network_id = '$network_id' and sector_id = '$sector_id'" );
                $sector_result = $paperweight->query($sector_query);
                if($sector_result != null && $sector_result->is_row_affected()){
                    $result = getOKStatus();
                }
                else{
                    $result = getOKStatus(); //todo -- add unchanged error here
                }

            }


            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK"
            }';

        }

        /*if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }*/

        echo json_export($result);
    }

    //todo - 99% - test
    if ($action == "remove_sector"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $sector_id = text_clean($data["sector_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];

                $result = getErrorStatus(ERROR_MSG_NOT_FOUND);

                $sector_query = "delete from " . TABLE_QUEST_SECTORS . " where network_id = '$network_id' and sector_id = '$sector_id'";
                $sector_query_result = $paperweight->query($sector_query);

                if($sector_query_result != null && $sector_query_result->is_row_affected()){
                    $target_query = "delete from " . TABLE_QUEST_TARGETS . " where network_id = '$network_id' and sector_id = '$sector_id'";
                    $target_query_result = $paperweight->query($target_query);

                    if($target_query_result != null && $target_query_result->is_row_affected()){
                        $result = getOKStatus();
                    }
                }

            }

        }

        echo json_export($result);
    }
    //fixme = ---------------------------- QUEST END ----------------------------


    //payment structure
    //get wallet data -- failed transaction
    //initialize_deposit - initialize the stripe operation to load funds to wallet (with / without invoice_id)
    //complete_deposit - this actually logs the funds deposited to the wallet (and auto hold if its for a specific purchase)

    //get quest payment - get invoice data for the specific quest (invoice table)

    //fixme = ---------------------------- WALLET START ----------------------------
    //todo - ACTION_GET_WALLET_DATA = "get_wallet_data"         - sample
    //todo - ACTION_WALLET_HISTORY = "get_wallet_history"       - sample


    //todo - ACTION_INITIATE_DEPOSIT = "initiate_deposit"       - sample
    //todo - ACTION_UPDATE_DEPOSIT = "update_deposit"           - sample


    //todo - ACTION_GET_QUEST_PAYMENT = "get_quest_payment"     - sample
    //todo - ACTION_GET_SAMPLE_PAYMENT = "get_sample_payment"      - sample

    //todo - ACTION_OFFSET_COST = "offset_wallet_cost"          - sample
    //todo - ACTION_SPLIT_PAYMENT = "split_payment"             - sample



    //todo - 99% - test
    if ($action == "get_wallet_data_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "account_holder": {
                "user_id": "1234",
                "user_name": "Kevin Smith"
              },
              "wallet_data": {
                "currency": "USD",
                "balance_available": 2800,
                "balance_holding": 100
              }
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    if ($action == "get_wallet_data"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $account_holder = $network_detail["account_holder"];


                $user_data = query_user($account_holder, $paperweight);

                $account_holder_data = array();
                $account_holder_data["user_id"] = null;
                $account_holder_data["user_name"] = null;

                if (!empty($user_data)){

                    $name = stringCase($user_data["fname"] . " " . $user_data["lname"],STRING_CASE_CAP_EACH);

                    $account_holder_data["user_id"] = $user_data["user_id"];
                    $account_holder_data["user_name"] = $name;
                }

                $wallet_balance = getWalletBalance($network_id,$paperweight);
                $holding_balance = getHoldingBalance($network_id,$paperweight);

                $wallet_data = array();
                $wallet_data["currency"] = SYSTEM_CURRENCY;
                $wallet_data["balance_available"] = $wallet_balance;
                $wallet_data["balance_holding"] = ($holding_balance);

                $result = getOKStatus();
                $result["account_holder"] = $account_holder_data;
                $result["wallet_data"] = $wallet_data;

            }


            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/


            /*$res = '{
              "status": "OK",
              "account_holder": {
                "user_id": "1234",
                "user_name": "Kevin Smith"
              },
              "wallet_data": {
                "currency": "USD",
                "balance_available": 2800,
                "balance_holding": 100
              }
            }';*/

            //echo json_export($result);
        }


        echo json_export($result);
    }

    //todo - 99% - test - test stripe key
    if ($action == "initiate_deposit_deprecated"){
        //wallet
        //`id` int(11) NOT NULL AUTO_INCREMENT,
        //  `creation_time` datetime DEFAULT NULL,
        //  `update_time` datetime DEFAULT NULL,
        //  `payment_id` varchar(40) DEFAULT NULL,
        //  `quest_id` int(11) DEFAULT NULL,
        //  `creator_id` INT(11) DEFAULT NULL,
        //  `network_id` VARCHAR(60) DEFAULT NULL,
        //  `amount` decimal(13,4) DEFAULT NULL,
        //  `currency` varchar(15) DEFAULT NULL,
        //  `local_currency` varchar(15) DEFAULT NULL,
        //  `local_currency_rate` decimal(13,4) DEFAULT NULL,
        //  `paid` int(11) DEFAULT '0' comment "if this entry has be used towards paying for something",
        //  `paid_time` datetime DEFAULT NULL,
        //  `amount_paid` decimal(13,4) DEFAULT NULL,
        //  `deposit_id` varchar(40) DEFAULT NULL,

        //deposit
        //`id` int(11) NOT NULL AUTO_INCREMENT,
        //  `creation_time` datetime DEFAULT NULL,
        //  `update_time` datetime DEFAULT NULL,
        //  `deposit_id` varchar(40) DEFAULT NULL,
        //  `payment_id` varchar(40) DEFAULT NULL,
        //  `status` varchar(30) DEFAULT NULL comment "failed, success, incomplete, cancelled",
        //  `amount` decimal(13,4) DEFAULT NULL,
        //  `currency` varchar(15) DEFAULT NULL,
        //  `creator_id` INT(11) DEFAULT NULL,
        //  `network_id` VARCHAR(40) DEFAULT NULL,
        //  `invoice_id` VARCHAR(40) DEFAULT NULL,
        //  `invoice_item_id` VARCHAR(40) DEFAULT NULL,
        //  `use_case` VARCHAR(20) DEFAULT NULL comment "wallet | purchase",
        //  `billing_name` VARCHAR(60) DEFAULT NULL,
        //  `billing_email` VARCHAR(200) DEFAULT NULL,
        //  `billing_comment` longtext DEFAULT NULL,
        //  `stripe_response` longtext DEFAULT NULL,

        //include 'payment/gw-stripe/vendor/autoload.php';
        require 'payment/gw-stripe/vendor/stripe/stripe-php/init.php';

        //\Stripe\Stripe::setApiKey(STRIPE_PAYMENT_LIVE_KEY);
        \Stripe\Stripe::setApiKey(STRIPE_PAYMENT_TEST_KEY);



        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $amount = text_clean($data["amount"]);
        $invoice_id = text_clean($data["invoice_id"]);
        $billing_details = $data["billing_details"];


        $billing_name = null;
        $billing_email = null;
        $billing_comment = null;

        if (!empty($billing_details)){
            $billing_name = text_clean($billing_details["name"]);
            $billing_email = text_clean($billing_details["email"]);
            $billing_comment = text_clean($billing_details["comment"]);
        }


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $account_holder = $network_detail["account_holder"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);


                if (!empty($invoice_id)){
                    //for purchase
                }
                else{
                    //for loading wallet

                    $stripe_fee = 0;
                    $total_charge = 0;

                    $stripe_charge = getStripeCharge($amount);
                    $stripe_fee = $stripe_charge["stripe_fee"];
                    $total_charge = $stripe_charge["total_charge"];


                    $amount_converted = intval(($total_charge) * 100);
                    $currency = strtolower(SYSTEM_CURRENCY);
                    $description = 'Queritel Wallet Deposit';
                    $comment = $billing_comment;
                    $email = $billing_email;
                    $deposit_id = generate_unique_id(UNIQUE_DEPOSIT);


                    $intent = \Stripe\PaymentIntent::create([
                        'amount' => $amount_converted,
                        'currency' => $currency,
                        'description' => $description,
                        'receipt_email' => $email,
                        'payment_method_types' => ['card'],
                        'metadata' => [
                            'integration_check' => 'accept_a_payment',
                            'comment' => $comment,
                            'deposit_id' => $deposit_id
                        ],
                    ]);

                    $deposit_query = get_insert_query(TABLE_CLIENT_DEPOSIT, [
                        "creation_time" => getCurrentTime(),
                        "deposit_id" => $deposit_id,
                        "status" => "incomplete",
                        "amount" => $amount,
                        "currency" => SYSTEM_CURRENCY,
                        "creator_id" => $user_id,
                        "network_id" => $network_id,
                        "billing_name" => $billing_name,
                        "billing_email" => $billing_email,
                        "billing_comment" => $billing_comment,
                        "use_case" => "wallet"
                    ]);

                    $deposit_result = $paperweight->query($deposit_query);
                    if($deposit_result != null && $deposit_result->is_row_affected()){

                        $deposit_data = array();
                        $deposit_data["deposit_id"] = $deposit_id;
                        $deposit_data["amount"] = $amount;
                        $deposit_data["currency"] = strtoupper(SYSTEM_CURRENCY);
                        $deposit_data["stripe_fee"] = round($stripe_fee,2);
                        $deposit_data["total_charge"] = round($total_charge,2);
                        $deposit_data["creation_time"] = getCurrentTime();


                        $billing_data = array();
                        $billing_data["name"] = $billing_name;
                        $billing_data["email"] = $billing_email;
                        $billing_data["comment"] = $billing_comment;


                        $result = getOKStatus();
                        $result["client_secret"] = $intent->client_secret;
                        $result["deposit_data"] = $deposit_data;
                        $result["billing_details"] = $billing_data;
                        //$result["stripe_intent"] = $intent;
                        /*"stripe_intent": {
                            "id": "pi_3KRIKPJyH9e69bzm1HWUJIZP",
                            "object": "payment_intent",
                            "amount": 10329,
                            "amount_capturable": 0,
                            "amount_received": 0,
                            "application": null,
                            "application_fee_amount": null,
                            "automatic_payment_methods": null,
                            "canceled_at": null,
                            "cancellation_reason": null,
                            "capture_method": "automatic",
                            "charges": {
                                "object": "list",
                                "data": [],
                                "has_more": false,
                                "total_count": 0,
                                "url": "/v1/charges?payment_intent=pi_3KRIKPJyH9e69bzm1HWUJIZP"
                            },
                            "client_secret": "pi_3KRIKPJyH9e69bzm1HWUJIZP_secret_fHdAiaqVnyt5IeTLwCtyx6LXw",
                            "confirmation_method": "automatic",
                            "created": 1644421413,
                            "currency": "usd",
                            "customer": null,
                            "description": "Queritel Wallet Deposit",
                            "invoice": null,
                            "last_payment_error": null,
                            "livemode": false,
                            "metadata": {
                                "integration_check": "accept_a_payment",
                                "comment": "This is a comment by the person making the payment",
                                "deposit_id": "dep-wiaqevd-2000862-lpaxfdq"
                            },
                            "next_action": null,
                            "on_behalf_of": null,
                            "payment_method": null,
                            "payment_method_options": {
                                "card": {
                                    "installments": null,
                                    "network": null,
                                    "request_three_d_secure": "automatic"
                                }
                            },
                            "payment_method_types": [
                                "card"
                            ],
                            "processing": null,
                            "receipt_email": "sarah.telmore@queritel.com",
                            "review": null,
                            "setup_future_usage": null,
                            "shipping": null,
                            "source": null,
                            "statement_descriptor": null,
                            "statement_descriptor_suffix": null,
                            "status": "requires_payment_method",
                            "transfer_data": null,
                            "transfer_group": null
                        }*/
                    }
                }

            }

        }

        echo json_export($result);
    }
    if ($action == "initiate_deposit"){
        //wallet
        //`id` int(11) NOT NULL AUTO_INCREMENT,
        //  `creation_time` datetime DEFAULT NULL,
        //  `update_time` datetime DEFAULT NULL,
        //  `payment_id` varchar(40) DEFAULT NULL,
        //  `quest_id` int(11) DEFAULT NULL,
        //  `creator_id` INT(11) DEFAULT NULL,
        //  `network_id` VARCHAR(60) DEFAULT NULL,
        //  `amount` decimal(13,4) DEFAULT NULL,
        //  `currency` varchar(15) DEFAULT NULL,
        //  `local_currency` varchar(15) DEFAULT NULL,
        //  `local_currency_rate` decimal(13,4) DEFAULT NULL,
        //  `paid` int(11) DEFAULT '0' comment "if this entry has be used towards paying for something",
        //  `paid_time` datetime DEFAULT NULL,
        //  `amount_paid` decimal(13,4) DEFAULT NULL,
        //  `deposit_id` varchar(40) DEFAULT NULL,

        //deposit
        //`id` int(11) NOT NULL AUTO_INCREMENT,
        //  `creation_time` datetime DEFAULT NULL,
        //  `update_time` datetime DEFAULT NULL,
        //  `deposit_id` varchar(40) DEFAULT NULL,
        //  `payment_id` varchar(40) DEFAULT NULL,
        //  `status` varchar(30) DEFAULT NULL comment "failed, success, incomplete, cancelled",
        //  `amount` decimal(13,4) DEFAULT NULL,
        //  `currency` varchar(15) DEFAULT NULL,
        //  `creator_id` INT(11) DEFAULT NULL,
        //  `network_id` VARCHAR(40) DEFAULT NULL,
        //  `invoice_id` VARCHAR(40) DEFAULT NULL,
        //  `invoice_item_id` VARCHAR(40) DEFAULT NULL,
        //  `use_case` VARCHAR(20) DEFAULT NULL comment "wallet | purchase",
        //  `billing_name` VARCHAR(60) DEFAULT NULL,
        //  `billing_email` VARCHAR(200) DEFAULT NULL,
        //  `billing_comment` longtext DEFAULT NULL,
        //  `stripe_response` longtext DEFAULT NULL,

        include 'payment/gw-stripe/vendor/autoload.php';
        //require 'payment/gw-stripe/vendor/stripe/stripe-php/init.php';

        //\Stripe\Stripe::setApiKey(STRIPE_PAYMENT_LIVE_KEY);
        \Stripe\Stripe::setApiKey(STRIPE_PAYMENT_TEST_KEY);


        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $amount = text_clean($data["amount"]);
        $invoice_id = text_clean($data["invoice_id"]);
        $deposit_provider = text_clean($data["provider"]);
        $billing_details = $data["billing_details"];


        $billing_name = null;
        $billing_email = null;
        $billing_comment = null;

        if (!empty($billing_details)){
            $billing_name = text_clean($billing_details["name"]);
            $billing_email = text_clean($billing_details["email"]);
            $billing_comment = text_clean($billing_details["comment"]);
        }


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $account_holder = $network_detail["account_holder"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                if ($deposit_provider == DEPOSIT_PROVIDER_STRIPE){
                    if (!empty($invoice_id)){
                        //for purchase
                    }
                    else{
                        //for loading wallet

                        $stripe_fee = 0;
                        $total_charge = 0;

                        $stripe_charge = getStripeCharge($amount);
                        $stripe_fee = $stripe_charge["stripe_fee"];
                        $total_charge = $stripe_charge["total_charge"];


                        $amount_converted = intval(($total_charge) * 100);
                        $currency = strtolower(SYSTEM_CURRENCY);
                        $description = 'Queritel Wallet Deposit';
                        $comment = $billing_comment;
                        $email = $billing_email;
                        $deposit_id = generate_unique_id(UNIQUE_DEPOSIT);


                        $intent = \Stripe\PaymentIntent::create([
                            'amount' => $amount_converted,
                            'currency' => $currency,
                            'description' => $description,
                            'receipt_email' => $email,
                            'payment_method_types' => ['card'],
                            'metadata' => [
                                'integration_check' => 'accept_a_payment',
                                'comment' => $comment,
                                'deposit_id' => $deposit_id
                            ],
                        ]);

                        $deposit_query = get_insert_query(TABLE_CLIENT_DEPOSIT, [
                            "creation_time" => getCurrentTime(),
                            "deposit_id" => $deposit_id,
                            "status" => DEPOSIT_STATUS_INCOMPLETE,
                            "amount" => $amount,
                            "currency" => SYSTEM_CURRENCY,
                            "creator_id" => $user_id,
                            "network_id" => $network_id,
                            "billing_name" => $billing_name,
                            "billing_email" => $billing_email,
                            "billing_comment" => $billing_comment,
                            "use_case" => DEPOSIT_USE_WALLET,
                            "provider" => $deposit_provider
                        ]);

                        $deposit_result = $paperweight->query($deposit_query);
                        if($deposit_result != null && $deposit_result->is_row_affected()){

                            $deposit_data = array();
                            $deposit_data["deposit_id"] = $deposit_id;
                            $deposit_data["amount"] = $amount;
                            $deposit_data["currency"] = strtoupper(SYSTEM_CURRENCY);
                            $deposit_data["stripe_fee"] = round($stripe_fee,2);
                            $deposit_data["total_charge"] = round($total_charge,2);
                            $deposit_data["provider"] = $deposit_provider;
                            $deposit_data["creation_time"] = getCurrentTime();

                            $wire_proof = array();
                            $wire_proof["is_uploaded"] = false;
                            $wire_proof["file_id"] = null;
                            $wire_proof["is_confirmed"] = false;

                            $deposit_data["wire_transfer_proof"] = $wire_proof;


                            $billing_data = array();
                            $billing_data["name"] = $billing_name;
                            $billing_data["email"] = $billing_email;
                            $billing_data["comment"] = $billing_comment;


                            $result = getOKStatus();
                            $result["client_secret"] = $intent->client_secret;
                            $result["deposit_data"] = $deposit_data;
                            $result["billing_details"] = $billing_data;
                            //$result["stripe_intent"] = $intent;
                            /*"stripe_intent": {
                                "id": "pi_3KRIKPJyH9e69bzm1HWUJIZP",
                                "object": "payment_intent",
                                "amount": 10329,
                                "amount_capturable": 0,
                                "amount_received": 0,
                                "application": null,
                                "application_fee_amount": null,
                                "automatic_payment_methods": null,
                                "canceled_at": null,
                                "cancellation_reason": null,
                                "capture_method": "automatic",
                                "charges": {
                                    "object": "list",
                                    "data": [],
                                    "has_more": false,
                                    "total_count": 0,
                                    "url": "/v1/charges?payment_intent=pi_3KRIKPJyH9e69bzm1HWUJIZP"
                                },
                                "client_secret": "pi_3KRIKPJyH9e69bzm1HWUJIZP_secret_fHdAiaqVnyt5IeTLwCtyx6LXw",
                                "confirmation_method": "automatic",
                                "created": 1644421413,
                                "currency": "usd",
                                "customer": null,
                                "description": "Queritel Wallet Deposit",
                                "invoice": null,
                                "last_payment_error": null,
                                "livemode": false,
                                "metadata": {
                                    "integration_check": "accept_a_payment",
                                    "comment": "This is a comment by the person making the payment",
                                    "deposit_id": "dep-wiaqevd-2000862-lpaxfdq"
                                },
                                "next_action": null,
                                "on_behalf_of": null,
                                "payment_method": null,
                                "payment_method_options": {
                                    "card": {
                                        "installments": null,
                                        "network": null,
                                        "request_three_d_secure": "automatic"
                                    }
                                },
                                "payment_method_types": [
                                    "card"
                                ],
                                "processing": null,
                                "receipt_email": "sarah.telmore@queritel.com",
                                "review": null,
                                "setup_future_usage": null,
                                "shipping": null,
                                "source": null,
                                "statement_descriptor": null,
                                "statement_descriptor_suffix": null,
                                "status": "requires_payment_method",
                                "transfer_data": null,
                                "transfer_group": null
                            }*/
                        }
                    }
                }
                elseif ($deposit_provider == DEPOSIT_PROVIDER_WIRE_TRANSFER){
                    if (!empty($invoice_id)){
                        //for purchase
                    }
                    else{
                        //for loading wallet

                        $stripe_fee = 0;
                        $total_charge = 0;


                        //$amount_converted = intval(($total_charge) * 100);
                        //$currency = strtolower(SYSTEM_CURRENCY);
                        //$description = 'Queritel Wallet Deposit';
                        //$comment = $billing_comment;
                        //$email = $billing_email;

                        $deposit_id = generate_unique_id(UNIQUE_DEPOSIT);


                        /*$intent = \Stripe\PaymentIntent::create([
                            'amount' => $amount_converted,
                            'currency' => $currency,
                            'description' => $description,
                            'receipt_email' => $email,
                            'payment_method_types' => ['card'],
                            'metadata' => [
                                'integration_check' => 'accept_a_payment',
                                'comment' => $comment,
                                'deposit_id' => $deposit_id
                            ],
                        ]);*/

                        $deposit_query = get_insert_query(TABLE_CLIENT_DEPOSIT, [
                            "creation_time" => getCurrentTime(),
                            "deposit_id" => $deposit_id,
                            "status" => DEPOSIT_STATUS_INCOMPLETE,
                            "amount" => $amount,
                            "currency" => SYSTEM_CURRENCY,
                            "creator_id" => $user_id,
                            "network_id" => $network_id,
                            "billing_name" => $billing_name,
                            "billing_email" => $billing_email,
                            "billing_comment" => $billing_comment,
                            "use_case" => DEPOSIT_USE_WALLET,
                            "provider" => $deposit_provider
                        ]);

                        $deposit_result = $paperweight->query($deposit_query);
                        if($deposit_result != null && $deposit_result->is_row_affected()){

                            $deposit_data = array();
                            $deposit_data["deposit_id"] = $deposit_id;
                            $deposit_data["amount"] = $amount;
                            $deposit_data["currency"] = strtoupper(SYSTEM_CURRENCY);
                            $deposit_data["stripe_fee"] = $stripe_fee;
                            $deposit_data["total_charge"] = $amount;
                            $deposit_data["creation_time"] = getCurrentTime();
                            $deposit_data["provider"] = $deposit_provider;

                            $wire_proof = array();
                            $wire_proof["is_uploaded"] = false;
                            $wire_proof["file_id"] = null;
                            $wire_proof["is_confirmed"] = false;

                            $deposit_data["wire_transfer_proof"] = $wire_proof;


                            $billing_data = array();
                            $billing_data["name"] = $billing_name;
                            $billing_data["email"] = $billing_email;
                            $billing_data["comment"] = $billing_comment;


                            $result = getOKStatus();
                            $result["client_secret"] = null;
                            $result["deposit_data"] = $deposit_data;
                            $result["billing_details"] = $billing_data;
                            //$result["stripe_intent"] = $intent;
                            /*"stripe_intent": {
                                "id": "pi_3KRIKPJyH9e69bzm1HWUJIZP",
                                "object": "payment_intent",
                                "amount": 10329,
                                "amount_capturable": 0,
                                "amount_received": 0,
                                "application": null,
                                "application_fee_amount": null,
                                "automatic_payment_methods": null,
                                "canceled_at": null,
                                "cancellation_reason": null,
                                "capture_method": "automatic",
                                "charges": {
                                    "object": "list",
                                    "data": [],
                                    "has_more": false,
                                    "total_count": 0,
                                    "url": "/v1/charges?payment_intent=pi_3KRIKPJyH9e69bzm1HWUJIZP"
                                },
                                "client_secret": "pi_3KRIKPJyH9e69bzm1HWUJIZP_secret_fHdAiaqVnyt5IeTLwCtyx6LXw",
                                "confirmation_method": "automatic",
                                "created": 1644421413,
                                "currency": "usd",
                                "customer": null,
                                "description": "Queritel Wallet Deposit",
                                "invoice": null,
                                "last_payment_error": null,
                                "livemode": false,
                                "metadata": {
                                    "integration_check": "accept_a_payment",
                                    "comment": "This is a comment by the person making the payment",
                                    "deposit_id": "dep-wiaqevd-2000862-lpaxfdq"
                                },
                                "next_action": null,
                                "on_behalf_of": null,
                                "payment_method": null,
                                "payment_method_options": {
                                    "card": {
                                        "installments": null,
                                        "network": null,
                                        "request_three_d_secure": "automatic"
                                    }
                                },
                                "payment_method_types": [
                                    "card"
                                ],
                                "processing": null,
                                "receipt_email": "sarah.telmore@queritel.com",
                                "review": null,
                                "setup_future_usage": null,
                                "shipping": null,
                                "source": null,
                                "statement_descriptor": null,
                                "statement_descriptor_suffix": null,
                                "status": "requires_payment_method",
                                "transfer_data": null,
                                "transfer_group": null
                            }*/
                        }
                    }
                }

            }

        }

        echo json_export($result);
    }


    //todo - 99% - test - replace with web-hook
    if ($action == "update_deposit_sample"){
        //require 'payment/gw-stripe/vendor/autoload.php';
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $account_holder = $network_detail["account_holder"];



                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/
            /*$deposit_result = $paperweight->query($deposit_query);
                if($deposit_result != null && $deposit_result->is_row_affected()){

                }*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    if ($action == "update_deposit"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        $deposit_id = text_clean($data["deposit_id"]);
        $deposit_status = text_clean($data["deposit_status"]);
        $stripe_response = $data["stripe_response"];


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $account_holder = $network_detail["account_holder"];

                $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

                $incomplete_status = DEPOSIT_STATUS_INCOMPLETE;

                $deposit_query = "select * from " . TABLE_CLIENT_DEPOSIT . " where network_id = '$network_id' and deposit_id = '$deposit_id' and status = '$incomplete_status'";
                $deposit_result = $paperweight->query($deposit_query);

                if($deposit_result != null && $deposit_result->is_row_found()){
                    if($row = $deposit_result->fetch_array()){
                        $amount = $row["amount"];
                        $use_case = $row["use_case"];
                        $currency = $row["currency"];
                        $provider = $row["provider"];

                        $payment_id = generate_unique_id(UNIQUE_WALLET_ENTRY); //for wallet entry
                        $update_time = getCurrentTime();

                        if ($use_case == DEPOSIT_USE_QUEST){}
                        elseif ($use_case == DEPOSIT_USE_WALLET){

                            if ($deposit_status == DEPOSIT_STATUS_SUCCESS){

                                $deposit_update = get_update_query(TABLE_CLIENT_DEPOSIT, [
                                    "update_time" => $update_time,
                                    "status" => $deposit_status,
                                    "payment_id" => $payment_id,
                                    "stripe_response" => json_encode($stripe_response)
                                ],"deposit_id = '$deposit_id'");
                                $deposit_update_result = $paperweight->query($deposit_update);
                                if($deposit_update_result != null && $deposit_update_result->is_row_affected()){

                                    $wallet_query = get_insert_query(TABLE_CLIENT_WALLET, [
                                        "creation_time" => $update_time,
                                        "payment_id" => $payment_id,
                                        "deposit_id" => $deposit_id,
                                        "creator_id" => $user_id,
                                        "network_id" => $network_id,
                                        "amount" => $amount,
                                        "local_currency" => $currency,
                                        "local_currency_rate" => 1
                                    ]);
                                    $wallet_result = $paperweight->query($wallet_query);
                                    if($wallet_result != null && $wallet_result->is_row_affected()){
                                        $result = getOKStatus();
                                    }

                                }

                            }
                            elseif ($deposit_status == DEPOSIT_STATUS_PENDING && $provider == DEPOSIT_PROVIDER_WIRE_TRANSFER){
                                //if this is a wire transfer to update a file

                                $is_uploaded = !empty($row["wire_file_id"]);
                                $file_id = $row["wire_file_id"];

                                if ($is_uploaded){
                                    //remove the file if a file was already uploaded
                                    $rel_type = FILE_REL_USR;
                                    $file_query = "select * from " . TABLE_ALL_FILES . " where network_id = '$network_id' and relationship_type = '$rel_type' and file_id = '$file_id'";
                                    $file_query_result = $paperweight->query($file_query);
                                    if($file_query_result != null && $file_query_result->is_row_found()){
                                        if($row_file = $file_query_result->fetch_array()){

                                            $targetPath = "uploads/file/" . $row_file["file_name"];

                                            $del_query = "delete from " . TABLE_ALL_FILES . " where network_id = '$network_id' and relationship_type = '$rel_type' and file_id = '$file_id'";
                                            $del_query_result = $paperweight->query($del_query);
                                            if($file_query_result != null && $file_query_result->is_row_affected()){
                                                queritelRemoveFile($targetPath);
                                            }

                                        }
                                    }
                                }

                                if (isset($_FILES["file_upload"]["tmp_name"])){
                                    $supportedFileTypeArray = array(
                                        'png' => 'ext_png',
                                        'jpg' => 'ext_jpg',
                                        'jpeg' => 'ext_jpg',
                                        'pdf' => 'ext_pdf'
                                    );
                                    $fileName = $_FILES["file_upload"]['name'];
                                    //$fileError = $_FILES["file_upload"]['error'];
                                    $fileSize = $_FILES["file_upload"]["size"];
                                    $fileNameOnly = pathinfo($fileName, PATHINFO_FILENAME);
                                    $fileExtension = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
                                    $fileNameNew = generate_file_name() . ".$fileExtension";
                                    $sourcePath = $_FILES["file_upload"]['tmp_name'];

                                    if (array_key_exists($fileExtension, $supportedFileTypeArray)) {
                                        $fileExt = $supportedFileTypeArray[$fileExtension];
                                        $targetPath = "uploads/file/" . $fileNameNew;

                                        $file_id = generate_unique_id(UNIQUE_FILE);

                                        if (queritelUploadFile($targetPath, $sourcePath)) {
                                            $add_file_query = get_insert_query(TABLE_ALL_FILES,[
                                                "file_id" => $file_id,
                                                "creation_time" => getCurrentTime(),
                                                "original_filename" => $fileNameOnly,
                                                "original_ext" => $fileExtension,
                                                "file_name" => $fileNameNew,
                                                "file_ext" => $fileExt,
                                                "file_size" => $fileSize,
                                                "creator_id" => $user_id,
                                                "network_id" => $network_id,
                                                "relationship_type" => FILE_REL_USR,
                                                "is_hidden" => 1
                                            ]);
                                            $file_query_result = $paperweight->query($add_file_query);
                                            if($file_query_result != null && $file_query_result->is_row_affected()){

                                                $deposit_update = get_update_query(TABLE_CLIENT_DEPOSIT, [
                                                    "update_time" => $update_time,
                                                    "status" => $deposit_status,
                                                    "wire_file_id" => $file_id
                                                ],"deposit_id = '$deposit_id'");
                                                $deposit_update_result = $paperweight->query($deposit_update);
                                                if($deposit_update_result != null && $deposit_update_result->is_row_affected()){
                                                    $result = getOKStatus();
                                                }
                                            }
                                        }
                                        else{
                                            //upload failed
                                        }

                                    }
                                }

                            }

                        }

                    }
                }
                else{
                    $result = getErrorStatus(ERROR_MSG_NOT_FOUND);
                }

            }

        }

        echo json_export($result);
    }


    //todo - 85% - test
    if ($action == "get_wallet_history_sample"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            //| "wire_transfer"
            $res = '{
              "status": "OK",
              "deposit_history": [
                {
                  "deposit_id": "dp-hgjfhhdg5674756ndhcb",
                  "update_time": "2021-11-15 09:07:45",
                  "deposit_currency": "USD",
                  "deposit_status": "success",
                  "deposit_amount": 100,
                  "creator_id": "125",
                  "creator_name": "Kevin Smith",
                  "provider": "stripe",
                  "wire_transfer_proof": {
                    "is_uploaded": false,
                    "file_id": null,
                    "is_confirmed": false
                  }
                }
              ],
              "holding_history": [
                {
                  "holder_id": "hd-kfgjjghfhff74556657fn",
                  "update_time": "2021-11-15 09:07:45",
                  "holding_status": "released",
                  "holding_currency": "USD",
                  "holding_amount": "5",
                  "creator_id": "125",
                  "creator_name": "Kevin Smith"
                }
              ]
            }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    if ($action == "get_wallet_history"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];


                $deposit_history = array();
                $holding_history = array();

                $deposit_use_case = DEPOSIT_USE_WALLET;

                $deposit_query = "select * from " . TABLE_CLIENT_DEPOSIT . " where network_id = '$network_id' and use_case = '$deposit_use_case'";
                $deposit_result = $paperweight->query($deposit_query);
                if($deposit_result != null && $deposit_result->is_row_found()){
                    while($row = $deposit_result->fetch_array()){
                        $creator_id = $row["creator_id"];
                        $creator_name = null;

                        $user_data = query_user($creator_id, $paperweight);
                        if (!empty($user_data)){
                            $creator_name = stringCase($user_data["fname"] . " " . $user_data["lname"],STRING_CASE_CAP_EACH);
                        }

                        $deposit_data = array();
                        $deposit_data["deposit_id"] = $row["deposit_id"];
                        $deposit_data["update_time"] = $row["creation_time"];
                        $deposit_data["deposit_currency"] = $row["currency"];
                        $deposit_data["deposit_status"] = $row["status"];
                        $deposit_data["deposit_amount"] = $row["amount"];
                        $deposit_data["creator_id"] = $creator_id;
                        $deposit_data["creator_name"] = $creator_name;
                        $deposit_data["provider"] = $row["provider"];

                        $wire_proof = array();
                        $wire_proof["is_uploaded"] = !empty($row["wire_file_id"]);
                        $wire_proof["file_id"] = $row["wire_file_id"];
                        $wire_proof["is_confirmed"] = $row["wire_confirmed"] == 1;

                        $deposit_data["wire_transfer_proof"] = $wire_proof;


                        $deposit_history[] = $deposit_data;
                    }
                }

                //get holding_history

                $result = getOKStatus();
                $result["deposit_history"] = $deposit_history;
                $result["holding_history"] = $holding_history;

            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "deposit_history": [
                {
                  "deposit_id": "dp-hgjfhhdg5674756ndhcb",
                  "update_time": "2021-11-15 09:07:45",
                  "deposit_currency": "USD",
                  "deposit_status": "success",
                  "deposit_amount": 100,
                  "creator_id": "125",
                  "creator_name": "Kevin Smith"
                }
              ],
              "holding_history": [
                {
                  "holder_id": "hd-kfgjjghfhff74556657fn",
                  "update_time": "2021-11-15 09:07:45",
                  "holding_status": "released",
                  "holding_currency": "USD",
                  "holding_amount": "5",
                  "creator_id": "125",
                  "creator_name": "Kevin Smith"
                }
              ]
            }';

        }

        echo json_export($result);
    }


    //todo - NYI - sample
    if ($action == "get_quest_payment"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "invoice_id": "inv_hgjHGDHHggdgdg65834",
              "use_case": "quest",
              "total_amount": 100,
              "currency": "USD",
              "paid": false,
              "split_payment": {
                "active": true,
                "payment_list": [
                  {
                    "item_id": "itm_urxnGDJDHhjdhjss",
                    "item_name": "Finance Payment 1",
                    "item_type": "split",
                    "item_amount": 50,
                    "payment": {
                      "paid": false,
                      "wallet_offset": 45,
                      "remaining_amount": 5,
                      "deposit_id": null
                    }
                  },
                  {
                    "item_id": "itm_hggfteYHd64547",
                    "item_name": "Finance Payment 2",
                    "item_type": "split",
                    "item_amount": 50,
                    "payment": {
                      "paid": false,
                      "wallet_offset": 0,
                      "remaining_amount": 50,
                      "deposit_id": null
                    }
                  }
                ]
              },
              "invoice_list": [
                {
                  "item_id": "itm_hgjhGhdgdj7464dhk",
                  "item_name": "Usage Fee",
                  "item_type": "usage_fee",
                  "item_amount": 20
                },
                {
                  "item_id": "itm_jfhgd645s55XGDDHD",
                  "item_name": "Processing Fee",
                  "item_type": "proc_fee",
                  "item_amount": 20
                },
                {
                  "item_id": "itm_KFHhhd756dnfsapd",
                  "item_name": "Total Data Collector Payout",
                  "item_type": "payout",
                  "item_amount": 60
                }
              ]
            }';

        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    if ($action == "get_quest_payment_dev"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }

    //todo - NYI - sample
    if ($action == "get_sample_payment"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
              "status": "OK",
              "invoice_id": "inv_hgjHGDHHggdgdg65834",
              "subscription_id": "sub_kslfhHFGFdre67463",
              "use_case": "subscription",
              "total_amount": 100,
              "currency": "USD",
              "paid": false,
              "handler": "stripe",
              "interval": "month",
              "interval_count": 3,
              "billing_mode": "automatic",
              "invoice_list": [
                {
                  "item_id": "itm_hgjhGhdgdj7464dhk",
                  "item_name": "Jamaican Store 1",
                  "item_type": "payout",
                  "item_amount": 20
                },
                {
                  "item_id": "itm_jfhgd645s55XGDDHD",
                  "item_name": "Jamaican Store 2",
                  "item_type": "payout",
                  "item_amount": 20
                },
                {
                  "item_id": "itm_KFHhhd756dnfsapd",
                  "item_name": "Jamaican Store 3",
                  "item_type": "payout",
                  "item_amount": 60
                }
              ]
            }';

        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    if ($action == "get_sample_payment_dev"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }

    //todo - NYI - sample
    if ($action == "offset_wallet_cost"){
        //require 'payment/gw-stripe/vendor/autoload.php';
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/
            /*$deposit_result = $paperweight->query($deposit_query);
                if($deposit_result != null && $deposit_result->is_row_affected()){

                }*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    if ($action == "offset_wallet_cost_dev"){
        //require 'payment/gw-stripe/vendor/autoload.php';
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/
            /*$deposit_result = $paperweight->query($deposit_query);
                if($deposit_result != null && $deposit_result->is_row_affected()){

                }*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }

    //todo - NYI - sample
    if ($action == "split_payment"){
        //require 'payment/gw-stripe/vendor/autoload.php';
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/
            /*$deposit_result = $paperweight->query($deposit_query);
                if($deposit_result != null && $deposit_result->is_row_affected()){

                }*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    if ($action == "split_payment_dev"){
        //require 'payment/gw-stripe/vendor/autoload.php';
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $quest_id = text_clean($data["quest_id"]); //array


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];




                $result = getOKStatus();
            }

            //$result = getOKStatus();

            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/
            /*$deposit_result = $paperweight->query($deposit_query);
                if($deposit_result != null && $deposit_result->is_row_affected()){

                }*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }



    /*
     * this operation allows the user to view their wallet data
     * the user will see the available balance, the amount held
     * transaction history [trans type - deposit, purchase], date, amount, currency, transaction id
     */
    //fixme = ---------------------------- WALLET END ----------------------------







    //Total : 400
    //    split 1 200 -> [+]
    //    split 2 200 -> [+]
    //    split 3 100 -> []
    //-- receipt - (html | pdf)

    //fixme = ---------------------------- EMBEDDED SURVEY START ----------------------------
    //condition structure
    //fixme = ---------------------------- EMBEDDED SURVEY END ----------------------------



    if ($action == ACTION_LOG_IN){
        $data = json_decode($param_json, true);

        $username = strtolower(text_clean($data["username"]));
        $password = text_clean($data["password"]);
        $login_data = $data["login_data"];



        $client = new Client($paperweight);

        $result = $client->login($username, $password, $login_data);

        echo json_export($result);

    }
    if ($action == ACTION_SIGN_OUT){
        $data = json_decode($param_json, true);

        $user_id = clean($data["user_id"]);
        $login_token = clean($data["login_token"]);


        $client = new Client($paperweight);
        //$client->initializeClient($user_id,$login_token);

        $obj = $client->signout($user_id, $login_token);

        $client->removeNotificationToken($user_id,$login_token);

        echo json_encode($obj);

    }












    //================== ADDITIONAL API ==================
    /*$insert_query = get_insert_query("test_table", [
        "name" => "Hello",
        "next" => "World"
    ]);

    $update_query = get_update_query("test_table", [
        "name" => "Yes",
        "food" => "banana",
        "next" => "Kadan"
    ]);*/

    //ACTION_ = ""
    //define("ACTION_", "");
    if ($action == "-template-get-sample-"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);
            $client->setCurrentLocation($lat,$lng);

            $result = $client->getOKStatus();

            $code = '{
                  "status": "OK",
                  "team_list": [
                    {
                      "network_id": "net-hdkshfl-9384653-shflcjs",
                      "team_name": "Market Research Services",
                      "team_id": "team-eqitpqm-6977877-asjshff"
                    },
                    {
                      "network_id": "net-xkdnfbd-7493749-xgcjzlx",
                      "team_name": "ODPEM Jamaica",
                      "team_id": "team-hfjdlsn-4847563-sldnvck"
                    }
                  ]
                }';
            $code_obj = json_decode($code,true);
            $result[""] = $code_obj[""];

        }

        echo json_export($result);
    }
    if ($action == "-template-set-sample-"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);
            $client->setCurrentLocation($lat,$lng);

            $result = $client->getOKStatus();

            $account_id = generate_unique_id(UNIQUE_ACCOUNT);

            $result["account_id"] = $account_id;
            $result["version_code"] = 1;

        }

        echo json_export($result);
    }
    if ($action == "template"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);

        //extra
        $quest_id = text_clean($data["quest_id"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);

            $client_network = getClientNetwork($user_id,$paperweight);
            if (!empty($client_network)){
                $network_id = $client_network["network_id"];
                $network_detail = getNetworkDetails($network_id,$paperweight);
                $org_name = $network_detail["organization_name"];
                $account_holder = $network_detail["account_holder"];




                $result = getOKStatus();
            }


            /*$result["get_insert_query"] = get_insert_query("test_table", [
                "name" => "Hello",
                "next" => "World"
            ]);

            $result["get_update_query"] = get_update_query("test_table", [
                "name" => "Yes",
                "food" => "banana",
                "next" => "Kadan"
            ]);*/

            /*$deposit_result = $paperweight->query($deposit_query);
                if($deposit_result != null && $deposit_result->is_row_affected()){

                }*/

            $res = '{
                  "status": "OK"
                }';

            //echo json_export($result);
        }

        if ($result["status"] == "OK"){
            echo $res;
        }
        else{
            echo json_export($result);
        }

    }
    if ($action == "template_2"){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $lat =          text_clean($data["lat"]);
        $lng =          text_clean($data["lng"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);
            $client->setCurrentLocation($lat,$lng);

            $result = $client->getOKStatus();

        }

        echo json_export($result);
    }
    if ($action == "-- external request --"){
        $data = json_decode($param_json, true);

        $number_locale = text_clean($data["number_locale"]);
        $value = text_clean($data["value"]);

        $result = array();

        echo json_export($result);
    }
    //================== ADDITIONAL API ==================



    if ($action == ACTION_AUTHENTICATE_USER){
        $data = json_decode($param_json, true);

        $user_id = clean($data["user_id"]);
        $login_token = clean($data["login_token"]);


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] != STATUS_OK){

            $result = $client->getErrorStatus(ERROR_MSG_INVALID_TOKEN);
        }

        echo json_export($result);
    }
    if ($action == "get_message_list_client"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $task_id =  text_clean($data["task_id"]);

        if ($user_id == 125){
            //$user_id = 35;
            //$task_id = 292;
        }

        //$login_token =  text_clean($data["task_id"]);

        //$lat =          text_clean($data["lat"]);
        //$lng =          text_clean($data["lng"]);

        $network_id = "";
        //$sender_network_id = "";
        $relationships = getNetworkRelationship($user_id, $paperweight);
        if (!empty($relationships)){
            $network_id = $relationships[0]["network_id"];
            //$sender_network_id = $network_id;
        }

        $quest_creator = getQuestCreatorNetwork($task_id,$paperweight);




        $result = array();
        $data_array = array();
        $message_list = array();

        $result["status"] = STATUS_OK;
        $result["network_id"] = $network_id;
        $result["message_list"] = array();

        $val = '{
                    "status": "OK",
                    "network_id": "",
                    "message_list": [
                        {
                            "user_id" : "329",
                            "fname" : "Kevin",
                            "lname" : "Smith",
                            "msg_body" : "Restart your application kevin",
                            "timestamp" : "2021-03-12 23:17:08",
                            "unread": 0
                        },
                        {
                            "user_id" : "121",
                            "fname" : "Kadan",
                            "lname" : "Salmon",
                            "msg_body" : "Did you confirm that your location was on?",
                            "timestamp" : "2021-03-12 18:05:41",
                            "unread": 0
                        }
                    ]
                }';


        if ($network_id == $quest_creator){

            $linked_agents = getQuestAgents($task_id, $paperweight);
            if (!empty($linked_agents)){

                foreach ($linked_agents as $agent) {
                    $last_msg = getLastMsg($agent["user_id"],$network_id,$task_id,$paperweight);

                    $data_array["user_id"] = $agent["user_id"];
                    $data_array["fname"] = $agent["fname"];
                    $data_array["lname"] = $agent["lname"];

                    $data_array["msg_body"] = $last_msg["msg_body"];
                    $data_array["timestamp"] = $last_msg["timestamp"];
                    $data_array["unread"] = $last_msg["unread"];

                    $message_list[] = $data_array;

                }

            }

        }

        $result["message_list"] = $message_list;



        //289 -- my

        /*$client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);
            $client->setCurrentLocation($lat,$lng);
            $result = $client->acceptJob($job_id);
        }*/

        echo json_export($result);
        //echo json_export($result);
        //echo generate_msg_id();
    }
    if ($action == "send_direct_message_client"){
        $data = json_decode($param_json, true);

        //todo INVESTIGATE
        //$paperweight->getConnector()->set_charset("utf8mb4");


        $user_id =      text_clean($data["user_id"]);
        $task_id =  text_clean($data["task_id"]);
        $agent_id =          text_clean($data["agent_id"]);
        $msg_body =          text_clean($data["body"]);

        //$MSG_DATA =             $data["message_data"];
        //$recipient_id_ =        text_clean($MSG_DATA["recipient_id"]);
        //$sender_network_id_ =   text_clean($MSG_DATA["sender_network_id"]);
        //$task_id_ =             text_clean($MSG_DATA["task_id"]);
        //$body =                 text_clean($MSG_DATA["body"]);



        /*
        "user_id": USER_ID,
            "task_id": QUEST_ID,
            "agent_id": agent_id,
            "body" : msg*/

        $network_id = "";
        $sender_network_id = "";
        $relationships = getNetworkRelationship($user_id, $paperweight);
        if (!empty($relationships)){
            $network_id = $relationships[0]["network_id"];
            $sender_network_id = $network_id;
        }



        $message_id = generate_unique_id(UNIQUE_MSG);
        $recipient_id = $agent_id;
        //$recipient_network_id = $recipient_network;
        //$recipient_network_id = getQuestCreatorNetwork($task_id_,$paperweight);
        $sender_id = $user_id;
        //$sender_network_id = $sender_network_id_;
        $timestamp = getCurrentTime();
        //$task_id = $task_id_;
        //$msg_body = $body;
        $msg_type = "msg_text";


        $result = array();
        $data_new = array();

        $data_new["message_id"] = $message_id;
        $data_new["recipient_id"] = intval($recipient_id);
        $data_new["recipient_network"] = null;
        $data_new["sender_id"] = intval($sender_id);
        $data_new["sender_network"] = $sender_network_id;
        $data_new["task_id"] = intval($task_id);
        $data_new["timestamp"] = $timestamp;
        $data_new["body"] = clean_reverse($msg_body);



        //$result["status"] = STATUS_ERROR;



        $result["status"] = STATUS_OK;
        $result["message_data"] = $data_new;

        $send_msg = "insert into " . TABLE_MESSAGE . " (message_id, send_time, sender_id, recipient_id, message_body, task_id, sender_network_id, message_type) values ('$message_id','$timestamp','$sender_id','$recipient_id','$msg_body','$task_id','$sender_network_id','$msg_type')";
        $send_msg_result = $paperweight->query($send_msg);

        if($send_msg_result != null && $send_msg_result->is_row_affected()){
            //success

            //$update_job = "update " . TABLE_JOBS . " set researcher_count = '$researcher_count', survey_assigned = '$new_assigned' where job_id = '$job_id'";
            //$update_result = $this->db_connector->query($update_job);

            /*if($update_result != null && $update_result->is_row_affected()){
                $result["status"] = STATUS_OK;


                //broadcast update to researcher and admin

            }*/

            $result["status"] = STATUS_OK;
            $result["message_data"] = $data_new;

            sendNewMessageNotification($agent_id,$paperweight);

        }





        /*$client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);
            $client->setCurrentLocation($lat,$lng);
            $result = $client->acceptJob($job_id);
        }*/

        echo json_export($result);
    }
    if ($action == "get_direct_message_thread_client"){
        $data = json_decode($param_json, true);


        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        //$network_id =  text_clean($data["network_id"]);//
        $task_id =  text_clean($data["task_id"]);
        $agent_id =  text_clean($data["agent_id"]);



        //$lat =          text_clean($data["lat"]);
        //$lng =          text_clean($data["lng"]);

        /*

        chatBubble1.setMessageId("udhfytb-7487365-HTRDYTI");
        chatBubble1.setRecipientId(329);
        chatBubble1.setSenderId(-1);
        chatBubble1.setSenderNetwork("nid_jsy827459OFksye");
        chatBubble1.setRecipientNetwork(null);
        chatBubble1.setTimestamp("2021-02-25 16:00:00");
        chatBubble1.setTask_id(292);
        chatBubble1.setRead(false);//have i marked this message as [READ] (i am the recipient)
        chatBubble1.setBelongToCurrentUser(false);//was this message sent by me (this is not mine becuz i didnt send it)
        chatBubble1.setMsgBody("We noticed that you have not accessed the application in while, is there a problem");

      */
        /*"status": "OK",
       "message_thread": [
           {
               "message_id": "pywxqjo-7175664-RRTWUNB",--
               "recipient_id": 0,--
               "recipient_network": "nid_jsy827459OFksye",--
               "sender_id": 329,--
               "sender_network": null,--
               "task_id": 289,--
               "timestamp": "2021-03-11 08:14:58",--
               "body": "this is my message body"
           },
           {
               "message_id": "jfhyfgr-8476395-HDKDJGT",--
               "recipient_id": 329,--
               "recipient_network": null,--
               "sender_id": 0,--
               "sender_network": "nid_jsy827459OFksye",--
               "task_id": 289,--
               "timestamp": "2021-03-11 08:14:58",--
               "body": "this is my message body sent by the company"
           }
       ]
        */

        $network_id = "";
        $sender_network_id = "";
        $relationships = getNetworkRelationship($user_id, $paperweight);
        if (!empty($relationships)){
            $network_id = $relationships[0]["network_id"];
        }

        $quest_creator = getQuestCreatorNetwork($task_id,$paperweight);

        if ($network_id == $quest_creator){
            $sender_network_id = "$network_id";
        }

        $result = array();
        $data = array();
        $message_thread = array();



        /*

        $message_id = "pywxqjo-7175664-RRTWUNB";
        $recipient_id = 0;
        $recipient_network_id = "nid_jsy827459OFksye";
        $sender_id = 329;
        $sender_network_id = null;
        $timestamp = getCurrentTime();
        $task_id = 289;
        $msg_body = "this is my message body";




        $data[$index]["message_id"] = $message_id;
        $data[$index]["recipient_id"] = intval($recipient_id);
        $data[$index]["recipient_network"] = $recipient_network_id;
        $data[$index]["sender_id"] = intval($sender_id);
        $data[$index]["sender_network"] = $sender_network_id;
        $data[$index]["task_id"] = intval($task_id);
        $data[$index]["timestamp"] = $timestamp;
        $data[$index]["body"] = $msg_body;



        $message_id = "jfhyfgr-8476395-HDKDJGT";
        $recipient_id = 329;
        $recipient_network_id = null;
        $sender_id = 0;
        $sender_network_id = "nid_jsy827459OFksye";
        $timestamp = "2021-03-11 08:14:58";
        $task_id = 289;
        $msg_body = "this is my message body sent by the company";

        $index = 1;

        $data[$index]["message_id"] = $message_id;
        $data[$index]["recipient_id"] = intval($recipient_id);
        $data[$index]["recipient_network"] = $recipient_network_id;
        $data[$index]["sender_id"] = intval($sender_id);
        $data[$index]["sender_network"] = $sender_network_id;
        $data[$index]["task_id"] = intval($task_id);
        $data[$index]["timestamp"] = $timestamp;
        $data[$index]["body"] = $msg_body;
        //$data[$index]["body"] = "Hello kadian";
        */


        $result["status"] = STATUS_OK;
        //$result["agent_id"] = $agent_id;
        $result["message_thread"] = array();

        //if sender is not null (check if user is sender)


        $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_network_id = '$sender_network_id' or recipient_network_id = '$sender_network_id') and (recipient_id = '$agent_id' or sender_id = '$agent_id')) and task_id = '$task_id'";
        $msg_result = $paperweight->query($msg_query);

        if($msg_result != null && $msg_result->is_row_found()){

            while($row = $msg_result->fetch_array()){

                $message_id = $row["message_id"];
                $recipient_id = $row["recipient_id"];
                $recipient_network_id = $row["recipient_network_id"];
                $sender_id = $row["sender_id"];
                $sender_network_id = $row["sender_network_id"];
                $timestamp = $row["send_time"];
                $task_id = $row["task_id"];
                $msg_body = $row["message_body"];

                $data["message_id"] = $message_id;
                $data["recipient_id"] = intval($recipient_id);
                $data["recipient_network"] = $recipient_network_id;
                $data["sender_id"] = intval($sender_id);
                $data["sender_network"] = $sender_network_id;
                $data["task_id"] = intval($task_id);
                $data["timestamp"] = $timestamp;
                $data["body"] = $msg_body;

                $message_thread[] = $data;

            }

            $result["status"] = STATUS_OK;
            $result["message_thread"] = $message_thread;

        }








        /*$client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);
            $client->setCurrentLocation($lat,$lng);
            $result = $client->acceptJob($job_id);
        }*/

        echo json_export($result);
        //echo json_export($user_id);
    }
    if ($action == ACTION_SEND_NOTIFICATION_ID){
        $data = json_decode($param_json, true);

        $user_id =      text_clean($data["user_id"]);
        $login_token =  text_clean($data["login_token"]);
        $notification_id = text_clean($data["notification_id"]);

        //todo : API Debug - remove commented
        //debugAPIResponse("send_notification_id",json_encode($data,JSON_PRETTY_PRINT));


        $client = new Client($paperweight);
        $isVerified = $client->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if($isVerified["status"] == STATUS_OK){
            $client->initializeClient($user_id);
            //$client->setCurrentLocation($lat,$lng);

            $updated = $client->updateNotificationToken($notification_id);

            if ($updated){
                $result = $client->getOKStatus();
            }
            else{
                $result = $client->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
            }

        }

        echo json_export($result);
    }

}




//todo improve this function (with country relationship table and table join)
function is_category_in_country($category_id, $country_code, $figozo){
    $sql_query = "select * from " . TABLE_CATALOG . " where category_id = '$category_id' group by country_code";
    $sql_query_result = $figozo->query($sql_query);

    if ($sql_query_result != null && $sql_query_result->is_row_found()) {
        while ($row = $sql_query_result->fetch_array()) {
            if ($row["country_code"] == $country_code) {
                return true;
            }
        }
    }

    return false;
}
function is_brand_in_country($brand_id, $country_code, $figozo){
    $sql_query = "select * from " . TABLE_CATALOG . " where brand_id = '$brand_id' group by country_code";
    $sql_query_result = $figozo->query($sql_query);

    if ($sql_query_result != null && $sql_query_result->is_row_found()) {
        while ($row = $sql_query_result->fetch_array()) {
            if ($row["country_code"] == $country_code) {
                return true;
            }
        }
    }

    return false;
}


function isStoreInSample($store_id,$sample_id,$paperweight){
    $in_sample = false;

    $store_query = "select * from " . TABLE_STORE_SAMPLE_PACKAGE . " where sample_id = '$sample_id' and store_id = '$store_id'";
    $store_result = $paperweight->query($store_query);
    if($store_result != null && $store_result->is_row_found()){
        $in_sample = true;
    }

    return $in_sample;
}

function getSampleStoreListCount($sample_id,$paperweight){
    $count = 0;

    $store_query = "select count(id) from " . TABLE_STORE_SAMPLE_PACKAGE . " where sample_id = '$sample_id' ";
    $store_result = $paperweight->query($store_query);

    if($store_result != null && $store_result->is_row_found()){
        if($row = $store_result->fetch_array()){

            $count = intval($row["count(id)"]);

        }
    }

    return $count;
}
function getSampleStoreListRaw($sample_id,$paperweight){
    $store_list = array();

    $store_query = "select * from " . TABLE_STORE_SAMPLE_PACKAGE . " where sample_id = '$sample_id' ";
    $store_result = $paperweight->query($store_query);

    if($store_result != null && $store_result->is_row_found()){
        while($row = $store_result->fetch_array()){
            $store_list[] = $row;
        }
    }

    return $store_list;
}
function getSampleDataRaw($sample_id,$paperweight){
    $sample_item = array();

    $sample_query = "select * from " . TABLE_STORE_SAMPLE . " where sample_id = '$sample_id' ";
    $sample_result = $paperweight->query($sample_query);

    if($sample_result != null && $sample_result->is_row_found()){
        if($row = $sample_result->fetch_array()){

            $sample_item = $row;

        }
    }

    return $sample_item;
}

//get stripe charge
function getStripeCharge($amount_usd){
    $stripe_percent = 2.9 / 100; //percent fee after VAT/GST is included
    $stripe_cost = 0.30; //fixed fee after VAT/GST is included

    $total_charge = (($amount_usd + $stripe_cost) / (1 - $stripe_percent));


    $stripe_charge = array();
    $stripe_charge["stripe_fee"] = $total_charge - $amount_usd;
    $stripe_charge["total_charge"] = $total_charge;


    return $stripe_charge;
}

//get wallet available balance
function getWalletBalance($network_id,$paperweight){

    $wallet_currency = SYSTEM_CURRENCY;
    $available_balance = 0;

    $total_available_usd = 0;
    $total_available = 0;


    $payment_query = "select * from " . TABLE_CLIENT_WALLET . " where network_id = '$network_id' and local_currency = '$wallet_currency' and extracted = 0";
    $payment_result = $paperweight->query($payment_query);

    if($payment_result != null && $payment_result->is_row_found()){
        while($row = $payment_result->fetch_array()){
            $local_currency_rate = $row["local_currency_rate"];
            $amount = ($row["amount"] == null) ? 0 : $row["amount"];
            $amount_extracted = ($row["amount_extracted"] == null) ? 0 : $row["amount_extracted"];
            $amount_remaining = $amount - $amount_extracted;

            $local_converted_amount = floatval($amount_remaining * $local_currency_rate);

            $total_available_usd += $amount_remaining;
            $total_available += $local_converted_amount;
        }

        $available_balance += floatval($total_available);
    }


    return $available_balance;
}

//get holding balance
function getHoldingBalance($network_id,$paperweight){
    $status = HOLDING_STATUS_HELD;
    $holding_balance = 0;

    $payment_query = "select * from " . TABLE_HOLDING . " where network_id = '$network_id' and status = '$status'";
    $payment_result = $paperweight->query($payment_query);

    if($payment_result != null && $payment_result->is_row_found()){
        while($row = $payment_result->fetch_array()){
            $amount = ($row["amount"] == null) ? 0 : $row["amount"];

            $holding_balance += floatval($amount);
        }
    }


    return $holding_balance;
}

//$param_obj = array();
//$param_obj["user_id"] = null;
//$param_obj["network_id"] = null;
//$param_obj["invoice_id"] = null;
//$param_obj["invoice_item_id"] = null;
//$param_obj["hold_amount"] = null;
//$param_obj["holding_id"] = null;


/**
 * @purpose HOLD : fixme (add invoice) hold funds from a client wallet for an invoice, or anything
 * @param $param_obj $param_obj [user_id | network_id | invoice_id | invoice_item_id | hold_amount]
 * @param $paperweight
 * @return bool
 */
function h_funds_hold($param_obj, $paperweight){
    //validate wallet amount inside
    $funds_held = false;

    $user_id = $param_obj["user_id"];
    $network_id = $param_obj["network_id"];
    $invoice_id = $param_obj["invoice_id"];
    $invoice_item_id = $param_obj["invoice_item_id"];
    $hold_amount = $param_obj["hold_amount"]; //(in local currency - SYSTEM_CURRENCY in this case)

    $hold_currency = SYSTEM_CURRENCY;

    $holding_id = generate_unique_id(UNIQUE_HOLD);
    $update_time = getCurrentTime();
    $transaction_amount = 0;

    //holding_id, creation_time, update_time, status, currency, amount, creator_id, network_id,
    //invoice_id, invoice_item_id, deposit_id, cancel_time, release_time, use_case

    $insert_hold = get_insert_query(TABLE_HOLDING, [
        "holding_id" => $holding_id,
        "creation_time" => $update_time,
        "status" => HOLDING_STATUS_HELD,
        "currency" => $hold_currency,
        "amount" => $transaction_amount,
        "creator_id" => $user_id,
        "network_id" => $network_id,
        "invoice_id" => null,
        "invoice_item_id" => null,
        "use_case" => null
    ]);

    $insert_hold_result = $paperweight->query($insert_hold);
    if($insert_hold_result != null && $insert_hold_result->is_row_affected()){
        $updated_usd = 0;
        $local_funds_taken = 0; //local funds already accounted for (SYSTEM_CURRENCY in this case)

        $wallet_query = "select * from " . TABLE_CLIENT_WALLET . " where creator_id = '$user_id' and local_currency = '$hold_currency' and extracted = 0 order by amount desc";
        $wallet_result = $paperweight->query($wallet_query);

        if($wallet_result != null && $wallet_result->is_row_found()){
            while($wallet_row = $wallet_result->fetch_array()){
                $payment_id = $wallet_row["payment_id"];
                $local_currency_rate = $wallet_row["local_currency_rate"];
                $local_currency = $wallet_row["local_currency"];
                $amount = ($wallet_row["amount"] == null) ? 0 : $wallet_row["amount"];
                $amount_extracted = ($wallet_row["amount_extracted"] == null) ? 0 : $wallet_row["amount_extracted"];
                $amount_remaining = $amount - $amount_extracted;

                $local_converted_amount = floatval($amount_remaining * $local_currency_rate);

                if (round($local_funds_taken,3) < round($hold_amount,3)){
                    //if more funds are required

                    $funds_required = ($hold_amount - $local_funds_taken);

                    if (round($funds_required,3) >= round($local_converted_amount,3)){
                        //payment entry has less than or the exact amount required
                        $subtracted_local_funds = ($local_converted_amount);
                        $subtracted_usd_funds = ($subtracted_local_funds / $local_currency_rate);
                        $new_amount_extracted = ($amount_extracted + $subtracted_usd_funds);
                        $extracted = 1;
                        $extracted_time = getCurrentTime();

                        //id, holding_id, creation_time, currency, amount, local_currency,
                        //local_currency_rate, creator_id, network_id, payment_id

                        $insert_hold_item = get_insert_query(TABLE_HOLDING_ITEM, [
                            "holding_id" => $holding_id,
                            "creation_time" => $update_time,
                            "currency" => $hold_currency,
                            "amount" => $subtracted_usd_funds,
                            "creator_id" => $user_id,
                            "network_id" => $network_id,
                            "local_currency" => $local_currency,
                            "local_currency_rate" => $local_currency_rate,
                            "payment_id" => $payment_id
                        ]);
                        $insert_hold_item_result = $paperweight->query($insert_hold_item);
                        if($insert_hold_item_result != null && $insert_hold_item_result->is_row_affected()){

                            $client_wallet_update = get_update_query(TABLE_CLIENT_WALLET, [
                                "amount_extracted" => $new_amount_extracted,
                                "extracted" => $extracted,
                                "extracted_time" => $update_time
                            ],"payment_id = '$payment_id' and network_id = '$network_id'");
                            $client_wallet_result = $paperweight->query($client_wallet_update);
                            if($client_wallet_result != null && $client_wallet_result->is_row_affected()){}
                        }

                        $local_funds_taken += $subtracted_local_funds;
                        $updated_usd += $subtracted_usd_funds;

                    }
                    else{
                        //payment entry has more than amount required
                        $subtracted_local_funds = ($funds_required);
                        $subtracted_usd_funds = ($subtracted_local_funds / $local_currency_rate);
                        $new_amount_extracted = ($amount_extracted + $subtracted_usd_funds);
                        $extracted = 0;

                        $insert_hold_item = get_insert_query(TABLE_HOLDING_ITEM, [
                            "holding_id" => $holding_id,
                            "creation_time" => $update_time,
                            "currency" => $hold_currency,
                            "amount" => $subtracted_usd_funds,
                            "creator_id" => $user_id,
                            "network_id" => $network_id,
                            "local_currency" => $local_currency,
                            "local_currency_rate" => $local_currency_rate,
                            "payment_id" => $payment_id
                        ]);
                        $insert_hold_item_result = $paperweight->query($insert_hold_item);
                        if($insert_hold_item_result != null && $insert_hold_item_result->is_row_affected()){
                            $client_wallet_update = get_update_query(TABLE_CLIENT_WALLET, [
                                "amount_extracted" => $new_amount_extracted,
                                "extracted" => $extracted,
                            ],"payment_id = '$payment_id' and network_id = '$network_id'");
                            $client_wallet_result = $paperweight->query($client_wallet_update);
                            if($client_wallet_result != null && $client_wallet_result->is_row_affected()){}
                        }

                        $local_funds_taken += $subtracted_local_funds;
                        $updated_usd += $subtracted_usd_funds;

                    }

                }
                else{
                    break;
                }

            }
        }

        $update_hold = get_update_query(TABLE_HOLDING, [
            "amount" => $updated_usd
        ],"holding_id = '$holding_id' and network_id = '$network_id'");
        $update_hold_result = $paperweight->query($update_hold);
        if($update_hold_result != null && $update_hold_result->is_row_affected()){
            $funds_held = true;
        }

    }

    return $funds_held;
}

/**
 * @purpose HOLD : This is used to apply the held funds to the intended invoice
 * @param $param_obj $param_obj [ network_id | holding_id]
 * @param $paperweight
 * @return bool
 */
function h_funds_hold_release($param_obj, $paperweight){
    $funds_released = false;

    $network_id = $param_obj["network_id"];
    $holding_id = $param_obj["holding_id"];

    $status = HOLDING_STATUS_HELD;

    $payment_query = "select * from " . TABLE_HOLDING . " where network_id = '$network_id' and status = '$status' and holding_id = '$holding_id'";
    $payment_result = $paperweight->query($payment_query);

    if($payment_result != null && $payment_result->is_row_found()){
        if($row = $payment_result->fetch_array()){

            $new_status = HOLDING_STATUS_RELEASED;
            $update_time = getCurrentTime();

            $update_hold = get_update_query(TABLE_HOLDING, [
                "update_time" => $update_time,
                "status" => $new_status
            ],"holding_id = '$holding_id' and network_id = '$network_id'");
            $update_hold_result = $paperweight->query($update_hold);
            if($update_hold_result != null && $update_hold_result->is_row_affected()){
                $funds_released = true;
            }

        }
    }


    return $funds_released;
}


/**
 * @purpose HOLD : This is used to re-apply the funds to wallet and remove hold item
 * @param $param_obj $param_obj [ network_id | holding_id]
 * @param $paperweight
 * @return bool
 */
function h_funds_hold_cancel($param_obj, $paperweight){
    $funds_cancelled = false;

    $network_id = $param_obj["network_id"];
    $holding_id = $param_obj["holding_id"];

    $status = HOLDING_STATUS_HELD;

    $payment_query = "select * from " . TABLE_HOLDING . " where network_id = '$network_id' and status = '$status' and holding_id = '$holding_id'";
    $payment_result = $paperweight->query($payment_query);

    if($payment_result != null && $payment_result->is_row_found()){
        if($row = $payment_result->fetch_array()){

            $hold_item_query = "select * from " . TABLE_HOLDING_ITEM . " where network_id = '$network_id' and holding_id = '$holding_id'";
            $item_result = $paperweight->query($hold_item_query);

            if($item_result != null && $item_result->is_row_found()){
                while($item_row = $item_result->fetch_array()){
                    $temp_id = $item_row["id"];
                    $amount = $item_row["amount"];
                    $payment_id = $item_row["payment_id"];
                    $update_time = getCurrentTime();
                    $extracted = 0;

                    $update_wallet = get_update_query(TABLE_CLIENT_WALLET, [
                        "update_time" => $update_time,
                        "extracted_time" => null,
                        "extracted" => $extracted
                    ],"payment_id = '$payment_id' and network_id = '$network_id'",[
                        "amount_extracted" => "amount_extracted - ($amount)"
                    ]);
                    $update_wallet_result = $paperweight->query($update_wallet);
                    if($update_wallet_result != null && $update_wallet_result->is_row_affected()){

                        $del_item_query = "delete from " . TABLE_HOLDING_ITEM . " where id = '$temp_id'";
                        $del_item_result = $paperweight->query($del_item_query);
                        if($del_item_result != null && $del_item_result->is_row_affected()){}

                    }
                }

                $new_status = HOLDING_STATUS_CANCELLED;
                $update_time = getCurrentTime();
                $update_hold = get_update_query(TABLE_HOLDING, [
                    "update_time" => $update_time,
                    "status" => $new_status
                ],"holding_id = '$holding_id' and network_id = '$network_id'");
                $update_hold_result = $paperweight->query($update_hold);
                if($update_hold_result != null && $update_hold_result->is_row_affected()){
                    $funds_cancelled = true;
                }
            }

        }
    }

    return $funds_cancelled;
}

/**
 * @purpose HOLD : This is used to update the amout being helf for a specific purpose
 * @param $param_obj $param_obj [network_id | holding_id | hold_amount]
 * @param $paperweight
 * @return bool
 */
function h_funds_hold_update($param_obj, $paperweight){
    $funds_updated = false;

    return $funds_updated;
}




//get subscription data
//get subscription item list
//get invoice data
//get invoice item list
//create subscription invoice


function getFileData($file_id, $network_id, $paperweight){
    $file_data = array();

    $file_query = "select * from " . TABLE_ALL_FILES . " where network_id = '$network_id' and file_id = '$file_id'";
    $file_query_result = $paperweight->query($file_query);

    if($file_query_result != null && $file_query_result->is_row_found()){
        if($row = $file_query_result->fetch_array()){

            $file_data["file_id"] = $row["file_id"];
            $file_data["file_name"] = $row["original_filename"];
            $file_data["file_ext"] = $row["file_ext"];
            $file_data["file_url"] = FTP_Q_FILE_DIRECTORY . $row["file_name"];
            $file_data["file_size"] = $row["file_size"];
            $file_data["uploaded_date"] = $row["creation_time"];

        }
    }

    return $file_data;
}

//Get the category based on the unique category identifier
function getProductCategory($category_id, $paperweight){

    $category = array();

    $get_category = "select * from " . TABLE_PRODUCT_CATEGORY . " where category_id = '$category_id'";
    $get_category_result = $paperweight->query($get_category);

    if($get_category_result != null && $get_category_result->is_row_found()){
        if($row = $get_category_result->fetch_array()){

            $category["category_id"] = $row["category_id"];
            $category["category_name"] = $row["category_name"];
            $category["category_description"] = $row["category_description"];
            $category["country_code"] = $row["country_code"];
            $category["creation_time"] = $row["creation_time"];
            $category["network_id"] = $row["network_id"];
            $category["creator_id"] = $row["creator_id"];
            $category["update_time"] = $row["update_time"];

        }
    }

    return $category;
}



//todo json - DEMO-FUNCTION-MARKET
function storesWithProduct($product_name, $country_code = null){
    ini_set('memory_limit', '-1');

    //$string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_PRODUCTS_UPDATED.json");
    $string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_PRODUCTS_WITH_JAMAICA.json");

    /*if (strtoupper($country_code) == "JM"){
        $string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_JM_PRODUCT_NAME.json");
    }*/

    //$string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_PRODUCTS.json");
    //$string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_PRODUCTS_WITH_SOPROLE.json");
    $json_a = json_decode($string, true);


    $stores_with_product = array();

    foreach ($json_a as $store) {

        if (isset($store[$product_name]) && $store[$product_name] == "Y") {
            array_push($stores_with_product, $store["store_id"]);
        }
    }

    return $stores_with_product;
}
function getStoreLocality($country_code, $search_id = null){
    ini_set('memory_limit', '-1');

    $string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_STORE_LIST_ALL.json");
    //$string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_PRODUCTS.json");
    //$string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_PRODUCTS_WITH_SOPROLE.json");
    $json_a = json_decode($string, true);


    $stores_with_product = array();
    $loaded = array();

    foreach ($json_a as $store) {

        if ($store["country_code"] == $country_code){

            if ($search_id != null){
                if (!isset($loaded[$store["locality"]]) && (stripos($store["locality"], $search_id) !== false)) {
                    $stores_with_product[] = $store["locality"];

                    $loaded[$store["locality"]] = 1;
                }
            }
            else{
                if (!isset($loaded[$store["locality"]])) {
                    $stores_with_product[] = $store["locality"];

                    $loaded[$store["locality"]] = 1;
                }
            }

        }

    }


    return $stores_with_product;
}
function filterStoreList($filter, $obj_store_list = null){
    //$filter = array();
    //$filter["country_code"] = "CL";
    //$filter["region"] = "La Serena";
    //$filter["locality"] = null;
    //$filter["store_type"] = "wholesalestore"; //wholesalestore
    //$filter["product_name"] = "Pan Hot Dog 8 Un";

    //$product_string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_PRODUCTS_WITH_SOPROLE.json");
    //$obj_product_list = json_decode($product_string, true);

    $country_code = text_clean($filter["country_code"]);
    $region = text_clean($filter["region"]);
    $locality = text_clean($filter["locality"]);
    $store_type = text_clean($filter["store_type"]);
    $product_name = text_clean($filter["product_name"]);
    //$product_name = text_clean($filter["product_type"]);

    $storesWithProduct = array();
    if (!empty($product_name)){
        $storesWithProduct = storesWithProduct($product_name,$country_code);
    }

    $final_list = array();

    foreach ($obj_store_list as $store){

        $store_obj = array();

        $store_obj["store_id"] = $store["store_id"];
        $store_obj["store_name"] = $store["store_name"];
        $store_obj["store_type"] = $store["store_type"];
        $store_obj["logo_url"] = $store["logo_url"];
        $store_obj["store_url"] = $store["store_url"];
        $store_obj["country_code"] = $store["country_code"];
        $store_obj["address"] = $store["address"];
        $store_obj["currency_code"] = $store["currency_code"];
        $store_obj["total_products"] = $store["total_products"];
        $store_obj["days_active"] = $store["days_active"];
        $store_obj["daily_transactions"] = $store["daily_transactions"];
        $store_obj["avg_monthly_sales"] = $store["avg_monthly_sales"];
        $store_obj["monthly_subscription"] = $store["monthly_subscription"];
        $store_obj["region"] = $store["region"];
        $store_obj["locality"] = $store["locality"];
        $store_obj["co_id"] = $store["co_id"];

        $required = 0;
        $passed = 0;

        if (!empty($country_code)){
            //$passed = false;

            $required++;

            if (strcasecmp($country_code, $store["country_code"]) == 0){
                $passed++;
            }

        }
        if (!empty($region)){
            //$passed = false;

            $required++;

            if (strcasecmp($region, $store["region"]) == 0){
                $passed++;
            }

        }
        if (!empty($locality)){
            //$passed = false;

            $required++;

            if (strcasecmp($locality, $store["locality"]) == 0){
                $passed++;
            }

        }
        if (!empty($store_type)){
            //$passed = false;

            $required++;

            if (strcasecmp($store_type, $store["store_type"]) == 0){
                $passed++;
            }

        }
        if (!empty($product_name)){
            //$passed = false;

            $required++;

            if (in_array($store["store_id"],$storesWithProduct)){
                $passed++;
            }
        }

        if ($passed >= $required){
            $final_list[] = $store_obj;
        }

    }

    return $final_list;
}
function getStorePackage($package_id) {
    $string = file_get_contents("https://api.queritel.com/api/web/queritel/console/v1/QWA_STORE_LIST_ALL.json");
    $json_a = json_decode($string, true);


    $package = array();

    foreach ($json_a as $store) {

        if ($store["store_id"] == $package_id) {
            $package = $store;

            break;
        }

    }

    return $package;
}




//this is used to get the session key
function get_session_key(){
    $insight_url = "https://insight.queritel.com/index.php/admin/remotecontrol";

    $headers = array(
        'Content-Type: application/json'
    );

    $session_key = null;

    $embedded = array();
    $embedded["method"] = "get_session_key";
    $embedded["id"] = 1;
    $embedded["params"] = array(
        "username" => "Queritel",
        "password" => "sMCzVSeWpvCZ"
    );

    $encoded_fields = json_encode($embedded);


    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $insight_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    $result_obj = json_decode($result, true);

    $session_key = $result_obj["result"];

    curl_close($ch);

    return $session_key;
}
function get_dashboard_lnk($dashboard_code){
    $SITE_URL = "https://chartally.com";
    $SECRET_KEY = "a5b75f839d2201416d39d502194092f29127e3baa187219cc11f5d15fbd5bdf8";


    $timeObj = new DateTime();
    $timeObj->setTimezone(new DateTimeZone("UTC"));
    $min = 60 * (24);  // 24 hours
    $expiration = ((int)$timeObj->format('U') + (60 * $min));

    $header = json_encode([
        'typ' => 'JWT',
        'alg' => 'HS256'
    ]);

    // Create token payload as a JSON string
    $payload = json_encode([
        'resource' => [
            'dashboard' => intval($dashboard_code)
        ],
        'params' => (object) array(),
        'exp' => $expiration
    ]);

    // Encode Header to Base64Url String
    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));

    // Encode Payload to Base64Url String
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));

    // Create Signature Hash
    $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $SECRET_KEY, true);

    // Encode Signature to Base64Url String
    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

    // Create JWT
    $jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;

    return $SITE_URL . "/embed/dashboard/" . $jwt . "#bordered=true&titled=true";
}
function get_question_lnk($question_code){
    $SITE_URL = "https://chartally.com";
    $SECRET_KEY = "a5b75f839d2201416d39d502194092f29127e3baa187219cc11f5d15fbd5bdf8";


    $timeObj = new DateTime();
    $timeObj->setTimezone(new DateTimeZone("UTC"));
    $min = 60 * (24);  // 24 hours
    $expiration = ((int)$timeObj->format('U') + (60 * $min));

    $header = json_encode([
        'typ' => 'JWT',
        'alg' => 'HS256'
    ]);

    // Create token payload as a JSON string
    $payload_quest = json_encode([
        'resource' => [
            'question' => $question_code
        ],
        'params' => (object) array(),
        'exp' => $expiration
    ]);

    // Encode Header to Base64Url String
    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));

    // Encode Payload to Base64Url String
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload_quest));

    // Create Signature Hash
    $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $SECRET_KEY, true);

    // Encode Signature to Base64Url String
    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

    // Create JWT
    $jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;

    return $SITE_URL . "/embed/question/" . $jwt . "#bordered=true&titled=true";
}


function isUserRegistered($email, $paperweight){
    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_email = '$email'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null && $user_result->is_row_found()) {

        if ($row = $user_result->fetch_array()) {

            $result["user_id"] = $row["user_id"];
            $result["user_type"] = $row["user_type"];

        }
    }

    return $result;
}
function isAgentRegistered($email, $paperweight){
    $result = array();

    $user_type = USER_TYPE_RESEARCHER;

    $user_query = "select * from " . TABLE_USERS . " where user_email = '$email' and user_type = '$user_type'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null && $user_result->is_row_found()) {

        if ($row = $user_result->fetch_array()) {

            $result["user_id"] = $row["user_id"];
            $result["user_type"] = $row["user_type"];

        }
    }

    return $result;
}
function isClientRegistered($email, $paperweight){
    $result = array();

    $user_type = USER_TYPE_CLIENT;

    $user_query = "select * from " . TABLE_USERS . " where user_email = '$email' and user_type = '$user_type'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null && $user_result->is_row_found()) {

        if ($row = $user_result->fetch_array()) {

            $result["user_id"] = $row["user_id"];
            $result["user_type"] = $row["user_type"];

        }
    }

    return $result;
}

function triggerRawLogin($user_id, $paperweight){
    $login_data = array();

    $login_token = generate_token();
    $login_time = getCurrentTime();
    $login_state = LOGIN_STATE_VALID;


    $add_login = get_insert_query(TABLE_LOGIN,[
        "token_id" => $login_token,
        "login_time" => $login_time,
        "login_state" => $login_state,
        "user_id" => $user_id
    ]);
    $add_login_result = $paperweight->query($add_login);
    if($add_login_result != null && $add_login_result->is_row_affected()){

        $login_data = getOKStatus();
        $login_data["user_id"] = $user_id;
        $login_data["login_token"] = $login_token;

    }

    return $login_data;
}

//todo not implemented
function addToGroup($user_id,$group_id,$network_id, $paperweight){
    $login_data = array();

    $login_token = generate_token();
    $login_time = getCurrentTime();
    $login_state = LOGIN_STATE_VALID;


    $add_login = get_insert_query(TABLE_LOGIN,[
        "token_id" => $login_token,
        "login_time" => $login_time,
        "login_state" => $login_state,
        "user_id" => $user_id
    ]);
    $add_login_result = $paperweight->query($add_login);
    if($add_login_result != null && $add_login_result->is_row_affected()){

        $login_data = getOKStatus();
        $login_data["user_id"] = $user_id;
        $login_data["login_token"] = $login_token;

    }

    return $login_data;
}


//todo update due date - config interface --------
function updateDueDate($days_hours_mins){
    //DAYS-HOURS-MINUTES
    $extra_obj = explode("-",$days_hours_mins);
    $days = $extra_obj[0];
    $hours = $extra_obj[1];
    $minutes = $extra_obj[2];
    $minutes_to_add = 0;

    if ($days > 0){
        $hours += ($days * 24);
    }
    if ($hours > 0){
        $minutes += ($hours * 60);
    }
    if ($minutes > 0){
        $minutes_to_add += $minutes;
    }

    $old_time_utc = "2021-07-28 07:00:00";
    $interval_spec = "PT" . $minutes_to_add . "M";

    $time = new DateTime($old_time_utc,new DateTimeZone("UTC"));
    $time->add(new DateInterval($interval_spec));
    $new_time_utc = $time->format("Y-m-d H:i:s");

    $sub = array();
    $sub["minutes_to_add"] = $minutes_to_add;
    $sub["old_time_utc"] = $old_time_utc;
    $sub["new_time_utc"] = $new_time_utc;
    $sub["extra_obj"] = $extra_obj;
    $sub["extra"] = $days_hours_mins;

    return $sub;
}

//SOURCE : used to upload files to Queritel directory
//fixme --> replace error strings with code
function queritelUploadFile($targetPath, $sourcePath){
    $ftp_connection = ftp_connect(FTP_HOST_SERVER, 21);

    $statusMessage = "";
    if ($ftp_connection) {
        $login = ftp_login($ftp_connection, FTP_Q_HOST_USERNAME, FTP_Q_HOST_PASS);
        if ($login) {
            ftp_pasv($ftp_connection, true);
            if (ftp_put($ftp_connection, $targetPath, $sourcePath, FTP_BINARY)) {
                $statusMessage = true;
            } else {
                $statusMessage = "Error while uploading";
            }
        } else {
            $statusMessage = "login to ftp server " . FTP_HOST_SERVER . " failed!";
        }
        ftp_close($ftp_connection);
    } else {
        return "connection to ftp server " . FTP_HOST_SERVER . " failed!";
    }

    return $statusMessage;
}

//SOURCE : used to remove files from the Queritel directory
//fixme --> replace error strings with code
function queritelRemoveFile($targetPath){
    $ftp_connection = ftp_connect(FTP_HOST_SERVER, 21);

    $statusMessage = "";
    if ($ftp_connection) {
        $login = ftp_login($ftp_connection, FTP_Q_HOST_USERNAME, FTP_Q_HOST_PASS);
        if ($login) {
            ftp_pasv($ftp_connection, true);
            if (ftp_delete($ftp_connection, $targetPath)) {
                $statusMessage = true;
            } else {
                $statusMessage = "Error while uploading";
            }
        } else {
            $statusMessage = "login to ftp server " . FTP_HOST_SERVER . " failed!";
        }
        ftp_close($ftp_connection);
    } else {
        return "connection to ftp server " . FTP_HOST_SERVER . " failed!";
    }

    return $statusMessage;
}

//CATALOG : to get the category name based on the id passed
function get_catalog_category($category_id,$figozo){
    $result = null;

    $catalog_query = "select * from " . TABLE_CATALOG_CATEGORY . " where category_id = '$category_id'";
    $catalog_result = $figozo->query($catalog_query);

    if($catalog_result != null && $catalog_result->is_row_found()){
        if ($row = $catalog_result->fetch_array()){
            $result = $row["name"];
        }
    }

    return $result;
}

//CATALOG : to get the brand name based on the id passed
function get_catalog_brand($brand_id,$figozo){
    $result = null;

    $catalog_query = "select * from " . TABLE_CATALOG_BRAND . " where brand_id = '$brand_id'";
    $catalog_result = $figozo->query($catalog_query);

    if($catalog_result != null && $catalog_result->is_row_found()){
        if ($row = $catalog_result->fetch_array()){
            $result = $row["name"];
        }
    }

    return $result;
}

//CATALOG : to get the unit label name based on the id passed
function get_catalog_label($unit_label_id,$figozo){
    $result = null;

    $catalog_query = "select * from " . TABLE_CATALOG_UNIT . " where unit_label_id = '$unit_label_id'";
    $catalog_result = $figozo->query($catalog_query);

    if($catalog_result != null && $catalog_result->is_row_found()){
        if ($row = $catalog_result->fetch_array()){
            $result = $row["name"];
        }
    }

    return $result;
}

//CATALOG : to get the item based on the catalog id passed
function get_catalog_item($catalog_id, $figozo = null){
    $catalog_item = array();

    if ($figozo == null){
        $figozo = new Database(FIGOZO_DB_USERNAME, FIGOZO_DB_PASSWORD, FIGOZO_DB_NAME);
    }

    $get_catalog = "select * from " . TABLE_CATALOG . " where catalog_id = '$catalog_id'";
    $catalog_result = $figozo->query($get_catalog);
    if($catalog_result != null && $catalog_result->is_row_found()){
        if($row = $catalog_result->fetch_array()){

            $brand = get_catalog_brand($row["brand_id"],$figozo);
            $category = get_catalog_category($row["category_id"],$figozo);
            $unit_label = get_catalog_label($row["unit_label_id"],$figozo);

            $catalog_item["catalog_id"] = $row["catalog_id"];
            $catalog_item["product_name"] = $row["name"];
            $catalog_item["category_name"] = $category;
            $catalog_item["brand"] = $brand;
            $catalog_item["unit_value"] = intval($row["unit_value"]);
            $catalog_item["unit_label"] = $unit_label;
            $catalog_item["image_url"] = CATALOG_ITEM_ROOT .  $row["file_name"];
            $catalog_item["image_name"] = $row["file_name"];
            $catalog_item["brand_id"] = $row["brand_id"];
            $catalog_item["category_id"] = $row["category_id"];
            $catalog_item["unit_label_id"] = $row["unit_label_id"];
            $catalog_item["country_code"] = $row["country_code"];

        }
    }

    return $catalog_item;
}


//INSIGHT : This is checks if the survey url is running on the insight platform
function isInsightSurvey($survey_url){
    $is_insight_survey = false;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);

    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    return $is_insight_survey;
}

//INSIGHT : this get the insight survey id or NULL
function getInsightSurveyID($survey_url){
    $is_insight_survey = false;
    $survey_id = null;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);
    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    if ($is_insight_survey){
        $path = parse_url($survey_url, PHP_URL_PATH);
        $path_arr = explode("/",$path);
        $survey_id = $path_arr[count($path_arr) - 1];
    }

    return $survey_id;
}

//INSIGHT : this gets the updated link with the token appended
function getUpdatedInsightSurveyLink($survey_url,$survey_token,$language_code = null){ //add language code
    $is_insight_survey = false;
    $url = $survey_url;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);
    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    if ($is_insight_survey){
        $search = "lang";
        $params = array();
        $query = parse_url($survey_url, PHP_URL_QUERY);
        parse_str($query,$params);

        if(preg_match("/{$search}/i", $query)){
            //if the url has "lang"
            foreach ($params as $key => $value) {
                if ($key == "lang") {
                    $item_search = "lang=$value";
                    $item_replace = "lang=$language_code";

                    if($language_code != null){
                        $survey_url = str_replace($item_search,$item_replace,$survey_url);
                    }

                }
            }
        }
        else {
            //if the url does not have "lang"
            if($language_code != null){
                $survey_url = $survey_url . (parse_url($survey_url, PHP_URL_QUERY) ? '&' : '?') . 'lang=' . $language_code;
            }
        }


        $url = $survey_url . (parse_url($survey_url, PHP_URL_QUERY) ? '&' : '?') . 'token=' . $survey_token;
    }

    return $url;
}


//INSIGHT : this gets a unique token from the survey database and reserves a spot
function getUniqueInsightSurveyToken($survey_url, $client = null){
    $is_insight_survey = false;
    $survey_id = null;
    $available_token = null;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);
    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    if ($is_insight_survey){
        $path = parse_url($survey_url, PHP_URL_PATH);
        $path_arr = explode("/",$path);
        $survey_id = $path_arr[count($path_arr) - 1];

        $survey_response_table = "lsnm_survey_" . $survey_id;
        $survey_token_table = "lsnm_tokens_" . $survey_id;

        $insight_db = new Database(INSIGHT_DB_USERNAME,INSIGHT_DB_PASSWORD,INSIGHT_DB_NAME);

        $available_token = null;
        $has_available_token = false;
        $reservation_time = getCurrentTime("Y-m-d H:i");


        //get previously assigned token
        $user_ref_id = $client->getUserRefId();
        $fname = $client->get_firstName();
        $lname = $client->get_lastName();
        $email = $client->get_email();


        $sql_prev_token = "select * from " . $survey_token_table . " where attribute_1 = '$user_ref_id' and (completed is null or completed in ('N'))"; //previous token is still available
        $sql_prev_query_result = $insight_db->query($sql_prev_token);
        if($sql_prev_query_result != null && $sql_prev_query_result->is_row_found()){
            while($row = $sql_prev_query_result->fetch_array()){
                $token_id = $row["tid"];
                $available_token = $row["token"];

                $update_query = "update " . $survey_token_table . " set `sent` = '$reservation_time' where `tid` = '$token_id'";
                $update_query_result = $insight_db->query($update_query);
                if($update_query_result != null && $update_query_result->is_row_affected()){
                    //$has_available_token = true;
                }

                break;
            }
        }
        else{
            $sql_query = "select * from " . $survey_token_table . " where sent is null or sent in ('N')"; //token is available
            $sql_query_result = $insight_db->query($sql_query);
            if($sql_query_result != null && $sql_query_result->is_row_found()){
                while($row = $sql_query_result->fetch_array()){
                    $token_id = $row["tid"];
                    $available_token = $row["token"];

                    $update_query = "update " . $survey_token_table . " set `sent` = '$reservation_time', email = '$email', attribute_1 = '$user_ref_id', firstname = '$fname', lastname = '$lname' where `tid` = '$token_id'";
                    $update_query_result = $insight_db->query($update_query);
                    if($update_query_result != null && $update_query_result->is_row_affected()){
                        //$has_available_token = true;
                    }

                    break;
                }
            }
        }






    }

    return $available_token;
}

//============= THIRD PARTY API START =================
$get_prod = array();


$payload = array();
$payload["SkuCode"] = "JM_DC_TopUp";
$payload["SendValue"] = 5;
$payload["SendCurrencyIso"] = "usd";
$payload["AccountNumber"] = "18765197487";
$payload["DistributorRef"] = "#659075749";

$settings = array();
$settings["Name"] = "Queritel Payout";
$settings["Value"] = "5 usd";

$payload["Settings"] = $settings;
$payload["ValidateOnly"] = false;
$payload["BillRef"] = "Queritel Reference : 1967048";

/*{
  "SkuCode": "string",
  "SendValue": 0,
  "SendCurrencyIso": "string",
  "AccountNumber": "string",
  "DistributorRef": "string",
  "Settings": [
    {
      "Name": "string",
      "Value": "string"
    }
  ],
  "ValidateOnly": true,
  "BillRef": "string"
}*/

function createEmailConfirmationBody($url){

    //$date = date("M d, Y h:i");
    //$timezone = date_default_timezone_get();
    //$url = "https://www.google.com"; //' . $url . '
    //$org_name = $organization_name;//"Queritel Business'";


    $body = '
    
            '.$url.'
        <table style="margin:0 auto;font-family:\'Open Sans\', sans-serif;" border="0" width="600" cellspacing="0" cellpadding="10" bgcolor="#FFFFFF">
        <tbody>
            <tr style="background:#bf0000 none repeat scroll 0px 0px;">
                <td style="padding:0px;">
                    <table border="0" width="100%" cellspacing="0" cellpadding="0">
                        <tbody>
                            <tr>
                                
                            </tr>
                        </tbody>
                    </table>
                </td>
            </tr>
        </tbody>
    </table>';

    return $body;
}

//DING MOBILE RECHARGE : needs to be fixed
function connectDingAPI($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    //curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json','api_key: ApyJWyuifmb6YMuJhu7wAW'));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Accept: application/json',
            'Content-Type: application/json',
            'api_key: ' . DING_MOBILE_RECHARGE_KEY
        ));


    $payload = array();
    $payload["SkuCode"] = "JM_DC_TopUp";
    $payload["SendValue"] = 5;
    $payload["SendCurrencyIso"] = "USD";
    //$payload["AccountNumber"] = "18765197487";
    $payload["AccountNumber"] = "18762971769";
    $payload["DistributorRef"] = "#659075749";

    //$settings = array();
    //$settings["Name"] = "Queritel Payout";
    //$settings["Value"] = "5 usd";
    //$settings["Name"] = "";
    //$settings["Value"] = "";

    //$payload["Settings"] = $settings;
    $payload["ValidateOnly"] = true;
    $payload["BillRef"] = "Queritel Reference : 1967048";



    //$fields = array();
    //$fields['data'] = $message;
    $encoded_fields = json_encode($payload);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $res = curl_exec($ch);

    curl_close($ch);

    //$res = json_decode($res, true);
    //$res = json_decode($res, true);

    return $res;
}

//FIREBASE NOTIFICATION BASE
function sendFCM($message, $id) {
    /*if(!function_exists(curl_exec)){
        LogReport("unsetRequestTopicListener : " . "curl is not installed");
        return;
    }*/

    //$message =  array
    $url = 'https://fcm.googleapis.com/fcm/send';

    $fields = array();
    $fields['data'] = $message;

    if (is_array($id)) {
        $fields["registration_ids"] = $id;
    }
    else {
        $fields["to"] = $id;
    }


    $encoded_fields = json_encode($fields);
    $headers = array(
        'Authorization: key=' . FIREBASE_SERVER_KEY,
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    echo $result;

    curl_close($ch);

    return $result;
}

//VERIFY CHILEAN R.U.T
function verifyRUT($chilean_rut){
    $__lnk = 'https://api.libreapi.cl/';
    $__out = '{
                "data": {
                    "rut": "272.185.964-8",
                    "name": "Full Name",
                    "activities": [
                        {
                            "name": "Actividades De Consultoria De Gestion",
                            "code": 702000,
                            "category": "Segunda",
                            "subject_to_vat": false,
                            "date": "2020-06-18T00:00:00Z"
                        }
                    ]
                },
                "status": "success"
            }';



    //$url = "https://api.libreapi.cl/rut/validate?rut=" . $chilean_rut;
    $url = "https://api.libreapi.cl/rut/activities?rut=" . $chilean_rut;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json'
    ));

    //$payload = array();
    //$payload["var_1"] = "value";

    //$encoded_fields = json_encode($payload);
    //curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    $result_object = json_decode($result, true);

    $output = array();
    $output["rut"] = $chilean_rut;
    $output["verified"] = false;
    $output["full_name"] = null;
    $output["activities"] = null;

    if (($result_object["status"] == "success")){
        $output["rut"] = $result_object["data"]["rut"];

        if (!empty($result_object["data"]["name"])){
            $output["verified"] = true;
            $output["full_name"] = $result_object["data"]["name"];
            $output["activities"] = $result_object["data"]["activities"];
        }
    }

    curl_close($ch);

    return $output;
}





//EMAIL FUNCTIONS
/*
function email_confirm_account($email_addr,$verify_link, $lang = "en"){
    $email_var = array();
    $email_var["{{verify_link}}"] = $verify_link;

    //todo debug log
    debugAPIResponse("email_confirm",json_encode($email_var));

    $template_data = getEmailBody(EMAIL_TEMPLATE_VERIFY_EMAIL,$email_var, strtolower($lang));

    if ($template_data != null){
        $subject = $template_data["subject"];
        $body = ($template_data["body"]);

        return triggerEmail($email_addr, $subject, $body, $extra_headers='');
    }

    return false;
}
function email_reg_agent_invite($email_addr,$invite_link,$invite_code,$organization,$customized_message, $lang = "en"){
    $email_var = array();
    $email_var["{{invite_link}}"] = $invite_link;
    $email_var["{{invite_code}}"] = $invite_code;
    $email_var["{{organization}}"] = $organization;
    $email_var["{{customized_message}}"] = $customized_message;

    //todo debug log
    debugAPIResponse("reg_agent_invite",json_encode($email_var));

    $template_data = getEmailBody(EMAIL_TEMPLATE_REG_AGENT_INVITE,$email_var, strtolower($lang));

    if ($template_data != null){
        $subject = $template_data["subject"];
        $body = ($template_data["body"]);

        return triggerEmail($email_addr, $subject, $body, $extra_headers='');
    }

    return false;
}
function email_un_reg_agent_invite($email_addr,$invite_code,$organization,$customized_message, $lang = "en"){
    $email_var = array();
    $email_var["{{invite_code}}"] = $invite_code;
    $email_var["{{organization}}"] = $organization;
    $email_var["{{customized_message}}"] = $customized_message;

    //todo debug log
    debugAPIResponse("unreg_agent__invite",json_encode($email_var));

    $template_data = getEmailBody(EMAIL_TEMPLATE_UN_REG_AGENT_INVITE,$email_var, strtolower($lang));

    if ($template_data != null){
        $subject = $template_data["subject"];
        $body = ($template_data["body"]);

        return triggerEmail($email_addr, $subject, $body, $extra_headers='');
    }

    return false;
}
function email_manager_invite($email_addr,$invite_link,$organization,$customized_message, $lang = "en"){
    $email_var = array();
    $email_var["{{invite_link}}"] = $invite_link;
    $email_var["{{organization}}"] = $organization;
    $email_var["{{customized_message}}"] = $customized_message;

    //todo debug log
    debugAPIResponse("manage_invite",json_encode($email_var));

    $template_data = getEmailBody(EMAIL_TEMPLATE_MANAGER_INVITE,$email_var, strtolower($lang));

    if ($template_data != null){
        $subject = $template_data["subject"];
        $body = ($template_data["body"]);

        return triggerEmail($email_addr, $subject, $body, $extra_headers='');
    }

    return false;
}

function getEmailBody($body_func, $param, $lang = "en"){
    //todo - modify here to have email body template which then has to passed through [bindEmailData($email_body, $param)]
    $default_lang = "en";
    $allowed_lang = array("en", "es");


    $email_data = null;

    if (!in_array($lang , $allowed_lang)){
        $lang = $default_lang;
    }

    include_once "template/$lang/email.php";
    //include_once "template/en/email.php";

    try {
        if (is_callable($body_func)) {
            $email_data = $body_func($param);
        }
    }
    catch (Exception $exception){
        //echo $exception;
    }




    return $email_data;
}
function triggerEmail($to, $subject, $body, $extra_headers=''){


    $headers  = 'MIME-Version: 1.0' . "\r\n";
    //$headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";
    $headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";

    $headers .= 'From: ' . "Queritel" . '<'. "queritel@queritel.com" . "> \r\n";
    //$headers .= 'X-Sender: ' . '<'. "queritel@queritel.com" . "> \r\n";
    //$headers .= "X-Mailer: PHP\r\n";
    //$headers .= 'Mailed-By: ' . '<'. "queritel@queritel.com" . "> \r\n";
    //$headers .= 'Return-Path: ' . "Queritel" . '<'. "queritel@queritel.com" . "> \r\n";
    //$headers .= 'Reply-To: ' . "Queritel" . '<'. "queritel@queritel.com" . "> \r\n";

    if ($extra_headers != '') $headers .= $extra_headers;

    mail($to, $subject, $body, $headers);
    return true;
}
*/



//THIRD-PARTY API TEMPLATE
function __api_template__($url){
    $__lnk = 'https://';
    $__out = '';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json'
    ));

    $payload = array();
    $payload["var_1"] = "value";

    $encoded_fields = json_encode($payload);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    //$result_object = json_decode($result, true);

    curl_close($ch);

    return $result;
}


function sendNewQuestNotification($paperweight,$country_code){
    //$note_id = array();

    $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION;
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){

            $user_id = $row["user_id"];

            $user_data = query_user($user_id,$paperweight);
            $code = $user_data["country_code"];

            //country_code

            if ($country_code == $code){

                $note_id = $row["notification_id"];
                $message = array();

                $payload = array();
                $payload["status"] = PUSH_NOTIFICATION_STATUS_NEW_QUEST;
                $payload["extra"]["message"] = "empty";
                $message["payload"] = $payload;
                sendFCM($message,$note_id);

            }
        }
    }
}
function sendNewMessageNotification($user_id,$paperweight){
    //$note_id = array();


    $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id'";
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){

            $note_id = $row["notification_id"];

            $message = array();
            $payload = array();
            $payload["status"] = PUSH_NOTIFICATION_STATUS_MESSAGE;
            $payload["extra"]["message"] = "empty";
            $message["payload"] = $payload;
            sendFCM($message,$note_id);

        }
    }
}


//users who accepted the specific quest
function getQuestAgents($task_id, $paperweight){
    $progress = array();
    $result = array();
    $combined_total = 0;
    $index = 0;
    $processed_array = array();

    $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and survey_state in (" . SURVEY_STATE_PROGRESS. "," . SURVEY_STATE_COMPLETED . ")";
    $response_result = $paperweight->query($response_query);

    if ($response_result != null && $response_result->is_row_found())
    {

        $data = array();

        while ($row = $response_result->fetch_array())
        {

            //$response_total = $row["survey_count"];
            //$response_count = $row["survey_completed"];
            /*$survey_state = $row["survey_state"];*/
            $user_id = $row["user_id"];


            if (!isset($processed_array[$user_id])){

                $user_info = query_user($user_id, $paperweight);

                $data["user_id"] = $user_info["user_id"];
                $data["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
                $data["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
                $data["phone_number"] = $user_info["phone_number"];
                $data["email"] = $user_info["user_email"];


                $processed_array[$user_id] = $data;

                $progress[$index] = $data;

                $index++;
            }

            //$progress[$index]["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["user_id"] = $user_info["user_id"];


            //$progress[$index]["user_ref_id"] = $user_info["user_ref_id"];
            //$progress[$index]["response_total"] = intval($response_total);
            //$progress[$index]["response_count"] = intval($response_count);

            //$combined_total = $combined_total + $response_count;
        }
    }

    //$result["combined_total"] = intval($combined_total);
    //$result["progress"] = $progress;

    return $progress;

}
function query_user($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null && $user_result->is_row_found()) {

        if ($row = $user_result->fetch_array()) {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $user_ref_id = $row["user_ref_id"];


            $result["fname"] = $fname;
            $result["lname"] = $lname;
            $result["user_ref_id"] = $user_ref_id;
            $result["user_id"] = $user_id;
            $result["country_code"] = $row["country_code"];
            $result["phone_number"] = $row["phone_number"];
            $result["user_email"] = $row["user_email"];


        }
    }

    return $result;
}
function getLastMsg($agent_id,$network_id,$task_id,$paperweight){
    //get the last communication between an agent and the network
    //as well as the unread messages
    $last_msg = array();
    $last_msg["msg_body"] = "";
    $last_msg["timestamp"] = "";
    $last_msg["unread"] = 0; //the combined unread messages


    $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_network_id = '$network_id' or recipient_network_id = '$network_id') and (recipient_id = '$agent_id' or sender_id = '$agent_id')) and task_id = '$task_id'";
    $msg_result = $paperweight->query($msg_query);

    if($msg_result != null && $msg_result->is_row_found()){


        while($row = $msg_result->fetch_array()){

            $message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);
            $read = $row["read"];
            $unread = 0;


            $last_msg["msg_body"] = $msg_body;
            $last_msg["timestamp"] = $timestamp;

            if (($recipient_network_id == $network_id) && $read == 0){
                $prev_unread = $last_msg["unread"];
                $new_unread = $prev_unread + 1;

                $last_msg["unread"] = $new_unread;

            }

        }

    }


    return $last_msg;
}

function getClientNetwork($user_id,$paperweight){
    $role_commander = NETWORK_ROLE_COMMANDER;
    $collector_role = NETWORK_ROLE_COLLECTOR;
    $role_manager = NETWORK_ROLE_MANAGER;

    $result = array();

    $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_role in ('$role_commander','$role_manager')";
    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null && $network_rel_result->is_row_found())
    {

        if ($row = $network_rel_result->fetch_array())
        {

            $network_id = $row["network_id"];
            $network_role = $row["network_role"];
            $network_rel_state = $row["relationship_state"];

            $net = array();
            $net["network_id"] = $network_id;
            $net["network_role"] = $network_role;
            $net["relationship_state"] = $network_rel_state;

            $result = $net;

        }
    }

    return $result;
}



/**
 * This function will check if a string is inside a string-array
 * irregardless of the case of the string
 *
 *  */
function isContainedIn($str, $str_array, $case_sensitive = false) {


    if($case_sensitive == false){
        $needle = strtolower($str);
        $haystack = strtolower($str_array);
    }
    else{
        $needle = $str;
        $haystack = $str_array;
    }

    $found = preg_match("/$needle/", $haystack);


    if($found){

        return true;
    }
    else{

        return false;
    }
}
function notificationTokenHash($notification_id){
    return md5("05624" . $notification_id);
}
function encryptPassword($password){//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}
function random_number($length = 5) {
    $characters = '01234567898576479201';
    $charactersLength = strlen($characters);
    $randomNumber = '';

    for ($i = 0; $i < $length; $i++) {
        $randomNumber .= $characters[true_random(0, $charactersLength - 1)];
    }
    return $randomNumber;
}
function generate_token() {
    return getRandomNumber(4) . "" . getRandomNumber(4);
}
function generate_email_token() {
    return getRandomString(20) . "" . getRandomString(20);
}
function generate_file_name() {
    return getRandomString(8) . getRandomNumber(8) . getRandomString(9) . getRandomNumber(6);
}
function generate_unique_id($unique_prefix) {
    return $unique_prefix . getRandomString(7) . getRandomNumber(7) . getRandomString(7) . getRandomNumber(2) . getRandomString(3) ;
}

function get_guid() {
    // Get an RFC-4122 compliant globally unique identifier
    try {
        $data = PHP_MAJOR_VERSION < 7 ? openssl_random_pseudo_bytes(16) : random_bytes(16);
    } catch (Exception $e) {
        $data = openssl_random_pseudo_bytes(16);
    }
    $data[6] = chr(ord($data[6]) & 0x0f | 0x40);    // Set version to 0100
    $data[8] = chr(ord($data[8]) & 0x3f | 0x80);    // Set bits 6-7 to 10
    return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
}



//debug----
function getQuestCreatorNetwork($task_id,$paperweight){
    $network_id = null;

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null && $task_result->is_row_found())
    {

        if($row = $task_result->fetch_array())
        {
            $network_id = $row["creator_net_id"];
        }
    }

    return $network_id;
}
function getQuestDetail($task_id,$paperweight){
    $detail = array();

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null && $task_result->is_row_found())
    {

        if($row = $task_result->fetch_array())
        {
            $detail["task_id"] = $row["task_id"];
            $detail["creator_net_id"] = $row["creator_net_id"];
            $detail["task_ref_id"] = $row["task_ref_id"];
            $detail["task_user_id"] = $row["task_user_id"];
            $detail["task_status"] = $row["task_status"];
            $detail["task_topic"] = $row["task_topic"];
            $detail["task_budget"] = $row["task_budget"];
            $detail["task_instructions"] = $row["task_instructions"];
            $detail["task_posted_on"] = $row["task_posted_on"];
            $detail["task_completed_on"] = $row["task_completed_on"];
            $detail["task_respondent_count"] = $row["task_respondent_count"];
            $detail["task_question_count"] = $row["task_question_count"];
            $detail["task_location_count"] = $row["task_location_count"];
            $detail["survey_url"] = $row["survey_url"];
            $detail["completion_url"] = $row["completion_url"];
            $detail["survey_ready"] = $row["survey_ready"];
            $detail["task_time_day"] = $row["task_time_day"];
            $detail["task_question_type"] = $row["task_question_type"];
            $detail["my_network"] = $row["my_network"];
            $detail["network_id"] = $row["network_id"];
            $detail["task_category"] = $row["task_category"];
            $detail["task_activity"] = $row["task_activity"];
            $detail["task_start_date"] = $row["task_start_date"];
            $detail["task_due_date"] = $row["task_due_date"];
            $detail["handle_payment"] = $row["handle_payment"];
            $detail["workforce_timezone"] = $row["workforce_timezone"];
            $detail["workforce_country"] = $row["workforce_country"];
        }
    }

    return $detail;
}
//debug----


//get details for specific network
function getNetworkDetails($network_id, $paperweight){

    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where network_id = '$network_id'";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null && $network_result->is_row_found())
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {

            $organization_name = stringCase($row["organization_name"],STRING_CASE_CAP_EACH);
            $network_name = $row["network_name"];
            $network_id = $row["network_id"];
            $account_holder = $row["default_user"];


            $result["organization_name"] = $organization_name;
            $result["network_name"] = $network_name;
            $result["network_id"] = $network_id;
            $result["account_holder"] = $account_holder;


        }
    }

    return $result;
}

/**
 * @param $target_id
 * @param $paperweight
 * @return array - this returns the specified target row data or null
 */
function getTargetRaw($target_id, $paperweight){
    $target_query = "select * from " . TABLE_QUEST_TARGETS . " where target_id = '$target_id'";
    $target_result = $paperweight->query($target_query);

    if($target_result != null && $target_result->is_row_found()){
        $row = $target_result->fetch_array();
        if($row != null){
            return $row;
        }

    }

    return null;
}


/**
 * @param $paperweight
 * @return array - this gets a list of all the networks that can be used by any client
 */
function getOfficialNetworks($paperweight){
    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_OFFICIAL . "," . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null && $network_result->is_row_found())
    {

        while($row = $network_result->fetch_array())
        {
            $result[] = $row["network_id"];
        }
    }

    return $result;
}

/**
 * @param $user_id
 * @param $network_id
 * @param $paperweight
 * @param bool $check_active
 * @return bool - is the data-collector from the network provided
 */
function isFromNetwork($user_id, $network_id, $paperweight,$check_active = true){
    //check_active - check to make sure the relationship is active

    $is_from_network = false;

    if ($check_active){
        $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "' and relationship_state = '" . STATE_ACTIVE . "'";
    }
    else{
        $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "'";
    }

    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null && $network_rel_result->is_row_found())
    {

        $row = $network_rel_result->fetch_array();

        if ($row != null)
        {
            $is_from_network = true;
        }
    }

    return $is_from_network;
}

/**
 * @param $user_id
 * @param $paperweight
 * @return array - the list of relationships that the user has (a data collector can be apart of multiple networks)
 */
function getNetworkRelationship($user_id, $paperweight){

    $result = array();

    $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id'";
    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null && $network_rel_result->is_row_found())
    {

        while ($row = $network_rel_result->fetch_array())
        {

            $network_id = $row["network_id"];
            $network_role = $row["network_role"];
            $network_rel_state = $row["relationship_state"];

            $net = array();
            $net["network_id"] = $network_id;
            $net["network_role"] = $network_role;
            $net["relationship_state"] = $network_rel_state;

            $result[] = $net;

        }
    }

    return $result;
}

/**
 * @param $user_id
 * @param $paperweight
 * @param bool $check_active
 * @return bool - is the user from an official network (in case of data collectors, other networks can use them)
 */
function isFromOfficialNetwork($user_id, $paperweight,$check_active = true){
    $from_official = false;

    $official_networks = getOfficialNetworks($paperweight);
    $network_relationship = getNetworkRelationship($user_id,$paperweight);

    if (!empty($network_relationship)){
        foreach ($network_relationship as $relation){
            $network_id = $relation["network_id"];
            $network_role = $relation["network_role"];
            $network_rel_state = $relation["relationship_state"];

            if ($check_active){
                if (in_array($network_id,$official_networks) && $network_rel_state == STATE_ACTIVE){
                    $from_official = true;
                }
            }
            else{
                if (in_array($network_id,$official_networks)){
                    $from_official = true;
                }
            }
        }
    }

    return $from_official;
}





function getContentCurl($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));

    $res = curl_exec($ch);

    curl_close($ch);

    return $res;
}

//Location-Based functions
function getDistanceBetweenAccurate(LocationPoint $point1, LocationPoint $point2) {
    //get the distance from driver's location to the request origin [to see how close the driver is]
    //returns array("SUCCESS","distance_value")
    //unit = metrics(meters)

    $output["status"] = "FAILED";

    if($point1->isEmpty() || $point2->isEmpty()){
        return $output;
    }


    $origin = $point1->getLatitude() . "," . $point1->getLongitude();
    $destination = $point2->getLatitude() . "," . $point2->getLongitude();

    $url2 = "https://map.google.com/maps/api/distancematrix/json?units=metric&origins={$origin}&destinations={$destination}&key=" . SERVER_MAP_KEY;
    $fil2 = file_get_contents($url2);

    $results = json_decode($fil2, true);


    if ($results["status"] == "OK") {
        if ($results["rows"][0]["elements"][0]["status"] == "OK") {
            $distance_in_meters = $results["rows"][0]["elements"][0]["distance"]["value"];
            $output["status"] = "SUCCESS";
            $output["distance"] = $distance_in_meters;
        }
    }

    return $output;
}
function getRad($var) {
    return $var * pi() / 180;
}
function getDistanceBetweenGeneral(LocationPoint $point1, LocationPoint $point2) {
    $EARTH_MEAN_RADIUS_METERS = 6378137; //earths mean radius in meters

    $output = null;

    if($point1->isEmpty() || $point2->isEmpty()){
        return $output;
    }


    $distanceLat = getRad($point2->getLatitude() - $point1->getLatitude());
    $distanceLon = getRad($point2->getLongitude() - $point1->getLongitude());

    $a = sin($distanceLat / 2) * sin($distanceLat / 2) + cos(getRad($point1->getLatitude())) * cos(getRad($point2->getLatitude())) * sin($distanceLon / 2) * sin($distanceLon / 2);
    $angular_distance = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $distance_meters = intval($EARTH_MEAN_RADIUS_METERS * $angular_distance);

    $output = $distance_meters;

    return $output;
}

function getDefaultNetwork($paperweight){
    $network_id = null;

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null && $network_result->is_row_found())
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {
            $network_id = $row["network_id"];
        }
    }

    //"nid_hfg589368HWrvsp"; // queritel network id

    return $network_id;

}
function generateUserReferenceId() {
    return getRandomNumber(8);
}
function generateNumericId() {
    return getRandomNumber(8);
}

function debugAPIResponse($api,$msg) {

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "$api-$time_stamp-$random.json";
    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);
}

function __get_template__($paperweight){
    $module = array();


    $sql_query = "select * from " . TABLE_ALL_MODULES . " order by sort asc";
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){
            $module[] = $row["module_id"];
        }
    }
}
function __insert_template__($paperweight){
    $module = array();


    $sql_query = "insert into " . "_TABLE_NAME_" . " (column_1,column_2,column_3,column_4) values ('','','','')";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }

    $get_insert_query = get_insert_query("test_table", [
        "name" => "Hello",
        "next" => "World"
    ]);
}
function __update_template__($paperweight){
    $module = array();

    $sql_query = "update " . "_TABLE_NAME_" . " set `column_1` = '' where `column_1` = 0";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }

    $get_update_query = get_update_query("test_table", [
        "name" => "Yes",
        "food" => "banana",
        "next" => "Kadan"
    ],"name = 'xdjj'");
}
function __delete_template__($paperweight){
    $module = array();

    $sql_query = "delete from " . "_TABLE_NAME_" . " where `column_1` = 0";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}

function get_update_query(string $table,array $set, string $where = null, array $calculated_set = null): string
{

    $query = "update " . $table . " set";
    foreach ($set as $key => $value) {
        if ($value === null){
            $query .= " $key = null,";
        }
        else{
            $query .= " $key = '" . $value . "',";
        }
    }

    if ($calculated_set !== null){
        //can be used to pass key value without quotations
        foreach ($calculated_set as $key => $value) {
            if ($value === null){
                $query .= " $key = null,";
            }
            else{
                $query .= " $key = " . $value . ",";
            }
        }
    }

    $query = rtrim($query, ", ");

    if ($where != null){
        $query .= " where " . $where;
    }

    return $query;
}
function get_insert_query($table, array $values): string
{

    $query = "insert into " . $table . " (";
    foreach ($values as $key => $value) {
        $query .= $key . ",";
    }
    $query = rtrim($query, ", ");
    $query .= ") values (";

    /*foreach ($values as $value) {
        $query .= " (";
        foreach ($value as $val) {
            $query .= "'" . $val . "',";
        }
        $query = rtrim($query, ", ");

        $query .= "),";
    }*/
    foreach ($values as $key => $value) {
        if ($value === null){
            $query .=  "null,";
        }
        else{
            $query .= "'" . $value . "',";
        }

    }
    $query = rtrim($query, ", ");

    $query .= "),";
    $query = rtrim($query, ", ");

    return $query;
}

function getErrorStatus($error_msg){
    $result = array();
    $error = array();
    $error["name"] = ERROR_NAME_OP_FAILED;
    $error["message"] = $error_msg;
    $result["status"] = STATUS_ERROR;
    $result["error"] = $error;

    return $result;
}
function getOKStatus(){
    $result = array();
    $result["status"] = STATUS_OK;

    return $result;
}




/*
 * Author : Kadian Salmon
 * Date : Sep 23, 2021
 * Purpose : Main class for all operations relating to client
 */

class Client {
    private $db_connector;
    private $isLoggedin;//is the researcher logged in
    private $isActive;//is this researcher's account still active
    private $hasCurrentLocation;//


    //current details
    private $host_info = null;
    private $currentLat = null;
    private $currentLon = null;
    private $currentLocation = null;

    //researcher details
    private $userId = null;
    private $loginToken = null;
    private $email = null;
    private $user_ref_id = null;
    private $language_code = null;
    private $password = null;
    private $screenName = null;
    private $firstName = null;
    private $lastName = null;
    private $gender = null;

    private $occupation = null;
    private $education = null;
    private $marital_status = null;
    private $ethnicity = null;
    private $employment_status = null;
    private $employment_industry = null;


    private $locationCountry = null;
    private $locationCountryCode = null;
    private $currencyCode = null;
    private $locationState = null;
    private $locationCity = null;
    private $registrationDate = null;
    private $phoneNumber = null;
    private $locationAddress = null;
    private $date_of_birth = null;



    function __construct(Database $db_connector) {
        $this->db_connector = $db_connector;

        $this->host_info = new HostInfo($db_connector);

        $this->currentLocation = new LocationPoint(null,null);

    }


    public function get_db_connector() {
        return $this->db_connector;
    }

    public function isLoggedin() {
        return $this->isLoggedin;
    }

    public function isActive() {
        return $this->isActive;
    }

    public function get_userId() {
        return $this->userId;
    }

    public function get_loginToken() {
        return $this->loginToken;
    }

    public function get_email() {
        return $this->email;
    }

    public function getUserRefId()
    {
        return $this->user_ref_id;
    }

    public function get_encrytedPassword() {
        return $this->password;
    }

    public function get_screenName() {
        return $this->screenName;
    }

    public function get_firstName() {
        return $this->firstName;
    }

    public function get_lastName() {
        return $this->lastName;
    }

    public function get_gender() {
        return $this->gender;
    }

    public function get_locationCountry() {
        return $this->locationCountry;
    }

    public function getLanguageCode()
    {
        return $this->language_code;
    }


    public function get_locationState() {
        return $this->locationState;
    }

    public function get_locationCity() {
        return $this->locationCity;
    }

    public function get_registrationDate() {
        return $this->registrationDate;
    }

    public function get_phoneNumber() {
        return $this->phoneNumber;
    }

    public function getCurrentLocation(){
        return $this->currentLocation;
    }

    public function getLocationCountryCode()
    {
        return $this->locationCountryCode;
    }

    public function getLocationAddress()
    {
        return $this->locationAddress;
    }

    public function getDateOfBirth()
    {
        return $this->date_of_birth;
    }

    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }


    public function getOccupation()
    {
        return $this->occupation;
    }
    public function getEducation()
    {
        return $this->education;
    }
    public function getMaritalStatus()
    {
        return $this->marital_status;
    }
    public function getEthnicity()
    {
        return $this->ethnicity;
    }
    public function getEmploymentStatus()
    {
        return $this->employment_status;
    }
    public function getEmploymentIndustry()
    {
        return $this->employment_industry;
    }


    public function setEmploymentIndustry($employment_industry)
    {
        $this->employment_industry = $employment_industry;
    }
    public function setEthnicity($ethnicity)
    {
        $this->ethnicity = $ethnicity;
    }
    public function setEmploymentStatus($employment_status)
    {
        $this->employment_status = $employment_status;
    }
    public function setMaritalStatus($marital_status)
    {
        $this->marital_status = $marital_status;
    }
    public function setOccupation($occupation)
    {
        $this->occupation = $occupation;
    }
    public function setEducation($education)
    {
        $this->education = $education;
    }



    public function setLanguageCode($language_code)
    {
        $this->language_code = $language_code;
    }

    public function setCurrentLocation($lat,$lon){
        $currentLocation = new LocationPoint(null,null);

        if (!empty($lat) && !empty($lon)){
            $currentLocation = new LocationPoint($lat,$lon);
        }

        $this->currentLocation = $currentLocation;

    }

    public function set_db_connector($db_connector) {
        $this->db_connector = $db_connector;
    }

    public function set_isLoggedin($isLoggedin) {
        $this->isLoggedin = $isLoggedin;
    }

    public function set_isActive($isActive) {
        $this->isActive = $isActive;
    }

    public function set_userId($userId) {
        $this->userId = $userId;
    }

    public function set_loginToken($loginToken) {
        $this->loginToken = $loginToken;
    }

    public function set_email($email) {
        $this->email = $email;
    }

    public function setUserRefId($user_ref_id)
    {
        $this->user_ref_id = $user_ref_id;
    }

    public function set_encrytedPassword($password) {
        $this->password = $password;
    }

    public function set_screenName($screenName) {
        $this->screenName = $screenName;
    }

    public function set_firstName($firstName) {
        $this->firstName = $firstName;
    }

    public function set_lastName($lastName) {
        $this->lastName = $lastName;
    }

    public function set_gender($gender) {
        $this->gender = $gender;
    }

    public function set_locationCountry($locationCountry) {
        $this->locationCountry = $locationCountry;
    }

    public function set_locationState($locationState) {
        $this->locationState = $locationState;
    }

    public function set_locationCity($locationCity) {
        $this->locationCity = $locationCity;
    }

    public function set_registrationDate($registrationDate) {
        $this->registrationDate = $registrationDate;
    }

    public function set_phoneNumber($phoneNumber) {
        $this->phoneNumber = $phoneNumber;
    }

    public function setLocationCountryCode($locationCountryCode)
    {
        $this->locationCountryCode = $locationCountryCode;
    }

    public function setLocationAddress($locationAddress)
    {
        $this->locationAddress = $locationAddress;
    }

    public function setDateOfBirth($date_of_birth)
    {
        $this->date_of_birth = $date_of_birth;
    }

    public function setCurrencyCode($currencyCode)
    {
        $this->currencyCode = $currencyCode;
    }



    //todo : currency support to get rates from database table
    public function getCurrencyRate($currency = SYSTEM_CURRENCY){
        //This rate listing is relative to the SYSTEM_CURRENCY = "USD"

        $RATE = array();
        $RATE["USD"] = 1;
        $RATE["JMD"] = 140;
        $RATE["CLP"] = 730;

        if (!isset($RATE[$currency])){
            return $RATE[SYSTEM_CURRENCY];
        }
        else{
            return $RATE[$currency];
        }
    }

    //todo : currency support to convert funds to desired currency
    public function getConvertedFunds($usd_funds)
    {
        $converted_funds = 0;

        $currency = $this->currencyCode;
        if ($currency == null){
            $currency = SYSTEM_CURRENCY;
        }

        $rate = $this->getCurrencyRate($currency);

        $converted_funds = floatval($usd_funds * $rate);

        return $converted_funds;
    }

    public function signout($user_id,$login_token) {
        $user_type = USER_TYPE_RESEARCHER;
        $account_state = STATE_ACTIVE;
        $login_state = LOGIN_STATE_INVALID;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token'";
        $update_query = "update " . TABLE_LOGIN . " set login_state = '$login_state' where user_id = '$user_id' and token_id = '$login_token'";


        $result["status"] = STATUS_OK;

        if($this->db_connector != null){
            $login_result = $this->db_connector->query($login_check_query);
            if($login_result != null && $login_result->is_row_found()){
                //if we found the record
                $update_result = $this->db_connector->query($update_query);
                if($update_result != null && $update_result->is_row_affected()){
                    $result["status"] = STATUS_OK;
                    $this->isLoggedin = false;
                }

            }
        }

        return $result;
    }

    public function login($username,$password,$login_data_arr) {

        $provided_password = encryptPassword($password);
        $provided_username = strtolower($username);
        $user_type = USER_TYPE_CLIENT;
        $account_state = STATE_ACTIVE;
        $verified_by_admin = VERIFIED;
        $verified_email = VERIFIED;

        $login_data = null;
        if (!empty($login_data_arr)){
            $login_data_arr["ip_address"] = $this->host_info->getIp_address();
            $login_data = json_encode($login_data_arr);
        }
        else{
            $login_data_arr = array();
            $login_data_arr["ip_address"] = $this->host_info->getIp_address();
            $login_data = json_encode($login_data_arr);
        }

        $result = $this->getErrorStatus(ERROR_MSG_INVALID_CRED);

        if($this->db_connector != null){
            //$login_query = "select * from " . TABLE_USERS . " where lower(user_email) = '$provided_username' and user_password = '$provided_password' and user_type = '$user_type' and user_active = '$account_state' and user_is_approved = '$verified_by_admin' and user_email_verified = '$verified_email'";
            $login_query = "select * from " . TABLE_USERS . " where lower(user_email) = '$provided_username' and user_password = '$provided_password' and user_type = '$user_type' and user_active = '$account_state'";

            $login_result = $this->db_connector->query($login_query);
            if($login_result != null && $login_result->is_row_found()){
                $row_data = $login_result->fetch_array();

                if($row_data != null){
                    $actual_uname = $row_data["user_email"];
                    $actual_pass = $row_data["user_password"];

                    if(($actual_uname == $provided_username) && ($actual_pass == $provided_password)){
                        $login_token = generate_token();
                        $login_time = getCurrentTime();
                        $login_state = LOGIN_STATE_VALID;
                        $user_id = $row_data["user_id"];
                        $user_email_verified = $row_data["user_email_verified"];

                        $result = $this->getErrorStatus(ERROR_MSG_NOT_VERIFIED);
                        if ($user_email_verified == VERIFIED){
                            $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,login_data) values ('$login_token','$login_time','$login_state','$user_id','$login_data')";
                            $details_result = $this->db_connector->query($details_query);
                            if($details_result != null && $details_result->is_row_affected()){
                                //$this->isLoggedin = true;
                                $result = $this->getOKStatus();

                                $result["user_id"] = $row_data["user_id"];
                                $result["login_token"] = $login_token;

                                return $result;
                            }
                        }
                    }
                }
            }


        }

        return $result;

    }

    public function verifyLogin($user_id,$login_token) {
        $user_type = USER_TYPE_CLIENT;
        $account_state = STATE_ACTIVE;
        $login_state = LOGIN_STATE_VALID;
        $verified_by_admin = VERIFIED;
        $verified_email = VERIFIED;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token' and login_state = '$login_state'";
        //$user_check_query = "select * from " . TABLE_USERS . " where user_id = '$user_id' and user_type = '$user_type' and user_active = '$account_state' and user_is_approved = '$verified_by_admin' and user_email_verified = '$verified_email'";
        $user_check_query = "select * from " . TABLE_USERS . " where user_id = '$user_id' and user_type = '$user_type' and user_active = '$account_state'";

        $result = $this->getErrorStatus(ERROR_MSG_INVALID_TOKEN);

        if($this->db_connector != null){
            $login_result = $this->db_connector->query($login_check_query);
            if($login_result != null && $login_result->is_row_found()){
                $user_result = $this->db_connector->query($user_check_query);
                if($user_result != null && $user_result->is_row_found()){
                    $result = $this->getOKStatus();

                    $this->isLoggedin = true;
                    $this->userId = $user_id;
                    $this->loginToken = $login_token;
                }
                else{
                    $result = $this->getErrorStatus(ERROR_MSG_USER_DEACTIVATED);
                }

            }
        }

       return $result;

    }


    //todo - fix here to return all the appropriate data
    public function initializeClient($user_id,$login_token="") {
        //$this->host_info = new HostInfo($this->db_connector);//get all the host info... like [ip_address|country_name|country_code|area_code|currency]

        if($user_id != null){
            $this->userId = $user_id;
            //$this->userId = 1468; -- hugo
        }
        else{
            return false;
        }
        if($login_token != null){
            $this->loginToken = $login_token;
        }


        $user_check_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
        //$user_profile_check_query = "select * from " . TABLE_USER_PROFILE . " where userprofile_user_id = '$user_id'";

        if($this->db_connector != null){
            $user_result = $this->db_connector->query($user_check_query);
            //$user_profile_result = $this->db_connector->query($user_profile_check_query);
            if($user_result != null && $user_result->is_row_found()){
                //$row_profile = $user_profile_result->fetch_array();

                if($row = $user_result->fetch_array()){
                    $this->email = strtolower($row["user_email"]);
                    $this->password = $row["user_password"];
                    $this->screenName = strtolower($row["user_screen_name"]);
                    $this->firstName = strtolower($row["user_first_name"]);
                    $this->lastName = strtolower($row["user_last_name"]);

                    if ($row["user_sex"] == GENDER_MALE){
                        $this->gender = GENDER_MALE_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_FEMALE){
                        $this->gender = GENDER_FEMALE_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_NON_BINARY){
                        $this->gender = GENDER_NON_BINARY_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_NOT_TO_SAY){
                        $this->gender = GENDER_NOT_TO_SAY_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_OTHER){
                        $this->gender = GENDER_OTHER_STRING;
                    }


                    $this->registrationDate = $row["user_regdate"];
                    $this->locationState = $row["location_state"];
                    $this->locationCity = $row["location_city"];


                    $account_state = $row["user_active"];
                    $countryId = $row["user_country_id"];
                    $countryCode = $row["country_code"];
                    $phone_number = $row["phone_number"];
                    $location_address = $row["location_address"];
                    $date_of_birth = $row["date_of_birth"];
                    $user_ref_id = $row["user_ref_id"];
                    $language_code = $row["language_code"];

                    $this->user_ref_id = $user_ref_id;
                    $this->language_code = $language_code;


                    if($account_state == STATE_ACTIVE){
                        $this->isActive = true;
                    }


                    if($countryCode != null){
                        $this->locationCountryCode = $countryCode;
                    }
                    //else{
                        //if no country is recorded then get the user's current country based on ip
                        //$this->locationCountryCode = $ip_country_code;
                    //}

                    /*if($countryId != null){
                        $this->locationCountry = Country::getCountry($countryId, $this->db_connector);
                    }*/

                    $ip_country_code = $this->host_info->getCountry_code();
                    $ip_currency_code = $this->host_info->getCurrency();

                    //todo - STORE USER'S CURRENCY CODE AT SIGN UP based on their country
                    if ($ip_currency_code != null){
                        //get currency based on current country
                        $this->currencyCode = $ip_currency_code;
                    }
                    else{
                        $this->currencyCode = SYSTEM_CURRENCY;
                    }


                    if($phone_number != null){
                        $this->phoneNumber = $phone_number;
                    }

                    if($location_address != null){
                        $this->locationAddress = $location_address;
                    }
                    if($date_of_birth != null){
                        $this->date_of_birth = $date_of_birth;
                    }

                    /*if ($this->get_userId() == "1077"){
                        $this->host_info->setCountry_code("JM");
                    }*/

                    return true;

                }

            }
        }

        return false;
    }

    public function updateNotificationToken($notification_id){
        $user_id = $this->get_userId();
        $login_token = $this->get_loginToken();
        $notification_hash = md5($notification_id);

        $updated = false;

        $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id' and token_id = '$login_token' and notification_hash = '$notification_hash'";
        $sql_query_result = $this->db_connector->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_found()){
            $updated = true;
        }
        else{
            $sql_query_2 = "insert into " . TABLE_REALTIME_NOTIFICATION . " (token_id,notification_id,notification_hash,user_id) values ('$login_token','$notification_id','$notification_hash','$user_id')";
            $sql_query_result_2 = $this->db_connector->query($sql_query_2);
            if($sql_query_result_2 != null && $sql_query_result_2->is_row_affected()){
                $updated = true;
            }
        }

        return $updated;
    }

    public function removeNotificationToken($user_id,$login_token){

        //$user_id = $this->get_userId();
        //$login_token = $this->get_loginToken();

        $updated = false;

        $sql_query = "delete from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id' and token_id = '$login_token'";
        $sql_query_result = $this->db_connector->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_affected()){
            $updated = true;
        }

        return $updated;
    }

    public function removeAllNotificationToken(){
        $user_id = $this->get_userId();

        $updated = false;

        $sql_query = "delete from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id'";
        $sql_query_result = $this->db_connector->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_affected()){
            $updated = true;
        }

        return $updated;
    }


    //this is used to get the user's primary bank account data
    public function getPrimaryBankAccount($user_id = null) {


        $result = array();
        $result["is_valid"] = false;
        $result["account_id"] = null;
        $result["account_type"] = null;
        $result["version_code"] = null;
        $result["fname"] = null;
        $result["mname"] = null;
        $result["lname"] = null;
        $result["full_name"] = null;
        $result["email"] = null;
        $result["date_of_birth"] = null;
        $result["phone_number"] = null;
        $result["country_code"] = null;
        $result["location_state"] = null;
        $result["location_city"] = null;
        $result["location_address"] = null;
        $result["bank_name"] = null;
        $result["bank_address"] = null;
        $result["bank_account_number"] = null;
        $result["bank_account_type"] = null;
        $result["tax_id_number"] = null;


        if ($user_id == null){
            $user_id = $this->userId;
        }

        $account_type = ACCOUNT_TYPE_BANK_ACCOUNT;
        $deleted = 0;

        $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_type = '$account_type' and deleted = '$deleted' and user_id = '$user_id'";
        $account_result = $this->db_connector->query($account_query);

        if($account_result != null && $account_result->is_row_found()){

            if($row = $account_result->fetch_array()){


                $result["is_valid"] = true;
                $result["account_id"] = $row["account_id"];
                $result["account_type"] = $row["account_type"];
                $result["version_code"] = $row["version_code"];
                $result["fname"] = stringCase($row["fname"],STRING_CASE_CAP_FIRST);
                $result["mname"] = stringCase($row["mname"]);
                $result["lname"] = stringCase($row["lname"],STRING_CASE_CAP_FIRST);
                $result["full_name"] = $row["full_name"];
                $result["email"] = stringCase($row["email"]);
                $result["date_of_birth"] = $row["date_of_birth"];
                $result["phone_number"] = $row["phone_number"];
                $result["country_code"] = stringCase($row["country_code"],STRING_CASE_UPPER);
                $result["location_state"] = stringCase($row["location_state"],STRING_CASE_CAP_EACH);
                $result["location_city"] = stringCase($row["location_city"],STRING_CASE_CAP_EACH);
                $result["location_address"] = $row["location_address"];
                $result["bank_name"] = $row["bank_name"];
                $result["bank_address"] = $row["bank_address"];
                $result["bank_account_number"] = $row["bank_account_number"];
                $result["bank_account_type"] = $row["bank_account_type"];
                $result["tax_id_number"] = $row["tax_id_number"];

            }

        }

        return $result;
    }


    //returns the jobs from the given id that this researcher qualifies for
    //NOTE: this will be null is =>
    //1 - if user is already attached to one of these jobs
    //2 - if these jobs dont require more researchers
    //3 - if there are no jobs


    function getJobTags($job_id){
        $record_found = false;
        $index = 0;

        $data = array();
        $result = array();


        $tag_query = "select * from " . TABLE_JOB_TAGS . " where job_id = '$job_id'";
        $tag_result = $this->db_connector->query($tag_query);

        if ($tag_result != null && $tag_result->is_row_found()){
            while ($row = $tag_result->fetch_array()){
                $record_found = true;

                $tag_id = $row["tag_id"];
                $tag_label = $row["tag_label"];
                $tag_data = $row["tag_data"];

                $decoded = json_decode($tag_data,true);

                $data[$index]["unique_id"] = $tag_id;
                $data[$index]["tag_label"] = $tag_label;
                $data[$index]["tag_data"] = $decoded;

                $index++;
            }

        }

        if ($record_found){
            $result = $data;
        }

        return $result;
    }
    private function getTagRadius($task_id,$job_id){
        $record_found = false;
        $index = 0;

        $effort = 0;

        //$result = array();

        //$result["status"] = "NO_DATA";


        $tag_query = "select * from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and tag_label = 'tag_radius' and job_id = '$job_id'";
        $tag_result = $this->db_connector->query($tag_query);

        if ($tag_result != null && $tag_result->is_row_found()){
            if ($row = $tag_result->fetch_array()){
                $tag_data = $row["tag_data"];
                $decoded = json_decode($tag_data,true);

                //$result["status"] = "OK";
                //$result["level"] = $decoded["level"];
                $effort = $decoded["value"];

            }

        }

        return $effort;
    }
    private function getTagEffort($task_id){
        $record_found = false;
        $index = 0;

        $effort = 0;

        $result = array();

        $result["status"] = "NO_DATA";


        $tag_query = "select * from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and tag_label = 'tag_effort'";
        $tag_result = $this->db_connector->query($tag_query);

        if ($tag_result != null && $tag_result->is_row_found()){
            if ($row = $tag_result->fetch_array()){
                $tag_data = $row["tag_data"];
                $decoded = json_decode($tag_data,true);

                //$result["status"] = "OK";
                //$result["level"] = $decoded["level"];
                $effort = $decoded["level"];

            }

        }

        return $effort;
    }
    private function ___returnAvailableJobs___($task_id) {
        //this gets all the jobs tied to this task

        $result = null;
        if($this->db_connector != null){
            //available = survey ready, admin approved, not finished, not cancelled
            $sql = "select * from " . TABLE_TASKS . " where task_id = '$task_id' and survey_ready = " . SURVEY_INSTRUMENT_READY . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ")";
            $task_result = $this->db_connector->query($sql);

            if($task_result == null){
                return $result;
            }

            $task_data = $task_result->fetch_array();

            if($task_data != null && $task_data["task_location_count"] > 0){

                $check_criteria = false;//should we check if this researcher is linked to the task

                if($check_criteria){
                    //do not consider cancelled as a linked job
                    $linkedJobs = $this->linkedJobs($task_id,false);

                    if($linkedJobs == null){
                        $check_linked = true;
                    }
                    else{
                        $check_linked = false;
                    }

                }
                else{
                    $check_linked = true;//bypass check
                }


                //T O D O - RE-ENABLE IP LOCATION CRITERIA SELECTION
                if($check_linked){//if this researcher is not already linked to this task then process to see if it is available
                    $country_code = $this->host_info->getCountry_code();
                    //$country_code = "JM";
                    //task is available to be check by the researcher
                    $job_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id' and country_code = '$country_code' and researcher_required > researcher_count and survey_total > 0";
                    $job_result = $this->db_connector->query($job_query);
                    $index = 0;

                    if($job_result == null){
                        return $result;
                    }

                    while($row = $job_result->fetch_array()){
                        /**
                         * // TODO :=> DO ADDITIONAL CRITERIA CHECK HERE
                         */

                        $result[$index]["job_id"] = $row["job_id"];
                        $result[$index]["task_id"] = $task_id;
                        $result[$index]["user_id"] = $row["user_id"];
                        $result[$index]["location_address"] = $row["address"];
                        $result[$index]["location_country"] = $row["country"];
                        $result[$index]["location_state"] = $row["state"];
                        $result[$index]["location_lat"] = $row["location_lat"];
                        $result[$index]["location_lon"] = $row["location_lon"];
                        $result[$index]["researcher_required"] = $row["researcher_required"];
                        $result[$index]["researcher_count"] = $row["researcher_count"];
                        $result[$index]["survey_url"] = $task_data["survey_url"];
                        $result[$index]["project_description"] = $task_data["task_instructions"];
                        $result[$index]["project_title"] = $task_data["task_topic"];
                        $result[$index]["customer"] = "";//$task_data["task_topic"];//lets ignor this for now

                        $cpq = $row["cpq"];//cost per questionnaire
                        $questionnaire_total = $row["survey_total"];
                        $questionnaire_assigned = $row["survey_assigned"];
                        $assignable = 0;//the number of questionnaires the reseacher viewing these results, could be assigned

                        $remaining = $questionnaire_total - $questionnaire_assigned;

                        //TODO fix here
                        //$question_set = $questionnaire_total / RESEARCHER_PER_LOC;
                        $question_set = $questionnaire_total / $row["researcher_required"];

                        if($remaining > $question_set){
                            $assignable = $question_set;//lets cap it at the default
                        }
                        elseif($remaining <= $question_set){
                            $assignable = $remaining;//lets show the 'whats left'
                        }

                        $price = $assignable * $cpq;

                        $result[$index]["price"] = $price;
                        $result[$index]["questionnaire_count"] = $assignable;

                        $index++;
                    }


                }

            }

        }

        return $result;
    }



    public function getErrorStatus($error_msg){
        $result = array();
        $error = array();
        $error["name"] = ERROR_NAME_OP_FAILED;
        $error["message"] = $error_msg;
        $result["status"] = STATUS_ERROR;
        $result["error"] = $error;

        return $result;
    }
    public function getOKStatus(){
        $result = array();
        $result["status"] = STATUS_OK;

        return $result;
    }

    //gets a list of jobs(of task_id) the researcher is linked to whether completed of otherwise
    //linked = matched task & user id for survey_response
    //returns Array if linked or null if not
    public function linkedJobs($task_id, $include_cancelled = true){

        if($include_cancelled){
            //check all records {cancelled,in progress,completed}
            $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and user_id = '$this->userId'";

        }
        else{
            //if this is falsed == then do not consider 'SURVEY_STATE_CANCELLED' as linked
            //return all records that arent cancelled
            //if records that arent cancelled are found.. then this researcher is linked
            //check records {finished,completed}
            $survey_state = SURVEY_STATE_CANCELLED;
            $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and user_id = '$this->userId' and survey_state not in ($survey_state)";

        }

        //$response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and user_id = '$this->userId'";
        $response_result = $this->db_connector->query($response_query);
        $index = 0;
        $results = null;

        if($response_result != null && $response_result->is_row_found()){
            while($row = $response_result->fetch_array()){
                $results[$index]["response_id"] = $row["response_id"];
                //$results[$index]["update_time"] = $row["update_time"];
                $results[$index]["job_id"] = $row["job_id"];
                $results[$index]["task_id"] = $row["task_id"];
                $results[$index]["user_id"] = $row["user_id"];//researcher
                $results[$index]["survey_id"] = $row["survey_id"];
                $results[$index]["survey_token"] = $row["survey_token"];
                $results[$index]["survey_count"] = $row["survey_count"];
                $results[$index]["survey_completed"] = $row["survey_completed"];
                $results[$index]["survey_state"] = $row["survey_state"];
                $results[$index]["survey_start"] = $row["survey_start"];
                $results[$index]["survey_end"] = $row["survey_end"];
                $results[$index]["price"] = $row["price"];
                $results[$index]["payment_date"] = $row["payment_date"];
                $results[$index]["verified"] = $row["verified"];

                $index++;
            }

        }

        return $results;
    }
    //get jobs based on where clause; return database result
    public function getJobsWhere($where_clause){
        $result = null;
        $job_query = "select * from " . TABLE_JOBS . " where $where_clause";
        $job_result = $this->db_connector->query($job_query);

        if($job_result != null && $job_result->is_row_found()){

            return $job_result;

        }

        return null;
    }
    //returns row
    public function getTaskRaw($task_id){
        $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
        $task_result = $this->db_connector->query($task_query);

        if($task_result != null && $task_result->is_row_found()){
            $row = $task_result->fetch_array();

            if($row != null){
                return $row;
            }
        }

        return null;
    }
    public function getResponseRaw($response_id){
        $response_query = "select * from " . TABLE_RESPONSE . " where job_id = '$response_id'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){
            $row = $response_result->fetch_array();
            if($row != null){
                return $row;
            }

        }

        return null;
    }
    public function getJobRaw($job_id){
        $job_query = "select * from " . TABLE_JOBS . " where job_id = '$job_id'";
        $job_result = $this->db_connector->query($job_query);

        if($job_result != null && $job_result->is_row_found()){
            $row = $job_result->fetch_array();
            if($row != null){
                return $row;
            }

        }

        return null;
    }

}