<?php
header("Access-Control-Allow-Origin: *"); //enable resource sharing(allows this resource to be shared with "all[*]" requesting clients
header('Content-Type: application/json');
/**
 * @Author : Kadian Salmon
 * Date : Sep 23, 2021
 * Purpose : process all api request for Queritel Console Application
 * @link : https://api.queritel.com/api/web/queritel/console/v1/api.php
 */


//------------------------------------------
define("QUESTION_SET", 10);//respondents per location
define("RESEARCHER_PER_LOC", 4);//researcher per location


define("MAIN_DB_USERNAME", "initia19_paperweight");
define("MAIN_DB_PASSWORD", "sqnktJrG-J4k");
define("MAIN_DB_NAME", "initia19_paperweight");


define("INSIGHT_DB_USERNAME", "initia19_lime880");
define("INSIGHT_DB_PASSWORD", "[2ST4)V2p6");
define("INSIGHT_DB_NAME", "initia19_lime880");
define("INSIGHT_DOMAIN", "insight.queritel.com");


define("PASSWORD_SALT","ewoiruqojfklajreajflajoer");

//status value
define("STATUS_OK","OK");
define("STATUS_ERROR","ERROR");
/*{
    "status": "ERROR",
    "error": {
        "name": "opFailed", //([ERROR NAME CONSTANTS])
        "message": "INV_TKN" | "USR_SPND" | "UNK_ERR" //([ERROR MESSAGE CONSTANTS])
    }
}*/

define("STATUS_SIGNUP_FAILED", "SIGNUP_FAILED");
define("STATUS_LOGIN_FAILED","LOGIN_FAILED");
define("STATUS_ACCOUNT_DEACTIVATED", "ACCOUNT_DEACTIVATED");
define("STATUS_OPERATION_FAILED", "OPERATION_FAILED");
define("STATUS_NO_JOBS", "NO_JOBS");


//ERROR NAME CONSTANTS
define("ERROR_NAME_OP_FAILED","opFailed");


//ERROR MESSAGE CONSTANTS
define("ERROR_MSG_INVALID_CRED","INV_CR"); //("The Credentials provided are invalid")
define("ERROR_MSG_INVALID_LOGIN","INV_LGN");//("The user is not Logged in")
define("ERROR_MSG_INVALID_TOKEN","INV_TKN");//("The Login token is invalid") {re-entering the password is needed}
define("ERROR_MSG_USER_SUSPENDED","USR_SPND");//("The account has been suspended")
define("ERROR_MSG_USER_DEACTIVATED","USR_DEAC");//("The account has been deactivated")
define("ERROR_MSG_USER_UNKNOWN","UNK_ERR");//("An unknown error was encountered")
define("ERROR_MSG_USER_ACC_DUPLICATE","ACC_DUPLICATE");//("The user already exist")
define("ERROR_MSG_INVALID_TAX_ID","INV_TAX_ID");//("The tax id provided when setting up the bank account was invalid")



//unique prefix (used to generate unique IDs)
define("UNIQUE_NETWORK","net-"); //unique data collection network
define("UNIQUE_TEAM","team-"); //unique team
define("UNIQUE_NOTIFICATION","note-"); //unique notification id (one way msg)
define("UNIQUE_MSG","msg-"); //unique message
define("UNIQUE_PAYMENT","pay-");//unique payment instance
define("UNIQUE_TRANSACTION","trans-"); //unique transaction instance
define("UNIQUE_ACCOUNT","acc-");//unique account instance
define("UNIQUE_ACTIVITY","aty-");//unique user activity instance
define("UNIQUE_PENALTY","pty-");//unique cancel quest/other penalty
define("UNIQUE_RELATIONSHIP","rel-");//unique relationship instance
define("UNIQUE_FILE","file-");//unique file
define("UNIQUE_INVITATION","ivn-");//unique invitation instance
define("UNIQUE_PULSE","pul-");//unique pulse instance
define("UNIQUE_PULSE_QUESTION","que-");//unique pulse instance
//define("UNIQUE_SUBMISSION","sub-");



//survey state
define("SURVEY_STATE_PROGRESS", 1);
define("SURVEY_STATE_COMPLETED",2);
define("SURVEY_STATE_CANCELLED",3);



//survey instrument state
define("SURVEY_INSTRUMENT_READY", 1);
define("SURVEY_INSTRUMENT_NOT_READY", 0);



//admin verification
define("VERIFIED", 1);
define("UNVERIFIED", 0);


//login state
define("LOGIN_STATE_VALID", 1);
define("LOGIN_STATE_INVALID", 0);


//active state / network relationship state
define("STATE_ACTIVE", 1);
define("STATE_INACTIVE", 0);


//database tables
define("TABLE_USER_PROFILE", "tbl_user_profile");
define("TABLE_TASKS", "tbl_tasks");
define("TABLE_COUNTRY", "tbl_countries");
define("TABLE_LOGIN", "mobile_login");
define("TABLE_JOBS", "job_instance");
define("TABLE_JOB_TAGS", "job_tag");
define("TABLE_RESPONSE", "survey_response");
define("TABLE_NETWORK", "research_network");
define("TABLE_NETWORK_RELATIONSHIP", "network_relationship");
define("TABLE_SUBMISSIONS", "submission_response");
define("TABLE_MESSAGE", "message");
define("TABLE_PAYOUT_ACCOUNT", "payout_account");
define("TABLE_REALTIME_NOTIFICATION", "realtime_notification");


//payout account type
define("ACCOUNT_TYPE_AMAZON_GIFT_CARD", "type_amazon_card");
define("ACCOUNT_TYPE_DING_MOBILE_TOP_UP", "type_ding");
//define("ACCOUNT_TYPE_REWARDS_GENIUS", "type_rewards_genius");
define("ACCOUNT_TYPE_PAYONEER", "type_payoneer");
define("ACCOUNT_TYPE_PAYPAL", "type_paypal");
define("ACCOUNT_TYPE_BANK_ACCOUNT", "type_bank");



//payout account function (the purpose of the specific account type)
define("ACCOUNT_FUNCTION_GIFT_CARD", "function_gift_card"); //("Gift Card")
define("ACCOUNT_FUNCTION_MOBILE", "function_mobile"); //("Mobile Recharge")
define("ACCOUNT_FUNCTION_CASH_OUT", "function_cash_out"); //("Monetary Cash Out")



//task status
define("TASK_STATUS_PENDING",   0);
define("TASK_STATUS_ACTIVE",    1);
define("TASK_STATUS_AWARDED",   2);
define("TASK_STATUS_COMPLETED", 3);
define("TASK_STATUS_CANCELLED", 4);
define("TASK_STATUS_DRAFT",     5);
define("TASK_STATUS_DISABLED",  6);



//task activity type
define("ACTIVITY_TYPE_SENTIMENT", "activity_sentiment");
define("ACTIVITY_TYPE_DISCOVERY", "activity_discovery");
define("ACTIVITY_TYPE_RETAIL", "activity_retail");
define("ACTIVITY_TYPE_MONITOR", "activity_monitor");
define("ACTIVITY_TYPE_INSPECTION", "activity_inspection");
define("ACTIVITY_TYPE_VOX", "activity_vox");
define("ACTIVITY_TYPE_POLL", "activity_poll");
//----------------
define("ACTIVITY_TYPE_SENTIMENT_TXT", "Sentiment Survey");
define("ACTIVITY_TYPE_DISCOVERY_TXT", "Location Discovery");
define("ACTIVITY_TYPE_RETAIL_TXT", "Retail Audit");
define("ACTIVITY_TYPE_MONITOR_TXT", "Price Monitoring");
define("ACTIVITY_TYPE_INSPECTION_TXT", "Inspection");



//task activity category
define("ACTIVITY_CATEGORY_LOCATE", "category_locate");
define("ACTIVITY_CATEGORY_EXPLORE", "category_explore");
define("ACTIVITY_CATEGORY_DISCOVER", "category_discover");
define("ACTIVITY_CATEGORY_VOX", "category_vox");
define("ACTIVITY_CATEGORY_PULSE", "category_pulse");

//-----------------
define("ACTIVITY_CATEGORY_PULSE_TXT", "Pulse");
define("ACTIVITY_CATEGORY_LOCATE_TXT", "Locate");
define("ACTIVITY_CATEGORY_EXPLORE_TXT", "Explore");
define("ACTIVITY_CATEGORY_DISCOVER_TXT", "Discover");



//user presence activity (the activity state that can be logged)
define("USER_ACTIVITY_ACCEPT_QUEST", "check_available");//the user queried available quest

//network role
define("NETWORK_ROLE_COMMANDER", "net_commander");
define("NETWORK_ROLE_MANAGER", "net_manager");
define("NETWORK_ROLE_COLLECTOR", "net_collector");

//network position
define("NETWORK_POSITION_PRIVATE", 0); //collectors cannot be used by other networks
define("NETWORK_POSITION_OFFICIAL", 1); //collectors can be used by other networks
define("NETWORK_POSITION_DEFAULT", 2); //this is the primary official network (all user registered without a specific network)

//user type
define("USER_TYPE_RESEARCHER", 1);
define("USER_TYPE_CLIENT", 0);

//gender
define("GENDER_FEMALE", 0);
define("GENDER_MALE", 1);
define("GENDER_NON_BINARY", 2);
define("GENDER_NOT_TO_SAY", 3);
define("GENDER_FEMALE_STRING", "female");
define("GENDER_MALE_STRING", "male");
define("GENDER_NON_BINARY_STRING", "non_binary");
define("GENDER_NOT_TO_SAY_STRING", "prefer_not_to_say");



//API KEY | AND CONSTANTS
define("SERVER_MAP_KEY", "AIzaSyCAbro3HYflhyhj9Z55xCMSZDBLABLABnM");
define("FIREBASE_SERVER_KEY", "AIzaSyD8Xf2XrVxrtq0sngAJrRULYniemVn8MJM");
define("FIREBASE_SENDER_ID", "114414183492");

define("PUSH_NOTIFICATION_TOPIC_NEW_QUEST", "/topics/new_quest");
define("PUSH_NOTIFICATION_TOPIC_BROADCAST", "/topics/new_broadcast");
define("PUSH_NOTIFICATION_TOPIC_MESSAGE", "/topics/new_message");

define("PUSH_NOTIFICATION_STATUS_NEW_QUEST", "new_quest");
define("PUSH_NOTIFICATION_STATUS_BROADCAST", "new_broadcast");
define("PUSH_NOTIFICATION_STATUS_MESSAGE", "new_message");


//define("NEW_REQUEST_TOPIC", "/topics/new_request");
//define("NEW_LOCATION_TOPIC", "/topics/location_changed");
//define("NEW_DRIVER_TOPIC", "/topics/driver_added");

//API KEY - PAYOUTS
define("DING_MOBILE_RECHARGE_KEY", "ApyJWyuifmb6YMuJhu7wAW");
define("AMAZON_GIFT_INCENTIVE_KEY", "AKIAWWFS6UKLHJAGJY55");




//--------------------------------------------------------


include("../../../../includes/headers/classes-v1.php");//has all the classes needed for queritel back-end
include("../../../../includes/headers/miscellaneous-v1.php");//additional functions
include("../../../../includes/headers/strings.php");//has all the constants needed


/**
 * @Title Official Mobile Application Version Information
 * @Obj VERSION_NAME : This the version string name is is only used for labeling
 * @Obj VERSION_CODE : This is the actual version code used to maintain app version
 * @Obj VERSION_COMMENT : This is an optional string to be used in messaging
 * @Obj VERSION_PRIORITY : (0 -> This update is not priority and can be ignored by the user | 1 -> This update cannot be ignored)
 * @Usage : verifyLogin and processed by SplashScreen on the mobile App
 */
define("MOBILE_AGENT_ANDROID", "android");
define("MOBILE_AGENT_IOS", "ios");
define("MOBILE_VERSION_NAME", "version_name");
define("MOBILE_VERSION_CODE", "version_code");
define("MOBILE_VERSION_COMMENT", "version_comment");
define("MOBILE_VERSION_PRIORITY", "version_priority");

define("ANDROID_VERSION_NAME", "1.4.1.8-18");
define("ANDROID_VERSION_CODE", 31);

//define("ANDROID_VERSION_NAME", "1.4.1.8-17");
//define("ANDROID_VERSION_CODE", 30);

//define("ANDROID_VERSION_NAME", "1.4.1.8-16");
//define("ANDROID_VERSION_CODE", 29);



define("ANDROID_VERSION_COMMENT", ".");
define("ANDROID_VERSION_PRIORITY", 1);

define("IOS_VERSION_NAME", "1.0");
define("IOS_VERSION_CODE", 1);
define("IOS_VERSION_COMMENT", ".");
define("IOS_VERSION_PRIORITY", 1);

//API ACTIONS
define("ACTION_LOG_IN", "log_in");
define("ACTION_SIGN_UP", "sign_up");
define("ACTION_SIGN_OUT", "sign_out");
define("ACTION_GET_AVAILABLE_JOBS", "available_jobs");
define("ACTION_GET_ACTIVE_JOBS", "active_jobs");
define("ACTION_GET_COMPLETED_JOBS", "completed_jobs");
define("ACTION_ACCEPT_JOB", "accept_job");
define("ACTION_CANCEL_JOB", "cancel_job");
define("ACTION_GET_JOB_DETAIL", "get_job_detail");

define("ACTION_SUBMISSION_START", "submission_start");
define("ACTION_SUBMISSION_COMPLETE", "submission_complete");
define("ACTION_SEND_NOTIFICATION_ID", "send_notification_id");
define("ACTION_AUTHENTICATE_USER", "authenticate_user");
define("ACTION_GET_USER_DATA", "get_user_data");
define("ACTION_CHANGE_PASSWORD", "change_password");
//new actions
//define("", "");
define("ACTION_GET_WALLET_DATA", "get_wallet_data");
define("ACTION_SEND_DIRECT_MESSAGE", "send_direct_message");
define("ACTION_GET_DIRECT_MESSAGE_THREAD", "get_direct_message_thread");
define("ACTION_GET_DIRECT_MESSAGE_ITEM", "get_direct_message_item");
define("ACTION_GET_MESSAGE_LIST", "get_message_list");

define("ACTION_ADD_PRIMARY_ACCOUNT", "add_primary_bank_account");
define("ACTION_UPDATE_PRIMARY_ACCOUNT", "update_primary_bank_account");
define("ACTION_GET_PRIMARY_ACCOUNT", "get_primary_bank_account");

//LOCATION BASED VARIABLES
define("DEFAULT_LANGUAGE_CODE","en");
define("LOCATION_GREEN_ZONE", 16000); //16 km -> Users must be within the GREEN_ZONE in order to accept quest
define("SYSTEM_CURRENCY", "USD"); //The base currency used by the system
define("COUNTRY_JAMAICA", "JM"); //Country code for jamaica
define("COUNTRY_CHILE", "CL"); //Country code for chile


define("DASHBOARD_DB_NAME", "initia19_ansplex"); //Dashboard
define("DASHBOARD_DB_USERNAME", "initia19_ansplex");
define("DASHBOARD_DB_PASSWORD", "QueritelMgmt2019!");

define("QUERITEL_DB_NAME", "initia19_paperweight"); //Queritel Main
define("QUERITEL_DB_USERNAME", "initia19");
define("QUERITEL_DB_PASSWORD", "QueritelMgmt2019!");

define("TABLE_USERS", "tbl_users");
define("TABLE_LIVE_SURVEY", "dash_live_survey");
define("TABLE_CLIENT_DASHBOARD", "dash_client_dashboard");



$paperweight = new Database(MAIN_DB_USERNAME,MAIN_DB_PASSWORD,MAIN_DB_NAME);
$dash_database = new Database(DASHBOARD_DB_USERNAME,DASHBOARD_DB_PASSWORD,DASHBOARD_DB_NAME);

//profile_survey_token
$action = $_GET["action"];
if ($action == "demo")
{

    //https://api.queritel.com/api/mobile/queritel/insight/workservice/api.php?action=demo&param_json={%22user_id%22:823,%22lat%22:%2277.00%22,%22lng%22:%2213.00%22}

    $param_json = $_GET["param_json"];
    $data = json_decode($param_json, true);

    //329
    $user_id =      text_clean($data["user_id"]);
    //$lat =          text_clean($data["lat"]);
    //$lng =          text_clean($data["lng"]);
    //$response_id =  text_clean($data["response_id"]);

    //echo "This is demo <br>";
    //echo createEmailInvitationBody("google.com","Kadan Salmon");

    //echo getDefaultNetwork($paperweight);
    //echo json_encode(getOfficialNetworks($paperweight));

    /*$letters = array("a","b","c","d");

    foreach ($letters as $let){
        echo $let . "<br>";
    }*/

    //echo json_encode(getNetworkRelationship(125, $paperweight));
    //echo json_encode(isFromOfficialNetwork(329, $paperweight));
    //echo json_encode(isFromOfficialNetwork(121, $paperweight));
    //echo json_encode(isFromOfficialNetwork(377, $paperweight));

    //$client = new HostInfo();


    //echo json_encode($client->getCountry_flag());

    $lat = 17.9973836;
    $lng = -76.7896984;

    //$user_id = 823;

    $client = new Client($paperweight);
    $client->initializeClient($user_id);

    //$client->setCurrentLocation($lat,$lng);

    //$result = $client->getCurrentLocation();

    //$result = $client->startSubmission($response_id);
    //$result = $client->completeSubmission($response_id,);

    $task_id = 297;
    $passed_network_id = getQuestCreatorNetwork($task_id,$paperweight);

    $result = array();
    $data = array();
    $message_thread = array();


    /*

    $message_id = "pywxqjo-7175664-RRTWUNB";
    $recipient_id = 0;
    $recipient_network_id = "nid_jsy827459OFksye";
    $sender_id = 329;
    $sender_network_id = null;
    $timestamp = getCurrentTime();
    $task_id = 289;
    $msg_body = "this is my message body";

    $data[$index]["message_id"] = $message_id;
    $data[$index]["recipient_id"] = intval($recipient_id);
    $data[$index]["recipient_network"] = $recipient_network_id;
    $data[$index]["sender_id"] = intval($sender_id);
    $data[$index]["sender_network"] = $sender_network_id;
    $data[$index]["task_id"] = intval($task_id);
    $data[$index]["timestamp"] = $timestamp;
    $data[$index]["body"] = $msg_body;

    $message_id = "jfhyfgr-8476395-HDKDJGT";
    $recipient_id = 329;
    $recipient_network_id = null;
    $sender_id = 0;
    $sender_network_id = "nid_jsy827459OFksye";
    $timestamp = "2021-03-11 08:14:58";
    $task_id = 289;
    $msg_body = "this is my message body sent by the company";

    $index = 1;

    $data[$index]["message_id"] = $message_id;
    $data[$index]["recipient_id"] = intval($recipient_id);
    $data[$index]["recipient_network"] = $recipient_network_id;
    $data[$index]["sender_id"] = intval($sender_id);
    $data[$index]["sender_network"] = $sender_network_id;
    $data[$index]["task_id"] = intval($task_id);
    $data[$index]["timestamp"] = $timestamp;
    $data[$index]["body"] = $msg_body;

    $data[$index]["body"] = "Hello kadian";
    */


    $result["status"] = STATUS_OK;
    $result["message_thread"] = array();

    //if sender is not null (check if user is sender)


    $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_id = '$user_id' or recipient_id = '$user_id')) and task_id = '$task_id'";
    $msg_result = $paperweight->query($msg_query);

    if($msg_result != null && $msg_result->is_row_found()){

        while($row = $msg_result->fetch_array()){

            $message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);


            $data["message_id"] = $message_id;
            $data["recipient_id"] = intval($recipient_id);
            $data["recipient_network"] = $recipient_network_id;
            $data["sender_id"] = intval($sender_id);
            $data["sender_network"] = $sender_network_id;
            $data["task_id"] = intval($task_id);
            $data["timestamp"] = $timestamp;
            $data["body"] = ($msg_body);

            $message_thread[] = $data;

        }

        $result["status"] = STATUS_OK;
        $result["message_thread"] = $message_thread;

    }
    //$result = $client->startSubmission(79446052);
    //$result = $client->completeSubmission(79446052,30742304);
    //$result = $client->completeQuestionnaire(79446052);

    //$result = new LocationPoint(null,null);

    /*if (!$result->isEmpty()){
        echo "Location was found";
    }
    else{
        echo "Location was not found";
    }*/

    //echo $result->isEmpty();
    //echo $result->isEmpty();

    //$paperweight->getConnector()->set_charset("utf8");

    echo "Current character set is: " . $paperweight->getConnector()->character_set_name();

    //echo json_export($result);
    //echo json_encode($result);

}

if (isset($_REQUEST["action"])){
    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];

    //https://www.soriana.com/dw/image/v2/BGBD_PRD/on/demandware.static/-/Sites-soriana-grocery-master-catalog/default/dwb0c713b2/images/product/7500093752228-A.jpg?sw=473&sh=473&sm=fit
    //https://www.soriana.com/dw/image/v2/BGBD_PRD/on/demandware.static/-/Sites-soriana-grocery-master-catalog/default/dwb0c713b2/images/product/7500093752228-A.jpg

    if ($action == "extra"){
        $extra = $_REQUEST["extra"];
        //downloadImage($extra,"img_normal_walmart.jpg");

        //echo "Link : " . $extra;
        //echo "Session Key : " . get_session_key();

        $session_key = get_session_key();



        $result["time"] = getCurrentTime();
        $result["exp"] = makeExpiryTime(60 * 60 * 24); //1 hour


        //echo $session_key;
        echo get_dashboard_lnk(2);
        //echo get_question_lnk(63);
    }

    //This file contains all the functions for the web console application
    //it will be used by the client

    //todo - 99% - testing
    if ($action == "get_client_list"){
        $data = json_decode($param_json, true);

        //$user_id = text_clean($data["user_id"]);
        //$login_token = text_clean($data["login_token"]);
        $search_id = text_clean($data["search_id"]);

        $result = getOKStatus();

        $user_type = USER_TYPE_CLIENT;

        $client_list = array();

        if (!empty($search_id)){
            $pending_query = "select * from " . TABLE_USERS . " where user_type = '$user_type' and (user_first_name like '%$search_id%' or user_last_name like '%$search_id%')";
        }
        else{
            $pending_query = "select * from " . TABLE_USERS . " where user_type = '$user_type'";
        }

        $pending_result = $paperweight->query($pending_query);

        if($pending_result != null && $pending_result->is_row_found()){
            while($row = $pending_result->fetch_array()){

                $client_id = $row["user_id"];
                $client_name = $row["user_first_name"] . " " . $row["user_last_name"];
                $client_email = $row["user_email"];


                $client_data = array();
                $client_data["client_id"] = $client_id;
                $client_data["client_name"] = $client_name . " - $client_email";
                $client_data["client_email"] = $client_email;

                $client_list[] = $client_data;

            }
        }


        /*$res = '{
          "status": "OK",
          "client_list": [
            {
              "client_id": "125",
              "client_name": "Todd Rodgers"
            },
            {
              "client_id": "346",
              "client_name": "Zendar Doblin"
            },
            {
              "client_id": "465",
              "client_name": "Feliz Robson"
            }
          ]
        }
        ';*/

        $result["client_list"] = $client_list;


        //echo $res;
        echo json_export($result);

    }

    //todo - 99% - testing
    if ($action == "get_survey_list"){
        $data = json_decode($param_json, true);

        //$user_id = text_clean($data["user_id"]);
        //$login_token = text_clean($data["login_token"]);
        $login_data = $data["login_data"];

        $result = getOKStatus();


        $all_surveys = get_all_survey(); //these are all the survey directly from insights
        $enabled_survey = get_enabled_survey_map($dash_database); //get all the surveys that are synced
        //$survey_to_cancel = 0; //these are live_survey entries that are no longer public (no longer live on insights)


        $survey_list = array();

        foreach ($all_surveys as $survey) {

            $survey_id = $survey["survey_id"];

            if (isset($enabled_survey[$survey_id])){
                $survey["is_enabled"] = $enabled_survey[$survey_id]["is_enabled"];
                $survey["interval_in_seconds"] = $enabled_survey[$survey_id]["interval_in_seconds"];
                $survey["last_update"] = $enabled_survey[$survey_id]["last_update"];
                $survey["submission_count"] = $enabled_survey[$survey_id]["submission_count"];
            }

            $survey_list[] = $survey;

        }

        $result = getOKStatus();
        $result["survey_list"] = $survey_list;

        //echo json_encode($all_surveys);
        //echo json_encode($enabled_survey);
        //echo json_encode($survey_list);

        /*[
          {
            "sid": "356795",
            "surveyls_title": "Social Media Survey",
            "startdate": null,
            "expires": null,
            "active": "Y"
          },
          {
            "sid": "738718",
            "surveyls_title": "Cornersave Campaign",
            "startdate": null,
            "expires": null,
            "active": "Y"
          }
        ]*/

        /*$res = '{
          "status": "OK",
          "survey_list": [
            {
              "survey_id": "FJ89579G",
              "survey_name": "All About Pets",
              "is_enabled": true,
              "submission_count": 330,
              "last_update": "2021-11-12 11:34:52",
              "interval_in_seconds": 4
            },
            {
              "survey_id": "HJ64537K",
              "survey_name": "Sweet Treats",
              "is_enabled": false,
              "submission_count": 650,
              "last_update": "2021-11-12 11:34:52",
              "interval_in_seconds": 300
            }
          ]
        }
        ';*/

        //echo $res;
        echo json_export($result);

    }

    //todo - 99% - testing
    if ($action == "add_dashboard_access"){
        $data = json_decode($param_json, true);

        //{"client_id":"1","dashboard_code":"5","dashboard_name":"123"}
        $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

        //$user_id = text_clean($data["user_id"]);
        //$login_token = text_clean($data["login_token"]);
        $client_id = text_clean($data["client_id"]);
        $dashboard_code = text_clean($data["dashboard_code"]);
        $dashboard_name = text_clean($data["dashboard_name"]);

        $client = query_user($client_id, $paperweight);

        $add_sub_net = get_insert_query(TABLE_CLIENT_DASHBOARD,[
            "creation_time" => getCurrentTime(),
            "client_id" => $client_id,
            "client_name" => $client["fname"] . " " . $client["lname"],
            "dashboard_name" => $dashboard_name,
            "dashboard_code" => $dashboard_code,
            "secret_key" => null
        ]);
        $add_sub_net_result = $dash_database->query($add_sub_net);
        if($add_sub_net_result != null && $add_sub_net_result->is_row_affected()){
            $result = getOKStatus();
        }


        echo json_export($result);
    }

    //todo - 99% - testing
    if ($action == "get_dashboard_list"){
        $data = json_decode($param_json, true);

        //$user_id = text_clean($data["user_id"]);
        //$login_token = text_clean($data["login_token"]);
        $login_data = $data["login_data"];

        $result = getOKStatus();

        $access_list = array();

        $net_rel_query = "select * from " . TABLE_CLIENT_DASHBOARD;
        $net_rel_result = $dash_database->query($net_rel_query);
        if ($net_rel_result != null && $net_rel_result->is_row_found()){
            while ($row = $net_rel_result->fetch_array()){

                $access = array();
                $access["client_id"] = $row["client_id"];
                $access["client_name"] = $row["client_name"];
                $access["dashboard_code"] = $row["dashboard_code"];
                $access["dashboard_name"] = $row["dashboard_name"];
                $access["secret_key"] = $row["secret_key"];
                $access["last_update"] = $row["update_time"];

                $access_list[] = $access;
            }
        }

        $result["access_list"] = $access_list;

        /*$res = '{
          "status": "OK",
          "access_list": [
            {
              "client_id": "125",
              "client_name": "Todd Rodgers",
              "dashboard_code": 5,
              "dashboard_name": "Gas Prices",
              "secret_key": "hdjjgjdkshfjsljyrytsfsdsjyds",
              "last_update": "2021-11-12 11:34:52"
            },
            {
              "client_id": "125",
              "client_name": "Todd Rodgers",
              "dashboard_code": 10,
              "dashboard_name": "Food Prices",
              "secret_key": "hfhfheytsdgdlkspisfsdlshsja",
              "last_update": "2021-11-12 11:34:52"
            },
            {
              "client_id": "346",
              "client_name": "Zendar Doblin",
              "dashboard_code": 10,
              "dashboard_name": "Food Prices",
              "secret_key": "hfhfheytsdgdlkspisfsdlshsja",
              "last_update": "2021-11-12 11:34:52"
            },
            {
              "client_id": "465",
              "client_name": "Feliz Robson",
              "dashboard_code": 13,
              "dashboard_name": "Pets",
              "secret_key": "hhffsgooejskgdkhspeljkfh",
              "last_update": "2021-11-13 11:34:52"
            }
          ]
        }
        ';*/

        //echo $res;
        echo json_export($result);

    }

    //todo - 99% - testing
    if ($action == "remove_dashboard_access"){
        $data = json_decode($param_json, true);

        $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

        $client_id = text_clean($data["client_id"]);
        $dashboard_code = text_clean($data["dashboard_code"]);

        //{"client_id":"125","dashboard_code":"5"}
        //$user_id = text_clean($data["user_id"]);
        //$login_token = text_clean($data["login_token"]);



        $add_sub_net = "delete from " . TABLE_CLIENT_DASHBOARD . " where client_id = '$client_id' and dashboard_code = '$dashboard_code'";
        $add_sub_net_result = $dash_database->query($add_sub_net);
        if($add_sub_net_result != null && $add_sub_net_result->is_row_affected()){
            $result = getOKStatus();
        }

        echo json_export($result);

    }


    //todo - 99% - testing
    if ($action == "update_sync_state"){
        $data = json_decode($param_json, true);

        $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

        $survey_id = text_clean($data["survey_id"]);
        $interval_in_seconds = text_clean($data["interval_in_seconds"]);
        $is_enable = text_clean($data["is_enabled"]);
        //$is_enable = ($is_enable);



        //$result = getOKStatus();

        //$user_query = "select * from " . TABLE_LIVE_SURVEY . " where is_enabled = '1'";
        $user_query = "select * from " . TABLE_LIVE_SURVEY . " where survey_id = '$survey_id'";
        $user_result = $dash_database->query($user_query);

        if ($user_result != null && $user_result->is_row_found()) {

            if ($row = $user_result->fetch_array()) {

                if ($is_enable){

                    $update_sub_net = get_update_query(TABLE_LIVE_SURVEY,[
                        "update_time" => getCurrentTime(),
                        "survey_name" => null,
                        "is_enabled" => 1,
                        "submission_count" => 0, //todo get submission here
                        "interval_in_sec" => $interval_in_seconds
                    ],"survey_id = '$survey_id'");

                    $update_sub_net_result = $dash_database->query($update_sub_net);
                    if($update_sub_net_result != null && $update_sub_net_result->is_row_affected()){
                        $result = getOKStatus();
                    }
                }
                else{
                    $update_sub_net = get_update_query(TABLE_LIVE_SURVEY,[
                        "update_time" => getCurrentTime(),
                        "survey_name" => null,
                        "is_enabled" => 0,
                        "submission_count" => 0,
                        "interval_in_sec" => $interval_in_seconds
                    ],"survey_id = '$survey_id'");

                    $update_sub_net_result = $dash_database->query($update_sub_net);
                    if($update_sub_net_result != null && $update_sub_net_result->is_row_affected()){
                        $result = getOKStatus();
                    }
                }

                /*$survey_id = $row["survey_id"];

                $survey_object = array();
                $survey_object["survey_id"] = $survey_id;
                $survey_object["survey_name"] = null;
                $survey_object["is_enabled"] = $row["is_enabled"] == 1;
                $survey_object["submission_count"] = $row["submission_count"];
                $survey_object["interval_in_seconds"] = $row["interval_in_sec"];

                $result[$survey_id] = $survey_object;*/
            }
        }
        else{
            if ($is_enable){
                $add_sub_net = get_insert_query(TABLE_LIVE_SURVEY,[
                    "creation_time" => getCurrentTime(),
                    "survey_name" => null,
                    "survey_id" => $survey_id,
                    "is_enabled" => 1,
                    "submission_count" => 0, //todo get submission here
                    "interval_in_sec" => $interval_in_seconds
                ]);
                $add_sub_net_result = $dash_database->query($add_sub_net);
                if($add_sub_net_result != null && $add_sub_net_result->is_row_affected()){
                    $result = getOKStatus();
                }
            }

        }




        //$result["survey_id"] = $survey_id;
        //$result["interval_in_seconds"] = $interval_in_seconds;
        //$result["is_enabled"] = boolval($is_enable);

        echo json_export($result);

    }
}



function downloadImage($url,$filename){
    $img = getContentCurlRaw($url);

    file_put_contents($filename, $img);
    //$fn = fopen($filename,"w");

    //if($fn != false){

    //fwrite($fn,$img,sizeof($img));
    //}

    //fclose($fn);
}
function getContentCurlRaw($url){
    //header('Content-Type:application/json');
    //$url = "https://www.coralnodes.com/best-wordpress-image-optimization-plugins/";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    //curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));

    $res = curl_exec($ch);

    curl_close($ch);

    return $res;
}


//this is used to get the session key
function get_session_key(){
    $insight_url = "https://insight.queritel.com/index.php/admin/remotecontrol";

    $headers = array(
        'Content-Type: application/json'
    );

    $session_key = null;

    $embedded = array();
    $embedded["method"] = "get_session_key";
    $embedded["id"] = 1;
    $embedded["params"] = array(
        "username" => "Queritel",
        "password" => "sMCzVSeWpvCZ"
    );

    $encoded_fields = json_encode($embedded);


    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $insight_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    $result_obj = json_decode($result, true);

    $session_key = $result_obj["result"];

    curl_close($ch);

    return $session_key;
}
function get_dashboard_lnk($dashboard_code){
    $SITE_URL = "https://chartally.com";
    $SECRET_KEY = "a5b75f839d2201416d39d502194092f29127e3baa187219cc11f5d15fbd5bdf8";


    $timeObj = new DateTime();
    $timeObj->setTimezone(new DateTimeZone("UTC"));
    $min = 60 * (24);  // 24 hours
    $expiration = ((int)$timeObj->format('U') + (60 * $min));

    $header = json_encode([
        'typ' => 'JWT',
        'alg' => 'HS256'
    ]);

    // Create token payload as a JSON string
    $payload = json_encode([
        'resource' => [
            'dashboard' => intval($dashboard_code)
        ],
        'params' => (object) array(),
        'exp' => $expiration
    ]);

    // Encode Header to Base64Url String
    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));

    // Encode Payload to Base64Url String
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload));

    // Create Signature Hash
    $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $SECRET_KEY, true);

    // Encode Signature to Base64Url String
    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

    // Create JWT
    $jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;

    return $SITE_URL . "/embed/dashboard/" . $jwt . "#bordered=true&titled=true";
}
function get_question_lnk($question_code){
    $SITE_URL = "https://chartally.com";
    $SECRET_KEY = "a5b75f839d2201416d39d502194092f29127e3baa187219cc11f5d15fbd5bdf8";


    $timeObj = new DateTime();
    $timeObj->setTimezone(new DateTimeZone("UTC"));
    $min = 60 * (24);  // 24 hours
    $expiration = ((int)$timeObj->format('U') + (60 * $min));

    $header = json_encode([
        'typ' => 'JWT',
        'alg' => 'HS256'
    ]);

    // Create token payload as a JSON string
    $payload_quest = json_encode([
        'resource' => [
            'question' => $question_code
        ],
        'params' => (object) array(),
        'exp' => $expiration
    ]);

    // Encode Header to Base64Url String
    $base64UrlHeader = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($header));

    // Encode Payload to Base64Url String
    $base64UrlPayload = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($payload_quest));

    // Create Signature Hash
    $signature = hash_hmac('sha256', $base64UrlHeader . "." . $base64UrlPayload, $SECRET_KEY, true);

    // Encode Signature to Base64Url String
    $base64UrlSignature = str_replace(['+', '/', '='], ['-', '_', ''], base64_encode($signature));

    // Create JWT
    $jwt = $base64UrlHeader . "." . $base64UrlPayload . "." . $base64UrlSignature;

    return $SITE_URL . "/embed/question/" . $jwt . "#bordered=true&titled=true";
}


//this is used to get a list of all
//the active survey directly from the insights platform
function get_all_survey(){
    $session_key = get_session_key();

    $insight_url = "https://insight.queritel.com/index.php/admin/remotecontrol";

    $headers = array(
        'Content-Type: application/json'
    );


    $embedded = array();
    $embedded["method"] = "list_surveys";
    $embedded["id"] = 1;
    $embedded["params"] = array(
        "sSessionKey" => $session_key,
        "sUsername" => "Queritel"
    );

    $encoded_fields = json_encode($embedded);


    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $insight_url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    $result_obj = json_decode($result, true);

    $final_array = array();
    if ($result_obj["result"]){
        foreach ($result_obj["result"] as $survey_item) {

            if ($survey_item["active"] == "Y"){
                $survey_object = array();
                $survey_object["survey_id"] = $survey_item["sid"];
                $survey_object["survey_name"] = $survey_item["surveyls_title"];
                $survey_object["is_enabled"] = false;
                $survey_object["submission_count"] = 0;
                $survey_object["last_update"] = null;
                $survey_object["interval_in_seconds"] = 0;

                $final_array[] = $survey_object;
            }
        }
    }

    /*{
        "survey_id": "FJ89579G",
        "survey_name": "All About Pets",
        "is_enabled": true,
        "submission_count": 330,
        "last_update": "2021-11-12 11:34:52",
        "interval_in_seconds": 4
      }*/

    /*[
      {
        "sid": "356795",
        "surveyls_title": "Social Media Survey",
        "startdate": null,
        "expires": null,
        "active": "Y"
      },
      {
        "sid": "738718",
        "surveyls_title": "cornersave Campaign",
        "startdate": null,
        "expires": null,
        "active": "Y"
      }
    ]*/

    curl_close($ch);

    return $final_array;
}

function get_enabled_survey_map($dash_database){

    $result = array();

    //$user_query = "select * from " . TABLE_LIVE_SURVEY . " where is_enabled = '1'";
    $user_query = "select * from " . TABLE_LIVE_SURVEY;
    $user_result = $dash_database->query($user_query);

    if ($user_result != null && $user_result->is_row_found()) {
        while ($row = $user_result->fetch_array()) {

            $survey_id = $row["survey_id"];

            $survey_object = array();
            $survey_object["survey_id"] = $survey_id;
            $survey_object["survey_name"] = null;
            $survey_object["is_enabled"] = $row["is_enabled"] == 1;
            $survey_object["submission_count"] = $row["submission_count"];
            $survey_object["interval_in_seconds"] = $row["interval_in_sec"];

            $result[$survey_id] = $survey_object;
        }
    }

    return $result;
}

function query_user($user_id, $paperweight){

    $result = array();

    $user_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
    $user_result = $paperweight->query($user_query);

    if ($user_result != null && $user_result->is_row_found()) {

        if ($row = $user_result->fetch_array()) {

            $fname = stringCase($row["user_first_name"],STRING_CASE_CAP_EACH);
            $lname = stringCase($row["user_last_name"],STRING_CASE_CAP_EACH);
            $user_ref_id = $row["user_ref_id"];


            $result["fname"] = $fname;
            $result["lname"] = $lname;
            $result["user_ref_id"] = $user_ref_id;
            $result["user_id"] = $user_id;
            $result["user_email"] = $row["user_email"];

        }
    }

    return $result;
}

function getErrorStatus($error_msg){
    $result = array();
    $error = array();
    $error["name"] = ERROR_NAME_OP_FAILED;
    $error["message"] = $error_msg;
    $result["status"] = STATUS_ERROR;
    $result["error"] = $error;

    return $result;
}
function getOKStatus(){
    $result = array();
    $result["status"] = STATUS_OK;

    return $result;
}

function get_update_query(string $table,array $set, string $where = null): string
{

    $query = "update " . $table . " set";
    foreach ($set as $key => $value) {
        $query .= " $key = '" . $value . "',";
    }

    $query = rtrim($query, ", ");

    if ($where != null){
        $query .= " where " . $where;
    }

    return $query;
}
function get_insert_query($table, array $values): string
{

    $query = "insert into " . $table . " (";
    foreach ($values as $key => $value) {
        $query .= $key . ",";
    }
    $query = rtrim($query, ", ");
    $query .= ") values (";

    /*foreach ($values as $value) {
        $query .= " (";
        foreach ($value as $val) {
            $query .= "'" . $val . "',";
        }
        $query = rtrim($query, ", ");

        $query .= "),";
    }*/
    foreach ($values as $key => $value) {
        $query .= "'" . $value . "',";
    }
    $query = rtrim($query, ", ");

    $query .= "),";
    $query = rtrim($query, ", ");

    return $query;
}











//todo update due date - config interface --------
function updateDueDate($days_hours_mins){
    //DAYS-HOURS-MINUTES
    $extra_obj = explode("-",$days_hours_mins);
    $days = $extra_obj[0];
    $hours = $extra_obj[1];
    $minutes = $extra_obj[2];
    $minutes_to_add = 0;

    if ($days > 0){
        $hours += ($days * 24);
    }
    if ($hours > 0){
        $minutes += ($hours * 60);
    }
    if ($minutes > 0){
        $minutes_to_add += $minutes;
    }

    $old_time_utc = "2021-07-28 07:00:00";
    $interval_spec = "PT" . $minutes_to_add . "M";

    $time = new DateTime($old_time_utc,new DateTimeZone("UTC"));
    $time->add(new DateInterval($interval_spec));
    $new_time_utc = $time->format("Y-m-d H:i:s");

    $sub = array();
    $sub["minutes_to_add"] = $minutes_to_add;
    $sub["old_time_utc"] = $old_time_utc;
    $sub["new_time_utc"] = $new_time_utc;
    $sub["extra_obj"] = $extra_obj;
    $sub["extra"] = $days_hours_mins;

    return $sub;
}

//INSIGHT : This is checks if the survey url is running on the insight platform
function isInsightSurvey($survey_url){
    $is_insight_survey = false;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);

    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    return $is_insight_survey;
}

//INSIGHT : this get the insight survey id or NULL
function getInsightSurveyID($survey_url){
    $is_insight_survey = false;
    $survey_id = null;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);
    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    if ($is_insight_survey){
        $path = parse_url($survey_url, PHP_URL_PATH);
        $path_arr = explode("/",$path);
        $survey_id = $path_arr[count($path_arr) - 1];
    }

    return $survey_id;
}

//INSIGHT : this gets the updated link with the token appended
function getUpdatedInsightSurveyLink($survey_url,$survey_token,$language_code = null){ //add language code
    $is_insight_survey = false;
    $url = $survey_url;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);
    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    if ($is_insight_survey){
        $search = "lang";
        $params = array();
        $query = parse_url($survey_url, PHP_URL_QUERY);
        parse_str($query,$params);

        if(preg_match("/{$search}/i", $query)){
            //if the url has "lang"
            foreach ($params as $key => $value) {
                if ($key == "lang") {
                    $item_search = "lang=$value";
                    $item_replace = "lang=$language_code";

                    if($language_code != null){
                        $survey_url = str_replace($item_search,$item_replace,$survey_url);
                    }

                }
            }
        }
        else {
            //if the url does not have "lang"
            if($language_code != null){
                $survey_url = $survey_url . (parse_url($survey_url, PHP_URL_QUERY) ? '&' : '?') . 'lang=' . $language_code;
            }
        }


        $url = $survey_url . (parse_url($survey_url, PHP_URL_QUERY) ? '&' : '?') . 'token=' . $survey_token;
    }

    return $url;
}

//INSIGHT : this gets a unique token from the survey database and reserves a spot
function getUniqueInsightSurveyToken($survey_url, $client = null){
    $is_insight_survey = false;
    $survey_id = null;
    $available_token = null;

    $survey_host = parse_url($survey_url, PHP_URL_HOST);
    if ($survey_host == INSIGHT_DOMAIN){
        $is_insight_survey = true;
    }

    if ($is_insight_survey){
        $path = parse_url($survey_url, PHP_URL_PATH);
        $path_arr = explode("/",$path);
        $survey_id = $path_arr[count($path_arr) - 1];

        $survey_response_table = "lsnm_survey_" . $survey_id;
        $survey_token_table = "lsnm_tokens_" . $survey_id;

        $insight_db = new Database(INSIGHT_DB_USERNAME,INSIGHT_DB_PASSWORD,INSIGHT_DB_NAME);

        $available_token = null;
        $has_available_token = false;
        $reservation_time = getCurrentTime("Y-m-d H:i");


        //get previously assigned token
        $user_ref_id = $client->getUserRefId();
        $fname = $client->get_firstName();
        $lname = $client->get_lastName();
        $email = $client->get_email();


        $sql_prev_token = "select * from " . $survey_token_table . " where attribute_1 = '$user_ref_id' and (completed is null or completed in ('N'))"; //previous token is still available
        $sql_prev_query_result = $insight_db->query($sql_prev_token);
        if($sql_prev_query_result != null && $sql_prev_query_result->is_row_found()){
            while($row = $sql_prev_query_result->fetch_array()){
                $token_id = $row["tid"];
                $available_token = $row["token"];

                $update_query = "update " . $survey_token_table . " set `sent` = '$reservation_time' where `tid` = '$token_id'";
                $update_query_result = $insight_db->query($update_query);
                if($update_query_result != null && $update_query_result->is_row_affected()){
                    //$has_available_token = true;
                }

                break;
            }
        }
        else{
            $sql_query = "select * from " . $survey_token_table . " where sent is null or sent in ('N')"; //token is available
            $sql_query_result = $insight_db->query($sql_query);
            if($sql_query_result != null && $sql_query_result->is_row_found()){
                while($row = $sql_query_result->fetch_array()){
                    $token_id = $row["tid"];
                    $available_token = $row["token"];

                    $update_query = "update " . $survey_token_table . " set `sent` = '$reservation_time', email = '$email', attribute_1 = '$user_ref_id', firstname = '$fname', lastname = '$lname' where `tid` = '$token_id'";
                    $update_query_result = $insight_db->query($update_query);
                    if($update_query_result != null && $update_query_result->is_row_affected()){
                        //$has_available_token = true;
                    }

                    break;
                }
            }
        }






    }

    return $available_token;
}

//============= THIRD PARTY API START =================

/**
 * @usage - This will be used for mobile recharge
 * @methods GetCurrencies
 * @methods GetRegions
 * @methods GetCountries
 * @methods GetProviders
 * @methods GetProviderStatus
 * @methods GetProducts
 * @methods GetProductDescriptions
 * @methods SendTransfer
 * @methods GetBalance
 *
 *
 * @link connectDingAPI("https://api.dingconnect.com/api/V1/GetCurrencies");
 *
 *
 * @COUNT 9
 */


//5 -
//18765197487 -

$get_prod = array();


$payload = array();
$payload["SkuCode"] = "JM_DC_TopUp";
$payload["SendValue"] = 5;
$payload["SendCurrencyIso"] = "usd";
$payload["AccountNumber"] = "18765197487";
$payload["DistributorRef"] = "#659075749";

$settings = array();
$settings["Name"] = "Queritel Payout";
$settings["Value"] = "5 usd";

$payload["Settings"] = $settings;
$payload["ValidateOnly"] = false;
$payload["BillRef"] = "Queritel Reference : 1967048";

/*{
  "SkuCode": "string",
  "SendValue": 0,
  "SendCurrencyIso": "string",
  "AccountNumber": "string",
  "DistributorRef": "string",
  "Settings": [
    {
      "Name": "string",
      "Value": "string"
    }
  ],
  "ValidateOnly": true,
  "BillRef": "string"
}*/




//DING MOBILE RECHARGE : needs to be fixed
function connectDingAPI($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    //curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json','api_key: ApyJWyuifmb6YMuJhu7wAW'));
    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            'Accept: application/json',
            'Content-Type: application/json',
            'api_key: ' . DING_MOBILE_RECHARGE_KEY
        ));


    $payload = array();
    $payload["SkuCode"] = "JM_DC_TopUp";
    $payload["SendValue"] = 5;
    $payload["SendCurrencyIso"] = "USD";
    //$payload["AccountNumber"] = "18765197487";
    $payload["AccountNumber"] = "18762971769";
    $payload["DistributorRef"] = "#659075749";

    //$settings = array();
    //$settings["Name"] = "Queritel Payout";
    //$settings["Value"] = "5 usd";
    //$settings["Name"] = "";
    //$settings["Value"] = "";

    //$payload["Settings"] = $settings;
    $payload["ValidateOnly"] = true;
    $payload["BillRef"] = "Queritel Reference : 1967048";



    //$fields = array();
    //$fields['data'] = $message;
    $encoded_fields = json_encode($payload);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $res = curl_exec($ch);

    curl_close($ch);

    //$res = json_decode($res, true);
    //$res = json_decode($res, true);

    return $res;
}

//FIREBASE NOTIFICATION BASE
function sendFCM($message, $id) {
    /*if(!function_exists(curl_exec)){
        LogReport("unsetRequestTopicListener : " . "curl is not installed");
        return;
    }*/

    //$message =  array
    $url = 'https://fcm.googleapis.com/fcm/send';

    $fields = array();
    $fields['data'] = $message;

    if (is_array($id)) {
        $fields["registration_ids"] = $id;
    }
    else {
        $fields["to"] = $id;
    }


    $encoded_fields = json_encode($fields);
    $headers = array(
        'Authorization: key=' . FIREBASE_SERVER_KEY,
        'Content-Type: application/json'
    );

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    echo $result;

    curl_close($ch);

    return $result;
}

//VERIFY CHILEAN R.U.T
function verifyRUT($chilean_rut){
    $__lnk = 'https://api.libreapi.cl/';
    $__out = '{
                "data": {
                    "rut": "272.185.964-8",
                    "name": "Full Name",
                    "activities": [
                        {
                            "name": "Actividades De Consultoria De Gestion",
                            "code": 702000,
                            "category": "Segunda",
                            "subject_to_vat": false,
                            "date": "2020-06-18T00:00:00Z"
                        }
                    ]
                },
                "status": "success"
            }';



    //$url = "https://api.libreapi.cl/rut/validate?rut=" . $chilean_rut;
    $url = "https://api.libreapi.cl/rut/activities?rut=" . $chilean_rut;

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json'
    ));

    //$payload = array();
    //$payload["var_1"] = "value";

    //$encoded_fields = json_encode($payload);
    //curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    $result_object = json_decode($result, true);

    $output = array();
    $output["rut"] = $chilean_rut;
    $output["verified"] = false;
    $output["full_name"] = null;
    $output["activities"] = null;

    if (($result_object["status"] == "success")){
        $output["rut"] = $result_object["data"]["rut"];

        if (!empty($result_object["data"]["name"])){
            $output["verified"] = true;
            $output["full_name"] = $result_object["data"]["name"];
            $output["activities"] = $result_object["data"]["activities"];
        }
    }

    curl_close($ch);

    return $output;
}

//THIRD-PARTY API TEMPLATE
function __api_template__($url){
    $__lnk = 'https://';
    $__out = '';

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
        'Accept: application/json',
        'Content-Type: application/json'
    ));

    $payload = array();
    $payload["var_1"] = "value";

    $encoded_fields = json_encode($payload);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $encoded_fields);

    $result = curl_exec($ch);

    //$result_object = json_decode($result, true);

    curl_close($ch);

    return $result;
}


//============= THIRD PARTY API END ===================



function sendNewQuestNotification($paperweight,$country_code){
    //$note_id = array();

    $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION;
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){

            $user_id = $row["user_id"];

            $user_data = query_user($user_id,$paperweight);
            $code = $user_data["country_code"];

            //country_code

            if ($country_code == $code){

                $note_id = $row["notification_id"];
                $message = array();

                $payload = array();
                $payload["status"] = PUSH_NOTIFICATION_STATUS_NEW_QUEST;
                $payload["extra"]["message"] = "empty";
                $message["payload"] = $payload;
                sendFCM($message,$note_id);

            }
        }
    }
}
function sendNewMessageNotification($user_id,$paperweight){
    //$note_id = array();


    $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id'";
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){

            $note_id = $row["notification_id"];

            $message = array();
            $payload = array();
            $payload["status"] = PUSH_NOTIFICATION_STATUS_MESSAGE;
            $payload["extra"]["message"] = "empty";
            $message["payload"] = $payload;
            sendFCM($message,$note_id);

        }
    }
}


//users who accepted the specific quest
function getQuestAgents($task_id, $paperweight){
    $progress = array();
    $result = array();
    $combined_total = 0;
    $index = 0;
    $processed_array = array();

    $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and survey_state in (" . SURVEY_STATE_PROGRESS. "," . SURVEY_STATE_COMPLETED . ")";
    $response_result = $paperweight->query($response_query);

    if ($response_result != null && $response_result->is_row_found())
    {

        $data = array();

        while ($row = $response_result->fetch_array())
        {

            //$response_total = $row["survey_count"];
            //$response_count = $row["survey_completed"];
            /*$survey_state = $row["survey_state"];*/
            $user_id = $row["user_id"];


            if (!isset($processed_array[$user_id])){

                $user_info = query_user($user_id, $paperweight);

                $data["user_id"] = $user_info["user_id"];
                $data["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
                $data["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
                $data["phone_number"] = $user_info["phone_number"];
                $data["email"] = $user_info["user_email"];


                $processed_array[$user_id] = $data;

                $progress[$index] = $data;

                $index++;
            }

            //$progress[$index]["fname"] = stringCase($user_info["fname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["lname"] = stringCase($user_info["lname"],STRING_CASE_CAP_EACH);
            //$progress[$index]["user_id"] = $user_info["user_id"];


            //$progress[$index]["user_ref_id"] = $user_info["user_ref_id"];
            //$progress[$index]["response_total"] = intval($response_total);
            //$progress[$index]["response_count"] = intval($response_count);

            //$combined_total = $combined_total + $response_count;
        }
    }

    //$result["combined_total"] = intval($combined_total);
    //$result["progress"] = $progress;

    return $progress;

}
function getLastMsg($agent_id,$network_id,$task_id,$paperweight){
    //get the last communication between an agent and the network
    //as well as the unread messages
    $last_msg = array();
    $last_msg["msg_body"] = "";
    $last_msg["timestamp"] = "";
    $last_msg["unread"] = 0; //the combined unread messages


    $msg_query = "select * from " . TABLE_MESSAGE . " where ((sender_network_id = '$network_id' or recipient_network_id = '$network_id') and (recipient_id = '$agent_id' or sender_id = '$agent_id')) and task_id = '$task_id'";
    $msg_result = $paperweight->query($msg_query);

    if($msg_result != null && $msg_result->is_row_found()){


        while($row = $msg_result->fetch_array()){

            $message_id = $row["message_id"];
            $recipient_id = $row["recipient_id"];
            $recipient_network_id = $row["recipient_network_id"];
            $sender_id = $row["sender_id"];
            $sender_network_id = $row["sender_network_id"];
            $timestamp = $row["send_time"];
            $task_id = $row["task_id"];
            $msg_body = ($row["message_body"]);
            $read = $row["read"];
            $unread = 0;


            $last_msg["msg_body"] = $msg_body;
            $last_msg["timestamp"] = $timestamp;

            if (($recipient_network_id == $network_id) && $read == 0){
                $prev_unread = $last_msg["unread"];
                $new_unread = $prev_unread + 1;

                $last_msg["unread"] = $new_unread;

            }

        }

    }


    return $last_msg;
}


/**
 * This function will check if a string is inside a string-array
 * irregardless of the case of the string
 *
 *  */
function isContainedIn($str, $str_array, $case_sensitive = false) {


    if($case_sensitive == false){
        $needle = strtolower($str);
        $haystack = strtolower($str_array);
    }
    else{
        $needle = $str;
        $haystack = $str_array;
    }

    $found = preg_match("/$needle/", $haystack);


    if($found){

        return true;
    }
    else{

        return false;
    }
}
function notificationTokenHash($notification_id){
    return md5("05624" . $notification_id);
}
function encryptPassword($password){//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}
function random_number($length = 5) {
    $characters = '01234567898576479201';
    $charactersLength = strlen($characters);
    $randomNumber = '';

    for ($i = 0; $i < $length; $i++) {
        $randomNumber .= $characters[true_random(0, $charactersLength - 1)];
    }
    return $randomNumber;
}
function generate_token() {
    return getRandomNumber(4) . "" . getRandomNumber(4);
}
function generate_unique_id($unique_prefix) {
    return $unique_prefix . strtolower(getRandomString(7)) . "-" . getRandomNumber(7) . "-" . strtolower(getRandomString(7));
}



function hasAgent(){
    $has_agent = isset($_GET["agent"]);
    //$app_agent = clean($_GET["agent"]);

    //if (!$has_agent){
        //$has_agent = true;
        //$app_agent = MOBILE_AGENT_ANDROID;
    //}

    return $has_agent;
}
function getAgent(){
    $has_agent = isset($_GET["agent"]);
    $app_agent = text_clean($_GET["agent"]);

    if (!$has_agent){
        $has_agent = true;
        $app_agent = MOBILE_AGENT_ANDROID;
    }

    return $app_agent;
}
function getAPP_VERSION_DATA(){
    $has_agent = isset($_GET["agent"]);
    $app_agent = clean($_GET["agent"]);
    $results = array();

    if (!$has_agent){
        $has_agent = true;
        $app_agent = MOBILE_AGENT_ANDROID;
    }

    if ($has_agent && ($app_agent == MOBILE_AGENT_ANDROID)){
        $results[MOBILE_VERSION_NAME] = ANDROID_VERSION_NAME;
        $results[MOBILE_VERSION_CODE] = ANDROID_VERSION_CODE;
        $results[MOBILE_VERSION_COMMENT] = ANDROID_VERSION_COMMENT;
        $results[MOBILE_VERSION_PRIORITY] = ANDROID_VERSION_PRIORITY;
    }
    else if ($has_agent && ($app_agent == MOBILE_AGENT_IOS)){
        $results[MOBILE_VERSION_NAME] = IOS_VERSION_NAME;
        $results[MOBILE_VERSION_CODE] = IOS_VERSION_CODE;
        $results[MOBILE_VERSION_COMMENT] = IOS_VERSION_COMMENT;
        $results[MOBILE_VERSION_PRIORITY] = IOS_VERSION_PRIORITY;
    }

    return $results;
}


//debug----
function getQuestCreatorNetwork($task_id,$paperweight){
    $network_id = null;

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null && $task_result->is_row_found())
    {

        if($row = $task_result->fetch_array())
        {
            $network_id = $row["creator_net_id"];
        }
    }

    return $network_id;
}
function getQuestDetail($task_id,$paperweight){
    $detail = array();

    $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
    $task_result = $paperweight->query($task_query);

    if ($task_result != null && $task_result->is_row_found())
    {

        if($row = $task_result->fetch_array())
        {
            $detail["task_id"] = $row["task_id"];
            $detail["creator_net_id"] = $row["creator_net_id"];
            $detail["task_ref_id"] = $row["task_ref_id"];
            $detail["task_user_id"] = $row["task_user_id"];
            $detail["task_status"] = $row["task_status"];
            $detail["task_topic"] = $row["task_topic"];
            $detail["task_budget"] = $row["task_budget"];
            $detail["task_instructions"] = $row["task_instructions"];
            $detail["task_posted_on"] = $row["task_posted_on"];
            $detail["task_completed_on"] = $row["task_completed_on"];
            $detail["task_respondent_count"] = $row["task_respondent_count"];
            $detail["task_question_count"] = $row["task_question_count"];
            $detail["task_location_count"] = $row["task_location_count"];
            $detail["survey_url"] = $row["survey_url"];
            $detail["completion_url"] = $row["completion_url"];
            $detail["survey_ready"] = $row["survey_ready"];
            $detail["task_time_day"] = $row["task_time_day"];
            $detail["task_question_type"] = $row["task_question_type"];
            $detail["my_network"] = $row["my_network"];
            $detail["network_id"] = $row["network_id"];
            $detail["task_category"] = $row["task_category"];
            $detail["task_activity"] = $row["task_activity"];
            $detail["task_start_date"] = $row["task_start_date"];
            $detail["task_due_date"] = $row["task_due_date"];
            $detail["handle_payment"] = $row["handle_payment"];
            $detail["workforce_timezone"] = $row["workforce_timezone"];
            $detail["workforce_country"] = $row["workforce_country"];
        }
    }

    return $detail;
}
//debug----

//get details for specific network
function getNetworkDetails($network_id, $paperweight){

    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where network_id = '$network_id'";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {

            $organization_name = stringCase($row["organization_name"],STRING_CASE_CAP_EACH);
            $network_name = $row["network_name"];
            $network_id = $row["network_id"];


            $result["organization_name"] = $organization_name;
            $result["network_name"] = $network_name;
            $result["network_id"] = $network_id;


        }
    }

    return $result;
}
function getOfficialNetworks($paperweight){
    $result = array();

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_OFFICIAL . "," . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        while($row = $network_result->fetch_array())
        {
            $result[] = $row["network_id"];
        }
    }

    return $result;
}
function isFromNetwork($user_id, $network_id, $paperweight,$check_active = true){
    //check_active - check to make sure the relationship is active

    $is_from_network = false;

    if ($check_active){
        $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "' and relationship_state = '" . STATE_ACTIVE . "'";
    }
    else{
        $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_id = '$network_id' and network_role = '" . NETWORK_ROLE_COLLECTOR . "'";
    }

    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null)
    {

        $row = $network_rel_result->fetch_array();

        if ($row != null)
        {
            $is_from_network = true;
        }
    }

    return $is_from_network;
}
function getNetworkRelationship($user_id, $paperweight){

    $result = array();

    $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id'";
    $network_rel_result = $paperweight->query($network_rel_query);

    if ($network_rel_result != null)
    {

        while ($row = $network_rel_result->fetch_array())
        {

            $network_id = $row["network_id"];
            $network_role = $row["network_role"];
            $network_rel_state = $row["relationship_state"];

            $net = array();
            $net["network_id"] = $network_id;
            $net["network_role"] = $network_role;
            $net["relationship_state"] = $network_rel_state;

            $result[] = $net;

        }
    }


    return $result;
}
function isFromOfficialNetwork($user_id, $paperweight,$check_active = true){
    $from_official = false;

    $official_networks = getOfficialNetworks($paperweight);
    $network_relationship = getNetworkRelationship($user_id,$paperweight);

    if (!empty($network_relationship)){
        foreach ($network_relationship as $relation){
            $network_id = $relation["network_id"];
            $network_role = $relation["network_role"];
            $network_rel_state = $relation["relationship_state"];

            if ($check_active){
                if (in_array($network_id,$official_networks) && $network_rel_state == STATE_ACTIVE){
                    $from_official = true;
                }
            }
            else{
                if (in_array($network_id,$official_networks)){
                    $from_official = true;
                }
            }
        }
    }

    return $from_official;
}
function getContentCurl($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));

    $res = curl_exec($ch);

    curl_close($ch);

    return $res;
}

//Location-Based functions
function getDistanceBetweenAccurate(LocationPoint $point1, LocationPoint $point2) {
    //get the distance from driver's location to the request origin [to see how close the driver is]
    //returns array("SUCCESS","distance_value")
    //unit = metrics(meters)

    $output["status"] = "FAILED";

    if($point1->isEmpty() || $point2->isEmpty()){
        return $output;
    }


    $origin = $point1->getLatitude() . "," . $point1->getLongitude();
    $destination = $point2->getLatitude() . "," . $point2->getLongitude();

    $url2 = "https://map.google.com/maps/api/distancematrix/json?units=metric&origins={$origin}&destinations={$destination}&key=" . SERVER_MAP_KEY;
    $fil2 = file_get_contents($url2);

    $results = json_decode($fil2, true);


    if ($results["status"] == "OK") {
        if ($results["rows"][0]["elements"][0]["status"] == "OK") {
            $distance_in_meters = $results["rows"][0]["elements"][0]["distance"]["value"];
            $output["status"] = "SUCCESS";
            $output["distance"] = $distance_in_meters;
        }
    }

    return $output;
}
function getRad($var) {
    return $var * pi() / 180;
}
function getDistanceBetweenGeneral(LocationPoint $point1, LocationPoint $point2) {
    $EARTH_MEAN_RADIUS_METERS = 6378137; //earths mean radius in meters

    $output = null;

    if($point1->isEmpty() || $point2->isEmpty()){
        return $output;
    }


    $distanceLat = getRad($point2->getLatitude() - $point1->getLatitude());
    $distanceLon = getRad($point2->getLongitude() - $point1->getLongitude());

    $a = sin($distanceLat / 2) * sin($distanceLat / 2) + cos(getRad($point1->getLatitude())) * cos(getRad($point2->getLatitude())) * sin($distanceLon / 2) * sin($distanceLon / 2);
    $angular_distance = 2 * atan2(sqrt($a), sqrt(1 - $a));
    $distance_meters = intval($EARTH_MEAN_RADIUS_METERS * $angular_distance);

    $output = $distance_meters;

    return $output;
}

function getDefaultNetwork($paperweight){
    $network_id = null;

    $network_query = "select * from " . TABLE_NETWORK . " where position in (" . NETWORK_POSITION_DEFAULT . ")";
    $network_result = $paperweight->query($network_query);

    if ($network_result != null)
    {

        $row = $network_result->fetch_array();

        if ($row != null)
        {
            $network_id = $row["network_id"];
        }
    }

    //"nid_hfg589368HWrvsp"; // queritel network id

    return $network_id;

}
function generateUserReferenceId() {
    return getRandomNumber(8);
}
function generateNumericId() {
    return getRandomNumber(8);
}

function debugAPIResponse($api,$msg) {

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "$api-$time_stamp-$random.json";
    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);
}

function __get_template__($paperweight){
    $module = array();


    $sql_query = "select * from " . TABLE_ALL_MODULES . " order by sort asc";
    $sql_query_result = $paperweight->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){
            $module[] = $row["module_id"];
        }
    }
}
function __insert_template__($paperweight){
    $module = array();


    $sql_query = "insert into " . "_TABLE_NAME_" . " (column_1,column_2,column_3,column_4) values ('','','','')";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}
function __update_template__($paperweight){
    $module = array();

    $sql_query = "update " . "_TABLE_NAME_" . " set `column_1` = '' where `column_1` = 0";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}
function __delete_template__($paperweight){
    $module = array();

    $sql_query = "delete from " . "_TABLE_NAME_" . " where `column_1` = 0";
    $sql_query_result = $paperweight->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}


/*
 * Author : Kadian Salmon
 * Date : Sep 23, 2021
 * Purpose : Main class for all operations relating to client
 */
class Client {
    private $db_connector;
    private $isLoggedin;//is the researcher logged in
    private $isActive;//is this researcher's account still active
    private $hasCurrentLocation;//


    //current details
    private $host_info = null;
    private $currentLat = null;
    private $currentLon = null;
    private $currentLocation = null;

    //researcher details
    private $userId = null;
    private $loginToken = null;
    private $email = null;
    private $user_ref_id = null;
    private $language_code = null;
    private $password = null;
    private $screenName = null;
    private $firstName = null;
    private $lastName = null;
    private $gender = null;

    private $occupation = null;
    private $education = null;
    private $marital_status = null;
    private $ethnicity = null;
    private $employment_status = null;
    private $employment_industry = null;


    private $locationCountry = null;
    private $locationCountryCode = null;
    private $currencyCode = null;
    private $locationState = null;
    private $locationCity = null;
    private $registrationDate = null;
    private $phoneNumber = null;
    private $locationAddress = null;
    private $date_of_birth = null;



    function __construct(Database $db_connector) {
        $this->db_connector = $db_connector;

        $this->host_info = new HostInfo($db_connector);

        $this->currentLocation = new LocationPoint(null,null);

    }


    public function get_db_connector() {
        return $this->db_connector;
    }

    public function isLoggedin() {
        return $this->isLoggedin;
    }

    public function isActive() {
        return $this->isActive;
    }

    public function get_userId() {
        return $this->userId;
    }

    public function get_loginToken() {
        return $this->loginToken;
    }

    public function get_email() {
        return $this->email;
    }

    public function getUserRefId()
    {
        return $this->user_ref_id;
    }

    public function get_encrytedPassword() {
        return $this->password;
    }

    public function get_screenName() {
        return $this->screenName;
    }

    public function get_firstName() {
        return $this->firstName;
    }

    public function get_lastName() {
        return $this->lastName;
    }

    public function get_gender() {
        return $this->gender;
    }

    public function get_locationCountry() {
        return $this->locationCountry;
    }

    public function getLanguageCode()
    {
        return $this->language_code;
    }


    public function get_locationState() {
        return $this->locationState;
    }

    public function get_locationCity() {
        return $this->locationCity;
    }

    public function get_registrationDate() {
        return $this->registrationDate;
    }

    public function get_phoneNumber() {
        return $this->phoneNumber;
    }

    public function getCurrentLocation(){
        return $this->currentLocation;
    }

    public function getLocationCountryCode()
    {
        return $this->locationCountryCode;
    }

    public function getLocationAddress()
    {
        return $this->locationAddress;
    }

    public function getDateOfBirth()
    {
        return $this->date_of_birth;
    }

    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }


    public function getOccupation()
    {
        return $this->occupation;
    }
    public function getEducation()
    {
        return $this->education;
    }
    public function getMaritalStatus()
    {
        return $this->marital_status;
    }
    public function getEthnicity()
    {
        return $this->ethnicity;
    }
    public function getEmploymentStatus()
    {
        return $this->employment_status;
    }
    public function getEmploymentIndustry()
    {
        return $this->employment_industry;
    }


    public function setEmploymentIndustry($employment_industry)
    {
        $this->employment_industry = $employment_industry;
    }
    public function setEthnicity($ethnicity)
    {
        $this->ethnicity = $ethnicity;
    }
    public function setEmploymentStatus($employment_status)
    {
        $this->employment_status = $employment_status;
    }
    public function setMaritalStatus($marital_status)
    {
        $this->marital_status = $marital_status;
    }
    public function setOccupation($occupation)
    {
        $this->occupation = $occupation;
    }
    public function setEducation($education)
    {
        $this->education = $education;
    }



    public function setLanguageCode($language_code)
    {
        $this->language_code = $language_code;
    }

    public function setCurrentLocation($lat,$lon){
        $currentLocation = new LocationPoint(null,null);

        if (!empty($lat) && !empty($lon)){
            $currentLocation = new LocationPoint($lat,$lon);
        }

        $this->currentLocation = $currentLocation;

    }

    public function set_db_connector($db_connector) {
        $this->db_connector = $db_connector;
    }

    public function set_isLoggedin($isLoggedin) {
        $this->isLoggedin = $isLoggedin;
    }

    public function set_isActive($isActive) {
        $this->isActive = $isActive;
    }

    public function set_userId($userId) {
        $this->userId = $userId;
    }

    public function set_loginToken($loginToken) {
        $this->loginToken = $loginToken;
    }

    public function set_email($email) {
        $this->email = $email;
    }

    public function setUserRefId($user_ref_id)
    {
        $this->user_ref_id = $user_ref_id;
    }

    public function set_encrytedPassword($password) {
        $this->password = $password;
    }

    public function set_screenName($screenName) {
        $this->screenName = $screenName;
    }

    public function set_firstName($firstName) {
        $this->firstName = $firstName;
    }

    public function set_lastName($lastName) {
        $this->lastName = $lastName;
    }

    public function set_gender($gender) {
        $this->gender = $gender;
    }

    public function set_locationCountry($locationCountry) {
        $this->locationCountry = $locationCountry;
    }

    public function set_locationState($locationState) {
        $this->locationState = $locationState;
    }

    public function set_locationCity($locationCity) {
        $this->locationCity = $locationCity;
    }

    public function set_registrationDate($registrationDate) {
        $this->registrationDate = $registrationDate;
    }

    public function set_phoneNumber($phoneNumber) {
        $this->phoneNumber = $phoneNumber;
    }

    public function setLocationCountryCode($locationCountryCode)
    {
        $this->locationCountryCode = $locationCountryCode;
    }

    public function setLocationAddress($locationAddress)
    {
        $this->locationAddress = $locationAddress;
    }

    public function setDateOfBirth($date_of_birth)
    {
        $this->date_of_birth = $date_of_birth;
    }

    public function setCurrencyCode($currencyCode)
    {
        $this->currencyCode = $currencyCode;
    }



    //todo : currency support to get rates from database table
    public function getCurrencyRate($currency = SYSTEM_CURRENCY){
        //This rate listing is relative to the SYSTEM_CURRENCY = "USD"

        $RATE = array();
        $RATE["USD"] = 1;
        $RATE["JMD"] = 140;
        $RATE["CLP"] = 730;

        if (!isset($RATE[$currency])){
            return $RATE[SYSTEM_CURRENCY];
        }
        else{
            return $RATE[$currency];
        }
    }

    //todo : currency support to convert funds to desired currency
    public function getConvertedFunds($usd_funds)
    {
        $converted_funds = 0;

        $currency = $this->currencyCode;
        if ($currency == null){
            $currency = SYSTEM_CURRENCY;
        }

        $rate = $this->getCurrencyRate($currency);

        $converted_funds = floatval($usd_funds * $rate);

        return $converted_funds;
    }

    public function signout($user_id,$login_token) {
        $user_type = USER_TYPE_RESEARCHER;
        $account_state = STATE_ACTIVE;
        $login_state = LOGIN_STATE_INVALID;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token'";
        $update_query = "update " . TABLE_LOGIN . " set login_state = '$login_state' where user_id = '$user_id' and token_id = '$login_token'";


        $result["status"] = STATUS_OK;


        if($this->db_connector != null){
            $login_result = $this->db_connector->query($login_check_query);
            if($login_result != null && $login_result->is_row_found()){
                //if we found the record
                $update_result = $this->db_connector->query($update_query);
                if($update_result != null && $update_result->is_row_affected()){
                    $result["status"] = STATUS_OK;
                    $this->isLoggedin = false;
                }

            }
        }

        return $result;

    }

    public function login($username,$password,$login_data_arr) {

        $provided_password = encryptPassword($password);
        $provided_username = strtolower($username);
        $user_type = USER_TYPE_CLIENT;
        $account_state = STATE_ACTIVE;
        $verified_by_admin = VERIFIED;
        $verified_email = VERIFIED;

        $login_data = null;
        if (!empty($login_data_arr)){
            $login_data_arr["ip_address"] = $this->host_info->getIp_address();
            $login_data = json_encode($login_data_arr);
        }
        else{
            $login_data_arr = array();
            $login_data_arr["ip_address"] = $this->host_info->getIp_address();
            $login_data = json_encode($login_data_arr);
        }

        $result = $this->getErrorStatus(ERROR_MSG_INVALID_CRED);

        if($this->db_connector != null){
            //$login_query = "select * from " . TABLE_USERS . " where lower(user_email) = '$provided_username' and user_password = '$provided_password' and user_type = '$user_type' and user_active = '$account_state' and user_is_approved = '$verified_by_admin' and user_email_verified = '$verified_email'";
            $login_query = "select * from " . TABLE_USERS . " where lower(user_email) = '$provided_username' and user_password = '$provided_password' and user_type = '$user_type' and user_active = '$account_state'";

            $login_result = $this->db_connector->query($login_query);

            if($login_result != null && $login_result->is_row_found()){
                $row_data = $login_result->fetch_array();

                if($row_data != null){
                    $actual_uname = $row_data["user_email"];
                    $actual_pass = $row_data["user_password"];

                    if(($actual_uname == $provided_username) && ($actual_pass == $provided_password)){
                        $login_token = generate_token();
                        $login_time = getCurrentTime();
                        $login_state = LOGIN_STATE_VALID;
                        $user_id = $row_data["user_id"];

                        $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,login_data) values ('$login_token','$login_time','$login_state','$user_id','$login_data')";
                        $details_result = $this->db_connector->query($details_query);

                        if($details_result != null && $details_result->is_row_affected()){
                            //$this->isLoggedin = true;
                            $result = $this->getOKStatus();

                            $result["user_id"] = $row_data["user_id"];
                            $result["login_token"] = $login_token;

                            return $result;
                        }

                    }
                }
            }


        }

        return $result;

    }

    public function verifyLogin($user_id,$login_token) {
        $user_type = USER_TYPE_CLIENT;
        $account_state = STATE_ACTIVE;
        $login_state = LOGIN_STATE_VALID;
        $verified_by_admin = VERIFIED;
        $verified_email = VERIFIED;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token' and login_state = '$login_state'";
        //$user_check_query = "select * from " . TABLE_USERS . " where user_id = '$user_id' and user_type = '$user_type' and user_active = '$account_state' and user_is_approved = '$verified_by_admin' and user_email_verified = '$verified_email'";
        $user_check_query = "select * from " . TABLE_USERS . " where user_id = '$user_id' and user_type = '$user_type' and user_active = '$account_state'";

        $result = $this->getErrorStatus(ERROR_MSG_INVALID_TOKEN);


        if($this->db_connector != null){
            $login_result = $this->db_connector->query($login_check_query);
            if($login_result != null && $login_result->is_row_found()){
                $user_result = $this->db_connector->query($user_check_query);
                if($user_result != null && $user_result->is_row_found()){
                    $result = $this->getOKStatus();

                    /*$version_data = getAPP_VERSION_DATA();

                    if (hasAgent()){
                        $result[MOBILE_VERSION_NAME] = $version_data[MOBILE_VERSION_NAME];
                        $result[MOBILE_VERSION_CODE] = $version_data[MOBILE_VERSION_CODE];
                        $result[MOBILE_VERSION_COMMENT] = $version_data[MOBILE_VERSION_COMMENT];
                        $result[MOBILE_VERSION_PRIORITY] = $version_data[MOBILE_VERSION_PRIORITY];
                    }*/

                    $this->isLoggedin = true;
                    $this->userId = $user_id;
                    $this->loginToken = $login_token;
                }
                else{
                    $result = $this->getErrorStatus(ERROR_MSG_USER_DEACTIVATED);
                }

            }
        }

       return $result;

    }

    public function initializeClient($user_id,$login_token="") {
        //$this->host_info = new HostInfo($this->db_connector);//get all the host info... like [ip_address|country_name|country_code|area_code|currency]

        if($user_id != null){
            $this->userId = $user_id;
            //$this->userId = 1468; -- hugo
        }
        else{
            return false;
        }
        if($login_token != null){
            $this->loginToken = $login_token;
        }


        $user_check_query = "select * from " . TABLE_USERS . " where user_id = '$user_id'";
        $user_profile_check_query = "select * from " . TABLE_USER_PROFILE . " where userprofile_user_id = '$user_id'";

        if($this->db_connector != null){
            $user_result = $this->db_connector->query($user_check_query);
            $user_profile_result = $this->db_connector->query($user_profile_check_query);
            if($user_result != null && $user_result->is_row_found()){
                $row = $user_result->fetch_array();
                $row_profile = $user_profile_result->fetch_array();

                if($row != null){
                    $this->email = strtolower($row["user_email"]);
                    $this->password = $row["user_password"];
                    $this->screenName = strtolower($row["user_screen_name"]);
                    $this->firstName = strtolower($row["user_first_name"]);
                    $this->lastName = strtolower($row["user_last_name"]);

                    if ($row["user_sex"] == GENDER_MALE){
                        $this->gender = GENDER_MALE_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_FEMALE){
                        $this->gender = GENDER_FEMALE_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_NON_BINARY){
                        $this->gender = GENDER_NON_BINARY_STRING;
                    }
                    elseif($row["user_sex"] == GENDER_NOT_TO_SAY){
                        $this->gender = GENDER_NOT_TO_SAY_STRING;
                    }

                    $this->registrationDate = $row["user_regdate"];


                    $account_state = $row["user_active"];
                    $countryId = $row["user_country_id"];
                    $countryCode = $row["country_code"];
                    $phone_number = $row["phone_number"];
                    $location_address = $row["location_address"];
                    $date_of_birth = $row["date_of_birth"];
                    $user_ref_id = $row["user_ref_id"];
                    $language_code = $row["language_code"];

                    if ($row_profile != null){
                        $this->occupation = $row_profile["occupation"];
                        $this->education = $row_profile["education"];
                        $this->ethnicity = $row_profile["ethnicity"];
                        $this->marital_status = $row_profile["marital_status"];
                        $this->employment_status = $row_profile["employment_status"];
                        $this->employment_industry = $row_profile["employment_industry"];
                    }

                    $this->user_ref_id = $user_ref_id;
                    $this->language_code = $language_code;


                    if($account_state == STATE_ACTIVE){
                        $this->isActive = true;
                    }


                    if($countryCode != null){
                        $this->locationCountryCode = $countryCode;
                    }
                    //else{
                        //if no country is recorded then get the user's current country based on ip
                        //$this->locationCountryCode = $ip_country_code;
                    //}

                    /*if($countryId != null){
                        $this->locationCountry = Country::getCountry($countryId, $this->db_connector);
                    }*/

                    $ip_country_code = $this->host_info->getCountry_code();
                    $ip_currency_code = $this->host_info->getCurrency();

                    //todo - STORE USER'S CURRENCY CODE AT SIGN UP based on their country
                    if ($ip_currency_code != null){
                        //get currency based on current country
                        $this->currencyCode = $ip_currency_code;
                    }
                    else{
                        $this->currencyCode = SYSTEM_CURRENCY;
                    }


                    if($phone_number != null){
                        $this->phoneNumber = $phone_number;
                    }

                    if($location_address != null){
                        $this->locationAddress = $location_address;
                    }
                    if($date_of_birth != null){
                        $this->date_of_birth = $date_of_birth;
                    }

                    /*if ($this->get_userId() == "1077"){
                        $this->host_info->setCountry_code("JM");
                    }*/

                    return true;

                }

            }
        }

        return false;


    }

    public function updateNotificationToken($notification_id){
        $user_id = $this->get_userId();
        $login_token = $this->get_loginToken();
        $notification_hash = md5($notification_id);

        $updated = false;

        $sql_query = "select * from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id' and token_id = '$login_token' and notification_hash = '$notification_hash'";
        $sql_query_result = $this->db_connector->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_found()){
            $updated = true;
        }
        else{
            $sql_query_2 = "insert into " . TABLE_REALTIME_NOTIFICATION . " (token_id,notification_id,notification_hash,user_id) values ('$login_token','$notification_id','$notification_hash','$user_id')";
            $sql_query_result_2 = $this->db_connector->query($sql_query_2);
            if($sql_query_result_2 != null && $sql_query_result_2->is_row_affected()){
                $updated = true;
            }
        }

        return $updated;
    }

    public function removeNotificationToken($user_id,$login_token){

        //$user_id = $this->get_userId();
        //$login_token = $this->get_loginToken();

        $updated = false;

        $sql_query = "delete from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id' and token_id = '$login_token'";
        $sql_query_result = $this->db_connector->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_affected()){
            $updated = true;
        }

        return $updated;
    }

    public function removeAllNotificationToken(){
        $user_id = $this->get_userId();

        $updated = false;

        $sql_query = "delete from " . TABLE_REALTIME_NOTIFICATION . " where user_id = '$user_id'";
        $sql_query_result = $this->db_connector->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_affected()){
            $updated = true;
        }

        return $updated;
    }



    public function getAvailableJobs() {

        $available = array();

        //$result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        $result = $this->getOKStatus();
        $result["jobs"] = $available;

        $approved_id = array();
        $approved_data = array();
        $record_found = false;

        if($this->db_connector != null){

            $official_networks = getOfficialNetworks($this->db_connector);
            //$isOfficialCollector = isFromOfficialNetwork($this->userId,$this->db_connector);
            $network_relationship = getNetworkRelationship($this->userId, $this->db_connector);

            $current_time = getCurrentTime();


            //$team_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_id is not '281' and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_ACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            //$team_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_ACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $team_query = "select * from " . TABLE_TASKS . " where (cast(task_due_date as datetime) > '$current_time') and  task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_ACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $team_result = $this->db_connector->query($team_query);

            if($team_result != null && $team_result->is_row_found()){
                while($team_data = $team_result->fetch_array()){
                    $creator_network = $team_data["creator_net_id"];

                    if (!empty($network_relationship)){
                        foreach ($network_relationship as $relation){
                            $network_id = $relation["network_id"];
                            $network_role = $relation["network_role"];
                            $network_rel_state = $relation["relationship_state"];

                            if (($network_id == $creator_network) && ($network_role == NETWORK_ROLE_COLLECTOR) && ($network_rel_state == STATE_ACTIVE)){

                                $approved_id[] = $team_data["task_id"];
                                $approved_data[] = $team_data;

                            }

                        }
                    }

                }
            }

            //$task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_INACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $task_query = "select * from " . TABLE_TASKS . " where (cast(task_due_date as datetime) > '$current_time') and task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and my_network = " . STATE_INACTIVE . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $task_result = $this->db_connector->query($task_query);

            if($task_result != null && $task_result->is_row_found()){
                while($task_data = $task_result->fetch_array()){
                    $creator_network = $team_data["creator_net_id"];

                    if (!empty($network_relationship)){
                        $is_available = false;//is the quest already available to the user

                        foreach ($network_relationship as $relation){
                            $network_id = $relation["network_id"];
                            $network_role = $relation["network_role"];
                            $network_rel_state = $relation["relationship_state"];

                            if (!$is_available){
                                if (in_array($network_id,$official_networks) || ($network_id == $creator_network)){
                                    if (($network_id == $creator_network) && ($network_rel_state == STATE_ACTIVE)){
                                        $approved_id[] = $task_data["task_id"];
                                        $approved_data[] = $task_data;
                                        $is_available = true;

                                    }
                                    elseif (($network_id != $creator_network)){
                                        $approved_id[] = $task_data["task_id"];
                                        $approved_data[] = $task_data;

                                        $is_available = true;
                                    }
                                }
                            }

                        }
                    }



                }
            }

            for ($index = 0; $index < count($approved_id); $index++){
                $task_id = $approved_id[$index];
                $data = $approved_data[$index];

                $sub_jobs = $this->returnAvailableJobs($task_id,$data);
                if($sub_jobs != null){
                    foreach($sub_jobs as $job){
                        $available[] = $job;
                    }

                    $record_found = true;
                }
            }

        }

        if ($record_found && ((getAgent() == MOBILE_AGENT_ANDROID) || (getAgent() == MOBILE_AGENT_IOS))){
            //$result = $this->getOKStatus();
            $result["jobs"] = $available;
        }

        if ((getAgent() == MOBILE_AGENT_IOS)){
            $place_holder = array();

            $place_holder["task_id"] = "1000";
            $place_holder["survey_url"] = "https://www.queritel.com";
            $place_holder["project_description"] = "System Upgrade is in progress";
            //$place_holder["project_title"] = "System Upgrade in progress";
            $place_holder["project_title"] = "SYSTEM UPGRADE IN PROGRESS";

            $place_holder["job_id"] = "0000000000";
            $place_holder["user_id"] = null;
            $place_holder["profile_lock"] = false;
            $place_holder["location_address"] = "Queritel";
            $place_holder["location_country"] = "Queritel";
            $place_holder["location_state"] = "Queritel";
            $place_holder["location_lat"] = 0;
            $place_holder["location_lon"] = 0;
            $place_holder["researcher_required"] = 0;
            $place_holder["researcher_count"] = 0;
            $place_holder["customer"] = null;

            $place_holder["start_date"] = "0000-00-00 00:00:00";
            $place_holder["end_date"] = "0000-00-00 00:00:00";
            $place_holder["activity_type"] = ACTIVITY_TYPE_VOX;
            $place_holder["activity_category"] = ACTIVITY_CATEGORY_VOX;
            $place_holder["meter_radius"] = 10;
            $place_holder["tag_effort"] = 1;
            $place_holder["green_zone"] = 10; //a lock is placed on all quest out of this range

            $place_holder["price"] = $this->getConvertedFunds(0);
            $place_holder["currency"] = $this->getCurrencyCode();
            $place_holder["survey_count"] = 0;

            $result["jobs"][] = $place_holder;
        }

        if (($this->get_userId() == 329)){
            //$result["jobs"] = array();
        }



        /*if($this->get_userId() == "329"){
            $result["jobs"] = array();
        }*/



        return $result;

    }

    public function getActiveJobs(){
        $active = array();

        //$result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        $result = $this->getOKStatus();
        $result["jobs"] = $active;

        $approved_id = array();
        $approved_data = array();
        $record_found = false;

        if($this->db_connector != null){
            $current_time = getCurrentTime();

            //$task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";
            $task_query = "select * from " . TABLE_TASKS . " where (cast(task_due_date as datetime) > '$current_time') and task_service_type = 3 and task_type = 0 and task_location_count > 0 and survey_ready = " . SURVEY_INSTRUMENT_READY . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";

            $task_result = $this->db_connector->query($task_query);

            if($task_result != null && $task_result->is_row_found()){
                while($task_data = $task_result->fetch_array()){
                    $approved_id[] = $task_data["task_id"];
                    $approved_data[] = $task_data;
                }
            }

            for ($index = 0; $index < count($approved_id); $index++){
                $task_id = $approved_id[$index];
                $data = $approved_data[$index];

                $sub_jobs = $this->returnActiveJobs($task_id,$data);
                if($sub_jobs != null){
                    foreach($sub_jobs as $job){
                        $active[] = $job;
                    }

                    $record_found = true;
                }
            }

        }

        if ($record_found){
            //$result = $this->getOKStatus();
            $result["jobs"] = $active;
        }

        /*if($this->get_userId() == "329"){
            $result["jobs"] = array();
        }*/

        return $result;
    }

    public function getCompletedJobs() {
        $completed = array();

        //$result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        $result = $this->getOKStatus();
        $result["jobs"] = $completed;

        $approved_id = array();
        $approved_data = array();
        $record_found = false;

        if($this->db_connector != null){
            $task_query = "select * from " . TABLE_TASKS . " where task_service_type = 3 and task_type = 0 and task_location_count > 0 and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ") order by task_posted_on desc";// and survey_ready = 1
            $task_result = $this->db_connector->query($task_query);

            if($task_result != null && $task_result->is_row_found()){
                while($task_data = $task_result->fetch_array()){
                    $approved_id[] = $task_data["task_id"];
                    $approved_data[] = $task_data;
                }
            }

            for ($index = 0; $index < count($approved_id); $index++){
                $task_id = $approved_id[$index];
                $data = $approved_data[$index];

                $sub_jobs = $this->returnCompletedJobs($task_id,$data);
                if($sub_jobs != null){
                    foreach($sub_jobs as $job){
                        $completed[] = $job;
                    }

                    $record_found = true;
                }
            }

        }

        if ($record_found){
            //$result = $this->getOKStatus();
            $result["jobs"] = $completed;
        }

        /*if($this->get_userId() == "329"){
            $result["jobs"] = array();
        }*/


        return $result;
    }



    //todo : change to $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
    public function acceptJob($job_id,$client) {

        $result["status"] = STATUS_OPERATION_FAILED;

        $job_query = "select * from " . TABLE_JOBS . " where job_id = '$job_id' and researcher_count < researcher_required";
        $job_result = $this->db_connector->query($job_query);

        if ($job_result != null && $job_result->is_row_found()){
            if($row = $job_result->fetch_array()){

                $response_id = generate_token();
                $update_time = getCurrentTime();
                $user_id = $this->get_userId();

                $local_currency_code = $this->getCurrencyCode();
                $local_currency_rate = $this->getCurrencyRate($local_currency_code);

                $job_id = $row["job_id"];
                $task_id = $row["task_id"];
                //$survey_id = $row["survey_id"];
                $cpq = $row["cpq"];
                //$researcher_required = $row["researcher_required"];

                $questionnaire_total = $row["survey_total"];
                $questionnaire_assigned = $row["survey_assigned"];
                $assignable = 0;//the number of questionnaires the reseacher could be assigned

                $remaining = $questionnaire_total - $questionnaire_assigned;

                //$question_set = $questionnaire_total / RESEARCHER_PER_LOC;
                $question_set = $questionnaire_total / $row["researcher_required"];


                if($remaining > $question_set){
                    $assignable = $question_set;//lets cap it at the default
                }
                elseif($remaining <= $question_set){
                    $assignable = $remaining;//lets give the 'whats left'
                }

                $price = $assignable * $cpq;
                $researcher_count = $row["researcher_count"] + 1;
                $new_assigned = $questionnaire_assigned + $assignable;

                $check_criteria = false;//should we check if this researcher has responded to the task already

                if($check_criteria){
                    $response_check = "select * from " . TABLE_RESPONSE . " where user_id = '$user_id' and task_id = '$task_id' and survey_state = 1";
                    $response_result = $this->db_connector->query($response_check);

                    if($response_result != null && !$response_result->is_row_found()){
                        $check_linked = true;
                    }
                    else{
                        $check_linked = false;
                    }

                }
                else{
                    $check_linked = true;//bypass check
                }
                if($check_linked){
                    //this is a unique response
                    $current_location = $client->getCurrentLocation();
                    $lat = null;
                    $lng = null;
                    if (!$current_location->isEmpty()){
                        $lat = $current_location->getLatitude();
                        $lng = $current_location->getLongitude();
                    }

                    $task = $this->getTaskRaw($task_id);
                    $survey_id = null;
                    $survey_token = null;

                    if($task != null) {
                        $survey_url = $task["survey_url"];

                        if (isInsightSurvey($survey_url)){
                            $survey_id = getInsightSurveyID($survey_url);
                            $survey_token = getUniqueInsightSurveyToken($survey_url,$client);
                        }
                    }

                    $accept_query = "insert into " . TABLE_RESPONSE . " (response_id,update_time,job_id,task_id,user_id,survey_id,survey_token,survey_count,price,local_currency,local_currency_rate,accepted_lat,accepted_lon) values ('$response_id','$update_time','$job_id','$task_id','$user_id','$survey_id','$survey_token','$assignable','$price','$local_currency_code','$local_currency_rate','$lat','$lng')";

                    $accept_result = $this->db_connector->query($accept_query);
                    if($accept_result != null && $accept_result->is_row_affected()){
                        //success

                        $update_job = "update " . TABLE_JOBS . " set researcher_count = '$researcher_count', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                        $update_result = $this->db_connector->query($update_job);

                        if($update_result != null && $update_result->is_row_affected()){
                            //$result["status"] = STATUS_OK;
                            $result = $this->getOKStatus();

                            //broadcast update to researcher and admin
                        }

                    }
                }

            }
        }


        return $result;

    }

    //todo : change to $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
    public function cancelJob($response_id) {

        $result["status"] = STATUS_OPERATION_FAILED;


        $survey_state = SURVEY_STATE_PROGRESS;
        $user_id = $this->userId;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id' and survey_state = '$survey_state'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){
            if($row = $response_result->fetch_array()){
                //$task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $assigned = $row["survey_count"];


                $job = $this->getJobRaw($job_id);
                $general_assigned = $job["survey_assigned"];
                $researcher_count = $job["researcher_count"];

                //set value for job instance
                $new_assigned = $general_assigned - $assigned;
                $new_researcher = $researcher_count - 1;

                //set value for response
                $survey_state = SURVEY_STATE_CANCELLED;

                //update response to 'cancelled'
                $update_response_q = "update " . TABLE_RESPONSE . " set survey_state = '$survey_state' where response_id = '$response_id'";
                $response_q_result = $this->db_connector->query($update_response_q);

                if($response_q_result != null && $response_q_result->is_row_affected()){
                    $update_job = "update " . TABLE_JOBS . " set researcher_count = '$new_researcher', survey_assigned = '$new_assigned' where job_id = '$job_id'";
                    $update_result = $this->db_connector->query($update_job);

                    if($update_result != null && $update_result->is_row_affected()){
                        $result["status"] = STATUS_OK;

                        //broadcast update to researcher and admin
                    }

                }


            }
        }

        return $result;

    }

    //todo fix here
    public function startProfileSurvey($response_id) {

        //this is triggered when the start quest button is pressed
        //if the questionnaire being completed is the final ;
        //then this job is now completed and the researcher must be paid

        $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        //$result["status"] = STATUS_OPERATION_FAILED;
        //$result["submission_id"] = null;

        $survey_state = SURVEY_STATE_PROGRESS;//it has to be in progress
        $user_id = $this->userId;
        $submission_id = null;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id' and survey_state = '$survey_state'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){

            if($row = $response_result->fetch_array()){
                $task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $assigned = intval($row["survey_count"]);
                $completed = intval($row["survey_completed"]);

                if($completed < $assigned){
                    //as long as there are submissions to be made

                    $current_location = $this->getCurrentLocation();

                    $lat = null;
                    $lng = null;

                    if (!$current_location->isEmpty()){
                        $lat = $current_location->getLatitude();
                        $lng = $current_location->getLongitude();
                    }

                    if($completed == 0){
                        //if this response is just starting .. update the start time
                        //check if unfinished submissions exist, update the start time and use it, and if not create it
                        $start = getCurrentTime();
                        $update_response = "update " . TABLE_RESPONSE . " set survey_start = '$start' where response_id = '$response_id'";
                        $update_result = $this->db_connector->query($update_response);

                        if ($update_result != null && $update_result->is_row_affected()){
                            $submission_query = "select * from " . TABLE_SUBMISSIONS . " where response_id = '$response_id' and user_id = '$user_id' and task_id = '$task_id' and job_id = '$job_id' and completion_time is null";
                            $submission_result = $this->db_connector->query($submission_query);
                            if($submission_result != null && $submission_result->is_row_found()){
                                //if an unfinished submission was found, use its id
                                if($submission_entry = $submission_result->fetch_array()){
                                    $submission_id = $submission_entry["submission_id"];

                                    $update_submission = "update " . TABLE_SUBMISSIONS . " set start_time = '$start', start_lat = '$lat', start_lon = '$lng' where submission_id = '$submission_id'";
                                    $update_sub_result = $this->db_connector->query($update_submission);
                                    if($update_sub_result != null && $update_sub_result->is_row_affected()){}
                                }
                            }
                            else{
                                //if an unfinished submission was NOT found, create a submission entry
                                $submission_id = generate_token();

                                $insert_submission_query = "insert into " . TABLE_SUBMISSIONS . " (submission_id,task_id,job_id,response_id,user_id,start_time, start_lat, start_lon) values ('$submission_id','$task_id','$job_id','$response_id','$user_id','$start','$lat','$lng')";
                                $insert_sub_result = $this->db_connector->query($insert_submission_query);
                                if($insert_sub_result != null && $insert_sub_result->is_row_affected()){}

                            }
                        }
                    }
                    else{
                        $start = getCurrentTime();
                        //if this response already has submissions .. check if unfinished submissions exist, update the start time and use it, and if not create it
                        $submission_query = "select * from " . TABLE_SUBMISSIONS . " where response_id = '$response_id' and user_id = '$user_id' and task_id = '$task_id' and job_id = '$job_id' and completion_time is null";
                        $submission_result = $this->db_connector->query($submission_query);
                        if($submission_result != null && $submission_result->is_row_found()){
                            //if an unfinished submission was found, use its id
                            if($submission_entry = $submission_result->fetch_array()){
                                $submission_id = $submission_entry["submission_id"];

                                $update_submission = "update " . TABLE_SUBMISSIONS . " set start_time = '$start', start_lat = '$lat', start_lon = '$lng' where submission_id = '$submission_id'";
                                $update_sub_result = $this->db_connector->query($update_submission);
                                if($update_sub_result != null && $update_sub_result->is_row_affected()){}
                            }
                        }
                        else{
                            //if an unfinished submission was NOT found, create a submission entry
                            $submission_id = generate_token();

                            $insert_submission_query = "insert into " . TABLE_SUBMISSIONS . " (submission_id,task_id,job_id,response_id,user_id,start_time, start_lat, start_lon) values ('$submission_id','$task_id','$job_id','$response_id','$user_id','$start','$lat','$lng')";
                            $insert_sub_result = $this->db_connector->query($insert_submission_query);
                            if($insert_sub_result != null && $insert_sub_result->is_row_affected()){}

                        }

                    }

                    $result = $this->getOKStatus();
                    $result["submission_id"] = $submission_id;
                }

            }

        }

        return $result;
    }
    public function completeProfileSurvey($response_id,$submission_id,$percent_completion) {

        //this is triggered when a questionnaire is completed
        //if the questionnaire being completed is the final ;
        //then this job is now completed ant the researcher must be paid

        $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        //$result["status"] = STATUS_OPERATION_FAILED;

        $survey_state = SURVEY_STATE_PROGRESS;//it has to be in progress
        $user_id = $this->userId;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id' and survey_state = '$survey_state'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){

            if($row = $response_result->fetch_array()){
                $task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $assigned = $row["survey_count"];
                $completed = $row["survey_completed"];
                $current_percent_completion = $row["percent_completion"];

                if($completed < $assigned){
                    //if more is to be completed
                    $new_completed_count = $completed + 1;
                    $final = ($assigned - 1);


                    //check if its the final submission
                    if($completed == $final){
                        $current_location = $this->getCurrentLocation();
                        $lat = null;
                        $lng = null;
                        if (!$current_location->isEmpty()){
                            $lat = $current_location->getLatitude();
                            $lng = $current_location->getLongitude();
                        }

                        $new_survey_state = SURVEY_STATE_COMPLETED;
                        $completion_time = getCurrentTime();
                        $new_percent_completion = 0;
                        if (($percent_completion > 0) && ($assigned > 0)){
                            $new_percent_completion = ($percent_completion / $assigned);
                            $new_percent_completion += $current_percent_completion;
                        }
                        else{
                            $new_percent_completion += $current_percent_completion;
                        }

                        $update_submission = "update " . TABLE_SUBMISSIONS . " set completion_time = '$completion_time', completion_lat = '$lat', completion_lon = '$lng', percent_completion = '$percent_completion' where submission_id = '$submission_id'";
                        $update_sub_result = $this->db_connector->query($update_submission);
                        if($update_sub_result != null && $update_sub_result->is_row_affected()){
                            $update = "update " . TABLE_RESPONSE . " set survey_completed = '$new_completed_count', survey_state = '$new_survey_state', survey_end = '$completion_time', percent_completion = '$new_percent_completion' where response_id = '$response_id'";
                            $update_result = $this->db_connector->query($update);
                        }

                        $this->surveyFinished($task_id,$job_id,$response_id);
                    }
                    else{
                        //if this is not the final submission
                        $current_location = $this->getCurrentLocation();

                        $lat = null;
                        $lng = null;

                        if (!$current_location->isEmpty()){
                            $lat = $current_location->getLatitude();
                            $lng = $current_location->getLongitude();
                        }
                        $completion_time = getCurrentTime();
                        $new_percent_completion = 0;
                        if (($percent_completion > 0) && ($assigned > 0)){
                            $new_percent_completion = ($percent_completion / $assigned);
                            $new_percent_completion += $current_percent_completion;
                        }
                        else{
                            $new_percent_completion += $current_percent_completion;
                        }

                        $update_submission = "update " . TABLE_SUBMISSIONS . " set completion_time = '$completion_time', completion_lat = '$lat', completion_lon = '$lng', percent_completion = '$percent_completion' where submission_id = '$submission_id'";
                        $update_sub_result = $this->db_connector->query($update_submission);
                        if($update_sub_result != null && $update_sub_result->is_row_affected()){
                            $update = "update " . TABLE_RESPONSE . " set survey_completed = '$new_completed_count', percent_completion = '$new_percent_completion' where response_id = '$response_id'";
                            $update_result = $this->db_connector->query($update);
                        }

                    }

                    $result = $this->getOKStatus();

                }

            }

        }

        return $result;

    }


    public function startSubmission($response_id) {

        //this is triggered when the start quest button is pressed
        //if the questionnaire being completed is the final ;
        //then this job is now completed and the researcher must be paid

        $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        //$result["status"] = STATUS_OPERATION_FAILED;
        //$result["submission_id"] = null;

        $survey_state = SURVEY_STATE_PROGRESS;//it has to be in progress
        $user_id = $this->userId;
        $submission_id = null;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id' and survey_state = '$survey_state'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){

            if($row = $response_result->fetch_array()){
                $task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $assigned = intval($row["survey_count"]);
                $completed = intval($row["survey_completed"]);

                if($completed < $assigned){
                    //as long as there are submissions to be made

                    $current_location = $this->getCurrentLocation();

                    $lat = null;
                    $lng = null;

                    if (!$current_location->isEmpty()){
                        $lat = $current_location->getLatitude();
                        $lng = $current_location->getLongitude();
                    }

                    if($completed == 0){
                        //if this response is just starting .. update the start time
                        //check if unfinished submissions exist, update the start time and use it, and if not create it
                        $start = getCurrentTime();
                        $update_response = "update " . TABLE_RESPONSE . " set survey_start = '$start' where response_id = '$response_id'";
                        $update_result = $this->db_connector->query($update_response);

                        if ($update_result != null && $update_result->is_row_affected()){
                            $submission_query = "select * from " . TABLE_SUBMISSIONS . " where response_id = '$response_id' and user_id = '$user_id' and task_id = '$task_id' and job_id = '$job_id' and completion_time is null";
                            $submission_result = $this->db_connector->query($submission_query);
                            if($submission_result != null && $submission_result->is_row_found()){
                                //if an unfinished submission was found, use its id
                                if($submission_entry = $submission_result->fetch_array()){
                                    $submission_id = $submission_entry["submission_id"];

                                    $update_submission = "update " . TABLE_SUBMISSIONS . " set start_time = '$start', start_lat = '$lat', start_lon = '$lng' where submission_id = '$submission_id'";
                                    $update_sub_result = $this->db_connector->query($update_submission);
                                    if($update_sub_result != null && $update_sub_result->is_row_affected()){}
                                }
                            }
                            else{
                                //if an unfinished submission was NOT found, create a submission entry
                                $submission_id = generate_token();

                                $insert_submission_query = "insert into " . TABLE_SUBMISSIONS . " (submission_id,task_id,job_id,response_id,user_id,start_time, start_lat, start_lon) values ('$submission_id','$task_id','$job_id','$response_id','$user_id','$start','$lat','$lng')";
                                $insert_sub_result = $this->db_connector->query($insert_submission_query);
                                if($insert_sub_result != null && $insert_sub_result->is_row_affected()){}

                            }
                        }
                    }
                    else{
                        $start = getCurrentTime();
                        //if this response already has submissions .. check if unfinished submissions exist, update the start time and use it, and if not create it
                        $submission_query = "select * from " . TABLE_SUBMISSIONS . " where response_id = '$response_id' and user_id = '$user_id' and task_id = '$task_id' and job_id = '$job_id' and completion_time is null";
                        $submission_result = $this->db_connector->query($submission_query);
                        if($submission_result != null && $submission_result->is_row_found()){
                            //if an unfinished submission was found, use its id
                            if($submission_entry = $submission_result->fetch_array()){
                                $submission_id = $submission_entry["submission_id"];

                                $update_submission = "update " . TABLE_SUBMISSIONS . " set start_time = '$start', start_lat = '$lat', start_lon = '$lng' where submission_id = '$submission_id'";
                                $update_sub_result = $this->db_connector->query($update_submission);
                                if($update_sub_result != null && $update_sub_result->is_row_affected()){}
                            }
                        }
                        else{
                            //if an unfinished submission was NOT found, create a submission entry
                            $submission_id = generate_token();

                            $insert_submission_query = "insert into " . TABLE_SUBMISSIONS . " (submission_id,task_id,job_id,response_id,user_id,start_time, start_lat, start_lon) values ('$submission_id','$task_id','$job_id','$response_id','$user_id','$start','$lat','$lng')";
                            $insert_sub_result = $this->db_connector->query($insert_submission_query);
                            if($insert_sub_result != null && $insert_sub_result->is_row_affected()){}

                        }

                    }

                    $result = $this->getOKStatus();
                    $result["submission_id"] = $submission_id;
                }

            }

        }

        return $result;
    }

    public function completeSubmission($response_id,$submission_id,$percent_completion) {

        //this is triggered when a questionnaire is completed
        //if the questionnaire being completed is the final ;
        //then this job is now completed ant the researcher must be paid

        $result = $this->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        //$result["status"] = STATUS_OPERATION_FAILED;

        $survey_state = SURVEY_STATE_PROGRESS;//it has to be in progress
        $user_id = $this->userId;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id' and survey_state = '$survey_state'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){

            if($row = $response_result->fetch_array()){
                $task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $assigned = $row["survey_count"];
                $completed = $row["survey_completed"];
                $current_percent_completion = $row["percent_completion"];

                if($completed < $assigned){
                    //if more is to be completed
                    $new_completed_count = $completed + 1;
                    $final = ($assigned - 1);


                    //check if its the final submission
                    if($completed == $final){
                        $current_location = $this->getCurrentLocation();
                        $lat = null;
                        $lng = null;
                        if (!$current_location->isEmpty()){
                            $lat = $current_location->getLatitude();
                            $lng = $current_location->getLongitude();
                        }

                        $new_survey_state = SURVEY_STATE_COMPLETED;
                        $completion_time = getCurrentTime();
                        $new_percent_completion = 0;
                        if (($percent_completion > 0) && ($assigned > 0)){
                            $new_percent_completion = ($percent_completion / $assigned);
                            $new_percent_completion += $current_percent_completion;
                        }
                        else{
                            $new_percent_completion += $current_percent_completion;
                        }

                        $update_submission = "update " . TABLE_SUBMISSIONS . " set completion_time = '$completion_time', completion_lat = '$lat', completion_lon = '$lng', percent_completion = '$percent_completion' where submission_id = '$submission_id'";
                        $update_sub_result = $this->db_connector->query($update_submission);
                        if($update_sub_result != null && $update_sub_result->is_row_affected()){
                            $update = "update " . TABLE_RESPONSE . " set survey_completed = '$new_completed_count', survey_state = '$new_survey_state', survey_end = '$completion_time', percent_completion = '$new_percent_completion' where response_id = '$response_id'";
                            $update_result = $this->db_connector->query($update);
                        }

                        $this->surveyFinished($task_id,$job_id,$response_id);
                    }
                    else{
                        //if this is not the final submission
                        $current_location = $this->getCurrentLocation();

                        $lat = null;
                        $lng = null;

                        if (!$current_location->isEmpty()){
                            $lat = $current_location->getLatitude();
                            $lng = $current_location->getLongitude();
                        }
                        $completion_time = getCurrentTime();
                        $new_percent_completion = 0;
                        if (($percent_completion > 0) && ($assigned > 0)){
                            $new_percent_completion = ($percent_completion / $assigned);
                            $new_percent_completion += $current_percent_completion;
                        }
                        else{
                            $new_percent_completion += $current_percent_completion;
                        }

                        $update_submission = "update " . TABLE_SUBMISSIONS . " set completion_time = '$completion_time', completion_lat = '$lat', completion_lon = '$lng', percent_completion = '$percent_completion' where submission_id = '$submission_id'";
                        $update_sub_result = $this->db_connector->query($update_submission);
                        if($update_sub_result != null && $update_sub_result->is_row_affected()){
                            $update = "update " . TABLE_RESPONSE . " set survey_completed = '$new_completed_count', percent_completion = '$new_percent_completion' where response_id = '$response_id'";
                            $update_result = $this->db_connector->query($update);
                        }

                    }

                    $result = $this->getOKStatus();

                }

            }

        }

        return $result;

    }

    public function getJobDetail($response_id) {

        $detail = null;

        $result["status"] = STATUS_OPERATION_FAILED;
        $result["detail"] = $detail;


        $survey_state = SURVEY_STATE_PROGRESS;
        $user_id = $this->userId;

        $response_query = "select * from " . TABLE_RESPONSE . " where response_id = '$response_id' and user_id = '$user_id'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){

            if($row = $response_result->fetch_array()){
                $customer_id = null;
                $address = null;
                $state = null;
                $country = null;
                $location_lat = null;
                $location_lon = null;
                $researcher_required = null;
                $researcher_count = null;
                $survey_url = null;
                $project_title = null;
                $project_description = null;

                $task_id = $row["task_id"];
                $job_id = $row["job_id"];
                $survey_assigned = $row["survey_count"];
                $survey_completed = $row["survey_completed"];
                $survey_state = $row["survey_state"];
                $survey_start = $row["survey_start"];
                $survey_end = $row["survey_end"];
                $price = $row["price"];
                $payment_date = $row["payment_date"];
                $verified = $row["verified"];


                $job = $this->getJobRaw($job_id);
                $task = $this->getTaskRaw($task_id);

                if($job != null){
                    $customer_id = $job["user_id"];
                    $address = $job["address"];
                    $state = $job["state"];
                    $country = $job["country"];
                    $location_lat = $job["location_lat"];
                    $location_lon = $job["location_lon"];
                    $researcher_required = $job["researcher_required"];
                    $researcher_count = $job["researcher_count"];
                    $zone_radius = $this->getTagRadius($task_id,$job_id);
                }

                if($task != null){
                    $detail["survey_url"] = $task["survey_url"];

                    if (isInsightSurvey($task["survey_url"]) && !empty($row["survey_token"])){

                        $detail["survey_url"] = getUpdatedInsightSurveyLink($task["survey_url"],$row["survey_token"],$this->getLanguageCode());

                    }
                    $detail["project_description"] = $task["task_instructions"];
                    $detail["project_title"] = $task["task_topic"];

                    $quest_activity = $task["task_activity"];
                    $quest_category = ACTIVITY_CATEGORY_DISCOVER;

                    if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                        //$quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                        $quest_category = ACTIVITY_CATEGORY_DISCOVER;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                        //$quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                        $quest_category = ACTIVITY_CATEGORY_EXPLORE;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                        //$quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                        $quest_category = ACTIVITY_CATEGORY_EXPLORE;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                        //$quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                        $quest_category = ACTIVITY_CATEGORY_EXPLORE;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                        //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                        $quest_category = ACTIVITY_CATEGORY_EXPLORE;
                    }
                    elseif ($quest_activity == ACTIVITY_TYPE_VOX){
                        //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                        $quest_category = ACTIVITY_CATEGORY_VOX;

                    }


                    $detail["start_date"] = $task["task_start_date"];
                    $detail["end_date"] = $task["task_due_date"];
                    $detail["activity_type"] = $quest_activity;
                    $detail["activity_category"] = $quest_category;
                    $detail["meter_radius"] = $this->getTagRadius($task_id,$job_id);
                    $detail["tag_effort"] = $this->getTagEffort($task_id);
                    $detail["green_zone"] = (LOCATION_GREEN_ZONE > $zone_radius) ? LOCATION_GREEN_ZONE : $zone_radius;

                }

                $detail["response_id"] = $response_id;
                $detail["job_id"] = $job_id;
                $detail["task_id"] = $task_id;
                $detail["user_id"] = $customer_id;//customer

                $detail["survey_count"] = $survey_assigned;
                $detail["survey_completed"] = $survey_completed;
                $detail["survey_start"] = $survey_start;
                $detail["survey_end"] = $survey_end;
                $detail["price"] = $this->getConvertedFunds($price);
                $detail["currency"] = $this->getCurrencyCode();
                $detail["payment_date"] = $payment_date;
                $detail["is_approved"] = ($verified == 1);

                $detail["location_address"] = $address;
                $detail["location_country"] = $country;
                $detail["location_state"] = $state;
                $detail["location_lat"] = $location_lat;
                $detail["location_lon"] = $location_lon;
                $detail["researcher_required"] = $researcher_required;
                $detail["researcher_count"] = $researcher_count;

                if($this->get_userId() == "329" && $task_id == 228){
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/435635?lang=en";
                    //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/"; //getUserMedia samples
                    //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/src/content/getusermedia/gum/"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://dev.queritel.com/capture.html"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://dev.queritel.com/capture3.html"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/664954?lang=en"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/114771?lang=en"; // Quest 2
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/981233?lang=en"; // Quest 3
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/187196?lang=en"; // Quest unknown
                    /*$detail["survey_url"] = "https://dev.queritel.com/sample.html?ver=1.0.0"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/745439?lang=en"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://dev.queritel.com/capture2.html"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://source.queritel.com/cam"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/src/content/getusermedia/record/"; //getUserMedia
                    //$results[$index]["survey_url"] = "https://w3c-test.org/html-media-capture/capture_image_environment-manual.html"; //media capture

                    if (isInsightSurvey($detail["survey_url"]) && !empty($row["survey_token"])){

                        $detail["survey_url"] = getUpdatedInsightSurveyLink($detail["survey_url"],$row["survey_token"]);

                    }*/

                    $detail["meter_radius"] = 10000;
                }


                $result["status"] = STATUS_OK;
                $result["detail"] = $detail;

            }

        }

        return $result;
    }

    //this is used to get the user's primary bank account data
    public function getPrimaryBankAccount($user_id = null) {


        $result = array();
        $result["is_valid"] = false;
        $result["account_id"] = null;
        $result["account_type"] = null;
        $result["version_code"] = null;
        $result["fname"] = null;
        $result["mname"] = null;
        $result["lname"] = null;
        $result["full_name"] = null;
        $result["email"] = null;
        $result["date_of_birth"] = null;
        $result["phone_number"] = null;
        $result["country_code"] = null;
        $result["location_state"] = null;
        $result["location_city"] = null;
        $result["location_address"] = null;
        $result["bank_name"] = null;
        $result["bank_address"] = null;
        $result["bank_account_number"] = null;
        $result["bank_account_type"] = null;
        $result["tax_id_number"] = null;


        if ($user_id == null){
            $user_id = $this->userId;
        }

        $account_type = ACCOUNT_TYPE_BANK_ACCOUNT;
        $deleted = 0;

        $account_query = "select * from " . TABLE_PAYOUT_ACCOUNT . " where account_type = '$account_type' and deleted = '$deleted' and user_id = '$user_id'";
        $account_result = $this->db_connector->query($account_query);

        if($account_result != null && $account_result->is_row_found()){

            if($row = $account_result->fetch_array()){


                $result["is_valid"] = true;
                $result["account_id"] = $row["account_id"];
                $result["account_type"] = $row["account_type"];
                $result["version_code"] = $row["version_code"];
                $result["fname"] = stringCase($row["fname"],STRING_CASE_CAP_FIRST);
                $result["mname"] = stringCase($row["mname"]);
                $result["lname"] = stringCase($row["lname"],STRING_CASE_CAP_FIRST);
                $result["full_name"] = $row["full_name"];
                $result["email"] = stringCase($row["email"]);
                $result["date_of_birth"] = $row["date_of_birth"];
                $result["phone_number"] = $row["phone_number"];
                $result["country_code"] = stringCase($row["country_code"],STRING_CASE_UPPER);
                $result["location_state"] = stringCase($row["location_state"],STRING_CASE_CAP_EACH);
                $result["location_city"] = stringCase($row["location_city"],STRING_CASE_CAP_EACH);
                $result["location_address"] = $row["location_address"];
                $result["bank_name"] = $row["bank_name"];
                $result["bank_address"] = $row["bank_address"];
                $result["bank_account_number"] = $row["bank_account_number"];
                $result["bank_account_type"] = $row["bank_account_type"];
                $result["tax_id_number"] = $row["tax_id_number"];

            }

        }

        return $result;
    }



    //this is called when a questionnaire submission of a quest is finished
    //todo deprecated
    private function logSubmissions($task_id,$job_id,$response_id){
        $current_location = $this->getCurrentLocation();

        $lat = null;
        $lng = null;

        if (!$current_location->isEmpty()){
            $lat = $current_location->getLatitude();
            $lng = $current_location->getLongitude();
        }

        $submission_id = generate_token();
        $update_time = getCurrentTime();
        $user_id = $this->get_userId();

        $log_submission_query = "insert into " . TABLE_SUBMISSIONS . " (submission_id,task_id,job_id,response_id,user_id,completion_time,completion_lat,completion_lon) values ('$submission_id','$task_id','$job_id','$response_id','$user_id','$update_time','$lat','$lng')";
        $log_result = $this->db_connector->query($log_submission_query);

        if($log_result != null && $log_result->is_row_affected()){
            //success

            //$update_job = "update " . TABLE_JOBS . " set researcher_count = '$researcher_count', survey_assigned = '$new_assigned' where job_id = '$job_id'";
            //$update_result = $this->db_connector->query($update_job);

            /*if($update_result != null && $update_result->is_row_affected()){
                $result["status"] = STATUS_OK;


                //broadcast update to researcher and admin

            }*/

        }
    }

    //this is called when all submissions of a survey is finished
    private function surveyFinished($task_id,$job_id,$response_id){}

    //this is called to update the users realtime presence
    private function logPresence(){}

    //this is called to log the user's activity
    private function logActivity(){}

    //returns the jobs from the given id that this researcher qualifies for
    //NOTE: this will be null is =>
    //1 - if user is already attached to one of these jobs
    //2 - if these jobs dont require more researchers
    //3 - if there are no jobs


    function getJobTags($job_id){
        $record_found = false;
        $index = 0;

        $data = array();
        $result = array();


        $tag_query = "select * from " . TABLE_JOB_TAGS . " where job_id = '$job_id'";
        $tag_result = $this->db_connector->query($tag_query);

        if ($tag_result != null && $tag_result->is_row_found()){
            while ($row = $tag_result->fetch_array()){
                $record_found = true;

                $tag_id = $row["tag_id"];
                $tag_label = $row["tag_label"];
                $tag_data = $row["tag_data"];

                $decoded = json_decode($tag_data,true);

                $data[$index]["unique_id"] = $tag_id;
                $data[$index]["tag_label"] = $tag_label;
                $data[$index]["tag_data"] = $decoded;

                $index++;
            }

        }

        if ($record_found){
            $result = $data;
        }

        return $result;
    }
    private function getTagRadius($task_id,$job_id){
        $record_found = false;
        $index = 0;

        $effort = 0;

        //$result = array();

        //$result["status"] = "NO_DATA";


        $tag_query = "select * from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and tag_label = 'tag_radius' and job_id = '$job_id'";
        $tag_result = $this->db_connector->query($tag_query);

        if ($tag_result != null && $tag_result->is_row_found()){
            if ($row = $tag_result->fetch_array()){
                $tag_data = $row["tag_data"];
                $decoded = json_decode($tag_data,true);

                //$result["status"] = "OK";
                //$result["level"] = $decoded["level"];
                $effort = $decoded["value"];

            }

        }

        return $effort;
    }
    private function getTagEffort($task_id){
        $record_found = false;
        $index = 0;

        $effort = 0;

        $result = array();

        $result["status"] = "NO_DATA";


        $tag_query = "select * from " . TABLE_JOB_TAGS . " where task_id = '$task_id' and tag_label = 'tag_effort'";
        $tag_result = $this->db_connector->query($tag_query);

        if ($tag_result != null && $tag_result->is_row_found()){
            if ($row = $tag_result->fetch_array()){
                $tag_data = $row["tag_data"];
                $decoded = json_decode($tag_data,true);

                //$result["status"] = "OK";
                //$result["level"] = $decoded["level"];
                $effort = $decoded["level"];

            }

        }

        return $effort;
    }
    private function ___returnAvailableJobs___($task_id) {
        //this gets all the jobs tied to this task

        $result = null;
        if($this->db_connector != null){
            //available = survey ready, admin approved, not finished, not cancelled
            $sql = "select * from " . TABLE_TASKS . " where task_id = '$task_id' and survey_ready = " . SURVEY_INSTRUMENT_READY . " and task_status not in (" . TASK_STATUS_PENDING . "," . TASK_STATUS_COMPLETED . "," . TASK_STATUS_CANCELLED . "," . TASK_STATUS_DRAFT . ")";
            $task_result = $this->db_connector->query($sql);

            if($task_result == null){
                return $result;
            }

            $task_data = $task_result->fetch_array();

            if($task_data != null && $task_data["task_location_count"] > 0){

                $check_criteria = false;//should we check if this researcher is linked to the task

                if($check_criteria){
                    //do not consider cancelled as a linked job
                    $linkedJobs = $this->linkedJobs($task_id,false);

                    if($linkedJobs == null){
                        $check_linked = true;
                    }
                    else{
                        $check_linked = false;
                    }

                }
                else{
                    $check_linked = true;//bypass check
                }


                //T O D O - RE-ENABLE IP LOCATION CRITERIA SELECTION
                if($check_linked){//if this researcher is not already linked to this task then process to see if it is available
                    $country_code = $this->host_info->getCountry_code();
                    //$country_code = "JM";
                    //task is available to be check by the researcher
                    $job_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id' and country_code = '$country_code' and researcher_required > researcher_count and survey_total > 0";
                    $job_result = $this->db_connector->query($job_query);
                    $index = 0;

                    if($job_result == null){
                        return $result;
                    }

                    while($row = $job_result->fetch_array()){
                        /**
                         * // TODO :=> DO ADDITIONAL CRITERIA CHECK HERE
                         */

                        $result[$index]["job_id"] = $row["job_id"];
                        $result[$index]["task_id"] = $task_id;
                        $result[$index]["user_id"] = $row["user_id"];
                        $result[$index]["location_address"] = $row["address"];
                        $result[$index]["location_country"] = $row["country"];
                        $result[$index]["location_state"] = $row["state"];
                        $result[$index]["location_lat"] = $row["location_lat"];
                        $result[$index]["location_lon"] = $row["location_lon"];
                        $result[$index]["researcher_required"] = $row["researcher_required"];
                        $result[$index]["researcher_count"] = $row["researcher_count"];
                        $result[$index]["survey_url"] = $task_data["survey_url"];
                        $result[$index]["project_description"] = $task_data["task_instructions"];
                        $result[$index]["project_title"] = $task_data["task_topic"];
                        $result[$index]["customer"] = "";//$task_data["task_topic"];//lets ignor this for now

                        $cpq = $row["cpq"];//cost per questionnaire
                        $questionnaire_total = $row["survey_total"];
                        $questionnaire_assigned = $row["survey_assigned"];
                        $assignable = 0;//the number of questionnaires the reseacher viewing these results, could be assigned

                        $remaining = $questionnaire_total - $questionnaire_assigned;

                        //TODO fix here
                        //$question_set = $questionnaire_total / RESEARCHER_PER_LOC;
                        $question_set = $questionnaire_total / $row["researcher_required"];

                        if($remaining > $question_set){
                            $assignable = $question_set;//lets cap it at the default
                        }
                        elseif($remaining <= $question_set){
                            $assignable = $remaining;//lets show the 'whats left'
                        }

                        $price = $assignable * $cpq;

                        $result[$index]["price"] = $price;
                        $result[$index]["questionnaire_count"] = $assignable;

                        $index++;
                    }


                }

            }

        }

        return $result;
    }



    //todo : reset from ghana - [GH]
    private function returnAvailableJobs($task_id,$task_data) {
        //this gets all the jobs tied to this task

        $result = null;
        if($this->db_connector != null){
            //available = survey ready, admin approved, not finished, not cancelled

            $check_connection = false; //should we check if the researcher is already connected to this quest and prevent further connections
            $has_connection = false; //is the researcher connected to this quest
            $preliminary_check_passed = false; //preliminary criteria check passed


            $quest_activity = $task_data["task_activity"];
            $quest_category = ACTIVITY_CATEGORY_DISCOVER;

            if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                //$quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                $quest_category = ACTIVITY_CATEGORY_DISCOVER;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                //$quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                //$quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                //$quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_VOX){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_VOX;

                $check_connection = true; //if this is a vox, then ensure that the researcher has only 1 connection
            }


            if (($task_id == 375) ){
                $check_connection = true;
            }

            //todo - add $this->passedPreliminaryCheck($task_data)
            if($check_connection){
                //do not consider a cancelled quest as a connected quest
                $linkedJobs = $this->linkedJobs($task_id,false);

                if($linkedJobs == null){
                    $has_connection = false; //does not already have a connection to this quest, so check for available quest
                    $preliminary_check_passed = true;
                }
                else{
                    $has_connection = true; //already has a connection, so prevent check for available quest
                    $preliminary_check_passed = false;
                }

            }
            else{
                $preliminary_check_passed = true;
            }


            //todo - add $this->isValidTarget($target_id, $task_data)
            if($preliminary_check_passed){//if this researcher is not already linked to this task then process to see if it is available
                $signup_country_code = $this->getLocationCountryCode();
                $country_code = $this->host_info->getCountry_code();

                //$country_code = "JM";

                $country_code_check = "country_code = '$country_code'";

                if ($country_code !== $signup_country_code){
                    if (!empty($country_code) && !empty($signup_country_code)){
                        $country_code_check = "country_code in ('$country_code','$signup_country_code')";
                    }
                    else{
                        if (!empty($signup_country_code)){
                            $country_code_check = "country_code = '$signup_country_code'";
                        }
                        elseif (!empty($country_code)){
                            $country_code_check = "country_code = '$country_code'";
                        }
                    }
                }

                if($this->get_userId() == "329"){
                    //$country_code = "JM";
                    //$this->currencyCode = "JMD";
                    //$country_code = "PR";
                    //$this->currencyCode = "JMD";
                }

                $job_query = "select * from " . TABLE_JOBS . " where task_id = '$task_id' and $country_code_check and researcher_required > researcher_count and survey_total > 0";
                $job_result = $this->db_connector->query($job_query);
                $index = 0;

                if($job_result == null){
                    return $result;
                }

                while($row = $job_result->fetch_array()){

                    //start_date
                    //activity_type
                    //activity_category
                    //meter_radius

                    $zone_radius = $this->getTagRadius($task_id,$row["job_id"]);

                    /**
                     * TODO :=> DO ADDITIONAL CRITERIA CHECK HERE : for each zone
                     */
                    if ($quest_category == ACTIVITY_CATEGORY_VOX){
                        //location guard check

                        if (!$this->currentLocation->isEmpty()){
                            //has a current location then check if researcher is in the zone

                            $zone_lat = $row["location_lat"];
                            $zone_lng = $row["location_lon"];

                            $zone_location = new LocationPoint($zone_lat,$zone_lng);
                            $distance_between = getDistanceBetweenGeneral($this->currentLocation,$zone_location);

                            if($distance_between > $zone_radius){
                                continue; //skip this vox zone
                            }

                        }
                        else{
                            //has no current location

                            //todo : targeting check
                            //continue; //skip this vox zone
                        }

                    }
                    else{//todo -- remove this (zones will not be blocked)
                        /*if (!$this->currentLocation->isEmpty()){
                            //has a current location then check if researcher is in the zone

                            $zone_lat = $row["location_lat"];
                            $zone_lng = $row["location_lon"];

                            $zone_location = new LocationPoint($zone_lat,$zone_lng);
                            $distance_between = getDistanceBetweenGeneral($this->currentLocation,$zone_location);

                            if($distance_between > LOCATION_GREEN_ZONE){
                                continue; //skip this red zone
                            }

                        }
                        else{
                            //has no current location

                            continue; //skip this no zone
                        }*/
                    }




                    $result[$index]["task_id"] = $task_id;
                    $result[$index]["survey_url"] = $task_data["survey_url"];
                    $result[$index]["project_description"] = $task_data["task_instructions"];
                    $result[$index]["project_title"] = $task_data["task_topic"];

                    $result[$index]["job_id"] = $row["job_id"];
                    $result[$index]["user_id"] = $row["user_id"];
                    $result[$index]["profile_lock"] = false;
                    $result[$index]["location_address"] = $row["address"];
                    $result[$index]["location_country"] = $row["country"];
                    $result[$index]["location_state"] = $row["state"];
                    $result[$index]["location_lat"] = $row["location_lat"];
                    $result[$index]["location_lon"] = $row["location_lon"];
                    $result[$index]["researcher_required"] = $row["researcher_required"];
                    $result[$index]["researcher_count"] = $row["researcher_count"];
                    $result[$index]["customer"] = "";//$task_data["task_topic"];//lets ignor this for now

                    $result[$index]["start_date"] = $task_data["task_start_date"];
                    $result[$index]["end_date"] = $task_data["task_due_date"];
                    $result[$index]["activity_type"] = $quest_activity;
                    $result[$index]["activity_category"] = $quest_category;
                    $result[$index]["meter_radius"] = $zone_radius;
                    $result[$index]["tag_effort"] = $this->getTagEffort($task_id);
                    $result[$index]["green_zone"] = (LOCATION_GREEN_ZONE > $zone_radius) ? LOCATION_GREEN_ZONE : $zone_radius; //a lock is placed on all quest out of this range

                    $cpq = $row["cpq"];//cost per questionnaire
                    $questionnaire_total = $row["survey_total"];
                    $questionnaire_assigned = $row["survey_assigned"];
                    $assignable = 0;//the number of questionnaires the researcher viewing these results, could be assigned

                    $remaining = $questionnaire_total - $questionnaire_assigned;

                    //TODO fix here
                    //$question_set = $questionnaire_total / RESEARCHER_PER_LOC;
                    $question_set = $questionnaire_total / $row["researcher_required"];

                    if($remaining > $question_set){
                        $assignable = $question_set;//lets cap it at the default
                    }
                    elseif($remaining <= $question_set){
                        $assignable = $remaining;//lets show the 'whats left'
                    }

                    $price = $assignable * $cpq;

                    $result[$index]["price"] = $this->getConvertedFunds($price);
                    $result[$index]["currency"] = $this->getCurrencyCode();
                    $result[$index]["survey_count"] = $assignable;

                    $index++;
                }


            }

        }

        return $result;
    }
    private function returnActiveJobs($task_id,$task_data) {
        //this gets all the active jobs tied to this task

        $results = null;
        if($this->db_connector != null){
            //active = survey ready, admin approved, not finished, not cancelled

            $quest_activity = $task_data["task_activity"];
            $quest_category = ACTIVITY_CATEGORY_DISCOVER;

            if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                //$quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                $quest_category = ACTIVITY_CATEGORY_DISCOVER;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                //$quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                //$quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                //$quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_VOX){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_VOX;
            }



            $linkedJobs = $this->linkedJobs($task_id);
            if($linkedJobs != null){//if this researcher is already linked to this task then get the jobs that apply
                $index = 0;

                foreach($linkedJobs as $response){
                    $zone_radius = $this->getTagRadius($task_id,$response["job_id"]);

                    //iterate through all the linked job responses(because that is returned by the linked function)
                    $survey_state = $response["survey_state"];
                    if($survey_state == SURVEY_STATE_PROGRESS){
                        //if this job is active; set up variables for the response

                        $results[$index]["response_id"] = $response["response_id"];
                        //$results[$index]["update_time"] = $response["update_time"];
                        $results[$index]["job_id"] = $response["job_id"];
                        $results[$index]["task_id"] = $response["task_id"];
                        $results[$index]["user_id"] = $task_data["user_id"];//customer

                        $results[$index]["survey_url"] = $task_data["survey_url"];
                        if (isInsightSurvey($task_data["survey_url"]) && !empty($response["survey_token"])){

                            $results[$index]["survey_url"] = getUpdatedInsightSurveyLink($task_data["survey_url"],$response["survey_token"],$this->getLanguageCode());

                        }

                        //$results[$index]["survey_url"] = getUpdatedInsightSurveyLink("https://insight.queritel.com/index.php/243676?lang=en","Ckz3dafzmrNXjkx");


                        $results[$index]["project_description"] = $task_data["task_instructions"];
                        $results[$index]["project_title"] = $task_data["task_topic"];


                        $results[$index]["start_date"] = $task_data["task_start_date"];
                        $results[$index]["end_date"] = $task_data["task_due_date"];
                        $results[$index]["activity_type"] = $quest_activity;
                        $results[$index]["activity_category"] = $quest_category;
                        $results[$index]["meter_radius"] = $zone_radius;
                        $results[$index]["tag_effort"] = $this->getTagEffort($task_id);
                        $results[$index]["green_zone"] = (LOCATION_GREEN_ZONE > $zone_radius) ? LOCATION_GREEN_ZONE : $zone_radius; //a lock is placed on all quest out of this range


                        $results[$index]["survey_count"] = $response["survey_count"];
                        $results[$index]["survey_completed"] = $response["survey_completed"];
                        $results[$index]["survey_start"] = $response["survey_start"];
                        $results[$index]["survey_end"] = $response["survey_end"];
                        $results[$index]["price"] = $this->getConvertedFunds($response["price"]);
                        $results[$index]["currency"] = $this->getCurrencyCode();
                        $results[$index]["payment_date"] = $response["payment_date"];

                        //lets get the job instance this is associated with
                        $job = $this->getJobRaw($response["job_id"]);
                        if($job != null){
                            //lets set all the job details that can not be obtaind from the response table

                            $results[$index]["location_address"] = $job["address"];
                            $results[$index]["location_country"] = $job["country"];
                            $results[$index]["location_state"] = $job["state"];
                            $results[$index]["location_lat"] = $job["location_lat"];
                            $results[$index]["location_lon"] = $job["location_lon"];
                            $results[$index]["researcher_required"] = $job["researcher_required"];
                            $results[$index]["researcher_count"] = $job["researcher_count"];
                        }


                        if($this->get_userId() == "329" && $response["task_id"] == 228){
                            //$results[$index]["survey_url"] = "https://www.surveymonkey.com/r/V3XWFVL"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://dev.queritel.com/sample.html?ver=1.0.0"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/482584?lang=es"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/425385?lang=en"; //new image sample
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/816821?lang=en"; //new image sample (automated)
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/922537?lang=en"; //location + profile data

                            /*$survey_url = "https://insight.queritel.com/index.php/885886?lang=en";
                            /*$survey_url = "https://insight.queritel.com/index.php/759147?lang=en"; //fruit survey (no token)
                            $survey_url = "https://insight.queritel.com/index.php/885886";
                            if (isInsightSurvey($survey_url) && !empty($response["survey_token"])){

                                $results[$index]["survey_url"] = getUpdatedInsightSurveyLink($survey_url,$response["survey_token"]);

                            }
                            else{
                                $results[$index]["survey_url"] = $survey_url; //location + profile data 2

                            }*/

                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/435635?lang=en";
                            //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/"; //getUserMedia samples
                            //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/src/content/getusermedia/gum/"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://dev.queritel.com/capture.html"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://dev.queritel.com/capture3.html"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/664954?lang=en"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/114771?lang=en"; // Quest 2
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/981233?lang=en"; // Quest 3
                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/187196?lang=en"; // Quest unknown

                            //$results[$index]["survey_url"] = "https://insight.queritel.com/index.php/745439?lang=en"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://dev.queritel.com/capture2.html"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://source.queritel.com/cam"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://webrtc.github.io/samples/src/content/getusermedia/record/"; //getUserMedia
                            //$results[$index]["survey_url"] = "https://w3c-test.org/html-media-capture/capture_image_environment-manual.html"; //media capture
                            $results[$index]["meter_radius"] = 10000;
                        }


                        $index++;

                    }

                }

            }

        }

        return $results;
    }
    private function returnCompletedJobs($task_id,$task_data) {
        //this gets all the jobs tied to this task

        $results = null;
        if($this->db_connector != null){

            $quest_activity = $task_data["task_activity"];
            $quest_category = ACTIVITY_CATEGORY_DISCOVER;

            if ($quest_activity == ACTIVITY_TYPE_SENTIMENT){
                //$quest_type = ACTIVITY_TYPE_SENTIMENT_TXT;
                $quest_category = ACTIVITY_CATEGORY_DISCOVER;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_DISCOVERY){
                //$quest_type = ACTIVITY_TYPE_DISCOVERY_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_MONITOR){
                //$quest_type = ACTIVITY_TYPE_MONITOR_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_INSPECTION){
                //$quest_type = ACTIVITY_TYPE_INSPECTION_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_RETAIL){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_EXPLORE;
            }
            elseif ($quest_activity == ACTIVITY_TYPE_VOX){
                //$quest_type = ACTIVITY_TYPE_RETAIL_TXT;
                $quest_category = ACTIVITY_CATEGORY_VOX;
            }

            $linkedJobs = $this->linkedJobs($task_id);
            if($linkedJobs != null){//if this researcher is already linked to this task then get the jobs that apply
                $index = 0;

                foreach($linkedJobs as $response){
                    //iterate through all the linked job responses(because that is returned by the linked function)
                    $survey_state = $response["survey_state"];
                    if($survey_state == SURVEY_STATE_COMPLETED){
                        //if this job is active; set up variables for the response

                        $results[$index]["response_id"] = $response["response_id"];
                        //$results[$index]["update_time"] = $response["update_time"];
                        $results[$index]["job_id"] = $response["job_id"];
                        $results[$index]["task_id"] = $response["task_id"];
                        $results[$index]["user_id"] = $task_data["user_id"];//customer
                        $results[$index]["survey_url"] = $task_data["survey_url"];

                        $results[$index]["project_description"] = $task_data["task_instructions"];
                        $results[$index]["project_title"] = $task_data["task_topic"];

                        $results[$index]["start_date"] = $task_data["task_start_date"];
                        $results[$index]["end_date"] = $task_data["task_due_date"];
                        $results[$index]["activity_type"] = $quest_activity;
                        $results[$index]["activity_category"] = $quest_category;
                        $results[$index]["meter_radius"] = $this->getTagRadius($task_id,$response["job_id"]);
                        $results[$index]["tag_effort"] = $this->getTagEffort($task_id);


                        $results[$index]["survey_count"] = $response["survey_count"];
                        $results[$index]["survey_completed"] = $response["survey_completed"];
                        $results[$index]["survey_start"] = $response["survey_start"];
                        $results[$index]["survey_end"] = $response["survey_end"];
                        $results[$index]["price"] = $this->getConvertedFunds($response["price"]);
                        $results[$index]["currency"] = $this->getCurrencyCode();
                        $results[$index]["payment_date"] = $response["payment_date"];
                        $results[$index]["is_approved"] = ($response["verified"] == 1);

                        //lets get the job instance this is associated with
                        $job = $this->getJobRaw($response["job_id"]);
                        if($job != null){
                            //lets set all the job details that can not be obtaind from the response table
                            $results[$index]["location_address"] = $job["address"];
                            $results[$index]["location_country"] = $job["country"];
                            $results[$index]["location_state"] = $job["state"];
                            $results[$index]["location_lat"] = $job["location_lat"];
                            $results[$index]["location_lon"] = $job["location_lon"];
                            $results[$index]["researcher_required"] = $job["researcher_required"];
                            $results[$index]["researcher_count"] = $job["researcher_count"];
                        }

                        $index++;

                    }

                }

            }

        }

        return $results;
    }

    public function getErrorStatus($error_msg){
        $result = array();
        $error = array();
        $error["name"] = ERROR_NAME_OP_FAILED;
        $error["message"] = $error_msg;
        $result["status"] = STATUS_ERROR;
        $result["error"] = $error;

        return $result;
    }
    public function getOKStatus(){
        $result = array();
        $result["status"] = STATUS_OK;

        return $result;
    }

    //gets a list of jobs(of task_id) the researcher is linked to whether completed of otherwise
    //linked = matched task & user id for survey_response
    //returns Array if linked or null if not
    public function linkedJobs($task_id, $include_cancelled = true){

        if($include_cancelled){
            //check all records {cancelled,in progress,completed}
            $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and user_id = '$this->userId'";

        }
        else{
            //if this is falsed == then do not consider 'SURVEY_STATE_CANCELLED' as linked
            //return all records that arent cancelled
            //if records that arent cancelled are found.. then this researcher is linked
            //check records {finished,completed}
            $survey_state = SURVEY_STATE_CANCELLED;
            $response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and user_id = '$this->userId' and survey_state not in ($survey_state)";

        }

        //$response_query = "select * from " . TABLE_RESPONSE . " where task_id = '$task_id' and user_id = '$this->userId'";
        $response_result = $this->db_connector->query($response_query);
        $index = 0;
        $results = null;

        if($response_result != null && $response_result->is_row_found()){
            while($row = $response_result->fetch_array()){
                $results[$index]["response_id"] = $row["response_id"];
                //$results[$index]["update_time"] = $row["update_time"];
                $results[$index]["job_id"] = $row["job_id"];
                $results[$index]["task_id"] = $row["task_id"];
                $results[$index]["user_id"] = $row["user_id"];//researcher
                $results[$index]["survey_id"] = $row["survey_id"];
                $results[$index]["survey_token"] = $row["survey_token"];
                $results[$index]["survey_count"] = $row["survey_count"];
                $results[$index]["survey_completed"] = $row["survey_completed"];
                $results[$index]["survey_state"] = $row["survey_state"];
                $results[$index]["survey_start"] = $row["survey_start"];
                $results[$index]["survey_end"] = $row["survey_end"];
                $results[$index]["price"] = $row["price"];
                $results[$index]["payment_date"] = $row["payment_date"];
                $results[$index]["verified"] = $row["verified"];

                $index++;
            }

        }

        return $results;
    }
    //get jobs based on where clause; return database result
    public function getJobsWhere($where_clause){
        $result = null;
        $job_query = "select * from " . TABLE_JOBS . " where $where_clause";
        $job_result = $this->db_connector->query($job_query);

        if($job_result != null && $job_result->is_row_found()){

            return $job_result;

        }

        return null;
    }
    //returns row
    public function getTaskRaw($task_id){
        $task_query = "select * from " . TABLE_TASKS . " where task_id = '$task_id'";
        $task_result = $this->db_connector->query($task_query);

        if($task_result != null && $task_result->is_row_found()){
            $row = $task_result->fetch_array();

            if($row != null){
                return $row;
            }
        }

        return null;
    }
    public function getResponseRaw($response_id){
        $response_query = "select * from " . TABLE_RESPONSE . " where job_id = '$response_id'";
        $response_result = $this->db_connector->query($response_query);

        if($response_result != null && $response_result->is_row_found()){
            $row = $response_result->fetch_array();
            if($row != null){
                return $row;
            }

        }

        return null;
    }
    public function getJobRaw($job_id){
        $job_query = "select * from " . TABLE_JOBS . " where job_id = '$job_id'";
        $job_result = $this->db_connector->query($job_query);

        if($job_result != null && $job_result->is_row_found()){
            $row = $job_result->fetch_array();
            if($row != null){
                return $row;
            }

        }

        return null;
    }

}