<?php
require '../vendor/autoload.php';
require '../includes/headers/strings.php';
$event = null;
$payload = @file_get_contents('php://input');
file_put_contents("test.log", $payload, FILE_APPEND | LOCK_EX);

//$event = json_decode($payload);

try {
    // Make sure the event is coming from Stripe by checking the signature header
    $event = \Stripe\Webhook::constructEvent($payload, $_SERVER['HTTP_STRIPE_SIGNATURE'], 'whsec_rmsgaxJbVaooNusFV7pc0WpJAWyLqBOs');
} catch (\Exception $e) {
    file_put_contents(__DIR__ . "/logs/exception/" . date('Y-m-d') . ".log", $e, FILE_APPEND | LOCK_EX);

    http_response_code(403);
    echo json_encode(['error' => $e->getMessage()]);
    exit;
}

$details = '';

$type = $event['type'];
$object = $event['data']['object'];

require '../v1/stripe_update_db.php';

try {
    updateDb($event);
} catch (Exception $exception) {
    file_put_contents(__DIR__ . "/logs/exception/" . date('Y-m-d') . ".log", $exception, FILE_APPEND | LOCK_EX);
}

if ($type == 'checkout.session.completed') {
    error_log('🔔  Checkout Session was completed!');
    try {
//        updateSubscription($event['data']['object']);
    } catch (Exception $exception) {
        file_put_contents(__DIR__ . "/logs/exception/" . date('Y-m-d') . ".log", $exception, FILE_APPEND | LOCK_EX);
    }
} else {
    error_log('🔔  Other webhook received! ' . $type);
}

$output = [
    'status' => 'success'
];

echo json_encode($output, JSON_PRETTY_PRINT);