<?php


class TeamMembersService
{


    var $connection;
    var $manager;

    /**
     * TeamMembersService constructor.
     * @param Database $cornersave
     * @param null $getManagerId
     */
    public function __construct(Database $cornersave, $getManagerId)
    {
        $this->manager = $getManagerId;
        $this->connection = $cornersave;
    }

    public function addMember($data)
    {

        try {
            $this->connection->transaction();
            $person_id = ($this->addPerson($data));
            if (is_null($person_id)) throw new Exception("add member failed");
            if (!$this->addEmployee($data, $person_id)) throw new Exception("add employee failed");
//            if (!$this->addPermissions($person_id, $data['permissions'])) throw new Exception("add grants failed");
            $this->connection->commit();
            return getOKStatus();
        } catch (Exception $e) {
            $this->connection->rollback();
            debugAPIResponse(ACTION_ADD_TEAM_MEMBER, $e);
//            die($e);
        }
        return getErrorStatus(ERROR_NAME_OP_FAILED);

    }

    private function addPerson($data)
    {
        $person = new stdClass();
        $person->first_name = $data['fname'];
        $person->last_name = $data['lname'];
        $person->email = $data['email'];
        $person->gender = $data['gender'];
        $person->phone_number = $data['phone_number'];
        $person->address_1 = $data['location_address_1'];
        $person->address_2 = $data['location_address_2'];
        $person->city = $data['location_city'];
        $person->state = $data['location_state'];
        $person->zip = $data['postal_code'];
        $person->country = $data['country_code'];

        return (new Person($this->connection, $this->manager))->add_person(array($person));
    }

    private function addEmployee($data, $person_id)
    {
        $employee = new stdClass();
        $employee->person_id = $person_id;
        $employee->username = $data['user_name'];
        $employee->password = $data['new_password'];
        $employee->user_type = USER_TYPE_EMPLOYEE;
        $employee->manager_id = $this->manager;

        return (new Employee($this->connection, $this->manager))->addEmployee(array($employee));
    }

    private function addPermissions($person_id, $permissions)
    {
        $inserts = array();
        $menu_group = get_menu_group();
        $modules = get_modules($this->connection);
//        echo json_encode($menu_group);
        foreach ($permissions as $permission) {
            $insert = new stdClass();
            $insert->permission_id = $permission;
//            echo "$permission" . "::" . json_encode($modules) . "::" . json_encode($menu_group);
//            if (array_key_exists($permission, $menu_group))
//                $insert->menu_group = $menu_group[$modules[$permission]];
//            $insert->menu_group = $menu_group[$permission] == null ? '' : $menu_group[$permission];
            $insert->person_id = $person_id;
            array_push($inserts, $insert);
        }

        return (new Permission($this->connection, $this->manager))->addGrants($inserts);
    }
}