<?php


class SupplierMarketService
{

    var $db_connection;
    var $manager_id;

    /**
     * SupplierMarketService constructor.
     * @param Database $cornersave
     * @param null $getManagerId
     */
    public function __construct(Database $cornersave, $getManagerId)
    {
        $this->db_connection = $cornersave;
        $this->manager_id = $getManagerId;
    }

    public function getMarketSupplierList(): array
    {
        $list = (new SupplierMarket($this->db_connection, $this->manager_id))->getMarketSupplierList();
        if (is_null($list)) return getErrorStatus(ERROR_MSG_INVALID_LOGIN);
        $result = getOKStatus();
        $result['supplier_list'] = $list;
        return $result;
    }

    public function getProductListBySupplier(string $supplier): array
    {
        $products = (new SupplierMarket($this->db_connection, $this->manager_id))->getProductList($supplier);
        if (is_null($products)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['product_list'] = $products;
        return $result;
    }

    public function MarkAsInterested($supplier, string $product_id)
    {
        $set = new stdClass();
        $set->is_interested = 1;

        $where = new stdClass();
        $where->supplier_id = $supplier;
        $where->item_id = $product_id;
        if ((new SupplierMarket($this->db_connection, $this->manager_id))->markAsInterested($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function completeMarketSale($data)
    {
        $result = getErrorStatus(ERROR_MSG_INVALID_LOGIN);

        if ($this->db_connection != null) {
            try {
                $this->db_connection->transaction();
                $order_id = $this->sales($data);
                if (!$order_id) throw new Exception("sale not completed");
                if (!$this->saleItems($data['product_list'], $order_id)) throw new Exception("sale items not inserted to db");
                if (!$this->orderPayment($order_id, $data)) throw new Exception("sale payments not inserted");
                $this->db_connection->commit();
                return getOKStatus();
            } catch (Exception $exception) {
                die($exception);
                $this->db_connection->rollback();
            }
        }

        return $result;

    }

    protected function sales($data)
    {
        $items = array();
        $item = new stdClass();
        $item->supplier_id = text_clean($data['supplier_id']);
        $item->pickup = $data['pickup'];
        array_push($items, $item);

        return (new SupplierMarket($this->db_connection, $this->manager_id))->order($items);
    }

    protected function saleItems($items, $sale_id)
    {
        $inserts = array();
        foreach ($items as $item) {

            $insert = new stdClass();
            $insert->item_id = text_clean($item['product_id']);
            $insert->order_id = $sale_id;
            $insert->quantity_purchased = text_clean($item['quantity_purchased']);
            $insert->order_id = $sale_id;
            $insert->description = text_clean($item['description']);
            $insert->item_unit_price = text_clean($item['unit_price']);
            $insert->item_cost_price = floatval(text_clean($item['unit_price'])) * intval(text_clean($item['quantity_purchased']));
            $insert->discount_type = getTypePercentage(text_clean($item['discount_type']));
            $insert->discount = text_clean($item['discount']);
            array_push($inserts, $insert);
        }
        return (new SupplierMarket($this->db_connection, $this->manager_id))->orderItems($inserts);
    }

    protected function orderPayment($sale_id, $data)
    {
        $inserts = array();
        $insert = new stdClass();
//        $insert->payment_type = text_clean($data['payment_method']);
        $insert->payment_amount = text_clean($data['payment_total']);
        $insert->employee_id = text_clean($data['user_id']);
        $insert->order_id = $sale_id;
        array_push($inserts, $insert);

        return (new SupplierMarket($this->db_connection, $this->manager_id))->orderPayments($inserts);
    }

    public function getOrderList()
    {
        $list = (new SupplierMarket($this->db_connection, $this->manager_id))->getOrderList();
        if (is_null($list)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['market_order_list'] = $list;
        return $res;
    }

    public function getOrderData(string $order_id)
    {
        $list = (new SupplierMarket($this->db_connection, $this->manager_id))->getOrder($order_id);
        if (is_null($list)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['order_data'] = $list;
        return $res;
    }

    public function getPromotionList($supplier_id): array
    {
        $model = new SupplierMarket($this->db_connection, $this->manager_id);
        $gifts = $model->getGiftCardList($supplier_id);
        $promotions = $model->getPromotionList($supplier_id);
        if (is_null($gifts) || is_null($promotions)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['gift_list'] = $gifts;
        $res['promotion_list'] = $promotions;
        return $res;
    }

    public function cancelOrder(string $order_id, $supplier_id): array
    {
        $set = new stdClass();
        $set->customer_cancel = 1;

        $where = new stdClass();
        $where->order_id = $order_id;
        $where->manager_id = $this->manager_id;
        $where->supplier_id = $supplier_id;

        if ((new SupplierMarket($this->db_connection, $this->manager_id))->updateOrder($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function claimGift(string $supplier_id, string $batch_code)
    {
        $set = new stdClass();
        $where = new stdClass();
        $where->supplier_id = $supplier_id;

        if ((new SupplierMarket($this->db_connection, $this->manager_id))->claimGift($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }
}