<?php


class ReceivingService
{
    var $db_connector;
    var $manager;

    /**
     * ReceivingService constructor.
     * @param $cornersave
     * @param $getManagerId
     */
    public function __construct($cornersave, $getManagerId)
    {
        $this->db_connector = $cornersave;
        $this->manager = $getManagerId;
    }

    public function completeReceive($data)
    {
        try {
            $this->db_connector->transaction();
            $receiving_id = $this->receive($data);
            if (is_null($receiving_id)) throw new Exception("receiving not complete");
            if ($this->receiveItems($data['product_list'], $this->manager, $receiving_id) == false) throw new Exception("receiving not complete");
            $this->db_connector->commit();
            return getOKStatus();
        } catch (Exception $e) {
            $this->db_connector->rollback();
//            die($e);
            debugAPIResponse(MODULE_RECEIVING, $e);
            return getErrorStatus(ERROR_NAME_OP_FAILED);
        }
    }

    private function receive($data)
    {
        $values = array();

        $receive = new stdClass();
        $receive->supplier_id = text_clean($data['supplier_id']);
        $receive->comment = text_clean($data['comment']);
        $receive->payment_type = text_clean($data['payment_method']);
        $receive->manager_id = $this->manager;
        $receive->employee_id = $this->manager;
//        $receive->line = 2;
        $receive->comment = text_clean($data['comment']);

        array_push($values, $receive);

        return (new Receiving($this->db_connector))->receive($values);
    }

    private function receiveItems($product_list, $manager, $receiving_id): bool
    {
        $values = array();
        $quantity_updates = array();
        foreach ($product_list as $product) {
            $value = new stdClass();
            $value->item_id = text_clean($product['product_id']);
            $value->receiving_id = $receiving_id;
            $value->quantity_purchased = text_clean($product['quantity_purchased']);
            $value->item_cost_price = text_clean($product['cost_price']);
            $value->discount = text_clean($product['discount']);
            $value->description = text_clean($product['description']);
            array_push($values, $value);

            $quantity_update = new stdClass();
            $quantity_update->quantity = text_clean($product['quantity_purchased']);
            $quantity_update->item_id = text_clean($product['product_id']);
            array_push($quantity_updates, $quantity_update);
        }

        return (new Receiving($this->db_connector))->receiveItems($values) && (new Item($this->db_connector))->updateProductQuantities($quantity_updates, 'receiving');
    }
}