<?php


class KitsService
{

    var $db_connector;
    var $manager;

    /**
     * KitsService constructor.
     * @param $db_connector
     */
    public function __construct($db_connector, $manager)
    {
        $this->db_connector = $db_connector;
        $this->manager = $manager;
    }

    public function getKitsList($manager_id, $offset, $limit): array
    {
        $kits = (new Kits($this->db_connector))->getList($manager_id, $offset, $limit);
        if (is_null($kits)) return getErrorStatus(ERROR_NAME_OP_FAILED);

        $result = getOKStatus();
        $result['promotion_list'] = $kits;
        $result['product_index'] = count($kits) + $offset;
        $result['last_index'] = count($kits) + $offset;
        return $result;
    }

    public function getKitItems($promotion_id, $manager_id)
    {
        $kit = (new Kits($this->db_connector))->getKit($promotion_id, $manager_id);
        if (is_null($kit)) return getErrorStatus(ERROR_NAME_OP_FAILED);

        $kitItem = (new ItemKit($this->db_connector))->getItemByKitId($promotion_id);

        if (!is_null($kitItem)) $kit['product_list'] = $kitItem;

        $result = getOKStatus();
        $result['promotion_data'] = $kit;
        return $result;
    }

    public function deleteKit($promotion_id, $manager_id)
    {
        if ((new Kits($this->db_connector))->delete($promotion_id, $manager_id)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function addKit($data)
    {
        try {
            $this->db_connector->transaction();
            $kit_id = ($this->add($data));
            if (is_null($kit_id)) throw new Exception("could not insert kit :: " . $this->db_connector->get_error());
            if (!$this->addKitItem($data['product_list'], $kit_id)) throw new Exception("count not insert kit item :: " . $this->db_connector->get_error());
            $this->db_connector->commit();
            return getOKStatus();
        } catch (Exception $e) {
            $this->db_connector->rollback();
            debugAPIResponse(ACTION_ADD_PROMOTION, $e);
        }

        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    private function add($data)
    {
        $kit = new stdClass();
        $kit->name = text_clean($data['promotion_name']);
        $kit->description = text_clean($data['promotion_description']);
        $kit->promotion_cost = text_clean($data['promotion_cost']);
        $kit->cost_price = text_clean($data['cost_price']);
        $kit->barcode = text_clean($data['barcode']);
        $kit->manager_id = $this->manager;
        $kit->kit_discount_type = text_clean($data['discount_type']) == DISCOUNT_TYPE_PERCENT ? DISCOUNT_TYPE_PERCENT_CODE : DISCOUNT_TYPE_FIXED_CODE;
        $kit->kit_discount = text_clean($data['discount']);

        $values = array();
        array_push($values, $kit);
        return (new Kits($this->db_connector))->addKit($values);
    }

    private function addKitItem($data, $kit_id): bool
    {

        $values = array();
        foreach ($data as $datum) {
            $value = new stdClass();
            $value->item_kit_id = $kit_id;
            $value->item_id = text_clean($datum['product_id']);
            $value->quantity = text_clean($datum['quantity']);
//            $value->quantity = text_clean($data['quantity']);
            array_push($values, $value);
        }

        return (new ItemKit($this->db_connector))->addKit($values);
    }

    public function updateKit($data, $manager_id)
    {
        try {
            $this->db_connector->transaction();
            ($this->update($data, $manager_id));
            (!$this->update_kit_item($data['product_list'], text_clean($data['promotion_id'])));
            $this->db_connector->commit();
            return getOKStatus();
        } catch (Exception $e) {
            $this->db_connector->rollback();
//            die($e);
            debugAPIResponse(ACTION_UPDATE_PROMOTION, $e);
        }

        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    private function update($data, $manager_id): bool
    {
        $set = new stdClass();
        $set->name = text_clean($data['promotion_name']);
        $set->description = text_clean($data['promotion_description']);
        $set->promotion_cost = text_clean($data['promotion_cost']);
        $set->cost_price = text_clean($data['cost_price']);
        $set->kit_discount_type = $this->get_discount(text_clean($data['discount_type']));
        $set->kit_discount = text_clean($data['discount']);
//        $set->name = text_clean($data['barcode']);

        $where = new stdClass();
        $where->item_kit_id = text_clean($data['promotion_id']);
        $where->manager_id = $manager_id;

        return (new Kits($this->db_connector))->update($set, $where);
    }

    private function update_kit_item($data, $promotion_id): bool
    {
        $kits_model = new ItemKit($this->db_connector);
        $items_in_the_db = $kits_model->getItemIdsByKitId($promotion_id);
        $items_to_be_updated = array();
        $items_to_be_deleted = array();
        $items_to_be_used_later = array();
        $items_to_be_inserted = array();

        foreach ($data as $datum) {
            $product = new stdClass();
            $product->quantity = text_clean($datum['quantity']);
            $product->item_id = text_clean($datum['product_id']);
            $product->item_kit_id = $promotion_id;
            $items_to_be_used_later[text_clean($datum['product_id'])] = $product;
        }


        if (!is_null($items_in_the_db) && !empty($items_in_the_db))
            foreach ($items_in_the_db as $item) {
                if (!array_key_exists(intval($item), $items_to_be_used_later)) array_push($items_to_be_deleted, trim($item));
                else $items_to_be_updated[trim($item)] = $items_to_be_used_later[trim($item)];
            }

        foreach ($data as $datum) {

            $prod = intval(trim(text_clean($datum['product_id'])));
            if (!array_key_exists($prod, $items_to_be_updated)) {
                array_push($items_to_be_inserted, $items_to_be_used_later[text_clean($datum['product_id'])]);
            }
        }

        $inserted = true;
        if (!is_null($items_to_be_inserted) && !empty($items_to_be_inserted))
            $inserted = (new ItemKit($this->db_connector))->addKit($items_to_be_inserted);

        $deleted = true;
        if (!is_null($items_to_be_deleted) && !empty($items_to_be_deleted))
            $deleted = (new ItemKit($this->db_connector))->deleteByIds($items_to_be_deleted, $promotion_id);

        $updated = true;
        if (!is_null($items_to_be_updated) && !empty($items_to_be_updated))
            foreach ($items_to_be_updated as $value) {
                if (!$updated) break;


                $set = new stdClass();
                $set->quantity = text_clean($value->quantity);

                $where = new stdClass();
                $where->item_kit_id = $promotion_id;
                $where->item_id = text_clean($value->item_id);
                $updated = (new ItemKit($this->db_connector))->update_item($set, $where);

            }

        return $updated && $deleted && $inserted;
    }

    private function get_discount(string $discount_type): int
    {
        if ($discount_type == DISCOUNT_TYPE_PERCENT) return DISCOUNT_TYPE_PERCENT_CODE;
        else return DISCOUNT_TYPE_FIXED_CODE;
    }

    private function insertKitItems(array $items_to_be_inserted)
    {

    }

    private function addKitItem2(array $data, $kit_id)
    {

        $values = array();
        foreach ($data as $datum) {
            $value = new stdClass();
            $value->item_kit_id = $kit_id;
            $value->item_id = ($datum->product_id);
            $value->quantity = ($datum->quantity);
//            $value->quantity = text_clean($data['quantity']);
            array_push($values, $value);
        }

        return (new ItemKit($this->db_connector))->addKit($data);
    }

}