<?php


class ItemService
{

    private $db_connector;
    private $host_info;
    private $currentLocation;

    function __construct(Database $db_connector)
    {
        $this->db_connector = $db_connector;
        $this->host_info = new HostInfo($db_connector);
        $this->currentLocation = new LocationPoint(null, null);
    }

    public function deleteItem($item_id, $manager_id)
    {
        $model = new Item($this->db_connector, $item_id);

        $deleted = $model->deleteItem($manager_id);

        if ($deleted) return getOKStatus();

        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function addProduct($object)
    {
        $result = getErrorStatus(ERROR_NAME_OP_FAILED);
        try {
            $item_model = new Item($this->db_connector);
            $this->db_connector->transaction();

            $item_id = $this->insert($object);

            if (is_null($item_id)) throw new Exception("failed to add to items table");

            $add_quantity = $this->addProductQuantity($object, $item_id);

            if (!$add_quantity) throw new Exception("failed to add item quantity");

            $this->db_connector->commit();

            return getOKStatus();
        } catch (Exception $exception) {
            $this->db_connector->rollback();
            debugAPIResponse(ACTION_ADD_PRODUCT, $exception);
        }

        return $result;
    }

    public function mark_order_out_of_stock($product_id, $order_id)
    {
        $set = new stdClass();
        $set->stock_type = 0;

        $where = new stdClass();
        $where->item_id = $product_id;

        if ((new Item($this->db_connector))->in_out_of_stock($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function mark_order_in_stock($product_id, $order_id)
    {
        $set = new stdClass();
        $set->stock_type = 1;

        $where = new stdClass();
        $where->item_id = $product_id;

        if ((new Item($this->db_connector))->in_out_of_stock($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    private function insert($data)
    {
        $item = new stdClass();
        $item->manager_id = $data->user_id;
        $item->name = $data->product_name;
        $item->category = $data->category_name;
        $item->cost_price = $data->cost_price;
        $item->unit_price = $data->unit_price;
//        $item->quantity = $data->quantity;
        $item->item_number = $data->barcode;
        $item->brand = $data->brand;
        $item->unit_value = $data->unit_value;
        $item->unit_label = $data->unit_label;
        $item->stock_type = $data->stock_type == "stock" ? 0 : 1; //1 - non_stock
        $item->supplier_id = $data->supplier_id;
        $item->receiving_quantity = $data->receiving_quantity;
        $item->receiving_quantity = $data->receiving_quantity;
        $item->description = $data->description;
        $item->pic_filename = $data->image_name;
        $item->source_path = $data->source_path;

        return (new Item($this->db_connector))->insert(array($item));
    }

    private function addProductQuantity($data, $item_id)
    {
        $item = new stdClass();
        $item->item_id = $item_id;
        $item->quantity = $data->quantity;
//        $item->location_id = null;
        return (new Item($this->db_connector))->addProductQuantity(array($item));
    }

}