<?php


class ExpensesService
{
    var $db_connector;
    var $manager_id;

    /**
     * ExpensesService constructor.
     * @param $cornersave
     * @param $getManagerId
     */
    public function __construct($cornersave, $getManagerId)
    {
        $this->db_connector = $cornersave;
        $this->manager_id = $getManagerId;
    }

    public function getListByManagerId(): array
    {

        $list = (new Expenses($this->db_connector))->getList($this->manager_id);
        if (is_null($list)) getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['expense_list'] = $list;
        return $result;
    }

    public function addExpense($data)
    {
        $values = array();

        $value = new stdClass();
        $value->date = text_clean($data['expense_date']);
        $value->amount = text_clean($data['expense_amount']);
        $value->payment_type = text_clean($data['payment_type']);
        $value->expense_category_id = text_clean($data['category_id']);
        $value->description = text_clean($data['expense_description']);
        $value->supplier_id = text_clean($data['supplier_id']);
        $value->supplier_tax_code = text_clean($data['supplier_tax_code']);
        $value->tax_amount = text_clean($data['tax_amount']);

        array_push($values, $value);

        $category = (new Expenses($this->db_connector))->add($values);

        if (!$category) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['expense_id'] = $category;
        return $result;
    }

    public function updateExpense($data)
    {
        $set = new stdClass();
//        $set->date = $date . " " . $time;
        $set->amount = text_clean($data['expense_amount']);
        $set->payment_type = text_clean($data['payment_type']);
        $set->expense_category_id = text_clean($data['category_id']);
        $set->description = text_clean($data['expense_description']);
        $set->supplier_id = text_clean($data['supplier_id']);
        $set->supplier_tax_code = text_clean($data['supplier_tax_code']);
        $set->tax_amount = text_clean($data['tax_amount']);

        $where = new stdClass();
        $where->expense_id = text_clean($data['expense_id']);

        $updated = (new Expenses($this->db_connector))->update($set, $where);

        if (!$updated) return getErrorStatus(ERROR_NAME_OP_FAILED);
        return getOKStatus();
    }

    public function delete(string $expense_id)
    {
        $set = new stdClass();
        $set->deleted = 1;
        $where = new stdClass();
        $where->category_id = $expense_id;
        $where->manager_id = $this->manager_id;

        if ((new Expenses($this->db_connector))->deleted($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }
}