<?php


class ExpenseCategoryService
{

    var $db_connector;
    var $manager_id;

    /**
     * ExpenseCategory constructor.
     * @param Database $cornersave
     * @param null $getManagerId
     */
    public function __construct($cornersave, $getManagerId)
    {
        $this->db_connector = $cornersave;
        $this->manager_id = $getManagerId;
    }

    public function getList(): array
    {
        $list = (new ExpenseCategory($this->db_connector))->getList($this->manager_id);
        if (is_null($list)) getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['category_list'] = $list;
        return $result;
    }

    public function addCategory($data): array
    {
        $values = array();

        $value = new stdClass();
        $value->category_name = text_clean($data['category_name']);
        $value->category_description = text_clean($data['category_description']);
        $value->manager_id = $this->manager_id;

        array_push($values, $value);

        $category = (new ExpenseCategory($this->db_connector))->add($values);

        if (!$category) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $result = getOKStatus();
        $result['category_id'] = $category;
        return $result;
    }

    public function delete($category_id)
    {
        $set = new stdClass();
        $set->deleted = 1;
        $where = new stdClass();
        $where->category_id = $category_id;
        $where->manager_id = $this->manager_id;

        if ((new ExpenseCategory($this->db_connector))->deleted($set, $where)) return getOKStatus();
        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }
}