<?php

class SupplierMarket
{
    var $conn;
    var $manager;

    /**
     * SupplierMarket constructor.
     * @param Database $db_connection
     * @param null $manager_id
     */
    public function __construct(Database $db_connection, $manager_id)
    {
        $this->conn = $db_connection;
        $this->manager = $manager_id;
    }

    public function getPromotionProductList($promotion_id): ?array
    {
        $query = "select k.item_id       as product_id,
       oi.name         as product_name,
       oi.category     as category_name,
       oi.cost_price,
       oi.unit_price,
       oi.brand,
       oi.unit_value,
       oi.unit_label,
       k.quantity,
       oi.pic_url      as image_url,
       oi.pic_filename as image_name,
       oi.catalog_id
from ospos_market_item_kit_items k
         inner join ospos_items oi on k.item_id = oi.item_id
where k.item_kit_id = " . $promotion_id;

        if (!is_null($this->conn)) {
            $select_request = $this->conn->query($query);
            $res = array();
            while ($row = $select_request->fetch_assoc()) {
                $row['product_id'] = intval($row['product_id']);
                $row['quantity'] = intval($row['quantity']);
                $row['unit_value'] = floatval($row['unit_value']);
                $row['cost_price'] = floatval($row['cost_price']);
                $row['unit_price'] = floatval($row['unit_price']);

                array_push($res, $row);
            }
            return $res;
        }

        return null;
    }

    public function getOrderItems($order_id)
    {

        if ($this->conn != null) {
            $Query = "SELECT SI.item_id         as product_id,
       I.name             as product_name,
       I.category         as category_name,
       SI.item_unit_price as unit_price,
       SI.quantity_purchased,
       I.pic_url          as image_url,
       I.pic_filename     as image_name,
       SI.discount_type,
       SI.discount,
       I.description
FROM " . TABLE_MARKET_SUPPLIER_ORDER_ITEMS . " SI
         inner join " . TABLE_ITEMS . " I on SI.item_id = I.item_id WHERE order_id = '$order_id'";

            $select_query = $this->conn->query($Query);

            if ($select_query != null) {
                $result = array();
                while ($row = $select_query->fetch_assoc()) {
                    $row['product_id'] = intval($row['product_id']);
                    $row['unit_price'] = floatval($row['unit_price']);
                    $row['quantity_purchased'] = intval($row['quantity_purchased']);
                    $row['discount'] = floatval($row['discount']);
                    array_push($result, $row);
                }
                return $result;
            }
        }

        return null;
    }

    public function getMarketSupplierList(): ?array
    {
        $Query = "SELECT S.person_id AS supplier_id, S.company_name, P.email, P.phone_number, S.category as supplier_category, S.supplier_url FROM " . TABLE_SUPPLIERS . " S inner join " . TABLE_PEOPLE . " P on S.person_id = P.person_id AND S.deleted = '0'";
        if ($this->conn != null) {
            $select_query = $this->conn->query($Query);
            if ($select_query != null && $select_query->is_row_affected()) {
                $res = array();
                while ($row = $select_query->fetch_assoc()) {
                    $supplier = $row;
                    $supplier['supplier_id'] = intval($row['supplier_id']);
                    $supplier['supplier_category'] = (Supplier::getSupplierType($row['supplier_category']));
                    $supplier['market_place_id'] = $this::getMarketPlaceId(intval($row['supplier_id']));
                    $supplier['is_connected'] = $this::supplierIsConnectedToManager(intval($row['supplier_id'])) == 1;
                    array_push($res, $supplier);
                }
                return $res;
            }
        }

        return null;
    }

    private function getMarketPlaceId(int $supplier): string
    {
        if (is_null($this->conn)) return '';
        $query = "select market_place_id
from ospos_supplier_market_place
where supplier_id = '$supplier'
limit 1";
        $result = $this->conn->fetch_object($query);

        if (is_null($result)) return '';
        return $result->market_place_id;
    }

    private function supplierIsConnectedToManager(int $supplier): int
    {
        if (is_null($this->conn)) return '';
        $query = "SELECT EXISTS(SELECT id FROM ospos_suppliers WHERE manager_id = '$this->manager' AND person_id = '$supplier') as IS_CONNECTED";
        return ($this->conn->fetch_object($query))->IS_CONNECTED;
    }

    public function getProductList($supplier)
    {

        if ($this->conn != null) {
            $Query = "select SP.item_id,
       I.name       as product_name,
       category     as category_name,
       cost_price,
       unit_price,
       SP.quantity,
       unit_value,
       unit_label,
       brand,   
       pic_filename as image_name,
       pic_url      as image_url,
       catalog_id,
       product_type,
       description  as product_description,
       SP.is_interested
from ospos_market_supplier_products SP
         inner join ospos_items I on SP.item_id = I.item_id
where SP.supplier_id = " . $supplier;

            $select_query = $this->conn->query($Query);

            if ($select_query != null) {
                $result = array();
                while ($row = $select_query->fetch_assoc()) {
                    $res['product_id'] = intval($row['product_id']);
                    $res['unit_price'] = floatval($row['unit_price']);
                    $res['quantity'] = intval($row['quantity']);
                    $res['cost_price'] = floatval($row['cost_price']);
                    $res['unit_value'] = floatval($row['unit_value']);
                    array_push($result, $res);
                }
                return $result;
            }
        }

        return null;
    }

    public function markAsInterested($set, $where)
    {
        $query = get_update_query(TABLE_MARKET_SUPPLIER_PRODUCTS, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);
    }

    public function order(array $items)
    {
        $query = get_insert_query(TABLE_MARKET_SUPPLIER_ORDER, $items);
        if (!is_null($this->conn)) {
            return $this->conn->get_insert_id($query);
        }
        return null;
    }

    public function orderItems(array $items)
    {
        $query = get_insert_query(TABLE_MARKET_SUPPLIER_ORDER_ITEMS, $items);
        return !is_null($this->conn) && $this->conn->insert($query);
    }

    public function orderPayments(array $inserts)
    {
        $query = get_insert_query(TABLE_MARKET_SUPPLIER_ORDER_PAYMENTS, $inserts);
        return !is_null($this->conn) && $this->conn->insert($query);
    }

    public function getOrderList()
    {
        if ($this->conn != null) {
            $Query = "select SO.order_id,
       order_time,
       SO.supplier_id,
       order_status,
       sum(quantity_purchased) as item_count,
       sum(payment_amount)     as total,
       market_place_id,
       S.company_name as supplier_name
from ospos_market_supplier_order SO
         left outer join ospos_market_supplier_order_items SOI on SO.order_id = SOI.order_id
         left outer join ospos_market_supplier_order_payments SOP on SO.order_id = SOP.order_id
         left outer join ospos_supplier_market_place SMP on SO.supplier_id = SMP.supplier_id
         left outer join ospos_suppliers S on SO.supplier_id = S.person_id
where SO.manager_id = " . $this->manager . "
group by SOI.order_id";

            $select_query = $this->conn->query($Query);

            if ($select_query != null) {
                $result = array();
                while ($rs = $select_query->fetch_assoc()) {
                    $rs['order_id'] = intval($rs['order_id']);
                    $rs['supplier_id'] = intval($rs['supplier_id']);
                    $rs['item_count'] = intval($rs['item_count']);
                    $rs['total'] = floatval($rs['total']);
                    $rs['order_status'] = Order::getOrderStatus($rs['order_status']);
                    array_push($result, $rs);
                }
                return $result;
            }

        }

        return null;

    }

    public function getOrder($order_id)
    {
        if ($this->conn != null) {
            $Query = "select SO.order_id,
       order_time,
       SO.supplier_id,
       order_status,
       sum(payment_amount)     as total,
       S.company_name          as supplier_name,
       pickup                  as pickup_time
from ospos_market_supplier_order SO
         left outer join ospos_market_supplier_order_items SOI on SO.order_id = SOI.order_id
         left outer join ospos_market_supplier_order_payments SOP on SO.order_id = SOP.order_id
         left outer join ospos_suppliers S on SO.supplier_id = S.person_id
where SO.manager_id = " . $this->manager . "
  and SO.order_id = " . $order_id . "
group by SOI.order_id;";

            $select_query = $this->conn->query($Query);

            if ($select_query != null) {
                $result = array();
                while ($rs = $select_query->fetch_assoc()) {
                    $rs['order_id'] = intval($rs['order_id']);
                    $rs['supplier_id'] = intval($rs['supplier_id']);
                    $rs['item_count'] = intval($rs['item_count']);
                    $rs['total'] = floatval($rs['total']);
                    $rs['order_status'] = Order::getOrderStatus($rs['order_status']);
                    $rs['product_list'] = $this->getOrderItems($rs['order_id']);
                    array_push($result, $rs);
                }
                return $result;
            }

        }

        return null;

    }

    public function getGiftCardList($supplier_id)
    {

        $Query = "select 'type_gift' as product_type, batch_code, value as card_value
from ospos_market_giftcards
where person_id = " . $supplier_id . "
  and manager_id = " . $this->manager;

        if (is_null($this->conn)) return null;

        $select_query = $this->conn->query($Query);

        if ($select_query != null) {
            $result = array();
            while ($rs = $select_query->fetch_assoc()) {
                $rs['batch_code'] = intval($rs['batch_code']);
                $rs['card_value'] = round(floatval($rs['card_value']), 2);
                array_push($result, $rs);
            }
            return $result;
        }

        return null;

    }

    public function getPromotionList($supplier_id)
    {

        $Query = "select 'type_promotion'  as product_type,
       item_kit_id       as promotion_id,
       name              as promotion_name,
       description       as promotion_description,
       promotion_cost,
       cost_price,
       kit_discount_type as discount_type,
       kit_discount      as discount
from ospos_market_item_kits
where person_id = $supplier_id
  and manager_id = " . $this->manager;

        if (is_null($this->conn)) return null;

        $select_query = $this->conn->query($Query);

        if ($select_query != null) {
            $result = array();
            while ($rs = $select_query->fetch_assoc()) {
                $p_id = intval($rs['promotion_id']);
                $rs['promotion_id'] = $p_id;
                $rs['promotion_cost'] = floatval($rs['promotion_cost']);
                $rs['cost_price'] = floatval($rs['cost_price']);
                $rs['discount'] = floatval($rs['discount']);
                $rs['product_list'] = $this->getPromotionProductList($p_id);
                array_push($result, $rs);
            }
            return $result;
        }

        return null;
    }

    public function updateOrder($set, $where)
    {
        $query = get_update_query(TABLE_MARKET_SUPPLIER_ORDER, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);
    }

    public function claimGift(stdClass $set, stdClass $where)
    {
        $query = get_update_query(TABLE_MARKET_GIFTCARDS, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);
    }
}