<?php


class Subscription extends Query
{

    /**
     * Subscription constructor.
     * @param Database $db_connector
     */
    public function __construct(\Database $db_connector)
    {
        parent::__construct($db_connector);
    }

    public function getPackageDataByFilter($filter)
    {
        $Query = "select package_id,
           store_id,
           monthly_subscription,
           store_name,
           store_type,
           logo_url,
           store_url,
           country_code,
           address,
           currency_code,
           total_products,
           json_object('lat', latitude, 'lng', longitude) as cordinates,
           days_active,
           daily_transactions,
           avg_monthly_sales from ospos_market_stores where 1 = 1";

        if (isset($filter['locality']) && !is_null($filter['locality'])) {
            $Query .= " and locality like '%" . $filter['locality'] . "%'";
        }
        if (isset($filter['locality']) && !is_null($filter['country_code'])) {
            $Query .= " and country_code like '%" . $filter['country_code'] . "%'";
        }
        if (isset($filter['store_type']) && !is_null($filter['store_type'])) {
            $Query .= " and store_type like '%" . $filter['store_type'] . "%'";
        }
        return parent::rawQuery($Query)->findAll();
    }

    public function getPackageData($package)
    {
//        return parent::sp(SP_GET_PACKAGE_DETAILS, array('package' => $package))->findOne();
        return parent::rawQuery("select package_id,
           store_id,
           monthly_subscription,
           store_name,
           store_type,
           logo_url,
           store_url,
           country_code,
           address,
           currency_code,
           total_products,
           json_object('lat', latitude, 'lng', longitude) as cordinates,
           days_active,
           daily_transactions,
           avg_monthly_sales from ospos_market_stores where package_id = '$package'")->findOne();
    }

    public function addPackage($manager_id, $session_id)
    {
        return parent::sp('SP_INSERT_PACKAGE', array('manager' => $manager_id, 'session' => $session_id, 'package_id' => generate_unique_id('pd_')))->findOne();
    }
}