<?php

class MsgNotification
{

    var $conn;

    /**
     * MsgNotification constructor.
     * @param $db_connector
     */
    public function __construct($db_connector)
    {
        $this->conn = $db_connector;
    }

    public function getMarketingMsgThread($manager_id, $recipient_type)
    {
        $query = "select message_id, manager_id as sender_id, sender_store_id, timestamp, msg_body, recipient_count, recipient_read from " . TABLE_MARKETING_MESSAGE . " where manager_id = " . $manager_id . " and recipient_type = '$recipient_type'";
        if (!is_null($this->conn)) {
            $select_query = $this->conn->query($query);
            $res = array();
            while ($row = $select_query->fetch_assoc()) {
                $row['sender_id'] = intval($row['sender_id']);
                $row['recipient_count'] = intval($row['recipient_count']);
                $row['recipient_read'] = intval($row['recipient_read']);
                array_push($res, $row);
            }
            return $res;
        }
        return null;
    }

    public function getMarketingMsgList($manager_id)
    {
        $query = "select recipient_type, timestamp, msg_body
from " . TABLE_MARKETING_MESSAGE . "
where manager_id = " . $manager_id;
        if (!is_null($this->conn)) {
            $select_query = $this->conn->query($query);
            $res = array();
            while ($row = $select_query->fetch_assoc()) {
                array_push($res, $row);
            }
            return $res;
        }
        return null;
    }

    public function getCustomerMsgThread($manager_id, $customer_id)
    {
        $query = "SELECT MC.msg_body,
       P.last_name                                                            as lname,
       P.first_name                                                           as fname,
       MC.timestamp,
       (select count(*) from " . TABLE_CUSTOMER_CONVERSATIONS . " where MC.`read` = 0 and customer_id =  $customer_id) as unread,
       MC.customer_id
from ospos_message_conversations MC
         inner join " . TABLE_PEOPLE . " P on MC.customer_id = P.person_id
where customer_id = $customer_id
  and MC.manager_id = $manager_id
order by MC.id desc
limit 1;";
        if (!is_null($this->conn)) {
            $select_query = $this->conn->query($query);
            $res = array();
            while ($row = $select_query->fetch_assoc()) {
                $row['customer_id'] = intval($row['customer_id']);
                $row['unread'] = intval($row['unread']);
                array_push($res, $row);
            }
            return $res;
        }
        return null;
    }

    public function getMsgListConversation($manager_id)
    {
        $query = "SELECT MC.msg_body,
       P.last_name                                                            as lname,
       P.first_name                                                           as fname,
       MC.timestamp,
       '0' as unread,
       MC.customer_id
from ospos_message_conversations MC
         inner join " . TABLE_PEOPLE . " P on MC.customer_id = P.person_id
where MC.manager_id = $manager_id
order by MC.id desc
limit 1;";
        if (!is_null($this->conn)) {
            $select_query = $this->conn->query($query);
            $res = array();
            while ($row = $select_query->fetch_assoc()) {
                array_push($res, $row);
            }
            return $res;
        }
        return null;
    }

    public function updateMsg($set, $where)
    {
//        return $this::update_query(TABLE_CUSTOMER_CONVERSATIONS, $set, $where);
        $query = get_update_query(TABLE_MARKETING_MESSAGE, $set, $where);
        return !is_null($this->conn) && $this->conn->insert($query);
    }

    public function insertMsg($values)
    {
        $query = get_insert_query(TABLE_MARKETING_MESSAGE, $values);
        return !is_null($this->conn) && $this->conn->insert($query);
    }
}