<?php


class Kits
{
    var $conn;

    /**
     * Kits constructor.
     * @param $conn
     */
    public function __construct($conn)
    {
        $this->conn = $conn;
    }


    public function getList($manager_id, $offset, $limit): ?array
    {
        $query = "select item_kit_id       as promotion_id,
       name              as promotion_name,
       description       as promotion_description,
       promotion_cost,
       cost_price,
       kit_discount      as discount,
       kit_discount_type as discount_type
from ospos_item_kits where manager_id = " . $manager_id . " and deleted = 0";
        if (!is_null($limit)) $query .= " limit " . $limit;
        if (!is_null($offset) && $offset != 0) $query .= " offset " . $offset;

        if (!is_null($this->conn)) {
            $select_result = $this->conn->query($query);
            $res = array();
            while ($row = $select_result->fetch_assoc($query)) {
                $row['discount_type'] = $this->discount_type($row['discount_type']);
                $row['promotion_id'] = intval($row['promotion_id']);
                $row['promotion_cost'] = intval($row['promotion_cost']);
                $row['cost_price'] = intval($row['cost_price']);
                $row['discount'] = intval($row['discount']);
                $row['product_list'] = (new ItemKit($this->conn))->getItemByKitId(intval($row['promotion_id']));
                array_push($res, $row);
            }
            return $res;
        }

        return null;
    }

    public function getKit($promotion_id, $manager_id)
    {

        $query = "select item_kit_id       as promotion_id,
       name              as promotion_name,
       description       as promotion_description,
       kit_discount      as discount,
       barcode,
       promotion_cost,
       cost_price,
       kit_discount_type as discount_type
from " . TABLE_KITS . " where item_kit_id = " . $promotion_id . " and manager_id = " . $manager_id . " and deleted = 0";

        if (!is_null($this->conn)) {
            $res = $this->conn->fetch_assoc($query);
            $res['discount_type'] = $this->discount_type($res['discount_type']);
            $res['promotion_id'] = intval($res['promotion_id']);
            $res['promotion_cost'] = floatval($res['promotion_cost']);
            $res['discount'] = floatval($res['discount']);
            $res['cost_price'] = floatval($res['cost_price']);
            return $res;
        }
        return null;
    }

    public function delete($promotion_id, $manager_id): bool
    {
        if (!is_null($this->conn)) return $this->conn->update("update " . TABLE_KITS . " set deleted = 1 where item_kit_id = " . $promotion_id . " and manager_id = " . $manager_id);
        return false;
    }

    private function discount_type($discount_type): string
    {
        if ($discount_type == DISCOUNT_TYPE_PERCENT_CODE) return DISCOUNT_TYPE_PERCENT;
        else return DISCOUNT_TYPE_FIXED;
    }

    public function addKit(array $values)
    {
        $query = get_insert_query(TABLE_KITS, $values);
        if (!is_null($this->conn)) {
            return $this->conn->get_insert_id($query);
        }
        return null;
    }

    public function update(stdClass $set, stdClass $where): bool
    {
//        $query = get_update_query(TABLE_KITS, $set, $where);
//        return !is_null($this->conn) && $this->conn->update($query);

        $query = get_update_query(TABLE_KITS, $set, $where);
//        echo "\n$query\n";
        if (!is_null($this->conn)) {
            $updated = $this->conn->update($query);
            return $updated;
        }

        return false;
    }
}