<?php


class Expenses
{

    var $conn;

    /**
     * Expenses constructor.
     * @param $db_connector
     */
    public function __construct($db_connector)
    {
        $this->conn = $db_connector;
    }

    public function getList($manager_id): ?array
    {

        $query = "select expense_id,
       date                                   as expense_date,
       amount                                 as expense_amount,
       payment_type,
       EX.expense_category_id                 as category_id,
       EC.category_name,
       description                            as category_description,
       EX.manager_id                          as creator_id,
       EX.supplier_id,
       concat(P.first_name, ' ', P.last_name) as supplier_name,
       supplier_tax_code,
       tax_amount
from ospos_expenses EX
         inner join " . TABLE_EXPENSE_CATEGORIES . " EC on EX.expense_category_id = EC.expense_category_id
         inner join " . TABLE_PEOPLE . " P on EX.supplier_id = P.person_id
where EX.manager_id = " . $manager_id;

        if (!is_null($this->conn)) {
            $select_query = $this->conn->query($query);
            if (!is_null($select_query)) {
                $res = array();
                while ($row = $select_query->fetch_assoc()) {
                    $row['expense_id'] = intval($row['expense_id']);
                    $row['category_id'] = intval($row['category_id']);
                    $row['expense_amount'] = floatval($row['expense_amount']);
                    $row['supplier_tax_code'] = intval($row['supplier_tax_code']);
                    $row['expense_amount'] = floatval($row['expense_amount']);
                    $row['tax_amount'] = floatval($row['tax_amount']);
                    array_push($res, $row);
                }

                return $res;
            }
        }

        return null;

    }

    public function add(array $values)
    {
        $query = get_insert_query(TABLE_EXPENSE_CATEGORIES, $values);
        if (!is_null($this->conn)) {
            return $this->conn->get_insert_id($query);
        }
        return null;
    }

    public function deleted(stdClass $set, stdClass $where)
    {
        $query = get_update_query(TABLE_EXPENSES, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);
    }

    public function update(stdClass $set, stdClass $where)
    {
        $query = get_update_query(TABLE_EXPENSES, $set, $where);
        return !is_null($this->conn) && $this->conn->update($query);
    }
}