<?php
include("PasswordBroker.php");
include("Notification.php");
include("Employee.php");
include("Permission.php");

class Merchant
{

    private $db_connector;
    private $isLoggedin = false;//is the merchant logged in
    private $isActive = false;//is this merchant's account still active
    private $hasCurrentLocation = false;//


    //current details
    private $host_info = null;
    private $currentLat = null;
    private $currentLon = null;
    private $currentLocation = null;

    //merchant details
    private $userId = null;
    private $loginToken = null;
    private $email = null;
    private $password = null;
    private $userName = null;
    private $firstName = null;
    private $lastName = null;
    private $gender = null;
    private $locationCountry = null;
    private $locationState = null;
    private $locationCity = null;
    private $registrationDate = null;
    private $phoneNumber = null;
    private $userType = null;
    private $locationAddress_1 = null;
    private $locationAddress_2 = null;
    private $userRef = null;
    private $managerId = null;
    private $storeId = null;


    function __construct(Database $db_connector)
    {
        $this->db_connector = $db_connector;

        $this->host_info = new HostInfo($db_connector);

        $this->currentLocation = new LocationPoint(null, null);

    }

    public function get_db_connector()
    {
        return $this->db_connector;
    }

    public function isLoggedin()
    {
        return $this->isLoggedin;
    }

    public function isActive()
    {
        return $this->isActive;
    }

    public function get_userId()
    {
        return $this->userId;
    }

    public function get_loginToken()
    {
        return $this->loginToken;
    }

    public function get_email()
    {
        return $this->email;
    }

    public function get_encrytedPassword()
    {
        return $this->password;
    }

    public function get_userName()
    {
        return $this->userName;
    }

    public function get_firstName()
    {
        return $this->firstName;
    }

    public function get_lastName()
    {
        return $this->lastName;
    }

    public function get_gender()
    {
        return $this->gender;
    }

    public function get_locationCountry()
    {
        return $this->locationCountry;
    }

    public function get_locationState()
    {
        return $this->locationState;
    }

    public function get_locationCity()
    {
        return $this->locationCity;
    }

    public function get_registrationDate()
    {
        return $this->registrationDate;
    }

    public function get_phoneNumber()
    {
        return $this->phoneNumber;
    }

    public function getCurrentLocation()
    {
        return $this->currentLocation;
    }

    public function getUserType()
    {
        return $this->userType;
    }

    public function getUserRef()
    {
        return $this->userRef;
    }

    public function getLocationAddress1()
    {
        return $this->locationAddress_1;
    }

    public function getLocationAddress2()
    {
        return $this->locationAddress_2;
    }

    public function getManagerId()
    {
        return $this->managerId;
    }

    public function getStoreId()
    {
        return $this->storeId;
    }

    public function getHostInfo()
    {
        return $this->host_info;
    }

    public function setCurrentLocation($lat, $lon)
    {
        $currentLocation = new LocationPoint(null, null);

        if (!empty($lat) && !empty($lon)) {
            $currentLocation = new LocationPoint($lat, $lon);
        }

        $this->currentLocation = $currentLocation;

    }

    public function set_db_connector($db_connector)
    {
        $this->db_connector = $db_connector;
    }

    public function set_isLoggedin($isLoggedin)
    {
        $this->isLoggedin = $isLoggedin;
    }

    public function set_isActive($isActive)
    {
        $this->isActive = $isActive;
    }

    public function set_userId($userId)
    {
        $this->userId = $userId;
    }

    public function set_loginToken($loginToken)
    {
        $this->loginToken = $loginToken;
    }

    public function set_email($email)
    {
        $this->email = $email;
    }

    public function set_encrytedPassword($password)
    {
        $this->password = $password;
    }

    public function set_userName($userName)
    {
        $this->userName = $userName;
    }

    public function set_firstName($firstName)
    {
        $this->firstName = $firstName;
    }

    public function set_lastName($lastName)
    {
        $this->lastName = $lastName;
    }

    public function set_gender($gender)
    {
        $this->gender = $gender;
    }

    public function set_locationCountry($locationCountry)
    {
        $this->locationCountry = $locationCountry;
    }

    public function set_locationState($locationState)
    {
        $this->locationState = $locationState;
    }

    public function set_locationCity($locationCity)
    {
        $this->locationCity = $locationCity;
    }

    public function set_registrationDate($registrationDate)
    {
        $this->registrationDate = $registrationDate;
    }

    public function set_phoneNumber($phoneNumber)
    {
        $this->phoneNumber = $phoneNumber;
    }

    public function setUserType($userType)
    {
        $this->userType = $userType;
    }

    public function setUserRef($userRef)
    {
        $this->userRef = $userRef;
    }

    public function setLocationAddress1($locationAddress_1)
    {
        $this->locationAddress_1 = $locationAddress_1;
    }

    public function setLocationAddress2($locationAddress_2)
    {
        $this->locationAddress_2 = $locationAddress_2;
    }

    public function setManagerId($managerId)
    {
        $this->managerId = $managerId;
    }

    public function setStoreId($storeId)
    {
        $this->storeId = $storeId;
    }

    public function signout($user_id, $login_token)
    {
        //$user_type = USER_TYPE_RESEARCHER;
        //$account_state = STATE_ACTIVE;
        $login_state = LOGIN_STATE_INVALID;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token'";
        $update_query = "update " . TABLE_LOGIN . " set login_state = '$login_state' where user_id = '$user_id' and token_id = '$login_token'";

        $result = getErrorStatus(ERROR_MSG_INVALID_LOGIN);


        if ($this->db_connector != null) {
            $login_result = $this->db_connector->query($login_check_query);
            if ($login_result != null && $login_result->is_row_found()) {
                //if we found the record
                $update_result = $this->db_connector->query($update_query);
                if ($update_result != null && $update_result->is_row_affected()) {
                    $result = getOKStatus();
                    $this->isLoggedin = false;
                }

            }
        }

        return $result;

    }

    public function login($username, $password)
    {

        $provided_password = encryptPassword($password);
        $provided_username = strtolower($username);
        //$user_type = USER_TYPE_RESEARCHER;
        $not_deleted = 0;
        //$verified_by_admin = VERIFIED;
        //$verified_email = VERIFIED;

        $result = getErrorStatus(ERROR_MSG_INVALID_CRED);


        if ($this->db_connector != null) {
            $login_query = "select * from " . TABLE_EMPLOYEE . " where lower(username) = '$provided_username' and password = '$provided_password' and deleted = '$not_deleted' and user_type in ('" . USER_TYPE_MANAGER . "','" . USER_TYPE_EMPLOYEE . "','" . USER_TYPE_SUPPLIER . "')";

            $login_result = $this->db_connector->query($login_query);

            if ($login_result != null && $login_result->is_row_found()) {

                if ($row_data = $login_result->fetch_array()) {
                    $actual_uname = $row_data["username"];
                    $actual_pass = $row_data["password"];
                    $user_id = $row_data["person_id"];
                    $user_type = $row_data["user_type"];

                    if (($actual_uname == $provided_username) && ($actual_pass == $provided_password)) {

                        $login_token = generate_token();
                        $login_time = getCurrentTime();
                        $login_state = LOGIN_STATE_VALID;

                        $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id) values ('$login_token','$login_time','$login_state','$user_id')";
                        $details_result = $this->db_connector->query($details_query);

                        if ($details_result != null && $details_result->is_row_affected()) {
                            //$this->isLoggedin = true;

                            $result = getOKStatus();
                            $result["user_id"] = $user_id;
                            $result["user_type"] = $user_type;
                            $result["login_token"] = $login_token;


                            return $result;
                        }

                    }

                }
            }


        }

        return $result;

    }

    public function verifyLogin($user_id, $login_token)
    {//758
        $not_deleted = 0;
        $login_state = LOGIN_STATE_VALID;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = " . $user_id . " and token_id = " . $login_token . " and login_state = " . $login_state;
        $user_check_query = "select * from " . TABLE_EMPLOYEE . " where person_id = '$user_id' and user_type in ('" . USER_TYPE_MANAGER . "','" . USER_TYPE_EMPLOYEE . "') and deleted = '$not_deleted'";

        $result = getErrorStatus(ERROR_MSG_INVALID_TOKEN);


        if ($this->db_connector != null) {
            $login_result = $this->db_connector->query($login_check_query);
            if ($login_result != null && $login_result->is_row_found()) {
                $user_result = $this->db_connector->query($user_check_query);
                if ($user_result != null && $user_result->is_row_found()) {
                    $this->isLoggedin = true;
                    $this->isActive = true;
//                    $result = getOKStatus();

                    return getOKStatus();

                } else {
                    $result = getErrorStatus(ERROR_MSG_USER_SUSPENDED);
                }

            }
        }

        return $result;

    }

    public function initializeMerchant($user_id, $login_token = "")
    {

        //$this->host_info = new HostInfo($this->db_connector);//get all the host info... like [ip_address|country_name|country_code|area_code|currency]

        if ($user_id != null) {
            $this->userId = $user_id;
        } else {
            return false;
        }
        if ($login_token != null) {
            $this->loginToken = $login_token;
        }


        $user_check_query = "select * from " . TABLE_PEOPLE . " where person_id = '$user_id'";
        $employee_check_query = "select * from " . TABLE_EMPLOYEE . " where person_id = '$user_id'";

        if ($this->db_connector != null) {
            $user_result = $this->db_connector->query($user_check_query);
            $employee_result = $this->db_connector->query($employee_check_query);

            if (($user_result != null && $user_result->is_row_found()) && ($employee_result != null && $employee_result->is_row_found())) {
                $row = $user_result->fetch_array();
                $row_emp = $employee_result->fetch_array();

                if ($row != null && $row_emp != null) {
                    $this->email = strtolower($row["email"]);
                    $this->password = $row_emp["password"];
                    $this->userType = $row_emp["user_type"];
                    $this->userRef = $row["user_ref_id"];
                    $this->locationAddress_1 = $row["address_1"];
                    $this->locationAddress_2 = $row["address_2"];
                    $this->phoneNumber = $row["phone_number"];
                    $this->userName = strtolower($row_emp["username"]);
                    $this->firstName = strtolower($row["first_name"]);
                    $this->lastName = strtolower($row["last_name"]);

                    $this->managerId = $row_emp["manager_id"];
                    if ($this->userType == USER_TYPE_MANAGER) {
                        $this->managerId = $row["person_id"];
                    }


                    if ($row["gender"] == GENDER_MALE_CODE) {
                        $this->gender = GENDER_MALE;
                    } elseif ($row["gender"] == GENDER_FEMALE_CODE) {
                        $this->gender = GENDER_FEMALE;
                    } elseif ($row["gender"] == GENDER_NOT_TO_SAY_CODE) {
                        $this->gender = GENDER_NOT_TO_SAY;
                    }


                    $this->registrationDate = $row["created_on"];

                    $this->locationCountry = $row["country"];
                    $this->locationCity = $row["city"];
                    $this->locationState = $row["state"];

                    $account_deleted = $row_emp["deleted"];

                    if ($account_deleted == 0) {
                        $this->isActive = true;
                    }
                    return true;

                }

            }
        }

        return false;


    }

    public function getStoreData()
    {
        $result = array();

        $manager_id = $this->managerId;
        $user_type = USER_TYPE_MANAGER;

        $manager_query = "select * from " . TABLE_PEOPLE . " where person_id = '$manager_id' and user_type = '$user_type'";
        $manager_result = $this->db_connector->query($manager_query);

        if ($manager_result != null && $manager_result->is_row_found()) {

            if ($row = $manager_result->fetch_array()) {
                $result["phone_number"] = $row["phone_number"];
                $result["store_id"] = $row["user_ref_id"];
                $result["manager_id"] = $row["person_id"];

                $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
                $store_result = $this->db_connector->query($store_query);
                if ($store_result != null && $store_result->is_row_found()) {
                    while ($config = $store_result->fetch_array()) {

                        if ($config["key"] == "company") {
                            $result["name"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "company_logo") {
                            $result["logo"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "address") {
                            $result["address"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_code") {
                            $result["currency_code"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_symbol") {
                            $result["currency_symbol"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "fax") {
                            $result["fax"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_decimals") {
                            $result["currency_decimals"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "number_locale") {
                            $result["number_locale"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "discoverable") {
                            $result["discoverable"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "thousands_separator") {
                            $result["thousands_separator"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "country_codes") {
                            $result["country_codes"] = text_clean($config["value"]);
                            //break;
                        }

                        if ($config["key"] == "email") {
                            $result["email"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "financial_year") {
                            $result["financial_year"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "timezone") {
                            $result["timezone"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "phone") {
                            $result["phone"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "store_type") {
                            $result["store_type"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "return_policy") {
                            $result["return_policy"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "coordinates") {
                            $result["coordinates"] = $config["value"];
                            //break;
                        }

                        if ($config["key"] == "data_market_status") {
                            $result["data_market_status"] = $config["value"] == 1;
                            //break;
                        }

                        if ($config["key"] == "store_price") {
                            $result["store_price"] = intval($config["value"]);
                            //break;
                        }
                    }
                }

            }
        }

        return $result;
    }

    public function getStoreData_2($manager_id)
    {
        $result = array();

//        $manager_id = $this->managerId;
        $user_type = USER_TYPE_MANAGER;

        $manager_query = "select * from " . TABLE_PEOPLE . " where person_id = '$manager_id' and user_type = '$user_type'";
        $manager_result = $this->db_connector->query($manager_query);

        if ($manager_result != null && $manager_result->is_row_found()) {

            if ($row = $manager_result->fetch_array()) {
                $result["phone_number"] = $row["phone_number"];
                $result["store_id"] = $row["user_ref_id"];
                $result["manager_id"] = $row["person_id"];

                $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
                $store_result = $this->db_connector->query($store_query);
                if ($store_result != null && $store_result->is_row_found()) {
                    while ($config = $store_result->fetch_array()) {

                        if ($config["key"] == "company") {
                            $result["name"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "company_logo") {
                            $result["logo"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "address") {
                            $result["address"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_code") {
                            $result["currency_code"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_symbol") {
                            $result["currency_symbol"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "fax") {
                            $result["fax"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_decimals") {
                            $result["currency_decimals"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "number_locale") {
                            $result["number_locale"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "discoverable") {
                            $result["discoverable"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "thousands_separator") {
                            $result["thousands_separator"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "country_codes") {
                            $result["country_codes"] = text_clean($config["value"]);
                            //break;
                        }

                        if ($config["key"] == "email") {
                            $result["email"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "financial_year") {
                            $result["financial_year"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "timezone") {
                            $result["timezone"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "phone") {
                            $result["phone"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "store_type") {
                            $result["store_type"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "return_policy") {
                            $result["return_policy"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "coordinates") {
                            $result["coordinates"] = $config["value"];
                            //break;
                        }

                        if ($config["key"] == "data_market_status") {
                            $result["data_market_status"] = $config["value"] == 1;
                            //break;
                        }

                        if ($config["key"] == "store_price") {
                            $result["store_price"] = intval($config["value"]);
                            //break;
                        }
                    }
                }

            }
        }

        return $result;
    }

    public function isDemo()
    {
        $demo_user = 55;

        if ($this->userId == $demo_user) {
            return true;
        }

        return false;
    }

    public function changePassword($user_id, $password)
    {
        $new_password = encryptPassword($password);

        $update_query = "update " . TABLE_EMPLOYEE . " set password = '$new_password' where person_id = '$user_id'";

        $result = getErrorStatus(ERROR_MSG_UN_CHANGED);

        if ($this->db_connector != null) {
            $update_result = $this->db_connector->query($update_query);
            if ($update_result != null && $update_result->is_row_affected()) {
                $result = getOKStatus();
            }
        }

        return $result;
    }

    public function usernameIsValid($username)
    {
        $result = getErrorStatus(ERROR_MSG_INVALID_CRED);
        $result['is_valid'] = false;
        try {
            $Query = "SELECT EXISTS(SELECT username FROM " . TABLE_EMPLOYEE . " WHERE username =  '$username') AS IS_VALID";

            if ($this->db_connector != null) {
                $update_result = $this->db_connector->query($Query);
                $exists = ($update_result->fetch_object())->IS_VALID;
                if ($exists == 1) {
                    $result = getOKStatus();
                    $result['is_valid'] = false;
                    return $result;
                } elseif ($exists == 0) {
                    $result = getOKStatus();
                    $result['is_valid'] = true;
                    return $result;
                }
            }
        } catch (Exception $exception) {
            die($exception);
        }

        return $result;
    }

    public function resetPassword($email)
    {
        $passwordBroker = new PasswordBroker($this->db_connector, $email);

        $token = $passwordBroker->create();

        if ($token == false) return getErrorStatus(ERROR_SENDING_MAIL);

        return $this->sendPasswordResetNotification($token, $email);

    }

    public function sendPasswordResetNotification($token, $email)
    {
        if ((new Notification($token, $email))->sendMail())
            return getOKStatus();
        return getErrorStatus(ERROR_SENDING_MAIL);
    }

    public function completeSale($data, $manager_id)
    {
        $result = getErrorStatus(ERROR_NAME_OP_FAILED);

        if ($this->db_connector != null) {
            try {
                $this->db_connector->transaction();
                $sale_id = $this->sales($data, $manager_id);
                if (!$sale_id) throw new Exception("sale not completed");
                if (!$this->saleItems($data['product_list'], $sale_id)) throw new Exception("sale items not inserted to db");
                if (!$this->salesPayments($sale_id, $data)) throw new Exception("sale payments not inserted");
                $this->db_connector->commit();

                $result = getOKStatus();
                $result['order_id'] = $sale_id;
                return $result;

            } catch (Exception $exception) {
                $this->db_connector->rollback();
            }

        }

        return $result;

    }

    protected function saleItems($items, $sale_id)
    {

        $Query = "INSERT INTO " . TABLE_SALES_ITEMS . " (SALE_ID, ITEM_ID, DESCRIPTION, QUANTITY_PURCHASED, ITEM_COST_PRICE, ITEM_UNIT_PRICE, DISCOUNT, DISCOUNT_TYPE) VALUES ";
        $update_quantities = array();
        foreach ($items as $item) {
            $product_id = text_clean($item['product_id']);
            $description = text_clean($item['description']);
            $quantity_purchased = text_clean($item['quantity_purchased']);
            $unit_price = text_clean($item['unit_price']);
            $item_cost_price = floatval($unit_price) * intval($quantity_purchased);
            $discount_type = getTypePercentage(text_clean($item['discount_type']));
            $discount = text_clean($item['discount']);

            $value = new stdClass();
            $value->quantity = text_clean($item['quantity_purchased']);
            $value->item_id = text_clean($item['product_id']);


            array_push($update_quantities, $value);
            $Query .= "('$sale_id','$product_id','$description', '$quantity_purchased', '$item_cost_price', '$unit_price', '$discount', '$discount_type'),";
        }
        $Query = rtrim($Query, ",");
        if ($this->db_connector != null) {
            $insert_query = $this->db_connector->query($Query);
            if ($insert_query != null && $insert_query->is_row_affected()) {
                (new Item($this->db_connector))->updateProductQuantities($update_quantities, 'sale');
                return true;
            }
        }

        return false;
    }

    protected function salesPayments($sale_id, $data)
    {
        $payment_type = text_clean($data['payment_method']);
        $payment_amount = text_clean($data['payment_total']);
        $employee_id = text_clean($data['user_id']);

        $Query = "INSERT INTO " . TABLE_SALES_PAYMENTS . " (sale_id, payment_type, payment_amount, employee_id) VALUES ('$sale_id', '$payment_type', '$payment_amount', '$employee_id')";
        if ($this->db_connector != null) {
            $insert_query = $this->db_connector->query($Query);
            if ($insert_query != null && $insert_query->is_row_affected()) {
                return true;
            }
        }

        return false;
    }

    protected function sales($data, $manager_id)
    {
        $customer_id = text_clean($data['customer_id']);
        $comment = text_clean($data['comment']);
        $invoice_number = text_clean($data['invoice_number']);
        $quote_number = text_clean($data['quote_number']);
        $sale_type = getSaleType(text_clean($data['sale_type']));


        $Query = "INSERT INTO " . TABLE_SALES . " (customer_id, comment, invoice_number, quote_number, sale_type, manager_id) VALUES ('$customer_id', '$comment', '$invoice_number', '$quote_number', '$sale_type', '$manager_id')";
//        echo "\n$Query\n";
        if ($this->db_connector != null) {
            $insert_query = $this->db_connector->query($Query);
            if ($insert_query != null && $insert_query->is_row_affected()) {
                return $insert_query->insert_id();
            }
        }

        return false;
    }

    function sendMail($to, $subject, $body, $extra_headers = '')
    {
        $headers = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=iso-8859-1' . "\r\n";

        $headers .= 'From: ' . "Queritel" . '<' . "queritel@queritel.co" . "> \r\n";

        if ($extra_headers != '') $headers .= $extra_headers;

        mail($to, $subject, $body, $headers);
        return true;
    }

    function createEmailInvitationBody($url, $organization_name)
    {

        $date = date("M d, Y h:i");
        $timezone = date_default_timezone_get();
        //$url = "https://www.google.com"; //' . $url . '
        $org_name = $organization_name;//"Queritel Business'";


        $body = '
    
    <table style="margin:0 auto;font-family:\'Open Sans\', sans-serif;" border="0" width="600" cellspacing="0" cellpadding="10" bgcolor="#FFFFFF">
   <tbody>
      <tr style="background:#bf0000 none repeat scroll 0px 0px;">
         <td style="padding:0px;">
            <table border="0" width="100%" cellspacing="0" cellpadding="0">
               <tbody>
                  <tr>
                     
                  </tr>
               </tbody>
            </table>
         </td>
      </tr>
   </tbody>
</table>
    
    ';

        //return $timezone;
        return $body;
    }

    public function getOrder($order_id)
    {
        $order_model = new Order($this->db_connector, $order_id);
        $order_data = $order_model->getSalesById();
        if ($order_data == null) return getErrorStatus(ERROR_MSG_USER_UNKNOWN);
        $result = getOKStatus();
        $order_items = $order_model->getSaleItemsByOrderId();
        if ($order_items != null) $order_data['product_list'] = $order_items;
        $result['order_data'] = $order_data;
        return $result;
    }

    public function getGrants($user_id)
    {
        $permissions = (new Permission($this->db_connector, $user_id))->getModulesFromPermissions();

        if (is_null($permissions)) return getErrorStatus(ERROR_MSG_INVALID_LOGIN);
        $result = getOKStatus();
        $result['permissions'] = $permissions;
        return $result;
    }

    public function disableTeamMember($member_id)
    {
        $person_model = new Employee($this->db_connector, $member_id);

        if ($person_model->disableTeamMember()) return getOKStatus();

        return getErrorStatus(ERROR_MSG_USER_UNKNOWN);
    }

    public function enableTeamMember($member_id)
    {
        $person_model = new Employee($this->db_connector, $member_id);

        if ($person_model->enableTeamMember()) return getOKStatus();

        return getErrorStatus(ERROR_MSG_USER_UNKNOWN);
    }

    public function getTeamMember($member_id)
    {
        $employee_model = new Employee($this->db_connector, $member_id);
        $member = $employee_model->getTeamMemberById();
        if (is_null($member)) return getErrorStatus(ERROR_MSG_INVALID_LOGIN);

        $result = getOKStatus();
        $member['permissions'] = (new Permission($this->db_connector, $member_id))->getModulesFromPermissions();
        $result['user_data'] = $member;

        return $result;
    }

    public function getTeamList($manager)
    {
        $employee_model = new Employee($this->db_connector);
        $member = $employee_model->getTeamList($this->managerId);
        if (is_null($member)) return getErrorStatus(ERROR_NAME_OP_FAILED);

        $result = getOKStatus();
        $result['team_list'] = $member;

        return $result;
    }

    public function getWalletData()
    {
        $wallet = new Wallet($this->db_connector, $this->getManagerId());
        $wallet_data = $wallet->getWalletData();
        if (is_null($wallet)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['wallet_data'] = json_decode($wallet_data['wallet_data']);
        return $res;
    }

    public function getPayoutAccountList()
    {
        $wallet = new Wallet($this->db_connector, $this->getManagerId());
        $wallet_data = $wallet->getPayoutAccountList();
        if (is_null($wallet)) return getErrorStatus(ERROR_NAME_OP_FAILED);
        $res = getOKStatus();
        $res['account_list'] = json_decode($wallet_data['payout_accounts']);
        return $res;
    }

    public function addToMarketPlaceSubscriptioncompleteSubscriptions()
    {
//        StripePayment::createCheckoutSession();
//        (new Subscription($this->db_connector))->addPackage($this->getManagerId());

    }

    public function completeSubscription($session_id, $user_id)
    {
        $res = (new Subscription($this->db_connector))->addPackage($user_id, $session_id);
        if ($res['Status'] == 'OK') {
            return getOKStatus();
        }

        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    public function getDashboardList($user_id)
    {

        $res = (new Query($this->db_connector))->sp(SP_GET_DASHBOARD_LIST, array('manager' => $user_id))->findOne();

        if ($res) {
            $response = getOKStatus();
            $response['dashboard_list'] = json_decode($res['dashboard']);
            return $response;
        }

        return getErrorStatus(ERROR_NAME_OP_FAILED);

    }

}