<?php

class Employee
{
    private $conn;
    private $person_id;

    public function __construct($db_connector, $person_id = '')
    {
        $this->conn = $db_connector;
        $this->person_id = $person_id;
    }

    public function enableTeamMember()
    {
        $Query = "UPDATE " . TABLE_EMPLOYEE . " SET disabled = '0' WHERE person_id = '$this->person_id'";

        if ($this->conn != null) {

            if ($this->conn != null) {
                return $this->conn->update($Query);
            }
        }

        return false;
    }

    public function disableTeamMember()
    {
        $Query = "UPDATE " . TABLE_EMPLOYEE . " SET disabled = '1' WHERE person_id = '$this->person_id'";

        if ($this->conn != null) {
            if ($this->conn != null) {
                return $this->conn->update($Query);
            }
        }

        return false;
    }

    public function getTeamMemberById()
    {
        $Query = "SELECT E.person_id as team_member_id, P.first_name as fname, P.last_name as lname, P.email, CASE  WHEN P.gender = 1 THEN 'male' when P.gender = '2' then 'female' else 'not_to_say' end           as gender, P.phone_number, P.address_1 as location_address_1, P.address_2 as location_address_2, P.city as location_city, P.state as location_state, P.zip as postal_code, IF(P.country = '', null , P.country) as country_code FROM " . TABLE_EMPLOYEE . " E INNER JOIN " . TABLE_PEOPLE . " P on E.person_id = P.person_id where E.person_id = '$this->person_id'";

        if ($this->conn != null) {
            $select_query = $this->conn->query($Query);
            if ($select_query != null && $select_query->is_row_affected()) {
                $member = $select_query->fetch_assoc();
                $member['team_member_id'] = intval($member['team_member_id']);
                return $member;
            }
        }

        return null;
    }

    public function getTeamList($manager_id): ?array
    {
        $Query = "SELECT E.person_id as user_id, P.first_name as fname, P.last_name as lname, P.email, P.phone_number, IF(E.disabled, 0,1) as account_enabled, P.user_type FROM " . TABLE_EMPLOYEE . " E INNER JOIN " . TABLE_PEOPLE . " P on E.person_id = P.person_id WHERE E.manager_id = $manager_id";

        if ($this->conn != null) {
            $select_query = $this->conn->query($Query);
            if ($select_query != null) {
                $res = array();
                while ($row = $select_query->fetch_assoc()) {
                    $member = $row;
                    $member['user_id'] = intval($row['user_id']);
                    $member['account_enabled'] = boolval($row['account_enabled']);
                    array_push($res, $member);
                }
                return $res;
            }
        }

        return null;
    }

    public function addEmployee($values)
    {
        $query = get_insert_query(TABLE_EMPLOYEE, $values);
        return !is_null($this->conn) && $this->conn->insert($query);
    }
}