<?php


class Order
{

    private $conn;
    private $order_id;

    /**
     * Order constructor.
     * @param Database $db_connector
     * @param $order_id
     */
    public function __construct(\Database $db_connector, $order_id)
    {
        $this->conn = $db_connector;
        $this->order_id = $order_id;
    }

    public function getSalesById()
    {
        $res = array();
        if ($this->conn != null) {
            $Query = "SELECT S.sale_id as order_id, S.sale_time as order_time, S.customer_id, S.employee_id as team_member_id, S.comment, S.invoice_number, S.quote_number, S.sale_type, IF(S.is_online=0, 'in_store','online') as order_type, S.sale_status as order_status, S.approved, P.payment_type as payment_method, P.payment_amount as sale_total, S.pickup as pickup_time, CONCAT(C.first_name, ' ', C.last_name) as customer_name FROM " . TABLE_SALES . " S left outer join " . TABLE_SALES_PAYMENTS . " P on S.sale_id = P.sale_id left outer join " . TABLE_PEOPLE . " C on S.customer_id = C.person_id WHERE S.sale_id = '$this->order_id'";

            $select_query = $this->conn->query($Query);

            if ($select_query != null && $select_query->is_row_affected()) {
                $rs = $select_query->fetch_object();
                $res['order_id'] = intval($rs->order_id);
                $res['order_time'] = $rs->order_time;
                $res['customer_id'] = $rs->customer_id == null || $rs->customer_id == 0 ? null : intval($rs->customer_id);
                $res['customer_name'] = $rs->customer_name;
                $res['team_member_id'] = intval($rs->team_member_id);
                $res['comment'] = $rs->comment;
                $res['invoice_number'] = intval($rs->invoice_number);
                $res['quote_number'] = intval($rs->quote_number);
                $res['order_type'] = $rs->order_type;
                $res['order_status'] = $this->getOrderStatus($rs->order_status);
                $res['approved'] = boolval($rs->approved);
                $res['payment_method'] = $rs->payment_method;
//                $res['sale_type'] = getSaleTypeByInt($rs->sale_type);
                $res['sale_total'] = intval($rs->sale_total);
                $res['pickup_time'] = $rs->pickup_time;

                return $res;
            }

        }

        return null;
    }


    public function getSaleItemsByOrderId(): ?array
    {

        if ($this->conn != null) {
            $Query = "SELECT SI.sale_id,
       SI.item_id         as product_id,
       I.name             as product_name,
       I.category         as category_name,
       SI.item_unit_price as unit_price,
       SI.quantity_purchased,
       I.pic_url          as image_url,
       I.pic_filename     as image_name,
       SI.discount_type,
       SI.discount,
       I.description
FROM " . TABLE_SALES_ITEMS . " SI
         inner join " . TABLE_ITEMS . " I on SI.item_id = I.item_id WHERE sale_id = '$this->order_id'";

            $select_query = $this->conn->query($Query);

            if ($select_query != null) {
                $result = array();
                while ($row = $select_query->fetch_assoc()) {
                    $row['sale_id'] = intval($row['sale_id']);
                    $row['product_id'] = intval($row['product_id']);
                    $row['unit_price'] = floatval($row['unit_price']);
                    $row['quantity_purchased'] = intval($row['quantity_purchased']);
                    $row['image_url'] = IMG_ITEM_ROOT . $row['image_name'];
                    $row['discount'] = floatval($row['discount']);
                    array_push($result, $row);
                }
                return $result;
            }

        }

        return null;
    }

    public static function getOrderStatus($db_status): string
    {

        if ($db_status == ORDER_COMPLETED) return ORDER_STATUS_COMPLETED;
        elseif ($db_status == ORDER_PENDING) return ORDER_STATUS_PENDING;
        elseif ($db_status == ORDER_CANCELED) return ORDER_STATUS_CANCELLED;
        elseif ($db_status == ORDER_PAID) return ORDER_STATUS_PAID;
        elseif ($db_status == ORDER_CONFIRMED) return ORDER_STATUS_CONFIRMED;
        return "";

    }

    public function getOrderList(string $user_id)
    {
        $query = "select IFNULL(
               concat(
                       '[',
                       group_concat(
                               json_object(
                                       'date', date,
                                       'pickup_date', pickup_date,
                                       'status', status,
                                       'items', items,
                                       'total', total,
                                       'status', status,
                                       'name', name,
                                       'store_id', store_id,
                                       'order_id', order_id
                                   )
                           ),
                       ']'
                   ), '[]') as cart
from (select sale_time                    as date,
             pickup                       as pickup_date,
             case
                 when sale_status = 0 then 'completed'
                 when sale_status = 1 then 'pending'
                 when sale_status = 2 then 'cancelled'
                 when sale_status = 3 then 'confirmed'
                 when sale_status = 4 then 'paid'
                 end                      as status,
             count(SI.quantity_purchased) as items,
             sum(SI.item_unit_price)            as total,
             P.user_ref_id                as store_id,
             value                        as name,
             S.sale_id                    as order_id
      from ospos_sales S
               left outer join ospos_sales_items SI on S.sale_id = SI.sale_id
               left outer join ospos_sales_payments SP on S.sale_id = SP.sale_id
               left outer join ospos_app_config AP on S.manager_id = AP.manager_id
               left outer join ospos_people P on S.manager_id = P.person_id
      where AP.`key` = 'company'
         and customer_id = $user_id
      group by S.sale_id) as items";

        $select_query = $this->conn->query($query);

        if (!is_null($select_query)) {
            $res = $select_query->fetch_assoc();
//            while ($row = $select_query->fetch_assoc()) {
//                $store = (getStoreInfo($this->getStoreId($row['manager']), null, $this->conn));
//                echo json_encode($store);
//                $row['items'] = intval($row['items']);
//                $row['total'] = floatval($row['total']);
//                $row['name'] = $store['name'];
//                array_push($res, $row);
//            }
            $result = getOKStatus();
            $result['order_list'] = json_decode($res['cart']);
            return $result;
        }

        return getErrorStatus(ERROR_NAME_OP_FAILED);
    }

    private function getStoreId($manager)
    {

        $query = "select user_ref_id from " . TABLE_PEOPLE . " where person_id = " . $manager;
        $select_query = $this->conn->query($query);

        if (!is_null($select_query)) {
            return ($select_query->fetch_assoc())['user_ref_id'];
        }

        return null;
    }

}