<?php
ini_set('display_errors', '1');

/**
 * @Author : Kadian Salmon
 * Date : Mar 15, 2021
 * Purpose : process all api request for mobile customer application
 * @link : http://api.queritel.com/api/mobile/cornersave/customer/v1/api.php
 */

header("Access-Control-Allow-Origin: *"); //enable resourse sharing(allows this resource to be shared with "all[*]" requesting clients
header('Content-Type: application/json');

include("../includes/headers/classes-v1.php");//has all the classes needed for queritel back-end
include("../includes/headers/miscellaneous-v1.php");//additional functions
include("../includes/headers/strings.php");//has all the constants needed
include("Service/Customer.php");//has all the constants needed
include("Service/ProductsService.php");//has all the constants needed
include("model/DB.php");//has all the constants needed
include("model/Products.php");//has all the constants needed
include("model/Config.php");//has all the constants needed
include("model/Order.php");//has all the constants needed
include("model/Item.php");//has all the constants needed
include("model/People.php");//has all the constants needed
include("Service/PasswordBroker.php");//has all the constants needed
include("Service/Notification.php");//has all the constants needed

$cornersave = new Database(MAIN_DB_USERNAME, MAIN_DB_PASSWORD, MAIN_DB_NAME, MAIN_DB_HOST);


//API CANCEL STATE
if (isset($_REQUEST["action"]) && $_REQUEST["action"] == "demo") {
    $result = array();

    $result["option"] = "test";


    //for ($x = 0; $x < 5; $x++){
    //echo generate_unique_id("unit") . "<br>";
    //echo getCurrentTime() . "<br>";
    //}

    //echo generate_unique_id("catalog") . "<br>";
    //echo getCurrentTime() . "<br>";


    //echo json_export($result);
}


if (isset($_REQUEST["release"]) && $_REQUEST["release"] == "1.0.0.1") {
}


$skip = true;
if ((isset($_REQUEST["release"]) && $_REQUEST["release"] == "development") || $skip) {
    $release = $_REQUEST["release"];
    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];

    if ($action == ACTION_LOCALE_CONVERSION) {
        $data = json_decode($param_json, true);

        $number_locale = text_clean($data["number_locale"]);
        $value = text_clean($data["value"]);

        $result = array();

        $formatted_locale = str_replace('_', '-', $number_locale);

        $fmt = new NumberFormatter($formatted_locale, NumberFormatter::DECIMAL);

        //$separator = $fmt->getSymbol(NumberFormatter::GROUPING_SEPARATOR_SYMBOL);
        //$fmt->setAttribute(NumberFormatter::FRACTION_DIGITS, 2);
        //$fmt->setSymbol(NumberFormatter::GROUPING_SEPARATOR_SYMBOL, "*");


        $result["number_locale"] = str_replace('_', '-', $fmt->getLocale());
        $result["currency_code"] = $fmt->getSymbol(NumberFormatter::INTL_CURRENCY_SYMBOL);
        $result["currency_symbol"] = $fmt->getSymbol(NumberFormatter::CURRENCY_SYMBOL);
        $result["converted_value"] = $fmt->format($value);

        echo json_export($result);
    }
    if ($action == ACTION_LOG_IN) {
        $data = json_decode($param_json, true);

        $username = strtolower(text_clean($data["user_name"]));
        $password = text_clean($data["password"]);


        $customer = new Customer($cornersave);
        $result = $customer->login($username, $password);


        echo json_export($result);

    }
    if ($action == ACTION_LOG_OUT) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);

        $result = $customer->signout($user_id, $login_token);

        echo json_encode($result);

    }
    if ($action == ACTION_AUTHENTICATE_USER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        //debugAPIResponse(ACTION_AUTHENTICATE_USER,json_encode($data,JSON_PRETTY_PRINT));


        $customer = new Customer($cornersave);
        $result = $customer->verifyLogin($user_id, $login_token);

        echo json_export($result);
    }


    //todo : add constant
    /*
        ACTION_LOG_IN = "log_in" //()
        ACTION_LOG_OUT = "log_out" //()
        ACTION_AUTHENTICATE_USER = "authenticate_user" //()
        ACTION_SIGN_UP = "sign_up" //()
        ACTION_PROFILE_DATA_GET = "get_profile_data" //()
        ACTION_PROFILE_DATA_SET = "set_profile_data" //()
        ACTION_PASSWORD_CHANGE = "change_password" //()
        ACTION_PASSWORD_RESET = "reset_password" //()
        ACTION_GET_STORE_LIST = "get_store_list" //()
        ACTION_GET_STORE_DATA = "get_store_data" //()
        ACTION_ADD_STORE = "add_store" //()
        ACTION_GET_PRODUCT_LIST = "get_product_list" //()
        ACTION_GET_PRODUCT_DATA = "get_product_data" //()
        ACTION_SEARCH_PRODUCT_LIST = "get_search_product_list" //()
        ACTION_GET_CATEGORY_PRODUCT_LIST = "get_category_product_list" //()
        ACTION_GET_PROMOTION_LIST = "get_promotion_list"
        ACTION_GET_PROMOTION_DATA = "get_promotion_data" //()
        ACTION_CLAIM_GIFT = "claim_gift" //()
        ACTION_GET_CATEGORY_LIST = "get_category_list" //()
        ACTION_COMPLETE_ORDER = "complete_order" //()
        ACTION_TRIGGER_PAYMENT = "trigger_payment" //()
        ACTION_GET_ORDER_LIST = "get_order_list" //()
        ACTION_GET_ORDER_DATA = "get_order_data" //()
        ACTION_CANCEL_ORDER = "cancel_order" //()

        ACTION_GET_MSG_LIST = "get_msg_list" //(This gets a list of messages categorized by [store])
        ACTION_GET_MSG_THREAD = "get_msg_thread" //(Message thread for messages after selecting a message from the list)
        ACTION_GET_MSG_RECIPIENTS = "get_msg_recipient" //(this is a list of store recipient options)

        ACTION_SEND_NOTIFICATION_ID = "send_notification_id" //(Used to send the the firebase token to the cornersave server)
        ACTION_SEND_MSG = "send_msg" //(To send messages)
        ACTION_MARK_AS_READ = "mark_as_read" //(to mark the messages as Read)
    */


    if ($action == ACTION_REMOVE_STORE) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $store_id = text_clean($data["store_id"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if ($isVerified["status"] == STATUS_OK) {
            $result = $customer->removeStore($store_id, $user_id);
        }

        echo json_export($result);
    }

    if ($action == ACTION_ADD_STORE) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $store_id = text_clean($data["store_id"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if ($isVerified["status"] == STATUS_OK) {
            $result = $customer->addStore($store_id, $user_id);
        }

        echo json_export($result);
    }

    if ($action == ACTION_GET_MY_STORE_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
//        $store_id = text_clean($data["store_id"]);
//        $lat = text_clean($data["lat"]);
//        $lng = text_clean($data["lng"]);

        //todo : API Debug
        //debugAPIResponse("get_store_list",json_encode($data,JSON_PRETTY_PRINT));


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if ($isVerified["status"] == STATUS_OK) {
            $result = $customer->getStoreList($user_id);

        }

        echo json_export($result);
    }

    if ($action == ACTION_GET_STORE_LIST) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $lat = text_clean($data["lat"]);
        $lng = text_clean($data["lng"]);

        //todo : API Debug
        //debugAPIResponse("get_store_list",json_encode($data,JSON_PRETTY_PRINT));


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if ($isVerified["status"] == STATUS_OK) {

            if ($customer->isLoggedin()) {
                $customer->initializeCustomer($user_id);
                $customer->setCurrentLocation($lat, $lng);
            }

            $store_list = getStoreList($cornersave, $customer);
            $result = getOKStatus();

//            $result = (new Config($cornersave, $user_id))->getStoreList();

            if (isset($store_list)) {
                $result["store_list"] = $store_list;
            } else {
                $result["store_list"] = array();
            }


        }

        echo json_export($result);
    }

    if ($action == "get_category_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $store_id = text_clean($data["store_id"]);

        //todo : API Debug
        //debugAPIResponse("get_category_list",json_encode($data,JSON_PRETTY_PRINT));


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if ($isVerified["status"] == STATUS_OK) {

            if ($customer->isLoggedin()) {
                $customer->initializeCustomer($user_id);
                $customer->setCurrentLocation($lat, $lng);
            }

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $store_info = getStoreInfo($store_id, $customer, $cornersave);
            $manager_id = $store_info["manager_id"];

            if ($manager_id != null) {
                $result = getOKStatus();
                $result['category_list'] = getCategoryList($manager_id, $cornersave);

                $string_json = '{
                  "status": "OK",
                  "category_list": [
                    {
                      "category_name": "Promotion",
                      "category_id": "promotion",
                      "quantity_items": 0
                    },
                    {
                      "category_name": "Bebidas",
                      "category_id": "bebidas",
                      "quantity_items": 0
                    },
                    {
                      "category_name": "Dulces",
                      "category_id": "dulces",
                      "quantity_items": 0
                    },
                    {
                      "category_name": "Panadería",
                      "category_id": "panaderia",
                      "quantity_items": 2
                    }
                  ]
                }';

                $obj = json_decode($string_json, true);


//                if (isset($category_list)) {
//                    $result = getOKStatus();
//                    $result["category_list"] = $category_list;
//                    $result["category_list"] = $obj["category_list"];
//                }
            }

        }

        echo json_export($result);
    }


    //todo: ============== ACTION APIs  ===========================
    //TODO : THESE API WERE COPIED FROM MERCHANT AND ARE NOT SUPPORTED BY THE CUSTOMER APPLICATION
    if ($action == "template") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $lat = text_clean($data["lat"]);
        $lng = text_clean($data["lng"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;

        if ($isVerified["status"] == STATUS_OK) {

            if ($customer->isLoggedin()) {
                $customer->initializeCustomer($user_id);
                $customer->setCurrentLocation($lat, $lng);
            }

            $result = getOKStatus();

        }

        echo json_export($result);
    }

    if ($action == ACTION_STORE_DATA_GET) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);


            $store_data = $customer->getStoreData();

            if (!empty($store_data)) {
                $data = array();
                $result = getOKStatus();

                $user_data["store_name"] = $store_data["name"];
                $user_data["phone_number"] = $store_data["phone"];
                $user_data["store_id"] = $store_data["store_id"];
                $user_data["logo"] = (empty($store_data["logo"]) ? IMG_LOGO_DEFAULT : $store_data["logo"]);
                $user_data["logo_url"] = IMG_LOGO_ROOT . $store_data["logo"];
                $user_data["currency_code"] = $store_data["currency_code"];
                $user_data["currency_decimals"] = $store_data["currency_decimals"];
                $user_data["discoverable"] = $store_data["discoverable"];
                $user_data["email"] = $store_data["email"];
                $user_data["country_code"] = $store_data["country_codes"];
                $user_data["store_type"] = (empty($store_data["store_type"]) ? STORE_TYPE_GROCERYSTORE : $store_data["store_type"]);
                $user_data["address"] = $store_data["address"];
                $user_data["coordinates"] = (empty($store_data["coordinates"]) ? array() : json_decode($store_data["coordinates"], true));

                //$result["store_date"] = $user_data;
                $result["store_date"] = $user_data;

            }

        }

        echo json_export($result);
    }
    if ($action == ACTION_PROFILE_DATA_GET) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = $customer->getLocationAddress1();
            $user_data["location_address_2"] = $customer->getLocationAddress2();
            $user_data["location_city"] = $customer->get_locationCity();
            $user_data["location_state"] = $customer->get_locationState();
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();

            $result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    if ($action == ACTION_PROFILE_DATA_SET) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {

            $result = $customer->setProfileData($data);
//            $customer->initializeCustomer($user_id);

//            $result = getOKStatus();

            /* request

            {
                    "user_id":21654,
                    "login_token":849345537,
                    "fname": "Kevin", //([First name])
                    "lname": "Smith", //([Last name])
                    "user_name": "Smith", //([user name - used for login])
                    "email": "kevin.smith@queritel.com", //([Email])
                    "gender": "male", //([GENDER CONSTANTS])
                    "phone_number": "866811467", //([Phone Number])
                    "location_address_1": "", //([Address 1])
                    "location_address_2": "", //([Address 2])
                    "location_city": "", //([City])
                    "location_state": "", //([State / municipality])
                    "postal_code": "", //([Postal code])
                    "country_code": "CL" //([Country code])

                }

             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }

    if ($action == ACTION_PASSWORD_RESET) {
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse(ACTION_PASSWORD_RESET, json_encode($data, JSON_PRETTY_PRINT));

        $email = text_clean($data["email"]);

        $merchant = new Customer($cornersave);

        $result = $merchant->resetPassword($email);

        echo json_export($result);
    }


    if ($action == ACTION_PASSWORD_CHANGE) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $old_password = text_clean($data["password"]);
        $new_password = text_clean($data["new_password"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            if (encryptPassword($old_password) == $customer->get_encrytedPassword()) {
                $result = $customer->changePassword($user_id, $new_password);
            } else {
                $result = getErrorStatus(ERROR_MSG_INVALID_CRED);
            }
        }

        echo json_export($result);
    }

    if ($action == ACTION_SIGN_UP) {
        $data = json_decode($param_json, true);

        $customer = new Customer($cornersave);
        $result = $customer->signUp($data);

        echo json_export($result);
    }


    //======== module_team =========
    //ACTION_GET_PERMISSIONS = "get_permissions" //(--)
    //ACTION_GET_TEAM_LIST = "get_team_list" //(--)
    //ACTION_GET_TEAM_MEMBER = "get_team_member" //(--)
    //ACTION_UPDATE_TEAM_MEMBER = "update_team_member" //(--)
    //ACTION_ADD_TEAM_MEMBER = "add_team_member" //(--)
    //ACTION_DISABLE_TEAM_MEMBER = "disable_team_member" //(--)
    //ACTION_ENABLE_TEAM_MEMBER = "enable_team_member" //(--)
    //ACTION_DELETE_TEAM_MEMBER = "delete_team_member" //(--)

    if ($action == "get_permissions") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $p_array = array();
            $p_array[] = "config";
            $p_array[] = "customers";
            $p_array[] = "employees";
            $p_array[] = "expenses";
            $p_array[] = "giftcards";
            $p_array[] = "item_kits";
            $p_array[] = "items";
            $p_array[] = "managers";
            $p_array[] = "messages";
            $p_array[] = "sales";
            $p_array[] = "preorders";
            $p_array[] = "receivings";
            $p_array[] = "reports";
            $p_array[] = "suppliers";
            $p_array[] = "catalog";
            $p_array[] = "supplier_market";

            $modules = getModulesFromPermissions($p_array);


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            $result["permissions"] = $modules;

        }

        echo json_export($result);
    }
    if ($action == "get_team_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            //$customer->getManagerId();

            $result = getOKStatus();

            //$customer->getHostInfo()->getCountry_code();


            $code = '{
                "status": "OK",
                "team_list": [
                    {
                        "user_id": 25,
                        "fname": "John", 
                        "lname": "Nixon", 
                        "email": "john.nixon@cornersave.com", 
                        "phone_number": "8668114567", 
                        "account_enabled": false,
                        "user_type": "type_emp"
                        
                    },
                    {
                        "user_id": 30,
                        "fname": "Alton", 
                        "lname": "Wilson", 
                        "email": "alton.wilson@cornersave.com", 
                        "phone_number": "8662739845", 
                        "account_enabled": true,
                        "user_type": "type_emp"
                    }
                ]
            }';


            $code_obj = json_decode($code, true);


            $result["team_list"] = $code_obj["team_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_team_member") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $member_id = text_clean($data["team_member_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "team_member_id":25
            }
            */

            $user_data["25"]["team_member_id"] = 25;
            $user_data["25"]["fname"] = "John";
            $user_data["25"]["lname"] = "Nixon";
            $user_data["25"]["user_name"] = "j_nixon_emp";
            $user_data["25"]["email"] = "john.nixon@cornersave.com";
            $user_data["25"]["gender"] = "male";
            $user_data["25"]["phone_number"] = "8668114567";
            //$user_data["25"]["location_address_1"] = text_export("220 Loreto Recoleta, Santiago Metropolitan Region");
            $user_data["25"]["location_address_1"] = "220 Loreto Recoleta, Santiago Metropolitan Region";
            $user_data["25"]["location_address_2"] = "";
            $user_data["25"]["location_city"] = "";
            $user_data["25"]["location_state"] = "Santiago";
            $user_data["25"]["postal_code"] = "";
            $user_data["25"]["country_code"] = "CL";

            $perm = '[
                    "module_configuration",
                    "module_customer",
                    "module_team",
                    "module_expense",
                    "module_giftcard",
                    "module_promotion",
                    "module_item",
                    "module_message",
                    "module_order",
                    "module_receiving",
                    "module_report",
                    "module_sale",
                    "module_supplier",
                    "module_catalog"
                ]';
            $user_data["25"]["permissions"] = json_decode($perm, true);

            $user_data["30"]["team_member_id"] = 30;
            $user_data["30"]["fname"] = "Alton";
            $user_data["30"]["lname"] = "Wilson";
            $user_data["30"]["user_name"] = "a_wilson_emp";
            $user_data["30"]["email"] = "alton.wilson@cornersave.com";
            $user_data["30"]["gender"] = "male";
            $user_data["30"]["phone_number"] = "8662739845";
            $user_data["30"]["location_address_1"] = "Avenida los molinos 1886";
            $user_data["30"]["location_address_2"] = "";
            $user_data["30"]["location_city"] = "Santiago";
            $user_data["30"]["location_state"] = "Región Metropolitana de Santiago";
            $user_data["30"]["postal_code"] = "";
            $user_data["30"]["country_code"] = "CL";
            $perm = '[
                    "module_configuration",
                    "module_customer",
                    "module_team",
                    "module_expense",
                    "module_giftcard",
                    "module_promotion",
                    "module_item",
                    "module_message",
                    "module_order",
                    "module_receiving",
                    "module_report",
                    "module_sale",
                    "module_supplier",
                    "module_catalog"
                ]';
            $user_data["30"]["permissions"] = json_decode($perm, true);


            if ($member_id == 25 || $member_id == 30) {

                $result = getOKStatus();

                $result["user_data"] = $user_data[$member_id];

            }


        }

        echo json_export($result);
    }
    if ($action == "update_team_member") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "team_member_id":25, //([the id for the team member])
                    "fname": "John",
                    "lname": "Nixon",
                    "user_name": "j_nixon_emp",
                    "new_password": "my.pass",
                    "email": "john.nixon@cornersave.com",
                    "gender": "male",
                    "phone_number": "8668114567",
                    "location_address_1": "220 Loreto Recoleta, Santiago Metropolitan Region",
                    "location_address_2": "",
                    "location_city": "",
                    "location_state": "Santiago",
                    "postal_code": "",
                    "country_code": "CL",
                    "permissions": [
                        "module_configuration",
                        "module_customer",
                        "module_team",
                        "module_expense",
                        "module_giftcard",
                        "module_promotion",
                        "module_item",
                        "module_message",
                        "module_order",
                        "module_receiving",
                        "module_report",
                        "module_sale",
                        "module_supplier",
                        "module_catalog"
                    ]

                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "add_team_member") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "fname": "John",
                    "lname": "Nixon",
                    "user_name": "j_nixon_emp",
                    "new_password": "my.pass",
                    "email": "john.nixon@cornersave.com",
                    "gender": "male",
                    "phone_number": "8668114567",
                    "location_address_1": "220 Loreto Recoleta, Santiago Metropolitan Region",
                    "location_address_2": "",
                    "location_city": "",
                    "location_state": "Santiago",
                    "postal_code": "",
                    "country_code": "CL",
                    "permissions": [
                        "module_configuration",
                        "module_customer",
                        "module_team",
                        "module_expense",
                        "module_giftcard",
                        "module_promotion",
                        "module_item",
                        "module_message",
                        "module_order",
                        "module_receiving",
                        "module_report",
                        "module_sale",
                        "module_supplier",
                        "module_catalog"
                    ]

                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "disable_team_member") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $member_id = text_clean($data["team_member_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();


            /* Request
            {
                    "user_id": 21654,
                    "login_token": 849345537,
                    "team_member_id":25
                }
            */

            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "enable_team_member") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $member_id = text_clean($data["team_member_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();


            /* Request
            {
                    "user_id": 21654,
                    "login_token": 849345537,
                    "team_member_id":25
                }
            */

            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "delete_team_member") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "team_member_id":25, //([the id for the team member])

                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    //======== module_supplier =========
    //ACTION_GET_SUPPLIER_LIST = "get_supplier_list" //(--)
    //ACTION_GET_SUPPLIER_DATA = "get_supplier_data" //(--)
    //ACTION_UPDATE_SUPPLIER = "update_supplier" //(--)
    //ACTION_ADD_SUPPLIER = "add_supplier" //(--)
    //ACTION_DELETE_SUPPLIER = "delete_supplier" //(--)

    //change user_type of supplier to type_supply (in database table - ospos_people)
    if ($action == "get_supplier_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1


            $code = '{
                "status": "OK",
                "supplier_list": [
                    {
                        "supplier_id": 163,
                        "company_name": "Jon Dist",
                        "email": "c_fernandez_supply@cornersave.com", 
                        "phone_number": "8669284724", 
                        "supplier_category": "goods_supplier",
                        "market_place_id": null
                    },
                    {
                        "supplier_id": 22,
                        "company_name": "CCU", 
                        "email": "e_jenkings@cornersave.com", 
                        "phone_number": "8662847290", 
                        "supplier_category": "cost_supplier",
                        "market_place_id": "8769856"
                    }
                ]
            }';

            $code_obj = json_decode($code, true);


            $result["supplier_list"] = $code_obj["supplier_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_supplier_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $supplier_id = text_clean($data["supplier_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $supplier_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "supplier_id":163
            }
            */

            $supplier_data["163"]["company_name"] = "Jon Dist";
            $supplier_data["163"]["supplier_id"] = 163;
            $supplier_data["163"]["fname"] = "Curnel";
            $supplier_data["163"]["lname"] = "Fernandez";
            $supplier_data["163"]["email"] = "c_fernandez_supply@cornersave.com";
            $supplier_data["163"]["supplier_category"] = "goods_supplier";
            $supplier_data["163"]["gender"] = "male";
            $supplier_data["163"]["phone_number"] = "8669284724";
            $supplier_data["163"]["location_address_1"] = "354 Flestol Recoleta, Santiago Metropolitan Region";
            $supplier_data["163"]["location_address_2"] = "";
            $supplier_data["163"]["location_city"] = "Santiago";
            $supplier_data["163"]["location_state"] = "Región Metropolitana";
            $supplier_data["163"]["postal_code"] = "";
            $supplier_data["163"]["country_code"] = "CL";
            $supplier_data["163"]["comments"] = "Delivering to all";
            $supplier_data["163"]["account_number"] = "";
            $supplier_data["163"]["tax_id"] = "";


            $supplier_data["22"]["company_name"] = "CCU";
            $supplier_data["22"]["supplier_id"] = 22;
            $supplier_data["22"]["fname"] = "Everton";
            $supplier_data["22"]["lname"] = "Jenkins";
            $supplier_data["22"]["email"] = "e_jenkings@cornersave.com";
            $supplier_data["22"]["supplier_category"] = "cost_supplier";
            $supplier_data["22"]["gender"] = "male";
            $supplier_data["22"]["phone_number"] = "8662847290";
            $supplier_data["22"]["location_address_1"] = "Denaves dos meltos";
            $supplier_data["22"]["location_address_2"] = "";
            $supplier_data["22"]["location_city"] = "Santiago";
            $supplier_data["22"]["location_state"] = "Región Metropolitana de Santiago";
            $supplier_data["22"]["postal_code"] = "";
            $supplier_data["22"]["country_code"] = "CL";
            $supplier_data["22"]["comments"] = "";
            $supplier_data["22"]["account_number"] = "";
            $supplier_data["22"]["tax_id"] = "";


            if ($supplier_id == 163 || $supplier_id == 22) {

                $result = getOKStatus();

                $result["supplier_data"] = $supplier_data[$supplier_id];

            }

        }

        echo json_export($result);
    }
    if ($action == "add_supplier") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "company_name": "Jon Dist",
                    "fname": "Curnel",
                    "lname": "Fernandez",
                    "email": "c_fernandez_supply@cornersave.com",
                    "supplier_category": "goods_supplier",
                    "gender": "male",
                    "phone_number": "8669284724",
                    "location_address_1": "354 Flestol Recoleta, Santiago Metropolitan Region",
                    "location_address_2": "",
                    "location_city": "Santiago",
                    "location_state": "Región Metropolitana",
                    "postal_code": "",
                    "country_code": "CL",
                    "comments": "Delivering to all",
                    "account_number": "",
                    "tax_id": ""
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "update_supplier") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "supplier_id":163,
                    "company_name": "Jon Dist",
                    "fname": "Curnel",
                    "lname": "Fernandez",
                    "email": "c_fernandez_supply@cornersave.com",
                    "supplier_category": "goods_supplier",
                    "gender": "male",
                    "phone_number": "8669284724",
                    "location_address_1": "354 Flestol Recoleta, Santiago Metropolitan Region",
                    "location_address_2": "",
                    "location_city": "Santiago",
                    "location_state": "Región Metropolitana",
                    "postal_code": "",
                    "country_code": "CL",
                    "comments": "Delivering to all",
                    "account_number": "",
                    "tax_id": ""
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "delete_supplier") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "supplier_id":163, //([the id for the supplier])

                }
             */

            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    //======== module_customer =========
    //ACTION_GET_CUSTOMER_LIST = "get_customer_list" //(--)
    //ACTION_GET_CUSTOMER_DATA = "get_customer_data" //(--)
    //ACTION_ADD_CUSTOMER = "add_customer" //(--)
    //ACTION_UPDATE_CUSTOMER = "update_customer" //(--)
    //ACTION_DELETE_CUSTOMER = "delete_customer" //(--)

    if ($action == "get_customer_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1


            $code = '{
                "status": "OK",
                "customer_list": [
                    {
                        "customer_id": 4,
                        "fname": "Sarah",
                        "lname": "Connor",
                        "email": "sarah.conner@cornersave.com", 
                        "phone_number": "8668375463", 
                        "points": 0,
                        "total_spent": 0
                    },
                    {
                        "customer_id": 12,
                        "fname": "Kevin",
                        "lname": "Smith",
                        "email": "kevin.smith@queritel.com", 
                        "phone_number": "8764420992", 
                        "points": 0,
                        "total_spent": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);


            $result["customer_list"] = $code_obj["customer_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_customer_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $customer_id = text_clean($data["customer_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $customer_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "customer_id":4
            }
            */

            $customer_data["4"]["customer_id"] = 4;
            $customer_data["4"]["fname"] = "Sarah";
            $customer_data["4"]["lname"] = "Connor";
            $customer_data["4"]["email"] = "sarah.conner@cornersave.com";
            $customer_data["4"]["phone_number"] = "8668375463";
            $customer_data["4"]["gender"] = "female";
            $customer_data["4"]["points"] = 0;
            $customer_data["4"]["total_spent"] = 0;
            $customer_data["4"]["discount_type"] = "type_percentage";
            $customer_data["4"]["discount"] = 2;


            $customer_data["12"]["customer_id"] = 12;
            $customer_data["12"]["fname"] = "Kevin";
            $customer_data["12"]["lname"] = "Smith";
            $customer_data["12"]["email"] = "kevin.smith@queritel.com";
            $customer_data["12"]["phone_number"] = "8764420992";
            $customer_data["12"]["gender"] = "male";
            $customer_data["12"]["points"] = 0;
            $customer_data["12"]["total_spent"] = 0;
            $customer_data["12"]["discount_type"] = "type_fixed";
            $customer_data["12"]["discount"] = 20;


            if ($customer_id == 4 || $customer_id == 12) {

                $result = getOKStatus();

                $result["customer_data"] = $customer_data[$customer_id];

            }

        }

        echo json_export($result);
    }
    if ($action == "add_customer") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "fname": "Sarah",
                    "lname": "Connor",
                    "email": "sarah.conner@cornersave.com",
                    "gender": "female",
                    "phone_number": "8668375463",
                    "location_address_1": "Guardia Vieja 255 Of. 604",
                    "location_address_2": "",
                    "location_city": "Providencia",
                    "location_state": "Providencia",
                    "postal_code": "",
                    "country_code": "CL",
                    "date_of_birth": "YYYY-MM-DD",
                    "discount_type": "type_percentage",
                    "discount": 2
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "update_customer") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "customer_id": 4,
                    //"fname": "Sarah",
                    //"lname": "Connor",
                    //"email": "sarah.conner@cornersave.com",
                    //"phone_number": "8668375463",
                    //"gender": "female",
                    "points": 0, //(The accumulated points)
                    "total_spent": 0, //(the total spent)
                    "discount_type": "type_percentage", //([DISCOUNT-TYPE CONSTANT])
                    "discount": 2
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "delete_customer") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "customer_id":12, //([the id for the customer])

                }
             */

            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    //======== module_item =========
    //ACTION_GET_PRODUCT_LIST = "get_product_list" //(--)
    //ACTION_GET_PRODUCT_DATA = "get_product_data" //(--)
    //ACTION_ADD_PRODUCT = "add_product" //(--)
    //ACTION_UPDATE_PRODUCT = "update_product" //(--)
    //ACTION_DELETE_PRODUCT = "delete_product" //(--)

    if ($action == ACTION_GET_PRODUCT_LIST) {
        $data = json_decode($param_json, true);
        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $store_id = text_clean($data["store_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = (new ProductsService($cornersave, $customer->getManagerId()))->getProductList($data, $store_id);
            //goods_supplier = 0
            //cost_supplier = 1

            //TODO information to be added the product list
            //brand
            //unit value
            //unit label

            $code = '{
                "status": "OK",
                "product_list": [
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "cost_price": 0.00, 
                        "unit_price": 10.00, 
                        "quantity": 0,
                        "brand": "Lider",
                        "unit_value": 500,
                        "unit_label": "g",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "catalog_id": "cid-mowvgil-0117851-memqqnx",
                        "product_type": "type_item",
                        "barcode" : "9208455739873"
                    },
                    {
                        "product_id": 143,
                        "product_name": "Masa Pre Pizza Tradicional",
                        "category_name": "Panadería",
                        "cost_price": 0.00, 
                        "unit_price": 24.00, 
                        "quantity": 0,
                        "brand": "Lider",
                        "unit_value": 1,
                        "unit_label": "Un",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
                        "image_name": "581446.jpg",
                        "catalog_id": null,
                        "product_type": "type_item",
                        "barcode" : "1735649201482"
                    },
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "cost_price": 0.00, 
                        "unit_price": 13.00, 
                        "quantity": 0,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "catalog_id": "cid-dlsnfjc-9385729-slrfkdf",
                        "product_type": "type_item",
                        "barcode" : "9857392874639"
                    }
                   
                ]
            }';

//            $code_obj = json_decode($code, true);


//            $result["product_list"] = $code_obj["product_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_product_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $product_id = text_clean($data["product_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $product_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "product_id": 142
            }
            */
            /*
                        $product_data["142"]["product_id"] = 142;
                        $product_data["142"]["product_name"] = "Pan De Molde 500 Gr";
                        $product_data["142"]["category_name"] = "Panadería";
                        $product_data["142"]["cost_price"] = 0.0;
                        $product_data["142"]["unit_price"] = 10.0;
                        $product_data["142"]["quantity"] = 0;
                        $product_data["142"]["image_url"] = "https://app.cornersave.com/public/uploads/item_pics/704080.jpg";
                        $product_data["142"]["image_name"] = "704080.jpg";
                        $product_data["142"]["catalog_id"] = "cid-mowvgil-0117851-memqqnx";
                        $product_data["142"]["barcode"] = "9208455739873";
                        $product_data["142"]["brand"] = "Lider";
                        $product_data["142"]["unit_value"] = "500";
                        $product_data["142"]["unit_label"] = "g";
                        $product_data["142"]["stock_type"] = "stock"; //stock -- non_stock
                        $product_data["142"]["supplier_id"] = 22; //22
                        $product_data["142"]["receiving_quantity"] = 1;
                        $product_data["142"]["reorder_level"] = 0;
                        $product_data["142"]["description"] = "";
                        //$product_data["142"]["tax_names"] = [];
                        //$product_data["142"]["tax_percents"] = [];


                        $product_data["143"]["product_id"] = 143;
                        $product_data["143"]["product_name"] = "Masa Pre Pizza Tradicional";
                        $product_data["143"]["category_name"] = "Panadería";
                        $product_data["143"]["cost_price"] = 0.00;
                        $product_data["143"]["unit_price"] = 24.00;
                        $product_data["143"]["quantity"] = 0;
                        $product_data["143"]["image_url"] = "https://app.cornersave.com/public/uploads/item_pics/581446.jpg";
                        $product_data["143"]["image_name"] = "581446.jpg";
                        $product_data["143"]["catalog_id"] = null;
                        $product_data["143"]["barcode"] = "1735649201482";
                        $product_data["143"]["brand"] = "Lider";
                        $product_data["143"]["unit_value"] = "1";
                        $product_data["143"]["unit_label"] = "Un";
                        $product_data["143"]["stock_type"] = "stock"; //stock -- non_stock
                        $product_data["143"]["supplier_id"] = 22; //22
                        $product_data["143"]["receiving_quantity"] = 1;
                        $product_data["143"]["reorder_level"] = 0;
                        $product_data["143"]["description"] = "";
                        //$product_data["143"]["tax_names"] = [];
                        //$product_data["143"]["tax_percents"] = [];


                        $product_data["150"]["product_id"] = 150;
                        $product_data["150"]["product_name"] = "Yoghurt Batido Sabor Vainilla Bolsa";
                        $product_data["150"]["category_name"] = "Lácteos";
                        $product_data["150"]["cost_price"] = 0.00;
                        $product_data["150"]["unit_price"] = 13.00;
                        $product_data["150"]["quantity"] = 0;
                        $product_data["150"]["image_url"] = "https://app.cornersave.com/public/uploads/item_pics/264322.jpg";
                        $product_data["150"]["image_name"] = "264322.jpg";
                        $product_data["150"]["catalog_id"] = "cid-dlsnfjc-9385729-slrfkdf";
                        $product_data["150"]["barcode"] = "9857392874639";
                        $product_data["150"]["brand"] = "Colun";
                        $product_data["150"]["unit_value"] = "1";
                        $product_data["150"]["unit_label"] = "Kg";
                        $product_data["150"]["stock_type"] = "stock"; //stock -- non_stock
                        $product_data["150"]["supplier_id"] = 22; //22
                        $product_data["150"]["receiving_quantity"] = 1;
                        $product_data["150"]["reorder_level"] = 0;
                        $product_data["150"]["description"] = "";
                        //$product_data["150"]["tax_names"] = [];
                        //$product_data["150"]["tax_percents"] = [];


                        if ($product_id == 142 || $product_id == 143 || $product_id == 150) {

            //                $result = getOKStatus();

            //                $result["product_data"] = $product_data[$product_id];

                        }
            */
            $result = getOKStatus();

            $product_item = get_product_info($product_id, $cornersave);
            if ($product_item != null) {
                $product_data["product_id"] = intval($product_id);
                $product_data["product_name"] = $product_item["product_name"];
                $product_data["category_name"] = $product_item["category_name"];
                $product_data["cost_price"] = intval($product_item["cost_price"]);
                $product_data["unit_price"] = intval($product_item["unit_price"]);
                $product_data["quantity"] = intval($product_item["quantity"]);
                $product_data["brand"] = $product_item["brand"];
                $product_data["unit_value"] = $product_item["unit_value"];
                $product_data["unit_label"] = $product_item["unit_label"];
                $product_data["image_url"] = $product_item["image_url"];
                $product_data["image_name"] = $product_item["image_name"];
                $product_data["catalog_id"] = $product_item["catalog_id"];
                $product_data["product_type"] = $product_item["product_type"]; //$row["product_type"];//not used (stock type)
                $product_data["barcode"] = $product_item["barcode"];

                $product_data["stock_type"] = $product_item["stock_type"];
                $product_data["supplier_id"] = $product_item["supplier_id"];//intval($row["supplier_id"]);
                $product_data["receiving_quantity"] = intval($product_item["receiving_quantity"]);
                $product_data["reorder_level"] = intval($product_item["reorder_level"]);
                $product_data["description"] = $product_item["description"];
            }

            $result["product_data"] = $product_data;

        }

        echo json_export($result);
    }
    if ($action == "add_product") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "product_name": "Pan De Molde 500 g",
                    "category_name": "Panadería",
                    "cost_price": 0,
                    "unit_price": 10,
                    "quantity": 0,
                    "barcode": "74947759",
                    "brand": "Lider",
                    "unit_value": "500",
                    "unit_label": "g",
                    "stock_type": "stock",
                    "supplier_id": 22,
                    "receiving_quantity": 1,
                    "reorder_level": 0,
                    "description": "",
                    "image_name": "704080.jpg",
                }

                //multipart file
                //name = "image"

             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "update_product") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "product_id": 142,
                    "product_name": "Pan De Molde 500 g",
                    "category_name": "Panadería",
                    "cost_price": 0,
                    "unit_price": 10,
                    "quantity": 0,
                    "barcode": "74947759",
                    "brand": "Lider",
                    "unit_value": "500",
                    "unit_label": "g",
                    "stock_type": "stock",
                    "supplier_id": 22,
                    "receiving_quantity": 1,
                    "reorder_level": 0,
                    "description": "",
                    "image_name": "704080.jpg",
                    "catalog_id": "cid-mowvgil-0117851-memqqnx"
                }
                //Multipart File
                //name = "image"
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "delete_product") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $product_id = text_clean($data["product_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "product_id":142, //([the id for the product])

                }
             */

            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    //======== module_catalog =========
    //ACTION_GET_CATALOG_LIST = "get_catalog_list" //(--)
    //--ACTION_GET_CATALOG_CATEGORY = "get_catalog_category" //()
    //ACTION_CATALOG_ADD_TO_STORE = "catalog_add_to_store" //(--)

    if ($action == "get_catalog_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1


            $code = '{
                "status": "OK",
                "catalog_list": [
                    {
                        "catalog_id": "cid-mowvgil-0117851-memqqnx",
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "brand": "Lider", 
                        "unit_value": "1", 
                        "unit_label": "Un",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "in_store": false
                    },
                    {
                        "catalog_id": "cid-dlsnfjc-9385729-slrfkdf",
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "brand": "Colun", 
                        "unit_value": "1", 
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "in_store": true
                    }
                   
                ]
            }';

            $code_obj = json_decode($code, true);


            $result["catalog_list"] = $code_obj["catalog_list"];

        }

        echo json_export($result);
    }
    if ($action == "catalog_add_to_store") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $catalog_id = text_clean($data["catalog_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "catalog_id":"cid-dlsnfjc-9385729-slrfkdf", //([the id for the catalog item])

                }
             */

            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }

    if ($action == ACTION_ADD_TO_CART) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = $customer->setCart($data);
        }

        echo json_export($result);
    }


    if ($action == ACTION_GET_CART_LIST) {
        $data = json_decode($param_json, true);
        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $store_id = text_clean($data["store_id"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = $customer->getCartList($user_id, $store_id);
        }

        echo json_export($result);
    }


    if ($action == ACTION_GET_CART_STORE_LIST) {
        $data = json_decode($param_json, true);
        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = $customer->getCartsStoreList();
        }

        echo json_export($result);
    }


    //======== module_giftcard =========
    //ACTION_GET_GIFT_CARD_LIST = "get_gift_card_list" //(--)
    //ACTION_GET_GIFT_CARD_DATA = "get_gift_card_data" //(--)
    //ACTION_ADD_GIFT_CARD = "add_gift_card" //(--)
    //ACTION_UPDATE_GIFT_CARD = "update_gift_card" //(--)
    //ACTION_DELETE_GIFT_CARD = "delete_gift_card" //(--)

    if ($action == "get_gift_card_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1


            $code = '{
                "status": "OK",
                "card_list": [
                    {
                        "gift_card_id": 10,
                        "customer_name": null,
                        "customer_id": null,
                        "is_public": true,
                        "card_code": 661142,
                        "batch_code": 7984619550,
                        "card_value": 100
                    },
                    {
                        "gift_card_id": 32,
                        "customer_name": null,
                        "customer_id": null,
                        "is_public": true,
                        "card_code": 384193,
                        "batch_code": 7984619550,
                        "card_value": 100
                    },
                    {
                        "gift_card_id": 74,
                        "customer_name": "Sarah Connor", 
                        "customer_id": 4, 
                        "is_public": false,
                        "card_code": 384763,
                        "batch_code": 2938579347,
                        "card_value": 30
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["card_list"] = $code_obj["card_list"];

        }

        echo json_export($result);
    }
    if ($action == "update_gift_card") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $gift_card_id = text_clean($data["gift_card_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request

                {
                    "user_id":55,
                    "login_token":91085539,
                    "gift_card_id": 10,
                    "customer_id": 4,
                    "customer_name": "Sarah Connor",
                    "is_public": false,
                    //"card_code": 384763,
                    //"batch_code": 2938579347,
                    "card_value": 30
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "delete_gift_card") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $gift_card_id = text_clean($data["gift_card_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "gift_card_id":10 //([the id for the gift card])

                }
             */

            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "add_gift_card") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request

                {
                    "user_id":55,
                    "login_token":91085539,
                    "customer_id": 4,
                    "customer_name": "Sarah Connor",
                    "is_public": false,
                    //"card_code": 384763,
                    //"batch_code": 2938579347,
                    "card_value": 30
                    "gift_card_count": 2
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "get_gift_card_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $gift_card_id = text_clean($data["gift_card_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $card_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "gift_card_id": 10
            }
            */

            /*{
                        "gift_card_id": 10,
                        "customer_name": null,
                        "customer_id": null,
                        "is_public": true,
                        "card_code": 661142,
                        "batch_code": 7984619550,
                        "card_value": 100
                    },
                    {
                        "gift_card_id": 32,
                        "customer_name": null,
                        "customer_id": null,
                        "is_public": true,
                        "card_code": 384193,
                        "batch_code": 7984619550,
                        "card_value": 100
                    },
                    {
                        "gift_card_id": 74,
                        "customer_name": "Sarah Connor",
                        "customer_id": 4,
                        "is_public": false,
                        "card_code": 384763,
                        "batch_code": 2938579347,
                        "card_value": 30
                    }*/

            $card_data["10"]["gift_card_id"] = 10;
            $card_data["10"]["customer_name"] = null;
            $card_data["10"]["customer_id"] = null;
            $card_data["10"]["is_public"] = true;
            $card_data["10"]["card_code"] = 661142;
            $card_data["10"]["batch_code"] = 7984619550;
            $card_data["10"]["card_value"] = 100;


            $card_data["32"]["gift_card_id"] = 32;
            $card_data["32"]["customer_name"] = null;
            $card_data["32"]["customer_id"] = null;
            $card_data["32"]["is_public"] = true;
            $card_data["32"]["card_code"] = 384193;
            $card_data["32"]["batch_code"] = 7984619550;
            $card_data["32"]["card_value"] = 100;


            $card_data["74"]["gift_card_id"] = 74;
            $card_data["74"]["customer_name"] = "Sarah Connor";
            $card_data["74"]["customer_id"] = 4;
            $card_data["74"]["is_public"] = false;
            $card_data["74"]["card_code"] = 384763;
            $card_data["74"]["batch_code"] = 2938579347;
            $card_data["74"]["card_value"] = 30;


            if ($gift_card_id == 10 || $gift_card_id == 32 || $gift_card_id == 74) {

                $result = getOKStatus();

                $result["card_data"] = $card_data[$gift_card_id];

            }

        }

        echo json_export($result);
    }


    //======== module_promotion =========
    //ACTION_GET_PROMOTION_LIST = "get_promotion_list" //(--)
    //ACTION_GET_PROMOTION_DATA = "get_promotion_data" //(--)
    //ACTION_UPDATE_PROMOTION = "update_promotion" //(--)
    //ACTION_ADD_PROMOTION = "add_promotion" //(--)
    //ACTION_DELETED_PROMOTION = "delete_promotion" //(--)

    if ($action == "get_promotion_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1


            $code = '{
                "status": "OK",
                "promotion_list": [
                    {
                        "promotion_id": 3,
                        "promotion_name": "Fruit Box Mix",
                        "promotion_description": "Fruit Box includes Real Flakes and Custard Apple",
                        "promotion_cost": 90.00, 
                        "cost_price": 0.00, 
                        "discount_type": "type_percentage", 
                        "discount": 10,
                        "barcode" : "7588674548756"
                    }  
                ]
            }';

            $code_obj = json_decode($code, true);


            $result["promotion_list"] = $code_obj["promotion_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_promotion_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $promotion_id = text_clean($data["promotion_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $promotion_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "promotion_id": 3
            }
            */
            /*{
                "status": "OK",
                "promotion_data": {
                    "promotion_id": 3,
                    "promotion_name": "Fruit Box Mix",
                    "promotion_description": "Fruit Box includes Real Flakes and Custard Apple",
                    "promotion_cost": 90,
                    "cost_price": 0,
                    "discount_type": "type_percentage",
                    "discount": 10,
                    "product_list": [
                        {
                            "product_id": 142,
                            "product_name": "Pan De Molde 500 Gr",
                            "category_name": "Panadería",
                            "cost_price": 0,
                            "unit_price": 10,
                            "quantity": 0,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                            "image_name": "704080.jpg",
                            "catalog_id": "cid-mowvgil-0117851-memqqnx"
                        },
                        {
                            "product_id": 143,
                            "product_name": "Masa Pre Pizza Tradicional",
                            "category_name": "Panadería",
                            "cost_price": 0,
                            "unit_price": 24,
                            "quantity": 0,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
                            "image_name": "581446.jpg",
                            "catalog_id": null
                        },
                        {
                            "product_id": 150,
                            "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                            "category_name": "Lácteos",
                            "cost_price": 0,
                            "unit_price": 13,
                            "quantity": 0,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                            "image_name": "264322.jpg",
                            "catalog_id": "cid-dlsnfjc-9385729-slrfkdf"
                        }
                    ]
                }
            }*/

            $promotion_data["3"]["promotion_id"] = 3;
            $promotion_data["3"]["promotion_name"] = "Fruit Box Mix";
            $promotion_data["3"]["promotion_description"] = "Fruit Box includes Real Flakes and Custard Apple";
            $promotion_data["3"]["promotion_cost"] = 90.0;
            $promotion_data["3"]["cost_price"] = 0.0;
            $promotion_data["3"]["discount_type"] = "type_percentage";
            $promotion_data["3"]["discount"] = 10;
            $promotion_data["3"]["barcode"] = "1735649201482";

            $product_list = '[
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "cost_price": 0.00, 
                        "unit_price": 10.00, 
                        "brand": "Lider",
                        "unit_value": 500,
                        "unit_label": "g",
                        "quantity": 1,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "catalog_id": "cid-mowvgil-0117851-memqqnx"
                    },
                    {
                        "product_id": 143,
                        "product_name": "Masa Pre Pizza Tradicional",
                        "category_name": "Panadería",
                        "cost_price": 0.00, 
                        "unit_price": 24.00, 
                        "brand": "Lider",
                        "unit_value": 1,
                        "unit_label": "Un",
                        "quantity": 1,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
                        "image_name": "581446.jpg",
                        "catalog_id": null
                    },
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "cost_price": 0.00, 
                        "unit_price": 13.00, 
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "quantity": 1,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "catalog_id": "cid-dlsnfjc-9385729-slrfkdf"
                    }
                ]';
            $product_obj = json_decode($product_list, true);

            $promotion_data["3"]["product_list"] = $product_obj;


            if ($promotion_id == 3) {

                $result = getOKStatus();

                $result["promotion_data"] = $promotion_data[$promotion_id];

            }

        }

        echo json_export($result);
    }
    if ($action == "delete_promotion") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $promotion_id = text_clean($data["promotion_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id":55,
                    "login_token":91085539,
                    "promotion_id":142 //([the id for the promotion])

                }
             */

            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "update_promotion") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "promotion_id": 3,
                    "promotion_name": "Fruit Box Mix",
                    "promotion_description": "Fruit Box includes Real Flakes and Custard Apple",
                    "promotion_cost": 90,
                    "cost_price": 0,
                    "discount_type": "type_percentage",
                    "discount": 10,
                    "product_list": [
                        {
                            "product_id": 142,
                            "quantity": 1,
                            "catalog_id": "cid-mowvgil-0117851-memqqnx"
                        },
                        {
                            "product_id": 143,
                            "quantity": 1,
                            "catalog_id": null
                        },
                        {
                            "product_id": 150,
                            "quantity": 1,
                            "catalog_id": "cid-dlsnfjc-9385729-slrfkdf"
                        }
                    ]
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "add_promotion") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "promotion_name": "Fruit Box Mix",
                    "promotion_description": "Fruit Box includes Real Flakes and Custard Apple",
                    "promotion_cost": 90,
                    "cost_price": 0,
                    "discount_type": "type_percentage",
                    "discount": 10,
                    "product_list": [
                        {
                            "product_id": 142,
                            "quantity": 1,
                            "catalog_id": "cid-mowvgil-0117851-memqqnx"
                        },
                        {
                            "product_id": 143,
                            "quantity": 1,
                            "catalog_id": null
                        },
                        {
                            "product_id": 150,
                            "quantity": 1,
                            "catalog_id": "cid-dlsnfjc-9385729-slrfkdf"
                        }
                    ]
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    //======== module_order =========
    //ACTION_GET_ORDER_LIST = "get_order_list" //(--)
    //ACTION_GET_ORDER_DATA = "get_order_data" //(--)
    //ACTION_CONFIRM_ONLINE_ORDER = "confirm_online_order" //(--)
    //ACTION_MARK_ORDER_ITEM_IN_STOCK = "mark_order_item_in_stock" //(--)
    //ACTION_MARK_ORDER_ITEM_OUT_STOCK = "mark_order_item_out_stock" //(--)
    //ACTION_MARK_ORDER_DELIVERED = "mark_order_delivered" //(--)
    //ACTION_CANCEL_ORDER = "cancel_order" //(--)

    if ($action == "get_order_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = (new Order($cornersave, null))->getOrderList($user_id);

//            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1


            //cancelled / confirmed demo
            $code = '{
                "status": "OK",
                "order_list": [
                    {
                        "order_id": 143,
                        "order_time": "2021-03-29 09:03:40",
                        "customer_id": 4,
                        "customer_name": "Sarah Connor",
                        "team_member_id": ' . $user_id . ',
                        "comment": null,
                        "invoice_number": null,
                        "quote_number": null,
                        "order_type": "online",
                        "order_status": "pending",
                        "approved": false,
                        "payment_method": null,
                        "sale_type": "sale",
                        "is_delivered": false
                    },
                    {
                        "order_id": 144,
                        "order_time": "2021-03-29 09:03:40",
                        "customer_id": 4,
                        "customer_name": "Sarah Connor",
                        "team_member_id": ' . $user_id . ',
                        "comment": null,
                        "invoice_number": null,
                        "quote_number": null,
                        "order_type": "online",
                        "order_status": "confirmed",
                        "approved": true,
                        "payment_method": null,
                        "sale_type": "sale",
                        "is_delivered": false
                    },
                    {
                        "order_id": 141,
                        "order_time": "2021-03-28 20:51:55",
                        "customer_id": 12,
                        "customer_name": "Kevin Smith",
                        "team_member_id": ' . "$user_id" . ',
                        "comment": "",
                        "invoice_number": "",
                        "quote_number": "",
                        "order_type": "in_store",
                        "order_status": "completed",
                        "approved": true,
                        "payment_method": "Cash",
                        "sale_type": "sale",
                        "is_delivered": true
                    },
                    {
                        "order_id": 142,
                        "order_time": "2021-03-29 19:30:50",
                        "customer_id": 12,
                        "customer_name": "Kevin Smith",
                        "team_member_id": ' . "$user_id" . ',
                        "comment": "",
                        "invoice_number": "",
                        "quote_number": "",
                        "order_type": "online",
                        "order_status": "cancelled",
                        "approved": false,
                        "payment_method": null,
                        "sale_type": "sale",
                        "is_delivered": false
                    },
                    {
                        "order_id": 145,
                        "order_time": "2021-03-29 19:30:50",
                        "customer_id": 12,
                        "customer_name": "Kevin Smith",
                        "team_member_id": ' . "$user_id" . ',
                        "comment": "",
                        "invoice_number": "",
                        "quote_number": "",
                        "order_type": "online",
                        "order_status": "paid",
                        "approved": true,
                        "payment_method": null,
                        "sale_type": "sale",
                        "is_delivered": false
                    }
                ]
            }';

            /*,
                    {
                        "order_id": 145,
                        "order_time": "2021-03-28 20:35:55",
                        "customer_id": null,
                        "customer_name": null,
                        "team_member_id": '."$user_id".',
                        "comment": "",
                        "invoice_number": "",
                        "quote_number": "",
                        "order_type": "in_store",
                        "order_status": "cancel",
                        "approved": true,
                        "payment_method": "Cash",
                        "sale_type": "sale"
                    }*/

//            $code_obj = json_decode($code, true);


//            $result["order_list"] = $code_obj["order_list"];

        }

        echo json_export($result);
    }

    if ($action == ACTION_GET_ORDER_DATA) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $order_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = $customer->getOrder($order_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "order_id": 143
            }
            */
            /*{
                "status": "OK",
                "order_data": {
                    "order_id": 143,
                    "order_time": "2021-03-29 09:03:40",
                    "customer_id": 4,
                    "customer_name": "Sarah Connor",
                    "team_member_id": "55",
                    "comment": null,
                    "invoice_number": null,
                    "quote_number": null,
                    "order_type": "online",
                    "order_status": "pending",
                    "approved": false,
                    "payment_method": null,
                    "sale_type": "sale",
                    "pickup_time": "2021-03-31 10:03:40",
                    "product_list": [
                        {
                            "product_id": 150,
                            "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                            "category_name": "Lácteos",
                            "unit_price": 13,
                            "quantity_purchased": 2,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                            "image_name": "264322.jpg",
                            "discount_type": "type_percentage",
                            "discount": "0",
                            "in_stock": false,
                            "description": null
                        },
                        {
                            "product_id": 142,
                            "product_name": "Pan De Molde 500 Gr",
                            "category_name": "Panadería",
                            "unit_price": 10,
                            "quantity_purchased": 2,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                            "image_name": "704080.jpg",
                            "discount_type": "type_percentage",
                            "discount": "0",
                            "in_stock": true,
                            "description": null
                        }
                    ]
                }
            }*/

            $order_data["141"]["order_id"] = 141;
            $order_data["141"]["order_time"] = "2021-03-28 20:51:55";
            $order_data["141"]["customer_id"] = 12;
            $order_data["141"]["customer_name"] = "Kevin Smith";
            $order_data["141"]["team_member_id"] = $user_id;
            $order_data["141"]["comment"] = null;
            $order_data["141"]["invoice_number"] = null;
            $order_data["141"]["quote_number"] = null;
            $order_data["141"]["order_type"] = "in_store";
            $order_data["141"]["order_status"] = "completed";
            $order_data["141"]["approved"] = true;
            $order_data["141"]["payment_method"] = "Cash";
            $order_data["141"]["sale_type"] = "sale";
            $order_data["141"]["pickup_time"] = null;
            $order_data["141"]["is_delivered"] = false;
            $product_list = '[
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 10.00, 
                        "quantity_purchased": 2,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "10",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["141"]["product_list"] = $product_obj;


            $order_data["143"]["order_id"] = 143;
            $order_data["143"]["order_time"] = "2021-03-29 09:03:40";
            $order_data["143"]["customer_id"] = 4;
            $order_data["143"]["customer_name"] = "Sarah Connor";
            $order_data["143"]["team_member_id"] = $user_id;
            $order_data["143"]["comment"] = null;
            $order_data["143"]["invoice_number"] = null;
            $order_data["143"]["quote_number"] = null;
            $order_data["143"]["order_type"] = "online";
            $order_data["143"]["order_status"] = "pending";
            $order_data["143"]["approved"] = false;
            $order_data["143"]["payment_method"] = null;
            $order_data["143"]["sale_type"] = "sale";
            $order_data["143"]["pickup_time"] = "2021-03-31 10:03:40";
            $order_data["143"]["is_delivered"] = false;
            $product_list = '[
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "unit_price": 13.00, 
                        "quantity_purchased": 2,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": false,
                        "description": null
                    },
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 10.00, 
                        "quantity_purchased": 2,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["143"]["product_list"] = $product_obj;


            $order_data["144"]["order_id"] = 144;
            $order_data["144"]["order_time"] = "2021-03-29 09:03:40";
            $order_data["144"]["customer_id"] = 4;
            $order_data["144"]["customer_name"] = "Sarah Connor";
            $order_data["144"]["team_member_id"] = $user_id;
            $order_data["144"]["comment"] = null;
            $order_data["144"]["invoice_number"] = null;
            $order_data["144"]["quote_number"] = null;
            $order_data["144"]["order_type"] = "online";
            $order_data["144"]["order_status"] = "confirmed";
            $order_data["144"]["approved"] = true;
            $order_data["144"]["payment_method"] = null;
            $order_data["144"]["sale_type"] = "sale";
            $order_data["144"]["pickup_time"] = "2021-03-31 10:03:40";
            $order_data["144"]["is_delivered"] = false;
            $product_list = '[
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "unit_price": 13.00, 
                        "quantity_purchased": 2,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": false,
                        "description": null
                    },
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 10.00, 
                        "quantity_purchased": 2,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["144"]["product_list"] = $product_obj;


            $order_data["142"]["order_id"] = 142;
            $order_data["142"]["order_time"] = "2021-03-29 19:30:50";
            $order_data["142"]["customer_id"] = 12;
            $order_data["142"]["customer_name"] = "Kevin Smith";
            $order_data["142"]["team_member_id"] = $user_id;
            $order_data["142"]["comment"] = null;
            $order_data["142"]["invoice_number"] = null;
            $order_data["142"]["quote_number"] = null;
            $order_data["142"]["order_type"] = "online";
            $order_data["142"]["order_status"] = "cancelled";
            $order_data["142"]["approved"] = false;
            $order_data["142"]["payment_method"] = null;
            $order_data["142"]["sale_type"] = "sale";
            $order_data["142"]["pickup_time"] = "2021-03-31 10:03:40";
            $order_data["142"]["is_delivered"] = false;
            $product_list = '[
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "unit_price": 13.00, 
                        "quantity_purchased": 2,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": false,
                        "description": null
                    },
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 10.00, 
                        "quantity_purchased": 2,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["142"]["product_list"] = $product_obj;


            $order_data["145"]["order_id"] = 145;
            $order_data["145"]["order_time"] = "2021-03-29 19:30:50";
            $order_data["145"]["customer_id"] = 12;
            $order_data["145"]["customer_name"] = "Kevin Smith";
            $order_data["145"]["team_member_id"] = $user_id;
            $order_data["145"]["comment"] = null;
            $order_data["145"]["invoice_number"] = null;
            $order_data["145"]["quote_number"] = null;
            $order_data["145"]["order_type"] = "online";
            $order_data["145"]["order_status"] = "paid";
            $order_data["145"]["approved"] = false;
            $order_data["145"]["payment_method"] = null;
            $order_data["145"]["sale_type"] = "sale";
            $order_data["145"]["pickup_time"] = "2021-03-31 10:03:40";
            $order_data["145"]["is_delivered"] = false;
            $product_list = '[
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "unit_price": 13.00, 
                        "quantity_purchased": 2,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    },
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 10.00, 
                        "quantity_purchased": 2,
                        "brand": "Colun",
                        "unit_value": 1,
                        "unit_label": "Kg",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["145"]["product_list"] = $product_obj;


//            if ($order_id == 141 || $order_id == 143 || $order_id == 144 || $order_id == 142 || $order_id == 145) {
//
//                $result = getOKStatus();
//
//                $result["order_data"] = $order_data[$order_id];
//
//            }

        }

        echo json_export($result);
    }
    if ($action == "confirm_online_order") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": 141

                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "mark_order_item_in_stock") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);
        $product_id = text_clean($data["product_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": 141,
                    "product_id": 150
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "mark_order_item_out_stock") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);
        $product_id = text_clean($data["product_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": 141,
                    "product_id": 150
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "mark_order_delivered") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);
        //$product_id = text_clean($data["product_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": 141,
                    "product_id": 150
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "cancel_order") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": 141

                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }


    //======== module_sale =========
    //ACTION_COMPLETE_SALE = "complete_sale" //(--)
    //ACTION_SUSPEND_SALE = "suspend_sale" //(--)

    if ($action == ACTION_COMPLETE_ORDER) {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = $customer->completeSale($data, $user_id);

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": null,
                    "customer_id": 12,
                    "comment": null,
                    "invoice_number": null,
                    "quote_number": null,
                    "order_type": "in_store",
                    "sale_type": "sale",
                    "payment_method": "Cash",
                    "payment_total": 16,
                    "product_list": [
                        {
                            "product_id": 142,
                            "unit_price": 10,
                            "quantity_purchased": 2,
                            "discount_type": "type_percentage",
                            "discount": "10",
                            "description": null
                        }
                    ]
                }
             */
            /*Response
            {
                "status": "OK",
                "order_id": 141
            }
            */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;
//            $result["order_id"] = 141;

        }

        echo json_export($result);
    }
    if ($action == "suspend_sale") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": null,
                    "customer_id": 12,
                    "comment": null,
                    "invoice_number": null,
                    "quote_number": null,
                    "order_type": "in_store",
                    "sale_type": "sale",
                    "payment_method": "Cash",
                    "payment_total": 16,
                    "product_list": [
                        {
                            "product_id": 142,
                            "unit_price": 10,
                            "quantity_purchased": 2,
                            "discount_type": "type_percentage",
                            "discount": "10",
                            "description": null
                        }
                    ]
                }
             */
            /*Response
            {
                "status": "OK",
                "order_id": 141
            }
            */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;
            $result["order_id"] = 141;

        }

        echo json_export($result);
    }


    //======== module_configuration =========
    //ACTION_GET_CONFIG_INFO = "get_config_information" //(--)
    //ACTION_SET_CONFIG_INFO = "set_config_information" //(--)
    //ACTION_ADD_COMPANY_LOGO = "add_company_logo" //(--)
    //ACTION_REMOVE_COMPANY_LOGO = "remove_company_logo" //(--)

    if ($action == "get_config_information") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);


            $store_data = $customer->getStoreData();

            if (!empty($store_data)) {
                $data = array();
                $result = getOKStatus();

                //rounding
                //etc

                $user_data["store_name"] = $store_data["name"];
                $user_data["phone_number"] = $store_data["phone"];
                $user_data["store_id"] = $store_data["store_id"];
                $user_data["logo"] = (empty($store_data["logo"]) ? IMG_LOGO_DEFAULT : $store_data["logo"]);
                $user_data["logo_url"] = IMG_LOGO_ROOT . $store_data["logo"];
                $user_data["currency_code"] = $store_data["currency_code"];
                $user_data["currency_decimals"] = $store_data["currency_decimals"];
                $user_data["discoverable"] = $store_data["discoverable"];
                $user_data["email"] = $store_data["email"];
                $user_data["country_code"] = $store_data["country_codes"];
                $user_data["store_type"] = (empty($store_data["store_type"]) ? STORE_TYPE_GROCERYSTORE : $store_data["store_type"]);
                $user_data["address"] = $store_data["address"];
                $user_data["coordinates"] = (empty($store_data["coordinates"]) ? array() : json_decode($store_data["coordinates"], true));

                //$user_data["number_locale"] = $store_data[""];
                //$user_data["thousands_separator"] = $store_data[""];
                //$user_data["timezone"] = $store_data[""];
                //$user_data["financial_year"] = $store_data[""];
                //$user_data["currency_symbol"] = $store_data[""];
                //$user_data["website"] = $store_data[""];
                //$user_data["fax"] = $store_data[""];
                //$user_data["return_policy"] = $store_data[""];

                //$user_data["number_locale"] = "es-CL";
                //$user_data["thousands_separator"] = true;
                //$user_data["timezone"] = "America/Santiago";
                //$user_data["financial_year"] = 1;
                //$user_data["currency_symbol"] = "$";
                //$user_data["website"] = null;
                //$user_data["fax"] = null;
                //$user_data["return_policy"] = null;

                $user_data["number_locale"] = "es-CL";
                $user_data["thousands_separator"] = true;
                $user_data["timezone"] = "America/Santiago";
                $user_data["financial_year"] = 1;
                $user_data["currency_symbol"] = "$";
                $user_data["website"] = null;
                $user_data["fax"] = null;
                $user_data["return_policy"] = null;


                $result["config_data"] = $user_data;

            }

        }

        echo json_export($result);
    }
    if ($action == "set_config_information") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "store_name": "Zendos Snackables",
                    "phone_number": "8764420992",
                    "currency_code": "CLP", //(can be obtained from the ACTION_LOCALE_CONVERSION api)
                    "currency_decimals": "0", //(the number of decimal places)
                    "email": "change@example.com",
                    "country_code": "CL", //(country code)
                    "address": "Bellavista 186, Recoleta, Chile", //(auto complete from places api)
                    "coordinates": {
                        "lat": -33.433553299999999808278516866266727447509765625, //(from places api)
                        "lng": -70.6427249999999986584953148849308490753173828125 //(from places api)
                    },
                    "number_locale": "es-CL", //(list can be seen in the lacale section)
                    "thousands_separator": true, //(whether or not the a thousand separator should be applied to currencies )
                    "timezone": "America/Santiago", //(list can be found in the locale section)
                    "financial_year": 1, //(can be found in the WebApp -> Localization -> Fiscal Year Start)
                    "currency_symbol": "$", //(can be obtained from the ACTION_LOCALE_CONVERSION api)
                    "website": null, //(string)
                    "fax": null, //(string)
                    "return_policy": null //(string)
                }

             */
            /*Response
            {
                "status": "OK",
            }
            */


        }

        echo json_export($result);
    }
    if ($action == "add_company_logo") {

        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);


            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "image_name": "new_image.jpg"
                }
                //-- IMPORTANT -- ADDITIONAL FILE PARAMETER
                //Multipart File
                //name = "image"
             */

            /*Response
            {
                "status": "OK"
            }
            */

        }

        echo json_export($result);
    }
    if ($action == "remove_company_logo") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539
                }

             */

            /*Response
            {
                "status": "OK"
            }
            */
        }

        echo json_export($result);

    }


    //======== module_message =========
    //ACTION_GET_MSG_LIST_MARKETING = "get_msg_list_marketing" //(--)
    //ACTION_GET_MSG_LIST_CONVERSATION = "get_msg_list_conversation" //(--)
    //ACTION_GET_CUSTOMER_MSG_THREAD = "get_customer_msg_thread" //(--)
    //ACTION_GET_MARKETING_MSG_THREAD = "get_marketing_msg_thread" //(--)

    //ACTION_SEND_NOTIFICATION_ID = "send_notification_id" //()
    //ACTION_SEND_MSG = "send_msg" //()
    //ACTION_MARK_AS_READ = "mark_as_read" //()

    if ($action == "get_msg_list_marketing") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "message_list": [
                    {
                        "recipient_type": "msg_all",
                        "timestamp": "2021-03-22 12:04:49",
                        "msg_body": "This is a thank you to all our customers"
                    },
                    {
                        "recipient_type": "msg_week",
                        "timestamp": "2021-03-17 18:57:57",
                        "msg_body": "This is a thank you to our customers who made a purchase in the last 7 days"
                    },
                    {
                        "recipient_type": "msg_biweek",
                        "timestamp": "2021-03-22 12:02:35",
                        "msg_body": "This is a thank you to our customers who made a purchase in the last 14 days"
                    },
                    {
                        "recipient_type": "msg_active",
                        "timestamp": "2021-03-23 12:02:35",
                        "msg_body": "This is a thank you to our customers who made a purchase in the last 30 days"
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["message_list"] = $code_obj["message_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_msg_list_conversation") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //"recipient_type": "msg_single",
            $code = '{
                "status": "OK",
                "message_list": [
                    {
                        "customer_id": 4,
                        "fname": "Sarah",
                        "lname": "Connor",
                        "timestamp": "2021-03-22 12:04:49",
                        "msg_body": "Good evening Sarah",
                        "unread": 0
                    },
                    { 
                        "customer_id": 12,
                        "fname": "Kevin",
                        "lname": "Smith",
                        "timestamp": "2021-03-17 18:57:57",
                        "msg_body": "Good Evening Kevin",
                        "unread": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["message_list"] = $code_obj["message_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_customer_msg_thread") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $customer_id = text_clean($data["customer_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $thread_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            //$result = getOKStatus();

            $thread_list = '[
                    {
                        "message_id": "msg-btlrvzs-7294585-djghhrg",
                        "recipient_id": 12,
                        "recipient_store_id": null,
                        "sender_id": ' . $user_id . ',
                        "sender_store_id": "4687314909",
                        "timestamp": "2021-03-12 18:04:04",
                        "read_time": "2021-03-12 19:04:04",
                        "msg_body": "Hi Kevin, We just wanted to reach to you."
                    },
                    {
                        "message_id": "msg-bwthgvq-8765740-itxkvuq",
                        "recipient_id": null,
                        "recipient_store_id": "4687314909",
                        "sender_id": 12,
                        "sender_store_id": null,
                        "timestamp": "2021-03-13 18:04:04",
                        "read_time": null,
                        "msg_body": "Hello store manager, Thank you for responding"
                    },
                    {
                        "message_id": "msg-xnfqdta-7158904-zcqglfs",
                        "recipient_id": 12,
                        "recipient_store_id": null,
                        "sender_id": ' . $user_id . ',
                        "sender_store_id": "4687314909",
                        "timestamp": "2021-03-14 18:04:04",
                        "read_time": "2021-03-14 19:04:04",
                        "msg_body": "Good Evening Kevin"
                    }
                ]';
            $thread_obj = json_decode($thread_list, true);
            $thread_data["12"] = $thread_obj;

            $thread_list = '[
                    {
                        "message_id": "msg-paccinh-4416764-ceuffww",
                        "recipient_id": 4,
                        "recipient_store_id": null,
                        "sender_id": ' . $user_id . ',
                        "sender_store_id": "4687314909",
                        "timestamp": "2021-03-12 18:04:04",
                        "read_time": "2021-03-12 19:04:04",
                        "msg_body": "Hello Sarah Conner, we are happy to have you as a customer"
                    },
                    {
                        "message_id": "msg-yippnjr-5424056-kobuasg",
                        "recipient_id": null,
                        "recipient_store_id": "4687314909",
                        "sender_id": 4,
                        "sender_store_id": null,
                        "timestamp": "2021-03-13 18:04:04",
                        "read_time": null,
                        "msg_body": "Hello store manager, Thank you for welcoming me"
                    },
                    {
                        "message_id": "msg-kqxfprh-0655970-fttngui",
                        "recipient_id": 4,
                        "recipient_store_id": null,
                        "sender_id": ' . $user_id . ',
                        "sender_store_id": "4687314909",
                        "timestamp": "2021-03-14 18:04:04",
                        "read_time": "2021-03-14 19:04:04",
                        "msg_body": "Good evening Sarah"
                    }
                ]';
            $thread_obj = json_decode($thread_list, true);
            $thread_data["4"] = $thread_obj;


            if ($customer_id == "4" || $customer_id == "12") {

                $result = getOKStatus();

                $result["message_thread"] = $thread_data[$customer_id];

            }

            //$code_obj = json_decode($code,true);

            //$result["message_list"] = $code_obj["message_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_marketing_msg_thread") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $recipient_type = text_clean($data["recipient_type"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $thread_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            //$result = getOKStatus();

            $thread_list = '[
                    {
                      "message_id": "msg-paccinh-4416764-ceuffww",
                      "sender_id": ' . $user_id . ',
                      "sender_store_id": "4687314909", 
                      "timestamp": "2021-03-22 12:04:49",
                      "msg_body": "This is a thank you to all our customers",
                      "recipient_count": 4,
                      "recipient_read": 2
                    }
                ]';
            $thread_obj = json_decode($thread_list, true);
            $thread_data["msg_all"] = $thread_obj;

            $thread_list = '[
                    {
                      "message_id": "msg-yippnjr-5424056-kobuasg",
                      "sender_id": ' . $user_id . ',
                      "sender_store_id": "4687314909", 
                      "timestamp": "2021-03-17 18:57:57",
                      "msg_body": "This is a thank you to our customers who made a purchase in the last 7 days",
                      "recipient_count": 4,
                      "recipient_read": 2
                    }
                ]';
            $thread_obj = json_decode($thread_list, true);
            $thread_data["msg_week"] = $thread_obj;

            $thread_list = '[
                    {
                      "message_id": "msg-ffpgiuk-6428710-xrhpfgj",
                      "sender_id": ' . $user_id . ',
                      "sender_store_id": "4687314909", 
                      "timestamp": "2021-03-22 12:02:35",
                      "msg_body": "This is a thank you to our customers who made a purchase in the last 14 days",
                      "recipient_count": 4,
                      "recipient_read": 2
                    }
                ]';
            $thread_obj = json_decode($thread_list, true);
            $thread_data["msg_biweek"] = $thread_obj;

            $thread_list = '[
                    {
                      "message_id": "msg-yxthqij-8589647-jmodumn",
                      "sender_id": ' . $user_id . ',
                      "sender_store_id": "4687314909", 
                      "timestamp": "2021-03-23 12:02:35",
                      "msg_body": "This is a thank you to our customers who made a purchase in the last 30 days",
                      "recipient_count": 4,
                      "recipient_read": 2
                    }
                ]';
            $thread_obj = json_decode($thread_list, true);
            $thread_data["msg_active"] = $thread_obj;

            if ($recipient_type == "msg_all" || $recipient_type == "msg_week" || $recipient_type == "msg_biweek" || $recipient_type == "msg_active") {

                $result = getOKStatus();

                $result["message_thread"] = $thread_data[$recipient_type];

            }

        }

        echo json_export($result);
    }
    if ($action == "") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "message_list": [
                    {
                        "quest_name": "Petrol Price Tracker",
                        "network_name": "Developer Space",
                        "network_id": "nid_jsy827459OFksye",
                        "task_id": 289,
                        "timestamp": "2021-03-22 12:04:49",
                        "msg_body": "hhhhh",
                        "unread": 0
                    },
                    {
                        "quest_name": "Fuel Tracking (Mar 12)",
                        "network_name": "Queritel Business",
                        "network_id": "nid_hfg589368HWrvsp",
                        "task_id": 297,
                        "timestamp": "2021-03-17 18:57:57",
                        "msg_body": "😅",
                        "unread": 0
                    },
                    {
                        "quest_name": "Official Test Quest",
                        "network_name": "Developer Space",
                        "network_id": "nid_jsy827459OFksye",
                        "task_id": 228,
                        "timestamp": "2021-03-22 12:02:35",
                        "msg_body": "You’re not finished yet",
                        "unread": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["message_list"] = $code_obj["message_list"];

        }

        echo json_export($result);
    }
    if ($action == "") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "message_list": [
                    {
                        "quest_name": "Petrol Price Tracker",
                        "network_name": "Developer Space",
                        "network_id": "nid_jsy827459OFksye",
                        "task_id": 289,
                        "timestamp": "2021-03-22 12:04:49",
                        "msg_body": "hhhhh",
                        "unread": 0
                    },
                    {
                        "quest_name": "Fuel Tracking (Mar 12)",
                        "network_name": "Queritel Business",
                        "network_id": "nid_hfg589368HWrvsp",
                        "task_id": 297,
                        "timestamp": "2021-03-17 18:57:57",
                        "msg_body": "😅",
                        "unread": 0
                    },
                    {
                        "quest_name": "Official Test Quest",
                        "network_name": "Developer Space",
                        "network_id": "nid_jsy827459OFksye",
                        "task_id": 228,
                        "timestamp": "2021-03-22 12:02:35",
                        "msg_body": "You’re not finished yet",
                        "unread": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["message_list"] = $code_obj["message_list"];

        }

        echo json_export($result);
    }
    if ($action == "") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "message_list": [
                    {
                        "quest_name": "Petrol Price Tracker",
                        "network_name": "Developer Space",
                        "network_id": "nid_jsy827459OFksye",
                        "task_id": 289,
                        "timestamp": "2021-03-22 12:04:49",
                        "msg_body": "hhhhh",
                        "unread": 0
                    },
                    {
                        "quest_name": "Fuel Tracking (Mar 12)",
                        "network_name": "Queritel Business",
                        "network_id": "nid_hfg589368HWrvsp",
                        "task_id": 297,
                        "timestamp": "2021-03-17 18:57:57",
                        "msg_body": "😅",
                        "unread": 0
                    },
                    {
                        "quest_name": "Official Test Quest",
                        "network_name": "Developer Space",
                        "network_id": "nid_jsy827459OFksye",
                        "task_id": 228,
                        "timestamp": "2021-03-22 12:02:35",
                        "msg_body": "You’re not finished yet",
                        "unread": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["message_list"] = $code_obj["message_list"];

        }

        echo json_export($result);
    }


    //======== module_expense =========
    //ACTON_GET_EXPENSE_LIST = "get_expense_list" //(--)
    //ACTON_GET_EXPENSE_CATEGORY_LIST = "get_expense_category_list" //(--)
    //ACTON_ADD_EXPENSE_CATEGORY = "add_expense_category" //(--)
    //ACTON_UPDATE_EXPENSE_CATEGORY = "update_expense_category" //(--)
    //ACTON_ADD_EXPENSE = "add_expense" //(--)
    //ACTON_UPDATE_EXPENSE = "update_expense" //(--)
    //ACTON_DELETE_EXPENSE = "delete_expense" //(--)
    //ACTON_DELETE_EXPENSE_CATEGORY = "delete_expense_category" //(--)

    if ($action == "get_expense_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "get_expense_category_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "category_list": [
                    {
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "category_description": "This is used with beverage-based purchases"
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["category_list"] = $code_obj["category_list"];

        }

        echo json_export($result);
    }
    if ($action == "add_expense_category") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $result["category_id"] = 1;

            /* request

                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "category_name": "Garcia Category for Beverages", //(the name of the expense category)
                    "category_description": "This is used with beverage-based purchases"
                }
             */


            /*{
                "status": "OK", //([STATUS CONSTANTS])
                "category_id": 1 //(the id for the expense category that was created)
            }*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "update_expense_category") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //$result["category_id"] = 1;

            /* request

                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "category_id": 1,
                    "category_name": "Garcia Category for Beverages", //(the name of the expense category)
                    "category_description": "This is used with beverage-based purchases"
                }
             */


            /*{
                "status": "OK" //([STATUS CONSTANTS])

            }*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "add_expense") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $result["expense_id"] = 1;

            /* request

                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "expense_date": "2020-12-30 15:04:55", //(YYYY-MM-DD HH:mm:ss)(UTC)(must be converted to local)
                    "expense_amount": 100, //(the total associated with this expense entry)
                    "payment_type": "Cash",  //(the payment type used)
                    "category_id": 1, //(the id of the expense category)
                    "category_name": "Garcia Category for Beverages", //(the name of the expense category)
                    "expense_description": "The purchasing of beverages",
                    "creator_id": 55, //(the id for the team member who created the expense)
                    "creator_name": "Jon Garcia", //(the name of the team member who created the expense)
                    "supplier_id": null, //(the id for the supplier if any was attached)
                    "supplier_name": null, //(the name of the supplier if any was attached)
                    "supplier_tax_code": null, //(the supplier tax code if any)
                    "tax_amount": 0 //(fixed tax amount associated with the expense)
                }
             */


            /*{
                "status": "OK", //([STATUS CONSTANTS])
                "expense_id": 1 //(the id for the expense category that was created)
            }*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "update_expense") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //$result["category_id"] = 1;

            /* request

                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "expense_id": 1, //(the id for the expense)
                    "expense_date": "2020-12-30 15:04:55", //(YYYY-MM-DD HH:mm:ss)(UTC)(must be converted to local)
                    "expense_amount": 100, //(the total associated with this expense entry)
                    "payment_type": "Cash",  //(the payment type used)
                    "category_id": 1, //(the id of the expense category)
                    "category_name": "Garcia Category for Beverages", //(the name of the expense category)
                    "expense_description": "The purchasing of beverages",
                    "creator_id": 55, //(the id for the team member who created the expense)
                    "creator_name": "Jon Garcia", //(the name of the team member who created the expense)
                    "supplier_id": null, //(the id for the supplier if any was attached)
                    "supplier_name": null, //(the name of the supplier if any was attached)
                    "supplier_tax_code": null, //(the supplier tax code if any)
                    "tax_amount": 0 //(fixed tax amount associated with the expense)
                }
             */


            /*{
                "status": "OK" //([STATUS CONSTANTS])

            }*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "delete_expense") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //$result["category_id"] = 1;

            /* request

                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "expense_id": 1 //(the id of the expense to be deleted)
                }
             */


            /*{
                "status": "OK" //([STATUS CONSTANTS])

            }*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "delete_expense_category") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //$result["category_id"] = 1;

            /* request

                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "category_id": 1 //(the id of the expense to be deleted)
                }
             */


            /*{
                "status": "OK" //([STATUS CONSTANTS])

            }*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }

    //======== module_receiving =========
    //ACTION_COMPLETE_RECEIVING = "complete_receiving" //()

    if ($action == "complete_receiving") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "supplier_id": 22, //(the id of the supplier) (if no supplier then use null)
                    "comment": null,
                    "invoice_number": null,
                    "quote_number": null,
                    "order_type": null, //(not important)
                    "receiving_mode": "receive", //([RECEIVING MODE CONSTANTS])
                    "payment_method": "Cash",
                    "payment_total": 16,
                    "product_list": [
                        {
                            "product_id": 142,
                            "cost_price": 10, //(the cost price from product list) (NOTE: NOT unit_price)
                            "quantity_purchased": 2,
                            "discount_type": "type_percentage",
                            "discount": "10",
                            "description": null
                        }
                    ]
                }
             */
            /*Response
            {
                "status": "OK"
            }
            */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;
            $result["order_id"] = 141;

        }

        echo json_export($result);
    }


    //======== module_report =========
    //ACTION_GET_LOW_INV_LIST = "report_get_low_inventory_list" //(--)
    //ACTION_GET_SUM_INV_LIST = "report_get_summary_inventory_list" //(--)
    //ACTION_GET_RCV_LIST = "report_get_receiving_list" //(--)
    //ACTION_GET_TRN_LIST = "report_get_transaction_list" //(--)
    //ACTION_GET_TRN_CHART = "report_get_transaction_chart_data" //(--)
    //ACTION_GET_CUS_LIST = "report_get_customer_list" //()
    //ACTION_GET_CUS_CHART = "report_get_customer_chart_data" //()
    //ACTION_GET_DIS_LIST = "report_get_discount_list" //()
    //ACTION_GET_DIS_CHART = "report_get_discount_chart_data" //()
    //ACTION_GET_EMP_LIST = "report_get_employee_list" //()
    //ACTION_GET_EMP_CHART = "report_get_employee_chart_data" //()
    //ACTION_GET_SUP_LIST = "report_get_supplier_list" //()
    //ACTION_GET_SUP_CHART = "report_get_supplier_chart_data" //()
    //ACTION_GET_PAY_LIST = "report_get_payment_list" //()
    //ACTION_GET_PAY_CHART = "report_get_payment_chart_data" //()
    //ACTION_GET_ITM_LIST = "report_get_item_list" //()
    //ACTION_GET_ITM_CHART = "report_get_item_chart_data" //()
    //ACTION_GET_CAT_LIST = "report_get_category_list" //()
    //ACTION_GET_CAT_CHART = "report_get_category_chart_data" //()

    if ($action == "report_get_low_inventory_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                  "status": "OK",
                  "inventory_data": [
                    {
                      "product_name": "4 Pack Ensure Advance Chocolate",
                      "barcode": "8475634",
                      "quantity": 0,
                      "reorder_level": 0,
                      "stock_type": "stock"
                    }
                  ]
                }';

            $code_obj = json_decode($code, true);

            $result["inventory_data"] = $code_obj["inventory_data"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_summary_inventory_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                  "status": "OK",
                  "inventory_data": [
                    {
                      "product_name": "4 Pack Ensure Advance Chocolate",
                      "barcode": "8475634",
                      "category_name": "Bebidas",
                      "quantity": 2,
                      "low_sell_qty": 0,
                      "reorder_level": 0,
                      "stock_type": "stock",
                      "cost_price": 100,
                      "unit_price": 150,
                      "sub_total": 200
                    },
                    {
                      "product_name": "Bebida Light",
                      "barcode": "7465837",
                      "category_name": "Bebidas",
                      "quantity": 2,
                      "low_sell_qty": 0,
                      "reorder_level": 0,
                      "stock_type": "stock",
                      "cost_price": 90,
                      "unit_price": 120,
                      "sub_total": 180
                    }
                  ]
                }';

            $code_obj = json_decode($code, true);

            $result["inventory_data"] = $code_obj["inventory_data"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_receiving_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                  "status": "OK",
                  "receiving_data": [
                    {
                      "receiving_id": 14,
                      "receiving_date": "2021-02-12 10:07:15",
                      "quantity": 2,
                      "received_by_id": 55,
                      "received_by_name": "Jon Garcia",
                      "supplied_by_id": 45,
                      "supplied_by_name": "Jon Fernandez Distribuidora",
                      "total": 250,
                      "payment_type": "Tarjeta de Débito",
                      "comments": ".",
                      "product_list": [
                        {
                          "product_name": "4 Pack Ensure Advance Chocolate",
                          "barcode": "8475634",
                          "category_name": "Bebidas",
                          "quantity": 1,
                          "total": 200,
                          "discount": 0
                        },
                        {
                          "product_name": "Gaseosa Guaraná",
                          "barcode": "85946445",
                          "category_name": "Bebidas",
                          "quantity": 1,
                          "total": 50,
                          "discount": 0
                        }
                      ]
                    }
                  ]
                }';


            $code_obj = json_decode($code, true);

            $result["receiving_data"] = $code_obj["receiving_data"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_transaction_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                  "status": "OK",
                  "transaction_data": [
                    {
                      "transaction_id": 21,
                      "transaction_date": "2021-02-12 10:07:15",
                      "quantity": 2,
                      "sold_by_id": 55, //(the id of the customer who made the transaction)
                      "sold_by_name": "Jon Garcia", //(the name of the customer who made the transaction)
                      "customer_id": 12, //(the customer connected to this transaction)
                      "customer_name": "Kevin Smith", //(the name of the customer connected to this transaction )
                      "total": 250,
                      "tax": 0,
                      "cost_price": 1000,
                      "profit": 750, //(the profits gained on this transaction)
                      "payment_type": "Efectivo", //(the payment type used)
                      "comments": "",
                      "points_used": 0, //(the points used)
                      "points_earned": 0, //(the points earned)
                      "product_list": [
                        {
                          "product_name": "4 Pack Ensure Advance Chocolate",
                          "barcode": "8475634",
                          "category_name": "Bebidas",
                          "description": ".",
                          "quantity": 1,
                          "total": 200,
                          "tax": 0,
                          "cost_price": "200",
                          "discount": 0,
                          "profit": 10
                        },
                        {
                          "product_name": "Gaseosa Guaraná",
                          "barcode": "85946445",
                          "category_name": "Bebidas",
                          "description": ".",
                          "quantity": 1,
                          "total": 50,
                          "tax": 0,
                          "cost_price": "50",
                          "discount": 0,
                          "profit": 10
                        }
                      ]
                    }
                  ]
                }';

            $code_obj = json_decode($code, true);

            $result["transaction_data"] = $code_obj["transaction_data"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_transaction_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
              "status": "OK",
              "max_revenue": 70000,
              "min_revenue": 0,
              "increment": 10000,
              "chart_data": [
                {
                  "transaction_date": "2021-02-12 10:07:15",
                  "revenue": 4430
                },
                {
                  "transaction_date": "2021-02-13 10:07:15",
                  "revenue": 12120
                },
                {
                  "transaction_date": "2021-02-14 10:07:15",
                  "revenue": 14350
                },
                {
                  "transaction_date": "2021-02-15 10:07:15",
                  "revenue": 3170
                },
                {
                  "transaction_date": "2021-02-16 10:07:15",
                  "revenue": 3890
                },
                {
                  "transaction_date": "2021-02-17 10:07:15",
                  "revenue": 4620
                },
                {
                  "transaction_date": "2021-02-18 10:07:15",
                  "revenue": 12160
                },
                {
                  "transaction_date": "2021-02-19 10:07:15",
                  "revenue": 68131
                }
              ]
            }';

            $code_obj = json_decode($code, true);

            $result["max_revenue"] = $code_obj["max_revenue"];
            $result["min_revenue"] = $code_obj["min_revenue"];
            $result["increment"] = $code_obj["increment"];
            $result["chart_data"] = $code_obj["chart_data"];

        }

        echo json_export($result);
    }


    if ($action == "report_get_customer_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_customer_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_discount_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_discount_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_employee_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_employee_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_supplier_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_supplier_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_payment_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_payment_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_item_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_item_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_category_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }
    if ($action == "report_get_category_chart_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            $code = '{
                "status": "OK",
                "expense_list": [
                    {
                        "expense_id": 1,
                        "expense_date": "2020-12-30 15:04:55",
                        "expense_amount": 100,
                        "payment_type": "Cash", 
                        "category_id": 1,
                        "category_name": "Garcia Category for Beverages",
                        "expense_description": "The purchasing of beverages",
                        "creator_id": 55,
                        "creator_name": "Jon Garcia",
                        "supplier_id": null,
                        "supplier_name": null,
                        "supplier_tax_code": null,
                        "tax_amount": 0
                    }
                ]
            }';

            $code_obj = json_decode($code, true);

            $result["expense_list"] = $code_obj["expense_list"];

        }

        echo json_export($result);
    }


    /* Error -- These reports are not working
        Customers
        Discount
        Employees
        Suppliers
        Payments
        Items
        Categories
    */


    //======== module_supplier_market =========
    //supplier_marketplace

    //ACTION_MARKET_GET_SUPPLIER_LIST = "market_get_supplier_list" //(--)
    //ACTION_MARKET_GET_PRODUCT_LIST = "market_get_product_list" //(--)
    //ACTION_MARKET_GET_PROMOTION_LIST = "market_get_promotion_list" //(--)
    //ACTION_MARKET_CANCEL_ORDER = "market_cancel_order" //(--)
    //ACTION_MARKET_COMPLETE_ORDER = "market_complete_order" //(--)
    //ACTION_MARKET_CLAIM_GIFT = "market_claim_gift_card" //(--)
    //ACTION_MARKET_SET_INTERESTED = "market_mark_as_interested" //(--)
    //ACTION_MARKET_GET_ORDER_LIST = "market_get_order_list" //(--)
    //ACTION_MARKET_GET_ORDER_DATA = "market_get_order_data" //(--)

    if ($action == "market_get_supplier_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1


            $code = '{
                "status": "OK",
                "supplier_list": [
                    {
                        "supplier_id": 163,
                        "company_name": "Beverage Distributor",
                        "email": "b_bev_supply@cornersave.com", 
                        "phone_number": "8669284724", 
                        "supplier_category": "goods_supplier",
                        "market_place_id": "85740397",
                        "is_connected": false,
                        "supplier_url": null
                    },
                    {
                        "supplier_id": 22,
                        "company_name": "Dairy Supplier", 
                        "email": "e_dairy@cornersave.com", 
                        "phone_number": "8662847290", 
                        "supplier_category": "cost_supplier",
                        "market_place_id": "87698564",
                        "is_connected": true,
                        "supplier_url": "https://cornersave.com/?lang=en#contact"
                    }
                ]
            }';

            $code_obj = json_decode($code, true);


            $result["supplier_list"] = $code_obj["supplier_list"];

        }

        echo json_export($result);
    }
    if ($action == "market_get_product_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1

            //TODO information to be added the product list
            //brand
            //unit value
            //unit label

            $code = '{
                "status": "OK",
                "product_list": [
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "cost_price": 0.00, 
                        "unit_price": 10.00, 
                        "quantity": 0,
                        "brand": "Lider",
                        "unit_value": 500,
                        "unit_label": "g",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "catalog_id": "cid-mowvgil-0117851-memqqnx",
                        "product_type": "type_item",
                        "product_description": null,
                        "is_interested": null
                    },
                    {
                        "product_id": 143,
                        "product_name": "Masa Pre Pizza Tradicional",
                        "category_name": "Panadería",
                        "cost_price": 0.00, 
                        "unit_price": 24.00, 
                        "quantity": 0,
                        "brand": "Lider",
                        "unit_value": 1,
                        "unit_label": "Un",
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
                        "image_name": "581446.jpg",
                        "catalog_id": null,
                        "product_type": "type_item",
                        "product_description": null,
                        "is_interested": null
                    },
                    {
                        "product_id": 182,
                        "product_name": "Accounting Service",
                        "category_name": "Finance",
                        "cost_price": null, 
                        "unit_price": null, 
                        "quantity": null,
                        "brand": null,
                        "unit_value": null,
                        "unit_label": null,
                        "image_url": "https://app.cornersave.com/public/uploads/accounting_5689.jpg",
                        "image_name": "accounting_5689.jpg",
                        "catalog_id": null,
                        "product_type": "type_service",
                        "product_description": "Providing accounting services to small and medium size stores.",
                        "is_interested": false
                        
                    }
                   
                ]
            }';

            $code_obj = json_decode($code, true);


            $result["product_list"] = $code_obj["product_list"];

        }

        echo json_export($result);
    }
    if ($action == "market_get_promotion_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1


            $code = '{
                "status": "OK",
                "gift_list" : [
                    {
                        "product_type": "type_gift",
                        "batch_code": 7984619550,
                        "card_value": 100
                    }
                ],
                "promotion_list": [
                    {
                        "product_type": "type_promotion",
                        "promotion_id": 3,
                        "promotion_name": "Fruit Box Mix",
                        "promotion_description": "Fruit Box includes Real Flakes and Custard Apple",
                        "promotion_cost": 90.00, 
                        "cost_price": 0.00, 
                        "discount_type": "type_percentage", 
                        "discount": 10,
                        "product_list": [
                            {
                                "product_id": 142,
                                "product_name": "Pan De Molde 500 Gr",
                                "category_name": "Panadería",
                                "cost_price": 0.00, 
                                "unit_price": 10.00, 
                                "brand": "Lider",
                                "unit_value": 500,
                                "unit_label": "g",
                                "quantity": 1,
                                "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                                "image_name": "704080.jpg",
                                "catalog_id": "cid-mowvgil-0117851-memqqnx"
                            },
                            {
                                "product_id": 143,
                                "product_name": "Masa Pre Pizza Tradicional",
                                "category_name": "Panadería",
                                "cost_price": 0.00, 
                                "unit_price": 24.00, 
                                "brand": "Lider",
                                "unit_value": 1,
                                "unit_label": "Un",
                                "quantity": 1,
                                "image_url": "https://app.cornersave.com/public/uploads/item_pics/581446.jpg",
                                "image_name": "581446.jpg",
                                "catalog_id": null
                            },
                            {
                                "product_id": 150,
                                "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                                "category_name": "Lácteos",
                                "cost_price": 0.00, 
                                "unit_price": 13.00, 
                                "brand": "Colun",
                                "unit_value": 1,
                                "unit_label": "Kg",
                                "quantity": 1,
                                "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                                "image_name": "264322.jpg",
                                "catalog_id": "cid-dlsnfjc-9385729-slrfkdf"
                            }
                        ]
                    }  
                ]
            }';

            $code_obj = json_decode($code, true);


            $result["gift_list"] = $code_obj["gift_list"];
            $result["promotion_list"] = $code_obj["promotion_list"];

        }

        echo json_export($result);
    }
    if ($action == "market_cancel_order") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);
        $supplier_id = text_clean($data["supplier_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "order_id": 141,
                    "supplier_id": 123
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "market_complete_order") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "supplier_id": 163,
                    "pickup": "2021-03-28 20:51:55",
                    "payment_total": 26,
                    "product_list": [
                        {
                            "product_id": 142,
                            "unit_price": 10,
                            "quantity_purchased": 2,
                            "discount_type": "type_percentage",
                            "discount": 10,
                            "description": null
                        },
                        {
                            "product_id": 143,
                            "unit_price": 10,
                            "quantity_purchased": 1,
                            "discount_type": "type_percentage",
                            "discount": 0,
                            "description": null
                        }
                    ]
                }
             */
            /*Response
            {
                "status": "OK"
            }
            */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;
            //$result["order_id"] = 141;

        }

        echo json_export($result);
    }
    if ($action == "market_claim_gift_card") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        //$order_id = text_clean($data["order_id"]);
        //$product_id = text_clean($data["product_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "supplier_id": 163,
                    "batch_code": 7984619550
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "market_mark_as_interested") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $supplier_id = text_clean($data["supplier_id"]);
        $product_id = text_clean($data["product_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            /* request
                {
                    "user_id": 55,
                    "login_token": 91085539,
                    "supplier_id": 163,
                    "product_id": 150
                }
             */


            /*$user_data["fname"] = $customer->get_firstName();
            $user_data["lname"] = $customer->get_lastName();
            $user_data["user_name"] = $customer->get_userName();
            $user_data["user_type"] = $customer->getUserType();
            $user_data["email"] = $customer->get_email();
            $user_data["gender"] = $customer->get_gender();
            $user_data["registration_date"] = $customer->get_registrationDate();
            $user_data["phone_number"] = $customer->get_phoneNumber();
            $user_data["location_address_1"] = text_export($customer->getLocationAddress1());
            $user_data["location_address_2"] = text_export($customer->getLocationAddress2());
            $user_data["location_city"] = text_export($customer->get_locationCity());
            $user_data["location_state"] = text_export($customer->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $customer->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "market_get_order_list") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            $result = getOKStatus();

            //goods_supplier = 0
            //cost_supplier = 1

            //cancelled / confirmed demo
            $code = '{
                "status": "OK",
                "market_order_list": [
                    {
                        "order_id": 141,
                        "order_time": "2021-03-29 09:03:40",
                        "supplier_id": 163,
                        "supplier_name": "Beverage Distribution",
                        "market_place_id": "85740397",
                        "item_count": 1,
                        "total": 100,
                        "order_status": "pending"
                    },
                    {
                        "order_id": 143,
                        "order_time": "2021-03-30 09:03:40",
                        "supplier_id": 124,
                        "supplier_name": "Salsa Distribution",
                        "market_place_id": "47564837",
                        "item_count": 2,
                        "total": 23,
                        "order_status": "confirmed"
                    },
                    {
                        "order_id": 144,
                        "order_time": "2021-03-31 09:03:40",
                        "supplier_id": 125,
                        "supplier_name": "Dairy Distribution",
                        "market_place_id": "75645382",
                        "item_count": 2,
                        "total": 200,
                        "order_status": "completed"
                    }
                ]
            }';

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "supplier_id": 163
            }
            */
            /*{
                        "order_id": 144,
                        "order_time": "2021-03-31 09:03:40",
                        "supplier_id": 125,
                        "supplier_name": "Dairy Distribution",
                        "market_place_id": "75645382",
                        "item_count": 2,
                        "total": 200,
                        "order_status": "completed"
                    }*/

            $code_obj = json_decode($code, true);

            $result["market_order_list"] = $code_obj["market_order_list"];

        }

        echo json_export($result);
    }
    if ($action == "market_get_order_data") {
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $order_id = text_clean($data["order_id"]);


        $customer = new Customer($cornersave);
        $isVerified = $customer->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $order_data = array();

        if ($isVerified["status"] == STATUS_OK) {
            $customer->initializeCustomer($user_id);

            /* Request
            {
                "user_id":55,
                "login_token":91085539,
                "order_id": 143
            }
            */
            /*{
                "status": "OK",
                "order_data": {
                    "order_id": 143,
                    "order_time": "2021-03-29 09:03:40",
                    "customer_id": 4,
                    "customer_name": "Sarah Connor",
                    "team_member_id": "55",
                    "comment": null,
                    "invoice_number": null,
                    "quote_number": null,
                    "order_type": "online",
                    "order_status": "pending",
                    "approved": false,
                    "payment_method": null,
                    "sale_type": "sale",
                    "pickup_time": "2021-03-31 10:03:40",
                    "product_list": [
                        {
                            "product_id": 150,
                            "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                            "category_name": "Lácteos",
                            "unit_price": 13,
                            "quantity_purchased": 2,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                            "image_name": "264322.jpg",
                            "discount_type": "type_percentage",
                            "discount": "0",
                            "in_stock": false,
                            "description": null
                        },
                        {
                            "product_id": 142,
                            "product_name": "Pan De Molde 500 Gr",
                            "category_name": "Panadería",
                            "unit_price": 10,
                            "quantity_purchased": 2,
                            "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                            "image_name": "704080.jpg",
                            "discount_type": "type_percentage",
                            "discount": "0",
                            "in_stock": true,
                            "description": null
                        }
                    ]
                }
            }*/


            $order_data["141"]["order_id"] = 141;
            $order_data["141"]["order_time"] = "2021-03-28 20:51:55";
            $order_data["141"]["supplier_id"] = 125;
            $order_data["141"]["supplier_name"] = "Beverage Distribution";
            $order_data["141"]["order_status"] = "pending";
            $order_data["141"]["total"] = 100;
            $order_data["141"]["pickup_time"] = null;
            $product_list = '[
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 10.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["141"]["product_list"] = $product_obj;


            $order_data["143"]["order_id"] = 143;
            $order_data["143"]["order_time"] = "2021-03-29 09:03:40";
            $order_data["143"]["supplier_id"] = 124;
            $order_data["143"]["supplier_name"] = "Salsa Distribution";
            $order_data["143"]["order_status"] = "confirmed";
            $order_data["143"]["total"] = 23;
            $order_data["143"]["pickup_time"] = "2021-03-31 10:03:40";
            $product_list = '[
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "unit_price": 13.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    },
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 10.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["143"]["product_list"] = $product_obj;


            $order_data["144"]["order_id"] = 144;
            $order_data["144"]["order_time"] = "2021-03-29 09:03:40";
            $order_data["144"]["supplier_id"] = 125;
            $order_data["144"]["supplier_name"] = "Dairy Distribution";
            $order_data["144"]["order_status"] = "completed";
            $order_data["144"]["pickup_time"] = "2021-03-31 10:03:40";
            $product_list = '[
                    {
                        "product_id": 150,
                        "product_name": "Yoghurt Batido Sabor Vainilla Bolsa",
                        "category_name": "Lácteos",
                        "unit_price": 100.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/264322.jpg",
                        "image_name": "264322.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": false,
                        "description": null
                    },
                    {
                        "product_id": 142,
                        "product_name": "Pan De Molde 500 Gr",
                        "category_name": "Panadería",
                        "unit_price": 100.00, 
                        "quantity_purchased": 2,
                        "image_url": "https://app.cornersave.com/public/uploads/item_pics/704080.jpg",
                        "image_name": "704080.jpg",
                        "discount_type": "type_percentage",
                        "discount": "0",
                        "in_stock": true,
                        "description": null
                    }
                ]';
            $product_obj = json_decode($product_list, true);
            $order_data["144"]["product_list"] = $product_obj;


            if ($order_id == 141 || $order_id == 143 || $order_id == 144) {

                $result = getOKStatus();

                $result["order_data"] = $order_data[$order_id];

            }

        }

        echo json_export($result);
    }


    /*

    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '303');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '331');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '338');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '340');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '387');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '448');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '470');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '471');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '508');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '509');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '510');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '511');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '512');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '576');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '676');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '702');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '719');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '745');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '896');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '966');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1010');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1036');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1037');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1056');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1057');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1064');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1065');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1066');
    DELETE FROM `initia19_paperweight`.`tbl_user_profile` WHERE (`userprofile_user_id` = '1067');*/

}


/*
 * Author : Kadian Salmon
 * Date : Mar 1, 2021
 * Purpose : Main class for all operations relating to customer
 */
/**
 * class Customer
 * {
 *
 * private $db_connector;
 * private $isLoggedin = false;//is the Customer logged in
 * private $isActive = false;//is this Customer's account still active
 * private $hasCurrentLocation = false;//
 *
 *
 * //current details
 * private $host_info = null;
 * private $currentLat = null;
 * private $currentLon = null;
 * private $currentLocation = null;
 *
 * //Customer details
 * private $userId = null;
 * private $loginToken = null;
 * private $email = null;
 * private $password = null;
 * private $userName = null;
 * private $firstName = null;
 * private $lastName = null;
 * private $gender = null;
 * private $locationCountry = null;
 * private $locationCountryCode = null;
 * private $locationState = null;
 * private $locationCity = null;
 * private $registrationDate = null;
 * private $phoneNumber = null;
 * private $userType = null;
 * private $locationAddress_1 = null;
 * private $locationAddress_2 = null;
 * private $userRef = null;
 * private $managerId = null;
 * private $storeId = null;
 *
 *
 * function __construct(Database $db_connector)
 * {
 * $this->db_connector = $db_connector;
 *
 * $this->host_info = new HostInfo($db_connector);
 *
 * $this->currentLocation = new LocationPoint(null, null);
 *
 * }
 *
 * public function get_db_connector()
 * {
 * return $this->db_connector;
 * }
 *
 * public function isLoggedin()
 * {
 * return $this->isLoggedin;
 * }
 *
 * public function isActive()
 * {
 * return $this->isActive;
 * }
 *
 * public function get_userId()
 * {
 * return $this->userId;
 * }
 *
 * public function get_loginToken()
 * {
 * return $this->loginToken;
 * }
 *
 * public function get_email()
 * {
 * return $this->email;
 * }
 *
 * public function get_encrytedPassword()
 * {
 * return $this->password;
 * }
 *
 * public function get_userName()
 * {
 * return $this->userName;
 * }
 *
 * public function get_firstName()
 * {
 * return $this->firstName;
 * }
 *
 * public function get_lastName()
 * {
 * return $this->lastName;
 * }
 *
 * public function get_gender()
 * {
 * return $this->gender;
 * }
 *
 * public function get_locationCountry()
 * {
 * return $this->locationCountry;
 * }
 *
 * public function get_locationCountryCode()
 * {
 * return $this->locationCountryCode;
 * }
 *
 * public function get_locationState()
 * {
 * return $this->locationState;
 * }
 *
 * public function get_locationCity()
 * {
 * return $this->locationCity;
 * }
 *
 * public function get_registrationDate()
 * {
 * return $this->registrationDate;
 * }
 *
 * public function get_phoneNumber()
 * {
 * return $this->phoneNumber;
 * }
 *
 * public function getCurrentLocation()
 * {
 * return $this->currentLocation;
 * }
 *
 * public function getUserType()
 * {
 * return $this->userType;
 * }
 *
 * public function getUserRef()
 * {
 * return $this->userRef;
 * }
 *
 * public function getLocationAddress1()
 * {
 * return $this->locationAddress_1;
 * }
 *
 * public function getLocationAddress2()
 * {
 * return $this->locationAddress_2;
 * }
 *
 * public function getManagerId()
 * {
 * return $this->managerId;
 * }
 *
 * public function getStoreId()
 * {
 * return $this->storeId;
 * }
 *
 * public function getHostInfo()
 * {
 * return $this->host_info;
 * }
 *
 * public function setCurrentLocation($lat, $lon)
 * {
 * $currentLocation = new LocationPoint(null, null);
 *
 * if (!empty($lat) && !empty($lon)) {
 * $currentLocation = new LocationPoint($lat, $lon);
 * }
 *
 * $this->currentLocation = $currentLocation;
 *
 * }
 *
 * public function set_db_connector($db_connector)
 * {
 * $this->db_connector = $db_connector;
 * }
 *
 * public function set_isLoggedin($isLoggedin)
 * {
 * $this->isLoggedin = $isLoggedin;
 * }
 *
 * public function set_isActive($isActive)
 * {
 * $this->isActive = $isActive;
 * }
 *
 * public function set_userId($userId)
 * {
 * $this->userId = $userId;
 * }
 *
 * public function set_loginToken($loginToken)
 * {
 * $this->loginToken = $loginToken;
 * }
 *
 * public function set_email($email)
 * {
 * $this->email = $email;
 * }
 *
 * public function set_encrytedPassword($password)
 * {
 * $this->password = $password;
 * }
 *
 * public function set_userName($userName)
 * {
 * $this->userName = $userName;
 * }
 *
 * public function set_firstName($firstName)
 * {
 * $this->firstName = $firstName;
 * }
 *
 * public function set_lastName($lastName)
 * {
 * $this->lastName = $lastName;
 * }
 *
 * public function set_gender($gender)
 * {
 * $this->gender = $gender;
 * }
 *
 * public function set_locationCountry($locationCountry)
 * {
 * $this->locationCountry = $locationCountry;
 * }
 *
 * public function set_locationCountryCode($locationCountryCode)
 * {
 * $this->locationCountryCode = $locationCountryCode;
 * }
 *
 * public function set_locationState($locationState)
 * {
 * $this->locationState = $locationState;
 * }
 *
 * public function set_locationCity($locationCity)
 * {
 * $this->locationCity = $locationCity;
 * }
 *
 * public function set_registrationDate($registrationDate)
 * {
 * $this->registrationDate = $registrationDate;
 * }
 *
 * public function set_phoneNumber($phoneNumber)
 * {
 * $this->phoneNumber = $phoneNumber;
 * }
 *
 * public function setUserType($userType)
 * {
 * $this->userType = $userType;
 * }
 *
 * public function setUserRef($userRef)
 * {
 * $this->userRef = $userRef;
 * }
 *
 * public function setLocationAddress1($locationAddress_1)
 * {
 * $this->locationAddress_1 = $locationAddress_1;
 * }
 *
 * public function setLocationAddress2($locationAddress_2)
 * {
 * $this->locationAddress_2 = $locationAddress_2;
 * }
 *
 * public function setManagerId($managerId)
 * {
 * $this->managerId = $managerId;
 * }
 *
 * public function setStoreId($storeId)
 * {
 * $this->storeId = $storeId;
 * }
 *
 * public function getErrorStatus($error_msg)
 * {
 * $result = array();
 * $error = array();
 *
 * $error["name"] = ERROR_NAME_OP_FAILED;
 * $error["message"] = $error_msg;
 *
 * $result["status"] = STATUS_ERROR;
 * $result["error"] = $error;
 *
 * return $result;
 * }
 *
 * public function getOKStatus()
 * {
 * $result = array();
 * $result["status"] = STATUS_OK;
 *
 * return $result;
 * }
 *
 * public function signout($user_id, $login_token)
 * {
 * $user_type = USER_TYPE_RESEARCHER;
 * $account_state = STATE_ACTIVE;
 * $login_state = LOGIN_STATE_INVALID;
 *
 * $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token'";
 * $update_query = "update " . TABLE_LOGIN . " set login_state = '$login_state' where user_id = '$user_id' and token_id = '$login_token'";
 *
 * $result = getErrorStatus(ERROR_MSG_INVALID_LOGIN);
 *
 *
 * if ($this->db_connector != null) {
 * $login_result = $this->db_connector->query($login_check_query);
 * if ($login_result != null && $login_result->is_row_found()) {
 * //if we found the record
 * $update_result = $this->db_connector->query($update_query);
 * if ($update_result != null && $update_result->is_row_affected()) {
 * $result = getOKStatus();
 * $this->isLoggedin = false;
 * }
 *
 * }
 * }
 *
 * return $result;
 *
 * }
 *
 * public function login($username, $password)
 * {
 *
 * $provided_password = encryptPassword($password);
 * $provided_username = strtolower($username);
 *
 * $user_type = USER_TYPE_CUSTOMER;
 * $not_deleted = 0;
 * //$verified_by_admin = VERIFIED;
 * //$verified_email = VERIFIED;
 *
 * $result = getErrorStatus(ERROR_MSG_INVALID_CRED);
 *
 *
 * if ($this->db_connector != null) {
 * $login_query = "select * from " . TABLE_PEOPLE . " where lower(email) = '$provided_username' and password = '$provided_password' and user_type in ('" . USER_TYPE_CUSTOMER . "')";
 *
 * $login_result = $this->db_connector->query($login_query);
 *
 * if ($login_result != null && $login_result->is_row_found()) {
 *
 * if ($row_data = $login_result->fetch_array()) {
 * $actual_uname = $row_data["email"];
 * $actual_pass = $row_data["password"];
 * $user_id = $row_data["person_id"];
 * $user_type = $row_data["user_type"];
 *
 * if (($actual_uname == $provided_username) && ($actual_pass == $provided_password)) {
 *
 * $login_token = generate_token();
 * $login_time = getCurrentTime();
 * $login_state = LOGIN_STATE_VALID;
 *
 * $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,user_type) values ('$login_token','$login_time','$login_state','$user_id','$user_type')";
 * $details_result = $this->db_connector->query($details_query);
 *
 * if ($details_result != null && $details_result->is_row_affected()) {
 * //$this->isLoggedin = true;
 *
 * $result = getOKStatus();
 * $result["user_id"] = $user_id;
 * $result["user_type"] = $user_type;
 * $result["login_token"] = $login_token;
 *
 * return $result;
 * }
 *
 * }
 *
 * }
 * }
 *
 *
 * }
 *
 * return $result;
 *
 * }
 *
 * public function __verifyLogin_old__($user_id, $login_token)
 * {
 * $not_deleted = 0;
 * $login_state = LOGIN_STATE_VALID;
 *
 * $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token' and login_state = '$login_state'";
 * $user_check_query = "select * from " . TABLE_EMPLOYEE . " where person_id = '$user_id' and user_type in ('" . USER_TYPE_MANAGER . "','" . USER_TYPE_EMPLOYEE . "') and deleted = '$not_deleted'";
 *
 * $result = getErrorStatus(ERROR_MSG_INVALID_TOKEN);
 *
 *
 * if ($this->db_connector != null) {
 * $login_result = $this->db_connector->query($login_check_query);
 * if ($login_result != null && $login_result->is_row_found()) {
 * $user_result = $this->db_connector->query($user_check_query);
 * if ($user_result != null && $user_result->is_row_found()) {
 * $result = getOKStatus();
 *
 * /*$version_data = getAPP_VERSION_DATA();
 *
 * if (hasAgent()){
 * $result[MOBILE_VERSION_NAME] = $version_data[MOBILE_VERSION_NAME];
 * $result[MOBILE_VERSION_CODE] = $version_data[MOBILE_VERSION_CODE];
 * $result[MOBILE_VERSION_COMMENT] = $version_data[MOBILE_VERSION_COMMENT];
 * $result[MOBILE_VERSION_PRIORITY] = $version_data[MOBILE_VERSION_PRIORITY];
 * }*/
/*
                    $this->isLoggedin = true;
                    $this->isActive = true;
                } else {
                    $result = getErrorStatus(ERROR_MSG_USER_SUSPENDED);
                }

            }
        }

        return $result;

    }

    public function verifyLogin($user_id, $login_token)
    {
        $not_deleted = 0;
        $login_state = LOGIN_STATE_VALID;
        $user_type_cus = USER_TYPE_CUSTOMER;
        $user_type_guest = USER_TYPE_GUEST;

        $result = getErrorStatus(ERROR_MSG_INVALID_TOKEN);

        if (!empty($user_id) && !empty($login_token)) {
            //if this is a customer
            $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token' and login_state = '$login_state' and user_type = '$user_type_cus'";

            if ($this->db_connector != null) {
                $login_result = $this->db_connector->query($login_check_query);
                if ($login_result != null && $login_result->is_row_found()) {
                    $this->isLoggedin = true;
                    $this->isActive = true;

                    $result = getOKStatus();
                    $result["user_type"] = $user_type_cus;
                    $result["login_token"] = null;

                } else {
                    //if the customer is not verified : then log them in as a guest
                    $login_token = generate_token();
                    $login_time = getCurrentTime();
                    $login_state = LOGIN_STATE_VALID;

                    $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,user_type) values ('$login_token','$login_time','$login_state',null,'$user_type_guest')";
                    $details_result = $this->db_connector->query($details_query);

                    if ($details_result != null && $details_result->is_row_affected()) {
                        $this->isLoggedin = false;
                        $this->isActive = true;

                        $result = getOKStatus();
                        //$result["user_id"] = null;
                        $result["user_type"] = $user_type_guest;
                        $result["login_token"] = $login_token;

                    }

                }
            }

        } elseif (empty($user_id) && !empty($login_token)) {
            //if this is a re-visiting guest
            $login_check_query = "select * from " . TABLE_LOGIN . " where token_id = '$login_token' and login_state = '$login_state' and user_type = '$user_type_guest'";

            if ($this->db_connector != null) {
                $login_result = $this->db_connector->query($login_check_query);
                if ($login_result != null && $login_result->is_row_found()) {
                    $this->isLoggedin = false;
                    $this->isActive = true;

                    $result = getOKStatus();
                    //$result["user_id"] = null;
                    $result["user_type"] = $user_type_guest;
                    $result["login_token"] = $login_token;

                } else {

                    $login_token = generate_token();
                    $login_time = getCurrentTime();
                    $login_state = LOGIN_STATE_VALID;

                    $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,user_type) values ('$login_token','$login_time','$login_state',null,'$user_type_guest')";
                    $details_result = $this->db_connector->query($details_query);

                    if ($details_result != null && $details_result->is_row_affected()) {
                        $this->isLoggedin = false;
                        $this->isActive = true;

                        $result = getOKStatus();
                        //$result["user_id"] = null;
                        $result["user_type"] = $user_type_guest;
                        $result["login_token"] = $login_token;

                    }

                }
            }

        } else {
            //if this is a new guest

            $login_token = generate_token();
            $login_time = getCurrentTime();
            $login_state = LOGIN_STATE_VALID;

            $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id,user_type) values ('$login_token','$login_time','$login_state',null,'$user_type_guest')";
            $details_result = $this->db_connector->query($details_query);

            if ($details_result != null && $details_result->is_row_affected()) {
                $this->isLoggedin = false;
                $this->isActive = true;

                $result = getOKStatus();
                //$result["user_id"] = null;
                $result["user_type"] = $user_type_guest;
                $result["login_token"] = $login_token;

            }

        }

        return $result;
    }

    public function initializeCustomer($user_id, $login_token = "")
    {

        //$this->host_info = new HostInfo($this->db_connector);//get all the host info... like [ip_address|country_name|country_code|area_code|currency]

        if ($user_id != null) {
            $this->userId = $user_id;
        } else {
            return false;
        }
        if ($login_token != null) {
            $this->loginToken = $login_token;
        }


        $user_check_query = "select * from " . TABLE_PEOPLE . " where person_id = '$user_id'";
        //$employee_check_query = "select * from " . TABLE_EMPLOYEE . " where person_id = '$user_id'";

        if ($this->db_connector != null) {
            $user_result = $this->db_connector->query($user_check_query);
            //$employee_result = $this->db_connector->query($employee_check_query);

            //if(($user_result != null && $user_result->is_row_found()) && ($employee_result != null && $employee_result->is_row_found())){
            if (($user_result != null && $user_result->is_row_found())) {
                $row = $user_result->fetch_array();
                //$row_emp = $employee_result->fetch_array();


                //if($row != null && $row_emp != null){
                if ($row != null) {
                    $this->email = stringCase($row["email"]);
                    $this->password = $row["password"];
                    $this->userType = $row["user_type"];
                    $this->userRef = $row["user_ref_id"];
                    $this->locationAddress_1 = stringCase($row["address_1"]);
                    $this->locationAddress_2 = stringCase($row["address_2"]);
                    $this->phoneNumber = $row["phone_number"];
                    $this->userName = null;
                    $this->firstName = stringCase($row["first_name"], STRING_CASE_CAP_FIRST);
                    $this->lastName = stringCase($row["last_name"], STRING_CASE_CAP_FIRST);
                    $this->locationCountryCode = stringCase($row["country"], STRING_CASE_UPPER);

                    //$this->managerId = $row_emp["manager_id"];
                    //if ($this->userType == USER_TYPE_MANAGER){
                    //$this->managerId = $row["person_id"];
                    //}


                    if ($row["gender"] == GENDER_MALE_CODE) {
                        $this->gender = GENDER_MALE;
                    } elseif ($row["gender"] == GENDER_FEMALE_CODE) {
                        $this->gender = GENDER_FEMALE;
                    }

                    $this->registrationDate = $row["created_on"];

                    $this->locationCountry = $row["country"];
                    $this->locationCity = $row["city"];
                    $this->locationState = $row["state"];

                    $account_deleted = $row["deleted"];

                    if ($account_deleted == 0) {
                        $this->isActive = true;
                    }
                    return true;

                }

            }
        }

        return false;
    }

    //todo: REMOVE MODULE
    public function getStoreData()
    {
        $result = array();

        $manager_id = $this->managerId;
        $user_type = USER_TYPE_MANAGER;

        $manager_query = "select * from " . TABLE_PEOPLE . " where person_id = '$manager_id' and user_type = '$user_type'";
        $manager_result = $this->db_connector->query($manager_query);

        if ($manager_result != null && $manager_result->is_row_found()) {

            if ($row = $manager_result->fetch_array()) {
                $result["phone_number"] = $row["phone_number"];
                $result["store_id"] = $row["user_ref_id"];
                $result["manager_id"] = $row["person_id"];

                $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
                $store_result = $this->db_connector->query($store_query);
                if ($store_result != null && $store_result->is_row_found()) {
                    while ($config = $store_result->fetch_array()) {

                        if ($config["key"] == "company") {
                            $result["name"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "company_logo") {
                            $result["logo"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "address") {
                            $result["address"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_code") {
                            $result["currency_code"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "currency_decimals") {
                            $result["currency_decimals"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "number_locale") {
                            $result["number_locale"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "discoverable") {
                            $result["discoverable"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "country_codes") {
                            $result["country_codes"] = text_clean($config["value"]);
                            //break;
                        }

                        if ($config["key"] == "email") {
                            $result["email"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "phone") {
                            $result["phone"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "store_type") {
                            $result["store_type"] = text_clean($config["value"]);
                            //break;
                        }
                        if ($config["key"] == "coordinates") {
                            $result["coordinates"] = $config["value"];
                            //break;
                        }
                    }
                }

            }
        }

        return $result;
    }

}

*/
//point state date
//image array for product
//remove customer from store
//login messaging

function checkCustomerLink($store_id, $cornersave, $customer)
{
    $isCustomerLinked = false;

    if (!$customer->isLoggedin()) {
        return $isCustomerLinked;
    }

    $customer_id = $customer->get_userId();

    $manager_id = getManagerId($store_id, $cornersave);

    $customer_query = "select * from " . TABLE_CUSTOMER . " where person_id = '$customer_id' and manager_id = '$manager_id'";
    $customer_result = $cornersave->query($customer_query);

    if ($customer_result != null && $customer_result->is_row_found()) {
        $isCustomerLinked = true;
    }

    return $isCustomerLinked;
}

function getManagerId($store_id, $cornersave)
{
    $manager_id = 0;
    $manager_type = USER_TYPE_MANAGER;


    $manager_query = "select * from " . TABLE_PEOPLE . " where user_ref_id = '$store_id' and user_type = '$manager_type'";
    $manager_result = $cornersave->query($manager_query);

    if ($manager_result != null && $manager_result->is_row_found()) {

        if ($row = $manager_result->fetch_array()) {
            $manager_id = $row["person_id"];
        }
    }

    return $manager_id;
}

function getStoreInfo($store_id, $customer, $cornersave)
{
    //$customer = new Customer($cornersave);

    $result = array();

    $manager_query = "select user_ref_id, person_id, user_type from " . TABLE_PEOPLE . " where user_ref_id = '$store_id'";
    $manager_result = $cornersave->query($manager_query);
//    echo $manager_query;
    if ($manager_result != null && $manager_result->is_row_found()) {
        //$row = $manager_result->fetch_array();


        if ($row = $manager_result->fetch_array()) {
            $result["store_id"] = $row["user_ref_id"];
            $result["manager_id"] = $row["person_id"];

            if ($row["user_type"] == USER_TYPE_ADMIN) {
                $result["manager_id"] = 0;
            }

            $manager_id = $result["manager_id"];

            $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
            $store_result = $cornersave->query($store_query);
            if ($store_result != null) {
                while ($row2 = $store_result->fetch_array()) {

                    if ($row2["key"] == "address") {
                        $result["address"] = $row2["value"];
                    }
                    if ($row2["key"] == "company") {
                        $result["name"] = stringCase($row2["value"], STRING_CASE_CAP_EACH);
                        //$result["name"] = "Keviñ";
                    }
                    if ($row2["key"] == "company_logo") {
                        $result["logo_url"] = IMG_LOGO_ROOT . $row2["value"];
                    }

                    if ($row2["key"] == "currency_code") {
                        $result["currency_code"] = stringCase($row2["value"], STRING_CASE_UPPER);
                    }
                    if ($row2["key"] == "currency_decimals") {
                        $result["currency_decimals"] = intval($row2["value"]);
                        //break;
                    }
                    if ($row2["key"] == "country_codes") {
                        $result["country_codes"] = stringCase($row2["value"], STRING_CASE_UPPER);
                    }
                    if ($row2["key"] == "email") {
                        $result["email"] = stringCase($row2["value"]);
                    }
                    if ($row2["key"] == "number_locale") {
                        $result["number_locale"] = ($row2["value"]);
                    }
                    if ($row2["key"] == "discoverable") {
                        $result["discoverable"] = ($row2["value"] == 1);
                    }
                    if ($row2["key"] == "phone") {
                        $result["phone_number"] = ($row2["value"]);
                    }
                    if ($row2["key"] == "store_type") {
                        $result["store_type"] = stringCase($row2["value"]);
                    }
                    if ($row2["key"] == "coordinates") {
                        $result["coordinates"] = (empty($row2["value"]) ? array("lat" => null, "lng" => null) : json_decode($row2["value"], true));
                    }

                }

            }

            $is_connected = false;
            if ($customer->isLoggedin()) {
                $is_connected = checkCustomerLink($store_id, $cornersave, $customer);
            }

            if (!isset($result["coordinates"])) {
                $result["coordinates"] = array("lat" => null, "lng" => null);
            }
            if (!isset($result["discoverable"])) {
                $result["discoverable"] = false;
            }
            if (!isset($result["store_type"])) {
                $result["store_type"] = STORE_TYPE_GROCERYSTORE;
            }


            $result["is_connected"] = $is_connected;
        }

    }

    return $result;
}

//todo : set based on country
function getStoreList($cornersave, $customer)
{
    //$customer = new Customer($cornersave);

    $result = array();

    $user_type = USER_TYPE_MANAGER;
    $current_country = $customer->getHostInfo()->getCountry_code();
    $current_country = "CL";


    $store_query = "select user_ref_id from " . TABLE_PEOPLE . " where user_type = '$user_type' and country = '$current_country'";
//    $store_query = "select * from " . TABLE_PEOPLE . " where user_type = '$user_type' and country = '$current_country'";
    $store_result = $cornersave->query($store_query);

//    $store_result = null;
    if ($store_result != null) {
        while ($row = $store_result->fetch_array()) {

            $id = $row["user_ref_id"];
            $is_visible = false;
            $right_locale = false; //is this store in the country the user is making the call from
            $store_info = getStoreInfo($id, $customer, $cornersave);


            if ($store_info["discoverable"]) {
                $is_visible = true;
            }

            if ($store_info["country_codes"] == $current_country) {
                $right_locale = true;
            }

            if ($right_locale && $is_visible) {
                $result[] = $store_info;
            }

        }
    }


    return $result;
}


function hasPromotions($manager_id, $cornersave)
{
    $item_query = "select * from " . TABLE_KITS . " where manager_id = '$manager_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null) {
        $row = $item_result->fetch_array();

        if ($row != null) {
            return true;
        }

    }

    return false;
}

function hasGifts($manager_id, $cornersave)
{
    $item_query = "select * from " . TABLE_GIFT_CARDS . " where manager_id = '$manager_id' and deleted = '0' and public = '1' and person_id is null";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null) {
        $row = $item_result->fetch_array();

        if ($row != null) {
            return true;
        }

    }

    return false;
}

function get_product_info($product_id, $cornersave)
{
    $result = null;

    $result = array();

    $item_query = "select * from " . TABLE_ITEMS . " where item_id = '$product_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null && $item_result->is_row_found()) {
        if ($row = $item_result->fetch_array()) {

            $product_id = intval($row["item_id"]);
            $product_qty = get_product_quantity($product_id, $cornersave);


            $result["product_id"] = $product_id;
            $result["product_name"] = $row["name"];
            $result["category_name"] = $row["category"];
            $result["cost_price"] = intval($row["cost_price"]);
            $result["unit_price"] = intval($row["unit_price"]);
            $result["quantity"] = $product_qty;
            $result["brand"] = $row["brand"] == null ? "" : $row["brand"];
            $result["unit_value"] = $row["unit_value"];
            $result["unit_label"] = $row["unit_label"];
            $result["image_url"] = IMG_ITEM_ROOT . $row["pic_filename"];
            $result["image_name"] = $row["pic_filename"];
            $result["catalog_id"] = $row["catalog_id"];
            $result["product_type"] = PRODUCT_TYPE_ITEM; //$row["product_type"];//not used (stock type)
            $result["barcode"] = $row["item_number"] == null ? "" : $row["item_number"];


            $result["stock_type"] = ($row["stock_type"] == 0) ? "stock" : "non_stock";
            $result["supplier_id"] = intval($row["supplier_id"]);
            $result["receiving_quantity"] = intval($row["receiving_quantity"]);
            $result["reorder_level"] = intval($row["reorder_level"]);
            $result["description"] = $row["description"] == null ? "" : $row["description"];
        }
    }

    return $result;
}

function get_product_quantity($product_id, $cornersave)
{
    $result = 0;

    $item_query = "select * from " . TABLE_ITEM_QUANTITY . " where item_id = '$product_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null && $item_result->is_row_found()) {
        if ($row = $item_result->fetch_array()) {
            $result = intval($row["quantity"]);
        }
    }

    return $result;
}

//todo : count
function getCategoryList($manager_id, $cornersave)
{
    $result = array();

    $deleted = 0;

//    $item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted'";
    $item_query = "SELECT category as category_name, sum(IQ.quantity) as quantity_items
FROM ospos_items OI
         left outer join ospos_item_quantities IQ on OI.item_id = IQ.item_id
WHERE manager_id = $manager_id
  and deleted = 0
group by category
having quantity_items > 0";
    $item_result = $cornersave->query($item_query);

    $index = 0;
    $category_list = array();

    if (hasPromotions($manager_id, $cornersave) || hasGifts($manager_id, $cornersave)) {
        $code_ = "promotion";

        $result[$index]["category_name"] = "Promotion";
        $result[$index]["category_id"] = $code_;
        $result[$index]["quantity_items"] = 0;
        $category_list[$code_] = 1;

        $index++;
    }

    if ($item_result != null) {
        while ($row = $item_result->fetch_assoc()) {

//            $product_id = $row["item_id"];
//            $product_qty = get_product_quantity($product_id, $cornersave);

//            if ($product_qty > 0) {
            $name = clean_reverse($row["category_name"]);
            $lowered = strtolower($name);
            $code = str_replace(" ", "+", $lowered);

            if (!isset($category_list[$code])) {
                $result[$index]["category_name"] = $name;
                $result[$index]["category_id"] = $code;
                $result[$index]["quantity_items"] = intval($row['quantity_items']);
                $category_list[$code] = 1;

                $index++;
            }
//            }

        }
    }

    return $result;
}


//todo , evaluate functions
function getModulesFromPermissions($permission_array)
{
    $modules = array();

    foreach ($permission_array as $permission) {
        if ($permission == "config")
            $modules[] = "module_configuration";

        if ($permission == "customers")
            $modules[] = "module_customer";

        if ($permission == "employees")
            $modules[] = "module_team";

        if ($permission == "expenses")
            $modules[] = "module_expense";

        if ($permission == "giftcards")
            $modules[] = "module_giftcard";

        if ($permission == "item_kits")
            $modules[] = "module_promotion";

        if ($permission == "items")
            $modules[] = "module_item";

        if ($permission == "messages")
            $modules[] = "module_message";

        if ($permission == "preorders")
            $modules[] = "module_order";

        if ($permission == "receivings")
            $modules[] = "module_receiving";

        if ($permission == "reports")
            $modules[] = "module_report";

        if ($permission == "sales")
            $modules[] = "module_sale";

        if ($permission == "suppliers")
            $modules[] = "module_supplier";

        if ($permission == "supplier_market")
            $modules[] = "module_supplier_market";

        if ($permission == "catalog")
            $modules[] = "module_catalog";

    }

    return $modules;
}

function encryptPassword($password)
{//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}

function generateUserReferenceId()
{
    return getRandomNumber(10);
}

function generate_token()
{
    return getRandomNumber(4) . "" . getRandomNumber(4);
}

function generate_unique_id($prefix)
{
    return $prefix . "-" . strtolower(getRandomString(7)) . "-" . getRandomNumber(7) . "-" . strtolower(getRandomString(7));
}

//return a formatted currency string based on the locale
function displayCurrency($number, $decimals = NULL, $locale = DEFAULT_LOCALE)
{
    $thousands_separator = true;

    //ignore empty strings and return
    if (empty($number)) {
        return $number;
    }

    if ($decimals == NULL) {
        $decimals = 0;
    }


    $fmt = new NumberFormatter($locale, NumberFormatter::DECIMAL);

    $fmt->setAttribute(NumberFormatter::FRACTION_DIGITS, intval($decimals));

    if (!$thousands_separator) {
        //remove thousand separator
        //$fmt->setAttribute(NumberFormatter::GROUPING_SEPARATOR_SYMBOL, '');
    }

    try {
        //return $fmt->parse($number);
        return $fmt->format($number);

    } catch (Exception $e) {
        return FALSE;
    }
}

function debugAPIResponse($api, $msg)
{

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "$api-$time_stamp-$random.json";
    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);
}
