<?php

//https://api.queritel.com/api/mobile/cornersave/catalog/v1/api.php?action=report

//3172546551
//First Name
//Last Name
//Phone Number
//Email
//Country Code
//Region
//City
//Address
//--
//Last Activity (date)
//Store Type
//Products from Catalog (count)
//Completed Sales (count)
//Last Sale (date)
//

//SELECT first_name as "First Name",last_name as "Last Name",phone_number as "Phone Number",email as "Email",country as "Country Code",state as "Region",city as "City", address_1 as "Address" FROM initia19_cornersave.ospos_people where user_type = 'type_manage' group by email order by person_id asc;



function getLastActivity($manager_id,$cornersave){
    $activity_date = array();

    //sale
    $store_query = "select max(sale_time) from " . TABLE_SALES . " where manager_id = '$manager_id' and sale_status = '0'";
    $store_result = $cornersave->query($store_query);
    if ($store_result != null && $store_result->is_row_found()){
        if ($row = $store_result->fetch_array()){
            $activity_date[] = $row["max(sale_time)"];
        }
    }


    //inventory
    $store_query = "select max(trans_date) from " . TABLE_INVENTORY . " where manager_id = '$manager_id'";
    $store_result = $cornersave->query($store_query);

    if ($store_result != null && $store_result->is_row_found()){
        if ($row = $store_result->fetch_array()){
            $activity_date[] = $row["max(trans_date)"];
        }
    }

    if (!empty($activity_date)){
        return max($activity_date);
    }

    return "N/A";
}
function getProductFromCatalog($manager_id,$cornersave){
    $store_query = "select count(item_id) from " . TABLE_ITEMS . " where manager_id = '$manager_id' and catalog_id is not null";
    $store_result = $cornersave->query($store_query);

    if ($store_result != null && $store_result->is_row_found()){
        if ($row = $store_result->fetch_array()){
            return $row["count(item_id)"];

        }
    }

    return "N/A";
}
function getProductFromUpload($manager_id,$cornersave){
    $store_query = "select count(item_id) from " . TABLE_ITEMS . " where manager_id = '$manager_id' and catalog_id is null";
    $store_result = $cornersave->query($store_query);

    if ($store_result != null && $store_result->is_row_found()){
        if ($row = $store_result->fetch_array()){
            return $row["count(item_id)"];

        }
    }

    return "N/A";
}
function getCompletedSale($manager_id,$cornersave){
    $store_query = "select count(sale_time) from " . TABLE_SALES . " where manager_id = '$manager_id' and sale_status = '0'";
    $store_result = $cornersave->query($store_query);

    if ($store_result != null && $store_result->is_row_found()){
        if ($row = $store_result->fetch_array()){
            return $row["count(sale_time)"];

        }
    }

    return "N/A";
}
function getLastSale($manager_id,$cornersave){
    $store_query = "select max(sale_time) from " . TABLE_SALES . " where manager_id = '$manager_id' and sale_status = '0'";
    $store_result = $cornersave->query($store_query);

    if ($store_result != null && $store_result->is_row_found()){
        if ($row = $store_result->fetch_array()){
            return $row["max(sale_time)"];
        }
    }

    return "N/A";
}
function getLastLogin($manager_id,$cornersave){
    $store_query = "select max(login_time) from " . TABLE_LOGIN . " where user_id = '$manager_id'";
    $store_result = $cornersave->query($store_query);

    if ($store_result != null && $store_result->is_row_found()){
        if ($row = $store_result->fetch_array()){
            return $row["max(login_time)"];
        }
    }

    return "N/A";
}

function getStoreInfo($store_id,$cornersave){
    //$customer = new Customer($cornersave);

    $result = array();

    $manager_query = "select * from " . TABLE_PEOPLE . " where user_ref_id = '$store_id'";
    $manager_result = $cornersave->query($manager_query);

    if ($manager_result != null && $manager_result->is_row_found())
    {
        //$row = $manager_result->fetch_array();

        if ($row = $manager_result->fetch_array())
        {

            $result["store_id"] = $row["user_ref_id"];
            $result["manager_id"] = $row["person_id"];

            if ($row["user_type"] == USER_TYPE_ADMIN){
                $result["manager_id"] = 0;
            }

            $manager_id = $result["manager_id"];

            $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
            $store_result = $cornersave->query($store_query);
            if ($store_result != null){
                while ($row2 = $store_result->fetch_array()){

                    if($row2["key"] == "address"){
                        $result["address"] = $row2["value"];
                    }
                    if($row2["key"] == "company"){
                        $result["name"] = stringCase($row2["value"],STRING_CASE_CAP_EACH);
                        //$result["name"] = "Keviñ";
                    }
                    if($row2["key"] == "company_logo"){
                        $result["logo_url"] = IMG_LOGO_ROOT . $row2["value"];
                    }

                    if($row2["key"] == "currency_code"){
                        $result["currency_code"] = stringCase($row2["value"],STRING_CASE_UPPER);
                    }
                    if($row2["key"] == "currency_decimals"){
                        $result["currency_decimals"] = intval($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "country_codes"){
                        $result["country_codes"] = stringCase($row2["value"],STRING_CASE_UPPER);
                    }
                    if($row2["key"] == "email"){
                        $result["email"] = stringCase($row2["value"]);
                    }
                    if($row2["key"] == "number_locale"){
                        $result["number_locale"] = ($row2["value"]);
                    }
                    if($row2["key"] == "discoverable"){
                        $result["discoverable"] = ($row2["value"] == 1);
                    }
                    if($row2["key"] == "phone"){
                        $result["phone_number"] = ($row2["value"]);
                    }
                    if($row2["key"] == "store_type"){
                        $result["store_type"] = stringCase($row2["value"]);
                    }
                    if($row2["key"] == "coordinates"){
                        $result["coordinates"] = (empty($row2["value"]) ? array("lat" => null,"lng" => null) : json_decode($row2["value"],true));
                    }

                }

            }


            if (!isset($result["coordinates"])){
                $result["coordinates"] = array("lat" => null,"lng" => null);
            }
            if (!isset($result["discoverable"])){
                $result["discoverable"] = false;
            }
            if (!isset($result["store_type"])){
                $result["store_type"] = STORE_TYPE_GROCERYSTORE;
            }

        }


    }

    return $result;
}

$user_list = array();

$store_query = "select * from " . TABLE_PEOPLE . " where user_type = 'type_manage'";
$store_result = $cornersave->query($store_query);
if ($store_result != null && $store_result->is_row_found()){
    while ($row = $store_result->fetch_array()){
        $store_data = getStoreInfo($row["user_ref_id"],$cornersave);

        $user = array();
        $user["First Name"] = $row["first_name"];
        $user["Last Name"] = $row["last_name"];
        $user["Personal Phone Number"] = $row["phone_number"];
        $user["Store Phone Number"] = $store_data["phone_number"];
        $user["Email"] = $row["email"];
        $user["Country Code"] = $row["country"];
        $user["Region"] = $row["state"];
        $user["City"] = $row["city"];
        $user["Personal Address"] = $row["address_1"];
        $user["Store Address"] = $store_data["address"];
        $user["Store Type"] = $store_data["store_type"];
        $user["Store Name"] = $store_data["name"];

        $manager_id = $store_data["manager_id"];
        $store_id = $store_data["store_id"];

        $user["Products From Catalog"] = getProductFromCatalog($manager_id,$cornersave);
        $user["Products From Upload"] = getProductFromUpload($manager_id,$cornersave);
        $user["Completed Sales"] = getCompletedSale($manager_id,$cornersave);
        $user["Last Sale Date"] = getLastSale($manager_id,$cornersave);
        $user["Last Login Date"] = getLastLogin($manager_id,$cornersave);
        $user["Last Activity Date"] = getLastActivity($manager_id,$cornersave);


        $user_list[] = $user;
    }
}

/*$manager_id = 55;

$result = array();
$result["getProductFromCatalog"] = getProductFromCatalog($manager_id,$cornersave);
$result["getProductFromUpload"] = getProductFromUpload($manager_id,$cornersave);
$result["getCompletedSale"] = getCompletedSale($manager_id,$cornersave);
$result["getLastSale"] = getLastSale($manager_id,$cornersave);
$result["getLastLogin"] = getLastLogin($manager_id,$cornersave);
$result["getLastActivity"] = getLastActivity($manager_id,$cornersave);*/


//echo json_encode($result);

//--
//Last Activity (date)
//Products from Catalog (count)
//Products from Uploaded (count)
//Completed Sales (count)
//Last Sale (date)


/*{
"store_id":"3172546551",
"manager_id":"6",
"address":"Bellavista 186, Recoleta, Chile",
"name":"Zendos Snackables",
"logo_url":"https:\/\/source.queritel.com\/figozo\/uploads\/store\/logo\/company_logo.jpg",
"country_codes":"CL",
"currency_code":"CLP",
"currency_decimals":0,
"email":"change@example.com",
"number_locale":"es-CL",
"phone_number":"8764420992",
"discoverable":true,
"coordinates":{"lat":-33.433553299999999808278516866266727447509765625,"lng":-70.6427249999999986584953148849308490753173828125},
"store_type":"grocerystore"
}*/


echo json_encode($user_list);