<?php

/**
 * @Author : Kadian Salmon
 * Date : Mar 1, 2021
 * Purpose : process all api request for mobile merchant application
 * @link : http://api.queritel.com/api/mobile/cornersave/catalog/v1/api.php
 */

header("Access-Control-Allow-Origin: *"); //enable resourse sharing(allows this resource to be shared with "all[*]" requesting clients
header('Content-Type: application/json');


define("DEFAULT_COUNTRY_CODE","US");
define("DEFAULT_LOCALE","en-US");
define("DEFAULT_LANGUAGE","english");


//cornersave database
define("MAIN_DB_USERNAME", "initia19_cornersave");
define("MAIN_DB_PASSWORD", "cornersave");
define("MAIN_DB_NAME", "initia19_cornersave");

define("PASSWORD_SALT","kfhfgsrakshsfhdtewpjskhfh");


// database tables
define("TABLE_LOGIN", "mobile_login");
define("TABLE_CONFIG", "ospos_app_config");
define("TABLE_PEOPLE", "ospos_people");
define("TABLE_EMPLOYEE", "ospos_employees");
define("TABLE_CUSTOMER", "ospos_customers");
define("TABLE_ITEMS", "ospos_items");
define("TABLE_ITEM_QUANTITY", "ospos_item_quantities");
define("TABLE_INVENTORY", "ospos_inventory");
define("TABLE_SALES", "ospos_sales");
define("TABLE_SALES_ITEMS", "ospos_sales_items");
define("TABLE_KITS", "ospos_item_kits");
define("TABLE_GIFT_CARDS", "ospos_giftcards");
define("TABLE_KITS_ITEMS", "ospos_item_kit_items");
define("TABLE_USER_PERMISSIONS", "ospos_grants");
define("TABLE_ALL_PERMISSIONS", "ospos_permissions");
define("TABLE_ALL_MODULES", "ospos_modules");

//catalog
define("TABLE_CATALOG_CATEGORY", "catalog_category_list");
define("TABLE_CATALOG_UNIT", "catalog_unit_list");
define("TABLE_CATALOG_BRAND", "catalog_brand_list");
define("TABLE_CATALOG", "catalog_item_list");

//USER TYPES CONSTANTS
define('USER_TYPE_ADMIN', "type_admin");
define('USER_TYPE_MANAGER', "type_manage");
define('USER_TYPE_EMPLOYEE', "type_emp");
define('USER_TYPE_CUSTOMER', "type_custom");

//GENDER CONSTANTS
define("GENDER_MALE_CODE",1);
define("GENDER_FEMALE_CODE",0);
define("GENDER_NOT_TO_SAY_CODE",2);
define("GENDER_MALE","male"); //(This represents male)
define("GENDER_FEMALE","female"); //(This represents female)
define("GENDER_NOT_TO_SAY","not_to_say"); //(This represents Prefer not to say)

//STATUS CONSTANTS
define("STATUS_OK","OK");
define("STATUS_ERROR","ERROR");

//login state
define("LOGIN_STATE_VALID", 1);
define("LOGIN_STATE_INVALID", 0);

//ERROR NAME CONSTANTS
define("ERROR_NAME_OP_FAILED","opFailed");

//ERROR MESSAGE CONSTANTS
define("ERROR_MSG_INVALID_CRED","INV_CR"); //("The Credentials provided are invalid")
define("ERROR_MSG_INVALID_LOGIN","INV_LGN");//("The user is not Logged in")
define("ERROR_MSG_INVALID_TOKEN","INV_TKN");//("The Login token is invalid") {re-entering the password is needed}
define("ERROR_MSG_USER_SUSPENDED","USR_SPND");//("The account has been suspended")
define("ERROR_MSG_USER_UNKNOWN","UNK_ERR");//("An unknown error was encountered")
define("ERROR_MSG_UN_CHANGED","UN_CHANGED");//("The data was not changed")

//MODULE TYPE CONSTANTS
define("MODULE_CUSTOMER","module_customer"); //(This is the customer module)
define("MODULE_ITEM","module_item"); //(This is the item/product module)
define("MODULE_SUPPLIER","module_supplier"); //(This is the supplier module)
define("MODULE_TEAM","module_team"); //(This is the team module)
define("MODULE_SALE","module_sale"); //(This is the sale module)
define("MODULE_ORDER","module_order"); //(This is the order module)
define("MODULE_CONFIGURATION","module_configuration"); //(This is the configuration module)
define("MODULE_REPORT","module_report"); //(This is the report module)
define("MODULE_EXPENSE","module_expense"); //(This is the expense module)
define("MODULE_PROMOTION","module_promotion"); //(This is the promotion module)
define("MODULE_GIFTCARD","module_giftcard"); //(This is the giftcard module)
define("MODULE_RECEIVING","module_receiving"); //(This is the receiving module)
define("MODULE_MESSAGE","module_message"); //(This is the message module)
define("MODULE_CATALOG","module_catalog"); //(This is the catalog module)

//INVENTORY LOG
define("INVENTORY_LOG_FROM_CATALOG","from_catalog"); //(added from catalog)
define("INVENTORY_LOG_MANUAL_QUANTITY","manually_changed_quantity"); //(manually edited quantity)


//STORE TYPE CONSTANTS
define("STORE_TYPE_GROCERYSTORE","grocerystore"); //("Grocery Store")(This is represents a Grocery Store)
define("STORE_TYPE_SUPERMARKET","supermarketstore"); //("Supermarket")(This is represents a Supermarket)
define("STORE_TYPE_WHOLESALE","wholesalestore"); //("Wholesale")(This is represents a Wholesale)
define("STORE_TYPE_LIQUOR_STORE","liquorstore"); //("Liquor Store")(This is represents a Liquor Store)
define("STORE_TYPE_MEAT_SHOP","meatstore"); //("Meat Shop")(This is represents a Meat Shop)
define("STORE_TYPE_OTHER_STORE","otherstore"); //("Other")(This is represents Other types of Store)


/*
 | Sale Related Constants.
 */
define('ORDER_COMPLETED',   0);
define('ORDER_SUSPENDED',   1);// or pre-ordered
define('ORDER_CANCELED',    2);

//sale_type
define('SALE_TYPE_POS',         0);
define('SALE_TYPE_INVOICE',     1);
define('SALE_TYPE_WORK_ORDER',  2);
define('SALE_TYPE_QUOTE',       3);
define('SALE_TYPE_RETURN',      4);


define("PRODUCT_TYPE_ITEM","type_item");
define("PRODUCT_TYPE_PROMOTION","type_promotion");
define("PRODUCT_TYPE_GIFT","type_gift");
define("PRODUCT_TYPE_SERVICE","type_service");

//SALE_TYPE_POS_STR = "sale" //("Sales Receipt")(This is the default register type)
//SALE_TYPE_INVOICE_STR  = "sale_invoice" //("Invoice")()
//SALE_TYPE_QUOTE_STR = "sale_quote" //("Quote")()
//SALE_TYPE_RETURN_STR = "return" //("Return")()

//API KEY | AND FIREBASE CONSTANTS
define("SERVER_MAP_KEY", "AIzaSyC-BVS2YTBaFhJYVG1FBVWMVruSc44Alns");
define("FIREBASE_SERVER_KEY", "AIzaSyCj1UPVstd1UJYzVDumN4VfkIRG1B1_UQQ");
define("FIREBASE_SENDER_ID", "384417295562");
//define("NEW_REQUEST_TOPIC", "/topics/new_request");
//define("NEW_LOCATION_TOPIC", "/topics/location_changed");
//define("NEW_DRIVER_TOPIC", "/topics/driver_added");

/**
 * @Title Official Mobile Application Version Information
 * @Obj VERSION_NAME : This the version string name is is only used for labeling
 * @Obj VERSION_CODE : This is the actual version code used to maintain app version
 * @Obj VERSION_COMMENT : This is an optional string to be used in messaging
 * @Obj VERSION_PRIORITY : (0 -> This update is not priority and can be ignored by the user | 1 -> This update cannot be ignored)
 * @Usage : verifyLogin and processed by SplashScreen on the mobile App
 */
/*define("MOBILE_AGENT_ANDROID", "android");
define("MOBILE_AGENT_IOS", "ios");
define("MOBILE_VERSION_NAME", "version_name");
define("MOBILE_VERSION_CODE", "version_code");
define("MOBILE_VERSION_COMMENT", "version_comment");
define("MOBILE_VERSION_PRIORITY", "version_priority");

define("ANDROID_VERSION_NAME", "1.0");
define("ANDROID_VERSION_CODE", 1);
define("ANDROID_VERSION_COMMENT", ".");
define("ANDROID_VERSION_PRIORITY", 0);

define("IOS_VERSION_NAME", "1.0");
define("IOS_VERSION_CODE", 1);
define("IOS_VERSION_COMMENT", ".");
define("IOS_VERSION_PRIORITY", 0);
*/




include("../includes/headers/classes-v1.php");//has all the classes needed for queritel back-end
include("../includes/headers/miscellaneous-v1.php");//additional functions
include("../includes/headers/strings.php");//has all the constants needed


//ACTION CONSTANTS
define("ACTION_LOG_IN", "log_in"); //--
define("ACTION_LOG_OUT", "log_out"); //--
define("ACTION_AUTHENTICATE_USER", "authenticate_user"); //--
define("ACTION_PROFILE_DATA_GET", "get_profile_data");
define("ACTION_STORE_DATA_GET", "get_store_data");
define("ACTION_LOCALE_CONVERSION", "locale_conversion");

//UNDONE
define("ACTION_PROFILE_DATA_SET", "set_profile_data");
define("ACTION_SIGN_UP", "sign_up");
define("ACTION_PASSWORD_CHANGE", "change_password");
//define("ACTION_PASSWORD_RESET", "reset_password");
//define("", "");


define("IMG_ITEM_DEFAULT", "no_photo.png");
define("IMG_LOGO_DEFAULT", "no_store.png");
//define("IMG_ITEM_ROOT", "https://app.cornersave.com/public/uploads/item_pics/");
//define("IMG_LOGO_ROOT", "https://app.cornersave.com/public/uploads/");
define("IMG_ITEM_ROOT", "https://source.queritel.com/figozo/uploads/store/product/");
define("IMG_LOGO_ROOT", "https://source.queritel.com/figozo/uploads/store/logo/");
define("SITE_CUSTOMER_ROOT", "https://store.cornersave.com/store/?storeid=");

//https://app.cornersave.com/public/uploads/item_pics/704080.jpg
//https://app.cornersave.com/public/uploads/item_pics/581446.jpg



define("FTP_HOST_SERVER", "ftp.queritel.com");
define("FTP_F_HOST_USERNAME", "figozo@source.queritel.com");
define('FTP_F_HOST_PASS', 'WdC1Dy$V0npr');



$cornersave = new Database(MAIN_DB_USERNAME, MAIN_DB_PASSWORD, MAIN_DB_NAME);


//API CANCEL STATE
if (isset($_REQUEST["action"]) && $_REQUEST["action"] == "demo"){
    $result = array();

    $result["option"] = "test";



    //for ($x = 0; $x < 5; $x++){
        //echo generate_unique_id("unit") . "<br>";
        //echo getCurrentTime() . "<br>";
    //}

    //echo generate_unique_id("catalog") . "<br>";
    //echo getCurrentTime() . "<br>";


    //echo json_export($result);
}

/*FilterType:
    country_code - Country
    category_id - Category
    brand_id - Brand
    unit_label_id - Unit Label
*/
/*FilterMode:
    inc - include
    exc - exclude
*/
$supported_filter_types = array(
    "country_code",
    "category_id",
    "brand_id",
    "unit_label_id"
);
$supported_filter_modes = array(
    "inc",
    "exc"
);

if (isset($_REQUEST["action"])){
    $release = $_REQUEST["release"];
    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];

    if ($action == ACTION_LOCALE_CONVERSION){
        $data = json_decode($param_json, true);

        $number_locale = text_clean($data["number_locale"]);
        $value = text_clean($data["value"]);

        $result = locale_converter($number_locale,$value);

        echo json_export($result);
    }

    //todo : fix reset password
    if ($action == ACTION_LOG_IN){
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse(ACTION_LOG_IN,json_encode($data,JSON_PRETTY_PRINT));


        $username = strtolower(text_clean($data["user_name"]));
        $password = text_clean($data["password"]);

        //jenny
        if($username == "jennybrown205@gmail.com"){
            $id = 370;
            $new_pass = encryptPassword($password);

            $sql_query = "update " . TABLE_EMPLOYEE . " set `password` = '$new_pass' where `person_id` = '$id'";
            $sql_query_result = $cornersave->query($sql_query);
            if($sql_query_result != null && $sql_query_result->is_row_affected()){
                $username = "jenny";
            }

            //todo : API Debug
            debugAPIResponse(ACTION_LOG_IN . "-" . $username,json_encode($data,JSON_PRETTY_PRINT));

        }

        $catalog = new Catalog($cornersave);
        $result = $catalog->login($username, $password);


        echo json_export($result);
    }
    if ($action == ACTION_LOG_OUT){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $catalog = new Catalog($cornersave);

        $result = $catalog->signout($user_id, $login_token);

        echo json_encode($result);

    }
    if ($action == ACTION_AUTHENTICATE_USER){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $catalog = new Catalog($cornersave);
        $result = $catalog->verifyLogin($user_id, $login_token);

        echo json_export($result);
    }

    //todo - 100%
    if ($action == "get_catalog_list"){
        /*{
          "user_id": "55",
          "login_token": "91085539",
          "search_id": "null",
          "search_limit": 10,
          "offset_index": 0,
          "filter_list": [
            {
              "filter_type": "country_code",
              "filter_mode": "inc",
              "filter_criteria": "JM"
            },
            {
              "filter_type": "category_id",
              "filter_mode": "inc",
              "filter_criteria": "category-hhgxfcs-7504219-rnpchcb"
            },
            {
              "filter_type": "brand_id",
              "filter_mode": "inc",
              "filter_criteria": "brand-hhgxfcs-7504219-rnpchcb"
            },
            {
              "filter_type": "unit_label_id",
              "filter_mode": "inc",
              "filter_criteria": "unit-nrbxaem-0102251-utpsiex"
            }
          ]
        }*/
        $data = json_decode($param_json, true);


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $search_id = text_clean($data["search_id"]);
        $search_limit = text_clean($data["search_limit"]);
        $offset_index = text_clean($data["offset_index"]);

        $filter_list = $data["filter_list"];

        if ($search_limit < 20){
            $search_limit = 60;
        }


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $result = $catalog->getOKStatus();

            //get_catalog_info($catalog_id,$cornersave)

            /*$code = '{
                "status": "OK",
                "catalog_list": []
            }';*/

            //$code_obj = json_decode($code,true);

            //$manage_id = $catalog->getManagerId();
            //$store_data = $catalog->getStoreData();
            //$country_code = $store_data["country_codes"];

            $catalog_list = array();

            $limit_from = intval($offset_index);
            $row_count = intval($search_limit);

            $has_where_clause = false;


            //todo - fixme - remove inner join and embed the data in the catalog
            $sql_query = "select * from " . TABLE_CATALOG . " ";


            //filter check here
            $filter_string = null;
            if (!empty($filter_list)){

                $country_filter = array();
                $brand_filter = array();
                $category_filter = array();
                $unit_filter = array();

                foreach ($filter_list as $filter){

                    $filter_type = text_clean($filter["filter_type"]);
                    $filter_mode = text_clean($filter["filter_mode"]);
                    $filter_criteria = text_clean($filter["filter_criteria"]);

                    if ($filter_type == "country_code"){
                        if ($filter_mode == "inc" || $filter_mode == "exc"){
                            $country_filter[$filter_mode][] = $filter_criteria;
                        }
                    }
                    elseif ($filter_type == "category_id"){
                        if ($filter_mode == "inc" || $filter_mode == "exc"){
                            $category_filter[$filter_mode][] = $filter_criteria;
                        }
                    }
                    elseif ($filter_type == "brand_id"){
                        if ($filter_mode == "inc" || $filter_mode == "exc"){
                            $brand_filter[$filter_mode][] = $filter_criteria;
                        }
                    }
                    elseif ($filter_type == "unit_label_id"){
                        if ($filter_mode == "inc" || $filter_mode == "exc"){
                            $unit_filter[$filter_mode][] = $filter_criteria;
                        }
                    }


                }

                $country_included = null;
                $country_excluded = null;
                $brand_included = null;
                $brand_excluded = null;
                $category_included = null;
                $category_excluded = null;
                $unit_included = null;
                $unit_excluded = null;

                if (!empty($country_filter["inc"])){

                    $country_included = "country_code in (";
                    foreach ($country_filter["inc"] as $criteria){
                        $country_included .= "'$criteria',";
                    }
                    $country_included = rtrim($country_included, ",");
                    $country_included .= ")";
                }
                if (!empty($country_filter["exc"])){

                    $country_excluded = "country_code not in (";
                    foreach ($country_filter["exc"] as $criteria){
                        $country_excluded .= "'$criteria',";
                    }
                    $country_excluded = rtrim($country_excluded, ",");
                    $country_excluded .= ")";
                }
                if (!empty($brand_filter["inc"])){

                    $brand_included = "brand_id in (";
                    foreach ($brand_filter["inc"] as $criteria){
                        $brand_included .= "'$criteria',";
                    }
                    $brand_included = rtrim($brand_included, ",");
                    $brand_included .= ")";
                }
                if (!empty($brand_filter["exc"])){

                    $brand_excluded = "brand_id not in (";
                    foreach ($brand_filter["exc"] as $criteria){
                        $brand_excluded .= "'$criteria',";
                    }
                    $brand_excluded = rtrim($brand_excluded, ",");
                    $brand_excluded .= ")";
                }
                if (!empty($category_filter["inc"])){

                    $category_included = "category_id in (";
                    foreach ($category_filter["inc"] as $criteria){
                        $category_included .= "'$criteria',";
                    }
                    $category_included = rtrim($category_included, ",");
                    $category_included .= ")";
                }
                if (!empty($category_filter["exc"])){

                    $category_excluded = "category_id not in (";
                    foreach ($category_filter["exc"] as $criteria){
                        $category_excluded .= "'$criteria',";
                    }
                    $category_excluded = rtrim($category_excluded, ",");
                    $category_excluded .= ")";
                }
                if (!empty($unit_filter["inc"])){

                    $unit_included = "unit_label_id in (";
                    foreach ($unit_filter["inc"] as $criteria){
                        $unit_included .= "'$criteria',";
                    }
                    $unit_included = rtrim($unit_included, ",");
                    $unit_included .= ")";
                }
                if (!empty($unit_filter["exc"])){

                    $unit_excluded = "unit_label_id not in (";
                    foreach ($unit_filter["exc"] as $criteria){
                        $unit_excluded .= "'$criteria',";
                    }
                    $unit_excluded = rtrim($unit_excluded, ",");
                    $unit_excluded .= ")";
                }


                //$has_where_clause = true;
                $filter_string = null;

                if (!empty($country_included)){
                    if (!empty($filter_string)){
                        $filter_string .= "and ";
                    }

                    $filter_string .= "($country_included) ";

                }
                if (!empty($country_excluded)){
                    if (!empty($filter_string)){
                        $filter_string .= "and ";
                    }

                    $filter_string .= "($country_excluded) ";

                }
                if (!empty($brand_included)){
                    if (!empty($filter_string)){
                        $filter_string .= "and ";
                    }

                    $filter_string .= "($brand_included) ";

                }
                if (!empty($brand_excluded)){
                    if (!empty($filter_string)){
                        $filter_string .= "and ";
                    }

                    $filter_string .= "($brand_excluded) ";

                }
                if (!empty($category_included)){
                    if (!empty($filter_string)){
                        $filter_string .= "and ";
                    }

                    $filter_string .= "($category_included) ";

                }
                if (!empty($category_excluded)){
                    if (!empty($filter_string)){
                        $filter_string .= "and ";
                    }

                    $filter_string .= "($category_excluded) ";

                }
                if (!empty($unit_included)){
                    if (!empty($filter_string)){
                        $filter_string .= "and ";
                    }

                    $filter_string .= "($unit_included) ";

                }
                if (!empty($unit_excluded)){
                    if (!empty($filter_string)){
                        $filter_string .= "and ";
                    }

                    $filter_string .= "($unit_excluded) ";

                }


                if (!empty($filter_string)){

                    $sql_query .= "where " . $filter_string;

                    $has_where_clause = true;
                }

            }

            if (!empty($search_id)){
                if ($has_where_clause){//and ((name like '%$search_id%'))
                    //$sql_query .= "and ((catalog_item_list.name like '%$search_id%') or (catalog_category_list.name like '%$search_id%') or (catalog_brand_list.name like '%$search_id%') or (catalog_unit_list.name like '%$search_id%')) "; //order by `name` asc
                    $sql_query .= "and ((name like '%$search_id%')) or ((catalog_id like '%$search_id%')) or ((brand_name like '%$search_id%')) "; //order by `name` asc
                }
                else{
                    //$sql_query .= "where ((catalog_item_list.name like '%$search_id%') or (catalog_category_list.name like '%$search_id%') or (catalog_brand_list.name like '%$search_id%') or (catalog_unit_list.name like '%$search_id%')) "; //order by `name` asc
                    $sql_query .= "where ((name like '%$search_id%')) or ((catalog_id like '%$search_id%')) or ((brand_name like '%$search_id%')) "; //order by `name` asc
                    //$sql_query .= "where ((category_id = '$search_id')) "; //order by `name` asc
                }



                //$sql_query .= " where ((catalog_name like '%$search_id%') or (category_name like '%$search_id%') or (brand_name like '%$search_id%') or (unit_label like '%$search_id%')) "; //order by `name` asc
                //$sql_query .= "where (catalog_name like '%$search_id%' or category_name like '%$search_id%' or brand_name like '%$search_id%' or unit_label like '%$search_id%') "; //order by `name` asc
                //$sql_query .= "where (catalog_name like '%$search_id%' or category_name like '%$search_id%' or brand_name like '%$search_id%' or unit_label like '%$search_id%') "; //order by `name` asc
                //$sql_query .= "where ((catalog_name like '%$search_id%') or (category_name like '%$search_id%') or (brand_name like '%$search_id%') or (unit_label like '%$search_id%')) "; //order by `name` asc

                //echo $sql_query;

                //$sql_query = "select * from " . TABLE_CATALOG . " where `name` like '%$search_id%' $criteria_check limit $row_count offset $limit_from"; //order by `name` asc
            }

            //add limit
            $sql_query .= "limit $row_count offset $limit_from";


            $sql_query_result = $cornersave->query($sql_query);

            $items_returned = 0;

            if($sql_query_result != null && $sql_query_result->is_row_found()){
                while($row = $sql_query_result->fetch_array()){
                    $catalog_item = array();
                    //$catalog_item = get_catalog_info($row["catalog_id"],$manage_id,$cornersave);

                    $brand = get_catalog_brand($row["brand_id"],$cornersave);
                    $category = get_catalog_category($row["category_id"],$cornersave);
                    $unit_label = get_catalog_label($row["unit_label_id"],$cornersave);

                    $catalog_item["catalog_id"] = $row["catalog_id"];
                    $catalog_item["product_name"] = $row["name"];
                    $catalog_item["category_name"] = $category;
                    $catalog_item["brand"] = $brand;
                    $catalog_item["unit_value"] = intval($row["unit_value"]);
                    $catalog_item["unit_label"] = $unit_label;
                    $catalog_item["image_url"] = IMG_ITEM_ROOT .  $row["file_name"];
                    $catalog_item["image_name"] = $row["file_name"];
                    $catalog_item["country_code"] = $row["country_code"];
                    //$catalog_item["in_store"] = catalog_is_in_store($row["catalog_id"],$catalog,$cornersave);

                    $catalog_list[] = $catalog_item;

                    $items_returned++;
                }
            }

            $last_index = (intval($offset_index) + intval($items_returned));

            $result["last_index"] = $last_index;
            $result["catalog_list"] = $catalog_list;

        }

        echo json_export($result);
        //echo json_export($catalog_list);
    }

    //todo - 100%
    if ($action == "get_category_list"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $search_id = text_clean($data["search_id"]);

        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            //$store_data = $catalog->getStoreData();
            //$country_code = $store_data["country_codes"];

            $category_list = array();

            if (!empty($search_id)){
                $sql_query = "select * from " . TABLE_CATALOG_CATEGORY . " where `name` like '%$search_id%'"; // order by `name`
            }
            else{
                $sql_query = "select * from " . TABLE_CATALOG_CATEGORY . " order by `name`";
            }

            $sql_query_result = $cornersave->query($sql_query);

            if($sql_query_result != null && $sql_query_result->is_row_found()){
                while($row = $sql_query_result->fetch_array()){
                    $category_name = $row["name"];
                    $category_id = $row["category_id"];

                    $category = array();
                    $category["category_name"] = $category_name;
                    $category["category_id"] = $category_id;

                    $category_list[] = $category;
                    //if(is_category_in_country($category_id, $country_code,$cornersave)){
                    //    $category_list[] = $category;
                    //}
                }
            }
            /*$string_json = '{
                  "status": "OK",
                  "category_list": [
                    {
                      "category_name": "Promotion",
                      "category_id": "promotion"
                    },
                    {
                      "category_name": "Bebidas",
                      "category_id": "bebidas"
                    },
                    {
                      "category_name": "Dulces",
                      "category_id": "dulces"
                    },
                    {
                      "category_name": "Panadería",
                      "category_id": "panaderia"
                    }
                  ]
                }';

            $obj = json_decode($string_json,true);
            $result["category_list"] = $obj["category_list"];
            */


            $result = $catalog->getOKStatus();
            $result["category_list"] = $category_list;

        }

        echo json_export($result);
    }

    //todo - 100%
    if ($action == "get_brand_list"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $search_id = text_clean($data["search_id"]);

        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $store_data = $catalog->getStoreData();
            //$country_code = $store_data["country_codes"];

            $brand_list = array();

            if (!empty($search_id)){
                $sql_query = "select * from " . TABLE_CATALOG_BRAND . " where (`name` like '%$search_id%')"; // order by `name` asc
            }
            else{
                $sql_query = "select * from " . TABLE_CATALOG_BRAND . " order by `name` asc";
            }

            $sql_query_result = $cornersave->query($sql_query);

            if($sql_query_result != null && $sql_query_result->is_row_found()){
                while($row = $sql_query_result->fetch_array()){
                    $brand_name = $row["name"];
                    $brand_id = $row["brand_id"];

                    $brand = array();
                    $brand["brand_name"] = $brand_name;
                    $brand["brand_id"] = $brand_id;

                    $brand_list[] = $brand;

                }
            }

            /*$string_json = '{
                  "status": "OK",
                  "category_list": [
                    {
                      "category_name": "Promotion",
                      "category_id": "promotion"
                    },
                    {
                      "category_name": "Bebidas",
                      "category_id": "bebidas"
                    },
                    {
                      "category_name": "Dulces",
                      "category_id": "dulces"
                    },
                    {
                      "category_name": "Panadería",
                      "category_id": "panaderia"
                    }
                  ]
                }';

            $obj = json_decode($string_json,true);
            $result["category_list"] = $obj["category_list"];
            */



            $result = $catalog->getOKStatus();
            $result["brand_list"] = $brand_list;

        }

        echo json_export($result);
    }

    //todo - 100%
    if ($action == "get_unit_list"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $search_id = text_clean($data["search_id"]);



        $catalog =  new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $store_data = $catalog->getStoreData();
            //$country_code = $store_data["country_codes"];

            $unit_label_list = array();

            if (!empty($search_id)){
                $sql_query = "select * from " . TABLE_CATALOG_UNIT . " where (`name` like '%$search_id%')"; // order by `name` asc
            }
            else{
                $sql_query = "select * from " . TABLE_CATALOG_UNIT . " order by `name` asc";
            }

            $sql_query_result = $cornersave->query($sql_query);

            if($sql_query_result != null && $sql_query_result->is_row_found()){
                while($row = $sql_query_result->fetch_array()){
                    $unit_label_name = $row["name"];
                    $unit_label_id = $row["unit_label_id"];

                    $unit_label = array();
                    $unit_label["unit_name"] = $unit_label_name;
                    $unit_label["unit_id"] = $unit_label_id;

                    $unit_label_list[] = $unit_label;

                }
            }

            /*$string_json = '{
                  "status": "OK",
                  "category_list": [
                    {
                      "category_name": "Promotion",
                      "category_id": "promotion"
                    },
                    {
                      "category_name": "Bebidas",
                      "category_id": "bebidas"
                    },
                    {
                      "category_name": "Dulces",
                      "category_id": "dulces"
                    },
                    {
                      "category_name": "Panadería",
                      "category_id": "panaderia"
                    }
                  ]
                }';

            $obj = json_decode($string_json,true);
            $result["category_list"] = $obj["category_list"];
            */



            $result = $catalog->getOKStatus();
            $result["unit_list"] = $unit_label_list;

        }

        echo json_export($result);
    }

    if ($action == "get_filter_type_list"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);


            $result = $catalog->getOKStatus();
            $result["filter_type_list"] = $supported_filter_types;

        }

        echo json_export($result);

    }

    //fixme -- get_filter_criteria_list
    if ($action == "get_filter_criteria_list"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $store_data = $catalog->getStoreData();
            //$country_code = $store_data["country_codes"];

            $category_list = array();

            $sql_query = "select * from " . TABLE_CATALOG_CATEGORY . " order by `name` asc";
            $sql_query_result = $cornersave->query($sql_query);

            if($sql_query_result != null && $sql_query_result->is_row_found()){
                while($row = $sql_query_result->fetch_array()){
                    $category_name = $row["name"];
                    $category_id = $row["category_id"];

                    $category = array();
                    $category["category_name"] = $category_name;
                    $category["category_id"] = $category_id;

                    $category_list[] = $category;
                    //if(is_category_in_country($category_id, $country_code,$cornersave)){
                    //    $category_list[] = $category;
                    //}


                }
            }

            /*$string_json = '{
                  "status": "OK",
                  "category_list": [
                    {
                      "category_name": "Promotion",
                      "category_id": "promotion"
                    },
                    {
                      "category_name": "Bebidas",
                      "category_id": "bebidas"
                    },
                    {
                      "category_name": "Dulces",
                      "category_id": "dulces"
                    },
                    {
                      "category_name": "Panadería",
                      "category_id": "panaderia"
                    }
                  ]
                }';

            $obj = json_decode($string_json,true);
            $result["category_list"] = $obj["category_list"];
            */



            $result = $catalog->getOKStatus();
            $result["category_list"] = $category_list;

        }

        echo json_export($result);

    }


    //todo - add_catalog_item - fix country, image
    if ($action == "add_catalog_item"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        //debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));
        //debugAPIResponse($action . "-2",json_encode($_REQUEST,JSON_PRETTY_PRINT));


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        //$list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            //$store_data = $catalog->getStoreData();

            /*
                //The Following fields are FORM POST fields
                name = "item_name"     //([type = string])([detail = The item name entered by user])([sample = "Apples Juice"])
                name = "category_name" //([type = string])([detail = The category entered by user])([sample = "Fruits"])
                name = "brand"         //([type = string])([detail = The brand entered by user])([sample = "RainForrest"])
                name = "unit_value"    //([type = integer])([detail = The unit value entered by user])([sample = 100])
                name = "unit_label"    //([type = string])([detail = The unit label entered by the user])([sample = "ml"])
                name = "barcode"       //([type = string])([detail = The barcode entered by th user])([sample = "7684846638"])
                name = "category_id"   //([type = string])([detail = This is the category_id from the list])([sample = "category-hhgjf-kgjg"])
                name = "brand_id"      //([type = string])([detail = This is the brand_id from the list])([sample = "brand-hhgjf-kgjg"])
                name = "unit_label_id" //([type = string])([detail = This is the unit_label_id from the list])([sample = "unit-hhgjf-kgjg"])
                name = "image_url"     //([type = string])([detail = if the user provided a image url])([sample = "http://resources/image/applejuice.jpg"])
                name = "image_file"    //([type = image file])([detail = if the user uploaded a file])([sample = --])
            */

            $item_name = text_clean($_REQUEST["item_name"]);
            $category_name = text_clean($_REQUEST["category_name"]);
            $brand = text_clean($_REQUEST["brand"]);
            $unit_value = text_clean($_REQUEST["unit_value"]);
            $unit_label = text_clean($_REQUEST["unit_label"]);
            $barcode = text_clean($_REQUEST["barcode"]);
            $category_id = text_clean($_REQUEST["category_id"]);
            $brand_id = text_clean($_REQUEST["brand_id"]);
            $unit_label_id = text_clean($_REQUEST["unit_label_id"]);
            $image_url = text_clean($_REQUEST["image_url"]);
            $country = text_clean($_REQUEST["country"]);

            //id, catalog_id, update_time,
            // category_id, brand_id,
            // unit_label_id, unit_value,
            // country_code, name, file_name

            $catalog_id = generate_unique_id("catalog_");

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $get_insert_query = get_insert_query(TABLE_CATALOG, [
                "catalog_id" => $catalog_id,
                "update_time" => getCurrentTime(),
                "category_id" => $category_id,
                "brand_id" => $brand_id,
                "unit_label_id" => $unit_label_id,
                "unit_value" => $unit_value,
                "country_code" => $country,
                "name" => $item_name,
                "brand_name" => $brand,
                "file_name" => ""
            ]);

            $sql_query_result = $cornersave->query($get_insert_query);
            if($sql_query_result != null && $sql_query_result->is_row_affected()){

                if (!empty($image_url)){

                }
                else{
                    if (isset($_FILES["image_file"]["type"])){

                    }
                }

                $result = getOKStatus();

            }

        }

        echo json_export($result);
    }

    //todo - get_catalog_item
    if ($action == "get_catalog_item"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $catalog_id = text_clean($data["catalog_id"]);

        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        //$list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $result = $catalog->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $item_data = array();
            $catalog_item = get_catalog_info($catalog_id,$cornersave);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            if (!empty($catalog_item)){

                $item_data = array();
                $item_data["product_name"] = $catalog_item["product_name"];
                $item_data["category_name"] = $catalog_item["category_name"];
                $item_data["brand"] = $catalog_item["brand"];
                $item_data["unit_value"] = $catalog_item["unit_value"];
                $item_data["unit_label"] = $catalog_item["unit_label"];
                $item_data["image_url"] = $catalog_item["image_url"];
                $item_data["image_name"] = $catalog_item["image_name"];
                $item_data["catalog_id"] = $catalog_item["catalog_id"];
                $item_data["category_id"] = $catalog_item["category_id"];
                $item_data["brand_id"] = $catalog_item["brand_id"];
                $item_data["unit_label_id"] = $catalog_item["unit_label_id"];
                $item_data["country_code"] = $catalog_item["country_code"];
                $item_data["barcode"] = $catalog_item["barcode"];

                $result = getOKStatus();
                $result["item_data"] = $item_data;
            }


        }

        echo json_export($result);
    }

    //fixme - delete_catalog_item
    if ($action == "delete_catalog_item"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $catalog_id = text_clean($data["catalog_id"]);

        //todo : API Debug
        debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        //$list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $result = $catalog->getOKStatus();
            $result["request_echo"] = $_REQUEST;

        }

        echo json_export($result);
    }

    //fixme - update_catalog_item
    if ($action == "update_catalog_item"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $catalog_id = text_clean($data["catalog_id"]);

        //todo : API Debug
        //debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));
        //debugAPIResponse($action . "-2",json_encode($_REQUEST,JSON_PRETTY_PRINT));


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        //$list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $result = getErrorStatus(ERROR_MSG_USER_UNKNOWN);

            $item_name = text_clean($_REQUEST["itemname"]);
            $category_name = text_clean($_REQUEST["category_name"]);
            $brand = text_clean($_REQUEST["brand"]);
            $unit_value = text_clean($_REQUEST["unit_value"]);
            $unit_label = text_clean($_REQUEST["unit_label"]);
            $barcode = text_clean($_REQUEST["barcode"]);
            $category_id = text_clean($_REQUEST["category_id"]);
            $brand_id = text_clean($_REQUEST["brand_id"]);
            $unit_label_id = text_clean($_REQUEST["unit_label_id"]);
            $image_url = text_clean($_REQUEST["image_url"]);
            $country = text_clean($_REQUEST["country"]);


            //"itemname": "Carne Molida Procesada Embutido",
            //"category_name": "Carnes Y Mariscos",
            //"brand": "Acuenta",
            //"unit_value": "250",
            //"unit_label": "g",
            //"country": "undefined",
            //"barcode": "Barcode",
            //"image_url": "https://source.queritel.com/figozo/uploads/store/product/261188.jpg",
            //"category_id": "category-hhgxfcs-7504219-rnpchcb",
            //"brand_id": "brand-kbhicgz-2870285-pqmrwcb",
            //"unit_label_id": "unit-hezbbjj-6182574-kvjrnks",
            //"action": "update_catalog_item",
            //"param_json": "{\"user_id\":\"1\",\"login_token\":\"79402621\",\"catalog_id\":\"catalog-idvlbbb-8957405-pmzzlun\"}"

            /*if (empty($brand_id) || (($brand_id == "brand-cbhdhfr-2638583-flnihsf") && $brand != "-")){

            }*/

            $brand_id = get_brand_id($brand, $cornersave);
            $category_id = get_category_id($category_name, $cornersave);
            $unit_label_id = get_unit_id($unit_label, $cornersave);

            $get_update_query = get_update_query(TABLE_CATALOG, [
                "update_time" => getCurrentTime(),
                "category_id" => $category_id,
                "brand_id" => $brand_id,
                "unit_label_id" => $unit_label_id,
                "unit_value" => $unit_value,
                //"country_code" => $country,
                "name" => $item_name,
                //"file_name" => ""
            ],"catalog_id = '$catalog_id'");

            $sql_query_result = $cornersave->query($get_update_query);
            if($sql_query_result != null && $sql_query_result->is_row_affected()){

            }

            $result = $catalog->getOKStatus();
            $result["request_echo"] = $_REQUEST;

        }

        echo json_export($result);
    }

    //fixme - add_catalog_multi_item
    if ($action == "add_catalog_multi_item"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));
        debugAPIResponse($action . "-2",json_encode($_REQUEST,JSON_PRETTY_PRINT));


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        //$list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $result = $catalog->getOKStatus();
            $result["request_echo"] = $_REQUEST;

        }

        echo json_export($result);
    }

    if ($action == "template"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse($action,json_encode($data,JSON_PRETTY_PRINT));


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        //$list_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $result = $catalog->getOKStatus();

            $code = '{
                "status": "OK",
                "empty_list": [
                    {
                        "user_id": 25,
                        "fname": "John", 
                        "lname": "Nixon", 
                        "email": "john.nixon@cornersave.com", 
                        "phone_number": "8668114567", 
                        "account_enabled": true,
                        "user_type": "type_emp"
                        
                    }
                ]
            }';
            $code_obj = json_decode($code,true);
            $result["empty_list"] = $code_obj["empty_list"];

        }

        echo json_export($result);
    }


    if ($action == "report"){

        include 'extra.php';



    }














    if ($action == ACTION_STORE_DATA_GET){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);


            $store_data = $catalog->getStoreData();

            if (!empty($store_data)){
                $data = array();
                $result = $catalog->getOKStatus();

                $user_data["store_name"] = clean_reverse($store_data["name"]);
                $user_data["phone_number"] = $store_data["phone"];
                $user_data["store_id"] = $store_data["store_id"];
                $user_data["website"] = SITE_CUSTOMER_ROOT . $store_data["store_id"];
                $user_data["logo"] = (empty($store_data["logo"]) ? IMG_LOGO_DEFAULT : $store_data["logo"]);
                $user_data["logo_url"] = IMG_LOGO_ROOT . $store_data["logo"];
                $user_data["currency_code"] = $store_data["currency_code"];
                $user_data["currency_decimals"] = $store_data["currency_decimals"];
                $user_data["discoverable"] = $store_data["discoverable"];
                $user_data["email"] = $store_data["email"];
                $user_data["country_code"] = $store_data["country_codes"];
                $user_data["store_type"] = (empty($store_data["store_type"]) ? STORE_TYPE_GROCERYSTORE : $store_data["store_type"]);
                $user_data["address"] = $store_data["address"];
                //$user_data["coordinates"] = (empty($store_data["coordinates"]) ? array() : json_decode($store_data["coordinates"],true));
                $user_data["coordinates"] = (empty($store_data["coordinates"]) ? array("lat" => floatval(0),"lng" => floatval(0)) : json_decode($store_data["coordinates"],true));

                //$val = text_clean("Maria's Wholesñail and Retail");

                //$update = "update ospos_app_config set `value` = '$val' where `key` = 'company' and manager_id = 90";
                //$cornersave->query($update);

                $result["store_date"] = $user_data;

            }

        }

        echo json_export($result);
        //echo json_encode($result);
    }
    if ($action == ACTION_PROFILE_DATA_GET){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $result = $catalog->getOKStatus();

            $user_data["fname"] = $catalog->get_firstName();
            $user_data["lname"] = $catalog->get_lastName();
            $user_data["user_name"] = $catalog->get_userName();
            $user_data["user_type"] = $catalog->getUserType();
            $user_data["email"] = $catalog->get_email();
            $user_data["gender"] = $catalog->get_gender();
            $user_data["registration_date"] = $catalog->get_registrationDate();
            $user_data["phone_number"] = $catalog->get_phoneNumber();
            $user_data["location_address_1"] = $catalog->getLocationAddress1();
            $user_data["location_address_2"] = $catalog->getLocationAddress2();
            $user_data["location_city"] = $catalog->get_locationCity();
            $user_data["location_state"] = $catalog->get_locationState();
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $catalog->get_locationCountry();


            $result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == ACTION_SIGN_UP){
        $data = json_decode($param_json, true);

        //$user_id = text_clean($data["user_id"]);
        //$login_token = text_clean($data["login_token"]);


        //todo : API Debug
        debugAPIResponse(ACTION_SIGN_UP,json_encode($data,JSON_PRETTY_PRINT));


        /*
             Request
             {
                "": "Kevin", //([First name])
                "": "Smith", //([Last name])
                "": "KevinStore", //(no spaces)([user name - used for login])
                "": "myPass", //([password - used for login])
                "": "kevin.smith@queritel.com", //([Email])
                "": "male", //([GENDER CONSTANTS])
                "": "866811467", //([Phone Number])
                "": "", //([Address 1])
                "": "", //([Address 2])
                "": "", //([City])
                "": "", //([State / municipality])
                "": "", //([Postal code])
                "": "CL" //([Country code])
                "": "en-US" //([LANGUAGE CONSTANTS])
                "": "grocerystore" //([STORE TYPE CONSTANTS])
            }
            */

        $general_success = false;

        $catalog = new Catalog($cornersave);

        $result = $catalog->getErrorStatus(ERROR_MSG_USER_UNKNOWN);

        $first_name = stringCase(text_clean($data["fname"]));
        $last_name = stringCase(text_clean($data["lname"]));
        $user_name = stringCase(text_clean($data["user_name"]));
        $password_txt = text_clean($data["password"]);
        $password = encryptPassword($password_txt);
        $email = stringCase(text_clean($data["email"]));
        $gender = text_clean($data["gender"]);
        if ($gender == GENDER_MALE){
            $gender = GENDER_MALE_CODE;
        }
        elseif ($gender == GENDER_FEMALE){
            $gender = GENDER_FEMALE_CODE;
        }
        elseif ($gender == GENDER_NOT_TO_SAY){
            $gender = GENDER_NOT_TO_SAY_CODE;
        }
        else{
            $gender = null;
        }
        $phone_number = text_clean($data["phone_number"]);

        $location_address_1 = stringCase(text_clean($data["location_address_1"]));
        $location_address_2 = stringCase(text_clean($data["location_address_2"]));
        $location_city = stringCase(text_clean($data["location_city"]));
        $location_state = stringCase(text_clean($data["location_state"]));
        $postal_code = stringCase(text_clean($data["postal_code"]));
        $country_code = stringCase(text_clean($data["country_code"]),STRING_CASE_UPPER);
        $language_code = stringCase(text_clean($data["store_language"]));
        $store_type = stringCase(text_clean($data["store_type"]));

        //todo DEBUG : store_type in app
        if ($store_type == "null"){
            $store_type = "grocerystore";
        }

        $user_type = USER_TYPE_MANAGER;
        $user_ref_id = generateUserReferenceId();
        $creation_time = getCurrentTime();

        $comments = null;
        $manager_id = 0;
        $deleted = 0;
        $disabled = 0;
        $hash_version = 2;



        $add_user = "insert into " . TABLE_PEOPLE . " (first_name, last_name, gender, phone_number, email, address_1, address_2, city, state, zip, country, comments, user_type, user_ref_id, created_on) values('$first_name','$last_name','$gender','$phone_number','$email','$location_address_1','$location_address_2','$location_city','$location_state','$postal_code','$country_code','$comments','$user_type','$user_ref_id','$creation_time')";
        $add_user_result = $cornersave->query($add_user);
        //$add_user_result = null;

        //$add_user_result
        if($add_user_result != null && $add_user_result->is_row_affected()){

            $user_id = $add_user_result->insert_id();

            $add_employee = "insert into " . TABLE_EMPLOYEE . " (username, password, person_id, deleted, hash_version, user_type, manager_id, disabled) values('$user_name','$password','$user_id','$deleted','$hash_version','$user_type','$manager_id','$disabled')";
            $add_employee_result = $cornersave->query($add_employee);
            if($add_employee_result != null && $add_employee_result->is_row_affected()){

                $default_modules = get_default_modules();
                $default_permissions = get_default_permissions();
                $disabled_modules = get_disabled_modules();

                $grants_array = array();
                $disabled_permission = get_disabled_permissions();
                $menu_group = get_menu_group();

                foreach(get_all_permissions($cornersave) as $permission) {
                    $grants = array();

                    if (!isset($disabled_permission[$permission])){
                        $grants['permission_id'] = $permission;
                        $grants['menu_group'] = $menu_group[$permission];

                        $grants_array[] = $grants;
                    }

                }

                $config_data = getConfigData(DEFAULT_LANGUAGE,DEFAULT_LOCALE,$store_type,$country_code);

                //this is a test

                foreach($grants_array as $grant)
                {
                    $permission_id = $grant["permission_id"];
                    $menu_group = $grant["menu_group"];


                    $insert_permission = "insert into " . TABLE_USER_PERMISSIONS . " (permission_id, person_id, menu_group) values('$permission_id','$user_id','$menu_group')";
                    $insert_permission_result = $cornersave->query($insert_permission);
                    if($insert_permission_result != null && $insert_permission_result->is_row_affected()){}

                }

                //todo : API Debug
                //debugAPIResponse("ACTION_SIGN_UP-CONFIG",json_encode($config_data,JSON_PRETTY_PRINT) . " : Manager : $user_id");


                foreach($config_data as $key => $val)
                {
                    $insert_data = "insert into " . TABLE_CONFIG . " (`key`, `value`, `manager_id`) values('$key','$val','$user_id')";
                    $insert_data_result = $cornersave->query($insert_data);
                    if($insert_data_result != null && $insert_data_result->is_row_affected()){}
                }



                $general_success = true;

            }
        }




        /*
     Request
     {
        "fname": "Demo",
        "lname": "User1",
        "user_name": "KevinStore",
        "password": "myPass",
        "email": "kevin.smith@queritel.com",
        "gender": "male",
        "phone_number": "866811467",
        "location_address_1": "",
        "location_address_2": "",
        "location_city": "",
        "location_state": "",
        "postal_code": "",
        "country_code": "CL",
        "store_language": "en-US",
        "store_type": "grocerystore"
    }

    */

        /*
         Request
         {
            "fname": "Kevin", //([First name])
            "lname": "Smith", //([Last name])
            "user_name": "KevinStore", //(no spaces)([user name - used for login])
            "password": "myPass", //([password - used for login])
            "email": "kevin.smith@queritel.com", //([Email])
            "gender": "male", //([GENDER CONSTANTS])
            "phone_number": "866811467", //([Phone Number])
            "location_address_1": "", //([Address 1])
            "location_address_2": "", //([Address 2])
            "location_city": "", //([City])
            "location_state": "", //([State / municipality])
            "postal_code": "", //([Postal code])
            "country_code": "CL" //([Country code])
            "store_language": "en-US" //([LANGUAGE CONSTANTS])
            "store_type": "grocerystore" //([STORE TYPE CONSTANTS])
        }

        */


        //$general_success = true;
        if ($general_success){
            $result = $catalog->login($user_name, $password_txt);
            //$result = $catalog->login("jon.garcia", "newstore");
            //$result = $catalog->getErrorStatus(ERROR_MSG_USER_UNKNOWN);
            /*$result = $catalog->getOKStatus();
            $result["user_id"] = "55";
            $result["user_type"] = "type_manage";
            $result["login_token"] = "98542845";
            $result["request_echo"] = $data;*/


        }


        echo json_export($result);
    }
    if ($action == "set_profile_data"){
        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);

        //todo : API Debug
        debugAPIResponse("set_profile_data",json_encode($data,JSON_PRETTY_PRINT));


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            $result = $catalog->getOKStatus();

            /* request

            {
                    "user_id":21654,
                    "login_token":849345537,
                    "fname": "Kevin", //([First name])
                    "lname": "Smith", //([Last name])
                    "user_name": "Smith", //([user name - used for login])
                    "email": "kevin.smith@queritel.com", //([Email])
                    "gender": "male", //([GENDER CONSTANTS])
                    "phone_number": "866811467", //([Phone Number])
                    "location_address_1": "", //([Address 1])
                    "location_address_2": "", //([Address 2])
                    "location_city": "", //([City])
                    "location_state": "", //([State / municipality])
                    "postal_code": "", //([Postal code])
                    "country_code": "CL" //([Country code])

                }

             */



            /*$user_data["fname"] = $catalog->get_firstName();
            $user_data["lname"] = $catalog->get_lastName();
            $user_data["user_name"] = $catalog->get_userName();
            $user_data["user_type"] = $catalog->getUserType();
            $user_data["email"] = $catalog->get_email();
            $user_data["gender"] = $catalog->get_gender();
            $user_data["registration_date"] = $catalog->get_registrationDate();
            $user_data["phone_number"] = $catalog->get_phoneNumber();
            $user_data["location_address_1"] = text_export($catalog->getLocationAddress1());
            $user_data["location_address_2"] = text_export($catalog->getLocationAddress2());
            $user_data["location_city"] = text_export($catalog->get_locationCity());
            $user_data["location_state"] = text_export($catalog->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $catalog->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "change_password"){
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse("change_password",json_encode($data,JSON_PRETTY_PRINT));


        $user_id = text_clean($data["user_id"]);
        $login_token = text_clean($data["login_token"]);
        $old_password = text_clean($data["password"]);
        $new_password = text_clean($data["new_password"]);


        $catalog = new Catalog($cornersave);
        $isVerified = $catalog->verifyLogin($user_id, $login_token);

        $result = $isVerified;
        $user_data = array();

        if ($isVerified["status"] == STATUS_OK){
            $catalog->initializeMerchant($user_id);

            if (encryptPassword($old_password) == $catalog->get_encrytedPassword()){
                $result = $catalog->getOKStatus();
            }
            else{
                $result = $catalog->getErrorStatus(ERROR_MSG_INVALID_CRED);
            }

            /* Request
            {
                    "user_id": 21654,
                    "login_token": 849345537,
                    "password": "my.pass", //([The user's current password])
                    "new_password": "my.new.pass" //([The new password])
                }
            */

            /*$user_data["fname"] = $catalog->get_firstName();
            $user_data["lname"] = $catalog->get_lastName();
            $user_data["user_name"] = $catalog->get_userName();
            $user_data["user_type"] = $catalog->getUserType();
            $user_data["email"] = $catalog->get_email();
            $user_data["gender"] = $catalog->get_gender();
            $user_data["registration_date"] = $catalog->get_registrationDate();
            $user_data["phone_number"] = $catalog->get_phoneNumber();
            $user_data["location_address_1"] = text_export($catalog->getLocationAddress1());
            $user_data["location_address_2"] = text_export($catalog->getLocationAddress2());
            $user_data["location_city"] = text_export($catalog->get_locationCity());
            $user_data["location_state"] = text_export($catalog->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $catalog->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        }

        echo json_export($result);
    }
    if ($action == "reset_password"){
        $data = json_decode($param_json, true);

        //todo : API Debug
        debugAPIResponse("reset_password",json_encode($data,JSON_PRETTY_PRINT));


        $email = text_clean($data["email"]);


        $catalog = new Catalog($cornersave);
        //$isVerified = $catalog->verifyLogin($user_id, $login_token);

        //$result = $isVerified;
        //$user_data = array();

        $result = $catalog->getOKStatus();

        //if ($isVerified["status"] == STATUS_OK){
            /*$catalog->initializeMerchant($user_id);

            if (encryptPassword($old_password) == $catalog->get_encrytedPassword()){
                $result = $catalog->getOKStatus();
            }
            else{
                $result = $catalog->getErrorStatus(ERROR_MSG_INVALID_CRED);
            }*/

            /* Request
            {
                    "user_id": 21654,
                    "login_token": 849345537,
                    "password": "my.pass", //([The user's current password])
                    "new_password": "my.new.pass" //([The new password])
                }
            */

            /*$user_data["fname"] = $catalog->get_firstName();
            $user_data["lname"] = $catalog->get_lastName();
            $user_data["user_name"] = $catalog->get_userName();
            $user_data["user_type"] = $catalog->getUserType();
            $user_data["email"] = $catalog->get_email();
            $user_data["gender"] = $catalog->get_gender();
            $user_data["registration_date"] = $catalog->get_registrationDate();
            $user_data["phone_number"] = $catalog->get_phoneNumber();
            $user_data["location_address_1"] = text_export($catalog->getLocationAddress1());
            $user_data["location_address_2"] = text_export($catalog->getLocationAddress2());
            $user_data["location_city"] = text_export($catalog->get_locationCity());
            $user_data["location_state"] = text_export($catalog->get_locationState());
            $user_data["postal_code"] = "";
            $user_data["country_code"] = $catalog->get_locationCountry();*/

            //$result["user_data"] = $user_data;

        //}

        echo json_export($result);
    }
    if ($action == "get_"){

        $data = json_decode($param_json, true);

        $user_id = text_clean($data["user_id"]);
        //$login_token = text_clean($data["login_token"]);

        $catalog = new Catalog($cornersave);

        $catalog_list = array();
        $country_code = "CL";

        /*$sql_query = "select * from " . TABLE_CATALOG . " where country_code = '$country_code'";
        $sql_query_result = $cornersave->query($sql_query);

        if($sql_query_result != null && $sql_query_result->is_row_found()){
            while($row = $sql_query_result->fetch_array()){
                $catalog_item = array();
                $catalog_item = get_catalog_info($row["catalog_id"],$cornersave);

                $catalog_list[] = $catalog_item;
            }
        }*/

        $project_list = array();
        $manager_id = 55;

        $sql_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id'";
        $sql_query_result = $cornersave->query($sql_query);

        if($sql_query_result != null && $sql_query_result->is_row_found()){
            while($row = $sql_query_result->fetch_array()){
                $product_item = array();
                $product_item = get_product_info($row["item_id"],$cornersave);

                $project_list[] = $product_item;
            }
        }




        //$result["catalog_list"] = $catalog_list;
        $result["project_list"] = $project_list;

        $result["user"] = $user_id;
        //$result["catalog_list"] = $catalog_list;
        //$result["demo"] = get_catalog_info("catalog-zztppfp-5565564-xsrpwvo",$cornersave);
        //$result["test"] = get_default_permissions();
        //$result["test"] = getConfigData();
        //$result["test"] = get_all_modules($cornersave);
        //$result["test"] = get_all_permissions($cornersave);
        //$result["test"] = get_user_permissions(6,$cornersave);

        /*$grants_array = array();
        $disabled_permission = get_disabled_permissions();
        $menu_group = get_menu_group();

        foreach(get_all_permissions($cornersave) as $permission) {
            $grants = array();

            if (!isset($disabled_permission[$permission])){
                $grants['permission_id'] = $permission;
                $grants['menu_group'] = $menu_group[$permission];

                $grants_array[] = $grants;
            }

        }
        $country_code = "JM";
        $store_type1 = STORE_TYPE_WHOLESALE;

        //$result["test"] = getConfigData($language = DEFAULT_LANGUAGE,$language_code = DEFAULT_LOCALE,$store_type = STORE_TYPE_GROCERYSTORE);
        $config_data = getConfigData($language = DEFAULT_LANGUAGE,$language_code = DEFAULT_LOCALE,$store_type = $store_type1,$country_code);

        $grant_entry = array();
        foreach($grants_array as $grant)
        {
            $entry = array();
            $entry["permission_id"] = $grant["permission_id"];
            $entry["person_id"] = 0;
            $entry["menu_group"] = $grant["menu_group"];

            //$grant_entry[] = $entry;
        }

        $config_entry = array();
        foreach($config_data as $key => $val)
        {
            $entry = array();
            $entry["key"] = $key;
            $entry["value"] = $val;
            $entry["manager_id"] = 0;

            $config_entry[] = $entry;
        }

        $result["grants"] = $grant_entry;
        $result["config"] = $config_entry;
        */




        echo json_export($result);
    }
    //======== module_configuration =========
    //ACTION_GET_CONFIG_INFO = "get_config_information" //(--)
    //ACTION_SET_CONFIG_INFO = "set_config_information" //(--)
    //ACTION_ADD_COMPANY_LOGO = "add_company_logo" //(--)
    //ACTION_REMOVE_COMPANY_LOGO = "remove_company_logo" //(--)

}


function uploadFile($remoteFileName, $file)
{
    $ftp_connection = ftp_connect(FTP_HOST_SERVER, 21);
    $statusMessage = "";
    if ($ftp_connection) {
        $login = ftp_login($ftp_connection, FTP_F_HOST_USERNAME, FTP_F_HOST_PASS);
        if ($login) {
            ftp_pasv($ftp_connection, true);
            if (ftp_put($ftp_connection, $remoteFileName, $file, FTP_BINARY)) {
                $statusMessage = "success";
            } else {
                $statusMessage = "Error while uploading";
            }
        } else {
            $statusMessage = "login to ftp server " . FTP_HOST_SERVER . " failed!";
        }
        ftp_close($ftp_connection);
    } else {
        return "connection to ftp server " . FTP_HOST_SERVER . " failed!";
    }

    return $statusMessage;
}


function get_catalog_info($catalog_id,$cornersave){
    $result = array();

    $catalog_query = "select * from " . TABLE_CATALOG . " where catalog_id = '$catalog_id'";
    $catalog_result = $cornersave->query($catalog_query);

    if($catalog_result != null && $catalog_result->is_row_found()){
        if ($row = $catalog_result->fetch_array()){
            $result = array();

            $brand = get_catalog_brand($row["brand_id"],$cornersave);
            $category = get_catalog_category($row["category_id"],$cornersave);
            $unit_label = get_catalog_label($row["unit_label_id"],$cornersave);

            $result["catalog_id"] = $catalog_id;
            $result["product_name"] = $row["name"];
            $result["category_name"] = $category;
            $result["brand"] = $brand;
            $result["unit_value"] = $row["unit_value"];
            $result["unit_label"] = $unit_label;
            $result["image_url"] = IMG_ITEM_ROOT .  $row["file_name"];
            $result["image_name"] = $row["file_name"];
            $result["category_id"] = $row["category_id"];
            $result["brand_id"] = $row["brand_id"];
            $result["unit_label_id"] = $row["unit_label_id"];
            $result["country_code"] = $row["country_code"];
            $result["barcode"] = null;


        }
    }

    return $result;
}

function debugAPIResponse($api,$msg) {

    $time = new DateTime();
    $time->setTimezone(new DateTimeZone("America/Santiago"));
    $time_stamp = "[" . $time->format('d_M_Y_h:i:s') . "]";
    $random = ""; //getRandomNumber(5);


    $fname = "$api-$time_stamp-$random.json";
    $handle = fopen($fname, "a");
    if ($handle == false) {
        return false;
    }

    //fwrite($handle, $msg . " ~ " . $time_stamp . "\n");
    fwrite($handle, $msg);
    fclose($handle);
}


//============================ Deprecated ===================================
function is_category_in_country($category_id, $country_code,$cornersave){
    $sql_query = "select * from " . TABLE_CATALOG . " where category_id = '$category_id' group by country_code";
    $sql_query_result = $cornersave->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        if ($row = $sql_query_result->fetch_array()){
            return ($row["country_code"] == $country_code);
        }
    }

    return false;
}
function generate_category_code($category_name){
    $lowered = strtolower($category_name);
    return str_replace(" ","+",$lowered);
}
//todo : fix
function generate_category_name($category_code){
    $category_name = str_replace("+"," ",$category_code);
    //$category_name = remove_accents($category_name);
    //$category_name = clean($category_name);

    return $category_name;
}
function get_catalog_category($category_id,$cornersave){
    $result = null;

    $catalog_query = "select * from " . TABLE_CATALOG_CATEGORY . " where category_id = '$category_id'";
    $catalog_result = $cornersave->query($catalog_query);

    if($catalog_result != null && $catalog_result->is_row_found()){
        if ($row = $catalog_result->fetch_array()){
            //$result = array();

            $result = $row["name"];

        }
    }

    return $result;
}
function get_catalog_brand($brand_id,$cornersave){
    $result = null;

    $catalog_query = "select * from " . TABLE_CATALOG_BRAND . " where brand_id = '$brand_id'";
    $catalog_result = $cornersave->query($catalog_query);

    if($catalog_result != null && $catalog_result->is_row_found()){
        if ($row = $catalog_result->fetch_array()){
            //$result = array();

            $result = $row["name"];

        }
    }

    return $result;
}
function get_catalog_label($unit_label_id,$cornersave){
    $result = null;

    $catalog_query = "select * from " . TABLE_CATALOG_UNIT . " where unit_label_id = '$unit_label_id'";
    $catalog_result = $cornersave->query($catalog_query);

    if($catalog_result != null && $catalog_result->is_row_found()){
        if ($row = $catalog_result->fetch_array()){
            //$result = array();

            $result = $row["name"];

        }
    }

    return $result;
}
function get_product_quantity($product_id,$cornersave){
    $result = 0;

    $item_query = "select * from " . TABLE_ITEM_QUANTITY . " where item_id = '$product_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null && $item_result->is_row_found()) {
        if ($row = $item_result->fetch_array()) {
            $result = intval($row["quantity"]);
        }
    }

    return $result;
}
//todo : update inventory on quantity change
function update_product_quantity($product_id,$product_qty,$catalog,$cornersave){
    $result = false;

    $item_query = "update " . TABLE_ITEM_QUANTITY . " set quantity = $product_qty where item_id = '$product_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null && $item_result->is_row_affected()) {
        $result = true;
    }

    return $result;
}

function add_product_quantity($product_id,$catalog,$cornersave){
    $result = false;

    //$manager_id = $catalog->getManagerId();
    //$user_id = $catalog->get_userId();

    $sql_query = "insert into " . TABLE_ITEM_QUANTITY . " (item_id, location_id, quantity) values ('$product_id', 1, 0)";
    $sql_query_result = $cornersave->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){
        $result = true;
    }

    return $result;
}
function add_inventory($product_id,$inventory_value,$inventory_log,$catalog,$cornersave){
    $result = false;

    $manager_id = $catalog->getManagerId();
    $user_id = $catalog->get_userId();

    $sql_query = "insert into " . TABLE_INVENTORY . " (trans_items, trans_user, trans_comment, trans_location, trans_inventory, manager_id) values ('$product_id','$user_id','$inventory_log',1,'$inventory_value','$manager_id')";
    $sql_query_result = $cornersave->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){
        $result = true;
    }

    return $result;
}


//todo: in progress
function catalog_is_in_store($catalog_id,Catalog $catalog,$cornersave){
    $in_store = false;

    $manager_id = $catalog->getManagerId();

    $sql_query = "select * from " . TABLE_ITEMS . " where catalog_id = '$catalog_id' and manager_id = '$manager_id'";
    $sql_query_result = $cornersave->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        $in_store = true;
    }

    return $in_store;
}
function catalog_add_to_store($catalog_id,$catalog,$cornersave){
    $result = false;
    $manager_id = $catalog->getManagerId();

    $in_store = catalog_is_in_store($catalog_id,$catalog,$cornersave);

    if ($in_store){
        return false;
    }

    $catalog_item = get_catalog_info($catalog_id,$catalog,$cornersave);

    $name = null;
    $category = null;
    $receiving_quantity = 0;
    $pic_filename = null;
    //$manager_id = null;
    $brand = null;
    $unit_label = null;
    $unit_value = 0;
    $catalog_id = null;

    if ($catalog_item != null){
        $name = $catalog_item["product_name"];
        $category = $catalog_item["category_name"];
        $receiving_quantity = 0;
        $pic_filename = $catalog_item["image_name"];
        //$manager_id = $manager_id;
        $brand = $catalog_item["brand"];
        $unit_label = $catalog_item["unit_label"];
        $unit_value = $catalog_item["unit_value"];
        $catalog_id = $catalog_item["catalog_id"];

        $sql_query = "insert into " . TABLE_ITEMS . " (`name`, category, receiving_quantity, pic_filename, manager_id, brand, unit_label, unit_value, catalog_id) values ('$name', '$category', '$receiving_quantity', '$pic_filename', '$manager_id', '$brand', '$unit_label', '$unit_value', '$catalog_id')";
        $sql_query_result = $cornersave->query($sql_query);
        if($sql_query_result != null && $sql_query_result->is_row_affected()){

            $product_id = $sql_query_result->insert_id();
            add_product_quantity($product_id,$manager_id,$cornersave);
            add_inventory($product_id,0,INVENTORY_LOG_FROM_CATALOG,$catalog,$cornersave);

            $result = true;

        }
    }

    return $result;
}



//todo: fix in app (process null for barcode) (unit value to integer)
function get_product_info($product_id,$cornersave){
    $result = null;

    $result = array();

    $item_query = "select * from " . TABLE_ITEMS . " where item_id = '$product_id'";
    $item_result = $cornersave->query($item_query);

    if($item_result != null && $item_result->is_row_found()){
        if($row = $item_result->fetch_array()){

            $product_id = intval($row["item_id"]);
            $product_qty = get_product_quantity($product_id,$cornersave);


            $result["product_id"] = $product_id;
            $result["product_name"] = $row["name"];
            $result["category_name"] = $row["category"];
            $result["cost_price"] = intval($row["cost_price"]);
            $result["unit_price"] = intval($row["unit_price"]);
            $result["quantity"] = $product_qty;
            $result["brand"] = $row["brand"] == null ? "" : $row["brand"];
            $result["unit_value"] = $row["unit_value"];
            $result["unit_label"] = $row["unit_label"];
            $result["image_url"] = IMG_ITEM_ROOT . $row["pic_filename"];
            $result["image_name"] = $row["pic_filename"];
            $result["catalog_id"] = $row["catalog_id"];
            $result["product_type"] = PRODUCT_TYPE_ITEM; //$row["product_type"];//not used (stock type)
            $result["barcode"] = $row["item_number"] == null ? "" : $row["item_number"];


            $result["stock_type"] = ($row["stock_type"] == 0) ? "stock" : "non_stock";
            $result["supplier_id"] = intval($row["supplier_id"]);
            $result["receiving_quantity"] = intval($row["receiving_quantity"]);
            $result["reorder_level"] = intval($row["reorder_level"]);
            $result["description"] = $row["description"] == null ? "" : $row["description"];
        }
    }



    /*
    $catalog_query = "select * from " . TABLE_CATALOG . " where catalog_id = '$catalog_id'";
    $catalog_result = $cornersave->query($catalog_query);
    if($catalog_result != null && $catalog_result->is_row_found()){
        if ($row = $catalog_result->fetch_array()){
            $result = array();

            $brand = get_catalog_brand($row["brand_id"],$cornersave);
            $category = get_catalog_category($row["category_id"],$cornersave);
            $unit_label = get_catalog_label($row["unit_label_id"],$cornersave);

            $result["catalog_id"] = $catalog_id;
            $result["product_name"] = $row["name"];
            $result["category_name"] = $category;
            $result["brand"] = $brand;
            $result["unit_value"] = $row["unit_value"];
            $result["unit_label"] = $unit_label;
            $result["image_url"] = IMG_ITEM_ROOT .  $row["file_name"];
            $result["image_name"] = $row["file_name"];
            $result["in_store"] = is_catalog_instore($catalog_id,$cornersave);

        }
    }
    */

    return $result;
}


//TODO : API DEBUG : Localizaton (convert localization string to localization value)
function get_localizations(){
    return array(
        'aa-DJ' => 'Afar (Djibouti)',
        'aa-ER' => 'Afar (Eritrea)',
        'aa-ET' => 'Afar (Ethiopia)',
        'af-ZA' => 'Afrikaans (South Africa)',
        'sq-AL' => 'Albanian (Albania)',
        'sq-MK' => 'Albanian (Macedonia)',
        'am-ET' => 'Amharic (Ethiopia)',
        'ar-DZ' => 'Arabic (Algeria)',
        'ar-BH' => 'Arabic (Bahrain)',
        'ar-EG' => 'Arabic (Egypt)',
        'ar-IN' => 'Arabic (India)',
        'ar-IQ' => 'Arabic (Iraq)',
        'ar-JO' => 'Arabic (Jordan)',
        'ar-KW' => 'Arabic (Kuwait)',
        'ar-LB' => 'Arabic (Lebanon)',
        'ar-LY' => 'Arabic (Libya)',
        'ar-MA' => 'Arabic (Morocco)',
        'ar-OM' => 'Arabic (Oman)',
        'ar-QA' => 'Arabic (Qatar)',
        'ar-SA' => 'Arabic (Saudi Arabia)',
        'ar-SD' => 'Arabic (Sudan)',
        'ar-SY' => 'Arabic (Syria)',
        'ar-TN' => 'Arabic (Tunisia)',
        'ar-AE' => 'Arabic (United Arab Emirates)',
        'ar-YE' => 'Arabic (Yemen)',
        'an-ES' => 'Aragonese (Spain)',
        'hy-AM' => 'Armenian (Armenia)',
        'as-IN' => 'Assamese (India)',
        'ast-ES' => 'Asturian (Spain)',
        'az-AZ' => 'Azerbaijani (Azerbaijan)',
        'az-TR' => 'Azerbaijani (Turkey)',
        'eu-FR' => 'Basque (France)',
        'eu-ES' => 'Basque (Spain)',
        'be-BY' => 'Belarusian (Belarus)',
        'bem-ZM' => 'Bemba (Zambia)',
        'bn-BD' => 'Bengali (Bangladesh)',
        'bn-IN' => 'Bengali (India)',
        'ber-DZ' => 'Berber (Algeria)',
        'ber-MA' => 'Berber (Morocco)',
        'byn-ER' => 'Blin (Eritrea)',
        'bs-BA' => 'Bosnian (Bosnia and Herzegovina)',
        'br-FR' => 'Breton (France)',
        'bg-BG' => 'Bulgarian (Bulgaria)',
        'my-MM' => 'Burmese (Myanmar [Burma])',
        'ca-AD' => 'Catalan (Andorra)',
        'ca-FR' => 'Catalan (France)',
        'ca-IT' => 'Catalan (Italy)',
        'ca-ES' => 'Catalan (Spain)',
        'zh-CN' => 'Chinese (China)',
        'zh-HK' => 'Chinese (Hong Kong SAR China)',
        'zh-SG' => 'Chinese (Singapore)',
        'zh_TW' => 'Chinese (Taiwan)',
        'cv_RU' => 'Chuvash (Russia)',
        'kw_GB' => 'Cornish (United Kingdom)',
        'crh_UA' => 'Crimean Turkish (Ukraine)',
        'hr_HR' => 'Croatian (Croatia)',
        'cs_CZ' => 'Czech (Czech Republic)',
        'da_DK' => 'Danish (Denmark)',
        'dv-MV' => 'Divehi (Maldives)',
        'nl-AW' => 'Dutch (Aruba)',
        'nl-BE' => 'Dutch (Belgium)',
        'nl-NL' => 'Dutch (Netherlands)',
        'dz-BT' => 'Dzongkha (Bhutan)',
        'en-AG' => 'English (Antigua and Barbuda)',
        'en-AU' => 'English (Australia)',
        'en-BW' => 'English (Botswana)',
        'en-BB' => 'English (Barbados)',
        'en-CA' => 'English (Canada)',
        'en-DK' => 'English (Denmark)',
        'en-HK' => 'English (Hong Kong SAR China)',
        'en-IN' => 'English (India)',
        'en-IE' => 'English (Ireland)',
        'en-JM' => 'English (Jamaica)',
        'en-NZ' => 'English (New Zealand)',
        'en-NG' => 'English (Nigeria)',
        'en-PH' => 'English (Philippines)',
        'en-SG' => 'English (Singapore)',
        'en-ZA' => 'English (South Africa)',
        'en-TT'	=> 'English (Trinidad and Tobago)',
        'en-GB' => 'English (United Kingdom)',
        'en-US' => 'English (United States)',
        'en-ZM' => 'English (Zambia)',
        'en-ZW' => 'English (Zimbabwe)',
        'eo' => 'Esperanto',
        'et-EE' => 'Estonian (Estonia)',
        'fo-FO' => 'Faroese (Faroe Islands)',
        'fil-PH' => 'Filipino (Philippines)',
        'fi-FI' => 'Finnish (Finland)',
        'fr-BE' => 'French (Belgium)',
        'fr-CA' => 'French (Canada)',
        'fr-FR' => 'French (France)',
        'fr-LU' => 'French (Luxembourg)',
        'fr-CH' => 'French (Switzerland)',
        'fur-IT' => 'Friulian (Italy)',
        'ff-SN' => 'Fulah (Senegal)',
        'gl-ES' => 'Galician (Spain)',
        'lg-UG' => 'Ganda (Uganda)',
        'gez-ER' => 'Geez (Eritrea)',
        'gez-ET' => 'Geez (Ethiopia)',
        'ka-GE' => 'Georgian (Georgia)',
        'de-AT' => 'German (Austria)',
        'de-BE' => 'German (Belgium)',
        'de-DE' => 'German (Germany)',
        'de-LI' => 'German (Liechtenstein)',
        'de-LU' => 'German (Luxembourg)',
        'de-CH' => 'German (Switzerland)',
        'el-CY' => 'Greek (Cyprus)',
        'el-GR' => 'Greek (Greece)',
        'gu-IN' => 'Gujarati (India)',
        'ht-HT' => 'Haitian (Haiti)',
        'ha-NG' => 'Hausa (Nigeria)',
        'iw-IL' => 'Hebrew (Israel)',
        'he-IL' => 'Hebrew (Israel)',
        'hi-IN' => 'Hindi (India)',
        'hu-HU' => 'Hungarian (Hungary)',
        'is-IS' => 'Icelandic (Iceland)',
        'ig-NG' => 'Igbo (Nigeria)',
        'id-ID' => 'Indonesian (Indonesia)',
        'ia' => 'Interlingua',
        'iu-CA' => 'Inuktitut (Canada)',
        'ik-CA' => 'Inupiaq (Canada)',
        'ga-IE' => 'Irish (Ireland)',
        'it-IT' => 'Italian (Italy)',
        'it-CH' => 'Italian (Switzerland)',
        'ja-JP' => 'Japanese (Japan)',
        'kl-GL' => 'Kalaallisut (Greenland)',
        'kn-IN' => 'Kannada (India)',
        'ks-IN' => 'Kashmiri (India)',
        'csb-PL' => 'Kashubian (Poland)',
        'kk-KZ' => 'Kazakh (Kazakhstan)',
        'km-KH' => 'Khmer (Cambodia)',
        'rw-RW' => 'Kinyarwanda (Rwanda)',
        'ky-KG' => 'Kirghiz (Kyrgyzstan)',
        'kok-IN' => 'Konkani (India)',
        'ko-KR' => 'Korean (South Korea)',
        'ku-TR' => 'Kurdish (Turkey)',
        'lo-LA' => 'Lao (Laos)',
        'lv-LV' => 'Latvian (Latvia)',
        'li-BE' => 'Limburgish (Belgium)',
        'li-NL' => 'Limburgish (Netherlands)',
        'lt-LT' => 'Lithuanian (Lithuania)',
        'nds-DE' => 'Low German (Germany)',
        'nds-NL' => 'Low German (Netherlands)',
        'mk-MK' => 'Macedonian (Macedonia)',
        'mai-IN' => 'Maithili (India)',
        'mg-MG' => 'Malagasy (Madagascar)',
        'ms-MY' => 'Malay (Malaysia)',
        'ml-IN' => 'Malayalam (India)',
        'mt-MT' => 'Maltese (Malta)',
        'gv-GB' => 'Manx (United Kingdom)',
        'mi-NZ' => 'Maori (New Zealand)',
        'mr-IN' => 'Marathi (India)',
        'mn-MN' => 'Mongolian (Mongolia)',
        'ne-NP' => 'Nepali (Nepal)',
        'se-NO' => 'Northern Sami (Norway)',
        'nso-ZA' => 'Northern Sotho (South Africa)',
        'nb-NO' => 'Norwegian Bokmål (Norway)',
        'nn-NO' => 'Norwegian Nynorsk (Norway)',
        'oc-FR' => 'Occitan (France)',
        'or-IN' => 'Oriya (India)',
        'om-ET' => 'Oromo (Ethiopia)',
        'om-KE' => 'Oromo (Kenya)',
        'os-RU' => 'Ossetic (Russia)',
        'pap-AN' => 'Papiamento (Netherlands Antilles)',
        'ps-AF' => 'Pashto (Afghanistan)',
        'fa-IR' => 'Persian (Iran)',
        'pl-PL' => 'Polish (Poland)',
        'pt-BR' => 'Portuguese (Brazil)',
        'pt-PT' => 'Portuguese (Portugal)',
        'pa-IN' => 'Punjabi (India)',
        'pa-PK' => 'Punjabi (Pakistan)',
        'ro-RO' => 'Romanian (Romania)',
        'ru-RU' => 'Russian (Russia)',
        'ru-UA' => 'Russian (Ukraine)',
        'sa-IN' => 'Sanskrit (India)',
        'sc-IT' => 'Sardinian (Italy)',
        'gd-GB' => 'Scottish Gaelic (United Kingdom)',
        'sr-ME' => 'Serbian (Montenegro)',
        'sr-RS' => 'Serbian (Serbia)',
        'sid-ET' => 'Sidamo (Ethiopia)',
        'sd-IN' => 'Sindhi (India)',
        'si-LK' => 'Sinhala (Sri Lanka)',
        'sk-SK' => 'Slovak (Slovakia)',
        'sl-SI' => 'Slovenian (Slovenia)',
        'so-DJ' => 'Somali (Djibouti)',
        'so-ET' => 'Somali (Ethiopia)',
        'so-KE' => 'Somali (Kenya)',
        'so-SO' => 'Somali (Somalia)',
        'nr-ZA' => 'South Ndebele (South Africa)',
        'st-ZA' => 'Southern Sotho (South Africa)',
        'es-AR' => 'Spanish (Argentina)',
        'es-BO' => 'Spanish (Bolivia)',
        'es-CL' => 'Spanish (Chile)',
        'es-CO' => 'Spanish (Colombia)',
        'es-CR' => 'Spanish (Costa Rica)',
        'es-DO' => 'Spanish (Dominican Republic)',
        'es-EC' => 'Spanish (Ecuador)',
        'es-SV' => 'Spanish (El Salvador)',
        'es-GT' => 'Spanish (Guatemala)',
        'es-HN' => 'Spanish (Honduras)',
        'es-MX' => 'Spanish (Mexico)',
        'es-NI' => 'Spanish (Nicaragua)',
        'es-PA' => 'Spanish (Panama)',
        'es-PY' => 'Spanish (Paraguay)',
        'es-PE' => 'Spanish (Peru)',
        'es-ES' => 'Spanish (Spain)',
        'es-US' => 'Spanish (United States)',
        'es-UY' => 'Spanish (Uruguay)',
        'es-VE' => 'Spanish (Venezuela)',
        'sw-KE' => 'Swahili (Kenya)',
        'sw-TZ' => 'Swahili (Tanzania)',
        'ss-ZA' => 'Swati (South Africa)',
        'sv-FI' => 'Swedish (Finland)',
        'sv-SE' => 'Swedish (Sweden)',
        'tl-PH' => 'Tagalog (Philippines)',
        'tg-TJ' => 'Tajik (Tajikistan)',
        'ta-IN' => 'Tamil (India)',
        'tt-RU' => 'Tatar (Russia)',
        'te-IN' => 'Telugu (India)',
        'th-TH' => 'Thai (Thailand)',
        'bo-CN' => 'Tibetan (China)',
        'bo-IN' => 'Tibetan (India)',
        'tig-ER' => 'Tigre (Eritrea)',
        'ti-ER' => 'Tigrinya (Eritrea)',
        'ti-ET' => 'Tigrinya (Ethiopia)',
        'ts-ZA' => 'Tsonga (South Africa)',
        'tn-ZA' => 'Tswana (South Africa)',
        'tr-CY' => 'Turkish (Cyprus)',
        'tr-TR' => 'Turkish (Turkey)',
        'tk-TM' => 'Turkmen (Turkmenistan)',
        'ug-CN' => 'Uighur (China)',
        'uk-UA' => 'Ukrainian (Ukraine)',
        'hsb-DE' => 'Upper Sorbian (Germany)',
        'ur-PK' => 'Urdu (Pakistan)',
        'uz-UZ' => 'Uzbek (Uzbekistan)',
        've-ZA' => 'Venda (South Africa)',
        'vi-VN' => 'Vietnamese (Vietnam)',
        'wa-BE' => 'Walloon (Belgium)',
        'cy-GB' => 'Welsh (United Kingdom)',
        'fy-DE' => 'Western Frisian (Germany)',
        'fy-NL' => 'Western Frisian (Netherlands)',
        'wo-SN' => 'Wolof (Senegal)',
        'xh-ZA' => 'Xhosa (South Africa)',
        'yi-US' => 'Yiddish (United States)',
        'yo-NG' => 'Yoruba (Nigeria)',
        'zu-ZA' => 'Zulu (South Africa)'
    );
}
function reverse_localization($string_locale){
    $localization_list = get_localizations();

    foreach ($localization_list as $num_locale => $str_locale) {
        if ($string_locale == $str_locale){
            return $num_locale;
        }
    }
    return null;
}

function locale_converter($number_locale,$value){
    $result = array();

    $formatted_locale = str_replace('_', '-', $number_locale);

    $fmt = new NumberFormatter( $formatted_locale, NumberFormatter::DECIMAL);

    //$separator = $fmt->getSymbol(NumberFormatter::GROUPING_SEPARATOR_SYMBOL);
    //$fmt->setAttribute(NumberFormatter::FRACTION_DIGITS, 2);
    //$fmt->setSymbol(NumberFormatter::GROUPING_SEPARATOR_SYMBOL, "*");


    $result["number_locale"] = str_replace('_', '-', $fmt->getLocale());
    $result["currency_code"] = $fmt->getSymbol(NumberFormatter::INTL_CURRENCY_SYMBOL);
    $result["currency_symbol"] = $fmt->getSymbol(NumberFormatter::CURRENCY_SYMBOL);
    $result["converted_value"] = $fmt->format($value);

    return $result;
}

function getConfigData($language = DEFAULT_LANGUAGE,$language_code = DEFAULT_LOCALE,$store_type = STORE_TYPE_GROCERYSTORE,$country_code = DEFAULT_COUNTRY_CODE){
    $is_discoverable = "1";

    $config = array();
    $config["address"] = "--";
    $config["allow_duplicate_barcodes"] = "0";
    $config["barcode_content"] = "id";
    $config["barcode_first_row"] = "category";
    $config["barcode_font"] = "Arial";
    $config["barcode_font_size"] = "10";
    $config["barcode_formats"] = "[]";
    $config["barcode_generate_if_empty"] = "0";
    $config["barcode_height"] = "50";
    $config["barcode_num_in_row"] = "2";
    $config["barcode_page_cellspacing"] = "20";
    $config["barcode_page_width"] = "100";
    $config["barcode_second_row"] = "item_code";
    $config["barcode_third_row"] = "unit_price";
    //$config["barcode_type"] = "Code39";
    $config["barcode_type"] = "Ean13";
    $config["barcode_width"] = "250";
    $config["cash_decimals"] = "2";
    $config["cash_rounding_code"] = "1";
    $config["category_dropdown"] = "0";
    $config["company"] = "Cornersave Store";
    //$config["company_logo"] = "company_logo.png";
    $config["company_logo"] = "no_store.png";
    $config["country_codes"] = $country_code;
    $config["currency_code"] = "USD";
    $config["currency_decimals"] = "2";
    $config["currency_symbol"] = "$";
    $config["customer_reward_enable"] = "0";
    $config["dateformat"] = "m/d/Y";
    $config["date_or_time_format"] = "";
    $config["default_receivings_discount"] = "0";
    $config["default_receivings_discount_type"] = "0";
    $config["default_register_mode"] = "sale";
    $config["default_sales_discount"] = "0";
    $config["default_sales_discount_type"] = "0";
    $config["default_tax_1_name"] = "";
    $config["default_tax_1_rate"] = "";
    $config["default_tax_2_name"] = "";
    $config["default_tax_2_rate"] = "";
    $config["default_tax_category"] = "";
    $config["default_tax_code"] = "";
    $config["default_tax_jurisdiction"] = "";
    $config["default_tax_rate"] = "8";
    $config["derive_sale_quantity"] = "0";
    $config["dinner_table_enable"] = "0";
    $config["discoverable"] = $is_discoverable;
    $config["email"] = "[changeme@example.com]";
    $config["email_receipt_check_behaviour"] = "last";
    $config["enforce_privacy"] = "";
    $config["fax"] = "";
    $config["financial_year"] = "1";
    $config["gcaptcha_enable"] = "0";
    $config["gcaptcha_secret_key"] = "";
    $config["gcaptcha_site_key"] = "";
    $config["giftcard_number"] = "series";
    $config["image_allowed_types"] = "jpg|gif|png";
    $config["image_max_height"] = "480";
    $config["image_max_size"] = "128";
    $config["image_max_width"] = "640";
    $config["include_hsn"] = "0";
    $config["invoice_default_comments"] = "This is a default comment";
    $config["invoice_email_message"] = "Dear {CU}, In attachment the receipt for sale {ISEQ}";
    $config["invoice_enable"] = "1";
    $config["invoice_type"] = "invoice";
    $config["language"] = $language;
    $config["language_code"] = $language_code;
    $config["last_used_invoice_number"] = "0";
    $config["last_used_quote_number"] = "0";
    $config["last_used_work_order_number"] = "0";
    $config["lines_per_page"] = "25";
    $config["line_sequence"] = "0";
    $config["mailpath"] = "/usr/sbin/sendmail";
    $config["msg_msg"] = "";
    $config["msg_pwd"] = "";
    $config["msg_src"] = "";
    $config["msg_uid"] = "";
    $config["multi_pack_enabled"] = "0";
    $config["notify_horizontal_position"] = "center";
    $config["notify_vertical_position"] = "bottom";
    $config["number_locale"] = "en-US";
    $config["payment_options_order"] = "cashdebitcredit";
    $config["phone"] = "555-555-5555";
    $config["print_bottom_margin"] = "0";
    $config["print_delay_autoreturn"] = "0";
    $config["print_footer"] = "0";
    $config["print_header"] = "0";
    $config["print_left_margin"] = "0";
    $config["print_left_margin"] = "0";
    $config["print_receipt_check_behaviour"] = "last";
    $config["print_right_margin"] = "0";
    $config["print_silently"] = "1";
    $config["print_top_margin"] = "0";
    $config["protocol"] = "mail";
    $config["quantity_decimals"] = "0";
    $config["quote_default_comments"] = "This is a default quote comment";
    $config["receipt_font_size"] = "12";
    $config["receipt_show_company_name"] = "1";
    $config["receipt_show_description"] = "1";
    $config["receipt_show_serialnumber"] = "1";
    $config["receipt_show_taxes"] = "0";
    $config["receipt_show_tax_ind"] = "0";
    $config["receipt_show_total_discount"] = "1";
    $config["receipt_template"] = "receipt_default";
    $config["receiving_calculate_average_price"] = "0";
    $config["recv_invoice_format"] = "{CO}";
    $config["return_policy"] = "Test";
    $config["sales_invoice_format"] = "{CO}";
    $config["sales_quote_format"] = "Q%y{QSEQ:6}";
    $config["smtp_crypto"] = "ssl";
    $config["smtp_host"] = "";
    $config["smtp_pass"] = "";
    $config["smtp_port"] = "465";
    $config["smtp_timeout"] = "5";
    $config["smtp_user"] = "";
    $config["store_type"] = $store_type;
    $config["suggestions_first_column"] = "name";
    $config["suggestions_second_column"] = "";
    $config["suggestions_third_column"] = "";
    $config["tax_decimals"] = "2";
    $config["tax_id"] = "GCT";
    $config["tax_included"] = "0";
    //$config["theme"] = "cerulean";
    $config["theme"] = "lumen";
    $config["thousands_separator"] = "1";
    $config["timeformat"] = "H:i:s";
    $config["timezone"] = "America/New_York";
    $config["use_destination_based_tax"] = "0";
    $config["website"] = "";
    $config["work_order_enable"] = "0";
    $config["work_order_format"] = "W%y{WSEQ:6}";

    return $config;
}

function get_default_modules(){
    $default_modules = array();

    $default_modules["home"] = "both";
    $default_modules["customers"] = "home";
    $default_modules["items"] = "home";

    $default_modules["item_kits"] = "home";
    $default_modules["suppliers"] = "home";
    $default_modules["reports"] = "home";
    $default_modules["receivings"] = "home";
    $default_modules["sales"] = "home";
    $default_modules["giftcards"] = "home";
    $default_modules["messages"] = "home";
    $default_modules["taxes"] = "home";
    //$default_modules["attributes"] = "home";
    $default_modules["expenses"] = "home";
    $default_modules["expenses_categories"] = "home";
    //$default_modules["cashups"] = "home";
    $default_modules["config"] = "home";
    $default_modules["office"] = "home";
    $default_modules["employees"] = "office";
    $default_modules["preorders"] = "home";
    $default_modules["catalog"] = "home";
    //$default_modules["managers"] = "office";


    return $default_modules;
}
function get_default_permissions(){
    $default_permissions = array();

    $default_permissions["items_stock"] = "";
    $default_permissions["reports_categories"] = "";
    $default_permissions["reports_customers"] = "";
    $default_permissions["reports_discounts"] = "";
    $default_permissions["reports_employees"] = "";
    $default_permissions["reports_expenses_categories"] = "";
    $default_permissions["reports_inventory"] = "";
    $default_permissions["reports_items"] = "";
    $default_permissions["reports_payments"] = "";
    $default_permissions["reports_receivings"] = "";
    $default_permissions["reports_sales"] = "";
    $default_permissions["reports_sales_taxes"] = "";
    $default_permissions["reports_suppliers"] = "";
    $default_permissions["reports_taxes"] = "";
    $default_permissions["sales_change_price"] = "";
    $default_permissions["sales_delete"] = "";
    $default_permissions["sales_stock"] = "";
    $default_permissions["receivings_stock"] = "";

    return $default_permissions;
}
function get_disabled_modules(){
    $disabled_modules = array();

    //$disabled_modules["employees"] = "";
    $disabled_modules["attributes"] = "";
    $disabled_modules["managers"] = "";
    $disabled_modules["none"] = "";

    return $disabled_modules;
}
function get_disabled_permissions(){
    $disabled_permissions = array();

    //$disabled_permissions["employees"] = "";
    $disabled_permissions["attributes"] = "";
    $disabled_permissions["cashups"] = "";
    $disabled_permissions["managers"] = "";

    return $disabled_permissions;
}


function get_menu_group(){
    $menu_group = array();

    $menu_group["home"] = "both";
    $menu_group["customers"] = "home";
    $menu_group["items"] = "home";
    $menu_group["item_kits"] = "home";
    $menu_group["suppliers"] = "home";
    $menu_group["reports"] = "home";
    $menu_group["receivings"] = "home";
    $menu_group["sales"] = "home";
    $menu_group["giftcards"] = "home";
    $menu_group["messages"] = "home";
    $menu_group["taxes"] = "home";
    $menu_group["expenses"] = "home";
    $menu_group["expenses_categories"] = "home";
    $menu_group["config"] = "home";
    $menu_group["office"] = "home";
    $menu_group["employees"] = "office";
    $menu_group["preorders"] = "home";
    $menu_group["catalog"] = "home";

    $menu_group["cashups"] = "home";
    $menu_group["attributes"] = "home";
    $menu_group["managers"] = "office";

    $menu_group["items_stock"] = "--";
    $menu_group["receivings_stock"] = "--";
    $menu_group["reports_categories"] = "--";
    $menu_group["reports_customers"] = "--";
    $menu_group["reports_discounts"] = "--";
    $menu_group["reports_employees"] = "--";
    $menu_group["reports_expenses_categories"] = "--";
    $menu_group["reports_inventory"] = "--";
    $menu_group["reports_items"] = "--";
    $menu_group["reports_payments"] = "--";
    $menu_group["reports_receivings"] = "--";
    $menu_group["reports_sales"] = "--";
    $menu_group["reports_sales_taxes"] = "--";
    $menu_group["reports_suppliers"] = "--";
    $menu_group["reports_taxes"] = "--";
    $menu_group["sales_change_price"] = "--";
    $menu_group["sales_delete"] = "--";
    $menu_group["sales_stock"] = "--";

    return $menu_group;
}


function get_all_modules($cornersave){
    $module = array();


    $module_query = "select * from " . TABLE_ALL_MODULES . " order by sort asc";
    $module_result = $cornersave->query($module_query);

    if($module_result != null && $module_result->is_row_found()){
        while($row = $module_result->fetch_array()){
            $module[] = $row["module_id"];
        }
    }

    return $module;
}
function get_all_permissions($cornersave){
    $permission = array();

    $permission_query = "select * from " . TABLE_ALL_PERMISSIONS;
    $permission_result = $cornersave->query($permission_query);

    if($permission_result != null && $permission_result->is_row_found()){
        while($row = $permission_result->fetch_array()){
            $permission[] = $row["permission_id"];
        }
    }

    return $permission;
}
function get_user_permissions($manager_id,$cornersave){
    $permission = array();

    $permission_query = "select * from " . TABLE_USER_PERMISSIONS . " where person_id = " . $manager_id;
    $permission_result = $cornersave->query($permission_query);

    if($permission_result != null && $permission_result->is_row_found()){
        while($row = $permission_result->fetch_array()){
            $permission[] = $row["permission_id"];
        }
    }

    return $permission;
}


/*
 * Author : Kadian Salmon
 * Date : Mar 1, 2021
 * Purpose : Main class for all operations relating to merchant
 */

function __get_template__($cornersave){
    $module = array();


    $sql_query = "select * from " . TABLE_ALL_MODULES . " order by sort asc";
    $sql_query_result = $cornersave->query($sql_query);

    if($sql_query_result != null && $sql_query_result->is_row_found()){
        while($row = $sql_query_result->fetch_array()){
            $module[] = $row["module_id"];
        }
    }
}
function __insert_template__($cornersave){
    $module = array();


    $sql_query = "insert into " . "_TABLE_NAME_" . " (column_1,column_2,column_3,column_4) values ('','','','')";
    $sql_query_result = $cornersave->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}
function __update_template__($cornersave){
    $module = array();

    $sql_query = "update " . "_TABLE_NAME_" . " set `column_1` = '' where `column_1` = 0";
    $sql_query_result = $cornersave->query($sql_query);
    if($sql_query_result != null && $sql_query_result->is_row_affected()){

    }
}

function get_update_query(string $table,array $set, string $where = null): string
{

    $query = "update " . $table . " set";
    foreach ($set as $key => $value) {
        $query .= " $key = '" . $value . "',";
    }

    $query = rtrim($query, ", ");

    if ($where != null){
        $query .= " where " . $where;
    }

    return $query;
}
function get_insert_query($table, array $values): string
{

    $query = "insert into " . $table . " (";
    foreach ($values as $key => $value) {
        $query .= $key . ",";
    }
    $query = rtrim($query, ", ");
    $query .= ") values (";

    /*foreach ($values as $value) {
        $query .= " (";
        foreach ($value as $val) {
            $query .= "'" . $val . "',";
        }
        $query = rtrim($query, ", ");

        $query .= "),";
    }*/
    foreach ($values as $key => $value) {
        $query .= "'" . $value . "',";
    }
    $query = rtrim($query, ", ");

    $query .= "),";
    $query = rtrim($query, ", ");

    return $query;
}

function getErrorStatus($error_msg){
    $result = array();
    $error = array();
    $error["name"] = ERROR_NAME_OP_FAILED;
    $error["message"] = $error_msg;
    $result["status"] = STATUS_ERROR;
    $result["error"] = $error;

    return $result;
}
function getOKStatus(){
    $result = array();
    $result["status"] = STATUS_OK;

    return $result;
}

/*$ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);
        $ = text_clean($data[""]);*/

class Catalog {

    private $db_connector; //db connector
    private $isLoggedin = false;//is the merchant logged in
    private $isActive = false;//is this merchant's account still active
    private $hasCurrentLocation = false;//


    //current details
    private $host_info = null;
    private $currentLat = null;
    private $currentLon = null;
    private $currentLocation = null;

    //merchant details
    private $userId = null;
    private $loginToken = null;
    private $email = null;
    private $password = null;
    private $userName = null;
    private $firstName = null;
    private $lastName = null;
    private $gender = null;
    private $locationCountry = null;
    private $locationState = null;
    private $locationCity = null;
    private $registrationDate = null;
    private $phoneNumber = null;
    private $userType = null;
    private $locationAddress_1 = null;
    private $locationAddress_2 = null;
    private $userRef = null;
    private $managerId = null;
    private $storeId = null;


    function __construct(Database $db_connector) {
        $this->db_connector = $db_connector;

        $this->host_info = new HostInfo($db_connector);

        $this->currentLocation = new LocationPoint(null,null);

    }

    public function get_db_connector() {
        return $this->db_connector;
    }
    public function isLoggedin() {
        return $this->isLoggedin;
    }
    public function isActive() {
        return $this->isActive;
    }
    public function get_userId() {
        return $this->userId;
    }
    public function get_loginToken() {
        return $this->loginToken;
    }
    public function get_email() {
        return $this->email;
    }
    public function get_encrytedPassword() {
        return $this->password;
    }
    public function get_userName() {
        return $this->userName;
    }
    public function get_firstName() {
        return $this->firstName;
    }
    public function get_lastName() {
        return $this->lastName;
    }
    public function get_gender() {
        return $this->gender;
    }
    public function get_locationCountry() {
        return $this->locationCountry;
    }
    public function get_locationState() {
        return $this->locationState;
    }
    public function get_locationCity() {
        return $this->locationCity;
    }
    public function get_registrationDate() {
        return $this->registrationDate;
    }
    public function get_phoneNumber() {
        return $this->phoneNumber;
    }
    public function getCurrentLocation(){
        return $this->currentLocation;
    }
    public function getUserType()
    {
        return $this->userType;
    }
    public function getUserRef()
    {
        return $this->userRef;
    }
    public function getLocationAddress1()
    {
        return $this->locationAddress_1;
    }
    public function getLocationAddress2()
    {
        return $this->locationAddress_2;
    }
    public function getManagerId()
    {
        return $this->managerId;
    }
    public function getStoreId()
    {
        return $this->storeId;
    }
    public function getHostInfo()
    {
        return $this->host_info;
    }

    public function setCurrentLocation($lat,$lon){
        $currentLocation = new LocationPoint(null,null);

        if (!empty($lat) && !empty($lon)){
            $currentLocation = new LocationPoint($lat,$lon);
        }

        $this->currentLocation = $currentLocation;

    }
    public function set_db_connector($db_connector) {
        $this->db_connector = $db_connector;
    }
    public function set_isLoggedin($isLoggedin) {
        $this->isLoggedin = $isLoggedin;
    }
    public function set_isActive($isActive) {
        $this->isActive = $isActive;
    }
    public function set_userId($userId) {
        $this->userId = $userId;
    }
    public function set_loginToken($loginToken) {
        $this->loginToken = $loginToken;
    }
    public function set_email($email) {
        $this->email = $email;
    }
    public function set_encrytedPassword($password) {
        $this->password = $password;
    }
    public function set_userName($userName) {
        $this->userName = $userName;
    }
    public function set_firstName($firstName) {
        $this->firstName = $firstName;
    }
    public function set_lastName($lastName) {
        $this->lastName = $lastName;
    }
    public function set_gender($gender) {
        $this->gender = $gender;
    }
    public function set_locationCountry($locationCountry) {
        $this->locationCountry = $locationCountry;
    }
    public function set_locationState($locationState) {
        $this->locationState = $locationState;
    }
    public function set_locationCity($locationCity) {
        $this->locationCity = $locationCity;
    }
    public function set_registrationDate($registrationDate) {
        $this->registrationDate = $registrationDate;
    }
    public function set_phoneNumber($phoneNumber) {
        $this->phoneNumber = $phoneNumber;
    }
    public function setUserType($userType)
    {
        $this->userType = $userType;
    }
    public function setUserRef($userRef)
    {
        $this->userRef = $userRef;
    }
    public function setLocationAddress1($locationAddress_1)
    {
        $this->locationAddress_1 = $locationAddress_1;
    }
    public function setLocationAddress2($locationAddress_2)
    {
        $this->locationAddress_2 = $locationAddress_2;
    }
    public function setManagerId($managerId)
    {
        $this->managerId = $managerId;
    }
    public function setStoreId($storeId)
    {
        $this->storeId = $storeId;
    }

    public function getErrorStatus($error_msg){
        $result = array();
        $error = array();

        $error["name"] = ERROR_NAME_OP_FAILED;
        $error["message"] = $error_msg;

        $result["status"] = STATUS_ERROR;
        $result["error"] = $error;

        return $result;
    }
    public function getOKStatus(){
        $result = array();
        $result["status"] = STATUS_OK;

        return $result;
    }

    public function signout($user_id,$login_token) {
        $user_type = USER_TYPE_RESEARCHER;
        $account_state = STATE_ACTIVE;
        $login_state = LOGIN_STATE_INVALID;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token'";
        $update_query = "update " . TABLE_LOGIN . " set login_state = '$login_state' where user_id = '$user_id' and token_id = '$login_token'";

        $result = $this->getErrorStatus(ERROR_MSG_INVALID_LOGIN);


        if($this->db_connector != null){
            $login_result = $this->db_connector->query($login_check_query);
            if($login_result != null && $login_result->is_row_found()){
                //if we found the record
                $update_result = $this->db_connector->query($update_query);
                if($update_result != null && $update_result->is_row_affected()){
                    $result = $this->getOKStatus();
                    $this->isLoggedin = false;
                }

            }
        }

        return $result;

    }
    public function login($username,$password) {

        $provided_password = encryptPassword($password);
        $provided_username = strtolower($username);
        //$user_type = USER_TYPE_RESEARCHER;
        $not_deleted = 0;
        //$verified_by_admin = VERIFIED;
        //$verified_email = VERIFIED;

        $result = $this->getErrorStatus(ERROR_MSG_INVALID_CRED);


        if($this->db_connector != null){
            $login_query = "select * from " . TABLE_EMPLOYEE . " where lower(username) = '$provided_username' and password = '$provided_password' and deleted = '$not_deleted' and user_type in ('". USER_TYPE_MANAGER ."','". USER_TYPE_ADMIN ."')";

            $login_result = $this->db_connector->query($login_query);

            if($login_result != null && $login_result->is_row_found()){

                if($row_data = $login_result->fetch_array()){
                    $actual_uname = $row_data["username"];
                    $actual_pass = $row_data["password"];
                    $user_id = $row_data["person_id"];
                    $user_type = $row_data["user_type"];

                    if(($actual_uname == $provided_username) && ($actual_pass == $provided_password)){

                        $login_token = generate_token();
                        $login_time = getCurrentTime();
                        $login_state = LOGIN_STATE_VALID;

                        $details_query = "insert into " . TABLE_LOGIN . " (token_id,login_time,login_state,user_id) values ('$login_token','$login_time','$login_state','$user_id')";
                        $details_result = $this->db_connector->query($details_query);

                        if($details_result != null && $details_result->is_row_affected()){
                            //$this->isLoggedin = true;

                            $result = $this->getOKStatus();
                            $result["user_id"] = $user_id;
                            $result["user_type"] = $user_type;
                            $result["login_token"] = $login_token;


                            return $result;
                        }

                    }

                }
            }


        }

        return $result;

    }
    public function verifyLogin($user_id,$login_token) {
        $not_deleted = 0;
        $login_state = LOGIN_STATE_VALID;

        $login_check_query = "select * from " . TABLE_LOGIN . " where user_id = '$user_id' and token_id = '$login_token' and login_state = '$login_state'";
        $user_check_query = "select * from " . TABLE_EMPLOYEE . " where person_id = '$user_id' and user_type in ('". USER_TYPE_MANAGER ."','". USER_TYPE_ADMIN ."') and deleted = '$not_deleted'";

        $result = $this->getErrorStatus(ERROR_MSG_INVALID_TOKEN);


        if($this->db_connector != null){
            $login_result = $this->db_connector->query($login_check_query);
            if($login_result != null && $login_result->is_row_found()){
                $user_result = $this->db_connector->query($user_check_query);
                if($user_result != null && $user_result->is_row_found()){
                    $result = $this->getOKStatus();

                    /*$version_data = getAPP_VERSION_DATA();

                    if (hasAgent()){
                        $result[MOBILE_VERSION_NAME] = $version_data[MOBILE_VERSION_NAME];
                        $result[MOBILE_VERSION_CODE] = $version_data[MOBILE_VERSION_CODE];
                        $result[MOBILE_VERSION_COMMENT] = $version_data[MOBILE_VERSION_COMMENT];
                        $result[MOBILE_VERSION_PRIORITY] = $version_data[MOBILE_VERSION_PRIORITY];
                    }*/

                    $this->isLoggedin = true;
                    $this->isActive = true;
                }
                else{
                    $result = $this->getErrorStatus(ERROR_MSG_USER_SUSPENDED);
                }

            }
        }

        return $result;

    }
    public function initializeMerchant($user_id,$login_token="") {

        //$this->host_info = new HostInfo($this->db_connector);//get all the host info... like [ip_address|country_name|country_code|area_code|currency]

        if($user_id != null){
            $this->userId = $user_id;
        }
        else{
            return false;
        }
        if($login_token != null){
            $this->loginToken = $login_token;
        }


        $user_check_query = "select * from " . TABLE_PEOPLE . " where person_id = '$user_id'";
        $employee_check_query = "select * from " . TABLE_EMPLOYEE . " where person_id = '$user_id'";

        if($this->db_connector != null){
            $user_result = $this->db_connector->query($user_check_query);
            $employee_result = $this->db_connector->query($employee_check_query);

            if(($user_result != null && $user_result->is_row_found()) && ($employee_result != null && $employee_result->is_row_found())){
                $row = $user_result->fetch_array();
                $row_emp = $employee_result->fetch_array();

                if($row != null && $row_emp != null){
                    $this->email = strtolower($row["email"]);
                    $this->password = $row_emp["password"];
                    $this->userType = $row_emp["user_type"];
                    $this->userRef = $row["user_ref_id"];
                    $this->locationAddress_1 = $row["address_1"];
                    $this->locationAddress_2 = $row["address_2"];
                    $this->phoneNumber = $row["phone_number"];
                    $this->userName = strtolower($row_emp["username"]);
                    $this->firstName = strtolower($row["first_name"]);
                    $this->lastName = strtolower($row["last_name"]);

                    $this->managerId = $row_emp["manager_id"];
                    if ($this->userType == USER_TYPE_MANAGER){
                        $this->managerId = $row["person_id"];
                    }

                    if ($this->userType == USER_TYPE_ADMIN){
                        $this->managerId = 0;
                    }



                    if ($row["gender"] == GENDER_MALE_CODE){
                        $this->gender = GENDER_MALE;
                    }
                    elseif($row["gender"] == GENDER_FEMALE_CODE){
                        $this->gender = GENDER_FEMALE;
                    }
                    elseif($row["gender"] == GENDER_NOT_TO_SAY_CODE){
                        $this->gender = GENDER_NOT_TO_SAY;
                    }


                    $this->registrationDate = $row["created_on"];

                    $this->locationCountry = $row["country"];
                    $this->locationCity = $row["city"];
                    $this->locationState = $row["state"];

                    $account_deleted = $row_emp["deleted"];

                    if($account_deleted == 0){
                        $this->isActive = true;
                    }
                    return true;

                }

            }
        }

        return false;


    }
    public function getStoreData(){
        $result = array();

        $manager_id = $this->managerId;
        $user_type = USER_TYPE_MANAGER;

        $manager_query = "select * from " . TABLE_PEOPLE . " where person_id = '$manager_id' and user_type = '$user_type'";
        $manager_result = $this->db_connector->query($manager_query);

        if ($manager_result != null && $manager_result->is_row_found()){

            if ($row = $manager_result->fetch_array())
            {
                $result["phone_number"] = $row["phone_number"];
                $result["store_id"] = $row["user_ref_id"];
                $result["manager_id"] = $row["person_id"];

                $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
                $store_result = $this->db_connector->query($store_query);
                if ($store_result != null && $store_result->is_row_found()){
                    while ($config = $store_result->fetch_array()){

                        if($config["key"] == "company"){
                            $result["name"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "company_logo"){
                            $result["logo"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "address"){
                            $result["address"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "currency_code"){
                            $result["currency_code"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "currency_symbol"){
                            $result["currency_symbol"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "fax"){
                            $result["fax"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "currency_decimals"){
                            $result["currency_decimals"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "number_locale"){
                            $result["number_locale"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "discoverable"){
                            $result["discoverable"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "thousands_separator"){
                            $result["thousands_separator"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "country_codes"){
                            $result["country_codes"] = text_clean($config["value"]);
                            //break;
                        }

                        if($config["key"] == "email"){
                            $result["email"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "financial_year"){
                            $result["financial_year"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "timezone"){
                            $result["timezone"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "phone"){
                            $result["phone"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "store_type"){
                            $result["store_type"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "return_policy"){
                            $result["return_policy"] = text_clean($config["value"]);
                            //break;
                        }
                        if($config["key"] == "coordinates"){
                            $result["coordinates"] = $config["value"];
                            //break;
                        }
                    }
                }

            }
        }

        return $result;
    }


}



function getModulesFromPermissions($permission_array){
    $modules = array();

    foreach ($permission_array as $permission) {
        if ($permission == "config")
            $modules[] = "module_configuration";

        if ($permission == "customers")
            $modules[] = "module_customer";

        if ($permission == "employees")
            $modules[] = "module_team";

        if ($permission == "expenses")
            $modules[] = "module_expense";

        if ($permission == "giftcards")
            $modules[] = "module_giftcard";

        if ($permission == "item_kits")
            $modules[] = "module_promotion";

        if ($permission == "items")
            $modules[] = "module_item";

        if ($permission == "messages")
            $modules[] = "module_message";

        if ($permission == "preorders")
            $modules[] = "module_order";

        if ($permission == "receivings")
            $modules[] = "module_receiving";

        if ($permission == "reports")
            $modules[] = "module_report";

        if ($permission == "sales")
            $modules[] = "module_sale";

        if ($permission == "suppliers")
            $modules[] = "module_supplier";

        if ($permission == "supplier_market")
            $modules[] = "module_supplier_market";

        if ($permission == "catalog")
            $modules[] = "module_catalog";

    }

    return $modules;
}
function encryptPassword($password){//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}
function generateUserReferenceId() {
    return getRandomNumber(10);
}
function generate_token() {
    return getRandomNumber(4) . "" . getRandomNumber(4);
}
function generate_unique_id($unique_prefix) {
    return $unique_prefix . getRandomString(7) . getRandomNumber(7) . getRandomString(7) . getRandomNumber(2) . getRandomString(3) ;
}
function get_unit_id($unit_label, $cornersave){
    $query = "select * from catalog_unit_list where BINARY name = '$unit_label'";
    $query_result = $cornersave->query($query);

    $unit_id = null;

    if ($query_result != null && $query_result->is_row_found()){
        if ($row = $query_result->fetch_array()) {

            $unit_id = $row['unit_label_id'];

        }
    }
    else {
        $unit_id = generate_unique_id("unit_");

        $add_val = get_insert_query("catalog_unit_list",[
            "unit_label_id" => $unit_id,
            "update_time" => getCurrentTime(),
            "name" => $unit_label
        ]);
        $add_val_result = $cornersave->query($add_val);

        if($add_val_result != null && $add_val_result->is_row_affected()){

        }
        else{
            $unit_id = null;
        }
    }

    return $unit_id;
}
function get_brand_id($brand, $cornersave){
    $query = "select * from catalog_brand_list where name = '$brand'";
    $query_result = $cornersave->query($query);

    $brand_id = null;

    if ($query_result != null && $query_result->is_row_found()){
        if ($row = $query_result->fetch_array()) {

            $brand_id = $row['brand_id'];

        }
    }
    else {
        $brand_id = generate_unique_id("brand_");

        $add_val = get_insert_query("catalog_brand_list",[
            "brand_id" => $brand_id,
            "update_time" => getCurrentTime(),
            "name" => $brand
        ]);
        $add_val_result = $cornersave->query($add_val);

        if($add_val_result != null && $add_val_result->is_row_affected()){

        }
        else{
            $brand_id = null;
        }
    }

    return $brand_id;
}
function get_category_id($category, $cornersave){
    $query = "select * from catalog_category_list where name = '$category'";
    $query_result = $cornersave->query($query);

    $category_id = null;

    if ($query_result != null && $query_result->is_row_found()){
        if ($row = $query_result->fetch_array()) {

            $category_id = $row['category_id'];

        }
    }
    else {
        $category_id = generate_unique_id("category_");

        $add_val = get_insert_query("catalog_category_list",[
            "category_id" => $category_id,
            "update_time" => getCurrentTime(),
            "name" => $category
        ]);
        $add_val_result = $cornersave->query($add_val);

        if($add_val_result != null && $add_val_result->is_row_affected()){

        }
        else{
            $category_id = null;
        }
    }

    return $category_id;
}


//return a formatted currency string based on the locale
function displayCurrency($number, $decimals = NULL, $locale = DEFAULT_LOCALE)
{
    $thousands_separator = true;

    //ignore empty strings and return
    if(empty($number))
    {
        return $number;
    }

    if($decimals == NULL)
    {
        $decimals = 0;
    }


    $fmt = new NumberFormatter($locale, NumberFormatter::DECIMAL);

    $fmt->setAttribute(NumberFormatter::FRACTION_DIGITS, intval($decimals));

    if(!$thousands_separator)
    {
        //remove thousand separator
        //$fmt->setAttribute(NumberFormatter::GROUPING_SEPARATOR_SYMBOL, '');
    }

    try
    {
        //return $fmt->parse($number);
        return $fmt->format($number);

    }
    catch(Exception $e)
    {
        return FALSE;
    }
}

