<?php

/**
* @Author : Kadian Salmon
* Purpose : This contains generally used functions
*
* @param clean : This is used to clean user provided information
* @param stringCase : Sets the case of the string accordingly
* @param getCurrentTime : get current UTC time
* @param isTimeExpired : determine if the passed arg timestamp is beyond current time
* @param makeExpiryTime : generate the new time based on the seconds passed
* @param getRandomNumber : generate random sequence of numbers
* @param getRandomString : generate random sequence of alphanumeric characters
* @param isEmailValid : returns true if the email is valid
*
*
* @param isEmailValid : returns true if the email is valid
* @param isEmailValid : returns true if the email is valid
* @param isEmailValid : returns true if the email is valid
*
*
*
*/



/**
 * @method json_export
 * Date : Feb 22, 2021
 * @param $value : array to be processed
 * @return string : the json string
 *
 * @uses : This processes the json output applying (JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES)
 *
 */
function json_export($value) {
    //HTML tags to avoid code injection
    //convert all the special characters to text equivalent and remove

    return json_encode($value,JSON_UNESCAPED_UNICODE|JSON_UNESCAPED_SLASHES);
}

/**
 * @method text_import
 * Date : Feb 21, 2021
 * @param value : string to be processed
 * @param preserve : whether or not html elements must be preserved
 * @param allowed_tags : if elements are not to be preserved then strips those elements leaving the allowed tag in place
 *
 * @return string
 *
 * @uses : This trims and formats the user provided data (that may have different char encoding [spanish char]) for entry into the sql database
 *
 */
function text_import($value = "", $preserve = "", $allowed_tags = "") {
    //HTML tags to avoid code injection
    //convert all the special characters to text equivalent and remove

    $decoded_text = trim($value);


    //$decoded_text = mysqli_r($decoded_text);
    $decoded_text = addslashes($decoded_text);
    $decoded_text = utf8_decode($decoded_text);
    //$decoded_text = htmlentities($decoded_text);


    return $decoded_text;
}

/**
 * @method text_clean
 * Date : Feb 21, 2021
 * @param value : string to be processed
 * @param preserve : whether or not html elements must be preserved
 * @param allowed_tags : if elements are not to be preserved then strips those elements leaving the allowed tag in place
 *
 * @return string
 *
 * @uses : This trims and formats the user provided data (with no specific encoding) for entry into the sql database
 *
 */
function text_clean($value = "", $preserve = "", $allowed_tags = "") {
    //HTML tags to avoid code injection
    //convert all the special characters to text equivalent and remove

    $decoded_text = trim($value);


    //$decoded_text = mysqli_r($decoded_text);
    $decoded_text = addslashes($decoded_text);
    $decoded_text = strip_tags($decoded_text);
    //$decoded_text = utf8_decode($decoded_text);
    //$decoded_text = htmlentities($decoded_text);


    return $decoded_text;
}
/**
 * @method clean_reverse
 * Date : Feb 21, 2021
 * @param value : string to be processed
 * @param preserve : whether or not html elements must be preserved
 * @param allowed_tags : if elements are not to be preserved then strips those elements leaving the allowed tag in place
 *
 * @return string
 *
 * @uses : This undoes the effect of text_clean for taking the data from the database
 *
 */
function clean_reverse($value = "", $preserve = "", $allowed_tags = "") {
    //HTML tags to avoid code injection
    //convert all the special characters to text equivalent and remove

    $decoded_text = trim($value);


    //$decoded_text = mysqli_r($decoded_text);
    //$decoded_text = addslashes($decoded_text);
    //$decoded_text = strip_tags($decoded_text);
    //$decoded_text = utf8_decode($decoded_text);
    //$decoded_text = htmlentities($decoded_text);

    $decoded_text = stripcslashes($decoded_text);



    return $decoded_text;
}

/**
 * @method text_export
 * Date : Feb 21, 2021
 * @param value : string to be processed
 * @param preserve : whether or not html elements must be preserved
 * @param allowed_tags : if elements are not to be preserved then strips those elements leaving the allowed tag in place
 *
 * @return string
 *
 * @uses : This trims and formats the user provided data for export text from sql database
 *
 */
function text_export($value = "", $preserve = "", $allowed_tags = "") {
    //HTML tags to avoid code injection
    //convert all the special characters to text equivalent and remove

    //$decoded_text = mb_convert_encoding($value, 'UTF-8', 'HTML-ENTITIES');
    $decoded_text = mb_convert_encoding($value, 'UTF-8', 'HTML-ENTITIES');
    //$decoded_text = mb_convert_encoding($value, 'UTF-8', 'ISO-8859-1');
    //$decoded_text = utf8_encode($value);
    //$decoded_text = html_entity_decode($value);
    $decoded_text = strip_tags($decoded_text);
    $decoded_text = stripcslashes($decoded_text);
    //$decoded_text = htmlspecialchars($decoded_text);

    return $decoded_text;
}



/**
* @method clean
* Date : Sep 18, 2019
* @param value : string to be processed
* @param preserve : whether or not html elements must be preserved
* @param allowed_tags : if elements are not to be preserved then strips those elements leaving the allowed tag in place
*
* @return string
*
*@uses : This trims and formats the user provided data to prevent sql attacks
*
*/
function clean($value = "", $preserve = "", $allowed_tags = "") {
  //HTML tags to avoid code injection
  //convert all the special characters to text equivalent and remove

    //$value = utf8_decode($value);
    //$value = utf8_encode($value);
    //$value = html_entity_decode($value);
  //html_entity_decode($string);
    //convert special chars like [& % /] to text like [&amp.. etc] to avoid formating and html injections

    $value2 = htmlspecialchars($value);
    if (empty($preserve)) {
    //remove html tags
        $value2 = strip_tags($value2, $allowed_tags); 
    }

  //escape strings for text protection against sql injection \' \"
    $value2 = addslashes($value2); 
  //remove all spaces before and after the text
    $value2 = trim($value2); 

    return $value2;
}

function unClean($value = "", $preserve = "", $allowed_tags = "") {
    //HTML tags to avoid code injection
    //convert all the special characters to text equivalent and remove

    //html_entity_decode($string);
    //convert special chars like [&amp.. etc]  to text like [& % /] to avoid formating and html injections
    $value2 = html_entity_decode($value);


    //escape strings for text protection against sql injection \' \"
    //$value2 = stripcslashes($value2);
    //remove all spaces before and after the text
    //$value2 = trim($value2);

    return $value2;
}

/**
* @method stringCase
* Date : Sep 18, 2019
* @uses : Sets the case of the string accordingly
*
* @param $string : string to be processed
* @param $mode : integer to determine the resulting case
*
* @return $result : the processed value
*
*/

define("STRING_CASE_LOWER",0);
define("STRING_CASE_UPPER",1);
define("STRING_CASE_CAP_EACH",2);
define("STRING_CASE_CAP_FIRST",3);

function stringCase($string, $mode = STRING_CASE_LOWER) {



  //0 : return all lower case
  //1 : return all upper case
  //2 : return string with the first letter of EACH word capitalized
  //3 : return string with the first letter capitalized

    $result = null;

    if($string == null){
        $result = null;
    }

    $string = strtolower(trim($string));

    switch ($mode) {
        case 0:
            $result = strtolower($string);
            break;

        case 1:
            $result = strtoupper($string);
            break;

        case 2:
            $result = ucwords($string, " ");
            break;

        case 3:
            $result = ucfirst($string);
            break;

    }

    return $result;
}

/**
* @method getCurrentTime
* Date : Sep 18, 2019
* @uses : This get the current time for the UTC timezone
*
* @param $format : default is 'Y-m-d h:i:s'
* @return string : timestamp
*
*/
function getCurrentTime($format = ""){

    $current_timezone = strtolower(date_default_timezone_get());

    if($current_timezone != null){
        if($current_timezone != "utc"){
            date_default_timezone_set("UTC");
        }
    }


    $timeObj = new DateTime();
    $timeObj->setTimezone(new DateTimeZone("UTC"));


    if($format != ""){
        $final_format = $format;//eg : 'Y-m-d h:i:s a'
    }
    else{
        $final_format = 'Y-m-d H:i:s';
    }

    $currentTime = $timeObj->format($final_format);

    return $currentTime;
}

/**
* @method isTimeExpired
* 999 111118888 2222000011998
* @uses : determine if the passed arg timestamp is beyond current time
*
* @param expired_timestamp : the time to check
* @param current_timestamp : default is the current timestamp.. so dont worry
* @return bool
*
*/
function isTimeExpired($expired_timestamp, $curr_timestamp = "") {

    $current = new DateTime();

    if ($curr_timestamp != "") {
        $current_timestamp = $curr_timestamp;
    } else {
        $current_timestamp = $current->format("Y-m-d h:i:s");
    }


    if (strtotime($current_timestamp) >= strtotime($expired_timestamp)) {
        return true;
    }

    return false;
}

/**
* @method makeExpiryTime
* 999 111118888 2222000011998
* @uses : generate the new time based on the seconds passed
*
* @param expire_after_in_sec : current time + these seconds
* @param current_timestamp : default is the current timestamp.. so dont worry ; but you can set expiry relative to this time
* @return string
*
*/
function makeExpiryTime($expire_after_in_sec, $curr_timestamp = "") {
    $current = new DateTime();

    if ($curr_timestamp != "") {
        $current_timestamp = $curr_timestamp;
    } else {
        $current_timestamp = $current->format("Y-m-d H:i:s");
    }

    $new_time = strtotime($current_timestamp) + $expire_after_in_sec;
    $new_stamp = date('Y-m-d H:i:s', $new_time);


    return $new_stamp;
}

/**
* @internal functions for random method - not to be used directly
*/
function true_random($min, $max) {

    $range = $max - $min;
    if ($range < 1) {
        //does not have a range to choose from so just return minimum val
        return $min;
    }
    $log = ceil(log($range, 2));
    $bytes = (int) ($log / 8) + 1; //represents the length in bytes
    $bits = (int) $log + 1; //represents the length in bits
    //shift all the lower bits to 1
    $converter = (int) (1 << $bits) - 1;

    do {
        $random = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
        $random = $random & $converter; //remover useless bits
    } while ($random > $range);
    return $min + $random;
}

/**
* @method getRandomNumber
* Date : Mar 30, 2020
* @param length : length of string
* @return string
*
*@uses : random sequence of numbers
*
*/
function getRandomNumber($length = 5) {
    $characters = '012345678985764792019585746';
    $charactersLength = strlen($characters);
    $randomNumber = '';

    for ($i = 0; $i < $length; $i++) {

        $random_digit = $characters[true_random(0, $charactersLength - 1)] . "";

        while (($i == 0) && ($random_digit == "0")){
            $random_digit = $characters[true_random(0, $charactersLength - 1)] . "";
        }

        $randomNumber .= $random_digit;

    }
    return $randomNumber;
}

/**
* @method getRandomString
* Date : Mar 30, 2020
* @param length : length of string
* @return string
*
*@uses : random sequence of alphanumeric characters
*
*/
function getRandomString($length = 5) {
    $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $charactersLength = strlen($characters);
    $randomString = '';

    for ($i = 0; $i < $length; $i++) {
        $randomString .= $characters[true_random(0, $charactersLength - 1)] . "";
    }

    return $randomString;
}

/**
* @method isEmailValid
* Date : Mar 30, 2020
* @uses : returns true if the email is valid
*
* @param string : length of string
* @return bool
*
*/
function isEmailValid($string) {

    if (filter_var($string, FILTER_VALIDATE_EMAIL)) {
        return true;
    }
    else {
        return false;
    }
}

/**
 * @method remove_accents
 * Date : Mar 30, 2020
 * @uses : returns the string after replacing all the accented chars with english base letters
 *
 * @param $text : string
 * @return string
 *
 */
function remove_accents( $text) {
    $trans = array(
        'À'=>'A','Á'=>'A','Â'=>'A','Ã'=>'A','Ä'=>'A','Å'=>'A','Ç'=>'C','È'=>'E',
        'É'=>'E','Ê'=>'E','Ë'=>'E','Ì'=>'I','Í'=>'I','Î'=>'I','Ï'=>'I','Ñ'=>'N',
        'Ò'=>'O','Ó'=>'O','Ô'=>'O','Õ'=>'O','Ö'=>'O','Ø'=>'O','Ù'=>'U','Ú'=>'U',
        'Û'=>'U','Ü'=>'U','Ý'=>'Y','à'=>'a','á'=>'a','â'=>'a','ã'=>'a','ä'=>'a',
        'å'=>'a','ç'=>'c','è'=>'e','é'=>'e','ê'=>'e','ë'=>'e','ì'=>'i','í'=>'i',
        'î'=>'i','ï'=>'i','ñ'=>'n','ò'=>'o','ó'=>'o','ô'=>'o','õ'=>'o','ö'=>'o',
        'ø'=>'o','ù'=>'u','ú'=>'u','û'=>'u','ü'=>'u','ý'=>'y','ÿ'=>'y','Ā'=>'A',
        'ā'=>'a','Ă'=>'A','ă'=>'a','Ą'=>'A','ą'=>'a','Ć'=>'C','ć'=>'c','Ĉ'=>'C',
        'ĉ'=>'c','Ċ'=>'C','ċ'=>'c','Č'=>'C','č'=>'c','Ď'=>'D','ď'=>'d','Đ'=>'D',
        'đ'=>'d','Ē'=>'E','ē'=>'e','Ĕ'=>'E','ĕ'=>'e','Ė'=>'E','ė'=>'e','Ę'=>'E',
        'ę'=>'e','Ě'=>'E','ě'=>'e','Ĝ'=>'G','ĝ'=>'g','Ğ'=>'G','ğ'=>'g','Ġ'=>'G',
        'ġ'=>'g','Ģ'=>'G','ģ'=>'g','Ĥ'=>'H','ĥ'=>'h','Ħ'=>'H','ħ'=>'h','Ĩ'=>'I',
        'ĩ'=>'i','Ī'=>'I','ī'=>'i','Ĭ'=>'I','ĭ'=>'i','Į'=>'I','į'=>'i','İ'=>'I',
        'ı'=>'i','Ĵ'=>'J','ĵ'=>'j','Ķ'=>'K','ķ'=>'k','Ĺ'=>'L','ĺ'=>'l','Ļ'=>'L',
        'ļ'=>'l','Ľ'=>'L','ľ'=>'l','Ŀ'=>'L','ŀ'=>'l','Ł'=>'L','ł'=>'l','Ń'=>'N',
        'ń'=>'n','Ņ'=>'N','ņ'=>'n','Ň'=>'N','ň'=>'n','ŉ'=>'n','Ō'=>'O','ō'=>'o',
        'Ŏ'=>'O','ŏ'=>'o','Ő'=>'O','ő'=>'o','Ŕ'=>'R','ŕ'=>'r','Ŗ'=>'R','ŗ'=>'r',
        'Ř'=>'R','ř'=>'r','Ś'=>'S','ś'=>'s','Ŝ'=>'S','ŝ'=>'s','Ş'=>'S','ş'=>'s',
        'Š'=>'S','š'=>'s','Ţ'=>'T','ţ'=>'t','Ť'=>'T','ť'=>'t','Ŧ'=>'T','ŧ'=>'t',
        'Ũ'=>'U','ũ'=>'u','Ū'=>'U','ū'=>'u','Ŭ'=>'U','ŭ'=>'u','Ů'=>'U','ů'=>'u',
        'Ű'=>'U','ű'=>'u','Ų'=>'U','ų'=>'u','Ŵ'=>'W','ŵ'=>'w','Ŷ'=>'Y','ŷ'=>'y',
        'Ÿ'=>'Y','Ź'=>'Z','ź'=>'z','Ż'=>'Z','ż'=>'z','Ž'=>'Z','ž'=>'z','ƀ'=>'b',
        'Ɓ'=>'B','Ƃ'=>'B','ƃ'=>'b','Ƈ'=>'C','ƈ'=>'c','Ɗ'=>'D','Ƌ'=>'D','ƌ'=>'d',
        'Ƒ'=>'F','ƒ'=>'f','Ɠ'=>'G','Ɨ'=>'I','Ƙ'=>'K','ƙ'=>'k','ƚ'=>'l','Ɲ'=>'N',
        'ƞ'=>'n','Ɵ'=>'O','Ơ'=>'O','ơ'=>'o','Ƥ'=>'P','ƥ'=>'p','ƫ'=>'t','Ƭ'=>'T',
        'ƭ'=>'t','Ʈ'=>'T','Ư'=>'U','ư'=>'u','Ʋ'=>'V','Ƴ'=>'Y','ƴ'=>'y','Ƶ'=>'Z',
        'ƶ'=>'z','ǅ'=>'D','ǈ'=>'L','ǋ'=>'N','Ǎ'=>'A','ǎ'=>'a','Ǐ'=>'I','ǐ'=>'i',
        'Ǒ'=>'O','ǒ'=>'o','Ǔ'=>'U','ǔ'=>'u','Ǖ'=>'U','ǖ'=>'u','Ǘ'=>'U','ǘ'=>'u',
        'Ǚ'=>'U','ǚ'=>'u','Ǜ'=>'U','ǜ'=>'u','Ǟ'=>'A','ǟ'=>'a','Ǡ'=>'A','ǡ'=>'a',
        'Ǥ'=>'G','ǥ'=>'g','Ǧ'=>'G','ǧ'=>'g','Ǩ'=>'K','ǩ'=>'k','Ǫ'=>'O','ǫ'=>'o',
        'Ǭ'=>'O','ǭ'=>'o','ǰ'=>'j','ǲ'=>'D','Ǵ'=>'G','ǵ'=>'g','Ǹ'=>'N','ǹ'=>'n',
        'Ǻ'=>'A','ǻ'=>'a','Ǿ'=>'O','ǿ'=>'o','Ȁ'=>'A','ȁ'=>'a','Ȃ'=>'A','ȃ'=>'a',
        'Ȅ'=>'E','ȅ'=>'e','Ȇ'=>'E','ȇ'=>'e','Ȉ'=>'I','ȉ'=>'i','Ȋ'=>'I','ȋ'=>'i',
        'Ȍ'=>'O','ȍ'=>'o','Ȏ'=>'O','ȏ'=>'o','Ȑ'=>'R','ȑ'=>'r','Ȓ'=>'R','ȓ'=>'r',
        'Ȕ'=>'U','ȕ'=>'u','Ȗ'=>'U','ȗ'=>'u','Ș'=>'S','ș'=>'s','Ț'=>'T','ț'=>'t',
        'Ȟ'=>'H','ȟ'=>'h','Ƞ'=>'N','ȡ'=>'d','Ȥ'=>'Z','ȥ'=>'z','Ȧ'=>'A','ȧ'=>'a',
        'Ȩ'=>'E','ȩ'=>'e','Ȫ'=>'O','ȫ'=>'o','Ȭ'=>'O','ȭ'=>'o','Ȯ'=>'O','ȯ'=>'o',
        'Ȱ'=>'O','ȱ'=>'o','Ȳ'=>'Y','ȳ'=>'y','ȴ'=>'l','ȵ'=>'n','ȶ'=>'t','ȷ'=>'j',
        'Ⱥ'=>'A','Ȼ'=>'C','ȼ'=>'c','Ƚ'=>'L','Ⱦ'=>'T','ȿ'=>'s','ɀ'=>'z','Ƀ'=>'B',
        'Ʉ'=>'U','Ɇ'=>'E','ɇ'=>'e','Ɉ'=>'J','ɉ'=>'j','ɋ'=>'q','Ɍ'=>'R','ɍ'=>'r',
        'Ɏ'=>'Y','ɏ'=>'y','ɓ'=>'b','ɕ'=>'c','ɖ'=>'d','ɗ'=>'d','ɟ'=>'j','ɠ'=>'g',
        'ɦ'=>'h','ɨ'=>'i','ɫ'=>'l','ɬ'=>'l','ɭ'=>'l','ɱ'=>'m','ɲ'=>'n','ɳ'=>'n',
        'ɵ'=>'o','ɼ'=>'r','ɽ'=>'r','ɾ'=>'r','ʂ'=>'s','ʄ'=>'j','ʈ'=>'t','ʉ'=>'u',
        'ʋ'=>'v','ʐ'=>'z','ʑ'=>'z','ʝ'=>'j','ʠ'=>'q','ͣ'=>'a','ͤ'=>'e','ͥ'=>'i',
        'ͦ'=>'o','ͧ'=>'u','ͨ'=>'c','ͩ'=>'d','ͪ'=>'h','ͫ'=>'m','ͬ'=>'r','ͭ'=>'t',
        'ͮ'=>'v','ͯ'=>'x','ᵢ'=>'i','ᵣ'=>'r','ᵤ'=>'u','ᵥ'=>'v','ᵬ'=>'b','ᵭ'=>'d',
        'ᵮ'=>'f','ᵯ'=>'m','ᵰ'=>'n','ᵱ'=>'p','ᵲ'=>'r','ᵳ'=>'r','ᵴ'=>'s','ᵵ'=>'t',
        'ᵶ'=>'z','ᵻ'=>'i','ᵽ'=>'p','ᵾ'=>'u','ᶀ'=>'b','ᶁ'=>'d','ᶂ'=>'f','ᶃ'=>'g',
        'ᶄ'=>'k','ᶅ'=>'l','ᶆ'=>'m','ᶇ'=>'n','ᶈ'=>'p','ᶉ'=>'r','ᶊ'=>'s','ᶌ'=>'v',
        'ᶍ'=>'x','ᶎ'=>'z','ᶏ'=>'a','ᶑ'=>'d','ᶒ'=>'e','ᶖ'=>'i','ᶙ'=>'u','᷊'=>'r',
        'ᷗ'=>'c','ᷚ'=>'g','ᷜ'=>'k','ᷝ'=>'l','ᷠ'=>'n','ᷣ'=>'r','ᷤ'=>'s','ᷦ'=>'z',
        'Ḁ'=>'A','ḁ'=>'a','Ḃ'=>'B','ḃ'=>'b','Ḅ'=>'B','ḅ'=>'b','Ḇ'=>'B','ḇ'=>'b',
        'Ḉ'=>'C','ḉ'=>'c','Ḋ'=>'D','ḋ'=>'d','Ḍ'=>'D','ḍ'=>'d','Ḏ'=>'D','ḏ'=>'d',
        'Ḑ'=>'D','ḑ'=>'d','Ḓ'=>'D','ḓ'=>'d','Ḕ'=>'E','ḕ'=>'e','Ḗ'=>'E','ḗ'=>'e',
        'Ḙ'=>'E','ḙ'=>'e','Ḛ'=>'E','ḛ'=>'e','Ḝ'=>'E','ḝ'=>'e','Ḟ'=>'F','ḟ'=>'f',
        'Ḡ'=>'G','ḡ'=>'g','Ḣ'=>'H','ḣ'=>'h','Ḥ'=>'H','ḥ'=>'h','Ḧ'=>'H','ḧ'=>'h',
        'Ḩ'=>'H','ḩ'=>'h','Ḫ'=>'H','ḫ'=>'h','Ḭ'=>'I','ḭ'=>'i','Ḯ'=>'I','ḯ'=>'i',
        'Ḱ'=>'K','ḱ'=>'k','Ḳ'=>'K','ḳ'=>'k','Ḵ'=>'K','ḵ'=>'k','Ḷ'=>'L','ḷ'=>'l',
        'Ḹ'=>'L','ḹ'=>'l','Ḻ'=>'L','ḻ'=>'l','Ḽ'=>'L','ḽ'=>'l','Ḿ'=>'M','ḿ'=>'m',
        'Ṁ'=>'M','ṁ'=>'m','Ṃ'=>'M','ṃ'=>'m','Ṅ'=>'N','ṅ'=>'n','Ṇ'=>'N','ṇ'=>'n',
        'Ṉ'=>'N','ṉ'=>'n','Ṋ'=>'N','ṋ'=>'n','Ṍ'=>'O','ṍ'=>'o','Ṏ'=>'O','ṏ'=>'o',
        'Ṑ'=>'O','ṑ'=>'o','Ṓ'=>'O','ṓ'=>'o','Ṕ'=>'P','ṕ'=>'p','Ṗ'=>'P','ṗ'=>'p',
        'Ṙ'=>'R','ṙ'=>'r','Ṛ'=>'R','ṛ'=>'r','Ṝ'=>'R','ṝ'=>'r','Ṟ'=>'R','ṟ'=>'r',
        'Ṡ'=>'S','ṡ'=>'s','Ṣ'=>'S','ṣ'=>'s','Ṥ'=>'S','ṥ'=>'s','Ṧ'=>'S','ṧ'=>'s',
        'Ṩ'=>'S','ṩ'=>'s','Ṫ'=>'T','ṫ'=>'t','Ṭ'=>'T','ṭ'=>'t','Ṯ'=>'T','ṯ'=>'t',
        'Ṱ'=>'T','ṱ'=>'t','Ṳ'=>'U','ṳ'=>'u','Ṵ'=>'U','ṵ'=>'u','Ṷ'=>'U','ṷ'=>'u',
        'Ṹ'=>'U','ṹ'=>'u','Ṻ'=>'U','ṻ'=>'u','Ṽ'=>'V','ṽ'=>'v','Ṿ'=>'V','ṿ'=>'v',
        'Ẁ'=>'W','ẁ'=>'w','Ẃ'=>'W','ẃ'=>'w','Ẅ'=>'W','ẅ'=>'w','Ẇ'=>'W','ẇ'=>'w',
        'Ẉ'=>'W','ẉ'=>'w','Ẋ'=>'X','ẋ'=>'x','Ẍ'=>'X','ẍ'=>'x','Ẏ'=>'Y','ẏ'=>'y',
        'Ẑ'=>'Z','ẑ'=>'z','Ẓ'=>'Z','ẓ'=>'z','Ẕ'=>'Z','ẕ'=>'z','ẖ'=>'h','ẗ'=>'t',
        'ẘ'=>'w','ẙ'=>'y','ẚ'=>'a','Ạ'=>'A','ạ'=>'a','Ả'=>'A','ả'=>'a','Ấ'=>'A',
        'ấ'=>'a','Ầ'=>'A','ầ'=>'a','Ẩ'=>'A','ẩ'=>'a','Ẫ'=>'A','ẫ'=>'a','Ậ'=>'A',
        'ậ'=>'a','Ắ'=>'A','ắ'=>'a','Ằ'=>'A','ằ'=>'a','Ẳ'=>'A','ẳ'=>'a','Ẵ'=>'A',
        'ẵ'=>'a','Ặ'=>'A','ặ'=>'a','Ẹ'=>'E','ẹ'=>'e','Ẻ'=>'E','ẻ'=>'e','Ẽ'=>'E',
        'ẽ'=>'e','Ế'=>'E','ế'=>'e','Ề'=>'E','ề'=>'e','Ể'=>'E','ể'=>'e','Ễ'=>'E',
        'ễ'=>'e','Ệ'=>'E','ệ'=>'e','Ỉ'=>'I','ỉ'=>'i','Ị'=>'I','ị'=>'i','Ọ'=>'O',
        'ọ'=>'o','Ỏ'=>'O','ỏ'=>'o','Ố'=>'O','ố'=>'o','Ồ'=>'O','ồ'=>'o','Ổ'=>'O',
        'ổ'=>'o','Ỗ'=>'O','ỗ'=>'o','Ộ'=>'O','ộ'=>'o','Ớ'=>'O','ớ'=>'o','Ờ'=>'O',
        'ờ'=>'o','Ở'=>'O','ở'=>'o','Ỡ'=>'O','ỡ'=>'o','Ợ'=>'O','ợ'=>'o','Ụ'=>'U',
        'ụ'=>'u','Ủ'=>'U','ủ'=>'u','Ứ'=>'U','ứ'=>'u','Ừ'=>'U','ừ'=>'u','Ử'=>'U',
        'ử'=>'u','Ữ'=>'U','ữ'=>'u','Ự'=>'U','ự'=>'u','Ỳ'=>'Y','ỳ'=>'y','Ỵ'=>'Y',
        'ỵ'=>'y','Ỷ'=>'Y','ỷ'=>'y','Ỹ'=>'Y','ỹ'=>'y','Ỿ'=>'Y','ỿ'=>'y','ⁱ'=>'i',
        'ⁿ'=>'n','ₐ'=>'a','ₑ'=>'e','ₒ'=>'o','ₓ'=>'x','⒜'=>'a','⒝'=>'b','⒞'=>'c',
        '⒟'=>'d','⒠'=>'e','⒡'=>'f','⒢'=>'g','⒣'=>'h','⒤'=>'i','⒥'=>'j','⒦'=>'k',
        '⒧'=>'l','⒨'=>'m','⒩'=>'n','⒪'=>'o','⒫'=>'p','⒬'=>'q','⒭'=>'r','⒮'=>'s',
        '⒯'=>'t','⒰'=>'u','⒱'=>'v','⒲'=>'w','⒳'=>'x','⒴'=>'y','⒵'=>'z','Ⓐ'=>'A',
        'Ⓑ'=>'B','Ⓒ'=>'C','Ⓓ'=>'D','Ⓔ'=>'E','Ⓕ'=>'F','Ⓖ'=>'G','Ⓗ'=>'H','Ⓘ'=>'I',
        'Ⓙ'=>'J','Ⓚ'=>'K','Ⓛ'=>'L','Ⓜ'=>'M','Ⓝ'=>'N','Ⓞ'=>'O','Ⓟ'=>'P','Ⓠ'=>'Q',
        'Ⓡ'=>'R','Ⓢ'=>'S','Ⓣ'=>'T','Ⓤ'=>'U','Ⓥ'=>'V','Ⓦ'=>'W','Ⓧ'=>'X','Ⓨ'=>'Y',
        'Ⓩ'=>'Z','ⓐ'=>'a','ⓑ'=>'b','ⓒ'=>'c','ⓓ'=>'d','ⓔ'=>'e','ⓕ'=>'f','ⓖ'=>'g',
        'ⓗ'=>'h','ⓘ'=>'i','ⓙ'=>'j','ⓚ'=>'k','ⓛ'=>'l','ⓜ'=>'m','ⓝ'=>'n','ⓞ'=>'o',
        'ⓟ'=>'p','ⓠ'=>'q','ⓡ'=>'r','ⓢ'=>'s','ⓣ'=>'t','ⓤ'=>'u','ⓥ'=>'v','ⓦ'=>'w',
        'ⓧ'=>'x','ⓨ'=>'y','ⓩ'=>'z','Ⱡ'=>'L','ⱡ'=>'l','Ɫ'=>'L','Ᵽ'=>'P','Ɽ'=>'R',
        'ⱥ'=>'a','ⱦ'=>'t','Ⱨ'=>'H','ⱨ'=>'h','Ⱪ'=>'K','ⱪ'=>'k','Ⱬ'=>'Z','ⱬ'=>'z',
        'Ɱ'=>'M','ⱱ'=>'v','Ⱳ'=>'W','ⱳ'=>'w','ⱴ'=>'v','ⱸ'=>'e','ⱺ'=>'o','ⱼ'=>'j',
        'Ꝁ'=>'K','ꝁ'=>'k','Ꝃ'=>'K','ꝃ'=>'k','Ꝅ'=>'K','ꝅ'=>'k','Ꝉ'=>'L','ꝉ'=>'l',
        'Ꝋ'=>'O','ꝋ'=>'o','Ꝍ'=>'O','ꝍ'=>'o','Ꝑ'=>'P','ꝑ'=>'p','Ꝓ'=>'P','ꝓ'=>'p',
        'Ꝕ'=>'P','ꝕ'=>'p','Ꝗ'=>'Q','ꝗ'=>'q','Ꝙ'=>'Q','ꝙ'=>'q','Ꝛ'=>'R','ꝛ'=>'r',
        'Ꝟ'=>'V','ꝟ'=>'v','Ａ'=>'A','Ｂ'=>'B','Ｃ'=>'C','Ｄ'=>'D','Ｅ'=>'E','Ｆ'=>'F',
        'Ｇ'=>'G','Ｈ'=>'H','Ｉ'=>'I','Ｊ'=>'J','Ｋ'=>'K','Ｌ'=>'L','Ｍ'=>'M','Ｎ'=>'N',
        'Ｏ'=>'O','Ｐ'=>'P','Ｑ'=>'Q','Ｒ'=>'R','Ｓ'=>'S','Ｔ'=>'T','Ｕ'=>'U','Ｖ'=>'V',
        'Ｗ'=>'W','Ｘ'=>'X','Ｙ'=>'Y','Ｚ'=>'Z','ａ'=>'a','ｂ'=>'b','ｃ'=>'c','ｄ'=>'d',
        'ｅ'=>'e','ｆ'=>'f','ｇ'=>'g','ｈ'=>'h','ｉ'=>'i','ｊ'=>'j','ｋ'=>'k','ｌ'=>'l',
        'ｍ'=>'m','ｎ'=>'n','ｏ'=>'o','ｐ'=>'p','ｑ'=>'q','ｒ'=>'r','ｓ'=>'s','ｔ'=>'t',
        'ｕ'=>'u','ｖ'=>'v','ｗ'=>'w','ｘ'=>'x','ｙ'=>'y','ｚ'=>'z',);
    return strtr( $text, $trans);
}

/**
 * @method localToUTC
 * Date : Feb 20, 2021
 * @uses : returns the string timestamp after converting javascript + offset
 * @uses : time to UTC time
 *
 * @param $date_time : local time in the form of Y-m-d H:i:s (if javascript local time then strip center 'T')
 * @return string : utc time in the form of Y-m-d H:i:s
 *
 */
//$start_date = "2021-02-20T15:00:00";//chile
//$local_date = date('Y-m-d H:i:s', strtotime($start_date));
function localToUTC($date_time,$offset_min){
    $final_date = "";
    $offset = intval($offset_min);

    if ($offset < 0){
        $offset = -$offset;
        $dateTime = strtotime("$date_time - $offset minute");
    }
    else{
        $dateTime = strtotime("$date_time + $offset minute");
    }


    $final_date = date('Y-m-d H:i:s', $dateTime);


    return $final_date;
}

/**
 * @method localTimezoneToUTC
 * Date : Feb 20, 2021
 * @uses : returns the string timestamp after converting javascript + timezone
 * @uses : time to UTC time
 *
 * @param $date_time : local time in the form of Y-m-d H:i:s (if javascript local time then strip center 'T')
 * @return string : utc time in the form of Y-m-d H:i:s
 *
 */
function localTimezoneToUTC($date_time,$timezone){


    //America/St Kitts -> America/St_Kitts
    //America/Puerto Rico -> America/Puerto_Rico
    $timezone = str_replace(" ","_",$timezone);

    $date = new DateTime($date_time,new DateTimeZone($timezone));
    $date->setTimezone(new DateTimeZone("UTC"));

    return $date->format("Y-m-d H:i:s");
}

//location calc here