<?php

header("Access-Control-Allow-Origin: *");
header('Content-Type: application/json');

// database tables
define("TABLE_CONFIG", "ospos_app_config");
define("TABLE_PEOPLE", "ospos_people");
define("TABLE_EMPLOYEE", "ospos_employees");
define("TABLE_CUSTOMER", "ospos_customers");
define("TABLE_ITEMS", "ospos_items");
define("TABLE_ITEM_QUANTITY", "ospos_item_quantities");
define("TABLE_SALES", "ospos_sales");
define("TABLE_SALES_ITEMS", "ospos_sales_items");
define("TABLE_KITS", "ospos_item_kits");
define("TABLE_GIFT_CARDS", "ospos_giftcards");
define("TABLE_KITS_ITEMS", "ospos_item_kit_items");

/*
 * KIT DISCOUNT TYPE
 */
define('KIT_TYPE_PERCENT', 0);
define('KIT_TYPE_FIXED', 1);

/*
 * PRODUCT TYPE
 */
define('PRODUCT_TYPE_ITEM', "item");
define('PRODUCT_TYPE_PROMOTION', "promotion");
define('PRODUCT_TYPE_GIFT', "gift");

/*
 * USER-TYPES
 */
define('USER_TYPE_ADMIN', "type_admin");
define('USER_TYPE_MANAGER', "type_manage");
define('USER_TYPE_EMPLOYEE', "type_emp");
define('USER_TYPE_CUSTOMER', "type_custom");

/*
 | Sale Related Constants.
 */
define('ORDER_COMPLETED', 0);
define('ORDER_SUSPENDED', 1);// or pre-ordered
define('ORDER_CANCELED', 2);

//cornersave database
define("MAIN_DB_USERNAME", "initia19_cornersave");
define("MAIN_DB_PASSWORD", "cornersave");
define("MAIN_DB_NAME", "initia19_cornersave");

define("PASSWORD_SALT","kfhfgsrakshsfhdtewpjskhfh");

define("DEFAULT_LOCALE","en-US");


include ("../../includes/headers/classes-v1.php");
include ("../../includes/headers/miscellaneous-v1.php"); //additional functions
//include ("../includes/headers/strings.php"); //has all the constants needed

$cornersave = new Database(MAIN_DB_USERNAME, MAIN_DB_PASSWORD, MAIN_DB_NAME);

//https://api.queritel.com/api/general/cornersave/cornercommand.php?interface=any&action=get_store_list&param_json={"":""}


//$item_query = "delete from " . TABLE_ITEMS . " where manager_id = '6'";
//$item_result = $cornersave->query($item_query);
/*if($item_result != null && $item_result->is_row_affected()){
    echo "deleted";
}
else{
    echo "not deleted";
}*/

$DEMO = false;

if (isset($_REQUEST["interface"])){
    $interface = $_REQUEST["interface"];
    $action = $_REQUEST["action"];
    $param_json = $_REQUEST["param_json"];

    if ($interface == "--"){

        //** IN PROGRESS **
        if ($action == '')
        {

            $data = json_decode($param_json, true);
            $list = $data["email_list"];
            $user_id = clean($data["user_id"]);
            $net_role = NETWORK_ROLE_COMMANDER;

            $result = array();

            $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_role = '$net_role'";
            $network_rel_result = $paperweight->query($network_rel_query);

            $result["status"] = "FAILED";

            if ($network_rel_result != null)
            {

                $row = $network_rel_result->fetch_array();

                if ($row != null)
                {
                    $network_id = $row["network_id"];
                    $network_detail = get_network_detail($network_id,$paperweight);

                    if (count($list) > 0) {
                        for ($i = 0; $i < count($list); $i++) {
                            $email = $list[$i];
                            $org_name = $network_detail["organization_name"];
                            $token = getRandomString(13);

                            $generated_link = "https://api.queritel.com/api/general/mailing/email/submission?ops=invitation&op=" . $network_id . "&token=" . $token;

                            $subject = "Queritel Invitation";
                            $body = createEmailInvitationBody($generated_link,$org_name);

                            sendMail($email,$subject,$body);

                        }

                        $result["status"] = "OK";
                    }
                }
            }


            echo json_encode($result);

        }

    }

    if ($interface == "any"){

        //** IN PROGRESS **
        if ($action == 'get_customer_detail')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $customer_id = clean($data["customer_id"]);

            $customer_info = getCustomerInfo($customer_id,$cornersave);

            if (isset($customer_info)){
                $result["status"] = "OK";
                $result["result"] = $customer_info;
            }

            echo json_encode($result);

        }

        if ($action == 'get_store_detail')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $store_id = clean($data["store_id"]);

            $store_info = getStoreInfo($store_id,$cornersave);

            if (isset($store_info)){
                $result["status"] = "OK";
                $result["result"] = $store_info;
            }

            echo json_encode($result);

        }

        if ($action == 'get_product_list')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $store_id = clean($data["store_id"]);

            if (empty($store_id)){
                echo json_encode($result);

                return;
            }

            $store_info = getStoreInfo($store_id,$cornersave);
            //$manager_id = $store_info["manager_id"];

            //todo remove demo
            /*if ($manager_id == "6"){
                $DEMO = true;
            }*/

            if (!empty($store_info)){
                $product_list = getItemList($store_info,$cornersave);

                if (isset($product_list)){
                    $result["status"] = "OK";
                    $result["result"] = $product_list;
                }
            }

            //echo json_encode($result);
            echo json_encode($result);

        }

        if ($action == 'get_category_product_list')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $store_id = clean($data["store_id"]);
            $category_id = $data["category_id"];

            $search_id = clean($data["search_id"]);
            if ($search_id == "" ){
                $search_id = null;
            }

            if (empty($store_id)){
                echo json_encode($result);

                return;
            }

            $store_info = getStoreInfo($store_id,$cornersave);
            //$manager_id = $store_info["manager_id"];

            //todo remove demo
            /*if ($manager_id == "6"){
                $DEMO = true;
            }*/

            if (!empty($store_info)){
                $product_list = getCategoryItemList($category_id,$store_info,$cornersave,$search_id);

                if (isset($product_list)){
                    $result["status"] = "OK";
                    $result["result"] = $product_list;
                }
            }


            //echo json_encode($result);
            echo json_encode($result);

        }

        if ($action == 'get_search_product_list')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $store_id = clean($data["store_id"]);
            $search_id = clean($data["search_id"]);

            if (empty($store_id)){
                echo json_encode($result);

                return;
            }

            $store_info = getStoreInfo($store_id,$cornersave);
            //$manager_id = $store_info["manager_id"];

            //todo remove demo
            /*if ($manager_id == "6"){
                $DEMO = true;
            }*/

            if (!empty($store_info)){
                $product_list = getSearchedItemList($search_id,$store_info,$cornersave);

                if (isset($product_list)){
                    $result["status"] = "OK";
                    $result["result"] = $product_list;
                }
            }



            //echo json_encode($result);
            echo json_encode($result);

        }

        if ($action == 'get_product_detail')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $store_id = clean($data["store_id"]);
            $product_id = clean($data["product_id"]);

            $store_info = getStoreInfo($store_id,$cornersave);
            //$manager_id = $store_info["manager_id"];

            //if ($manager_id != null){

            //}

            $product_detail = getItemInfo($product_id,$cornersave,$store_info);

            if (isset($product_detail)){
                $result["status"] = "OK";
                $result["result"] = $product_detail;
            }


            //echo json_encode($result);
            echo json_encode($result);

        }

        if ($action == 'get_store_list')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $country = clean($data["country"]);
            //$country = "CL";

            //$store_info = getStoreInfo($store_id,$cornersave);
            //$manager_id = $store_info["manager_id"];

            if ($country == "--"){
                $country = null;
            }

            $store_list = getStoreList($cornersave,$country);

            if (isset($store_list)){
                $result["status"] = "OK";
                $result["result"] = $store_list;
            }

            //echo json_encode($result);
            echo json_encode($result);

        }

        if ($action == 'get_category_list') {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $store_id = clean($data["store_id"]);
            //$category = clean($data["category"]);

            if (empty($store_id)){
                echo json_encode($result);

                return;
            }

            $store_info = getStoreInfo($store_id,$cornersave);
            $manager_id = $store_info["manager_id"];

            //todo remove demo
            /*if ($manager_id == "6"){
                $DEMO = true;
            }*/

            if ($manager_id != null){
                $category_list = getCategoryList($manager_id,$cornersave);

                if (isset($category_list)){
                    $result["status"] = "OK";
                    $result["result"] = $category_list;
                }
            }



            echo json_encode($result);

        }

        if ($action == 'login_customer')
        {
            //$data = json_decode($param_json, true);
            $data = $_REQUEST;
            //$data[""] = $_REQUEST[""];

            $result = array();
            $result["status"] = "ERROR";

            $email = stringCase(clean($data["username"]));
            $password = clean($data["password"]);

            $customer_id = loginCustomer($email,$password,$cornersave);

            if ($customer_id != null){
                $info = getCustomerInfo($customer_id,$cornersave);

                $result["status"] = "OK";
                $result["user_ref_id"] = $info["user_ref_id"];
                $result["user_id"] = $customer_id;
            }

            //echo json_encode($result);
            echo json_encode($result);
        }

        if ($action == 'register_customer')
        {
            $result = array();
            $result["status"] = STATUS_SIGNUP_FAILED;

            //$data = json_decode($param_json, true);
            $data = $_REQUEST;
            //$data[""] = $_REQUEST[""];


            //echo json_encode($result);
            //return;

            $first_name = stringCase(clean($data["firstname"]));
            $last_name = stringCase(clean($data["lastname"]));
            $email = stringCase(clean($data["username"]));
            $password = encryptPassword(clean($data["password"]));
            $address = stringCase(clean($data["address"]));
            $state = clean($data["state"]);
            $country = clean($data["country"]);
            $number = clean($data["number"]);
            $gender = (clean($data["gender"]) == "male") ? 1 : 0;

            $user_ref_id = generateUserReferenceId();
            $update_time = getCurrentTime();
            $user_type = USER_TYPE_CUSTOMER;
            $address2 = null;
            $city = null;
            $zip = null;
            $is_verified = 1;



            /*$city_id = clean($data["user_city_id"]);
            $zip = clean($data["user_zip"]);
            $county = clean($data["user_county"]);
            $parish = clean($data["user_parish"]);
            $is_experienced = clean($data["user_is_experienced"]);
            //$more_cv_data = clean($data["user_more_cv_data"]);
            $user_assistance_company = "";//clean($data["user_is_experienced"]);
            $user_deg_id = 0;//clean($data["user_is_experienced"]);

            $user_type = USER_TYPE_RESEARCHER;
            $user_active = STATE_ACTIVE;
            $user_is_approved = VERIFIED;
            $email_is_verified = VERIFIED;//todo : remove auto email verification
            $user_regdate = getCurrentTime();
            $user_ref_id = generateUserReferenceId();

            //psuedo profile data
            $user_test_passed = VERIFIED;
            $user_sample_essay = VERIFIED;

            //network data
            $network_id = clean($data["n_id"]);// please validate this first
            if(!isset($data["n_id"]) || $network_id == ""){
                $network_id = getDefaultNetworkId();
            }
            $network_role = NETWORK_ROLE_COLLECTOR;
            $relationship_id = generateNumericId();*/

            $people_query = "insert into " . TABLE_PEOPLE . " (first_name,last_name,gender,phone_number,email,address_1,address_2,city,state,zip,country,user_type,password,user_ref_id,is_verified) values ('$first_name','$last_name','$gender','$number','$email','$address','$address2','$city','$state','$zip','$country','$user_type','$password','$user_ref_id','$is_verified')";

            $people_result = $cornersave->query($people_query);
            if($people_result != null && $people_result->is_row_affected()){
                $user_id = $people_result->insert_id();

                $result["status"] = "OK";
                $result["user_ref_id"] = $user_ref_id;
                $result["user_id"] = $user_id;

            }

            //$sale_id = $add_sale_result->insert_id();


            echo json_encode($result);

        }

        if ($action == 'get_my_orders')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            //$store_id = clean($data["store_id"]);
            $customer_id = clean($data["customer_id"]);

            //$store_info = getStoreInfo($store_id,$cornersave);
            //$manager_id = $store_info["manager_id"];

            $order_list = getOrderList($customer_id,$cornersave);
            //$store_list = getStoreList($cornersave);

            if (isset($order_list)){
                $result["status"] = "OK";
                $result["result"] = $order_list;
            }

            //echo json_encode($result);
            echo json_encode($result);

        }

        if ($action == 'get_order_detail')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);

            $store_id = clean($data["store_id"]);
            $customer_id = clean($data["customer_id"]);
            $order_id = clean($data["order_id"]);

            $store_info = getStoreInfo($store_id,$cornersave);
            $manager_id = $store_info["manager_id"];

            $order_detail = getOrderDetail($order_id,$store_id,$cornersave);
            //$store_list = getStoreList($cornersave);

            if (isset($order_detail)){
                $result["status"] = "OK";
                $result["result"] = $order_detail;
            }

            //echo json_encode($result);
            echo json_encode($result);

        }

        if ($action == 'cancel_order')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);

            $store_id = clean($data["store_id"]);
            $customer_id = clean($data["customer_id"]);
            $order_id = clean($data["order_id"]);

            $store_info = getStoreInfo($store_id,$cornersave);
            $manager_id = $store_info["manager_id"];

            $order_cancelled = cancelOrder($order_id,$customer_id,$manager_id,$cornersave);

            if ($order_cancelled){
                $result["status"] = "OK";
            }

            //echo json_encode($result);
            echo json_encode($result);

        }

        if ($action == 'get_promotion_detail')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $store_id = clean($data["store_id"]);
            $product_id = clean($data["product_id"]);

            $store_info = getStoreInfo($store_id,$cornersave);
            //$manager_id = $store_info["manager_id"];

            //if ($manager_id != null){

            //}

            //$product_detail = getItemInfo($product_id,$cornersave,$store_info);
            $product_detail = getPromotion($product_id,$store_info,$cornersave);

            if (isset($product_detail)){
                $result["status"] = "OK";
                $result["result"] = $product_detail;
            }

            //echo json_encode($result);
            echo json_encode($result);
        }

        if ($action == 'get_promotion_product_list')
        {
            $result["status"] = "NO_DATA";

            $data = json_decode($param_json, true);
            $store_id = clean($data["store_id"]);
            $search_id = clean($data["search_id"]);

            //$category_id = $data["category_id"];

            if ($search_id == ""){
                $search_id = null;
            }

            if (empty($store_id)){
                echo json_encode($result);

                return;
            }

            $store_info = getStoreInfo($store_id,$cornersave);
            //$manager_id = $store_info["manager_id"];

            if (!empty($store_info)){
                //$product_list = getCategoryItemList($category_id,$store_info,$cornersave,$search_id);
                $product_list = getPromotionItemList($store_info,$cornersave,$search_id);

                if (isset($product_list)){
                    $result["status"] = "OK";
                    $result["result"] = $product_list;
                }
            }


            //echo json_encode($result);
            echo json_encode($result);

        }

        if ($action == 'claim_gift')
        {
            $result["status"] = "FAILED";

            $data = json_decode($param_json, true);

            $batch_number = clean($data["batch_number"]);
            $store_id = clean($data["store_id"]);
            $customer_id = clean($data["customer_id"]);


            $isLinked = checkCustomerLink($customer_id,$store_id,$cornersave);

            if(!$isLinked){
                makeCustomerLink($customer_id,$store_id,$cornersave);
            }

            $store_info = getStoreInfo($store_id,$cornersave);
            $manager_id = $store_info["manager_id"];

            $isClaimed = checkCustomerGiftLink($customer_id,$store_id,$batch_number,$cornersave);
            if (!$isClaimed){

                $any_gift_id = getAnyGift($store_id,$batch_number,$cornersave);

                if ($any_gift_id != null){

                    $update_gift = "update " . TABLE_GIFT_CARDS . " set person_id = '$customer_id' where giftcard_id = '$any_gift_id' and manager_id = '$manager_id' and deleted = '0'";
                    $update_gift_result = $cornersave->query($update_gift);
                    if($update_gift_result != null && $update_gift_result->is_row_affected()){
                        $result["status"] = "OK";
                    }


                }


            }

            echo json_encode($result);

        }

        //ACTION_GET_PROMOTION_LIST = "get_promotion_list"
        //ACTION_GET_PROMOTION_DATA = "get_promotion_data" //()
        //ACTION_CLAIM_GIFT = "claim_gift" //()
        //ACTION_GET_CATEGORY_LIST = "get_category_list" //()
        //ACTION_COMPLETE_ORDER = "complete_order" //()
        //ACTION_TRIGGER_PAYMENT = "trigger_payment" //()
        //ACTION_GET_ORDER_LIST = "get_order_list" //()
        //ACTION_GET_ORDER_DATA = "get_order_data" //()
        //ACTION_CANCEL_ORDER = "cancel_order" //()



    }

    if ($interface == "cart"){

        //** IN PROGRESS **
        if ($action == 'preorder')
        {
            $result["status"] = "FAILED";

            $data = json_decode($param_json, true);
            $list = $data["product_list"];
            $store_id = clean($data["store_id"]);
            $customer_id = clean($data["customer_id"]);
            $pickup = $data["pickup"];//clean($data["pickup"]);

            $isLinked = checkCustomerLink($customer_id,$store_id,$cornersave);

            if(!$isLinked){
                makeCustomerLink($customer_id,$store_id,$cornersave);
            }

            $store_info = getStoreInfo($store_id,$cornersave);

            $sales_data = array(
                'sale_time'			=> getCurrentTime(),
                'customer_id'		=> intval($customer_id),
                'employee_id'		=> 0,
                'comment'			=> null,
                'sale_status'		=> ORDER_SUSPENDED,
                'invoice_number'	=> null,
                'quote_number'		=> null,
                'work_order_number'	=> null,
                'dinner_table_id'	=> 0,
                'sale_type'			=> 0,
                'pickup'			=> trim($pickup),
                'manager_id'		=> intval($store_info["manager_id"]),
                'is_online'		=> 1
            );

            $res = addSale($sales_data,$list,$cornersave);


            if ($res){
                $result["status"] = "OK";
            }

            echo json_encode($result);

        }

    }

    if ($interface == "-"){

        //** IN PROGRESS **
        if ($action == '')
        {

            $data = json_decode($param_json, true);
            $list = $data["email_list"];
            $user_id = clean($data["user_id"]);
            $net_role = NETWORK_ROLE_COMMANDER;

            $result = array();

            $network_rel_query = "select * from " . TABLE_NETWORK_RELATIONSHIP . " where user_id = '$user_id' and network_role = '$net_role'";
            $network_rel_result = $paperweight->query($network_rel_query);

            $result["status"] = "FAILED";

            if ($network_rel_result != null)
            {

                $row = $network_rel_result->fetch_array();

                if ($row != null)
                {
                    $network_id = $row["network_id"];
                    $network_detail = get_network_detail($network_id,$paperweight);

                    if (count($list) > 0) {
                        for ($i = 0; $i < count($list); $i++) {
                            $email = $list[$i];
                            $org_name = $network_detail["organization_name"];
                            $token = getRandomString(13);

                            $generated_link = "https://api.queritel.com/api/general/mailing/email/submission?ops=invitation&op=" . $network_id . "&token=" . $token;

                            $subject = "Queritel Invitation";
                            $body = createEmailInvitationBody($generated_link,$org_name);

                            sendMail($email,$subject,$body);

                        }

                        $result["status"] = "OK";
                    }
                }
            }


            echo json_encode($result);

        }

    }
}






//echo json_encode(getStoreInfo("3172546551",$cornersave));
//echo json_encode(getItemInfo("1071",$cornersave));


function getStoreById($manager_id,$cornersave){
    $result = array();

    $manager_query = "select * from " . TABLE_PEOPLE . " where person_id = '$manager_id'";
    $manager_result = $cornersave->query($manager_query);

    if ($manager_result != null)
    {

        $row = $manager_result->fetch_array();

        if ($row != null)
        {
            $result["phone_number"] = $row["phone_number"];
            $result["store_id"] = $row["user_ref_id"];
            $result["manager_id"] = $row["person_id"];

            if ($row["user_type"] == USER_TYPE_ADMIN){
                $result["manager_id"] = 0;
            }

            $manager_id = $result["manager_id"];

            $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
            //$store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
            $store_result = $cornersave->query($store_query);
            if ($store_result != null){
                while ($row2 = $store_result->fetch_array()){

                    if($row2["key"] == "company"){
                        $result["name"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "company_logo"){
                        $result["logo"] = $row2["value"];
                        //break;
                    }
                    if($row2["key"] == "address"){
                        $result["address"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "currency_code"){
                        $result["currency_code"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "currency_decimals"){
                        $result["currency_decimals"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "number_locale"){
                        $result["number_locale"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "discoverable"){
                        $result["discoverable"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "country_codes"){
                        $result["country_codes"] = ($row2["value"]);
                        //break;
                    }

                    if($row2["key"] == "email"){
                        $result["email"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "phone"){
                        $result["phone"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "store_type"){
                        $result["store_type"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "coordinates"){
                        $result["coordinates"] = $row2["value"];
                        //break;
                    }
                }

            }
        }
    }

    return $result;
}
function getStoreInfo($store_id,$cornersave){
    $result = array();

    $manager_query = "select * from " . TABLE_PEOPLE . " where user_ref_id = '$store_id'";
    $manager_result = $cornersave->query($manager_query);

    if ($manager_result != null)
    {

        $row = $manager_result->fetch_array();

        if ($row != null)
        {
            $result["phone_number"] = $row["phone_number"];
            $result["store_id"] = $row["user_ref_id"];
            $result["manager_id"] = $row["person_id"];

            if ($row["user_type"] == USER_TYPE_ADMIN){
                $result["manager_id"] = 0;
            }

            $manager_id = $result["manager_id"];

            $store_query = "select * from " . TABLE_CONFIG . " where manager_id = '$manager_id'";
            $store_result = $cornersave->query($store_query);
            if ($store_result != null){
                while ($row2 = $store_result->fetch_array()){

                    if($row2["key"] == "company"){
                        //$result["name"] = clean($row2["value"]);
                        $result["name"] = $row2["value"];
                        //break;
                    }
                    if($row2["key"] == "company_logo"){
                        $result["logo"] = $row2["value"];
                        //break;
                    }
                    if($row2["key"] == "address"){
                        $result["address"] = $row2["value"];
                        //break;
                    }
                    if($row2["key"] == "currency_code"){
                        $result["currency_code"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "currency_decimals"){
                        $result["currency_decimals"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "number_locale"){
                        $result["number_locale"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "discoverable"){
                        $result["discoverable"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "country_codes"){
                        $result["country_codes"] = ($row2["value"]);
                        //break;
                    }

                    if($row2["key"] == "email"){
                        $result["email"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "phone"){
                        $result["phone"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "store_type"){
                        $result["store_type"] = ($row2["value"]);
                        //break;
                    }
                    if($row2["key"] == "coordinates"){
                        $result["coordinates"] = $row2["value"];
                        //break;
                    }

                }

            }
        }
    }

    return $result;
}
function getItemInfo($product_id,$cornersave,$store_info = NULL){
    $decimal_place = 0;
    $number_locale = DEFAULT_LOCALE;
    $currency_code = "";

    if ($store_info != null){
        $manager_id = $store_info["manager_id"];
        $decimal_place = $store_info["currency_decimals"];
        $number_locale = $store_info["number_locale"];
        $currency_code = $store_info["currency_code"];
    }

    $result = array();

    $item_query = "select * from " . TABLE_ITEMS . " where item_id = '$product_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null)
    {

        $row = $item_result->fetch_array();

        if ($row != null)
        {
            $product_id = $row["item_id"];
            $product_qty = getItemQuantity($product_id,$cornersave);

            $category = clean($row["category"]);
            $result["item_id"] = $product_id;
            $result["name"] = clean($row["name"]);
            $result["category"] = $category;
            $result["item_number"] = $row["item_number"];
            $result["description"] = clean($row["description"]);
            $result["cost_price"] = $row["cost_price"];//not this one
            $result["unit_price"] = $row["unit_price"];
            $result["quantity"] = $product_qty;

            if ($store_info != null){
                $result["display_price"] = displayCurrency($row["unit_price"],$decimal_place,$number_locale);
                $result["currency_code"] = $currency_code;
            }

            $result["featured"] = $row["featured"];
            $result["pic_filename"] = $row["pic_filename"];
            $result["manager_id"] = $row["manager_id"];
            $result["brand"] = clean($row["brand"]);
            $result["unit_label"] = clean($row["unit_label"]);
            $result["unit_value"] = $row["unit_value"];
            $result["deleted"] = $row["deleted"];
            $result["discount"] = 0;
            $result["discount_type"] = 0;

            $lowered = strtolower($category);
            $code = str_replace(" ","+",$lowered);

            $result["category_name"] = $category;
            $result["category_id"] = $code;
            //$result["category_name"] = $name;
            //$result["category_id"] = "code";

        }
    }

    return $result;
}
function getItemQuantity($product_id,$cornersave){
    $result = 0;

    $item_query = "select * from " . TABLE_ITEM_QUANTITY . " where item_id = '$product_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null)
    {
        $row = $item_result->fetch_array();

        if ($row != null)
        {
            $result = $row["quantity"];
        }
    }

    //todo remove demo
    global $DEMO;
    if ($DEMO){
        return 1;
    }


    return $result;
}

//t-odo calculate original price based on discount and discount type (review)
function addSale($sales_data,$list,$cornersave){

    $success = false;

    $sale_time = $sales_data["sale_time"];
    $customer_id = $sales_data["customer_id"];
    $employee_id = $sales_data["employee_id"];
    $comment = $sales_data["comment"];
    $sale_status = $sales_data["sale_status"];
    $invoice_number = $sales_data["invoice_number"];
    $quote_number = $sales_data["quote_number"];
    $work_order_number = $sales_data["work_order_number"];
    $dinner_table_id = $sales_data["dinner_table_id"];
    $sale_type = $sales_data["sale_type"];
    $pickup = $sales_data["pickup"];
    $manager_id = $sales_data["manager_id"];
    $is_online = $sales_data["is_online"];


    //insert into table user
    $add_sale = "insert into " . TABLE_SALES . " (sale_time,customer_id,employee_id,comment,sale_status,invoice_number,quote_number,work_order_number,dinner_table_id,sale_type,manager_id,pickup,is_online) values('$sale_time','$customer_id','$employee_id','$comment','$sale_status','$invoice_number','$quote_number','$work_order_number','$dinner_table_id','$sale_type','$manager_id','$pickup','$is_online')";
    $add_sale_result = $cornersave->query($add_sale);

    //echo $add_sale;

    //$add_sale_result = null;

    if($add_sale_result != null && $add_sale_result->is_row_affected()){
        $sale_id = $add_sale_result->insert_id();

        $index = 0;
        foreach($list as $line=>$item)
        {
            $cur_item_info = getItemInfo($item['product_id'],$cornersave);

            //if($item['price'] == 0.00)
            //{
            //   $item['discount'] = 0.00;
            //}

            //sale_id, item_id, description, serialnumber, line, quantity_purchased, item_cost_price, item_unit_price, discount, discount_type, item_location, print_option
            //'1', '1', '', '', '1', '1.000', '5.00', '6.00', '0.00', '0', '1', '0'


            //$sale_id = $item[""];
            $item_id = $cur_item_info['item_id'];
            $line = $index;
            $description = null;
            $serialnumber = null;
            $quantity_purchased = $item['product_qty'];

            $discount = $item['discount'];
            $discount_type = $item['discount_type'];

            $item_cost_price = $cur_item_info['cost_price'];
            $item_unit_price = $cur_item_info['unit_price'];
            $item_location = 1;
            $print_option = 0;

            //todo calculate original price based on discount and discount type (review)

            $add_sale_items = "insert into " . TABLE_SALES_ITEMS . " (sale_id,item_id,line,description,serialnumber,quantity_purchased,discount,discount_type,item_cost_price,item_unit_price,item_location,print_option) values('$sale_id','$item_id','$line','$description','$serialnumber','$quantity_purchased','$discount','$discount_type','$item_cost_price','$item_unit_price','$item_location','$print_option')";
            $add_sale_item_result = $cornersave->query($add_sale_items);

            if($add_sale_item_result != null && $add_sale_item_result->is_row_affected()){

            }

            $index++;
        }

        $success = true;
    }

    return $success;
}
function getItemList($store_info,$cornersave){
    $manager_id = $store_info["manager_id"];
    $decimal_place = $store_info["currency_decimals"];
    $number_locale = $store_info["number_locale"];
    $currency_code = $store_info["currency_code"];

    $result = array();

    $deleted = 0;

    $item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted' order by featured desc, name asc";
    $item_result = $cornersave->query($item_query);

    $index = 0;

    if ($item_result != null)
    {
        while ($row = $item_result->fetch_array()){

            $product_id = $row["item_id"];
            $product_qty = getItemQuantity($product_id,$cornersave);

            if ($product_qty > 0){

                $result[$index]["item_id"] = $product_id;
                $result[$index]["name"] = clean($row["name"]);
                $result[$index]["category"] = clean($row["category"]);
                $result[$index]["item_number"] = $row["item_number"];
                $result[$index]["description"] = clean($row["description"]);
                $result[$index]["cost_price"] = $row["cost_price"];//not this one

                $unit_price = floatval($row["unit_price"]);
                $result[$index]["unit_price"] = $unit_price;
                $result[$index]["display_price"] = displayCurrency($unit_price,$decimal_place,$number_locale);
                $result[$index]["currency_code"] = $currency_code;

                $result[$index]["featured"] = $row["featured"];
                $result[$index]["pic_filename"] = $row["pic_filename"];
                $result[$index]["manager_id"] = $row["manager_id"];
                $result[$index]["brand"] = clean($row["brand"]);
                $result[$index]["unit_label"] = clean($row["unit_label"]);
                $result[$index]["unit_value"] = $row["unit_value"];
                $result[$index]["deleted"] = $row["deleted"];

                $index++;

            }
        }
    }


    return $result;
}
function getCategoryItemList($category_id,$store_info,$cornersave,$search_id = null){
    $manager_id = $store_info["manager_id"];
    $decimal_place = $store_info["currency_decimals"];
    $number_locale = $store_info["number_locale"];
    $currency_code = $store_info["currency_code"];

    $result = array();

    $deleted = 0;

    //$name = trim($row["category"]);
    //$lowered = strtolower($name);
    $category_name = str_replace("+"," ",$category_id);
    $category_name = remove_accents($category_name);
    $category_name = clean($category_name);
    //$code = str_replace(" ","+",$lowered);

    if ($search_id != null){
        $item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted' and category = '$category_name' and name like '%$search_id%' order by featured desc, name asc";
    }
    else{

        $item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted' and category = '$category_name' order by featured desc, name asc";
    }
    //$item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted' and category like '%$category_name%'";
    //$item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted'";
    $item_result = $cornersave->query($item_query);

    $index = 0;

    if ($item_result != null)
    {
        while ($row = $item_result->fetch_array()){

            $product_id = $row["item_id"];
            $product_qty = getItemQuantity($product_id,$cornersave);

            if ($product_qty > 0){

                $result[$index]["item_id"] = $product_id;
                $result[$index]["name"] = clean($row["name"]);
                //$result[$index]["name"] = ($row["name"]);
                $result[$index]["category"] = clean($row["category"]);
                $result[$index]["item_number"] = $row["item_number"];
                $result[$index]["description"] = clean($row["description"]);
                $result[$index]["cost_price"] = $row["cost_price"];//not this one
                $result[$index]["unit_price"] = $row["unit_price"];
                $result[$index]["display_price"] = displayCurrency($row["unit_price"],$decimal_place,$number_locale);
                $result[$index]["currency_code"] = $currency_code;

                $result[$index]["featured"] = $row["featured"];
                $result[$index]["pic_filename"] = $row["pic_filename"];
                $result[$index]["manager_id"] = $row["manager_id"];
                $result[$index]["brand"] = clean($row["brand"]);
                $result[$index]["unit_label"] = clean($row["unit_label"]);
                $result[$index]["unit_value"] = $row["unit_value"];
                $result[$index]["deleted"] = $row["deleted"];

                $index++;

            }
        }
    }

    return $result;
}

function getKitDetail($kit_id,$cornersave,$store_info = null){
    $result = array();
    $items = array();
    $index = 0;

    $item_query = "select * from " . TABLE_KITS_ITEMS . " where item_kit_id = '$kit_id'";
    $item_result = $cornersave->query($item_query);

    $record_found = false;

    $total = 0;

    if ($item_result != null){
        while ($row = $item_result->fetch_array()){
            $record_found = true;

            $item_id = $row["item_id"];
            $item_amount = $row["quantity"];
            $item_detail = getItemInfo($item_id,$cornersave,$store_info);

            $price = 0;

            if (!empty($item_detail)){
                $price = $item_detail["unit_price"];
            }
            $item_discount = 0;

            $cost = ($price - $item_discount) * $item_amount;

            $total += $cost;


            $category = $item_detail["category"];
            $items[$index]["item_id"] = $item_id;
            $items[$index]["name"] = $item_detail["name"];
            $items[$index]["category"] = $category;
            $items[$index]["item_number"] = $item_detail["item_number"];
            $items[$index]["description"] = $item_detail["description"];
            $items[$index]["cost_price"] = $item_detail["cost_price"];//not this one
            $items[$index]["unit_price"] = $item_detail["unit_price"];

            $items[$index]["price"] = $cost;
            $items[$index]["quantity"] = $item_amount;
            if ($store_info != null){
                //$manager_id = $store_info["manager_id"];
                $decimal_place = $store_info["currency_decimals"];
                $number_locale = $store_info["number_locale"];
                $currency_code = $store_info["currency_code"];

                $items[$index]["display_unit_price"] = displayCurrency($item_detail["unit_price"],$decimal_place,$number_locale);
                $items[$index]["display_price"] = displayCurrency($cost,$decimal_place,$number_locale);
                $items[$index]["currency_code"] = $currency_code;
            }
            $items[$index]["pic_filename"] = $item_detail["pic_filename"];
            $items[$index]["manager_id"] = $item_detail["manager_id"];
            $items[$index]["brand"] = $item_detail["brand"];
            $items[$index]["unit_label"] = $item_detail["unit_label"];
            $items[$index]["unit_value"] = $item_detail["unit_value"];
            $items[$index]["deleted"] = $item_detail["deleted"];
            $lowered = strtolower($category);
            $code = str_replace(" ","+",$lowered);
            $items[$index]["category_name"] = $category;
            $items[$index]["category_id"] = $code;

            $index++;

        }
    }

    if ($record_found){
        $result["total"] = $total;
        $result["items"] = $items;

        return $result;
    }


    return null;

}
function getPromotion($product_id,$store_info,$cornersave){
    $manager_id = $store_info["manager_id"];
    $decimal_place = $store_info["currency_decimals"];
    $number_locale = $store_info["number_locale"];
    $currency_code = $store_info["currency_code"];

    $result = array();

    $deleted = 0;

    //$name = trim($row["category"]);
    //$lowered = strtolower($name);
    //$category_name = str_replace("+"," ",$category_id);
    //$category_name = remove_accents($category_name);
    //$category_name = clean($category_name);
    //$code = str_replace(" ","+",$lowered);

    $item_query = "select * from " . TABLE_KITS . " where manager_id = '$manager_id' and item_kit_id = '$product_id'";

    //$item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted' and category like '%$category_name%'";
    //$item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted'";
    $item_result = $cornersave->query($item_query);

    $index = 0;
    $kit_items = array();

    if ($item_result != null)
    {
        $row = $item_result->fetch_array();
        if ($row != null){


            $kit_id = $row["item_kit_id"];
            $kit_name = clean($row["name"]);
            $kit_discount = $row["kit_discount"];
            $kit_discount_type = $row["kit_discount_type"];
            $kit_discount_description = clean($row["description"]);

            $kit_total = 0;
            $items = array();


            $kit_detail = getKitDetail($kit_id,$cornersave,$store_info);
            if ($kit_detail != null){
                $kit_total = $kit_detail["total"];
                $items = $kit_detail["items"];
            }

            $price = 0;

            if ($kit_discount_type == KIT_TYPE_PERCENT){
                $percent = ($kit_discount / 100) * $kit_total;
                $price = $kit_total - $percent;

                for ($i = 0; $i < count($items); $i++){
                    $pri = $items[$i]["price"];
                    $items[$i]["discount"] = $kit_discount;
                    $items[$i]["discount_type"] = KIT_TYPE_PERCENT;

                    $per = ($kit_discount / 100) * $pri;
                    $items[$i]["discounted_price"] = $pri - $per;
                    $items[$i]["discounted_display_price"] = displayCurrency($items[$i]["discounted_price"],$decimal_place,$number_locale);

                }
            }
            else{
                $price = $kit_total - $kit_discount;

                for ($i = 0; $i < count($items); $i++){
                    $pri = $items[$i]["price"];
                    $items[$i]["discount"] = $kit_discount;
                    $items[$i]["discount_type"] = KIT_TYPE_FIXED;

                    $items[$i]["discounted_price"] = $pri - $kit_discount;
                    $items[$i]["discounted_display_price"] = displayCurrency($items[$i]["discounted_price"],$decimal_place,$number_locale);
                }

            }


            $result["item_id"] = $kit_id;
            $result["name"] = $kit_name;
            $result["description"] = $kit_discount_description;
            $result["price"] = $price;
            $result["display_price"] = displayCurrency($price,$decimal_place,$number_locale);
            $result["currency_code"] = $currency_code;
            $result["items"] = $items;

        }
    }

    return $result;
}
function getPromotionItemList($store_info,$cornersave,$search_id = null){
    $manager_id = $store_info["manager_id"];
    $decimal_place = $store_info["currency_decimals"];
    $number_locale = $store_info["number_locale"];
    $currency_code = $store_info["currency_code"];

    $result = array();

    $deleted = 0;

    //$name = trim($row["category"]);
    //$lowered = strtolower($name);
    //$category_name = str_replace("+"," ",$category_id);
    //$category_name = remove_accents($category_name);
    //$category_name = clean($category_name);
    //$code = str_replace(" ","+",$lowered);

    if ($search_id != null){
        //$item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted' and category = '$category_name' and name like '%$search_id%'";
    }
    else{
        $item_query = "select * from " . TABLE_KITS . " where manager_id = '$manager_id'";
    }
    //$item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted' and category like '%$category_name%'";
    //$item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted'";
    $item_result = $cornersave->query($item_query);

    $index = 0;

    //get gifts if any
    if (hasGifts($manager_id,$cornersave)){
        $batch_array = array();

        $gift_query = "select * from " . TABLE_GIFT_CARDS . " where manager_id = '$manager_id' and deleted = '0' and public = '1' and person_id is null";
        $gift_result = $cornersave->query($gift_query);
        if ($gift_result != null){
            while ($row = $gift_result->fetch_array()){

                $batch = $row["batch_code"];
                $price = $row["value"];

                if (!in_array($batch,$batch_array)){
                    $result[$index]["type"] = PRODUCT_TYPE_GIFT;
                    $result[$index]["batch_number"] = $batch;
                    $result[$index]["price"] = $price;
                    $result[$index]["display_price"] = displayCurrency($price,$decimal_place,$number_locale);
                    $result[$index]["currency_code"] = $currency_code;

                    array_push($batch_array,$batch);

                    $index++;
                }

            }
        }

    }

    //todo : GET GIFT CARDS HERE

    if ($item_result != null)
    {
        while ($row = $item_result->fetch_array()){


            $kit_id = $row["item_kit_id"];
            $kit_name = clean($row["name"]);
            $kit_discount = $row["kit_discount"];
            $kit_discount_type = $row["kit_discount_type"];
            $kit_discount_description = clean($row["description"]);

            $kit_total = 0;
            $items = array();


            $kit_detail = getKitDetail($kit_id,$cornersave,$store_info);
            if ($kit_detail != null){
                $kit_total = $kit_detail["total"];
                $items = $kit_detail["items"];
            }

            $price = 0;

            if ($kit_discount_type == KIT_TYPE_PERCENT){
                $percent = ($kit_discount / 100) * $kit_total;
                $price = $kit_total - $percent;

                for ($i = 0; $i < count($items); $i++){
                    $pri = $items[$i]["price"];
                    $items[$i]["discount"] = $kit_discount;
                    $items[$i]["discount_type"] = KIT_TYPE_PERCENT;

                    $per = ($kit_discount / 100) * $pri;
                    $items[$i]["discounted_price"] = $pri - $per;
                    $items[$i]["discounted_display_price"] = displayCurrency($items[$i]["discounted_price"],$decimal_place,$number_locale);

                }
            }
            else{
                $price = $kit_total - $kit_discount;

                for ($i = 0; $i < count($items); $i++){
                    $pri = $items[$i]["price"];
                    $items[$i]["discount"] = $kit_discount;
                    $items[$i]["discount_type"] = KIT_TYPE_FIXED;

                    $items[$i]["discounted_price"] = $pri - $kit_discount;
                    $items[$i]["discounted_display_price"] = displayCurrency($items[$i]["discounted_price"],$decimal_place,$number_locale);
                }

            }


            $result[$index]["item_id"] = $kit_id;
            $result[$index]["name"] = $kit_name;
            $result[$index]["type"] = PRODUCT_TYPE_PROMOTION;
            $result[$index]["description"] = $kit_discount_description;
            $result[$index]["price"] = $price;
            $result[$index]["display_price"] = displayCurrency($price,$decimal_place,$number_locale);
            $result[$index]["currency_code"] = $currency_code;
            $result[$index]["items"] = $items;

            $index++;
        }
    }

    return $result;
}




function getSearchedItemList($search_id,$store_info,$cornersave){
    $manager_id = $store_info["manager_id"];
    $decimal_place = $store_info["currency_decimals"];
    $number_locale = $store_info["number_locale"];
    $currency_code = $store_info["currency_code"];

    $result = array();

    $deleted = 0;

    //$name = trim($row["category"]);
    //$lowered = strtolower($name);
    //$category_name = str_replace("+"," ",$category_id);
    //$code = str_replace(" ","+",$lowered);

    $item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted' and name like '%$search_id%' order by featured desc, name asc";
    //$item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted' and category like '%$category_name%'";
    //$item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted'";
    $item_result = $cornersave->query($item_query);

    $index = 0;

    if ($item_result != null)
    {
        while ($row = $item_result->fetch_array()){

            $product_id = $row["item_id"];
            $product_qty = getItemQuantity($product_id,$cornersave);

            if ($product_qty > 0){

                $result[$index]["item_id"] = $product_id;
                $result[$index]["name"] = clean($row["name"]);
                //$result[$index]["name"] = ($row["name"]);
                $result[$index]["category"] = clean($row["category"]);
                $result[$index]["item_number"] = $row["item_number"];
                $result[$index]["description"] = clean($row["description"]);
                $result[$index]["cost_price"] = $row["cost_price"];//not this one
                $result[$index]["unit_price"] = $row["unit_price"];
                $result[$index]["display_price"] = displayCurrency($row["unit_price"],$decimal_place,$number_locale);
                $result[$index]["currency_code"] = $currency_code;

                $result[$index]["featured"] = $row["featured"];
                $result[$index]["pic_filename"] = $row["pic_filename"];
                $result[$index]["manager_id"] = $row["manager_id"];
                $result[$index]["brand"] = clean($row["brand"]);
                $result[$index]["unit_label"] = clean($row["unit_label"]);
                $result[$index]["unit_value"] = $row["unit_value"];
                $result[$index]["deleted"] = $row["deleted"];

                $index++;

            }
        }
    }

    return $result;
}
function getStoreList($cornersave,$country = null){
    $result = array();

    $user_type = USER_TYPE_MANAGER;

    $store_query = "select * from " . TABLE_PEOPLE . " where user_type = '$user_type'";
    $store_result = $cornersave->query($store_query);

    $index = 0;

    if ($store_result != null) {

        while ($row = $store_result->fetch_array()){

            $id = $row["user_ref_id"];
            $store_info = getStoreInfo($id,$cornersave);

            $is_visible = false;
            $right_locale = false;

            //criteria check
            if ($store_info["discoverable"] == 1){
                $is_visible = true;
            }
            if ($country == null){
                $right_locale = true;
            }
            else{
                if ($country == $store_info["country_codes"]){
                    $right_locale = true;
                }
            }

            if ($right_locale && $is_visible){
                $result[$index] = getStoreInfo($id,$cornersave);

                $index++;
            }

        }
    }

    return $result;
}

function hasPromotions($manager_id,$cornersave){
    $item_query = "select * from " . TABLE_KITS . " where manager_id = '$manager_id'";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null){
        $row = $item_result->fetch_array();

        if ($row != null){
            return true;
        }

    }

    return false;
}
function hasGifts($manager_id,$cornersave){
    $item_query = "select * from " . TABLE_GIFT_CARDS . " where manager_id = '$manager_id' and deleted = '0' and public = '1' and person_id is null";
    $item_result = $cornersave->query($item_query);

    if ($item_result != null){
        $row = $item_result->fetch_array();

        if ($row != null){
            return true;
        }

    }

    return false;
}
function getCategoryList($manager_id,$cornersave){
    $result = array();

    $deleted = 0;

    $item_query = "select * from " . TABLE_ITEMS . " where manager_id = '$manager_id' and deleted = '$deleted'";
    $item_result = $cornersave->query($item_query);

    $index = 0;
    $category_list = array();

    if (hasPromotions($manager_id,$cornersave) || hasGifts($manager_id,$cornersave)){
        $code_ = "promotion";

        $result[$index]["category_name"] = "Promotion";
        $result[$index]["category_id"] = $code_;
        $category_list[$code_] = 1;

        $index++;
    }

    if ($item_result != null){
        while ($row = $item_result->fetch_array()){

            $product_id = $row["item_id"];
            $product_qty = getItemQuantity($product_id,$cornersave);

            if ($product_qty > 0){
                $name = clean($row["category"]);
                $lowered = strtolower($name);
                $code = str_replace(" ","+",$lowered);

                if (!isset($category_list[$code])){
                    $result[$index]["category_name"] = $name;
                    $result[$index]["category_id"] = $code;
                    $category_list[$code] = 1;

                    $index++;
                }
            }

        }
    }

    return $result;
}

//has the customer already claimed a giftcard from this batch
function checkCustomerGiftLink($customer_id,$store_id,$batch_number,$cornersave){
    $isCustomerLinked = false;

    $store_info = getStoreInfo($store_id,$cornersave);
    $manager_id = $store_info["manager_id"];

    $customer_query = "select * from " . TABLE_GIFT_CARDS . " where batch_code = '$batch_number' and public = '1' and manager_id = '$manager_id' and deleted = '0' and person_id = '$customer_id'";
    $customer_result = $cornersave->query($customer_query);

    if ($customer_result != null){
        $row = $customer_result->fetch_array();
        if ($row != null){
            $isCustomerLinked = true;
        }

    }

    return $isCustomerLinked;
}
//get the id of any gift in this batch
function getAnyGift($store_id,$batch_number,$cornersave){
    $gift_id = null;

    $store_info = getStoreInfo($store_id,$cornersave);
    $manager_id = $store_info["manager_id"];

    $customer_query = "select * from " . TABLE_GIFT_CARDS . " where batch_code = '$batch_number' and public = '1' and manager_id = '$manager_id' and deleted = '0' and person_id is null";
    $customer_result = $cornersave->query($customer_query);

    if ($customer_result != null){
        $row = $customer_result->fetch_array();
        if ($row != null){

            $gift_id = $row["giftcard_id"];
        }

    }

    return $gift_id;
}

function checkCustomerLink($customer_id,$store_id,$cornersave){
    $isCustomerLinked = false;

    $store_info = getStoreInfo($store_id,$cornersave);
    $manager_id = $store_info["manager_id"];

    $customer_query = "select * from " . TABLE_CUSTOMER . " where person_id = '$customer_id' and manager_id = '$manager_id'";
    $customer_result = $cornersave->query($customer_query);

    if ($customer_result != null){
        $row = $customer_result->fetch_array();
        if ($row != null){
            $isCustomerLinked = true;
        }

    }

    return $isCustomerLinked;
}

function makeCustomerLink($customer_id,$store_id,$cornersave){
    $store_info = getStoreInfo($store_id,$cornersave);
    $manager_id = $store_info["manager_id"];
    $linkMade = false;

    //$customer_query = "insert into " . TABLE_CUSTOMER . " (sale_time,customer_id,employee_id,comment,sale_status,invoice_number,quote_number,work_order_number,dinner_table_id,sale_type,manager_id) values('$sale_time','$customer_id','$employee_id','$comment','$sale_status','$invoice_number','$quote_number','$work_order_number','$dinner_table_id','$sale_type','$manager_id')";
    //$people_query = "insert into " . TABLE_PEOPLE . " (first_name,last_name,gender,phone_number,email,address_1,address_2,city,state,zip,country,comments,person_id,user_type,password,user_ref_id) values('$sale_time','$customer_id','$employee_id','$comment','$sale_status','$invoice_number','$quote_number','$work_order_number','$dinner_table_id','$sale_type','$manager_id')";
    //$sale_id = $add_sale_result->insert_id();

    $company_name = null;
    $account_number = null;
    $taxable = 1;
    $tax_id = null;
    $sales_tax_code_id = null;
    $discount = 0;
    $discount_type = 0;
    $package_id = null;
    $points = null;

    $deleted = 0;
    $date = getCurrentTime();
    $employee_id = 0;
    $consent = 1;

    //$customer_query = "insert into " . TABLE_CUSTOMER . " (person_id,company_name,account_number,taxable,tax_id,sales_tax_code_id,discount,discount_type,package_id,points,deleted,date,employee_id,consent,manager_id) values('$customer_id','$company_name','$account_number','$taxable','$tax_id','$sales_tax_code_id','$discount','$discount_type','$package_id','$points','$deleted','$date','$employee_id','$consent','$manager_id')";
    $customer_query = "insert into " . TABLE_CUSTOMER . " (person_id,taxable,tax_id,discount,discount_type,deleted,date,employee_id,consent,manager_id) values('$customer_id','$taxable','$tax_id','$discount','$discount_type','$deleted','$date','$employee_id','$consent','$manager_id')";

    //$customer_query = "select * from " . TABLE_CUSTOMER . " where person_id = '$customer_id' and manager_id = '$manager_id'";
    $customer_result = $cornersave->query($customer_query);
    if($customer_result != null && $customer_result->is_row_affected()){
        $linkMade = true;
    }

    return $linkMade;
}

function loginCustomer($username,$password,$cornersave){
    $customer_id = null;

    //$store_info = getStoreInfo($store_id,$cornersave);
    //$manager_id = $store_info["manager_id"];

    $username = strtolower(clean($username));
    $password = encryptPassword(clean($password));
    $user_type = USER_TYPE_CUSTOMER;

    $customer_query = "select * from " . TABLE_PEOPLE . " where email = '$username' and password = '$password' and user_type = '$user_type'";
    $customer_result = $cornersave->query($customer_query);

    if ($customer_result != null){

        $row = $customer_result->fetch_array();

        if ($row != null){
            $customer_id = $row["person_id"];
        }

    }

    return $customer_id;
}

//name and email
function getCustomerInfo($customer_id,$cornersave){
    $result = array();

    $user_type = USER_TYPE_CUSTOMER;

    $customer_query = "select * from " . TABLE_PEOPLE . " where person_id = '$customer_id' and user_type = '$user_type'";
    $customer_result = $cornersave->query($customer_query);

    if ($customer_result != null)
    {

        $row = $customer_result->fetch_array();

        if ($row != null)
        {
            $result["first_name"] = stringCase($row["first_name"],STRING_CASE_CAP_EACH);
            $result["last_name"] = stringCase($row["last_name"],STRING_CASE_CAP_EACH);
            $result["email"] = stringCase($row["email"]);
            $result["user_ref_id"] = $row["user_ref_id"];
            //$result["phone_number"] = $row["phone_number"];
            //$result["store_id"] = $row["user_ref_id"];
            //$result["manager_id"] = $row["person_id"];
        }
    }

    return $result;
}

function getOrderList($customer_id,$cornersave){
    $result = array();
    $index = 0;


    $order_query = "select * from " . TABLE_SALES . " where customer_id = '$customer_id'";
    $order_result = $cornersave->query($order_query);

    if ($order_result != null)
    {

        while ($row = $order_result->fetch_array()){

            $sale_time = $row["sale_time"];
            $pickup_time = $row["sale_time"];
            $sale_id = $row["sale_id"];
            $manger_id = $row["manager_id"];

            $status = "pending";
            $sale_status = $row["sale_status"];
            $approved = $row["approved"];

            // ORDER_COMPLETED
            // ORDER_SUSPENDED
            // ORDER_CANCELED

            if($sale_status == ORDER_CANCELED){
                $status = "cancelled";
            }
            elseif ($sale_status == ORDER_COMPLETED){
                $status = "completed";
            }
            elseif ($sale_status == ORDER_SUSPENDED){

                if ($approved == "1"){
                    $status = "confirmed";
                }
                else{
                    $status = "pending";
                }
            }


            $store_data = getStoreById($manger_id,$cornersave);

            $result[$index]["name"] = clean($store_data["name"]);
            $result[$index]["order_id"] = $sale_id;
            $result[$index]["store_id"] = $store_data["store_id"];
            $result[$index]["date"] = $sale_time;
            $result[$index]["pickup_date"] = $pickup_time;

            $result[$index]["status"] = $status;

            $result[$index]["items"] = "0";
            $result[$index]["total"] = "0";

            $item_list = getOrderItemList($sale_id,$cornersave);

            if ($item_list["status"] == "OK"){
                $result[$index]["items"] = count($item_list["list"]);
                $result[$index]["total"] = $item_list["total"];
            }




            /*
                $result[$index]["status"] = "pending";
                $result[$index]["status"] = "confirmed";
                $result[$index]["status"] = "completed";
                $result[$index]["status"] = "cancelled";
            */
            //$result[$index] = getStoreInfo($id,$cornersave);

            $index++;
        }
    }


    //$user_type = USER_TYPE_MANAGER;

    //$store_query = "select * from " . TABLE_PEOPLE . " where user_type = '$user_type'";
    //$store_result = $cornersave->query($store_query);



    /*if ($store_result != null)
    {

        while ($row = $store_result->fetch_array()){

            $id = $row["user_ref_id"];
            $result[$index] = getStoreInfo($id,$cornersave);

            $index++;
        }
    }*/
    /*$name = "Jon Garcia Minimarket";
    $result[$index]["name"] = $name;
    $result[$index]["order_id"] = "75";
    $result[$index]["store_id"] = "4687314909";
    $result[$index]["date"] = "2020-12-28 01:30:38";
    $result[$index]["pickup_date"] = "2020-12-28 01:30:38";
    $result[$index]["items"] = "2";
    $result[$index]["total"] = "2900";
    $result[$index]["status"] = "pending";*/

    /*$index = 1;

    $result[$index]["name"] = "Zendos Snackables";
    $result[$index]["order_id"] = "74";
    $result[$index]["store_id"] = "3172546551";
    $result[$index]["date"] = "2020-09-12 10:12:38";
    $result[$index]["pickup_date"] = "2020-09-12 12:12:38";
    $result[$index]["items"] = "2";
    $result[$index]["total"] = "300";
    //$result[$index]["status"] = "pending";
    $result[$index]["status"] = "confirmed";
    //$result[$index]["status"] = "completed";
    //$result[$index]["status"] = "cancelled";
    */

    return $result;
}

function cancelOrder($order_id,$customer_id,$manager_id,$cornersave){
    $order_cancelled = false;
    $new_status = ORDER_CANCELED;
    $customer_cancelled = 1;


    $update_sale = "update " . TABLE_SALES . " set sale_status = '$new_status', customer_cancel = '$customer_cancelled' where sale_id = '$order_id' and customer_id = '$customer_id' and manager_id = '$manager_id'";
    $update_sale_result = $cornersave->query($update_sale);
    if($update_sale_result != null && $update_sale_result->is_row_affected()){
        $order_cancelled = true;
    }

    return $order_cancelled;
}

function getOrderDetail($order_id,$store_id,$cornersave){
    $result = array();
    $item = array();

    //$user_type = USER_TYPE_MANAGER;

    //$store_query = "select * from " . TABLE_PEOPLE . " where user_type = '$user_type'";
    //$store_result = $cornersave->query($store_query);

    $index = 0;

    //Gonzalo
    //Gonzalo Minimarket
    //55

    $store_info = getStoreInfo($store_id,$cornersave);

    $result["store"] = $store_info["name"];
    $result["store_id"] = $store_info["store_id"];
    $result["order_id"] = $order_id;
    $result["currency"] = $store_info["currency_code"];

    $result["total"] = 0;

    $sale_query = "select * from " . TABLE_SALES . " where sale_id = '$order_id'";
    $sale_result = $cornersave->query($sale_query);

    if ($sale_result != null){
        if ($row = $sale_result->fetch_array()){
            $item_list = getOrderItemList($order_id,$cornersave);

            if ($item_list["status"] == "OK"){
                $result["total"] = $item_list["total"];
            }

            $result["pickup_date"] = $row["pickup"];

            $status = "pending";
            $sale_status = $row["sale_status"];
            $approved = $row["approved"];

            if($sale_status == ORDER_CANCELED){
                $status = "cancelled";
            }
            elseif ($sale_status == ORDER_COMPLETED){
                $status = "completed";
            }
            elseif ($sale_status == ORDER_SUSPENDED){

                if ($approved == "1"){
                    $status = "confirmed";
                }
                else{
                    $status = "pending";
                }
            }
            $result["status"] = $status;

            foreach ($item_list["list"] as $item_element) {

                $item_id = $item_element["item_id"];

                $item_info = getItemInfo($item_id,$cornersave);

                $item[$index]["item_id"] = $item_id;
                //$item[$index]["name"] = clean($item_info["name"]);
                $item[$index]["name"] = $item_info["name"];
                //$item[$index]["name"] = remove_accents($item_info["name"]);
                $item[$index]["unit_price"] = $item_element["item_unit_price"];
                $item[$index]["pic_filename"] = $item_info["pic_filename"];
                //$item[$index]["status"] = $item_element[""];
                $item[$index]["product_qty"] = $item_element["quantity_purchased"];
                $item[$index]["total"] = $item_element["discounted_total"];


                $stat = "pending";

                $approved_item = $item_element["approved"];

                if ($approved == 0 && $approved_item == 1){
                    $stat = "in_stock";
                }
                if ($approved == 1 && $approved_item == 1){
                    $stat = "in_stock";
                }
                if ($approved == 1 && $approved_item == 0){
                    $stat = "out_stock";
                }


                $item[$index]["status"] = $stat;

                $index++;
            }

        }
    }

    //in_stock
    //out_stock





    /*if ($store_result != null)
    {

        while ($row = $store_result->fetch_array()){

            $id = $row["user_ref_id"];
            $result[$index] = getStoreInfo($id,$cornersave);

            $index++;
        }
    }*/
    //$item[$index]["item_id"] = "789";
    //$item[$index]["name"] = "Gaseosa Sabor Papaya";

    //$item[$index]["category"] = "ACEITES Y ADEREZOS";
    //$item[$index]["item_number"] = "";
    //$item[$index]["description"] = "";
    //$item[$index]["cost_price"] = "0";//not this one
    //$item[$index]["unit_price"] = 100;
    //$item[$index]["pic_filename"] = "460928.jpg";
    //$item[$index]["manager_id"] = "6";
    //$item[$index]["brand"] = "Olivo de Plata";
    //$item[$index]["unit_label"] = "L";
    //$item[$index]["unit_value"] = "1";
    //$item[$index]["deleted"] = 0;
    //$item[$index]["status"] = "pending";
    //$item[$index]["product_qty"] = 1;
    //$item[$index]["total"] = 100;
    //$item[$index]["status"] = "in_stock";
    //$item[$index]["status"] = "out_stock";

    //$index = 1;

    //$item[$index]["item_id"] = "790";
    //$item[$index]["name"] = clean("Gaseosa Guaraná");
    //$item[$index]["category"] = "ACEITES Y ADEREZOS";
    //$item[$index]["item_number"] = "";
    //$item[$index]["description"] = "";
    //$item[$index]["cost_price"] = "0";//not this one
    //$item[$index]["unit_price"] = 80;
    //$item[$index]["pic_filename"] = "693622.jpg";
    //$item[$index]["manager_id"] = "6";
    //$item[$index]["brand"] = "A de Coco";
    //$item[$index]["unit_label"] = "g";
    //$item[$index]["unit_value"] = "384";
    //$item[$index]["deleted"] = 0;
    //$item[$index]["status"] = "pending";
    //$item[$index]["status"] = "in_stock";
    //$item[$index]["product_qty"] = 1;
    //$item[$index]["total"] = 80;

    //$result["product_list"] = $item;

    $result["product_list"] = $item;

    /*$index = 1;

    $result[$index]["name"] = "Zendos Snackables";
    $result[$index]["order_id"] = "74";
    $result[$index]["store_id"] = "3172546551";
    $result[$index]["date"] = "2020-09-12 10:12:38";
    $result[$index]["pickup_date"] = "2020-09-12 12:12:38";
    $result[$index]["items"] = "2";
    $result[$index]["total"] = "300";
    //$result[$index]["status"] = "pending";
    $result[$index]["status"] = "confirmed";
    //$result[$index]["status"] = "completed";
    //$result[$index]["status"] = "cancelled";
    */


    return $result;
}

function getOrderItemList($order_id,$cornersave){
    //$user_type = USER_TYPE_MANAGER;
    $result = array();
    $items = array();
    $index = 0;

    $result["status"] = "NO_DATA";
    $record_found = false;

    $sale_item_query = "select * from " . TABLE_SALES_ITEMS . " where sale_id = '$order_id'";
    $sale_item_result = $cornersave->query($sale_item_query);

    $final_total = 0;

    if ($sale_item_result != null)
    {

        while ($row = $sale_item_result->fetch_array()){
            $record_found = true;

            $item_id = $row["item_id"];
            $description = $row["description"];
            $serialnumber = $row["serialnumber"];
            $line = $row["line"];
            $quantity_purchased = $row["quantity_purchased"];
            $item_cost_price = $row["item_cost_price"];
            $item_unit_price = $row["item_unit_price"];
            $discount = $row["discount"];
            $discount_type = $row["discount_type"];
            $item_location = $row["item_location"];
            $print_option = $row["print_option"];
            $approved = $row["approved"];


            $total = $quantity_purchased * $item_unit_price;
            $discounted_total = $total - (($discount / 100) * $total);


            //$total

            $items[$index]["item_id"] = $item_id;
            $items[$index]["description"] = $description;
            $items[$index]["serialnumber"] = $serialnumber;
            $items[$index]["line"] = $line;
            $items[$index]["quantity_purchased"] = $quantity_purchased;
            $items[$index]["item_cost_price"] = $item_cost_price;
            $items[$index]["item_unit_price"] = $item_unit_price;
            $items[$index]["discount"] = $discount;
            $items[$index]["discount_type"] = $discount_type;
            $items[$index]["item_location"] = $item_location;
            $items[$index]["print_option"] = $print_option;
            $items[$index]["approved"] = $approved;
            $items[$index]["discounted_total"] = $discounted_total;


            $final_total += $discounted_total;

            $index++;
        }


    }

    if ($record_found){
        $result["status"] = "OK";
        $result["total"] = $final_total;
        $result["list"] = $items;
    }

    return $result;
}
//echo encryptPassword("pointofsale");
//echo generateUserReferenceId();

function encryptPassword($password){//(site-function)
    return md5(PASSWORD_SALT . $password . PASSWORD_SALT);
}
function generateUserReferenceId() {
    return getRandomNumber(10);
}


function getContentCurl($url){
    //header('Content-Type:application/json');
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

    //curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
    //curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 5);
    //curl_setopt($ch, CURLOPT_TIMEOUT, 3);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Accept: application/json'));

    $res = curl_exec($ch);

    curl_close($ch);

    return $res;
}

//return a formatted currency string based on the locale
function displayCurrency($number, $decimals = NULL, $locale = DEFAULT_LOCALE)
{
    $thousands_separator = true;

    //ignore empty strings and return
    if(empty($number))
    {
        return $number;
    }

    if($decimals == NULL)
    {
        $decimals = 0;
    }


    $fmt = new NumberFormatter($locale, NumberFormatter::DECIMAL);

    $fmt->setAttribute(NumberFormatter::FRACTION_DIGITS, intval($decimals));

    if(!$thousands_separator)
    {
        //remove thousand separator
        //$fmt->setAttribute(NumberFormatter::GROUPING_SEPARATOR_SYMBOL, '');
    }

    try
    {
        //return $fmt->parse($number);
        return $fmt->format($number);

    }
    catch(Exception $e)
    {
        return FALSE;
    }
}